/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.query.dao;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.Attributes;
import akka.stream.scaladsl.Source;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.config.JournalColumnsDefConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.QueryPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.JournalRow;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.query.dao.QueryProcessor;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.Select;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\b\u0011\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\"B-\u0001\t\u0003Q\u0006bB1\u0001\u0005\u0004%\tA\u0019\u0005\u0007M\u0002\u0001\u000b\u0011B2\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1\u0011\u000f\u0001Q\u0001\n%DQA\u001d\u0001\u0005BMDq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002N\u0001!\t%a\u0014\t\u000f\u0005e\u0003\u0001\"\u0005\u0002\\\t\u0001bKM)vKJL\bK]8dKN\u001cxN\u001d\u0006\u0003#I\t1\u0001Z1p\u0015\t\u0019B#A\u0003rk\u0016\u0014\u0018P\u0003\u0002\u0016-\u0005AA-\u001f8b[>$'M\u0003\u0002\u00181\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\tI\"$\u0001\u0003bW.\f'BA\u000e\u001d\u0003\u0019QW'[63_*\u0011QDH\u0001\u0007O&$\b.\u001e2\u000b\u0003}\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011FK\u0007\u0002!%\u00111\u0006\u0005\u0002\u000f#V,'/\u001f)s_\u000e,7o]8s\u0003\u0019\u0019\u0018p\u001d;f[B\u0011aFM\u0007\u0002_)\u0011\u0001'M\u0001\u0006C\u000e$xN\u001d\u0006\u00023%\u00111g\f\u0002\f\u0003\u000e$xN]*zgR,W.A\u0006bgft7m\u00117jK:$\bcA\u00127q%\u0011q\u0007\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005e\u001aU\"\u0001\u001e\u000b\u0005UY$B\u0001\u001f>\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001 @\u0003\u0019\two]:eW*\u0011\u0001)Q\u0001\u0007C6\f'p\u001c8\u000b\u0003\t\u000b\u0001b]8gi^\f'/Z\u0005\u0003\tj\u00121\u0003R=oC6|GIY!ts:\u001c7\t\\5f]R\f!b]=oG\u000ec\u0017.\u001a8u!\r\u0019cg\u0012\t\u0003s!K!!\u0013\u001e\u0003\u001d\u0011Kh.Y7p\t\n\u001cE.[3oi\u0006a\u0001\u000f\\;hS:\u001cuN\u001c4jOB\u0011AjT\u0007\u0002\u001b*\u0011a\nF\u0001\u0007G>tg-[4\n\u0005Ak%!E)vKJL\b\u000b\\;hS:\u001cuN\u001c4jO\u0006yQ.\u001a;sS\u000e\u001c(+\u001a9peR,'\u000fE\u0002$mM\u0003\"\u0001V,\u000e\u0003US!A\u0016\u000b\u0002\u000f5,GO]5dg&\u0011\u0001,\u0016\u0002\u0010\u001b\u0016$(/[2t%\u0016\u0004xN\u001d;fe\u00061A(\u001b8jiz\"ba\u0017/^=~\u0003\u0007CA\u0015\u0001\u0011\u0015ac\u00011\u0001.\u0011\u0015!d\u00011\u00016\u0011\u0015)e\u00011\u0001G\u0011\u0015Qe\u00011\u0001L\u0011\u0015\tf\u00011\u0001S\u0003A\u0019w\u000e\\;n]N$UMZ\"p]\u001aLw-F\u0001d!\taE-\u0003\u0002f\u001b\n9\"j\\;s]\u0006d7i\u001c7v[:\u001cH)\u001a4D_:4\u0017nZ\u0001\u0012G>dW/\u001c8t\t\u001647i\u001c8gS\u001e\u0004\u0013\u0001D:ue\u0016\fWn\u00117jK:$X#A5\u0011\u0005)|W\"A6\u000b\u00051l\u0017A\u0001<3\u0015\tqG#\u0001\u0004dY&,g\u000e^\u0005\u0003a.\u0014\u0001c\u0015;sK\u0006l'+Z1e\u00072LWM\u001c;\u0002\u001bM$(/Z1n\u00072LWM\u001c;!\u0003E\tG\u000e\u001c)feNL7\u000f^3oG\u0016LEm\u001d\u000b\u0004i\u00065\u0001#B;{y\u0006\u0015Q\"\u0001<\u000b\u0005]D\u0018\u0001C:dC2\fGm\u001d7\u000b\u0005e\f\u0014AB:ue\u0016\fW.\u0003\u0002|m\n11k\\;sG\u0016\u00042!`A\u0001\u001b\u0005q(BA@\u0015\u0003\u0015iw\u000eZ3m\u0013\r\t\u0019A \u0002\u000e!\u0016\u00148/[:uK:\u001cW-\u00133\u0011\t\u0005\u001d\u0011\u0011B\u0007\u0002c%\u0019\u00111B\u0019\u0003\u000f9{G/V:fI\"9\u0011qB\u0006A\u0002\u0005E\u0011aA7bqB\u00191%a\u0005\n\u0007\u0005UAE\u0001\u0003M_:<\u0017aF3wK:$8OQ=UC\u001e\f5OS8ve:\fGNU8x))\tY\"!\u000b\u0002D\u0005\u001d\u00131\n\t\u0007kj\fi\"!\u0002\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t\u0015\u0003\u001dQw.\u001e:oC2LA!a\n\u0002\"\tQ!j\\;s]\u0006d'k\\<\t\u000f\u0005-B\u00021\u0001\u0002.\u0005\u0019A/Y4\u0011\t\u0005=\u0012Q\b\b\u0005\u0003c\tI\u0004E\u0002\u00024\u0011j!!!\u000e\u000b\u0007\u0005]\u0002%\u0001\u0004=e>|GOP\u0005\u0004\u0003w!\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002@\u0005\u0005#AB*ue&twMC\u0002\u0002<\u0011Bq!!\u0012\r\u0001\u0004\t\t\"\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003\u0013b\u0001\u0019AA\t\u0003%i\u0017\r_(gMN,G\u000fC\u0004\u0002\u00101\u0001\r!!\u0005\u0002\u001f)|WO\u001d8bYN+\u0017/^3oG\u0016$b!!\u0015\u0002T\u0005U\u0003CB;{\u0003#\t)\u0001C\u0004\u0002F5\u0001\r!!\u0005\t\u000f\u0005]S\u00021\u0001\u0002\u0012\u0005)A.[7ji\u0006\u00192m\u001c8wKJ$Hk\u001c&pkJt\u0017\r\u001c*poR!\u0011QDA/\u0011\u001d\tyF\u0004a\u0001\u0003C\n1!\\1q!!\ty#a\u0019\u0002.\u0005\u001d\u0014\u0002BA3\u0003\u0003\u00121!T1q!\u0011\tI'!\u001c\u000e\u0005\u0005-$BA@;\u0013\u0011\ty'a\u001b\u0003\u001d\u0005#HO]5ckR,g+\u00197vK\u0002")
public class V2QueryProcessor
implements QueryProcessor {
    private final QueryPluginConfig pluginConfig;
    private final JournalColumnsDefConfig columnsDefConfig;
    private final StreamReadClient streamClient;
    private final Source<Object, NotUsed> startTimeSource;
    private final Attributes logLevels;

    @Override
    public Source<Object, NotUsed> startTimeSource() {
        return this.startTimeSource;
    }

    @Override
    public Attributes logLevels() {
        return this.logLevels;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$query$dao$QueryProcessor$_setter_$startTimeSource_$eq(Source<Object, NotUsed> x$1) {
        this.startTimeSource = x$1;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$query$dao$QueryProcessor$_setter_$logLevels_$eq(Attributes x$1) {
        this.logLevels = x$1;
    }

    public JournalColumnsDefConfig columnsDefConfig() {
        return this.columnsDefConfig;
    }

    private StreamReadClient streamClient() {
        return this.streamClient;
    }

    @Override
    public Source<PersistenceId, NotUsed> allPersistenceIds(long max) {
        ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.pluginConfig.tableName()).select(Select.SPECIFIC_ATTRIBUTES).attributesToGet(new String[]{this.columnsDefConfig().deletedColumnName(), this.columnsDefConfig().persistenceIdColumnName()}).limit(Predef$.MODULE$.int2Integer(this.pluginConfig.scanBatchSize())).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return ((Source)this.streamClient().recursiveScanSource(scanRequest, (Option)new Some((Object)BoxesRunTime.boxToLong((long)max))).mapConcat((Function1 & Serializable & scala.Serializable)result -> (Vector)Option$.MODULE$.apply((Object)result.items()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toVector()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Vector)x$2.map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$3).asScala()).toMap(Predef$.MODULE$.$conforms()), Vector$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(((AttributeValue)x$4.apply((Object)this.columnsDefConfig().deletedColumnName())).bool()))).map((Function1 & Serializable & scala.Serializable)x$5 -> ((AttributeValue)x$5.apply((Object)this.columnsDefConfig().persistenceIdColumnName())).s()).fold((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> (Set)x$6.$plus(x$7)).mapConcat((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toVector()).map((Function1 & Serializable & scala.Serializable)value -> PersistenceId$.MODULE$.apply(value)).take(max)).withAttributes(this.logLevels());
    }

    @Override
    public Source<JournalRow, NotUsed> eventsByTagAsJournalRow(String tag, long offset, long maxOffset, long max) {
        ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.pluginConfig.tableName()).indexName(this.pluginConfig.tagsIndexName()).filterExpression("contains(#tags, :tag)").expressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#tags"), (Object)this.columnsDefConfig().tagsColumnName())}))).asJava()).expressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":tag"), AttributeValue.builder().s(tag).build())}))).asJava()).limit(Predef$.MODULE$.int2Integer(this.pluginConfig.scanBatchSize())).build();
        return ((Source)this.streamClient().recursiveScanSource(scanRequest, (Option)new Some((Object)BoxesRunTime.boxToLong((long)max))).mapConcat((Function1 & Serializable & scala.Serializable)result -> (Vector)Option$.MODULE$.apply((Object)result.items()).map((Function1 & Serializable & scala.Serializable)x$9 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$9).asScala()).toVector()).map((Function1 & Serializable & scala.Serializable)x$10 -> (Vector)x$10.map((Function1 & Serializable & scala.Serializable)x$11 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$11).asScala()).toMap(Predef$.MODULE$.$conforms()), Vector$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)map -> this.convertToJournalRow((scala.collection.immutable.Map<String, AttributeValue>)map)).fold((Object)ArrayBuffer$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x$12, x$13) -> x$12.$plus$eq(x$13)).map((Function1 & Serializable & scala.Serializable)x$14 -> (ArrayBuffer)x$14.sortBy((Function1 & Serializable & scala.Serializable)journalRow -> new Tuple2((Object)journalRow.persistenceId().asString(), (Object)BoxesRunTime.boxToLong((long)journalRow.sequenceNumber().value())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).mapConcat((Function1 & Serializable & scala.Serializable)x$15 -> x$15.toVector()).statefulMapConcat((Function0 & Serializable & scala.Serializable)() -> {
            AtomicLong index = new AtomicLong();
            return (Function1 & Serializable & scala.Serializable)journalRow -> new .colon.colon((Object)journalRow.withOrdering(index.incrementAndGet()), (List)Nil$.MODULE$);
        }).filter((Function1 & Serializable & scala.Serializable)journalRow -> BoxesRunTime.boxToBoolean((boolean)V2QueryProcessor.$anonfun$eventsByTagAsJournalRow$13(offset, maxOffset, journalRow))).take(max)).withAttributes(this.logLevels());
    }

    @Override
    public Source<Object, NotUsed> journalSequence(long offset, long limit) {
        ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(this.pluginConfig.tableName()).select(Select.SPECIFIC_ATTRIBUTES).attributesToGet(new String[]{this.columnsDefConfig().orderingColumnName()}).limit(Predef$.MODULE$.int2Integer(this.pluginConfig.scanBatchSize())).consistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig.consistentRead())).build();
        return (Source)this.streamClient().recursiveScanSource(scanRequest, (Option)new Some((Object)BoxesRunTime.boxToLong((long)limit))).mapConcat((Function1 & Serializable & scala.Serializable)result -> (Vector)Option$.MODULE$.apply((Object)result.items()).map((Function1 & Serializable & scala.Serializable)x$16 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$16).asScala()).toVector()).map((Function1 & Serializable & scala.Serializable)x$17 -> (Vector)x$17.map((Function1 & Serializable & scala.Serializable)x$18 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$18).asScala()).toMap(Predef$.MODULE$.$conforms()), Vector$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToLong((long)V2QueryProcessor.$anonfun$journalSequence$6(this, result))).drop(offset).take(limit);
    }

    public JournalRow convertToJournalRow(scala.collection.immutable.Map<String, AttributeValue> map) {
        return new JournalRow(PersistenceId$.MODULE$.apply(((AttributeValue)map.apply((Object)this.columnsDefConfig().persistenceIdColumnName())).s()), new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)map.apply((Object)this.columnsDefConfig().sequenceNrColumnName())).n())).toLong()), Predef$.MODULE$.Boolean2boolean(((AttributeValue)map.apply((Object)this.columnsDefConfig().deletedColumnName())).bool()), (byte[])map.get((Object)this.columnsDefConfig().messageColumnName()).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.b().asByteArray()).get(), new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)map.apply((Object)this.columnsDefConfig().orderingColumnName())).n())).toLong(), map.get((Object)this.columnsDefConfig().tagsColumnName()).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.s()));
    }

    public static final /* synthetic */ boolean $anonfun$eventsByTagAsJournalRow$13(long offset$1, long maxOffset$1, JournalRow journalRow) {
        return journalRow.ordering() > offset$1 && journalRow.ordering() <= maxOffset$1;
    }

    public static final /* synthetic */ long $anonfun$journalSequence$6(V2QueryProcessor $this, scala.collection.immutable.Map result) {
        return new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)result.apply((Object)$this.columnsDefConfig().orderingColumnName())).n())).toLong();
    }

    public V2QueryProcessor(ActorSystem system, Option<DynamoDbAsyncClient> asyncClient, Option<DynamoDbClient> syncClient, QueryPluginConfig pluginConfig, Option<MetricsReporter> metricsReporter) {
        this.pluginConfig = pluginConfig;
        QueryProcessor.$init$(this);
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.columnsDefConfig = pluginConfig.columnsDefConfig();
        this.streamClient = new StreamReadClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.readBackoffConfig());
    }
}

