/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.query.dao;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.Attributes;
import akka.stream.scaladsl.Source;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.Select;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamReadClient;
import com.github.j5ik2o.akka.persistence.dynamodb.config.JournalColumnsDefConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.QueryPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.JournalRow;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.query.dao.QueryProcessor;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001\u0002\u000b\u0016\u0001\u0019B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\ts\u0001\u0011)\u0019!C\u0001u!A\u0001\n\u0001B\u0001B\u0003%1\b\u0003\u0005J\u0001\t\u0015\r\u0011\"\u0001K\u0011!y\u0005A!A!\u0002\u0013Y\u0005\u0002\u0003)\u0001\u0005\u000b\u0007I\u0011A)\t\u0011a\u0003!\u0011!Q\u0001\nIC\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u0017\u0005\tE\u0002\u0011\t\u0011)A\u00057\"A1\r\u0001B\u0001B\u0003-A\rC\u0003k\u0001\u0011\u00051\u000eC\u0004u\u0001\t\u0007I\u0011B;\t\re\u0004\u0001\u0015!\u0003w\u0011\u001dQ\bA1A\u0005\nmDq!!\u0003\u0001A\u0003%A\u0010C\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u00111\u000f\u0001\u0005B\u0005U\u0004bBA@\u0001\u0011E\u0011\u0011\u0011\u0002\u0011-F\nV/\u001a:z!J|7-Z:t_JT!AF\f\u0002\u0007\u0011\fwN\u0003\u0002\u00193\u0005)\u0011/^3ss*\u0011!dG\u0001\tIft\u0017-\\8eE*\u0011A$H\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u001f?\u0005!\u0011m[6b\u0015\t\u0001\u0013%\u0001\u0004kk%\\'g\u001c\u0006\u0003E\r\naaZ5uQV\u0014'\"\u0001\u0013\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00019S\u0006\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003]=j\u0011!F\u0005\u0003aU\u0011a\"U;fef\u0004&o\\2fgN|'/\u0001\u0004tsN$X-\u001c\t\u0003g]j\u0011\u0001\u000e\u0006\u0003kY\nQ!Y2u_JT\u0011AH\u0005\u0003qQ\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u0006Y\u0011m]=oG\u000ec\u0017.\u001a8u+\u0005Y\u0004c\u0001\u0015=}%\u0011Q(\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005}2U\"\u0001!\u000b\u0005\u0005\u0013\u0015A\u00033z]\u0006lw\u000e\u001a2we)\u00111\tR\u0001\tg\u0016\u0014h/[2fg*\u0011QiI\u0001\nC6\f'p\u001c8boNL!a\u0012!\u0003'\u0005k\u0017M_8o\tft\u0017-\\8E\u0005\u0006\u001b\u0018P\\2\u0002\u0019\u0005\u001c\u0018P\\2DY&,g\u000e\u001e\u0011\u0002\u0015MLhnY\"mS\u0016tG/F\u0001L!\rAC\b\u0014\t\u0003\u007f5K!A\u0014!\u0003\u001d\u0005k\u0017M_8o\tft\u0017-\\8E\u0005\u0006Y1/\u001f8d\u00072LWM\u001c;!\u00031\u0001H.^4j]\u000e{gNZ5h+\u0005\u0011\u0006CA*W\u001b\u0005!&BA+\u001a\u0003\u0019\u0019wN\u001c4jO&\u0011q\u000b\u0016\u0002\u0012#V,'/\u001f)mk\u001eLgnQ8oM&<\u0017!\u00049mk\u001eLgnQ8oM&<\u0007%A\bnKR\u0014\u0018nY:SKB|'\u000f^3s+\u0005Y\u0006c\u0001\u0015=9B\u0011Q\fY\u0007\u0002=*\u0011q,G\u0001\b[\u0016$(/[2t\u0013\t\tgLA\bNKR\u0014\u0018nY:SKB|'\u000f^3s\u0003AiW\r\u001e:jGN\u0014V\r]8si\u0016\u0014\b%\u0001\u0002fGB\u0011Q\r[\u0007\u0002M*\u0011q-K\u0001\u000bG>t7-\u001e:sK:$\u0018BA5g\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0007Y>\u0004\u0018O]:\u0015\u00055t\u0007C\u0001\u0018\u0001\u0011\u0015\u00197\u0002q\u0001e\u0011\u0015\t4\u00021\u00013\u0011\u0015I4\u00021\u0001<\u0011\u0015I5\u00021\u0001L\u0011\u0015\u00016\u00021\u0001S\u0011\u0015I6\u00021\u0001\\\u0003A\u0019w\u000e\\;n]N$UMZ\"p]\u001aLw-F\u0001w!\t\u0019v/\u0003\u0002y)\n9\"j\\;s]\u0006d7i\u001c7v[:\u001cH)\u001a4D_:4\u0017nZ\u0001\u0012G>dW/\u001c8t\t\u001647i\u001c8gS\u001e\u0004\u0013\u0001D:ue\u0016\fWn\u00117jK:$X#\u0001?\u0011\u0007u\f)!D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\u0003mFR1!a\u0001\u001a\u0003\u0019\u0019G.[3oi&\u0019\u0011q\u0001@\u0003!M#(/Z1n%\u0016\fGm\u00117jK:$\u0018!D:ue\u0016\fWn\u00117jK:$\b%A\tbY2\u0004VM]:jgR,gnY3JIN$B!a\u0004\u00024AA\u0011\u0011CA\u000e\u0003?\tY#\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003!\u00198-\u00197bINd'bAA\rm\u000511\u000f\u001e:fC6LA!!\b\u0002\u0014\t11k\\;sG\u0016\u0004B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003KI\u0012!B7pI\u0016d\u0017\u0002BA\u0015\u0003G\u0011Q\u0002U3sg&\u001cH/\u001a8dK&#\u0007\u0003BA\u0017\u0003_i\u0011AN\u0005\u0004\u0003c1$a\u0002(piV\u001bX\r\u001a\u0005\b\u0003k\u0001\u0002\u0019AA\u001c\u0003\ri\u0017\r\u001f\t\u0004Q\u0005e\u0012bAA\u001eS\t!Aj\u001c8h\u0003])g/\u001a8ug\nKH+Y4Bg*{WO\u001d8bYJ{w\u000f\u0006\u0006\u0002B\u0005=\u0013\u0011NA7\u0003c\u0002\u0002\"!\u0005\u0002\u001c\u0005\r\u00131\u0006\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011J\r\u0002\u000f)|WO\u001d8bY&!\u0011QJA$\u0005)Qu.\u001e:oC2\u0014vn\u001e\u0005\b\u0003#\n\u0002\u0019AA*\u0003\r!\u0018m\u001a\t\u0005\u0003+\n\u0019G\u0004\u0003\u0002X\u0005}\u0003cAA-S5\u0011\u00111\f\u0006\u0004\u0003;*\u0013A\u0002\u001fs_>$h(C\u0002\u0002b%\na\u0001\u0015:fI\u00164\u0017\u0002BA3\u0003O\u0012aa\u0015;sS:<'bAA1S!9\u00111N\tA\u0002\u0005]\u0012AB8gMN,G\u000fC\u0004\u0002pE\u0001\r!a\u000e\u0002\u00135\f\u0007p\u00144gg\u0016$\bbBA\u001b#\u0001\u0007\u0011qG\u0001\u0010U>,(O\\1m'\u0016\fX/\u001a8dKR1\u0011qOA=\u0003w\u0002\u0002\"!\u0005\u0002\u001c\u0005]\u00121\u0006\u0005\b\u0003W\u0012\u0002\u0019AA\u001c\u0011\u001d\tiH\u0005a\u0001\u0003o\tQ\u0001\\5nSR\f1cY8om\u0016\u0014H\u000fV8K_V\u0014h.\u00197S_^$B!a\u0011\u0002\u0004\"9\u0011QQ\nA\u0002\u0005\u001d\u0015aA7baBA\u0011QKAE\u0003'\ni)\u0003\u0003\u0002\f\u0006\u001d$aA'baB!\u0011qRAJ\u001b\t\t\tJC\u0002\u0002&\u0001KA!!&\u0002\u0012\nq\u0011\t\u001e;sS\n,H/\u001a,bYV,\u0007")
public class V1QueryProcessor
implements QueryProcessor {
    private final Option<AmazonDynamoDBAsync> asyncClient;
    private final Option<AmazonDynamoDB> syncClient;
    private final QueryPluginConfig pluginConfig;
    private final Option<MetricsReporter> metricsReporter;
    private final JournalColumnsDefConfig columnsDefConfig;
    private final StreamReadClient streamClient;
    private final Source<Object, NotUsed> startTimeSource;
    private final Attributes logLevels;

    @Override
    public Source<Object, NotUsed> startTimeSource() {
        return this.startTimeSource;
    }

    @Override
    public Attributes logLevels() {
        return this.logLevels;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$query$dao$QueryProcessor$_setter_$startTimeSource_$eq(Source<Object, NotUsed> x$1) {
        this.startTimeSource = x$1;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$query$dao$QueryProcessor$_setter_$logLevels_$eq(Attributes x$1) {
        this.logLevels = x$1;
    }

    public Option<AmazonDynamoDBAsync> asyncClient() {
        return this.asyncClient;
    }

    public Option<AmazonDynamoDB> syncClient() {
        return this.syncClient;
    }

    public QueryPluginConfig pluginConfig() {
        return this.pluginConfig;
    }

    public Option<MetricsReporter> metricsReporter() {
        return this.metricsReporter;
    }

    private JournalColumnsDefConfig columnsDefConfig() {
        return this.columnsDefConfig;
    }

    private StreamReadClient streamClient() {
        return this.streamClient;
    }

    @Override
    public Source<PersistenceId, NotUsed> allPersistenceIds(long max) {
        ScanRequest scanRequest = new ScanRequest().withTableName(this.pluginConfig().tableName()).withSelect(Select.SPECIFIC_ATTRIBUTES).withAttributesToGet(new String[]{this.columnsDefConfig().deletedColumnName(), this.columnsDefConfig().persistenceIdColumnName()}).withLimit(Predef$.MODULE$.int2Integer(this.pluginConfig().scanBatchSize())).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig().consistentRead()));
        return ((Source)this.streamClient().recursiveScanSource(scanRequest, (Option)new Some((Object)BoxesRunTime.boxToLong((long)max))).mapConcat((Function1 & Serializable & scala.Serializable)result -> (Vector)Option$.MODULE$.apply((Object)result.getItems()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toVector()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Vector)x$2.map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$3).asScala()).toMap(Predef$.MODULE$.$conforms()), Vector$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(((AttributeValue)x$4.apply((Object)this.columnsDefConfig().deletedColumnName())).getBOOL()))).map((Function1 & Serializable & scala.Serializable)x$5 -> ((AttributeValue)x$5.apply((Object)this.columnsDefConfig().persistenceIdColumnName())).getS()).fold((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> (Set)x$6.$plus(x$7)).mapConcat((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toVector()).map((Function1 & Serializable & scala.Serializable)value -> PersistenceId$.MODULE$.apply(value)).take(max)).withAttributes(this.logLevels());
    }

    @Override
    public Source<JournalRow, NotUsed> eventsByTagAsJournalRow(String tag, long offset, long maxOffset, long max) {
        ScanRequest scanRequest = new ScanRequest().withTableName(this.pluginConfig().tableName()).withIndexName(this.pluginConfig().tagsIndexName()).withFilterExpression("contains(#tags, :tag)").withExpressionAttributeNames((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"#tags"), (Object)this.columnsDefConfig().tagsColumnName())}))).asJava()).withExpressionAttributeValues((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)":tag"), (Object)new AttributeValue().withS(tag))}))).asJava()).withLimit(Predef$.MODULE$.int2Integer(this.pluginConfig().scanBatchSize()));
        return ((Source)this.streamClient().recursiveScanSource(scanRequest, (Option)new Some((Object)BoxesRunTime.boxToLong((long)max))).mapConcat((Function1 & Serializable & scala.Serializable)result -> (Vector)Option$.MODULE$.apply((Object)result.getItems()).map((Function1 & Serializable & scala.Serializable)x$9 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$9).asScala()).toVector()).map((Function1 & Serializable & scala.Serializable)x$10 -> (Vector)x$10.map((Function1 & Serializable & scala.Serializable)x$11 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$11).asScala()).toMap(Predef$.MODULE$.$conforms()), Vector$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)map -> this.convertToJournalRow((scala.collection.immutable.Map<String, AttributeValue>)map)).fold((Object)ArrayBuffer$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x$12, x$13) -> x$12.$plus$eq(x$13)).map((Function1 & Serializable & scala.Serializable)x$14 -> (ArrayBuffer)x$14.sortBy((Function1 & Serializable & scala.Serializable)journalRow -> new Tuple2((Object)journalRow.persistenceId().asString(), (Object)BoxesRunTime.boxToLong((long)journalRow.sequenceNumber().value())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).mapConcat((Function1 & Serializable & scala.Serializable)x$15 -> x$15.toVector()).statefulMapConcat((Function0 & Serializable & scala.Serializable)() -> {
            AtomicLong index = new AtomicLong();
            return (Function1 & Serializable & scala.Serializable)journalRow -> new .colon.colon((Object)journalRow.withOrdering(index.incrementAndGet()), (List)Nil$.MODULE$);
        }).filter((Function1 & Serializable & scala.Serializable)journalRow -> BoxesRunTime.boxToBoolean((boolean)V1QueryProcessor.$anonfun$eventsByTagAsJournalRow$13(offset, maxOffset, journalRow))).take(max)).withAttributes(this.logLevels());
    }

    @Override
    public Source<Object, NotUsed> journalSequence(long offset, long limit) {
        ScanRequest scanRequest = new ScanRequest().withTableName(this.pluginConfig().tableName()).withSelect(Select.SPECIFIC_ATTRIBUTES).withAttributesToGet(new String[]{this.columnsDefConfig().orderingColumnName()}).withLimit(Predef$.MODULE$.int2Integer(this.pluginConfig().scanBatchSize())).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.pluginConfig().consistentRead()));
        return (Source)this.streamClient().recursiveScanSource(scanRequest, (Option)None$.MODULE$).mapConcat((Function1 & Serializable & scala.Serializable)result -> (Vector)Option$.MODULE$.apply((Object)result.getItems()).map((Function1 & Serializable & scala.Serializable)x$16 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$16).asScala()).toVector()).map((Function1 & Serializable & scala.Serializable)x$17 -> (Vector)x$17.map((Function1 & Serializable & scala.Serializable)x$18 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$18).asScala()).toMap(Predef$.MODULE$.$conforms()), Vector$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Vector().empty())).map((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToLong((long)V1QueryProcessor.$anonfun$journalSequence$6(this, result))).drop(offset).take(limit);
    }

    public JournalRow convertToJournalRow(scala.collection.immutable.Map<String, AttributeValue> map) {
        return new JournalRow(PersistenceId$.MODULE$.apply(((AttributeValue)map.apply((Object)this.columnsDefConfig().persistenceIdColumnName())).getS()), new SequenceNumber(new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)map.apply((Object)this.columnsDefConfig().sequenceNrColumnName())).getN())).toLong()), Predef$.MODULE$.Boolean2boolean(((AttributeValue)map.apply((Object)this.columnsDefConfig().deletedColumnName())).getBOOL()), (byte[])map.get((Object)this.columnsDefConfig().messageColumnName()).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.getB().array()).get(), new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)map.apply((Object)this.columnsDefConfig().orderingColumnName())).getN())).toLong(), map.get((Object)this.columnsDefConfig().tagsColumnName()).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.getS()));
    }

    public static final /* synthetic */ boolean $anonfun$eventsByTagAsJournalRow$13(long offset$1, long maxOffset$1, JournalRow journalRow) {
        return journalRow.ordering() > offset$1 && journalRow.ordering() <= maxOffset$1;
    }

    public static final /* synthetic */ long $anonfun$journalSequence$6(V1QueryProcessor $this, scala.collection.immutable.Map result) {
        return new StringOps(Predef$.MODULE$.augmentString(((AttributeValue)result.apply((Object)$this.columnsDefConfig().orderingColumnName())).getN())).toLong();
    }

    public V1QueryProcessor(ActorSystem system, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient, QueryPluginConfig pluginConfig, Option<MetricsReporter> metricsReporter, ExecutionContext ec) {
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        this.pluginConfig = pluginConfig;
        this.metricsReporter = metricsReporter;
        QueryProcessor.$init$(this);
        this.columnsDefConfig = pluginConfig.columnsDefConfig();
        this.streamClient = new StreamReadClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.readBackoffConfig());
    }
}

