/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.v2;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.Attributes;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.config.JournalPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.JournalRow;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.PartitionKeyResolver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.SortKeyResolver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowWriteDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.PersistenceIdWithSeqNr;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.v2.V2JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001B\u0010!\u0005MB\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0001\"A\u0001\n\u0001BC\u0002\u0013\u0005\u0011\n\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003K\u0011!Y\u0006A!b\u0001\n\u0003a\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\t\u0004!Q1A\u0005\u0002\rD\u0001B\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tW\u0002\u0011)\u0019!C\u0001Y\"A\u0011\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005s\u0001\t\u0015\r\u0011\"\u0001t\u0011!9\bA!A!\u0002\u0013!\b\u0002\u0003=\u0001\u0005\u000b\u0007I\u0011A=\t\u0013\u0005\r\u0001A!A!\u0002\u0013Q\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\n\u00037\u0001!\u0019!C\u0005\u0003;A\u0001\"a\f\u0001A\u0003%\u0011q\u0004\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003gA\u0001\"a\u0011\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003\u000b\u0002!\u0019!C\u0005\u0003\u000fB\u0001\"a\u0014\u0001A\u0003%\u0011\u0011\n\u0005\b\u0003#\u0002A\u0011IA*\u0011%\t9\u000bAI\u0001\n\u0003\tI\u000bC\u0004\u0002R\u0001!\t%a0\t\u000f\u0005\u0005\b\u0001\"\u0011\u0002d\"9\u0011q\u001e\u0001\u0005B\u0005E\bbBA\u0000\u0001\u0011\u0005#\u0011\u0001\u0005\b\u0005\u001f\u0001A\u0011\tB\t\u0011\u001d\u0011)\u0002\u0001C!\u0005/AqA!\b\u0001\t\u0003\u0012yBA\fWe){WO\u001d8bYJ{wo\u0016:ji\u0016$%/\u001b<fe*\u0011\u0011EI\u0001\u0003mJR!a\t\u0013\u0002\u0007\u0011\fwN\u0003\u0002&M\u00059!n\\;s]\u0006d'BA\u0014)\u0003!!\u0017P\\1n_\u0012\u0014'BA\u0015+\u0003-\u0001XM]:jgR,gnY3\u000b\u0005-b\u0013\u0001B1lW\u0006T!!\f\u0018\u0002\r),\u0014n\u001b\u001ap\u0015\ty\u0003'\u0001\u0004hSRDWO\u0019\u0006\u0002c\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g!\tYD(D\u0001#\u0013\ti$EA\u000bK_V\u0014h.\u00197S_^<&/\u001b;f\tJLg/\u001a:\u0002\rML8\u000f^3n+\u0005\u0001\u0005CA!F\u001b\u0005\u0011%BA\"E\u0003\u0015\t7\r^8s\u0015\u0005Y\u0013B\u0001$C\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nA\u0005Y\u0011m]=oG\u000ec\u0017.\u001a8u+\u0005Q\u0005cA\u001bL\u001b&\u0011AJ\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00059CV\"A(\u000b\u0005\u001d\u0002&BA)S\u0003!\u0019XM\u001d<jG\u0016\u001c(BA*U\u0003\u0019\two]:eW*\u0011QKV\u0001\u0007C6\f'p\u001c8\u000b\u0003]\u000b\u0001b]8gi^\f'/Z\u0005\u00033>\u00131\u0003R=oC6|GIY!ts:\u001c7\t\\5f]R\fA\"Y:z]\u000e\u001cE.[3oi\u0002\n!b]=oG\u000ec\u0017.\u001a8u+\u0005i\u0006cA\u001bL=B\u0011ajX\u0005\u0003A>\u0013a\u0002R=oC6|GIY\"mS\u0016tG/A\u0006ts:\u001c7\t\\5f]R\u0004\u0013\u0001\u00049mk\u001eLgnQ8oM&<W#\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d4\u0013AB2p]\u001aLw-\u0003\u0002jM\n\u0019\"j\\;s]\u0006d\u0007\u000b\\;hS:\u001cuN\u001c4jO\u0006i\u0001\u000f\\;hS:\u001cuN\u001c4jO\u0002\nA\u0003]1si&$\u0018n\u001c8LKf\u0014Vm]8mm\u0016\u0014X#A7\u0011\u00059|W\"\u0001\u0013\n\u0005A$#\u0001\u0006)beRLG/[8o\u0017\u0016L(+Z:pYZ,'/A\u000bqCJ$\u0018\u000e^5p].+\u0017PU3t_24XM\u001d\u0011\u0002\u001fM|'\u000f^&fsJ+7o\u001c7wKJ,\u0012\u0001\u001e\t\u0003]VL!A\u001e\u0013\u0003\u001fM{'\u000f^&fsJ+7o\u001c7wKJ\f\u0001c]8si.+\u0017PU3t_24XM\u001d\u0011\u0002\u001f5,GO]5dgJ+\u0007o\u001c:uKJ,\u0012A\u001f\t\u0004k-[\bC\u0001?\u0000\u001b\u0005i(B\u0001@'\u0003\u001diW\r\u001e:jGNL1!!\u0001~\u0005=iU\r\u001e:jGN\u0014V\r]8si\u0016\u0014\u0018\u0001E7fiJL7m\u001d*fa>\u0014H/\u001a:!\u0003\u0019a\u0014N\\5u}Q\u0001\u0012\u0011BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011\u0004\t\u0004\u0003\u0017\u0001Q\"\u0001\u0011\t\u000byz\u0001\u0019\u0001!\t\u000b!{\u0001\u0019\u0001&\t\u000bm{\u0001\u0019A/\t\u000b\t|\u0001\u0019\u00013\t\u000b-|\u0001\u0019A7\t\u000bI|\u0001\u0019\u0001;\t\u000ba|\u0001\u0019\u0001>\u0002\r1|wmZ3s+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u000bMdg\r\u000e6\u000b\u0005\u0005%\u0012aA8sO&!\u0011QFA\u0012\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001D:ue\u0016\fWn\u00117jK:$XCAA\u001b!\u0011\t9$a\u0010\u000e\u0005\u0005e\"bA\u0011\u0002<)\u0019\u0011Q\b\u0014\u0002\r\rd\u0017.\u001a8u\u0013\u0011\t\t%!\u000f\u0003#M#(/Z1n/JLG/Z\"mS\u0016tG/A\u0007tiJ,\u0017-\\\"mS\u0016tG\u000fI\u0001\u000be\u0016\fG\r\u0012:jm\u0016\u0014XCAA%!\u0011\tY!a\u0013\n\u0007\u00055\u0003E\u0001\fWe){WO\u001d8bYJ{wOU3bI\u0012\u0013\u0018N^3s\u0003-\u0011X-\u00193Ee&4XM\u001d\u0011\u0002\u001d\u001d,GOS8ve:\fGNU8xgRa\u0011QKA:\u0003\u0007\u000bi)!%\u0002\u001cBA\u0011qKA1\u0003K\nY'\u0004\u0002\u0002Z)!\u00111LA/\u0003!\u00198-\u00197bINd'bAA0\t\u000611\u000f\u001e:fC6LA!a\u0019\u0002Z\t11k\\;sG\u0016\u00042A\\A4\u0013\r\tI\u0007\n\u0002\u000b\u0015>,(O\\1m%><\b\u0003BA7\u0003_j\u0011\u0001R\u0005\u0004\u0003c\"%a\u0002(piV\u001bX\r\u001a\u0005\b\u0003k2\u0002\u0019AA<\u00035\u0001XM]:jgR,gnY3JIB!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~\u0019\nQ!\\8eK2LA!!!\u0002|\ti\u0001+\u001a:tSN$XM\\2f\u0013\u0012Dq!!\"\u0017\u0001\u0004\t9)\u0001\bge>l7+Z9vK:\u001cWM\u0014:\u0011\t\u0005e\u0014\u0011R\u0005\u0005\u0003\u0017\u000bYH\u0001\bTKF,XM\\2f\u001dVl'-\u001a:\t\u000f\u0005=e\u00031\u0001\u0002\b\u0006aAo\\*fcV,gnY3Oe\"9\u00111\u0013\fA\u0002\u0005U\u0015aA7bqB\u0019Q'a&\n\u0007\u0005eeG\u0001\u0003M_:<\u0007\"CAO-A\u0005\t\u0019AAP\u0003\u001d!W\r\\3uK\u0012\u0004B!N&\u0002\"B\u0019Q'a)\n\u0007\u0005\u0015fGA\u0004C_>dW-\u00198\u00021\u001d,GOS8ve:\fGNU8xg\u0012\"WMZ1vYR$S'\u0006\u0002\u0002,*\"\u0011qTAWW\t\ty\u000b\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\u0013Ut7\r[3dW\u0016$'bAA]m\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00161\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G\u0003CAa\u00037\fi.a8\u0011\u0011\u0005]\u0013\u0011MAb\u0003W\u0002b!!2\u0002V\u0006\u0015d\u0002BAd\u0003#tA!!3\u0002P6\u0011\u00111\u001a\u0006\u0004\u0003\u001b\u0014\u0014A\u0002\u001fs_>$h(C\u00018\u0013\r\t\u0019NN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9.!7\u0003\u0007M+\u0017OC\u0002\u0002TZBq!!\u001e\u0019\u0001\u0004\t9\bC\u0004\u0002\u0010b\u0001\r!a\"\t\u000f\u0005u\u0005\u00041\u0001\u0002\"\u0006\t\u0002.[4iKN$8+Z9vK:\u001cWM\u0014:\u0015\u0011\u0005\u0015\u0018q]Au\u0003[\u0004\u0002\"a\u0016\u0002b\u0005U\u00151\u000e\u0005\b\u0003kJ\u0002\u0019AA<\u0011%\t))\u0007I\u0001\u0002\u0004\tY\u000f\u0005\u00036\u0017\u0006\u001d\u0005\"CAO3A\u0005\t\u0019AAP\u0003i\u0019\u0018N\\4mK\u0012+G.\u001a;f\u0015>,(O\\1m%><h\t\\8x+\t\t\u0019\u0010\u0005\u0006\u0002X\u0005U\u0018\u0011`AK\u0003WJA!a>\u0002Z\t!a\t\\8x!\rY\u00141`\u0005\u0004\u0003{\u0014#A\u0006)feNL7\u000f^3oG\u0016LEmV5uQN+\u0017O\u0014:\u0002\u001bU\u0004H-\u0019;f\u001b\u0016\u001c8/Y4f)\u0011\u0011\u0019Aa\u0003\u0011\u0011\u0005]\u0013\u0011\rB\u0003\u0003W\u00022!\u000eB\u0004\u0013\r\u0011IA\u000e\u0002\u0005+:LG\u000fC\u0004\u0003\u000em\u0001\r!!\u001a\u0002\u0015)|WO\u001d8bYJ{w/A\ftS:<G.\u001a)vi*{WO\u001d8bYJ{wO\u00127poV\u0011!1\u0003\t\u000b\u0003/\n)0!\u001a\u0002\u0016\u0006-\u0014AG7vYRLG)\u001a7fi\u0016Tu.\u001e:oC2\u0014vn^:GY><XC\u0001B\r!)\t9&!>\u0003\u001c\u0005U\u00151\u000e\t\u0007\u0003\u000b\f).!?\u0002/5,H\u000e^5QkRTu.\u001e:oC2\u0014vn^:GY><XC\u0001B\u0011!)\t9&!>\u0002D\u0006U\u00151\u000e")
public final class V2JournalRowWriteDriver
implements JournalRowWriteDriver {
    private final ActorSystem system;
    private final Option<DynamoDbAsyncClient> asyncClient;
    private final Option<DynamoDbClient> syncClient;
    private final JournalPluginConfig pluginConfig;
    private final PartitionKeyResolver partitionKeyResolver;
    private final SortKeyResolver sortKeyResolver;
    private final Option<MetricsReporter> metricsReporter;
    private final Logger logger;
    private final StreamWriteClient streamClient;
    private final V2JournalRowReadDriver readDriver;
    private Attributes logLevels;

    @Override
    public Option<SequenceNumber> highestSequenceNr$default$2() {
        return JournalRowReadDriver.highestSequenceNr$default$2$(this);
    }

    @Override
    public Option<Object> highestSequenceNr$default$3() {
        return JournalRowReadDriver.highestSequenceNr$default$3$(this);
    }

    @Override
    public Attributes logLevels() {
        return this.logLevels;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$journal$dao$JournalRowDriver$_setter_$logLevels_$eq(Attributes x$1) {
        this.logLevels = x$1;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    public Option<DynamoDbAsyncClient> asyncClient() {
        return this.asyncClient;
    }

    public Option<DynamoDbClient> syncClient() {
        return this.syncClient;
    }

    public JournalPluginConfig pluginConfig() {
        return this.pluginConfig;
    }

    public PartitionKeyResolver partitionKeyResolver() {
        return this.partitionKeyResolver;
    }

    public SortKeyResolver sortKeyResolver() {
        return this.sortKeyResolver;
    }

    public Option<MetricsReporter> metricsReporter() {
        return this.metricsReporter;
    }

    private Logger logger() {
        return this.logger;
    }

    private StreamWriteClient streamClient() {
        return this.streamClient;
    }

    private V2JournalRowReadDriver readDriver() {
        return this.readDriver;
    }

    @Override
    public Source<JournalRow, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber fromSequenceNr, SequenceNumber toSequenceNr, long max, Option<Object> deleted) {
        return this.readDriver().getJournalRows(persistenceId, fromSequenceNr, toSequenceNr, max, deleted);
    }

    @Override
    public Source<scala.collection.immutable.Seq<JournalRow>, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber toSequenceNr, boolean deleted) {
        return this.readDriver().getJournalRows(persistenceId, toSequenceNr, deleted);
    }

    @Override
    public Option<Object> getJournalRows$default$5() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public Source<Object, NotUsed> highestSequenceNr(PersistenceId persistenceId, Option<SequenceNumber> fromSequenceNr, Option<Object> deleted) {
        return this.readDriver().highestSequenceNr(persistenceId, fromSequenceNr, deleted);
    }

    @Override
    public Flow<PersistenceIdWithSeqNr, Object, NotUsed> singleDeleteJournalRowFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)persistenceIdWithSeqNr -> {
            DeleteItemRequest deleteRequest = (DeleteItemRequest)DeleteItemRequest.builder().key(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(persistenceIdWithSeqNr.persistenceId().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(persistenceIdWithSeqNr.sequenceNumber().asString()).build())}))).asJava()).build();
            return (Source)Source$.MODULE$.single((Object)deleteRequest).via((Graph)this.streamClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                Source source;
                if (response.sdkHttpResponse().isSuccessful()) {
                    source = Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)1L));
                } else {
                    int statusCode = response.sdkHttpResponse().statusCode();
                    Optional statusText = response.sdkHttpResponse().statusText();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(0).append(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable)() -> "", (Function1 & Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
                }
                return source;
            });
        });
    }

    @Override
    public Source<BoxedUnit, NotUsed> updateMessage(JournalRow journalRow) {
        String pkey = journalRow.partitionKey(this.partitionKeyResolver()).asString();
        String skey = journalRow.sortKey(this.sortKeyResolver()).asString();
        UpdateItemRequest updateRequest = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.pluginConfig().tableName()).key(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().partitionKeyColumnName()), AttributeValue.builder().s(pkey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sortKeyColumnName()), AttributeValue.builder().s(skey).build())}))).asJava()).attributeUpdates(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().messageColumnName()), AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])journalRow.message())).build()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().orderingColumnName()), AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().n(Long.toString(journalRow.ordering())).build()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().deletedColumnName()), AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().bool(Predef$.MODULE$.boolean2Boolean(journalRow.deleted())).build()).build())}))).$plus$plus((IterableOnce)journalRow.tags().map((Function1 & Serializable)tag -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().tagsColumnName()), AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().s(tag).build()).build())}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava()).build();
        return ((Source)Source$.MODULE$.single((Object)updateRequest).via((Graph)this.streamClient().updateItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            Source source;
            if (response.sdkHttpResponse().isSuccessful()) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(0).append(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable)() -> "", (Function1 & Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            }
            return source;
        })).withAttributes(this.logLevels());
    }

    @Override
    public Flow<JournalRow, Object, NotUsed> singlePutJournalRowFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)journalRow -> {
            String pkey = this.partitionKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
            String skey = this.sortKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
            PutItemRequest request = (PutItemRequest)PutItemRequest.builder().tableName(this.pluginConfig().tableName()).item(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().partitionKeyColumnName()), AttributeValue.builder().s(pkey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sortKeyColumnName()), AttributeValue.builder().s(skey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(journalRow.persistenceId().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(journalRow.sequenceNumber().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().orderingColumnName()), AttributeValue.builder().n(Long.toString(journalRow.ordering())).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().deletedColumnName()), AttributeValue.builder().bool(Predef$.MODULE$.boolean2Boolean(journalRow.deleted())).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().messageColumnName()), AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])journalRow.message())).build())}))).$plus$plus((IterableOnce)journalRow.tags().map((Function1 & Serializable)tag -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().tagsColumnName()), AttributeValue.builder().s(tag).build())}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava()).build();
            return (Source)Source$.MODULE$.single((Object)request).via((Graph)this.streamClient().putItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                Source source;
                if (response.sdkHttpResponse().isSuccessful()) {
                    source = Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)1L));
                } else {
                    int statusCode = response.sdkHttpResponse().statusCode();
                    Optional statusText = response.sdkHttpResponse().statusText();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(0).append(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable)() -> "", (Function1 & Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
                }
                return source;
            });
        });
    }

    @Override
    public Flow<scala.collection.immutable.Seq<PersistenceIdWithSeqNr>, Object, NotUsed> multiDeleteJournalRowsFlow() {
        return ((Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)persistenceIdWithSeqNrs -> {
            ((IterableOnceOps)persistenceIdWithSeqNrs.map((Function1 & Serializable)x0$1 -> {
                PersistenceIdWithSeqNr persistenceIdWithSeqNr = x0$1;
                if (persistenceIdWithSeqNr == null) {
                    throw new MatchError((Object)persistenceIdWithSeqNr);
                }
                PersistenceId pid = persistenceIdWithSeqNr.persistenceId();
                SequenceNumber seqNr = persistenceIdWithSeqNr.sequenceNumber();
                String string = new StringBuilder(16).append("pid = ").append(pid).append(", seqNr = ").append(seqNr).toString();
                return string;
            })).foreach((Function1 & Serializable)x$1 -> {
                V2JournalRowWriteDriver.$anonfun$multiDeleteJournalRowsFlow$3(this, x$1);
                return BoxedUnit.UNIT;
            });
            return persistenceIdWithSeqNrs.isEmpty() ? Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L)) : (Source)Source$.MODULE$.single(persistenceIdWithSeqNrs.map((Function1 & Serializable)persistenceIdWithSeqNr -> (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(persistenceIdWithSeqNr.persistenceId().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(persistenceIdWithSeqNr.sequenceNumber().asString()).build())}))).asJava()).build()).build())).flatMapConcat((Function1 & Serializable)requestItems -> (Source)Source$.MODULE$.single(BatchWriteItemRequest.builder().requestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().tableName()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)requestItems).asJava())}))).asJava()).build()).via((Graph)this.streamClient().recursiveBatchWriteItemFlow()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)requestItems.size())));
        })).withAttributes(this.logLevels());
    }

    @Override
    public Flow<scala.collection.immutable.Seq<JournalRow>, Object, NotUsed> multiPutJournalRowsFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)journalRows -> {
            Source source;
            if (journalRows.isEmpty()) {
                source = Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L));
            } else {
                Predef$.MODULE$.require(journalRows.size() == journalRows.toSet().size(), (Function0 & Serializable)() -> "journalRows: keys contains duplicates");
                scala.collection.immutable.Seq journalRowWithPKeyWithSKeys = (scala.collection.immutable.Seq)journalRows.map((Function1 & Serializable)journalRow -> {
                    String pkey = this.partitionKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
                    String skey = this.sortKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
                    return new Tuple3(journalRow, (Object)pkey, (Object)skey);
                });
                this.logger().debug(new StringBuilder(30).append("journalRowWithPKeyWithSKeys = ").append(journalRowWithPKeyWithSKeys.mkString("\n", ",\n", "\n")).toString());
                Predef$.MODULE$.require(((IterableOnceOps)journalRowWithPKeyWithSKeys.map((Function1 & Serializable)x0$1 -> {
                    Tuple3 tuple3 = x0$1;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String p = (String)tuple3._2();
                    String s = (String)tuple3._3();
                    Tuple2 tuple2 = new Tuple2((Object)p, (Object)s);
                    return tuple2;
                })).toSet().size() == journalRows.size(), (Function0 & Serializable)() -> "journalRowWithPKeyWithSKeys: keys contains duplicates");
                source = ((Source)Source$.MODULE$.single(journalRowWithPKeyWithSKeys.map((Function1 & Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    JournalRow journalRow = (JournalRow)tuple3._1();
                    String pkey = (String)tuple3._2();
                    String skey = (String)tuple3._3();
                    String pid = journalRow.persistenceId().asString();
                    String seqNr = journalRow.sequenceNumber().asString();
                    String ordering = Long.toString(journalRow.ordering());
                    boolean deleted = journalRow.deleted();
                    SdkBytes message = SdkBytes.fromByteArray((byte[])journalRow.message());
                    Option<String> tagsOpt = journalRow.tags();
                    WriteRequest writeRequest = (WriteRequest)WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().partitionKeyColumnName()), AttributeValue.builder().s(pkey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sortKeyColumnName()), AttributeValue.builder().s(skey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(pid).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(seqNr).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().orderingColumnName()), AttributeValue.builder().n(ordering).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().deletedColumnName()), AttributeValue.builder().bool(Predef$.MODULE$.boolean2Boolean(deleted)).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().messageColumnName()), AttributeValue.builder().b(message).build())}))).$plus$plus((IterableOnce)tagsOpt.map((Function1 & Serializable)tags -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().tagsColumnName()), AttributeValue.builder().s(tags).build())}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava()).build()).build();
                    return writeRequest;
                })).flatMapConcat((Function1 & Serializable)requestItems -> (Source)Source$.MODULE$.single(BatchWriteItemRequest.builder().requestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().tableName()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)requestItems).asJava())}))).asJava()).build()).via((Graph)this.streamClient().recursiveBatchWriteItemFlow()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)requestItems.size())))).withAttributes(this.logLevels());
            }
            return source;
        });
    }

    public static final /* synthetic */ void $anonfun$multiDeleteJournalRowsFlow$3(V2JournalRowWriteDriver $this, String x$1) {
        $this.logger().debug(x$1);
    }

    public V2JournalRowWriteDriver(ActorSystem system, Option<DynamoDbAsyncClient> asyncClient, Option<DynamoDbClient> syncClient, JournalPluginConfig pluginConfig, PartitionKeyResolver partitionKeyResolver, SortKeyResolver sortKeyResolver, Option<MetricsReporter> metricsReporter) {
        this.system = system;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        this.pluginConfig = pluginConfig;
        this.partitionKeyResolver = partitionKeyResolver;
        this.sortKeyResolver = sortKeyResolver;
        this.metricsReporter = metricsReporter;
        JournalRowDriver.$init$(this);
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.streamClient = new StreamWriteClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.writeBackoffConfig());
        this.readDriver = new V2JournalRowReadDriver(system, asyncClient, syncClient, pluginConfig, metricsReporter);
        Statics.releaseFence();
    }
}

