/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.v1;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.Attributes;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.config.JournalPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.JournalRow;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.PartitionKeyResolver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.SortKeyResolver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowWriteDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.PersistenceIdWithSeqNr;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.v1.V1JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tEb\u0001\u0002\u0011\"\u0005QB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0003\"A\u0011\n\u0001BC\u0002\u0013\u0005!\n\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003L\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\u0001\u0004!Q1A\u0005\u0002\u0005D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tS\u0002\u0011)\u0019!C\u0001U\"Aq\u000e\u0001B\u0001B\u0003%1\u000e\u0003\u0005q\u0001\t\u0015\r\u0011\"\u0001r\u0011!)\bA!A!\u0002\u0013\u0011\b\u0002\u0003<\u0001\u0005\u000b\u0007I\u0011A<\t\u0011}\u0004!\u0011!Q\u0001\naD!\"!\u0001\u0001\u0005\u0003\u0005\u000b1BA\u0002\u0011\u001d\ty\u0001\u0001C\u0001\u0003#A\u0011\"!\u000b\u0001\u0005\u0004%I!a\u000b\t\u0011\u0005u\u0002\u0001)A\u0005\u0003[A\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u0007B\u0011\"a\u0015\u0001\u0005\u0004%I!!\u0016\t\u0011\u0005u\u0003\u0001)A\u0005\u0003/Bq!a\u0018\u0001\t\u0003\n\t\u0007C\u0004\u0002`\u0001!\t%!0\t\u0013\u0005]\u0007!%A\u0005\u0002\u0005e\u0007bBAx\u0001\u0011\u0005\u0013\u0011\u001f\u0005\b\u0003{\u0004A\u0011IA\u0000\u0011\u001d\u00119\u0001\u0001C!\u0005\u0013AqA!\u0004\u0001\t\u0003\u0012y\u0001C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$\t9b+\r&pkJt\u0017\r\u001c*po^\u0013\u0018\u000e^3Ee&4XM\u001d\u0006\u0003E\r\n!A^\u0019\u000b\u0005\u0011*\u0013a\u00013b_*\u0011aeJ\u0001\bU>,(O\\1m\u0015\tA\u0013&\u0001\u0005es:\fWn\u001c3c\u0015\tQ3&A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'B\u0001\u0017.\u0003\u0011\t7n[1\u000b\u00059z\u0013A\u000266S.\u0014tN\u0003\u00021c\u00051q-\u001b;ik\nT\u0011AM\u0001\u0004G>l7\u0001A\n\u0004\u0001UZ\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$AB!osJ+g\r\u0005\u0002={5\t1%\u0003\u0002?G\t)\"j\\;s]\u0006d'k\\<Xe&$X\r\u0012:jm\u0016\u0014\u0018AB:zgR,W.F\u0001B!\t\u0011e)D\u0001D\u0015\t!U)A\u0003bGR|'OC\u0001-\u0013\t95IA\u0006BGR|'oU=ti\u0016l\u0017aB:zgR,W\u000eI\u0001\fCNLhnY\"mS\u0016tG/F\u0001L!\r1DJT\u0005\u0003\u001b^\u0012aa\u00149uS>t\u0007CA(W\u001b\u0005\u0001&BA)S\u0003)!\u0017P\\1n_\u0012\u0014gO\r\u0006\u0003'R\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0003+F\n\u0011\"Y7bu>t\u0017m^:\n\u0005]\u0003&aE!nCj|g\u000eR=oC6|GIQ!ts:\u001c\u0017\u0001D1ts:\u001c7\t\\5f]R\u0004\u0013AC:z]\u000e\u001cE.[3oiV\t1\fE\u00027\u0019r\u0003\"aT/\n\u0005y\u0003&AD!nCj|g\u000eR=oC6|GIQ\u0001\fgft7m\u00117jK:$\b%\u0001\u0007qYV<\u0017N\\\"p]\u001aLw-F\u0001c!\t\u0019g-D\u0001e\u0015\t)w%\u0001\u0004d_:4\u0017nZ\u0005\u0003O\u0012\u00141CS8ve:\fG\u000e\u00157vO&t7i\u001c8gS\u001e\fQ\u0002\u001d7vO&t7i\u001c8gS\u001e\u0004\u0013\u0001\u00069beRLG/[8o\u0017\u0016L(+Z:pYZ,'/F\u0001l!\taW.D\u0001&\u0013\tqWE\u0001\u000bQCJ$\u0018\u000e^5p].+\u0017PU3t_24XM]\u0001\u0016a\u0006\u0014H/\u001b;j_:\\U-\u001f*fg>dg/\u001a:!\u0003=\u0019xN\u001d;LKf\u0014Vm]8mm\u0016\u0014X#\u0001:\u0011\u00051\u001c\u0018B\u0001;&\u0005=\u0019vN\u001d;LKf\u0014Vm]8mm\u0016\u0014\u0018\u0001E:peR\\U-\u001f*fg>dg/\u001a:!\u0003=iW\r\u001e:jGN\u0014V\r]8si\u0016\u0014X#\u0001=\u0011\u0007Yb\u0015\u0010\u0005\u0002{{6\t1P\u0003\u0002}O\u00059Q.\u001a;sS\u000e\u001c\u0018B\u0001@|\u0005=iU\r\u001e:jGN\u0014V\r]8si\u0016\u0014\u0018\u0001E7fiJL7m\u001d*fa>\u0014H/\u001a:!\u0003\t)7\r\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIaN\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u0007\u0003\u000f\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)A\t\u0019\"a\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\t9\u0003\u0006\u0003\u0002\u0016\u0005e\u0001cAA\f\u00015\t\u0011\u0005C\u0004\u0002\u0002A\u0001\u001d!a\u0001\t\u000b}\u0002\u0002\u0019A!\t\u000b%\u0003\u0002\u0019A&\t\u000be\u0003\u0002\u0019A.\t\u000b\u0001\u0004\u0002\u0019\u00012\t\u000b%\u0004\u0002\u0019A6\t\u000bA\u0004\u0002\u0019\u0001:\t\u000bY\u0004\u0002\u0019\u0001=\u0002\r1|wmZ3s+\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u000bMdg\r\u000e6\u000b\u0005\u0005]\u0012aA8sO&!\u00111HA\u0019\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001D:ue\u0016\fWn\u00117jK:$XCAA\"!\u0011\t)%!\u0014\u000e\u0005\u0005\u001d#b\u0001\u0012\u0002J)\u0019\u00111J\u0014\u0002\r\rd\u0017.\u001a8u\u0013\u0011\ty%a\u0012\u0003#M#(/Z1n/JLG/Z\"mS\u0016tG/A\u0007tiJ,\u0017-\\\"mS\u0016tG\u000fI\u0001\u000be\u0016\fG\r\u0012:jm\u0016\u0014XCAA,!\u0011\t9\"!\u0017\n\u0007\u0005m\u0013E\u0001\fWc){WO\u001d8bYJ{wOU3bI\u0012\u0013\u0018N^3s\u0003-\u0011X-\u00193Ee&4XM\u001d\u0011\u0002\u001d\u001d,GOS8ve:\fGNU8xgRA\u00111MAM\u0003S\u000b\u0019\f\u0005\u0005\u0002f\u0005=\u00141OAI\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014\u0001C:dC2\fGm\u001d7\u000b\u0007\u00055T)\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003c\n9G\u0001\u0004T_V\u00148-\u001a\t\u0007\u0003k\n))a#\u000f\t\u0005]\u0014\u0011\u0011\b\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011QP\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014bAABo\u00059\u0001/Y2lC\u001e,\u0017\u0002BAD\u0003\u0013\u00131aU3r\u0015\r\t\u0019i\u000e\t\u0004Y\u00065\u0015bAAHK\tQ!j\\;s]\u0006d'k\\<\u0011\t\u0005M\u0015QS\u0007\u0002\u000b&\u0019\u0011qS#\u0003\u000f9{G/V:fI\"9\u00111T\fA\u0002\u0005u\u0015!\u00049feNL7\u000f^3oG\u0016LE\r\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\r\t\u0019kJ\u0001\u0006[>$W\r\\\u0005\u0005\u0003O\u000b\tKA\u0007QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\u0005\b\u0003W;\u0002\u0019AAW\u00031!xnU3rk\u0016t7-\u001a(s!\u0011\ty*a,\n\t\u0005E\u0016\u0011\u0015\u0002\u000f'\u0016\fX/\u001a8dK:+XNY3s\u0011\u001d\t)l\u0006a\u0001\u0003o\u000bq\u0001Z3mKR,G\rE\u00027\u0003sK1!a/8\u0005\u001d\u0011un\u001c7fC:$B\"a0\u0002B\u0006\r\u0017qYAe\u0003'\u0004\u0002\"!\u001a\u0002p\u0005-\u0015\u0011\u0013\u0005\b\u00037C\u0002\u0019AAO\u0011\u001d\t)\r\u0007a\u0001\u0003[\u000baB\u001a:p[N+\u0017/^3oG\u0016t%\u000fC\u0004\u0002,b\u0001\r!!,\t\u000f\u0005-\u0007\u00041\u0001\u0002N\u0006\u0019Q.\u0019=\u0011\u0007Y\ny-C\u0002\u0002R^\u0012A\u0001T8oO\"I\u0011Q\u0017\r\u0011\u0002\u0003\u0007\u0011Q\u001b\t\u0005m1\u000b9,\u0001\rhKRTu.\u001e:oC2\u0014vn^:%I\u00164\u0017-\u001e7uIU*\"!a7+\t\u0005U\u0017Q\\\u0016\u0003\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011^\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002n\u0006\r(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\t\u0002.[4iKN$8+Z9vK:\u001cWM\u0014:\u0015\u0011\u0005M\u0018Q_A|\u0003w\u0004\u0002\"!\u001a\u0002p\u00055\u0017\u0011\u0013\u0005\b\u00037S\u0002\u0019AAO\u0011%\t)M\u0007I\u0001\u0002\u0004\tI\u0010\u0005\u00037\u0019\u00065\u0006\"CA[5A\u0005\t\u0019AAk\u0003]\u0019\u0018N\\4mKB+HOS8ve:\fGNU8x\r2|w/\u0006\u0002\u0003\u0002AQ\u0011Q\rB\u0002\u0003\u0017\u000bi-!%\n\t\t\u0015\u0011q\r\u0002\u0005\r2|w/A\fnk2$\u0018\u000eU;u\u0015>,(O\\1m%><8O\u00127poV\u0011!1\u0002\t\u000b\u0003K\u0012\u0019!a\u001d\u0002N\u0006E\u0015AG7vYRLG)\u001a7fi\u0016Tu.\u001e:oC2\u0014vn^:GY><XC\u0001B\t!)\t)Ga\u0001\u0003\u0014\u00055\u0017\u0011\u0013\t\u0007\u0003k\n)I!\u0006\u0011\u0007q\u00129\"C\u0002\u0003\u001a\r\u0012a\u0003U3sg&\u001cH/\u001a8dK&#w+\u001b;i'\u0016\fhJ]\u0001\u001bg&tw\r\\3EK2,G/\u001a&pkJt\u0017\r\u001c*po\u001acwn^\u000b\u0003\u0005?\u0001\"\"!\u001a\u0003\u0004\tU\u0011QZAI\u00035)\b\u000fZ1uK6+7o]1hKR!!Q\u0005B\u0017!!\t)'a\u001c\u0003(\u0005E\u0005c\u0001\u001c\u0003*%\u0019!1F\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005_y\u0002\u0019AAF\u0003)Qw.\u001e:oC2\u0014vn\u001e")
public final class V1JournalRowWriteDriver
implements JournalRowWriteDriver {
    private final ActorSystem system;
    private final Option<AmazonDynamoDBAsync> asyncClient;
    private final Option<AmazonDynamoDB> syncClient;
    private final JournalPluginConfig pluginConfig;
    private final PartitionKeyResolver partitionKeyResolver;
    private final SortKeyResolver sortKeyResolver;
    private final Option<MetricsReporter> metricsReporter;
    private final Logger logger;
    private final StreamWriteClient streamClient;
    private final V1JournalRowReadDriver readDriver;
    private Attributes logLevels;

    @Override
    public Option<SequenceNumber> highestSequenceNr$default$2() {
        return JournalRowReadDriver.highestSequenceNr$default$2$(this);
    }

    @Override
    public Option<Object> highestSequenceNr$default$3() {
        return JournalRowReadDriver.highestSequenceNr$default$3$(this);
    }

    @Override
    public Attributes logLevels() {
        return this.logLevels;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$journal$dao$JournalRowDriver$_setter_$logLevels_$eq(Attributes x$1) {
        this.logLevels = x$1;
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    public Option<AmazonDynamoDBAsync> asyncClient() {
        return this.asyncClient;
    }

    public Option<AmazonDynamoDB> syncClient() {
        return this.syncClient;
    }

    public JournalPluginConfig pluginConfig() {
        return this.pluginConfig;
    }

    public PartitionKeyResolver partitionKeyResolver() {
        return this.partitionKeyResolver;
    }

    public SortKeyResolver sortKeyResolver() {
        return this.sortKeyResolver;
    }

    public Option<MetricsReporter> metricsReporter() {
        return this.metricsReporter;
    }

    private Logger logger() {
        return this.logger;
    }

    private StreamWriteClient streamClient() {
        return this.streamClient;
    }

    private V1JournalRowReadDriver readDriver() {
        return this.readDriver;
    }

    @Override
    public Source<scala.collection.immutable.Seq<JournalRow>, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber toSequenceNr, boolean deleted) {
        return this.readDriver().getJournalRows(persistenceId, toSequenceNr, deleted);
    }

    @Override
    public Source<JournalRow, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber fromSequenceNr, SequenceNumber toSequenceNr, long max, Option<Object> deleted) {
        return this.readDriver().getJournalRows(persistenceId, fromSequenceNr, toSequenceNr, max, deleted);
    }

    @Override
    public Option<Object> getJournalRows$default$5() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public Source<Object, NotUsed> highestSequenceNr(PersistenceId persistenceId, Option<SequenceNumber> fromSequenceNr, Option<Object> deleted) {
        return this.readDriver().highestSequenceNr(persistenceId, fromSequenceNr, deleted);
    }

    @Override
    public Flow<JournalRow, Object, NotUsed> singlePutJournalRowFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)journalRow -> {
            String pkey = this.partitionKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
            String skey = this.sortKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
            PutItemRequest request = new PutItemRequest().withTableName(this.pluginConfig().tableName()).withItem(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(journalRow.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(journalRow.sequenceNumber().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().orderingColumnName()), (Object)new AttributeValue().withN(Long.toString(journalRow.ordering()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().deletedColumnName()), (Object)new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(journalRow.deleted()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().messageColumnName()), (Object)new AttributeValue().withB(ByteBuffer.wrap(journalRow.message())))}))).$plus$plus((IterableOnce)journalRow.tags().map((Function1 & Serializable)tag -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().tagsColumnName()), (Object)new AttributeValue().withS(tag))}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava());
            return (Source)Source$.MODULE$.single((Object)request).via((Graph)this.streamClient().putItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                Source source;
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    source = Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)1L));
                } else {
                    int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
                }
                return source;
            });
        });
    }

    @Override
    public Flow<scala.collection.immutable.Seq<JournalRow>, Object, NotUsed> multiPutJournalRowsFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)journalRows -> {
            Source source;
            if (journalRows.isEmpty()) {
                source = Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L));
            } else {
                Predef$.MODULE$.require(journalRows.size() == journalRows.toSet().size(), (Function0 & Serializable)() -> "journalRows: keys contains duplicates");
                scala.collection.immutable.Seq journalRowWithPKeyWithSKeys = (scala.collection.immutable.Seq)journalRows.map((Function1 & Serializable)journalRow -> {
                    String pkey = this.partitionKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
                    String skey = this.sortKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
                    return new Tuple3(journalRow, (Object)pkey, (Object)skey);
                });
                this.logger().debug(new StringBuilder(30).append("journalRowWithPKeyWithSKeys = ").append(journalRowWithPKeyWithSKeys.mkString("\n", ",\n", "\n")).toString());
                Predef$.MODULE$.require(((IterableOnceOps)journalRowWithPKeyWithSKeys.map((Function1 & Serializable)x0$1 -> {
                    Tuple3 tuple3 = x0$1;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String p = (String)tuple3._2();
                    String s = (String)tuple3._3();
                    Tuple2 tuple2 = new Tuple2((Object)p, (Object)s);
                    return tuple2;
                })).toSet().size() == journalRows.size(), (Function0 & Serializable)() -> "journalRowWithPKeyWithSKeys: keys contains duplicates");
                source = ((Source)Source$.MODULE$.single(journalRowWithPKeyWithSKeys.map((Function1 & Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    JournalRow journalRow = (JournalRow)tuple3._1();
                    String pkey = (String)tuple3._2();
                    String skey = (String)tuple3._3();
                    String pid = journalRow.persistenceId().asString();
                    String seqNr = journalRow.sequenceNumber().asString();
                    String ordering = Long.toString(journalRow.ordering());
                    boolean deleted = journalRow.deleted();
                    ByteBuffer message = ByteBuffer.wrap(journalRow.message());
                    Option<String> tagsOpt = journalRow.tags();
                    WriteRequest writeRequest = new WriteRequest().withPutRequest(new PutRequest().withItem(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(pid)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(seqNr)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().orderingColumnName()), (Object)new AttributeValue().withN(ordering)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().deletedColumnName()), (Object)new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(deleted))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().messageColumnName()), (Object)new AttributeValue().withB(message))}))).$plus$plus((IterableOnce)tagsOpt.map((Function1 & Serializable)tags -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().tagsColumnName()), (Object)new AttributeValue().withS(tags))}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava()));
                    return writeRequest;
                })).flatMapConcat((Function1 & Serializable)requestItems -> (Source)Source$.MODULE$.single((Object)new BatchWriteItemRequest().withRequestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().tableName()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)requestItems).asJava())}))).asJava())).via((Graph)this.streamClient().recursiveBatchWriteItemFlow()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)requestItems.size())))).withAttributes(this.logLevels());
            }
            return source;
        });
    }

    @Override
    public Flow<scala.collection.immutable.Seq<PersistenceIdWithSeqNr>, Object, NotUsed> multiDeleteJournalRowsFlow() {
        return ((Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)persistenceIdWithSeqNrs -> {
            ((IterableOnceOps)persistenceIdWithSeqNrs.map((Function1 & Serializable)x0$1 -> {
                PersistenceIdWithSeqNr persistenceIdWithSeqNr = x0$1;
                if (persistenceIdWithSeqNr == null) {
                    throw new MatchError((Object)persistenceIdWithSeqNr);
                }
                PersistenceId pid = persistenceIdWithSeqNr.persistenceId();
                SequenceNumber seqNr = persistenceIdWithSeqNr.sequenceNumber();
                String string = new StringBuilder(16).append("pid = ").append(pid).append(", seqNr = ").append(seqNr).toString();
                return string;
            })).foreach((Function1 & Serializable)x$1 -> {
                V1JournalRowWriteDriver.$anonfun$multiDeleteJournalRowsFlow$3(this, x$1);
                return BoxedUnit.UNIT;
            });
            return persistenceIdWithSeqNrs.isEmpty() ? Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L)) : (Source)Source$.MODULE$.single(persistenceIdWithSeqNrs.map((Function1 & Serializable)persistenceIdWithSeqNr -> new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(persistenceIdWithSeqNr.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(persistenceIdWithSeqNr.sequenceNumber().asString()))}))).asJava())))).flatMapConcat((Function1 & Serializable)requestItems -> (Source)Source$.MODULE$.single((Object)new BatchWriteItemRequest().withRequestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().tableName()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)requestItems).asJava())}))).asJava())).via((Graph)this.streamClient().recursiveBatchWriteItemFlow()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)requestItems.size())));
        })).withAttributes(this.logLevels());
    }

    @Override
    public Flow<PersistenceIdWithSeqNr, Object, NotUsed> singleDeleteJournalRowFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)persistenceIdWithSeqNr -> {
            DeleteItemRequest deleteRequest = new DeleteItemRequest().withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(persistenceIdWithSeqNr.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(persistenceIdWithSeqNr.sequenceNumber().asString()))}))).asJava());
            return (Source)Source$.MODULE$.single((Object)deleteRequest).via((Graph)this.streamClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                Source source;
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    source = Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)1L));
                } else {
                    int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
                }
                return source;
            });
        });
    }

    @Override
    public Source<BoxedUnit, NotUsed> updateMessage(JournalRow journalRow) {
        this.logger().debug(new StringBuilder(35).append("updateMessage(journalRow = ").append(journalRow).append("): start").toString());
        String pkey = journalRow.partitionKey(this.partitionKeyResolver()).asString();
        String skey = journalRow.sortKey(this.sortKeyResolver()).asString();
        return ((Source)Source$.MODULE$.single((Object)this.createUpdateRequest$1(pkey, skey, journalRow)).via((Graph)this.streamClient().updateItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                this.logger().debug(new StringBuilder(38).append("updateMessage(journalRow = ").append(journalRow).append("): finished").toString());
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        })).withAttributes(this.logLevels());
    }

    public static final /* synthetic */ void $anonfun$multiDeleteJournalRowsFlow$3(V1JournalRowWriteDriver $this, String x$1) {
        $this.logger().debug(x$1);
    }

    private final UpdateItemRequest createUpdateRequest$1(String pkey$1, String skey$1, JournalRow journalRow$1) {
        return new UpdateItemRequest().withTableName(this.pluginConfig().tableName()).withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey$1))}))).asJava()).withAttributeUpdates(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().messageColumnName()), (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withB(ByteBuffer.wrap(journalRow$1.message())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().orderingColumnName()), (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withN(Long.toString(journalRow$1.ordering())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().deletedColumnName()), (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(journalRow$1.deleted()))))}))).$plus$plus((IterableOnce)journalRow$1.tags().map((Function1 & Serializable)tag -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginConfig().columnsDefConfig().tagsColumnName()), (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withS(tag)))}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava());
    }

    public V1JournalRowWriteDriver(ActorSystem system, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient, JournalPluginConfig pluginConfig, PartitionKeyResolver partitionKeyResolver, SortKeyResolver sortKeyResolver, Option<MetricsReporter> metricsReporter, ExecutionContext ec) {
        this.system = system;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        this.pluginConfig = pluginConfig;
        this.partitionKeyResolver = partitionKeyResolver;
        this.sortKeyResolver = sortKeyResolver;
        this.metricsReporter = metricsReporter;
        JournalRowDriver.$init$(this);
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.streamClient = new StreamWriteClient(system, asyncClient, syncClient, (PluginConfig)pluginConfig, pluginConfig.writeBackoffConfig());
        this.readDriver = new V1JournalRowReadDriver(system, asyncClient, syncClient, pluginConfig, metricsReporter, ec);
        Statics.releaseFence();
    }
}

