/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.journal.dao;

import akka.Done;
import akka.NotUsed;
import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.Scheduler;
import akka.persistence.PersistentRepr;
import akka.stream.ActorMaterializer$;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.Graph;
import akka.stream.KillSwitches$;
import akka.stream.Materializer;
import akka.stream.OverflowStrategy;
import akka.stream.OverflowStrategy$;
import akka.stream.QueueOfferResult;
import akka.stream.UniqueKillSwitch;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.stream.scaladsl.SourceQueueWithComplete;
import com.github.j5ik2o.akka.persistence.dynamodb.config.JournalPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.JournalRow;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.DaoSupport;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalDaoWithUpdates;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowWriteDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.PersistenceIdWithSeqNr;
import com.github.j5ik2o.akka.persistence.dynamodb.metrics.MetricsReporter;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import com.github.j5ik2o.akka.persistence.dynamodb.serialization.FlowPersistentReprSerializer;
import java.io.Serializable;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t\rd\u0001B\u0017/\u0001}B\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t)\u0002\u0011)\u0019!C\t+\"A\u0011\f\u0001B\u0001B\u0003%a\u000b\u0003\u0005[\u0001\t\u0015\r\u0011\"\u0001\\\u0011!1\u0007A!A!\u0002\u0013a\u0006\u0002C4\u0001\u0005\u000b\u0007I\u0011\u00035\t\u0011I\u0004!\u0011!Q\u0001\n%D\u0001b\u001d\u0001\u0003\u0006\u0004%\u0019\u0001\u001e\u0005\tw\u0002\u0011\t\u0011)A\u0005k\"AA\u0010\u0001B\u0001B\u0003-Q\u0010C\u0004\u0002\n\u0001!\t!a\u0003\t\u0013\u0005u\u0001A1A\u0005\u0004\u0005}\u0001\u0002CA\u0017\u0001\u0001\u0006I!!\t\t\u0013\u0005=\u0002A1A\u0005\n\u0005E\u0002\u0002CA\u001d\u0001\u0001\u0006I!a\r\t\u0013\u0005m\u0002A1A\u0005\n\u0005E\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\r\t\u0013\u0005}\u0002A1A\u0005\n\u0005E\u0002\u0002CA!\u0001\u0001\u0006I!a\r\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0003\u0002CA'\u0001\u0001\u0006I!a\u0012\t\u0013\u0005=\u0003A1A\u0005\n\u0005E\u0003\u0002CA-\u0001\u0001\u0006I!a\u0015\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u0011\u0011\u0014\u0001\u0005\n\u0005m\u0005\"CA\\\u0001\t\u0007I\u0011BA]\u0011!\ti\f\u0001Q\u0001\n\u0005m\u0006bBA`\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003'\u0004A\u0011BAk\u0011\u001d\tI\u000e\u0001C\u0005\u00037Dq!!;\u0001\t\u0013\tY\u000fC\u0005\u0002t\u0002\u0011\r\u0011\"\u0003\u0002v\"A\u0011\u0011 \u0001!\u0002\u0013\t9\u0010C\u0004\u0002|\u0002!\t%!@\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!9!1\u0002\u0001\u0005B\t5\u0001b\u0002B\u0010\u0001\u0011\u0005#\u0011\u0005\u0005\b\u0005c\u0001A\u0011\tB\u001a\u0011\u001d\u0011I\u0004\u0001C!\u0005wAqAa\u0011\u0001\t\u0013\u0011)\u0005C\u0004\u0003N\u0001!IA!\u0012\t\u000f\t=\u0003\u0001\"\u0003\u0003R!9!1\f\u0001\u0005\n\tu\u0003b\u0002B1\u0001\u0011%!Q\f\u0002\u0014/JLG/\u001a&pkJt\u0017\r\u001c#b_&k\u0007\u000f\u001c\u0006\u0003_A\n1\u0001Z1p\u0015\t\t$'A\u0004k_V\u0014h.\u00197\u000b\u0005M\"\u0014\u0001\u00033z]\u0006lw\u000e\u001a2\u000b\u0005U2\u0014a\u00039feNL7\u000f^3oG\u0016T!a\u000e\u001d\u0002\t\u0005\\7.\u0019\u0006\u0003si\naA[\u001bjWJz'BA\u001e=\u0003\u00199\u0017\u000e\u001e5vE*\tQ(A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u0001\u001aS\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%AB!osJ+g\r\u0005\u0002H\u00116\ta&\u0003\u0002J]\t)\"j\\;s]\u0006dG)Y8XSRDW\u000b\u001d3bi\u0016\u001c\bCA$L\u0013\taeF\u0001\u0006EC>\u001cV\u000f\u001d9peR\fA\u0002\u001d7vO&t7i\u001c8gS\u001e\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u001a\u0002\r\r|gNZ5h\u0013\t\u0019\u0006KA\nK_V\u0014h.\u00197QYV<\u0017N\\\"p]\u001aLw-\u0001\tk_V\u0014h.\u00197S_^$%/\u001b<feV\ta\u000b\u0005\u0002H/&\u0011\u0001L\f\u0002\u0016\u0015>,(O\\1m%><xK]5uK\u0012\u0013\u0018N^3s\u0003EQw.\u001e:oC2\u0014vn\u001e#sSZ,'\u000fI\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014X#\u0001/\u0011\u0007u\u0003'-D\u0001_\u0015\ty&'A\u0007tKJL\u0017\r\\5{CRLwN\\\u0005\u0003Cz\u0013AD\u00127poB+'o]5ti\u0016tGOU3qeN+'/[1mSj,'\u000f\u0005\u0002dI6\t\u0001'\u0003\u0002fa\tQ!j\\;s]\u0006d'k\\<\u0002\u0017M,'/[1mSj,'\u000fI\u0001\u0010[\u0016$(/[2t%\u0016\u0004xN\u001d;feV\t\u0011\u000eE\u0002BU2L!a\u001b\"\u0003\r=\u0003H/[8o!\ti\u0007/D\u0001o\u0015\ty''A\u0004nKR\u0014\u0018nY:\n\u0005Et'aD'fiJL7m\u001d*fa>\u0014H/\u001a:\u0002!5,GO]5dgJ+\u0007o\u001c:uKJ\u0004\u0013AA3d+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=C\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003u^\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0007\u0015\u001c\u0007%\u0001\u0004tsN$X-\u001c\t\u0004}\u0006\u0015Q\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0006C\u000e$xN\u001d\u0006\u0002o%\u0019\u0011qA@\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u00055\u0011QCA\f\u00033\tY\u0002\u0006\u0004\u0002\u0010\u0005E\u00111\u0003\t\u0003\u000f\u0002AQa]\u0006A\u0004UDQ\u0001`\u0006A\u0004uDQ!T\u0006A\u00029CQ\u0001V\u0006A\u0002YCQAW\u0006A\u0002qCQaZ\u0006A\u0002%\f1!\\1u+\t\t\t\u0003\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\u0011\t9#a\u0001\u0002\rM$(/Z1n\u0013\u0011\tY#!\n\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002\t5\fG\u000fI\u0001\u0010cV,W/\u001a\"vM\u001a,'oU5{KV\u0011\u00111\u0007\t\u0004\u0003\u0006U\u0012bAA\u001c\u0005\n\u0019\u0011J\u001c;\u0002!E,X-^3Ck\u001a4WM]*ju\u0016\u0004\u0013\u0001E9vKV,\u0007+\u0019:bY2,G.[:n\u0003E\tX/Z;f!\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000eI\u0001\u0011oJLG/\u001a)be\u0006dG.\u001a7jg6\f\u0011c\u001e:ji\u0016\u0004\u0016M]1mY\u0016d\u0017n]7!\u0003%awn\u001a'fm\u0016d7/\u0006\u0002\u0002HA!\u00111EA%\u0013\u0011\tY%!\n\u0003\u0015\u0005#HO]5ckR,7/\u0001\u0006m_\u001edUM^3mg\u0002\nQ#];fk\u0016|e/\u001a:gY><8\u000b\u001e:bi\u0016<\u00170\u0006\u0002\u0002TA!\u00111EA+\u0013\u0011\t9&!\n\u0003!=3XM\u001d4m_^\u001cFO]1uK\u001eL\u0018AF9vKV,wJ^3sM2|wo\u0015;sCR,w-\u001f\u0011\u0002#%tG/\u001a:oC2\u0004V\u000f^*ue\u0016\fW\u000e\u0006\u0004\u0002`\u00055\u0014Q\u0010\t\u0006m\u0006\u0005\u0014QM\u0005\u0004\u0003G:(A\u0002$viV\u0014X\r\u0005\u0003\u0002h\u0005%TBAA\u0002\u0013\u0011\tY'a\u0001\u0003\t\u0011{g.\u001a\u0005\b\u0003_B\u0002\u0019AA9\u0003\u001d\u0001(o\\7jg\u0016\u0004RA^A:\u0003oJ1!!\u001ex\u0005\u001d\u0001&o\\7jg\u0016\u00042!QA=\u0013\r\tYH\u0011\u0002\u0005\u0019>tw\rC\u0004\u0002\u0000a\u0001\r!!!\u0002\tI|wo\u001d\t\u0006\u0003\u0007\u000b\u0019J\u0019\b\u0005\u0003\u000b\u000byI\u0004\u0003\u0002\b\u00065UBAAE\u0015\r\tYIP\u0001\u0007yI|w\u000e\u001e \n\u0003\rK1!!%C\u0003\u001d\u0001\u0018mY6bO\u0016LA!!&\u0002\u0018\n\u00191+Z9\u000b\u0007\u0005E%)\u0001\u0005qkR\fV/Z;f+\t\ti\nE\u0004B\u0003?\u000b\u0019+!-\n\u0007\u0005\u0005&I\u0001\u0004UkBdWM\r\t\u0007\u0003K\u000bY+a,\u000e\u0005\u0005\u001d&\u0002BAU\u0003K\t\u0001b]2bY\u0006$7\u000f\\\u0005\u0005\u0003[\u000b9KA\fT_V\u00148-Z)vKV,w+\u001b;i\u0007>l\u0007\u000f\\3uKB9\u0011)a(\u0002r\u0005\u0005\u0005\u0003BA\u0012\u0003gKA!!.\u0002&\t\u0001RK\\5rk\u0016\\\u0015\u000e\u001c7To&$8\r[\u0001\naV$\u0018+^3vKN,\"!a/\u0011\r\u0005\r\u00151SAO\u0003)\u0001X\u000f^)vKV,7\u000fI\u0001\fcV,W/Z%e\rJ|W\u000e\u0006\u0003\u00024\u0005\r\u0007bBAc9\u0001\u0007\u0011qY\u0001\u000ea\u0016\u00148/[:uK:\u001cW-\u00133\u0011\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017T1!!43\u0003\u0015iw\u000eZ3m\u0013\u0011\t\t.a3\u0003\u001bA+'o]5ti\u0016t7-Z%e\u00039\u0019X\r\\3diB+H/U;fk\u0016$B!a)\u0002X\"9\u0011QY\u000fA\u0002\u0005\u001d\u0017\u0001F5oi\u0016\u0014h.\u00197EK2,G/Z*ue\u0016\fW\u000e\u0006\u0004\u0002`\u0005u\u0017q\u001c\u0005\b\u0003_r\u0002\u0019AA9\u0011\u001d\tyH\ba\u0001\u0003C\u0004b!a!\u0002\u0014\u0006\r\bcA$\u0002f&\u0019\u0011q\u001d\u0018\u0003-A+'o]5ti\u0016t7-Z%e/&$\bnU3r\u001dJ\f1\u0002Z3mKR,\u0017+^3vKV\u0011\u0011Q\u001e\t\b\u0003\u0006}\u0015q^AY!\u0019\t)+a+\u0002rB9\u0011)a(\u0002r\u0005\u0005\u0018\u0001\u00043fY\u0016$X-U;fk\u0016\u001cXCAA|!\u0019\t\u0019)a%\u0002n\u0006iA-\u001a7fi\u0016\fV/Z;fg\u0002\nq\u0001Z5ta>\u001cX\r\u0006\u0002\u0002\u0000B\u0019\u0011I!\u0001\n\u0007\t\r!I\u0001\u0003V]&$\u0018!E:fY\u0016\u001cG\u000fR3mKR,\u0017+^3vKR!\u0011q\u001eB\u0005\u0011\u001d\t)m\ta\u0001\u0003\u000f\fQ\"\u001e9eCR,W*Z:tC\u001e,G\u0003\u0002B\b\u00057\u0001\u0002\"!*\u0003\u0012\u0005}(QC\u0005\u0005\u0005'\t9K\u0001\u0004T_V\u00148-\u001a\t\u0005\u0003O\u00129\"\u0003\u0003\u0003\u001a\u0005\r!a\u0002(piV\u001bX\r\u001a\u0005\u0007\u0005;!\u0003\u0019\u00012\u0002\u0015)|WO\u001d8bYJ{w/\u0001\beK2,G/Z'fgN\fw-Z:\u0015\r\t\r\"Q\u0005B\u0014!!\t)K!\u0005\u0002x\tU\u0001bBAcK\u0001\u0007\u0011q\u0019\u0005\b\u0005S)\u0003\u0019\u0001B\u0016\u00031!xnU3rk\u0016t7-\u001a(s!\u0011\tIM!\f\n\t\t=\u00121\u001a\u0002\u000f'\u0016\fX/\u001a8dK:+XNY3s\u0003-\u0001X\u000f^'fgN\fw-Z:\u0015\t\t\r\"Q\u0007\u0005\b\u0005o1\u0003\u0019AAA\u0003!iWm]:bO\u0016\u001c\u0018!\u00055jO\",7\u000f^*fcV,gnY3OeR1!1\u0005B\u001f\u0005\u007fAq!!2(\u0001\u0004\t9\rC\u0004\u0003B\u001d\u0002\rAa\u000b\u0002\u001d\u0019\u0014x.\\*fcV,gnY3Oe\u0006\u0001#/Z9vKN$\b+\u001e;K_V\u0014h.\u00197S_^\u001c\b+Y:t)\"\u0014x.^4i+\t\u00119\u0005\u0005\u0006\u0002&\n%\u0013\u0011QA<\u0005+IAAa\u0013\u0002(\n!a\t\\8x\u0003U\u0011X-];fgR\u0004V\u000f\u001e&pkJt\u0017\r\u001c*poN\f\u0001\u0002Z3mKR,')\u001f\u000b\u0007\u0005G\u0011\u0019F!\u0016\t\u000f\u0005\u0015'\u00061\u0001\u0002H\"9!q\u000b\u0016A\u0002\te\u0013aC:fcV,gnY3OeN\u0004b!a!\u0002\u0014\n-\u0012a\t:fcV,7\u000f\u001e#fY\u0016$XMS8ve:\fGNU8xgB\u000b7o\u001d+ie>,x\r[\u000b\u0003\u0005?\u0002\"\"!*\u0003J\u0005\u0005\u0018q\u000fB\u000b\u0003a\u0011X-];fgR$U\r\\3uK*{WO\u001d8bYJ{wo\u001d")
public class WriteJournalDaoImpl
implements JournalDaoWithUpdates,
DaoSupport {
    private final JournalPluginConfig pluginConfig;
    private final JournalRowWriteDriver journalRowDriver;
    private final FlowPersistentReprSerializer<JournalRow> serializer;
    private final Option<MetricsReporter> metricsReporter;
    private final ExecutionContext ec;
    private final Materializer mat;
    private final int queueBufferSize;
    private final int queueParallelism;
    private final int writeParallelism;
    private final Attributes logLevels;
    private final OverflowStrategy queueOverflowStrategy;
    private final Seq<Tuple2<SourceQueueWithComplete<Tuple2<Promise<Object>, Seq<JournalRow>>>, UniqueKillSwitch>> putQueues;
    private final Seq<Tuple2<SourceQueueWithComplete<Tuple2<Promise<Object>, Seq<PersistenceIdWithSeqNr>>>, UniqueKillSwitch>> deleteQueues;

    @Override
    public Source<JournalRow, NotUsed> getMessagesAsJournalRow(PersistenceId persistenceId, SequenceNumber fromSequenceNr, SequenceNumber toSequenceNr, long max, Option<Object> deleted) {
        return DaoSupport.getMessagesAsJournalRow$(this, persistenceId, fromSequenceNr, toSequenceNr, max, deleted);
    }

    @Override
    public Option<Object> getMessagesAsJournalRow$default$5() {
        return DaoSupport.getMessagesAsJournalRow$default$5$(this);
    }

    @Override
    public Source<Try<PersistentRepr>, NotUsed> getMessagesAsPersistentRepr(PersistenceId persistenceId, SequenceNumber fromSequenceNr, SequenceNumber toSequenceNr, long max, Option<Object> deleted) {
        return DaoSupport.getMessagesAsPersistentRepr$(this, persistenceId, fromSequenceNr, toSequenceNr, max, deleted);
    }

    @Override
    public Option<Object> getMessagesAsPersistentRepr$default$5() {
        return DaoSupport.getMessagesAsPersistentRepr$default$5$(this);
    }

    @Override
    public Source<Try<PersistentRepr>, NotUsed> getMessagesAsPersistentReprWithBatch(String persistenceId, long fromSequenceNr, long toSequenceNr, int batchSize, Option<Tuple2<FiniteDuration, Scheduler>> refreshInterval) {
        return DaoSupport.getMessagesAsPersistentReprWithBatch$(this, persistenceId, fromSequenceNr, toSequenceNr, batchSize, refreshInterval);
    }

    @Override
    public JournalRowWriteDriver journalRowDriver() {
        return this.journalRowDriver;
    }

    @Override
    public FlowPersistentReprSerializer<JournalRow> serializer() {
        return this.serializer;
    }

    @Override
    public Option<MetricsReporter> metricsReporter() {
        return this.metricsReporter;
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public Materializer mat() {
        return this.mat;
    }

    private int queueBufferSize() {
        return this.queueBufferSize;
    }

    private int queueParallelism() {
        return this.queueParallelism;
    }

    private int writeParallelism() {
        return this.writeParallelism;
    }

    private Attributes logLevels() {
        return this.logLevels;
    }

    private OverflowStrategy queueOverflowStrategy() {
        return this.queueOverflowStrategy;
    }

    private Future<Done> internalPutStream(Promise<Object> promise, Seq<JournalRow> rows) {
        Source s = rows.size() == 1 ? (Source)Source$.MODULE$.single(rows.head()).batch((long)this.pluginConfig.clientConfig().batchWriteItemLimit(), (Function1 & Serializable)x$1 -> (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JournalRow[]{x$1})), (Function2 & Serializable)(x$2, x$3) -> (Vector)x$2.$colon$plus(x$3)).flatMapConcat((Function1 & Serializable)request -> request.size() == 1 ? Source$.MODULE$.single(request.head()).via(this.journalRowDriver().singlePutJournalRowFlow()) : Source$.MODULE$.single(request).via(this.journalRowDriver().multiPutJournalRowsFlow())) : (rows.size() > this.pluginConfig.clientConfig().batchWriteItemLimit() ? (Source)((Source)Source$.MODULE$.apply((Iterable)rows.toVector()).grouped(this.pluginConfig.clientConfig().batchWriteItemLimit())).via(this.journalRowDriver().multiPutJournalRowsFlow()).fold((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x$4, x$5) -> x$4 + x$5) : Source$.MODULE$.single(rows).via(this.journalRowDriver().multiPutJournalRowsFlow()));
        return (Future)((Source)s.map((Function1 & Serializable)result -> promise.success((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)result)))).recover((PartialFunction)new Serializable(null, promise){
            private static final long serialVersionUID = 0L;
            private final Promise promise$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Promise promise = this.promise$1.failure(A1);
                return (B1)promise;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.promise$1 = promise$1;
            }
        })).runWith((Graph)Sink$.MODULE$.ignore(), this.mat());
    }

    private Tuple2<SourceQueueWithComplete<Tuple2<Promise<Object>, Seq<JournalRow>>>, UniqueKillSwitch> putQueue() {
        Tuple2 result = (Tuple2)((Source)Source$.MODULE$.queue(this.queueBufferSize(), this.queueOverflowStrategy()).viaMat(KillSwitches$.MODULE$.single(), Keep$.MODULE$.both()).mapAsync(this.writeParallelism(), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Promise promise = (Promise)tuple2._1();
            Seq rows = (Seq)tuple2._2();
            Future<Done> future = this.internalPutStream((Promise<Object>)promise, (Seq<JournalRow>)rows);
            return future;
        })).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.both()).withAttributes(this.logLevels()).run(this.mat());
        return new Tuple2(((Tuple2)result._1())._1(), ((Tuple2)result._1())._2());
    }

    private Seq<Tuple2<SourceQueueWithComplete<Tuple2<Promise<Object>, Seq<JournalRow>>>, UniqueKillSwitch>> putQueues() {
        return this.putQueues;
    }

    private int queueIdFrom(PersistenceId persistenceId) {
        return Math.abs(Statics.anyHash((Object)persistenceId.asString())) % this.queueParallelism();
    }

    private SourceQueueWithComplete<Tuple2<Promise<Object>, Seq<JournalRow>>> selectPutQueue(PersistenceId persistenceId) {
        return (SourceQueueWithComplete)((Tuple2)this.putQueues().apply(this.queueIdFrom(persistenceId)))._1();
    }

    private Future<Done> internalDeleteStream(Promise<Object> promise, Seq<PersistenceIdWithSeqNr> rows) {
        Source s = rows.size() == 1 ? (Source)Source$.MODULE$.single(rows.head()).batch((long)this.pluginConfig.clientConfig().batchWriteItemLimit(), (Function1 & Serializable)x$7 -> (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PersistenceIdWithSeqNr[]{x$7})), (Function2 & Serializable)(x$8, x$9) -> (Vector)x$8.$colon$plus(x$9)).flatMapConcat((Function1 & Serializable)request -> request.size() == 1 ? Source$.MODULE$.single(request.head()).via(this.journalRowDriver().singleDeleteJournalRowFlow()) : Source$.MODULE$.single(request).via(this.journalRowDriver().multiDeleteJournalRowsFlow())) : (rows.size() > this.pluginConfig.clientConfig().batchWriteItemLimit() ? (Source)((Source)Source$.MODULE$.apply((Iterable)rows.toVector()).grouped(this.pluginConfig.clientConfig().batchWriteItemLimit())).via(this.journalRowDriver().multiDeleteJournalRowsFlow()).fold((Object)BoxesRunTime.boxToLong((long)0L), (Function2)(JFunction2.mcJJJ.sp & Serializable)(x$10, x$11) -> x$10 + x$11) : Source$.MODULE$.single(rows).via(this.journalRowDriver().multiDeleteJournalRowsFlow()));
        return (Future)((Source)s.map((Function1 & Serializable)result -> promise.success((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)result)))).recover((PartialFunction)new Serializable(null, promise){
            private static final long serialVersionUID = 0L;
            private final Promise promise$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Promise promise = this.promise$2.failure(A1);
                return (B1)promise;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                this.promise$2 = promise$2;
            }
        })).runWith((Graph)Sink$.MODULE$.ignore(), this.mat());
    }

    private Tuple2<SourceQueueWithComplete<Tuple2<Promise<Object>, Seq<PersistenceIdWithSeqNr>>>, UniqueKillSwitch> deleteQueue() {
        Tuple2 result = (Tuple2)((Source)Source$.MODULE$.queue(this.queueBufferSize(), this.queueOverflowStrategy()).viaMat(KillSwitches$.MODULE$.single(), Keep$.MODULE$.both()).mapAsync(this.writeParallelism(), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Promise promise = (Promise)tuple2._1();
            Seq rows = (Seq)tuple2._2();
            Future<Done> future = this.internalDeleteStream((Promise<Object>)promise, (Seq<PersistenceIdWithSeqNr>)rows);
            return future;
        })).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.both()).withAttributes(this.logLevels()).run(this.mat());
        return new Tuple2(((Tuple2)result._1())._1(), ((Tuple2)result._1())._2());
    }

    private Seq<Tuple2<SourceQueueWithComplete<Tuple2<Promise<Object>, Seq<PersistenceIdWithSeqNr>>>, UniqueKillSwitch>> deleteQueues() {
        return this.deleteQueues;
    }

    @Override
    public void dispose() {
        this.putQueues().foreach((Function1 & Serializable)x0$1 -> {
            WriteJournalDaoImpl.$anonfun$dispose$1(x0$1);
            return BoxedUnit.UNIT;
        });
        this.deleteQueues().foreach((Function1 & Serializable)x0$2 -> {
            WriteJournalDaoImpl.$anonfun$dispose$2(x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private SourceQueueWithComplete<Tuple2<Promise<Object>, Seq<PersistenceIdWithSeqNr>>> selectDeleteQueue(PersistenceId persistenceId) {
        return (SourceQueueWithComplete)((Tuple2)this.deleteQueues().apply(this.queueIdFrom(persistenceId)))._1();
    }

    @Override
    public Source<BoxedUnit, NotUsed> updateMessage(JournalRow journalRow) {
        return this.journalRowDriver().updateMessage(journalRow);
    }

    @Override
    public Source<Object, NotUsed> deleteMessages(PersistenceId persistenceId, SequenceNumber toSequenceNr) {
        return ((Source)this.journalRowDriver().getJournalRows(persistenceId, toSequenceNr, false).flatMapConcat((Function1 & Serializable)journalRows -> (Source)this.putMessages((Seq<JournalRow>)((Seq)journalRows.map((Function1 & Serializable)x$13 -> x$13.withDeleted()))).map((Function1 & Serializable)result -> WriteJournalDaoImpl.$anonfun$deleteMessages$3(journalRows, BoxesRunTime.unboxToLong((Object)result)))).flatMapConcat((Function1 & Serializable)x0$1 -> {
            Source source;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long result = tuple2._1$mcJ$sp();
                Seq journalRows = (Seq)tuple2._2();
                if (!$this.pluginConfig.softDeleted()) {
                    PersistenceId x$1 = persistenceId;
                    Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    Option<SequenceNumber> x$3 = this.journalRowDriver().highestSequenceNr$default$2();
                    source = (Source)this.journalRowDriver().highestSequenceNr(x$1, x$3, (Option<Object>)x$2).flatMapConcat((Function1 & Serializable)highestMarkedSequenceNr -> WriteJournalDaoImpl.$anonfun$deleteMessages$5(this, persistenceId, journalRows, BoxesRunTime.unboxToLong((Object)highestMarkedSequenceNr)));
                } else {
                    source = Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)result));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Source source2 = source;
            return source2;
        })).withAttributes(this.logLevels());
    }

    @Override
    public Source<Object, NotUsed> putMessages(Seq<JournalRow> messages) {
        return messages.isEmpty() ? Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L)) : (this.pluginConfig.queueEnable() ? Source$.MODULE$.single(messages).via(this.requestPutJournalRows()) : Source$.MODULE$.single(messages).via(this.requestPutJournalRowsPassThrough()));
    }

    @Override
    public Source<Object, NotUsed> highestSequenceNr(PersistenceId persistenceId, SequenceNumber fromSequenceNr) {
        return this.journalRowDriver().highestSequenceNr(persistenceId, (Option<SequenceNumber>)new Some((Object)fromSequenceNr), this.journalRowDriver().highestSequenceNr$default$3());
    }

    private Flow<Seq<JournalRow>, Object, NotUsed> requestPutJournalRowsPassThrough() {
        return (Flow)Flow$.MODULE$.apply().mapAsync(this.writeParallelism(), (Function1 & Serializable)messages -> {
            Promise promise = Promise$.MODULE$.apply();
            return this.internalPutStream((Promise<Object>)promise, (Seq<JournalRow>)messages).flatMap((Function1 & Serializable)x$16 -> promise.future(), this.ec());
        });
    }

    private Flow<Seq<JournalRow>, Object, NotUsed> requestPutJournalRows() {
        return ((Flow)Flow$.MODULE$.apply().mapAsync(1, (Function1 & Serializable)messages -> {
            Promise promise = Promise$.MODULE$.apply();
            return this.selectPutQueue(((JournalRow)messages.head()).persistenceId()).offer((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)promise), messages)).flatMap((Function1 & Serializable)x0$1 -> {
                Future future;
                QueueOfferResult queueOfferResult = x0$1;
                if (QueueOfferResult.Enqueued$.MODULE$.equals(queueOfferResult)) {
                    Future future2;
                    future = future2 = promise.future();
                } else if (queueOfferResult instanceof QueueOfferResult.Failure) {
                    QueueOfferResult.Failure failure = (QueueOfferResult.Failure)queueOfferResult;
                    Throwable t = failure.cause();
                    future = Future$.MODULE$.failed((Throwable)new Exception("Failed to write journal row batch", t));
                } else if (QueueOfferResult.Dropped$.MODULE$.equals(queueOfferResult)) {
                    future = Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(129).append("Failed to enqueue journal row batch write, the queue buffer was full (").append(this.queueBufferSize()).append(" elements) please check the jdbc-journal.bufferSize setting").toString()));
                } else if (QueueOfferResult.QueueClosed$.MODULE$.equals(queueOfferResult)) {
                    future = Future$.MODULE$.failed((Throwable)new Exception("Failed to enqueue journal row batch write, the queue was closed"));
                } else {
                    throw new MatchError((Object)queueOfferResult);
                }
                return future;
            }, this.ec());
        })).withAttributes(this.logLevels());
    }

    private Source<Object, NotUsed> deleteBy(PersistenceId persistenceId, Seq<SequenceNumber> sequenceNrs) {
        return sequenceNrs.isEmpty() ? Source$.MODULE$.empty() : (this.pluginConfig.queueEnable() ? Source$.MODULE$.single(sequenceNrs.map((Function1 & Serializable)snr -> new PersistenceIdWithSeqNr(persistenceId, (SequenceNumber)snr))).via(this.requestDeleteJournalRows()) : Source$.MODULE$.single(sequenceNrs.map((Function1 & Serializable)snr -> new PersistenceIdWithSeqNr(persistenceId, (SequenceNumber)snr))).via(this.requestDeleteJournalRowsPassThrough()));
    }

    private Flow<Seq<PersistenceIdWithSeqNr>, Object, NotUsed> requestDeleteJournalRowsPassThrough() {
        return (Flow)Flow$.MODULE$.apply().mapAsync(this.writeParallelism(), (Function1 & Serializable)messages -> {
            Promise promise = Promise$.MODULE$.apply();
            return this.internalDeleteStream((Promise<Object>)promise, (Seq<PersistenceIdWithSeqNr>)messages).flatMap((Function1 & Serializable)x$17 -> promise.future(), this.ec());
        });
    }

    private Flow<Seq<PersistenceIdWithSeqNr>, Object, NotUsed> requestDeleteJournalRows() {
        return ((Flow)Flow$.MODULE$.apply().mapAsync(this.writeParallelism(), (Function1 & Serializable)messages -> {
            Promise promise = Promise$.MODULE$.apply();
            return this.selectDeleteQueue(((PersistenceIdWithSeqNr)messages.head()).persistenceId()).offer((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)promise), messages)).flatMap((Function1 & Serializable)x0$1 -> {
                Future future;
                QueueOfferResult queueOfferResult = x0$1;
                if (QueueOfferResult.Enqueued$.MODULE$.equals(queueOfferResult)) {
                    Future future2;
                    future = future2 = promise.future();
                } else if (queueOfferResult instanceof QueueOfferResult.Failure) {
                    QueueOfferResult.Failure failure = (QueueOfferResult.Failure)queueOfferResult;
                    Throwable t = failure.cause();
                    future = Future$.MODULE$.failed((Throwable)new Exception("Failed to write journal row batch", t));
                } else if (QueueOfferResult.Dropped$.MODULE$.equals(queueOfferResult)) {
                    future = Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(129).append("Failed to enqueue journal row batch write, the queue buffer was full (").append(this.queueBufferSize()).append(" elements) please check the jdbc-journal.bufferSize setting").toString()));
                } else if (QueueOfferResult.QueueClosed$.MODULE$.equals(queueOfferResult)) {
                    future = Future$.MODULE$.failed((Throwable)new Exception("Failed to enqueue journal row batch write, the queue was closed"));
                } else {
                    throw new MatchError((Object)queueOfferResult);
                }
                return future;
            }, this.ec());
        })).withAttributes(this.logLevels());
    }

    public static final /* synthetic */ Tuple2 $anonfun$putQueues$1(WriteJournalDaoImpl $this, int x$6) {
        int n = x$6;
        Tuple2<SourceQueueWithComplete<Tuple2<Promise<Object>, Seq<JournalRow>>>, UniqueKillSwitch> tuple2 = $this.putQueue();
        return tuple2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$deleteQueues$1(WriteJournalDaoImpl $this, int x$12) {
        int n = x$12;
        Tuple2<SourceQueueWithComplete<Tuple2<Promise<Object>, Seq<PersistenceIdWithSeqNr>>>, UniqueKillSwitch> tuple2 = $this.deleteQueue();
        return tuple2;
    }

    public static final /* synthetic */ void $anonfun$dispose$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        UniqueKillSwitch sw = (UniqueKillSwitch)tuple2._2();
        sw.shutdown();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$dispose$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        UniqueKillSwitch sw = (UniqueKillSwitch)tuple2._2();
        sw.shutdown();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple2 $anonfun$deleteMessages$3(Seq journalRows$1, long result) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)result), (Object)journalRows$1);
    }

    public static final /* synthetic */ Source $anonfun$deleteMessages$5(WriteJournalDaoImpl $this, PersistenceId persistenceId$1, Seq journalRows$2, long highestMarkedSequenceNr) {
        return (Source)$this.journalRowDriver().getJournalRows(persistenceId$1, new SequenceNumber(highestMarkedSequenceNr - 1L), false).flatMapConcat((Function1 & Serializable)x$14 -> $this.deleteBy(persistenceId$1, (Seq<SequenceNumber>)((Seq)journalRows$2.map((Function1 & Serializable)x$15 -> x$15.sequenceNumber()))));
    }

    public WriteJournalDaoImpl(JournalPluginConfig pluginConfig, JournalRowWriteDriver journalRowDriver, FlowPersistentReprSerializer<JournalRow> serializer, Option<MetricsReporter> metricsReporter, ExecutionContext ec, ActorSystem system) {
        OverflowStrategy overflowStrategy;
        OverflowStrategy overflowStrategy2;
        this.pluginConfig = pluginConfig;
        this.journalRowDriver = journalRowDriver;
        this.serializer = serializer;
        this.metricsReporter = metricsReporter;
        this.ec = ec;
        DaoSupport.$init$(this);
        this.mat = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)system);
        LoggerFactory.getLogger(this.getClass());
        this.queueBufferSize = pluginConfig.queueEnable() ? pluginConfig.queueBufferSize() : 0;
        this.queueParallelism = pluginConfig.queueEnable() ? pluginConfig.queueParallelism() : 0;
        this.writeParallelism = pluginConfig.writeParallelism();
        int x$1 = Attributes.LogLevels$.MODULE$.Debug();
        int x$2 = Attributes.LogLevels$.MODULE$.Error();
        int x$3 = Attributes.LogLevels$.MODULE$.Debug();
        this.logLevels = Attributes$.MODULE$.logLevels(x$1, x$3, x$2);
        String string = pluginConfig.queueOverflowStrategy().toLowerCase();
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        String string2 = string;
        String string3 = OverflowStrategy$.MODULE$.dropHead().getClass().getSimpleName().toLowerCase();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            overflowStrategy2 = OverflowStrategy$.MODULE$.dropHead();
        } else {
            String string4 = string;
            String string5 = OverflowStrategy$.MODULE$.dropTail().getClass().getSimpleName().toLowerCase();
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                overflowStrategy2 = OverflowStrategy$.MODULE$.dropTail();
            } else {
                String string6 = string;
                String string7 = OverflowStrategy$.MODULE$.dropBuffer().getClass().getSimpleName().toLowerCase();
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    overflowStrategy2 = OverflowStrategy$.MODULE$.dropBuffer();
                } else {
                    String string8 = string;
                    String string9 = OverflowStrategy$.MODULE$.dropNew().getClass().getSimpleName().toLowerCase();
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        overflowStrategy2 = OverflowStrategy$.MODULE$.dropNew();
                    } else {
                        String string10 = string;
                        String string11 = OverflowStrategy$.MODULE$.fail().getClass().getSimpleName().toLowerCase();
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            overflowStrategy2 = OverflowStrategy$.MODULE$.fail();
                        } else {
                            String string12 = string;
                            String string13 = OverflowStrategy$.MODULE$.backpressure().getClass().getSimpleName().toLowerCase();
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                overflowStrategy2 = OverflowStrategy$.MODULE$.backpressure();
                            } else {
                                throw new IllegalArgumentException("queueOverflowStrategy is invalid");
                            }
                        }
                    }
                }
            }
        }
        this.queueOverflowStrategy = overflowStrategy = overflowStrategy2;
        this.putQueues = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.queueParallelism()).map((Function1 & Serializable)x$6 -> WriteJournalDaoImpl.$anonfun$putQueues$1(this, BoxesRunTime.unboxToInt((Object)x$6)));
        this.deleteQueues = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.queueParallelism()).map((Function1 & Serializable)x$12 -> WriteJournalDaoImpl.$anonfun$deleteQueues$1(this, BoxesRunTime.unboxToInt((Object)x$12)));
    }
}

