/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.journal;

import com.github.j5ik2o.akka.persistence.dynamodb.config.JournalPluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.PartitionKey;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.PersistenceIdOps;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.ToPersistenceIdOps;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId$;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import net.ceedubs.ficus.Ficus$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000594q!\u0005\n\u0011\u0002G\u0005\u0011\u0005C\u0003)\u0001\u0019\u0005\u0011fB\u0003<%!\u0005AHB\u0003\u0012%!\u0005Q\bC\u0003?\u0007\u0011\u0005qH\u0002\u0003A\u0007\u0001\t\u0005\u0002C$\u0006\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000by*A\u0011A*\u0007\t\u0011\u001b\u0001!\u0012\u0005\t\u000f\"\u0011\t\u0011)A\u0005\u0011\")a\b\u0003C\u0001\u001d\")\u0001\u0006\u0003C!!\u001a!ak\u0001\u0001X\u0011!9EB!A!\u0002\u0013A\u0005\"\u0002 \r\t\u0003Y\u0006\"\u00020\r\t\u0003z\u0006\"\u0002\u0015\r\t\u0003Z'\u0001\u0006)beRLG/[8o\u0017\u0016L(+Z:pYZ,'O\u0003\u0002\u0014)\u00059!n\\;s]\u0006d'BA\u000b\u0017\u0003!!\u0017P\\1n_\u0012\u0014'BA\f\u0019\u0003-\u0001XM]:jgR,gnY3\u000b\u0005eQ\u0012\u0001B1lW\u0006T!a\u0007\u000f\u0002\r),\u0014n\u001b\u001ap\u0015\tib$\u0001\u0004hSRDWO\u0019\u0006\u0002?\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0002\u000fI,7o\u001c7wKR\u0019!F\f\u001c\u0011\u0005-bS\"\u0001\n\n\u00055\u0012\"\u0001\u0004)beRLG/[8o\u0017\u0016L\b\"B\u0018\u0002\u0001\u0004\u0001\u0014!\u00049feNL7\u000f^3oG\u0016LE\r\u0005\u00022i5\t!G\u0003\u00024)\u0005)Qn\u001c3fY&\u0011QG\r\u0002\u000e!\u0016\u00148/[:uK:\u001cW-\u00133\t\u000b]\n\u0001\u0019\u0001\u001d\u0002\u001dM,\u0017/^3oG\u0016tU/\u001c2feB\u0011\u0011'O\u0005\u0003uI\u0012abU3rk\u0016t7-\u001a(v[\n,'/\u0001\u000bQCJ$\u0018\u000e^5p].+\u0017PU3t_24XM\u001d\t\u0003W\r\u0019\"a\u0001\u0012\u0002\rqJg.\u001b;?)\u0005a$a\u0002#fM\u0006,H\u000e^\n\u0003\u000b\t\u0003\"a\u0011\u0005\u000e\u0003\r\u00111cU3rk\u0016t7-\u001a(v[\n,'OQ1tK\u0012\u001c2\u0001\u0003\u0012G!\tY\u0003!A\nk_V\u0014h.\u00197QYV<\u0017N\\\"p]\u001aLw\r\u0005\u0002J\u00196\t!J\u0003\u0002L)\u000511m\u001c8gS\u001eL!!\u0014&\u0003'){WO\u001d8bYBcWoZ5o\u0007>tg-[4\u0015\u0005\t{\u0005\"B$\u000b\u0001\u0004AEc\u0001\u0016R%\")qf\u0003a\u0001a!)qg\u0003a\u0001qQ\u0011A+\u0016\t\u0003\u0007\u0016AQaR\u0004A\u0002!\u0013!\u0003U3sg&\u001cH/\u001a8dK&#')Y:fIN!AB\t$Y!\tY\u0013,\u0003\u0002[%\t\u0011Bk\u001c)feNL7\u000f^3oG\u0016LEm\u00149t)\taV\f\u0005\u0002D\u0019!)qI\u0004a\u0001\u0011\u0006I1/\u001a9be\u0006$xN]\u000b\u0002AB\u0011\u0011\r\u001b\b\u0003E\u001a\u0004\"a\u0019\u0013\u000e\u0003\u0011T!!\u001a\u0011\u0002\rq\u0012xn\u001c;?\u0013\t9G%\u0001\u0004Qe\u0016$WMZ\u0005\u0003S*\u0014aa\u0015;sS:<'BA4%)\rQC.\u001c\u0005\u0006_A\u0001\r\u0001\r\u0005\u0006oA\u0001\r\u0001\u000f")
public interface PartitionKeyResolver {
    public PartitionKey resolve(PersistenceId var1, SequenceNumber var2);

    public static class Default
    extends SequenceNumberBased {
        public Default(JournalPluginConfig journalPluginConfig) {
            super(journalPluginConfig);
        }
    }

    public static class PersistenceIdBased
    implements PartitionKeyResolver,
    ToPersistenceIdOps {
        private final JournalPluginConfig journalPluginConfig;

        @Override
        public PersistenceIdOps ToPersistenceIdOps(PersistenceId self) {
            return ToPersistenceIdOps.ToPersistenceIdOps$(this, self);
        }

        @Override
        public String separator() {
            return (String)Ficus$.MODULE$.toFicusConfig(this.journalPluginConfig.sourceConfig()).getOrElse("persistence-id-separator", (Function0 & Serializable)() -> PersistenceId$.MODULE$.Separator(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        }

        @Override
        public PartitionKey resolve(PersistenceId persistenceId, SequenceNumber sequenceNumber) {
            String string;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            DecimalFormat df = new DecimalFormat("0000000000000000000000000000000000000000");
            byte[] bytes = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(persistenceId.asString())).getBytes(StandardCharsets.UTF_8);
            BigInt hash = package$.MODULE$.BigInt().apply(md5.digest(bytes));
            BigInt mod = hash.abs().$percent(BigInt$.MODULE$.int2bigInt(this.journalPluginConfig.shardCount())).$plus(BigInt$.MODULE$.int2bigInt(1));
            Option<String> modelNameOpt = this.ToPersistenceIdOps(persistenceId).prefix();
            Option<String> option = modelNameOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                String modelName = (String)some.value();
                string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{modelName, df.format(mod)}));
            } else if (None$.MODULE$.equals(option)) {
                string = df.format(mod);
            } else {
                throw new MatchError(option);
            }
            String pkey = string;
            return new PartitionKey(pkey);
        }

        public PersistenceIdBased(JournalPluginConfig journalPluginConfig) {
            this.journalPluginConfig = journalPluginConfig;
            ToPersistenceIdOps.$init$(this);
        }
    }

    public static class SequenceNumberBased
    implements PartitionKeyResolver {
        private final JournalPluginConfig journalPluginConfig;

        @Override
        public PartitionKey resolve(PersistenceId persistenceId, SequenceNumber sequenceNumber) {
            String pkey = new StringBuilder(1).append(persistenceId.asString()).append("-").append(sequenceNumber.value() % (long)this.journalPluginConfig.shardCount()).toString();
            return new PartitionKey(pkey);
        }

        public SequenceNumberBased(JournalPluginConfig journalPluginConfig) {
            this.journalPluginConfig = journalPluginConfig;
        }
    }
}

