/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.v2;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.Attributes;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.JournalPluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.JournalRow;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowWriteDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.PersistenceIdWithSeqNr;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.v2.V2JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\r\u001b\u00055B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005u!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003B\u0011!\u0011\u0006A!b\u0001\n\u0003\u0019\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u000be\u0003A\u0011\u0001.\t\u000b\u0001\u0004A\u0011I1\t\u000f%\u0004!\u0019!C\u0005U\"11\u000f\u0001Q\u0001\n-Dq\u0001\u001e\u0001C\u0002\u0013%Q\u000f\u0003\u0004~\u0001\u0001\u0006IA\u001e\u0005\b}\u0002\u0011\r\u0011\"\u0003\u0000\u0011!\t9\u0001\u0001Q\u0001\n\u0005\u0005\u0001bBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003'\u0001A\u0011IA\u000b\u0011%\tI\u0007AI\u0001\n\u0003\tY\u0007C\u0004\u0002\u0014\u0001!\t%!!\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\"9\u00111\u0017\u0001\u0005B\u0005U\u0006bBAb\u0001\u0011\u0005\u0013Q\u0019\u0005\b\u0003\u001b\u0004A\u0011IAh\u0011\u001d\t\u0019\u000e\u0001C!\u0003+Dq!a7\u0001\t\u0003\niNA\fWe){WO\u001d8bYJ{wo\u0016:ji\u0016$%/\u001b<fe*\u00111\u0004H\u0001\u0003mJR!!\b\u0010\u0002\u0007\u0011\fwN\u0003\u0002 A\u00059!n\\;s]\u0006d'BA\u0011#\u0003!!\u0017P\\1n_\u0012\u0014'BA\u0012%\u0003-\u0001XM]:jgR,gnY3\u000b\u0005\u00152\u0013\u0001B1lW\u0006T!a\n\u0015\u0002\r),\u0014n\u001b\u001ap\u0015\tI#&\u0001\u0004hSRDWO\u0019\u0006\u0002W\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g!\t)d'D\u0001\u001d\u0013\t9DDA\u000bK_V\u0014h.\u00197S_^<&/\u001b;f\tJLg/\u001a:\u0002\u001bAdWoZ5o\u0007>tG/\u001a=u+\u0005Q\u0004CA\u001e=\u001b\u0005q\u0012BA\u001f\u001f\u0005QQu.\u001e:oC2\u0004F.^4j]\u000e{g\u000e^3yi\u0006q\u0001\u000f\\;hS:\u001cuN\u001c;fqR\u0004\u0013aC1ts:\u001c7\t\\5f]R,\u0012!\u0011\t\u0004_\t#\u0015BA\"1\u0005\u0019y\u0005\u000f^5p]B\u0011QiT\u0007\u0002\r*\u0011\u0011e\u0012\u0006\u0003\u0011&\u000b\u0001b]3sm&\u001cWm\u001d\u0006\u0003\u0015.\u000ba!Y<tg\u0012\\'B\u0001'N\u0003\u0019\tW.\u0019>p]*\ta*\u0001\u0005t_\u001a$x/\u0019:f\u0013\t\u0001fIA\nEs:\fWn\u001c#c\u0003NLhnY\"mS\u0016tG/\u0001\u0007bgft7m\u00117jK:$\b%\u0001\u0006ts:\u001c7\t\\5f]R,\u0012\u0001\u0016\t\u0004_\t+\u0006CA#W\u0013\t9fI\u0001\bEs:\fWn\u001c#c\u00072LWM\u001c;\u0002\u0017MLhnY\"mS\u0016tG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tmkfl\u0018\t\u00039\u0002i\u0011A\u0007\u0005\u0006q\u001d\u0001\rA\u000f\u0005\u0006\u007f\u001d\u0001\r!\u0011\u0005\u0006%\u001e\u0001\r\u0001V\u0001\u0007gf\u001cH/Z7\u0016\u0003\t\u0004\"aY4\u000e\u0003\u0011T!!\u001a4\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003\u0015J!\u0001\u001b3\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\\\u0001\u0007Y><w-\u001a:\u0016\u0003-\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u000bMdg\r\u000e6\u000b\u0003A\f1a\u001c:h\u0013\t\u0011XN\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u00031\u0019HO]3b[\u000ec\u0017.\u001a8u+\u00051\bCA<|\u001b\u0005A(BA\u000ez\u0015\tQ\b%\u0001\u0004dY&,g\u000e^\u0005\u0003yb\u0014\u0011c\u0015;sK\u0006lwK]5uK\u000ec\u0017.\u001a8u\u00035\u0019HO]3b[\u000ec\u0017.\u001a8uA\u0005Q!/Z1e\tJLg/\u001a:\u0016\u0005\u0005\u0005\u0001c\u0001/\u0002\u0004%\u0019\u0011Q\u0001\u000e\u0003-Y\u0013$j\\;s]\u0006d'k\\<SK\u0006$GI]5wKJ\f1B]3bI\u0012\u0013\u0018N^3sA\u00059A-[:q_N,GCAA\u0007!\ry\u0013qB\u0005\u0004\u0003#\u0001$\u0001B+oSR\fabZ3u\u0015>,(O\\1m%><8\u000f\u0006\u0007\u0002\u0018\u0005U\u0012QIA(\u0003'\ni\u0006\u0005\u0005\u0002\u001a\u0005\r\u0012qEA\u0017\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011\u0001C:dC2\fGm\u001d7\u000b\u0007\u0005\u0005b-\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003K\tYB\u0001\u0004T_V\u00148-\u001a\t\u0004w\u0005%\u0012bAA\u0016=\tQ!j\\;s]\u0006d'k\\<\u0011\t\u0005=\u0012\u0011G\u0007\u0002M&\u0019\u00111\u00074\u0003\u000f9{G/V:fI\"9\u0011q\u0007\tA\u0002\u0005e\u0012!\u00049feNL7\u000f^3oG\u0016LE\r\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\ty\u0004I\u0001\u0006[>$W\r\\\u0005\u0005\u0003\u0007\niDA\u0007QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\n\u001a\u0005\b\u0003\u000f\u0002\u0002\u0019AA%\u000391'o\\7TKF,XM\\2f\u001dJ\u0004B!a\u000f\u0002L%!\u0011QJA\u001f\u00059\u0019V-];f]\u000e,g*^7cKJDq!!\u0015\u0011\u0001\u0004\tI%\u0001\u0007u_N+\u0017/^3oG\u0016t%\u000fC\u0004\u0002VA\u0001\r!a\u0016\u0002\u00075\f\u0007\u0010E\u00020\u00033J1!a\u00171\u0005\u0011auN\\4\t\u0013\u0005}\u0003\u0003%AA\u0002\u0005\u0005\u0014a\u00023fY\u0016$X\r\u001a\t\u0005_\t\u000b\u0019\u0007E\u00020\u0003KJ1!a\u001a1\u0005\u001d\u0011un\u001c7fC:\f\u0001dZ3u\u0015>,(O\\1m%><8\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tiG\u000b\u0003\u0002b\u0005=4FAA9!\u0011\t\u0019(! \u000e\u0005\u0005U$\u0002BA<\u0003s\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m\u0004'\u0001\u0006b]:|G/\u0019;j_:LA!a \u0002v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0015\u0011\u0005\r\u0015QTAP\u0003C\u0003\u0002\"!\u0007\u0002$\u0005\u0015\u0015Q\u0006\t\u0007\u0003\u000f\u000b9*a\n\u000f\t\u0005%\u00151\u0013\b\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011q\u0012\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014bAAKa\u00059\u0001/Y2lC\u001e,\u0017\u0002BAM\u00037\u00131aU3r\u0015\r\t)\n\r\u0005\b\u0003o\u0011\u0002\u0019AA\u001d\u0011\u001d\t\tF\u0005a\u0001\u0003\u0013Bq!a\u0018\u0013\u0001\u0004\t\u0019'A\tiS\u001eDWm\u001d;TKF,XM\\2f\u001dJ$\u0002\"a*\u0002,\u00065\u0016\u0011\u0017\t\t\u00033\t\u0019#!+\u0002.A!qFQA,\u0011\u001d\t9d\u0005a\u0001\u0003sA\u0011\"a\u0012\u0014!\u0003\u0005\r!a,\u0011\t=\u0012\u0015\u0011\n\u0005\n\u0003?\u001a\u0002\u0013!a\u0001\u0003C\n!d]5oO2,G)\u001a7fi\u0016Tu.\u001e:oC2\u0014vn\u001e$m_^,\"!a.\u0011\u0015\u0005e\u0011\u0011XA_\u0003/\ni#\u0003\u0003\u0002<\u0006m!\u0001\u0002$m_^\u00042!NA`\u0013\r\t\t\r\b\u0002\u0017!\u0016\u00148/[:uK:\u001cW-\u00133XSRD7+Z9Oe\u0006iQ\u000f\u001d3bi\u0016lUm]:bO\u0016$B!a2\u0002JBA\u0011\u0011DA\u0012\u0003\u001b\ti\u0003C\u0004\u0002LV\u0001\r!a\n\u0002\u0015)|WO\u001d8bYJ{w/A\ftS:<G.\u001a)vi*{WO\u001d8bYJ{wO\u00127poV\u0011\u0011\u0011\u001b\t\u000b\u00033\tI,a\n\u0002X\u00055\u0012AG7vYRLG)\u001a7fi\u0016Tu.\u001e:oC2\u0014vn^:GY><XCAAl!)\tI\"!/\u0002Z\u0006]\u0013Q\u0006\t\u0007\u0003\u000f\u000b9*!0\u0002/5,H\u000e^5QkRTu.\u001e:oC2\u0014vn^:GY><XCAAp!)\tI\"!/\u0002\u0006\u0006]\u0013Q\u0006")
public final class V2JournalRowWriteDriver
implements JournalRowWriteDriver {
    private final JournalPluginContext pluginContext;
    private final Option<DynamoDbAsyncClient> asyncClient;
    private final Option<DynamoDbClient> syncClient;
    private final Logger logger;
    private final StreamWriteClient streamClient;
    private final V2JournalRowReadDriver readDriver;
    private final Attributes logLevels;

    public Option<SequenceNumber> highestSequenceNr$default$2() {
        return JournalRowReadDriver.highestSequenceNr$default$2$((JournalRowReadDriver)this);
    }

    public Option<Object> highestSequenceNr$default$3() {
        return JournalRowReadDriver.highestSequenceNr$default$3$((JournalRowReadDriver)this);
    }

    public Attributes logLevels() {
        return this.logLevels;
    }

    public void com$github$j5ik2o$akka$persistence$dynamodb$journal$dao$JournalRowDriver$_setter_$logLevels_$eq(Attributes x$1) {
        this.logLevels = x$1;
    }

    public JournalPluginContext pluginContext() {
        return this.pluginContext;
    }

    public Option<DynamoDbAsyncClient> asyncClient() {
        return this.asyncClient;
    }

    public Option<DynamoDbClient> syncClient() {
        return this.syncClient;
    }

    public ActorSystem system() {
        return this.pluginContext().system();
    }

    private Logger logger() {
        return this.logger;
    }

    private StreamWriteClient streamClient() {
        return this.streamClient;
    }

    private V2JournalRowReadDriver readDriver() {
        return this.readDriver;
    }

    public void dispose() {
        Option option;
        Option option2;
        Tuple2 tuple2 = new Tuple2(this.asyncClient(), this.syncClient());
        if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option2;
            DynamoDbAsyncClient a = (DynamoDbAsyncClient)some.value();
            a.close();
            return;
        }
        if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            DynamoDbClient s = (DynamoDbClient)some.value();
            s.close();
            return;
        }
    }

    public Source<JournalRow, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber fromSequenceNr, SequenceNumber toSequenceNr, long max, Option<Object> deleted) {
        return this.readDriver().getJournalRows(persistenceId, fromSequenceNr, toSequenceNr, max, deleted);
    }

    public Source<Seq<JournalRow>, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber toSequenceNr, boolean deleted) {
        return this.readDriver().getJournalRows(persistenceId, toSequenceNr, deleted);
    }

    public Option<Object> getJournalRows$default$5() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Source<Option<Object>, NotUsed> highestSequenceNr(PersistenceId persistenceId, Option<SequenceNumber> fromSequenceNr, Option<Object> deleted) {
        return this.readDriver().highestSequenceNr(persistenceId, fromSequenceNr, deleted);
    }

    public Flow<PersistenceIdWithSeqNr, Object, NotUsed> singleDeleteJournalRowFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable & scala.Serializable)persistenceIdWithSeqNr -> {
            String pkey = this.pluginContext().partitionKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
            String skey = this.pluginContext().sortKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
            DeleteItemRequest deleteRequest = (DeleteItemRequest)DeleteItemRequest.builder().key((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName()), AttributeValue.builder().s(pkey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName()), AttributeValue.builder().s(skey).build())}))).asJava()).build();
            return (Source)Source$.MODULE$.single((Object)deleteRequest).via((Graph)this.streamClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
                if (response.sdkHttpResponse().isSuccessful()) {
                    return Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)1L));
                }
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            });
        });
    }

    public Source<BoxedUnit, NotUsed> updateMessage(JournalRow journalRow) {
        String pkey = journalRow.partitionKey(this.pluginContext().partitionKeyResolver()).asString();
        String skey = journalRow.sortKey(this.pluginContext().sortKeyResolver()).asString();
        UpdateItemRequest updateRequest = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.pluginContext().pluginConfig().tableName()).key((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName()), AttributeValue.builder().s(pkey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName()), AttributeValue.builder().s(skey).build())}))).asJava()).attributeUpdates((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().messageColumnName()), AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])journalRow.message())).build()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName()), AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().n(Long.toString(journalRow.ordering())).build()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName()), AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().bool(Predef$.MODULE$.boolean2Boolean(journalRow.deleted())).build()).build())}))).$plus$plus((GenTraversableOnce)journalRow.tags().map((Function1 & Serializable & scala.Serializable)tag -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName()), AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().s(tag).build()).build())}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava()).build();
        return ((Source)Source$.MODULE$.single((Object)updateRequest).via((Graph)this.streamClient().updateItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
            if (response.sdkHttpResponse().isSuccessful()) {
                return Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            }
            int statusCode = response.sdkHttpResponse().statusCode();
            Optional statusText = response.sdkHttpResponse().statusText();
            return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
        })).withAttributes(this.logLevels());
    }

    public Flow<JournalRow, Object, NotUsed> singlePutJournalRowFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable & scala.Serializable)journalRow -> {
            String pkey = this.pluginContext().partitionKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
            String skey = this.pluginContext().sortKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
            PutItemRequest request = (PutItemRequest)PutItemRequest.builder().tableName(this.pluginContext().pluginConfig().tableName()).item((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName()), AttributeValue.builder().s(pkey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName()), AttributeValue.builder().s(skey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(journalRow.persistenceId().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(journalRow.sequenceNumber().asString()).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName()), AttributeValue.builder().n(Long.toString(journalRow.ordering())).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName()), AttributeValue.builder().bool(Predef$.MODULE$.boolean2Boolean(journalRow.deleted())).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().messageColumnName()), AttributeValue.builder().b(SdkBytes.fromByteArray((byte[])journalRow.message())).build())}))).$plus$plus((GenTraversableOnce)journalRow.tags().map((Function1 & Serializable & scala.Serializable)tag -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName()), AttributeValue.builder().s(tag).build())}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava()).build();
            return (Source)Source$.MODULE$.single((Object)request).via((Graph)this.streamClient().putItemFlow()).flatMapConcat((Function1 & Serializable & scala.Serializable)response -> {
                if (response.sdkHttpResponse().isSuccessful()) {
                    return Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)1L));
                }
                int statusCode = response.sdkHttpResponse().statusCode();
                Optional statusText = response.sdkHttpResponse().statusText();
                return Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).append(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(statusText)).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)s -> new StringBuilder(2).append(", ").append((String)s).toString())).toString()));
            });
        });
    }

    public Flow<Seq<PersistenceIdWithSeqNr>, Object, NotUsed> multiDeleteJournalRowsFlow() {
        return ((Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable & scala.Serializable)persistenceIdWithSeqNrs -> {
            ((IterableLike)persistenceIdWithSeqNrs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                PersistenceIdWithSeqNr persistenceIdWithSeqNr = x0$1;
                if (persistenceIdWithSeqNr != null) {
                    PersistenceId pid = persistenceIdWithSeqNr.persistenceId();
                    SequenceNumber seqNr = persistenceIdWithSeqNr.sequenceNumber();
                    return new StringBuilder(16).append("pid = ").append(pid).append(", seqNr = ").append(seqNr).toString();
                }
                throw new MatchError((Object)persistenceIdWithSeqNr);
            }, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                V2JournalRowWriteDriver.$anonfun$multiDeleteJournalRowsFlow$3(this, x$1);
                return BoxedUnit.UNIT;
            });
            if (persistenceIdWithSeqNrs.isEmpty()) {
                return Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L));
            }
            return (Source)Source$.MODULE$.single(persistenceIdWithSeqNrs.map((Function1 & Serializable & scala.Serializable)persistenceIdWithSeqNr -> {
                String pkey = this.pluginContext().partitionKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
                String skey = this.pluginContext().sortKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
                return (WriteRequest)WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName()), AttributeValue.builder().s(pkey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName()), AttributeValue.builder().s(skey).build())}))).asJava()).build()).build();
            }, Seq$.MODULE$.canBuildFrom())).flatMapConcat((Function1 & Serializable & scala.Serializable)requestItems -> (Source)Source$.MODULE$.single(BatchWriteItemRequest.builder().requestItems((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().tableName()), CollectionConverters$.MODULE$.seqAsJavaListConverter(requestItems).asJava())}))).asJava()).build()).via((Graph)this.streamClient().recursiveBatchWriteItemFlow()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)requestItems.size())));
        })).withAttributes(this.logLevels());
    }

    public Flow<Seq<JournalRow>, Object, NotUsed> multiPutJournalRowsFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable & scala.Serializable)journalRows -> {
            if (journalRows.isEmpty()) {
                return Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L));
            }
            Predef$.MODULE$.require(journalRows.size() == journalRows.toSet().size(), (Function0 & Serializable & scala.Serializable)() -> "journalRows: keys contains duplicates");
            Seq journalRowWithPKeyWithSKeys = (Seq)journalRows.map((Function1 & Serializable & scala.Serializable)journalRow -> {
                String pkey = this.pluginContext().partitionKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
                String skey = this.pluginContext().sortKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
                return new Tuple3(journalRow, (Object)pkey, (Object)skey);
            }, Seq$.MODULE$.canBuildFrom());
            this.logger().debug(new StringBuilder(55).append("multiPutJournalRowsFlow: journalRowWithPKeyWithSKeys = ").append(journalRowWithPKeyWithSKeys.mkString("\n", ",\n", "\n")).toString());
            Predef$.MODULE$.require(((TraversableOnce)journalRowWithPKeyWithSKeys.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple3 tuple3 = x0$1;
                if (tuple3 != null) {
                    String p = (String)tuple3._2();
                    String s = (String)tuple3._3();
                    return new Tuple2((Object)p, (Object)s);
                }
                throw new MatchError((Object)tuple3);
            }, Seq$.MODULE$.canBuildFrom())).toSet().size() == journalRows.size(), (Function0 & Serializable & scala.Serializable)() -> "journalRowWithPKeyWithSKeys: keys contains duplicates");
            return ((Source)Source$.MODULE$.single(journalRowWithPKeyWithSKeys.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 != null) {
                    JournalRow journalRow = (JournalRow)tuple3._1();
                    String pkey = (String)tuple3._2();
                    String skey = (String)tuple3._3();
                    String pid = journalRow.persistenceId().asString();
                    String seqNr = journalRow.sequenceNumber().asString();
                    String ordering = Long.toString(journalRow.ordering());
                    boolean deleted = journalRow.deleted();
                    SdkBytes message = SdkBytes.fromByteArray((byte[])journalRow.message());
                    Option tagsOpt = journalRow.tags();
                    return (WriteRequest)WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName()), AttributeValue.builder().s(pkey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName()), AttributeValue.builder().s(skey).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName()), AttributeValue.builder().s(pid).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName()), AttributeValue.builder().n(seqNr).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName()), AttributeValue.builder().n(ordering).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName()), AttributeValue.builder().bool(Predef$.MODULE$.boolean2Boolean(deleted)).build()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().messageColumnName()), AttributeValue.builder().b(message).build())}))).$plus$plus((GenTraversableOnce)tagsOpt.map((Function1 & Serializable & scala.Serializable)tags -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName()), AttributeValue.builder().s(tags).build())}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava()).build()).build();
                }
                throw new MatchError((Object)tuple3);
            }, Seq$.MODULE$.canBuildFrom())).flatMapConcat((Function1 & Serializable & scala.Serializable)requestItems -> (Source)Source$.MODULE$.single(BatchWriteItemRequest.builder().requestItems((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().tableName()), CollectionConverters$.MODULE$.seqAsJavaListConverter(requestItems).asJava())}))).asJava()).build()).via((Graph)this.streamClient().recursiveBatchWriteItemFlow()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)requestItems.size())))).withAttributes(this.logLevels());
        });
    }

    public static final /* synthetic */ void $anonfun$multiDeleteJournalRowsFlow$3(V2JournalRowWriteDriver $this, String x$1) {
        $this.logger().debug(x$1);
    }

    public V2JournalRowWriteDriver(JournalPluginContext pluginContext, Option<DynamoDbAsyncClient> asyncClient, Option<DynamoDbClient> syncClient) {
        this.pluginContext = pluginContext;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        JournalRowDriver.$init$((JournalRowDriver)this);
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.streamClient = new StreamWriteClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().writeBackoffConfig());
        this.readDriver = new V2JournalRowReadDriver(pluginContext, asyncClient, syncClient);
    }
}

