/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.v1;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.stream.Attributes;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v1.StreamWriteClient;
import com.github.j5ik2o.akka.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.JournalPluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.JournalRow;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.JournalRowWriteDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.PersistenceIdWithSeqNr;
import com.github.j5ik2o.akka.persistence.dynamodb.journal.dao.v1.V1JournalRowReadDriver;
import com.github.j5ik2o.akka.persistence.dynamodb.model.PersistenceId;
import com.github.j5ik2o.akka.persistence.dynamodb.model.SequenceNumber;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001B\r\u001b\u00055B\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005u!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003B\u0011!y\u0005A!b\u0001\n\u0003\u0001\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u000bY\u0003A\u0011A,\t\u000bu\u0003A\u0011\t0\t\u000f\u0019\u0004!\u0019!C\u0005O\"1\u0001\u000f\u0001Q\u0001\n!Dq!\u001d\u0001C\u0002\u0013%!\u000f\u0003\u0004{\u0001\u0001\u0006Ia\u001d\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0011\u001d\t\t\u0001\u0001Q\u0001\nuDq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002\u000e\u0001!\t%a\u0004\t\u000f\u00055\u0001\u0001\"\u0011\u0002l!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\b\u0003;\u0003A\u0011IAP\u0011\u001d\ti\u000b\u0001C!\u0003_Cq!a.\u0001\t\u0003\nI\fC\u0004\u0002>\u0002!\t%a0\t\u000f\u0005-\u0007\u0001\"\u0011\u0002N\"9\u0011\u0011\u001b\u0001\u0005B\u0005M'a\u0006,2\u0015>,(O\\1m%><xK]5uK\u0012\u0013\u0018N^3s\u0015\tYB$\u0001\u0002wc)\u0011QDH\u0001\u0004I\u0006|'BA\u0010!\u0003\u001dQw.\u001e:oC2T!!\t\u0012\u0002\u0011\u0011Lh.Y7pI\nT!a\t\u0013\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003K\u0019\nA!Y6lC*\u0011q\u0005K\u0001\u0007UVJ7NM8\u000b\u0005%R\u0013AB4ji\",(MC\u0001,\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U2T\"\u0001\u000f\n\u0005]b\"!\u0006&pkJt\u0017\r\u001c*po^\u0013\u0018\u000e^3Ee&4XM]\u0001\u000ea2,x-\u001b8D_:$X\r\u001f;\u0016\u0003i\u0002\"a\u000f\u001f\u000e\u0003yI!!\u0010\u0010\u0003)){WO\u001d8bYBcWoZ5o\u0007>tG/\u001a=u\u00039\u0001H.^4j]\u000e{g\u000e^3yi\u0002\n1\"Y:z]\u000e\u001cE.[3oiV\t\u0011\tE\u00020\u0005\u0012K!a\u0011\u0019\u0003\r=\u0003H/[8o!\t)E*D\u0001G\u0015\t9\u0005*\u0001\u0006es:\fWn\u001c3cmJR!!\u0013&\u0002\u0011M,'O^5dKNT!a\u0013\u0016\u0002\u0013\u0005l\u0017M_8oC^\u001c\u0018BA'G\u0005M\tU.\u0019>p]\u0012Kh.Y7p\t\n\u000b5/\u001f8d\u00031\t7/\u001f8d\u00072LWM\u001c;!\u0003)\u0019\u0018P\\2DY&,g\u000e^\u000b\u0002#B\u0019qF\u0011*\u0011\u0005\u0015\u001b\u0016B\u0001+G\u00059\tU.\u0019>p]\u0012Kh.Y7p\t\n\u000b1b]=oG\u000ec\u0017.\u001a8uA\u00051A(\u001b8jiz\"B\u0001\u0017.\\9B\u0011\u0011\fA\u0007\u00025!)\u0001h\u0002a\u0001u!)qh\u0002a\u0001\u0003\")qj\u0002a\u0001#\u000611/_:uK6,\u0012a\u0018\t\u0003A\u0012l\u0011!\u0019\u0006\u0003E\u000e\fQ!Y2u_JT\u0011!J\u0005\u0003K\u0006\u00141\"Q2u_J\u001c\u0016p\u001d;f[\u00061An\\4hKJ,\u0012\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\fQa\u001d7gi)T\u0011!\\\u0001\u0004_J<\u0017BA8k\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013\u0001D:ue\u0016\fWn\u00117jK:$X#A:\u0011\u0005QDX\"A;\u000b\u0005m1(BA<!\u0003\u0019\u0019G.[3oi&\u0011\u00110\u001e\u0002\u0012'R\u0014X-Y7Xe&$Xm\u00117jK:$\u0018!D:ue\u0016\fWn\u00117jK:$\b%\u0001\u0006sK\u0006$GI]5wKJ,\u0012! \t\u00033zL!a \u000e\u0003-Y\u000b$j\\;s]\u0006d'k\\<SK\u0006$GI]5wKJ\f1B]3bI\u0012\u0013\u0018N^3sA\u00059A-[:q_N,GCAA\u0004!\ry\u0013\u0011B\u0005\u0004\u0003\u0017\u0001$\u0001B+oSR\fabZ3u\u0015>,(O\\1m%><8\u000f\u0006\u0005\u0002\u0012\u0005\u001d\u0013qKA1!!\t\u0019\"!\b\u0002\"\u0005}RBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u0011M\u001c\u0017\r\\1eg2T1!a\u0007d\u0003\u0019\u0019HO]3b[&!\u0011qDA\u000b\u0005\u0019\u0019v.\u001e:dKB1\u00111EA\u001a\u0003sqA!!\n\u000209!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,1\na\u0001\u0010:p_Rt\u0014\"A\u0019\n\u0007\u0005E\u0002'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0012q\u0007\u0002\u0004'\u0016\f(bAA\u0019aA\u00191(a\u000f\n\u0007\u0005ubD\u0001\u0006K_V\u0014h.\u00197S_^\u0004B!!\u0011\u0002D5\t1-C\u0002\u0002F\r\u0014qAT8u+N,G\rC\u0004\u0002JA\u0001\r!a\u0013\u0002\u001bA,'o]5ti\u0016t7-Z%e!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)A\u0005)Qn\u001c3fY&!\u0011QKA(\u00055\u0001VM]:jgR,gnY3JI\"9\u0011\u0011\f\tA\u0002\u0005m\u0013\u0001\u0004;p'\u0016\fX/\u001a8dK:\u0013\b\u0003BA'\u0003;JA!a\u0018\u0002P\tq1+Z9vK:\u001cWMT;nE\u0016\u0014\bbBA2!\u0001\u0007\u0011QM\u0001\bI\u0016dW\r^3e!\ry\u0013qM\u0005\u0004\u0003S\u0002$a\u0002\"p_2,\u0017M\u001c\u000b\r\u0003[\ny'!\u001d\u0002v\u0005]\u0014\u0011\u0011\t\t\u0003'\ti\"!\u000f\u0002@!9\u0011\u0011J\tA\u0002\u0005-\u0003bBA:#\u0001\u0007\u00111L\u0001\u000fMJ|WnU3rk\u0016t7-\u001a(s\u0011\u001d\tI&\u0005a\u0001\u00037Bq!!\u001f\u0012\u0001\u0004\tY(A\u0002nCb\u00042aLA?\u0013\r\ty\b\r\u0002\u0005\u0019>tw\rC\u0005\u0002dE\u0001\n\u00111\u0001\u0002\u0004B!qFQA3\u0003a9W\r\u001e&pkJt\u0017\r\u001c*poN$C-\u001a4bk2$H%N\u000b\u0003\u0003\u0013SC!a!\u0002\f.\u0012\u0011Q\u0012\t\u0005\u0003\u001f\u000bI*\u0004\u0002\u0002\u0012*!\u00111SAK\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0018B\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY*!%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\tiS\u001eDWm\u001d;TKF,XM\\2f\u001dJ$\u0002\"!)\u0002&\u0006\u001d\u00161\u0016\t\t\u0003'\ti\"a)\u0002@A!qFQA>\u0011\u001d\tIe\u0005a\u0001\u0003\u0017B\u0011\"a\u001d\u0014!\u0003\u0005\r!!+\u0011\t=\u0012\u00151\f\u0005\n\u0003G\u001a\u0002\u0013!a\u0001\u0003\u0007\u000bqc]5oO2,\u0007+\u001e;K_V\u0014h.\u00197S_^4En\\<\u0016\u0005\u0005E\u0006CCA\n\u0003g\u000bI$a\u001f\u0002@%!\u0011QWA\u000b\u0005\u00111En\\<\u0002/5,H\u000e^5QkRTu.\u001e:oC2\u0014vn^:GY><XCAA^!)\t\u0019\"a-\u0002\"\u0005m\u0014qH\u0001\u001b[VdG/\u001b#fY\u0016$XMS8ve:\fGNU8xg\u001acwn^\u000b\u0003\u0003\u0003\u0004\"\"a\u0005\u00024\u0006\r\u00171PA !\u0019\t\u0019#a\r\u0002FB\u0019Q'a2\n\u0007\u0005%GD\u0001\fQKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ,ji\"\u001cV-\u001d(s\u0003i\u0019\u0018N\\4mK\u0012+G.\u001a;f\u0015>,(O\\1m%><h\t\\8x+\t\ty\r\u0005\u0006\u0002\u0014\u0005M\u0016QYA>\u0003\u007f\tQ\"\u001e9eCR,W*Z:tC\u001e,G\u0003BAk\u0003/\u0004\u0002\"a\u0005\u0002\u001e\u0005\u001d\u0011q\b\u0005\b\u00033D\u0002\u0019AA\u001d\u0003)Qw.\u001e:oC2\u0014vn\u001e")
public final class V1JournalRowWriteDriver
implements JournalRowWriteDriver {
    private final JournalPluginContext pluginContext;
    private final Option<AmazonDynamoDBAsync> asyncClient;
    private final Option<AmazonDynamoDB> syncClient;
    private final Logger logger;
    private final StreamWriteClient streamClient;
    private final V1JournalRowReadDriver readDriver;
    private Attributes logLevels;

    public Option<SequenceNumber> highestSequenceNr$default$2() {
        return JournalRowReadDriver.highestSequenceNr$default$2$((JournalRowReadDriver)this);
    }

    public Option<Object> highestSequenceNr$default$3() {
        return JournalRowReadDriver.highestSequenceNr$default$3$((JournalRowReadDriver)this);
    }

    public Attributes logLevels() {
        return this.logLevels;
    }

    public void com$github$j5ik2o$akka$persistence$dynamodb$journal$dao$JournalRowDriver$_setter_$logLevels_$eq(Attributes x$1) {
        this.logLevels = x$1;
    }

    public JournalPluginContext pluginContext() {
        return this.pluginContext;
    }

    public Option<AmazonDynamoDBAsync> asyncClient() {
        return this.asyncClient;
    }

    public Option<AmazonDynamoDB> syncClient() {
        return this.syncClient;
    }

    public ActorSystem system() {
        return this.pluginContext().system();
    }

    private Logger logger() {
        return this.logger;
    }

    private StreamWriteClient streamClient() {
        return this.streamClient;
    }

    private V1JournalRowReadDriver readDriver() {
        return this.readDriver;
    }

    public void dispose() {
        Option option;
        Option option2;
        Tuple2 tuple2 = new Tuple2(this.asyncClient(), this.syncClient());
        if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option2;
            AmazonDynamoDBAsync a = (AmazonDynamoDBAsync)some.value();
            a.shutdown();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            AmazonDynamoDB s = (AmazonDynamoDB)some.value();
            s.shutdown();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Source<scala.collection.immutable.Seq<JournalRow>, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber toSequenceNr, boolean deleted) {
        return this.readDriver().getJournalRows(persistenceId, toSequenceNr, deleted);
    }

    public Source<JournalRow, NotUsed> getJournalRows(PersistenceId persistenceId, SequenceNumber fromSequenceNr, SequenceNumber toSequenceNr, long max, Option<Object> deleted) {
        return this.readDriver().getJournalRows(persistenceId, fromSequenceNr, toSequenceNr, max, deleted);
    }

    public Option<Object> getJournalRows$default$5() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Source<Option<Object>, NotUsed> highestSequenceNr(PersistenceId persistenceId, Option<SequenceNumber> fromSequenceNr, Option<Object> deleted) {
        return this.readDriver().highestSequenceNr(persistenceId, fromSequenceNr, deleted);
    }

    public Flow<JournalRow, Object, NotUsed> singlePutJournalRowFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)journalRow -> {
            String pkey = this.pluginContext().partitionKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
            String skey = this.pluginContext().sortKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
            PutItemRequest request = new PutItemRequest().withTableName(this.pluginContext().pluginConfig().tableName()).withItem(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(journalRow.persistenceId().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(journalRow.sequenceNumber().asString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName()), (Object)new AttributeValue().withN(Long.toString(journalRow.ordering()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName()), (Object)new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(journalRow.deleted()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().messageColumnName()), (Object)new AttributeValue().withB(ByteBuffer.wrap(journalRow.message())))}))).$plus$plus((IterableOnce)journalRow.tags().map((Function1 & Serializable)tag -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName()), (Object)new AttributeValue().withS(tag))}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava());
            return (Source)Source$.MODULE$.single((Object)request).via((Graph)this.streamClient().putItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                Source source;
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    source = Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)1L));
                } else {
                    int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
                }
                return source;
            });
        });
    }

    public Flow<scala.collection.immutable.Seq<JournalRow>, Object, NotUsed> multiPutJournalRowsFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)journalRows -> {
            Source source;
            if (journalRows.isEmpty()) {
                source = Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L));
            } else {
                Predef$.MODULE$.require(journalRows.size() == journalRows.toSet().size(), (Function0 & Serializable)() -> "journalRows: keys contains duplicates");
                scala.collection.immutable.Seq journalRowWithPKeyWithSKeys = (scala.collection.immutable.Seq)journalRows.map((Function1 & Serializable)journalRow -> {
                    String pkey = this.pluginContext().partitionKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
                    String skey = this.pluginContext().sortKeyResolver().resolve(journalRow.persistenceId(), journalRow.sequenceNumber()).asString();
                    return new Tuple3(journalRow, (Object)pkey, (Object)skey);
                });
                this.logger().debug(new StringBuilder(55).append("multiPutJournalRowsFlow: journalRowWithPKeyWithSKeys = ").append(journalRowWithPKeyWithSKeys.mkString("\n", ",\n", "\n")).toString());
                Predef$.MODULE$.require(((IterableOnceOps)journalRowWithPKeyWithSKeys.map((Function1 & Serializable)x0$1 -> {
                    Tuple3 tuple3 = x0$1;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String p = (String)tuple3._2();
                    String s = (String)tuple3._3();
                    Tuple2 tuple2 = new Tuple2((Object)p, (Object)s);
                    return tuple2;
                })).toSet().size() == journalRows.size(), (Function0 & Serializable)() -> "journalRowWithPKeyWithSKeys: keys contains duplicates");
                source = ((Source)Source$.MODULE$.single(journalRowWithPKeyWithSKeys.map((Function1 & Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    JournalRow journalRow = (JournalRow)tuple3._1();
                    String pkey = (String)tuple3._2();
                    String skey = (String)tuple3._3();
                    String pid = journalRow.persistenceId().asString();
                    String seqNr = journalRow.sequenceNumber().asString();
                    String ordering = Long.toString(journalRow.ordering());
                    boolean deleted = journalRow.deleted();
                    ByteBuffer message = ByteBuffer.wrap(journalRow.message());
                    Option tagsOpt = journalRow.tags();
                    WriteRequest writeRequest = new WriteRequest().withPutRequest(new PutRequest().withItem(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().persistenceIdColumnName()), (Object)new AttributeValue().withS(pid)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sequenceNrColumnName()), (Object)new AttributeValue().withN(seqNr)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName()), (Object)new AttributeValue().withN(ordering)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName()), (Object)new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(deleted))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().messageColumnName()), (Object)new AttributeValue().withB(message))}))).$plus$plus((IterableOnce)tagsOpt.map((Function1 & Serializable)tags -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName()), (Object)new AttributeValue().withS(tags))}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava()));
                    return writeRequest;
                })).flatMapConcat((Function1 & Serializable)requestItems -> (Source)Source$.MODULE$.single((Object)new BatchWriteItemRequest().withRequestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().tableName()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)requestItems).asJava())}))).asJava())).via((Graph)this.streamClient().recursiveBatchWriteItemFlow()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)requestItems.size())))).withAttributes(this.logLevels());
            }
            return source;
        });
    }

    public Flow<scala.collection.immutable.Seq<PersistenceIdWithSeqNr>, Object, NotUsed> multiDeleteJournalRowsFlow() {
        return ((Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)persistenceIdWithSeqNrs -> {
            ((IterableOnceOps)persistenceIdWithSeqNrs.map((Function1 & Serializable)x0$1 -> {
                PersistenceIdWithSeqNr persistenceIdWithSeqNr = x0$1;
                if (persistenceIdWithSeqNr == null) {
                    throw new MatchError((Object)persistenceIdWithSeqNr);
                }
                PersistenceId pid = persistenceIdWithSeqNr.persistenceId();
                SequenceNumber seqNr = persistenceIdWithSeqNr.sequenceNumber();
                String string = new StringBuilder(16).append("pid = ").append(pid).append(", seqNr = ").append(seqNr).toString();
                return string;
            })).foreach((Function1 & Serializable)x$1 -> {
                V1JournalRowWriteDriver.$anonfun$multiDeleteJournalRowsFlow$3(this, x$1);
                return BoxedUnit.UNIT;
            });
            return persistenceIdWithSeqNrs.isEmpty() ? Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)0L)) : (Source)Source$.MODULE$.single(persistenceIdWithSeqNrs.map((Function1 & Serializable)persistenceIdWithSeqNr -> {
                String pkey = this.pluginContext().partitionKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
                String skey = this.pluginContext().sortKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
                return new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey))}))).asJava()));
            })).flatMapConcat((Function1 & Serializable)requestItems -> (Source)Source$.MODULE$.single((Object)new BatchWriteItemRequest().withRequestItems(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().tableName()), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)requestItems).asJava())}))).asJava())).via((Graph)this.streamClient().recursiveBatchWriteItemFlow()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)requestItems.size())));
        })).withAttributes(this.logLevels());
    }

    public Flow<PersistenceIdWithSeqNr, Object, NotUsed> singleDeleteJournalRowFlow() {
        return (Flow)Flow$.MODULE$.apply().flatMapConcat((Function1 & Serializable)persistenceIdWithSeqNr -> {
            String pkey = this.pluginContext().partitionKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
            String skey = this.pluginContext().sortKeyResolver().resolve(persistenceIdWithSeqNr.persistenceId(), persistenceIdWithSeqNr.sequenceNumber()).asString();
            DeleteItemRequest deleteRequest = new DeleteItemRequest().withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey))}))).asJava());
            return (Source)Source$.MODULE$.single((Object)deleteRequest).via((Graph)this.streamClient().deleteItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
                Source source;
                if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                    source = Source$.MODULE$.single((Object)BoxesRunTime.boxToLong((long)1L));
                } else {
                    int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                    source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
                }
                return source;
            });
        });
    }

    public Source<BoxedUnit, NotUsed> updateMessage(JournalRow journalRow) {
        this.logger().debug(new StringBuilder(35).append("updateMessage(journalRow = ").append(journalRow).append("): start").toString());
        String pkey = journalRow.partitionKey(this.pluginContext().partitionKeyResolver()).asString();
        String skey = journalRow.sortKey(this.pluginContext().sortKeyResolver()).asString();
        return ((Source)Source$.MODULE$.single((Object)this.createUpdateRequest$1(pkey, skey, journalRow)).via((Graph)this.streamClient().updateItemFlow()).flatMapConcat((Function1 & Serializable)response -> {
            Source source;
            if (response.getSdkHttpMetadata().getHttpStatusCode() == 200) {
                source = Source$.MODULE$.single((Object)BoxedUnit.UNIT);
            } else {
                int statusCode = response.getSdkHttpMetadata().getHttpStatusCode();
                this.logger().debug(new StringBuilder(38).append("updateMessage(journalRow = ").append(journalRow).append("): finished").toString());
                source = Source$.MODULE$.failed((Throwable)new IOException(new StringBuilder(12).append("statusCode: ").append(statusCode).toString()));
            }
            return source;
        })).withAttributes(this.logLevels());
    }

    public static final /* synthetic */ void $anonfun$multiDeleteJournalRowsFlow$3(V1JournalRowWriteDriver $this, String x$1) {
        $this.logger().debug(x$1);
    }

    private final UpdateItemRequest createUpdateRequest$1(String pkey$1, String skey$1, JournalRow journalRow$1) {
        return new UpdateItemRequest().withTableName(this.pluginContext().pluginConfig().tableName()).withKey(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().partitionKeyColumnName()), (Object)new AttributeValue().withS(pkey$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().sortKeyColumnName()), (Object)new AttributeValue().withS(skey$1))}))).asJava()).withAttributeUpdates(CollectionConverters$.MODULE$.MapHasAsJava((Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().messageColumnName()), (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withB(ByteBuffer.wrap(journalRow$1.message())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().orderingColumnName()), (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withN(Long.toString(journalRow$1.ordering())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().deletedColumnName()), (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withBOOL(Predef$.MODULE$.boolean2Boolean(journalRow$1.deleted()))))}))).$plus$plus((IterableOnce)journalRow$1.tags().map((Function1 & Serializable)tag -> (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.pluginContext().pluginConfig().columnsDefConfig().tagsColumnName()), (Object)new AttributeValueUpdate().withAction(AttributeAction.PUT).withValue(new AttributeValue().withS(tag)))}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty()))).asJava());
    }

    public V1JournalRowWriteDriver(JournalPluginContext pluginContext, Option<AmazonDynamoDBAsync> asyncClient, Option<AmazonDynamoDB> syncClient) {
        this.pluginContext = pluginContext;
        this.asyncClient = asyncClient;
        this.syncClient = syncClient;
        JournalRowDriver.$init$((JournalRowDriver)this);
        Tuple2 tuple2 = new Tuple2(asyncClient, syncClient);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("aws clients is both None");
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.streamClient = new StreamWriteClient((PluginContext)pluginContext, asyncClient, syncClient, pluginContext.pluginConfig().writeBackoffConfig());
        this.readDriver = new V1JournalRowReadDriver(pluginContext, asyncClient, syncClient);
        Statics.releaseFence();
    }
}

