/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.utils;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.dispatch.MessageDispatcher;
import akka.stream.ActorAttributes$;
import akka.stream.scaladsl.Flow;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientVersion$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ExecutorServiceUtils$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.LoggingSupport;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;

public final class DispatcherUtils$
implements LoggingSupport {
    public static final DispatcherUtils$ MODULE$ = new DispatcherUtils$();
    private static Logger logger;

    static {
        LoggingSupport.$init$(MODULE$);
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public ExecutionContextExecutorService newV1Executor(PluginConfig pluginConfig, ActorSystem system) {
        return (ExecutionContextExecutorService)this.getV1DispatcherName(pluginConfig).map((Function1 & Serializable)dn -> {
            MessageDispatcher ec = system.dispatchers().lookup(dn);
            return ExecutorServiceUtils$.MODULE$.fromExecutionContext((ExecutionContext)ec);
        }).getOrElse((Function0 & Serializable)() -> ExecutorServiceUtils$.MODULE$.fromExecutionContext((ExecutionContext)system.dispatcher()));
    }

    public ExecutionContextExecutorService newV2Executor(PluginConfig pluginConfig, ActorSystem system) {
        return (ExecutionContextExecutorService)this.getV2DispatcherName(pluginConfig).map((Function1 & Serializable)dn -> {
            MessageDispatcher ec = system.dispatchers().lookup(dn);
            return ExecutorServiceUtils$.MODULE$.fromExecutionContext((ExecutionContext)ec);
        }).getOrElse((Function0 & Serializable)() -> ExecutorServiceUtils$.MODULE$.fromExecutionContext((ExecutionContext)system.dispatcher()));
    }

    public <A, B> Flow<A, B, NotUsed> ApplyV1DispatcherOps(Flow<A, B, NotUsed> flow) {
        return flow;
    }

    public Option<String> getV1DispatcherName(PluginConfig pluginConfig) {
        Option<String> option;
        Enumeration.Value value = pluginConfig.clientConfig().clientVersion();
        Enumeration.Value value2 = ClientVersion$.MODULE$.V1();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            option = pluginConfig.clientConfig().v1ClientConfig().dispatcherName();
        } else {
            Enumeration.Value value4 = ClientVersion$.MODULE$.V1Dax();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                option = pluginConfig.clientConfig().v1DaxClientConfig().dispatcherName();
            } else {
                throw new IllegalArgumentException("Invalid the client version");
            }
        }
        return option;
    }

    public Option<String> getV2DispatcherName(PluginConfig pluginConfig) {
        Enumeration.Value value = pluginConfig.clientConfig().clientVersion();
        Enumeration.Value value2 = ClientVersion$.MODULE$.V2();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            throw new IllegalArgumentException("Invalid the client version");
        }
        Option option = pluginConfig.clientConfig().v2ClientConfig().dispatcherName().orElse((Function0 & Serializable)() -> pluginConfig.clientConfig().v2ClientConfig().syncClientConfig().dispatcherName());
        return option;
    }

    public <A, B> Flow<A, B, NotUsed> com$github$j5ik2o$akka$persistence$dynamodb$utils$DispatcherUtils$$applyV1Dispatcher(PluginConfig pluginConfig, Flow<A, B, NotUsed> flow) {
        return (Flow)this.getV1DispatcherName(pluginConfig).fold((Function0 & Serializable)() -> flow, (Function1 & Serializable)name -> flow.withAttributes(ActorAttributes$.MODULE$.dispatcher(name)));
    }

    public <A, B> Flow<A, B, NotUsed> ApplyV2DispatcherOps(Flow<A, B, NotUsed> flow) {
        return flow;
    }

    public <A, B> Flow<A, B, NotUsed> com$github$j5ik2o$akka$persistence$dynamodb$utils$DispatcherUtils$$applyV2Dispatcher(PluginConfig pluginConfig, Flow<A, B, NotUsed> flow) {
        return (Flow)this.getV2DispatcherName(pluginConfig).fold((Function0 & Serializable)() -> flow, (Function1 & Serializable)name -> flow.withAttributes(ActorAttributes$.MODULE$.dispatcher(name)));
    }

    private DispatcherUtils$() {
    }
}

