/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2;

import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.AwsCredentialsProviderProvider;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.ExecutionInterceptorsProvider;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.MetricPublishersProvider;
import com.github.j5ik2o.akka.persistence.dynamodb.client.v2.RetryPolicyProvider;
import com.github.j5ik2o.akka.persistence.dynamodb.config.ConfigSupport$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.ConfigSupport$ConfigOps$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.AsyncClientConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.AsyncClientConfig$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.SyncClientConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.SyncClientConfig$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ClassCheckUtils$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ConfigOps$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ConfigOps$ConfigOperations$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.LoggingSupport;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple15;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricPublisher;

public final class DynamoDBClientV2Config$
implements LoggingSupport,
Serializable {
    public static final DynamoDBClientV2Config$ MODULE$ = new DynamoDBClientV2Config$();
    private static final String dispatcherNameKey;
    private static final String asyncKey;
    private static final String syncKey;
    private static final String headersKey;
    private static final String retryModeKey;
    private static final String retryPolicyProviderClassNameKey;
    private static final String executionInterceptorClassNamesKey;
    private static final String executionInterceptorProviderClassNameKey;
    private static final String apiCallTimeoutKey;
    private static final String apiCallAttemptTimeoutKey;
    private static final String metricPublisherProviderClassNameKey;
    private static final String metricPublisherClassNameKey;
    private static final String awsCredentialsProviderProviderClassNameKey;
    private static final String awsCredentialsProviderClassNameKey;
    private static final scala.collection.immutable.Seq<String> keyNames;
    private static Logger logger;

    static {
        LoggingSupport.$init$(MODULE$);
        dispatcherNameKey = "dispatcher-name";
        asyncKey = "async";
        syncKey = "sync";
        headersKey = "headers";
        retryModeKey = "retry-mode";
        retryPolicyProviderClassNameKey = "retry-policy-provider-class-name";
        executionInterceptorClassNamesKey = "execution-interceptor-class-names";
        executionInterceptorProviderClassNameKey = "execution-interceptor-provider-class-name";
        apiCallTimeoutKey = "api-call-timeout";
        apiCallAttemptTimeoutKey = "api-call-attempt-timeout";
        metricPublisherProviderClassNameKey = "metric-publishers-provider-class-names";
        metricPublisherClassNameKey = "metric-publisher-class-names";
        awsCredentialsProviderProviderClassNameKey = "aws-credentials-provider-provider-class-name";
        awsCredentialsProviderClassNameKey = "aws-credentials-provider-class-name";
        keyNames = (scala.collection.immutable.Seq)new .colon.colon((Object)MODULE$.dispatcherNameKey(), (List)new .colon.colon((Object)MODULE$.asyncKey(), (List)new .colon.colon((Object)MODULE$.syncKey(), (List)new .colon.colon((Object)MODULE$.retryModeKey(), (List)new .colon.colon((Object)MODULE$.apiCallTimeoutKey(), (List)new .colon.colon((Object)MODULE$.apiCallAttemptTimeoutKey(), (List)Nil$.MODULE$))))));
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public String dispatcherNameKey() {
        return dispatcherNameKey;
    }

    public String asyncKey() {
        return asyncKey;
    }

    public String syncKey() {
        return syncKey;
    }

    public String headersKey() {
        return headersKey;
    }

    public String retryModeKey() {
        return retryModeKey;
    }

    public String retryPolicyProviderClassNameKey() {
        return retryPolicyProviderClassNameKey;
    }

    public String executionInterceptorClassNamesKey() {
        return executionInterceptorClassNamesKey;
    }

    public String executionInterceptorProviderClassNameKey() {
        return executionInterceptorProviderClassNameKey;
    }

    public String apiCallTimeoutKey() {
        return apiCallTimeoutKey;
    }

    public String apiCallAttemptTimeoutKey() {
        return apiCallAttemptTimeoutKey;
    }

    public String metricPublisherProviderClassNameKey() {
        return metricPublisherProviderClassNameKey;
    }

    public String metricPublisherClassNameKey() {
        return metricPublisherClassNameKey;
    }

    public String awsCredentialsProviderProviderClassNameKey() {
        return awsCredentialsProviderProviderClassNameKey;
    }

    public String awsCredentialsProviderClassNameKey() {
        return awsCredentialsProviderClassNameKey;
    }

    public scala.collection.immutable.Seq<String> keyNames() {
        return keyNames;
    }

    public scala.collection.immutable.Map<String, Object> existsKeyNames(Config config) {
        return ((IterableOnceOps)this.keyNames().map((Function1 & Serializable)v -> new Tuple2(v, (Object)BoxesRunTime.boxToBoolean((boolean)ConfigOps$ConfigOperations$.MODULE$.exists$extension(ConfigOps$.MODULE$.ConfigOperations(config), (String)v))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    public DynamoDBClientV2Config fromConfig(Config config, boolean legacyConfigFormat) {
        void var3_10;
        AsyncClientConfig asyncClientConfig;
        this.logger().debug("config = {}", (Object)config);
        Option option = ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.dispatcherNameKey());
        if (legacyConfigFormat) {
            this.logger().warn(new StringBuilder(288).append("<<<!!!CAUTION: PLEASE MIGRATE TO NEW CONFIG FORMAT!!!>>>\n\tThe configuration items of AWS-SDK V2 client remain with the old key names: (j5ik2o.dynamo-db-journal.dynamo-db-client).\n\tPlease change current key name to the new key name: (j5ik2o.dynamo-db-journal.dynamo-db-client.v2.async). \n\t").append(((MapOps)AsyncClientConfig$.MODULE$.existsKeyNames(config).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1._2$mcZ$sp()))).keys().mkString("child-keys = [ ", ", ", " ]")).toString());
            asyncClientConfig = AsyncClientConfig$.MODULE$.fromConfig(config);
        } else {
            asyncClientConfig = AsyncClientConfig$.MODULE$.fromConfig(ConfigSupport$ConfigOps$.MODULE$.configAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.asyncKey(), ConfigFactory.empty()));
        }
        Option className = ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.retryPolicyProviderClassNameKey()).orElse((Function0 & Serializable)() -> new Some((Object)RetryPolicyProvider.Default.class.getName()));
        String className2 = ConfigSupport$ConfigOps$.MODULE$.valueAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.executionInterceptorProviderClassNameKey(), ExecutionInterceptorsProvider.Default.class.getName());
        Seq classNames = ConfigSupport$ConfigOps$.MODULE$.valuesAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.executionInterceptorClassNamesKey(), (Seq)Seq$.MODULE$.empty());
        String className3 = ConfigSupport$ConfigOps$.MODULE$.valueAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.metricPublisherProviderClassNameKey(), MetricPublishersProvider.Default.class.getName());
        Seq classNames2 = ConfigSupport$ConfigOps$.MODULE$.valuesAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.metricPublisherClassNameKey(), (Seq)Seq$.MODULE$.empty());
        String className4 = ConfigSupport$ConfigOps$.MODULE$.valueAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.awsCredentialsProviderProviderClassNameKey(), AwsCredentialsProviderProvider.Default.class.getName());
        Option className5 = ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.awsCredentialsProviderClassNameKey());
        DynamoDBClientV2Config result = new DynamoDBClientV2Config(config, option, asyncClientConfig, SyncClientConfig$.MODULE$.fromConfig(ConfigSupport$ConfigOps$.MODULE$.configAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.syncKey(), ConfigFactory.empty())), ConfigSupport$ConfigOps$.MODULE$.mapAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.headersKey(), Map$.MODULE$.empty()), ClassCheckUtils$.MODULE$.requireClass(RetryPolicyProvider.class, (Option<String>)className), (Option<RetryMode>)ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.retryModeKey()).map((Function1 & Serializable)s -> RetryMode.valueOf((String)s)), ClassCheckUtils$.MODULE$.requireClass(ExecutionInterceptorsProvider.class, className2), (scala.collection.immutable.Seq<String>)((IterableOnceOps)classNames.map((Function1 & Serializable)s -> ClassCheckUtils$.MODULE$.requireClass(ExecutionInterceptor.class, (String)s))).toIndexedSeq(), ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.apiCallTimeoutKey()), ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.apiCallAttemptTimeoutKey()), ClassCheckUtils$.MODULE$.requireClass(MetricPublishersProvider.class, className3), (Seq<String>)((Seq)classNames2.map((Function1 & Serializable)s -> ClassCheckUtils$.MODULE$.requireClass(MetricPublisher.class, (String)s))), ClassCheckUtils$.MODULE$.requireClass(AwsCredentialsProviderProvider.class, className4), ClassCheckUtils$.MODULE$.requireClass(AwsCredentialsProvider.class, className5));
        this.logger().debug("result = {}", (Object)result);
        return var3_10;
    }

    public DynamoDBClientV2Config apply(Config sourceConfig, Option<String> dispatcherName, AsyncClientConfig asyncClientConfig, SyncClientConfig syncClientConfig, Map<String, Seq<String>> headers, Option<String> retryPolicyProviderClassName, Option<RetryMode> retryMode, String executionInterceptorsProviderClassName, scala.collection.immutable.Seq<String> executionInterceptorClassNames, Option<FiniteDuration> apiCallTimeout, Option<FiniteDuration> apiCallAttemptTimeout, String metricPublishersProviderClassName, Seq<String> metricPublisherClassNames, String awsCredentialsProviderProviderClassName, Option<String> awsCredentialsProviderClassName) {
        return new DynamoDBClientV2Config(sourceConfig, dispatcherName, asyncClientConfig, syncClientConfig, headers, retryPolicyProviderClassName, retryMode, executionInterceptorsProviderClassName, executionInterceptorClassNames, apiCallTimeout, apiCallAttemptTimeout, metricPublishersProviderClassName, metricPublisherClassNames, awsCredentialsProviderProviderClassName, awsCredentialsProviderClassName);
    }

    public Option<Tuple15<Config, Option<String>, AsyncClientConfig, SyncClientConfig, Map<String, Seq<String>>, Option<String>, Option<RetryMode>, String, scala.collection.immutable.Seq<String>, Option<FiniteDuration>, Option<FiniteDuration>, String, Seq<String>, String, Option<String>>> unapply(DynamoDBClientV2Config x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple15((Object)x$0.sourceConfig(), x$0.dispatcherName(), (Object)x$0.asyncClientConfig(), (Object)x$0.syncClientConfig(), x$0.headers(), x$0.retryPolicyProviderClassName(), x$0.retryMode(), (Object)x$0.executionInterceptorsProviderClassName(), x$0.executionInterceptorClassNames(), x$0.apiCallTimeout(), x$0.apiCallAttemptTimeout(), (Object)x$0.metricPublishersProviderClassName(), x$0.metricPublisherClassNames(), (Object)x$0.awsCredentialsProviderProviderClassName(), x$0.awsCredentialsProviderClassName()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DynamoDBClientV2Config$.class);
    }

    private DynamoDBClientV2Config$() {
    }
}

