/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.config.client;

import com.github.j5ik2o.akka.persistence.dynamodb.config.ConfigSupport$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.ConfigSupport$ConfigOps$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientType$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientVersion$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.DynamoDBClientConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1.DynamoDBClientV1Config;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1.DynamoDBClientV1Config$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1dax.DynamoDBClientV1DaxConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1dax.DynamoDBClientV1DaxConfig$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.LoggingSupport;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple12;
import scala.collection.MapOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DynamoDBClientConfig$
implements LoggingSupport,
Serializable {
    public static final DynamoDBClientConfig$ MODULE$ = new DynamoDBClientConfig$();
    private static final String accessKeyIdKeyKey;
    private static final String secretAccessKeyKey;
    private static final String endpointKey;
    private static final String regionKey;
    private static final String clientVersionKey;
    private static final String clientTypeKey;
    private static final String v1Key;
    private static final String v1DaxKey;
    private static final String v2Key;
    private static final String batchGetItemLimitKey;
    private static final String batchWriteItemLimitKey;
    private static final Enumeration.Value DefaultClientVersion;
    private static final Enumeration.Value DefaultClientType;
    private static final int DefaultBatchGetItemLimit;
    private static final int DefaultBatchWriteItemLimit;
    private static Logger logger;

    static {
        LoggingSupport.$init$(MODULE$);
        accessKeyIdKeyKey = "access-key-id";
        secretAccessKeyKey = "secret-access-key";
        endpointKey = "endpoint";
        regionKey = "region";
        clientVersionKey = "client-version";
        clientTypeKey = "client-type";
        v1Key = "v1";
        v1DaxKey = "v1-dax";
        v2Key = "v2";
        batchGetItemLimitKey = "batch-get-item-limit";
        batchWriteItemLimitKey = "batch-write-item-limit";
        DefaultClientVersion = ClientVersion$.MODULE$.V2();
        DefaultClientType = ClientType$.MODULE$.Async();
        DefaultBatchGetItemLimit = 100;
        DefaultBatchWriteItemLimit = 25;
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public String accessKeyIdKeyKey() {
        return accessKeyIdKeyKey;
    }

    public String secretAccessKeyKey() {
        return secretAccessKeyKey;
    }

    public String endpointKey() {
        return endpointKey;
    }

    public String regionKey() {
        return regionKey;
    }

    public String clientVersionKey() {
        return clientVersionKey;
    }

    public String clientTypeKey() {
        return clientTypeKey;
    }

    public String v1Key() {
        return v1Key;
    }

    public String v1DaxKey() {
        return v1DaxKey;
    }

    public String v2Key() {
        return v2Key;
    }

    public String batchGetItemLimitKey() {
        return batchGetItemLimitKey;
    }

    public String batchWriteItemLimitKey() {
        return batchWriteItemLimitKey;
    }

    public Enumeration.Value DefaultClientVersion() {
        return DefaultClientVersion;
    }

    public Enumeration.Value DefaultClientType() {
        return DefaultClientType;
    }

    public int DefaultBatchGetItemLimit() {
        return DefaultBatchGetItemLimit;
    }

    public int DefaultBatchWriteItemLimit() {
        return DefaultBatchWriteItemLimit;
    }

    /*
     * WARNING - void declaration
     */
    public DynamoDBClientConfig fromConfig(Config config, boolean legacyConfigFormat) {
        void var3_3;
        DynamoDBClientV2Config dynamoDBClientV2Config;
        this.logger().debug("config = {}", (Object)config);
        Option option = ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.accessKeyIdKeyKey());
        Option option2 = ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.secretAccessKeyKey());
        Option option3 = ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.endpointKey());
        Option option4 = ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.regionKey());
        Enumeration.Value value = (Enumeration.Value)ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.clientVersionKey()).map((Function1 & Serializable)s -> ClientVersion$.MODULE$.withName((String)s)).getOrElse((Function0 & Serializable)() -> MODULE$.DefaultClientVersion());
        Enumeration.Value value2 = (Enumeration.Value)ConfigSupport$ConfigOps$.MODULE$.valueOptAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.clientTypeKey()).map((Function1 & Serializable)s -> ClientType$.MODULE$.withName((String)s)).getOrElse((Function0 & Serializable)() -> MODULE$.DefaultClientType());
        DynamoDBClientV1Config dynamoDBClientV1Config = DynamoDBClientV1Config$.MODULE$.fromConfig(ConfigSupport$ConfigOps$.MODULE$.configAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.v1Key(), ConfigFactory.empty()));
        DynamoDBClientV1DaxConfig dynamoDBClientV1DaxConfig = DynamoDBClientV1DaxConfig$.MODULE$.fromConfig(ConfigSupport$ConfigOps$.MODULE$.configAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.v1DaxKey(), ConfigFactory.empty()));
        if (legacyConfigFormat) {
            this.logger().warn(new StringBuilder(282).append("<<<!!!CAUTION: PLEASE MIGRATE TO NEW CONFIG FORMAT!!!>>>\n\tThe configuration items of AWS-SDK V2 client remain with the old key names: (j5ik2o.dynamo-db-journal.dynamo-db-client).\n\tPlease change current key name to the new key name: (j5ik2o.dynamo-db-journal.dynamo-db-client.v2). \n\t").append(((MapOps)DynamoDBClientV2Config$.MODULE$.existsKeyNames(config).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1._2$mcZ$sp()))).keys().mkString("child-keys = [ ", ", ", " ]")).toString());
            dynamoDBClientV2Config = DynamoDBClientV2Config$.MODULE$.fromConfig(config, legacyConfigFormat);
        } else {
            dynamoDBClientV2Config = DynamoDBClientV2Config$.MODULE$.fromConfig(ConfigSupport$ConfigOps$.MODULE$.configAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.v2Key(), ConfigFactory.empty()), legacyConfigFormat);
        }
        DynamoDBClientConfig result = new DynamoDBClientConfig(config, option, option2, option3, option4, value, value2, dynamoDBClientV1Config, dynamoDBClientV1DaxConfig, dynamoDBClientV2Config, BoxesRunTime.unboxToInt((Object)ConfigSupport$ConfigOps$.MODULE$.valueAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.batchGetItemLimitKey(), BoxesRunTime.boxToInteger((int)this.DefaultBatchGetItemLimit()))), BoxesRunTime.unboxToInt((Object)ConfigSupport$ConfigOps$.MODULE$.valueAs$extension(ConfigSupport$.MODULE$.ConfigOps(config), this.batchWriteItemLimitKey(), BoxesRunTime.boxToInteger((int)this.DefaultBatchWriteItemLimit()))));
        this.logger().debug("result = {}", (Object)result);
        return var3_3;
    }

    public DynamoDBClientConfig apply(Config sourceConfig, Option<String> accessKeyId, Option<String> secretAccessKey, Option<String> endpoint, Option<String> region, Enumeration.Value clientVersion, Enumeration.Value clientType, DynamoDBClientV1Config v1ClientConfig, DynamoDBClientV1DaxConfig v1DaxClientConfig, DynamoDBClientV2Config v2ClientConfig, int batchGetItemLimit, int batchWriteItemLimit) {
        return new DynamoDBClientConfig(sourceConfig, accessKeyId, secretAccessKey, endpoint, region, clientVersion, clientType, v1ClientConfig, v1DaxClientConfig, v2ClientConfig, batchGetItemLimit, batchWriteItemLimit);
    }

    public Option<Tuple12<Config, Option<String>, Option<String>, Option<String>, Option<String>, Enumeration.Value, Enumeration.Value, DynamoDBClientV1Config, DynamoDBClientV1DaxConfig, DynamoDBClientV2Config, Object, Object>> unapply(DynamoDBClientConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.sourceConfig(), x$0.accessKeyId(), x$0.secretAccessKey(), x$0.endpoint(), x$0.region(), (Object)x$0.clientVersion(), (Object)x$0.clientType(), (Object)x$0.v1ClientConfig(), (Object)x$0.v1DaxClientConfig(), (Object)x$0.v2ClientConfig(), (Object)BoxesRunTime.boxToInteger((int)x$0.batchGetItemLimit()), (Object)BoxesRunTime.boxToInteger((int)x$0.batchWriteItemLimit())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DynamoDBClientConfig$.class);
    }

    private DynamoDBClientConfig$() {
    }
}

