/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.utils;

import akka.NotUsed;
import akka.dispatch.MessageDispatcher;
import akka.stream.ActorAttributes$;
import akka.stream.scaladsl.Flow;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientVersion$;
import com.github.j5ik2o.akka.persistence.dynamodb.context.PluginContext;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ExecutorServiceUtils$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.LoggingSupport;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;

public final class DispatcherUtils$
implements LoggingSupport {
    public static DispatcherUtils$ MODULE$;
    private final Logger logger;

    static {
        new DispatcherUtils$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ExecutionContextExecutorService newV1Executor(PluginContext pluginContext) {
        return (ExecutionContextExecutorService)this.getV1DispatcherName(pluginContext.pluginConfig()).map((Function1 & java.io.Serializable & Serializable)dn -> {
            MessageDispatcher ec = pluginContext.system().dispatchers().lookup(dn);
            return ExecutorServiceUtils$.MODULE$.fromExecutionContext((ExecutionContext)ec);
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> ExecutorServiceUtils$.MODULE$.fromExecutionContext((ExecutionContext)pluginContext.system().dispatcher()));
    }

    public ExecutionContextExecutorService newV2Executor(PluginContext pluginContext) {
        return (ExecutionContextExecutorService)this.getV2DispatcherName(pluginContext.pluginConfig()).map((Function1 & java.io.Serializable & Serializable)dn -> {
            MessageDispatcher ec = pluginContext.system().dispatchers().lookup(dn);
            return ExecutorServiceUtils$.MODULE$.fromExecutionContext((ExecutionContext)ec);
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> ExecutorServiceUtils$.MODULE$.fromExecutionContext((ExecutionContext)pluginContext.system().dispatcher()));
    }

    public <A, B> Flow<A, B, NotUsed> ApplyV1DispatcherOps(Flow<A, B, NotUsed> flow) {
        return flow;
    }

    public Option<String> getV1DispatcherName(PluginConfig pluginConfig) {
        Enumeration.Value value = pluginConfig.clientConfig().clientVersion();
        Enumeration.Value value2 = ClientVersion$.MODULE$.V1();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return pluginConfig.clientConfig().v1ClientConfig().dispatcherName();
        }
        Enumeration.Value value4 = ClientVersion$.MODULE$.V1Dax();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return pluginConfig.clientConfig().v1DaxClientConfig().dispatcherName();
        }
        throw new IllegalArgumentException("Invalid the client version");
    }

    public Option<String> getV2DispatcherName(PluginConfig pluginConfig) {
        Enumeration.Value value = pluginConfig.clientConfig().clientVersion();
        Enumeration.Value value2 = ClientVersion$.MODULE$.V2();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return pluginConfig.clientConfig().v2ClientConfig().dispatcherName().orElse((Function0 & java.io.Serializable & Serializable)() -> pluginConfig.clientConfig().v2ClientConfig().syncClientConfig().dispatcherName());
        }
        throw new IllegalArgumentException("Invalid the client version");
    }

    public <A, B> Flow<A, B, NotUsed> com$github$j5ik2o$akka$persistence$dynamodb$utils$DispatcherUtils$$applyV1Dispatcher(PluginConfig pluginConfig, Flow<A, B, NotUsed> flow) {
        return (Flow)this.getV1DispatcherName(pluginConfig).fold((Function0 & java.io.Serializable & Serializable)() -> flow, (Function1 & java.io.Serializable & Serializable)name -> flow.withAttributes(ActorAttributes$.MODULE$.dispatcher(name)));
    }

    public <A, B> Flow<A, B, NotUsed> ApplyV2DispatcherOps(Flow<A, B, NotUsed> flow) {
        return flow;
    }

    public <A, B> Flow<A, B, NotUsed> com$github$j5ik2o$akka$persistence$dynamodb$utils$DispatcherUtils$$applyV2Dispatcher(PluginConfig pluginConfig, Flow<A, B, NotUsed> flow) {
        return (Flow)this.getV2DispatcherName(pluginConfig).fold((Function0 & java.io.Serializable & Serializable)() -> flow, (Function1 & java.io.Serializable & Serializable)name -> flow.withAttributes(ActorAttributes$.MODULE$.dispatcher(name)));
    }

    private DispatcherUtils$() {
        MODULE$ = this;
        LoggingSupport.$init$(this);
    }
}

