/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.utils;

import com.github.j5ik2o.akka.persistence.dynamodb.utils.LoggingSupport;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.runtime.BoxedUnit;

public final class ClassCheckUtils$
implements LoggingSupport {
    public static ClassCheckUtils$ MODULE$;
    private final Logger logger;

    static {
        new ClassCheckUtils$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String requireClassByName(String expectedClassName, String className, boolean validation) {
        this.requireClassByName(expectedClassName, (Option<String>)new Some((Object)className), validation).get();
        return className;
    }

    public String requireClassByName(String expectedClassName, String className) {
        return this.requireClassByName(expectedClassName, className, true);
    }

    public Option<String> requireClassByName(String expectedClassName, Option<String> classNameOpt, boolean validation) {
        Option<String> option = validation ? this.requireClass(Class.forName(expectedClassName), classNameOpt, validation) : BoxedUnit.UNIT;
        return classNameOpt;
    }

    public <A> String requireClass(Class<A> expectedClass, String className) {
        return this.requireClass(expectedClass, className, true);
    }

    public <A> String requireClass(Class<A> expectedClass, String className, boolean validation) {
        this.requireClass(expectedClass, (Option<String>)new Some((Object)className), validation).get();
        return className;
    }

    public <A> Option<String> requireClass(Class<A> expectedClass, Option<String> classNameOpt) {
        return this.requireClass(expectedClass, classNameOpt, true);
    }

    public <A> Option<String> requireClass(Class<A> expectedClass, Option<String> classNameOpt, boolean validation) {
        Option<String> option;
        try {
            if (validation) {
                classNameOpt.foreach((Function1 & java.io.Serializable & Serializable)s -> {
                    Predef$.MODULE$.require(expectedClass.isAssignableFrom(Class.forName(s)), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(57).append("`").append(s).append("` different from the expected the class(").append(expectedClass$1.getName()).append(") was specified.").toString());
                    return BoxedUnit.UNIT;
                });
            }
            option = classNameOpt;
        }
        catch (ClassNotFoundException ex) {
            this.logger().error(new StringBuilder(31).append("The class file of ").append(expectedClass.getName()).append(" is not found").toString(), (Throwable)ex);
            throw ex;
        }
        return option;
    }

    private ClassCheckUtils$() {
        MODULE$ = this;
        LoggingSupport.$init$(this);
    }
}

