/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2;

import com.github.j5ik2o.akka.persistence.dynamodb.config.client.CommonConfigKeys$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.RetryMode$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.V2CommonConfigDefaultValues$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.V2CommonConfigKeys$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.AsyncClientConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.AsyncClientConfig$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.SyncClientConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.SyncClientConfig$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ClassCheckUtils$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ConfigOps$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ConfigOps$ConfigOperations$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.LoggingSupport;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple15;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DynamoDBClientV2Config$
implements LoggingSupport,
scala.Serializable {
    public static DynamoDBClientV2Config$ MODULE$;
    private final String asyncKey;
    private final String syncKey;
    private final String retryPolicyProviderClassNameKey;
    private final String executionInterceptorClassNamesKey;
    private final String executionInterceptorProviderClassNameKey;
    private final String apiCallTimeoutKey;
    private final String apiCallAttemptTimeoutKey;
    private final scala.collection.immutable.Seq<String> keyNames;
    private final String RetryPolicyProviderClassName;
    private final String ExecutionInterceptorsProviderClassName;
    private final Logger logger;

    static {
        new DynamoDBClientV2Config$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String asyncKey() {
        return this.asyncKey;
    }

    public String syncKey() {
        return this.syncKey;
    }

    public String retryPolicyProviderClassNameKey() {
        return this.retryPolicyProviderClassNameKey;
    }

    public String executionInterceptorClassNamesKey() {
        return this.executionInterceptorClassNamesKey;
    }

    public String executionInterceptorProviderClassNameKey() {
        return this.executionInterceptorProviderClassNameKey;
    }

    public String apiCallTimeoutKey() {
        return this.apiCallTimeoutKey;
    }

    public String apiCallAttemptTimeoutKey() {
        return this.apiCallAttemptTimeoutKey;
    }

    public scala.collection.immutable.Seq<String> keyNames() {
        return this.keyNames;
    }

    public scala.collection.immutable.Map<String, Object> existsKeyNames(Config config) {
        return ((TraversableOnce)this.keyNames().map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, (Object)BoxesRunTime.boxToBoolean((boolean)ConfigOps$ConfigOperations$.MODULE$.exists$extension(ConfigOps$.MODULE$.ConfigOperations(config), (String)v))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public String RetryPolicyProviderClassName() {
        return this.RetryPolicyProviderClassName;
    }

    public String ExecutionInterceptorsProviderClassName() {
        return this.ExecutionInterceptorsProviderClassName;
    }

    public DynamoDBClientV2Config fromConfig(Config config, boolean classNameValidation, boolean legacyConfigFormat) {
        AsyncClientConfig asyncClientConfig;
        this.logger().debug("config = {}", new Object[]{config});
        Option option = ConfigOps$ConfigOperations$.MODULE$.valueOptAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), CommonConfigKeys$.MODULE$.dispatcherNameKey());
        if (legacyConfigFormat) {
            this.logger().warn(new StringBuilder(288).append("<<<!!!CAUTION: PLEASE MIGRATE TO NEW CONFIG FORMAT!!!>>>\n\tThe configuration items of AWS-SDK V2 client remain with the old key names: (j5ik2o.dynamo-db-journal.dynamo-db-client).\n\tPlease change current key name to the new key name: (j5ik2o.dynamo-db-journal.dynamo-db-client.v2.async). \n\t").append(((MapLike)AsyncClientConfig$.MODULE$.existsKeyNames(config).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1._2$mcZ$sp()))).keys().mkString("child-keys = [ ", ", ", " ]")).toString());
            asyncClientConfig = AsyncClientConfig$.MODULE$.fromConfig(config);
        } else {
            asyncClientConfig = AsyncClientConfig$.MODULE$.fromConfig(ConfigOps$ConfigOperations$.MODULE$.configAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.asyncKey(), ConfigFactory.empty()));
        }
        String className = (String)ConfigOps$ConfigOperations$.MODULE$.value$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.retryPolicyProviderClassNameKey(), ClassTag$.MODULE$.apply(String.class));
        String className2 = (String)ConfigOps$ConfigOperations$.MODULE$.value$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.executionInterceptorProviderClassNameKey(), ClassTag$.MODULE$.apply(String.class));
        Seq classNames = ConfigOps$ConfigOperations$.MODULE$.valuesAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.executionInterceptorClassNamesKey(), (Seq)Nil$.MODULE$);
        String className3 = (String)ConfigOps$ConfigOperations$.MODULE$.value$extension(ConfigOps$.MODULE$.ConfigOperations(config), V2CommonConfigKeys$.MODULE$.metricPublisherProviderClassNameKey(), ClassTag$.MODULE$.apply(String.class));
        Seq classNames2 = ConfigOps$ConfigOperations$.MODULE$.valuesAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), V2CommonConfigKeys$.MODULE$.metricPublisherClassNameKey(), (Seq)Nil$.MODULE$);
        String className4 = (String)ConfigOps$ConfigOperations$.MODULE$.value$extension(ConfigOps$.MODULE$.ConfigOperations(config), V2CommonConfigKeys$.MODULE$.awsCredentialsProviderProviderClassNameKey(), ClassTag$.MODULE$.apply(String.class));
        Option className5 = ConfigOps$ConfigOperations$.MODULE$.valueOptAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), V2CommonConfigKeys$.MODULE$.awsCredentialsProviderClassNameKey());
        DynamoDBClientV2Config result = new DynamoDBClientV2Config(config, option, asyncClientConfig, SyncClientConfig$.MODULE$.fromConfig(ConfigOps$ConfigOperations$.MODULE$.configAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.syncKey(), ConfigFactory.empty())), ConfigOps$ConfigOperations$.MODULE$.mapAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), CommonConfigKeys$.MODULE$.headersKey(), Map$.MODULE$.empty()), ClassCheckUtils$.MODULE$.requireClassByName(this.RetryPolicyProviderClassName(), className, classNameValidation), (Option<Enumeration.Value>)ConfigOps$ConfigOperations$.MODULE$.valueOptAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), CommonConfigKeys$.MODULE$.retryModeKey()).map((Function1 & Serializable & scala.Serializable)s -> RetryMode$.MODULE$.withName(s.toUpperCase())), ClassCheckUtils$.MODULE$.requireClassByName(this.ExecutionInterceptorsProviderClassName(), className2, classNameValidation), (scala.collection.immutable.Seq<String>)((TraversableOnce)classNames.map((Function1 & Serializable & scala.Serializable)s -> ClassCheckUtils$.MODULE$.requireClassByName(V2CommonConfigDefaultValues$.MODULE$.MetricPublisherClassName(), (String)s, classNameValidation), scala.collection.Seq$.MODULE$.canBuildFrom())).toIndexedSeq(), ConfigOps$ConfigOperations$.MODULE$.valueOptAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.apiCallTimeoutKey()), ConfigOps$ConfigOperations$.MODULE$.valueOptAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.apiCallAttemptTimeoutKey()), ClassCheckUtils$.MODULE$.requireClassByName(V2CommonConfigDefaultValues$.MODULE$.MetricPublishersProviderClassName(), className3, classNameValidation), (Seq<String>)((Seq)classNames2.map((Function1 & Serializable & scala.Serializable)s -> ClassCheckUtils$.MODULE$.requireClassByName(V2CommonConfigDefaultValues$.MODULE$.MetricPublisherClassName(), (String)s, classNameValidation), scala.collection.Seq$.MODULE$.canBuildFrom())), ClassCheckUtils$.MODULE$.requireClassByName(V2CommonConfigDefaultValues$.MODULE$.AwsCredentialsProviderProviderClassName(), className4, classNameValidation), ClassCheckUtils$.MODULE$.requireClassByName(V2CommonConfigDefaultValues$.MODULE$.AwsCredentialsProviderClassName(), className5, classNameValidation));
        this.logger().debug("result = {}", new Object[]{result});
        return result;
    }

    public DynamoDBClientV2Config apply(Config sourceConfig, Option<String> dispatcherName, AsyncClientConfig asyncClientConfig, SyncClientConfig syncClientConfig, Map<String, Seq<String>> headers, String retryPolicyProviderClassName, Option<Enumeration.Value> retryMode, String executionInterceptorsProviderClassName, scala.collection.immutable.Seq<String> executionInterceptorClassNames, Option<FiniteDuration> apiCallTimeout, Option<FiniteDuration> apiCallAttemptTimeout, String metricPublishersProviderClassName, Seq<String> metricPublisherClassNames, String awsCredentialsProviderProviderClassName, Option<String> awsCredentialsProviderClassName) {
        return new DynamoDBClientV2Config(sourceConfig, dispatcherName, asyncClientConfig, syncClientConfig, headers, retryPolicyProviderClassName, retryMode, executionInterceptorsProviderClassName, executionInterceptorClassNames, apiCallTimeout, apiCallAttemptTimeout, metricPublishersProviderClassName, metricPublisherClassNames, awsCredentialsProviderProviderClassName, awsCredentialsProviderClassName);
    }

    public Option<Tuple15<Config, Option<String>, AsyncClientConfig, SyncClientConfig, Map<String, Seq<String>>, String, Option<Enumeration.Value>, String, scala.collection.immutable.Seq<String>, Option<FiniteDuration>, Option<FiniteDuration>, String, Seq<String>, String, Option<String>>> unapply(DynamoDBClientV2Config x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple15((Object)x$0.sourceConfig(), x$0.dispatcherName(), (Object)x$0.asyncClientConfig(), (Object)x$0.syncClientConfig(), x$0.headers(), (Object)x$0.retryPolicyProviderClassName(), x$0.retryMode(), (Object)x$0.executionInterceptorsProviderClassName(), x$0.executionInterceptorClassNames(), x$0.apiCallTimeout(), x$0.apiCallAttemptTimeout(), (Object)x$0.metricPublishersProviderClassName(), x$0.metricPublisherClassNames(), (Object)x$0.awsCredentialsProviderProviderClassName(), x$0.awsCredentialsProviderClassName()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DynamoDBClientV2Config$() {
        MODULE$ = this;
        LoggingSupport.$init$(this);
        this.asyncKey = "async";
        this.syncKey = "sync";
        this.retryPolicyProviderClassNameKey = "retry-policy-provider-class-name";
        this.executionInterceptorClassNamesKey = "execution-interceptor-class-names";
        this.executionInterceptorProviderClassNameKey = "execution-interceptor-provider-class-name";
        this.apiCallTimeoutKey = "api-call-timeout";
        this.apiCallAttemptTimeoutKey = "api-call-attempt-timeout";
        this.keyNames = (scala.collection.immutable.Seq)new .colon.colon((Object)CommonConfigKeys$.MODULE$.dispatcherNameKey(), (List)new .colon.colon((Object)this.asyncKey(), (List)new .colon.colon((Object)this.syncKey(), (List)new .colon.colon((Object)CommonConfigKeys$.MODULE$.retryModeKey(), (List)new .colon.colon((Object)this.apiCallTimeoutKey(), (List)new .colon.colon((Object)this.apiCallAttemptTimeoutKey(), (List)Nil$.MODULE$))))));
        this.RetryPolicyProviderClassName = "com.github.j5ik2o.akka.persistence.dynamodb.client.v2.RetryPolicyProvider";
        this.ExecutionInterceptorsProviderClassName = "com.github.j5ik2o.akka.persistence.dynamodb.client.v2.ExecutionInterceptorsProvider";
    }
}

