/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.config.client;

import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientType$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientVersion$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.DynamoDBClientConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1.DynamoDBClientV1Config;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1.DynamoDBClientV1Config$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1dax.DynamoDBClientV1DaxConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1dax.DynamoDBClientV1DaxConfig$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2dax.DynamoDBClientV2DaxConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2dax.DynamoDBClientV2DaxConfig$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ConfigOps$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.ConfigOps$ConfigOperations$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.LoggingSupport;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple13;
import scala.collection.MapLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DynamoDBClientConfig$
implements LoggingSupport,
scala.Serializable {
    public static DynamoDBClientConfig$ MODULE$;
    private final String accessKeyIdKeyKey;
    private final String secretAccessKeyKey;
    private final String endpointKey;
    private final String regionKey;
    private final String clientVersionKey;
    private final String clientTypeKey;
    private final String v1Key;
    private final String v1DaxKey;
    private final String v2Key;
    private final String v2DaxKey;
    private final String batchGetItemLimitKey;
    private final String batchWriteItemLimitKey;
    private final Logger logger;

    static {
        new DynamoDBClientConfig$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String accessKeyIdKeyKey() {
        return this.accessKeyIdKeyKey;
    }

    public String secretAccessKeyKey() {
        return this.secretAccessKeyKey;
    }

    public String endpointKey() {
        return this.endpointKey;
    }

    public String regionKey() {
        return this.regionKey;
    }

    public String clientVersionKey() {
        return this.clientVersionKey;
    }

    public String clientTypeKey() {
        return this.clientTypeKey;
    }

    public String v1Key() {
        return this.v1Key;
    }

    public String v1DaxKey() {
        return this.v1DaxKey;
    }

    public String v2Key() {
        return this.v2Key;
    }

    public String v2DaxKey() {
        return this.v2DaxKey;
    }

    public String batchGetItemLimitKey() {
        return this.batchGetItemLimitKey;
    }

    public String batchWriteItemLimitKey() {
        return this.batchWriteItemLimitKey;
    }

    public DynamoDBClientConfig fromConfig(Config config, boolean legacyConfigFormat) {
        DynamoDBClientV2Config dynamoDBClientV2Config;
        this.logger().debug("config = {}", new Object[]{config});
        Enumeration.Value clientVersion = ClientVersion$.MODULE$.withName((String)ConfigOps$ConfigOperations$.MODULE$.value$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.clientVersionKey(), ClassTag$.MODULE$.apply(String.class)));
        Option option = ConfigOps$ConfigOperations$.MODULE$.valueOptAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.accessKeyIdKeyKey());
        Option option2 = ConfigOps$ConfigOperations$.MODULE$.valueOptAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.secretAccessKeyKey());
        Option option3 = ConfigOps$ConfigOperations$.MODULE$.valueOptAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.endpointKey());
        Option option4 = ConfigOps$ConfigOperations$.MODULE$.valueOptAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.regionKey());
        Enumeration.Value value = ClientType$.MODULE$.withName((String)ConfigOps$ConfigOperations$.MODULE$.value$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.clientTypeKey(), ClassTag$.MODULE$.apply(String.class)));
        Enumeration.Value value2 = clientVersion;
        Enumeration.Value value3 = ClientVersion$.MODULE$.V1();
        DynamoDBClientV1Config dynamoDBClientV1Config = DynamoDBClientV1Config$.MODULE$.fromConfig(ConfigOps$ConfigOperations$.MODULE$.configAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.v1Key(), ConfigFactory.empty()), !(value2 != null ? !value2.equals(value3) : value3 != null));
        Enumeration.Value value4 = clientVersion;
        Enumeration.Value value5 = ClientVersion$.MODULE$.V1Dax();
        DynamoDBClientV1DaxConfig dynamoDBClientV1DaxConfig = DynamoDBClientV1DaxConfig$.MODULE$.fromConfig(ConfigOps$ConfigOperations$.MODULE$.configAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.v1DaxKey(), ConfigFactory.empty()), !(value4 != null ? !value4.equals(value5) : value5 != null));
        if (legacyConfigFormat) {
            this.logger().warn(new StringBuilder(282).append("<<<!!!CAUTION: PLEASE MIGRATE TO NEW CONFIG FORMAT!!!>>>\n\tThe configuration items of AWS-SDK V2 client remain with the old key names: (j5ik2o.dynamo-db-journal.dynamo-db-client).\n\tPlease change current key name to the new key name: (j5ik2o.dynamo-db-journal.dynamo-db-client.v2). \n\t").append(((MapLike)DynamoDBClientV2Config$.MODULE$.existsKeyNames(config).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1._2$mcZ$sp()))).keys().mkString("child-keys = [ ", ", ", " ]")).toString());
            Enumeration.Value value6 = clientVersion;
            Enumeration.Value value7 = ClientVersion$.MODULE$.V2();
            dynamoDBClientV2Config = DynamoDBClientV2Config$.MODULE$.fromConfig(config, !(value6 != null ? !value6.equals(value7) : value7 != null), legacyConfigFormat);
        } else {
            Enumeration.Value value8 = clientVersion;
            Enumeration.Value value9 = ClientVersion$.MODULE$.V2();
            dynamoDBClientV2Config = DynamoDBClientV2Config$.MODULE$.fromConfig(ConfigOps$ConfigOperations$.MODULE$.configAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.v2Key(), ConfigFactory.empty()), !(value8 != null ? !value8.equals(value9) : value9 != null), legacyConfigFormat);
        }
        Enumeration.Value value10 = clientVersion;
        Enumeration.Value value11 = ClientVersion$.MODULE$.V2();
        DynamoDBClientConfig result = new DynamoDBClientConfig(config, option, option2, option3, option4, clientVersion, value, dynamoDBClientV1Config, dynamoDBClientV1DaxConfig, dynamoDBClientV2Config, DynamoDBClientV2DaxConfig$.MODULE$.fromConfig(ConfigOps$ConfigOperations$.MODULE$.configAs$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.v2DaxKey(), ConfigFactory.empty()), !(value10 != null ? !value10.equals(value11) : value11 != null)), BoxesRunTime.unboxToInt(ConfigOps$ConfigOperations$.MODULE$.value$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.batchGetItemLimitKey(), ClassTag$.MODULE$.Int())), BoxesRunTime.unboxToInt(ConfigOps$ConfigOperations$.MODULE$.value$extension(ConfigOps$.MODULE$.ConfigOperations(config), this.batchWriteItemLimitKey(), ClassTag$.MODULE$.Int())));
        this.logger().debug("result = {}", new Object[]{result});
        return result;
    }

    public DynamoDBClientConfig apply(Config sourceConfig, Option<String> accessKeyId, Option<String> secretAccessKey, Option<String> endpoint, Option<String> region, Enumeration.Value clientVersion, Enumeration.Value clientType, DynamoDBClientV1Config v1ClientConfig, DynamoDBClientV1DaxConfig v1DaxClientConfig, DynamoDBClientV2Config v2ClientConfig, DynamoDBClientV2DaxConfig v2DaxClientConfig, int batchGetItemLimit, int batchWriteItemLimit) {
        return new DynamoDBClientConfig(sourceConfig, accessKeyId, secretAccessKey, endpoint, region, clientVersion, clientType, v1ClientConfig, v1DaxClientConfig, v2ClientConfig, v2DaxClientConfig, batchGetItemLimit, batchWriteItemLimit);
    }

    public Option<Tuple13<Config, Option<String>, Option<String>, Option<String>, Option<String>, Enumeration.Value, Enumeration.Value, DynamoDBClientV1Config, DynamoDBClientV1DaxConfig, DynamoDBClientV2Config, DynamoDBClientV2DaxConfig, Object, Object>> unapply(DynamoDBClientConfig x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple13((Object)x$0.sourceConfig(), x$0.accessKeyId(), x$0.secretAccessKey(), x$0.endpoint(), x$0.region(), (Object)x$0.clientVersion(), (Object)x$0.clientType(), (Object)x$0.v1ClientConfig(), (Object)x$0.v1DaxClientConfig(), (Object)x$0.v2ClientConfig(), (Object)x$0.v2DaxClientConfig(), (Object)BoxesRunTime.boxToInteger((int)x$0.batchGetItemLimit()), (Object)BoxesRunTime.boxToInteger((int)x$0.batchWriteItemLimit())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DynamoDBClientConfig$() {
        MODULE$ = this;
        LoggingSupport.$init$(this);
        this.accessKeyIdKeyKey = "access-key-id";
        this.secretAccessKeyKey = "secret-access-key";
        this.endpointKey = "endpoint";
        this.regionKey = "region";
        this.clientVersionKey = "client-version";
        this.clientTypeKey = "client-type";
        this.v1Key = "v1";
        this.v1DaxKey = "v1-dax";
        this.v2Key = "v2";
        this.v2DaxKey = "v2-dax";
        this.batchGetItemLimitKey = "batch-get-item-limit";
        this.batchWriteItemLimitKey = "batch-write-item-limit";
    }
}

