/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.config.client;

import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientType$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.ClientVersion$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.DynamoDBClientConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1.DynamoDBClientV1Config;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1.DynamoDBClientV1Config$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1dax.DynamoDBClientV1DaxConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v1dax.DynamoDBClientV1DaxConfig$;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.v2.DynamoDBClientV2Config$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.LoggingSupport;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import net.ceedubs.ficus.Ficus$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple12;
import scala.collection.MapLike;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class DynamoDBClientConfig$
implements LoggingSupport,
scala.Serializable {
    public static DynamoDBClientConfig$ MODULE$;
    private final String accessKeyIdKeyKey;
    private final String secretAccessKeyKey;
    private final String endpointKey;
    private final String regionKey;
    private final String clientVersionKey;
    private final String clientTypeKey;
    private final String v1Key;
    private final String v1DaxKey;
    private final String v2Key;
    private final String batchGetItemLimitKey;
    private final String batchWriteItemLimitKey;
    private final Enumeration.Value DefaultClientVersion;
    private final Enumeration.Value DefaultClientType;
    private final int DefaultBatchGetItemLimit;
    private final int DefaultBatchWriteItemLimit;
    private final Logger logger;

    static {
        new DynamoDBClientConfig$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$github$j5ik2o$akka$persistence$dynamodb$utils$LoggingSupport$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String accessKeyIdKeyKey() {
        return this.accessKeyIdKeyKey;
    }

    public String secretAccessKeyKey() {
        return this.secretAccessKeyKey;
    }

    public String endpointKey() {
        return this.endpointKey;
    }

    public String regionKey() {
        return this.regionKey;
    }

    public String clientVersionKey() {
        return this.clientVersionKey;
    }

    public String clientTypeKey() {
        return this.clientTypeKey;
    }

    public String v1Key() {
        return this.v1Key;
    }

    public String v1DaxKey() {
        return this.v1DaxKey;
    }

    public String v2Key() {
        return this.v2Key;
    }

    public String batchGetItemLimitKey() {
        return this.batchGetItemLimitKey;
    }

    public String batchWriteItemLimitKey() {
        return this.batchWriteItemLimitKey;
    }

    public Enumeration.Value DefaultClientVersion() {
        return this.DefaultClientVersion;
    }

    public Enumeration.Value DefaultClientType() {
        return this.DefaultClientType;
    }

    public int DefaultBatchGetItemLimit() {
        return this.DefaultBatchGetItemLimit;
    }

    public int DefaultBatchWriteItemLimit() {
        return this.DefaultBatchWriteItemLimit;
    }

    /*
     * WARNING - void declaration
     */
    public DynamoDBClientConfig fromConfig(Config config, boolean legacyConfigFormat) {
        void var3_3;
        DynamoDBClientV2Config dynamoDBClientV2Config;
        this.logger().debug("config = {}", new Object[]{config});
        Option option = Ficus$.MODULE$.toFicusConfig(config).getAs(this.accessKeyIdKeyKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        Option option2 = Ficus$.MODULE$.toFicusConfig(config).getAs(this.secretAccessKeyKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        Option option3 = Ficus$.MODULE$.toFicusConfig(config).getAs(this.endpointKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        Option option4 = Ficus$.MODULE$.toFicusConfig(config).getAs(this.regionKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader()));
        Enumeration.Value value = (Enumeration.Value)Ficus$.MODULE$.toFicusConfig(config).getAs(this.clientVersionKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader())).map((Function1 & Serializable & scala.Serializable)s -> ClientVersion$.MODULE$.withName((String)s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DefaultClientVersion());
        Enumeration.Value value2 = (Enumeration.Value)Ficus$.MODULE$.toFicusConfig(config).getAs(this.clientTypeKey(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.stringValueReader())).map((Function1 & Serializable & scala.Serializable)s -> ClientType$.MODULE$.withName((String)s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DefaultClientType());
        DynamoDBClientV1Config dynamoDBClientV1Config = DynamoDBClientV1Config$.MODULE$.fromConfig((Config)Ficus$.MODULE$.toFicusConfig(config).getOrElse(this.v1Key(), (Function0 & Serializable & scala.Serializable)() -> ConfigFactory.empty(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.configValueReader())));
        DynamoDBClientV1DaxConfig dynamoDBClientV1DaxConfig = DynamoDBClientV1DaxConfig$.MODULE$.fromConfig((Config)Ficus$.MODULE$.toFicusConfig(config).getOrElse(this.v1DaxKey(), (Function0 & Serializable & scala.Serializable)() -> ConfigFactory.empty(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.configValueReader())));
        if (legacyConfigFormat) {
            this.logger().warn(new StringBuilder(282).append("<<<!!!CAUTION: PLEASE MIGRATE TO NEW CONFIG FORMAT!!!>>>\n\tThe configuration items of AWS-SDK V2 client remain with the old key names: (j5ik2o.dynamo-db-journal.dynamo-db-client).\n\tPlease change current key name to the new key name: (j5ik2o.dynamo-db-journal.dynamo-db-client.v2). \n\t").append(((MapLike)DynamoDBClientV2Config$.MODULE$.existsKeyNames(config).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1._2$mcZ$sp()))).keys().mkString("child-keys = [ ", ", ", " ]")).toString());
            dynamoDBClientV2Config = DynamoDBClientV2Config$.MODULE$.fromConfig(config, legacyConfigFormat);
        } else {
            dynamoDBClientV2Config = DynamoDBClientV2Config$.MODULE$.fromConfig((Config)Ficus$.MODULE$.toFicusConfig(config).getOrElse(this.v2Key(), (Function0 & Serializable & scala.Serializable)() -> ConfigFactory.empty(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.configValueReader())), legacyConfigFormat);
        }
        DynamoDBClientConfig result = new DynamoDBClientConfig(config, (Option<String>)option, (Option<String>)option2, (Option<String>)option3, (Option<String>)option4, value, value2, dynamoDBClientV1Config, dynamoDBClientV1DaxConfig, dynamoDBClientV2Config, BoxesRunTime.unboxToInt((Object)Ficus$.MODULE$.toFicusConfig(config).getOrElse(this.batchGetItemLimitKey(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DefaultBatchGetItemLimit(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.intValueReader()))), BoxesRunTime.unboxToInt((Object)Ficus$.MODULE$.toFicusConfig(config).getOrElse(this.batchWriteItemLimitKey(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.DefaultBatchWriteItemLimit(), Ficus$.MODULE$.optionValueReader(Ficus$.MODULE$.intValueReader()))));
        this.logger().debug("result = {}", new Object[]{result});
        return var3_3;
    }

    public DynamoDBClientConfig apply(Config sourceConfig, Option<String> accessKeyId, Option<String> secretAccessKey, Option<String> endpoint, Option<String> region, Enumeration.Value clientVersion, Enumeration.Value clientType, DynamoDBClientV1Config v1ClientConfig, DynamoDBClientV1DaxConfig v1DaxClientConfig, DynamoDBClientV2Config v2ClientConfig, int batchGetItemLimit, int batchWriteItemLimit) {
        return new DynamoDBClientConfig(sourceConfig, accessKeyId, secretAccessKey, endpoint, region, clientVersion, clientType, v1ClientConfig, v1DaxClientConfig, v2ClientConfig, batchGetItemLimit, batchWriteItemLimit);
    }

    public Option<Tuple12<Config, Option<String>, Option<String>, Option<String>, Option<String>, Enumeration.Value, Enumeration.Value, DynamoDBClientV1Config, DynamoDBClientV1DaxConfig, DynamoDBClientV2Config, Object, Object>> unapply(DynamoDBClientConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.sourceConfig(), x$0.accessKeyId(), x$0.secretAccessKey(), x$0.endpoint(), x$0.region(), (Object)x$0.clientVersion(), (Object)x$0.clientType(), (Object)x$0.v1ClientConfig(), (Object)x$0.v1DaxClientConfig(), (Object)x$0.v2ClientConfig(), (Object)BoxesRunTime.boxToInteger((int)x$0.batchGetItemLimit()), (Object)BoxesRunTime.boxToInteger((int)x$0.batchWriteItemLimit())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DynamoDBClientConfig$() {
        MODULE$ = this;
        LoggingSupport.$init$(this);
        this.accessKeyIdKeyKey = "access-key-id";
        this.secretAccessKeyKey = "secret-access-key";
        this.endpointKey = "endpoint";
        this.regionKey = "region";
        this.clientVersionKey = "client-version";
        this.clientTypeKey = "client-type";
        this.v1Key = "v1";
        this.v1DaxKey = "v1-dax";
        this.v2Key = "v2";
        this.batchGetItemLimitKey = "batch-get-item-limit";
        this.batchWriteItemLimitKey = "batch-write-item-limit";
        this.DefaultClientVersion = ClientVersion$.MODULE$.V2();
        this.DefaultClientType = ClientType$.MODULE$.Async();
        this.DefaultBatchGetItemLimit = 100;
        this.DefaultBatchWriteItemLimit = 25;
    }
}

