/*
 * Decompiled with CFR 0.152.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.utils;

import akka.actor.DynamicAccess;
import akka.event.LoggingAdapter;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.github.j5ik2o.akka.persistence.dynamodb.config.PluginConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.config.client.DynamoDBClientConfig;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.V1DaxClientBuilderUtils$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.V1DynamoDBClientBuilderUtils$;
import com.github.j5ik2o.akka.persistence.dynamodb.utils.V2DynamoDbClientBuilderUtils$;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

public final class ClientUtils$ {
    public static final ClientUtils$ MODULE$;

    static {
        new ClientUtils$();
    }

    public DynamoDbClient createV2SyncClient(DynamicAccess dynamicAccess, String configRootPath, PluginConfig pluginConfig, Function1<DynamoDbClient, BoxedUnit> f, LoggingAdapter log) {
        if (pluginConfig.clientConfig().v2ClientConfig().dispatcherName().isEmpty()) {
            log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please set a dispatcher name defined by you to `", ".dynamo-db-client.v2.dispatcher-name` if you are using the AWS-SDK API for blocking I/O"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configRootPath})));
        }
        DynamoDbClient javaSyncClientV2 = (DynamoDbClient)V2DynamoDbClientBuilderUtils$.MODULE$.setupSync(dynamicAccess, pluginConfig).build();
        f.apply((Object)javaSyncClientV2);
        return javaSyncClientV2;
    }

    public DynamoDbAsyncClient createV2AsyncClient(DynamicAccess dynamicAccess, PluginConfig pluginConfig, Function1<DynamoDbAsyncClient, BoxedUnit> f) {
        DynamoDbAsyncClient javaAsyncClientV2 = (DynamoDbAsyncClient)V2DynamoDbClientBuilderUtils$.MODULE$.setupAsync(dynamicAccess, pluginConfig).build();
        f.apply((Object)javaAsyncClientV2);
        return javaAsyncClientV2;
    }

    public AmazonDynamoDBAsync createV1AsyncClient(DynamicAccess dynamicAccess, PluginConfig pluginConfig) {
        return (AmazonDynamoDBAsync)V1DynamoDBClientBuilderUtils$.MODULE$.setupAsync(dynamicAccess, pluginConfig).build();
    }

    public AmazonDynamoDB createV1SyncClient(DynamicAccess dynamicAccess, String configRootPath, PluginConfig pluginConfig, LoggingAdapter log) {
        if (pluginConfig.clientConfig().v1ClientConfig().dispatcherName().isEmpty()) {
            log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please set a dispatcher name defined by you to `", ".dynamo-db-client.v1.dispatcher-name` if you are using the AWS-SDK API for blocking I/O"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configRootPath})));
        }
        return (AmazonDynamoDB)V1DynamoDBClientBuilderUtils$.MODULE$.setupSync(dynamicAccess, pluginConfig).build();
    }

    public AmazonDynamoDB createV1DaxSyncClient(String configRootPath, DynamoDBClientConfig dynamoDBClientConfig, LoggingAdapter log) {
        if (dynamoDBClientConfig.v1DaxClientConfig().dispatcherName().isEmpty()) {
            log.warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please set a dispatcher name defined by you to `", ".dynamo-db-client.v1-dax.dispatcher-name` if you are using the AWS-SDK API for blocking I/O"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configRootPath})));
        }
        return V1DaxClientBuilderUtils$.MODULE$.setupSync(dynamoDBClientConfig).build();
    }

    public AmazonDynamoDBAsync createV1DaxAsyncClient(DynamoDBClientConfig dynamoDBClientConfig) {
        return V1DaxClientBuilderUtils$.MODULE$.setupAsync(dynamoDBClientConfig).build();
    }

    private ClientUtils$() {
        MODULE$ = this;
    }
}

