/*
 * Copyright 2022 Junichi Kato
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.j5ik2o.akka.persistence.dynamodb.utils

import com.github.j5ik2o.akka.persistence.dynamodb.context.PluginContext
import software.amazon.awssdk.services.dynamodb.{ DynamoDbClient => JavaDynamoDbSyncClient }

trait V2SyncClientFactory {
  def create: JavaDynamoDbSyncClient
}

object V2SyncClientFactory {

  class Default(pluginContext: PluginContext) extends V2SyncClientFactory {
    override def create: JavaDynamoDbSyncClient = {
      V2ClientUtils.createV2SyncClient(
        pluginContext,
        pluginContext.pluginConfig.configRootPath
      )
    }
  }

}
