/*
 * Decompiled with CFR 0.152.
 */
package com.itzmeds.logging.appender;

import com.itzmeds.logging.DailyFileAppenderConfig;
import com.itzmeds.logging.appender.LogAppenderFactory;
import com.itzmeds.logging.appender.exception.LoggerConfigException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;

public class DailyFileLogAppenderFactory
implements LogAppenderFactory<DailyFileAppenderConfig> {
    public static final Map<String, String> LOGGER_LAYOUT_PATTERN = new HashMap<String, String>();
    private static DailyFileLogAppenderFactory dailyFileLogAppenderFactory;

    private DailyFileLogAppenderFactory() {
    }

    public static synchronized DailyFileLogAppenderFactory getInstance() {
        if (dailyFileLogAppenderFactory == null) {
            dailyFileLogAppenderFactory = new DailyFileLogAppenderFactory();
        }
        return dailyFileLogAppenderFactory;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot create clone of this factory class");
    }

    @Override
    public Appender createAppender(DailyFileAppenderConfig logAppConfig) throws LoggerConfigException {
        DailyRollingFileAppender dailyfileLogAppender = null;
        if (LOGGER_LAYOUT_PATTERN.get(logAppConfig.getLoggerLayoutPattern()) == null) {
            throw new LoggerConfigException("Unsupported layout pattern, failed to initalize file log appender.");
        }
        try {
            PatternLayout layout = new PatternLayout(LOGGER_LAYOUT_PATTERN.get(logAppConfig.getLoggerLayoutPattern()));
            switch (logAppConfig.getrollingSchedule()) {
                case "MINUTELY_PATTERN": {
                    dailyfileLogAppender = new DailyRollingFileAppender((Layout)layout, logAppConfig.getLoggerFileBasePath() + (logAppConfig.getLoggerFileBasePath().endsWith("/") ? "" : "/") + logAppConfig.getLoggerFileName(), "yyyy-MM-dd-HH-mm");
                    break;
                }
                case "HOURLY_PATTERN": {
                    dailyfileLogAppender = new DailyRollingFileAppender((Layout)layout, logAppConfig.getLoggerFileBasePath() + (logAppConfig.getLoggerFileBasePath().endsWith("/") ? "" : "/") + logAppConfig.getLoggerFileName(), "yyyy-MM-dd-HH");
                    break;
                }
                case "HALF_DAILY_PATTERN": {
                    dailyfileLogAppender = new DailyRollingFileAppender((Layout)layout, logAppConfig.getLoggerFileBasePath() + (logAppConfig.getLoggerFileBasePath().endsWith("/") ? "" : "/") + logAppConfig.getLoggerFileName(), "yyyy-MM-dd-a");
                    break;
                }
                case "DAILY_PATTERN": {
                    dailyfileLogAppender = new DailyRollingFileAppender((Layout)layout, logAppConfig.getLoggerFileBasePath() + (logAppConfig.getLoggerFileBasePath().endsWith("/") ? "" : "/") + logAppConfig.getLoggerFileName(), "yyyy-MM-dd");
                    break;
                }
                case "WEEKLY_PATTERN": {
                    dailyfileLogAppender = new DailyRollingFileAppender((Layout)layout, logAppConfig.getLoggerFileBasePath() + (logAppConfig.getLoggerFileBasePath().endsWith("/") ? "" : "/") + logAppConfig.getLoggerFileName(), "yyyy-ww");
                    break;
                }
                case "MONTHLY_PATTERN": {
                    dailyfileLogAppender = new DailyRollingFileAppender((Layout)layout, logAppConfig.getLoggerFileBasePath() + (logAppConfig.getLoggerFileBasePath().endsWith("/") ? "" : "/") + logAppConfig.getLoggerFileName(), "yyyy-MM");
                    break;
                }
                default: {
                    throw new LoggerConfigException("Invalid log rotation schedule");
                }
            }
            dailyfileLogAppender.setName(logAppConfig.getLoggerName());
            dailyfileLogAppender.activateOptions();
        }
        catch (IOException e) {
            throw new LoggerConfigException(e);
        }
        return dailyfileLogAppender;
    }

    static {
        LOGGER_LAYOUT_PATTERN.put("DEFAULT_CONVERSION_PATTERN", "%m%n");
        LOGGER_LAYOUT_PATTERN.put("TTCC_CONVERSION_PATTERN", "%r [%t] %p %c %x - %m%n");
        LOGGER_LAYOUT_PATTERN.put("STANDARD_CONVERSION_PATTERN", "%p [%d] %r %m%n");
        dailyFileLogAppenderFactory = null;
    }
}

