/*
 * Decompiled with CFR 0.152.
 */
package com.itzmeds.logging;

import com.itzmeds.logging.DailyFileAppenderConfig;
import com.itzmeds.logging.FileAppenderConfig;
import com.itzmeds.logging.LoggerConfig;
import com.itzmeds.logging.appender.DailyFileLogAppenderFactory;
import com.itzmeds.logging.appender.FileLogAppenderFactory;
import com.itzmeds.logging.appender.LoggerConstants;
import com.itzmeds.logging.appender.exception.LoggerConfigException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class LogConfigurator {
    public static void init(LoggerConfig logConfig) throws LoggerConfigException {
        BasicConfigurator.configure();
        Logger.getRootLogger().getLoggerRepository().resetConfiguration();
        FileLogAppenderFactory fileAppenderFactory = FileLogAppenderFactory.getInstance();
        DailyFileLogAppenderFactory dailyFileLogAppenderFactory = DailyFileLogAppenderFactory.getInstance();
        if (logConfig.getFileAppenderConfig() != null) {
            for (FileAppenderConfig fileAppenderConfig : logConfig.getFileAppenderConfig()) {
                Logger.getLogger((String)fileAppenderConfig.getLoggerName()).addAppender(fileAppenderFactory.createAppender(fileAppenderConfig));
            }
        }
        if (logConfig.getDailyFileAppenderConfig() != null) {
            for (DailyFileAppenderConfig dailyFileAppenderConfig : logConfig.getDailyFileAppenderConfig()) {
                if (!LoggerConstants.DATE_PATTERN.contains(dailyFileAppenderConfig.getrollingSchedule())) {
                    throw new LoggerConfigException("Invalid logger schedule configuration");
                }
                Logger.getLogger((String)dailyFileAppenderConfig.getLoggerName()).addAppender(dailyFileLogAppenderFactory.createAppender(dailyFileAppenderConfig));
            }
        }
    }
}

