/*
 * Decompiled with CFR 0.152.
 */
package com.github.iotexproject.mobile.utils;

import java.math.BigInteger;
import java.util.Arrays;

public class Numeric {
    public static BigInteger toBigInt(byte[] value) {
        return new BigInteger(1, value);
    }

    public static BigInteger toBigInt(String hexValue) {
        return new BigInteger(hexValue, 16);
    }

    public static byte[] hexStringToByteArray(String input) {
        int startIdx;
        byte[] data;
        int len;
        if (input == null) {
            input = "";
        }
        if ((len = input.length()) == 0) {
            return new byte[0];
        }
        if (len % 2 != 0) {
            data = new byte[len / 2 + 1];
            data[0] = (byte)Character.digit(input.charAt(0), 16);
            startIdx = 1;
        } else {
            data = new byte[len / 2];
            startIdx = 0;
        }
        for (int i = startIdx; i < len; i += 2) {
            data[(i + 1) / 2] = (byte)((Character.digit(input.charAt(i), 16) << 4) + Character.digit(input.charAt(i + 1), 16));
        }
        return data;
    }

    public static String toHexString(byte[] input, int offset, int length) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = offset; i < offset + length; ++i) {
            stringBuilder.append(String.format("%02x", input[i] & 0xFF));
        }
        return stringBuilder.toString();
    }

    public static String toHexString(byte[] input) {
        return Numeric.toHexString(input, 0, input.length);
    }

    public static byte[] toBytesPadded(BigInteger value, int length) {
        int srcOffset;
        int bytesLength;
        byte[] result = new byte[length];
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            bytesLength = bytes.length - 1;
            srcOffset = 1;
        } else {
            bytesLength = bytes.length;
            srcOffset = 0;
        }
        if (bytesLength > length) {
            throw new RuntimeException("Input is too large to put in byte array of size " + length);
        }
        int destOffset = length - bytesLength;
        System.arraycopy(bytes, srcOffset, result, destOffset, bytesLength);
        return result;
    }

    public static byte[] bigIntegerToBytes(BigInteger b, int numBytes) {
        if (b == null) {
            return null;
        }
        byte[] bytes = new byte[numBytes];
        byte[] biBytes = b.toByteArray();
        int start = biBytes.length == numBytes + 1 ? 1 : 0;
        int length = Math.min(biBytes.length, numBytes);
        System.arraycopy(biBytes, start, bytes, numBytes - length, length);
        return bytes;
    }

    public static byte[] bigIntegerToBytesSigned(BigInteger b, int numBytes) {
        if (b == null) {
            return null;
        }
        byte[] bytes = new byte[numBytes];
        Arrays.fill(bytes, b.signum() < 0 ? (byte)-1 : 0);
        byte[] biBytes = b.toByteArray();
        int start = biBytes.length == numBytes + 1 ? 1 : 0;
        int length = Math.min(biBytes.length, numBytes);
        System.arraycopy(biBytes, start, bytes, numBytes - length, length);
        return bytes;
    }

    public static byte[] merge(byte[] ... arrays) {
        int count = 0;
        for (byte[] array : arrays) {
            count += array.length;
        }
        byte[] mergedArray = new byte[count];
        int start = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, mergedArray, start, array.length);
            start += array.length;
        }
        return mergedArray;
    }
}

