/*
 * Decompiled with CFR 0.152.
 */
package com.github.iotexproject.mobile.utils;

import java.math.BigDecimal;

public final class Convert {
    private Convert() {
    }

    public static String fromRau(String number, Unit unit) {
        return Convert.fromRau(new BigDecimal(number), unit);
    }

    public static String fromRau(BigDecimal number, Unit unit) {
        return number.divide(unit.getWeiFactor()).toPlainString();
    }

    public static String toRau(String number, Unit unit) {
        return Convert.toRau(new BigDecimal(number), unit);
    }

    public static String toRau(BigDecimal number, Unit unit) {
        return number.multiply(unit.getWeiFactor()).toBigInteger().toString();
    }

    public static enum Unit {
        Rau("Rau", 0),
        KRau("KRau", 3),
        MRau("MRau", 6),
        GRau("GRau", 9),
        Qev("Qev", 12),
        Jing("Jing", 15),
        Iotx("Iotx", 18);

        private String name;
        private BigDecimal weiFactor;

        private Unit(String name, int factor) {
            this.name = name;
            this.weiFactor = BigDecimal.TEN.pow(factor);
        }

        public static Unit fromString(String name) {
            if (name != null) {
                for (Unit unit : Unit.values()) {
                    if (!name.equalsIgnoreCase(unit.name)) continue;
                    return unit;
                }
            }
            return Unit.valueOf(name);
        }

        public BigDecimal getWeiFactor() {
            return this.weiFactor;
        }

        public String toString() {
            return this.name;
        }
    }
}

