/*
 * Decompiled with CFR 0.152.
 */
package com.github.iotexproject.mobile.keystore;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.iotexproject.mobile.account.Account;
import com.github.iotexproject.mobile.keystore.Keystore;
import com.github.iotexproject.mobile.keystore.KeystoreFile;
import com.github.iotexproject.mobile.utils.Numeric;
import java.io.IOException;
import java.math.BigInteger;

public class KeystoreUtils {
    static final ObjectMapper objectMapper = new ObjectMapper();

    public static KeystoreFile createWalletFileByAcount(String password, Account account) {
        return Keystore.createStandard(password, Numeric.toBigInt(account.privateKey()));
    }

    public static KeystoreFile createWalletFileByKey(String password, BigInteger privateKey) {
        return Keystore.createStandard(password, privateKey);
    }

    public static BigInteger loadKeyFromWalletFile(String password, String keystore) {
        try {
            KeystoreFile walletFile = (KeystoreFile)objectMapper.readValue(keystore, KeystoreFile.class);
            return Keystore.decrypt(password, walletFile);
        }
        catch (IOException e) {
            throw new RuntimeException("read keystore json error", e);
        }
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

