/*
 * Decompiled with CFR 0.152.
 */
package com.github.iotexproject.mobile.crypto;

import com.github.iotexproject.mobile.crypto.SECP256K1;
import com.github.iotexproject.mobile.crypto.SignatureData;
import com.github.iotexproject.mobile.utils.Numeric;
import java.math.BigInteger;
import java.util.Arrays;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;

public class Signer {
    public static BigInteger recoverFromSignature(int from, int recId, BigInteger r, BigInteger s, byte[] message) {
        BigInteger prime;
        BigInteger n = SECP256K1.CURVE.getN();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = r.add(i.multiply(n));
        if (x.compareTo(prime = SecP256K1Curve.q) >= 0) {
            return null;
        }
        ECPoint R = Signer.decompressKey(x, (recId & 1) == 1);
        if (!R.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, message);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = r.modInverse(n);
        BigInteger srInv = rInv.multiply(s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)SECP256K1.CURVE.getG(), (BigInteger)eInvrInv, (ECPoint)R, (BigInteger)srInv);
        byte[] qBytes = q.getEncoded(false);
        return new BigInteger(1, Arrays.copyOfRange(qBytes, from, qBytes.length));
    }

    private static ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(SECP256K1.CURVE.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return SECP256K1.CURVE.getCurve().decodePoint(compEnc);
    }

    public static SignatureData sign(BigInteger privateKey, BigInteger publicKey, int addToV, int from, byte[] data) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(privateKey, SECP256K1.CURVE);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(data);
        BigInteger r = components[0];
        BigInteger s = components[1];
        if (s.compareTo(SECP256K1.HALF_CURVE_ORDER) > 0) {
            s = SECP256K1.CURVE.getN().subtract(s);
        }
        int recId = -1;
        for (int i = 0; i < 4; ++i) {
            BigInteger k = Signer.recoverFromSignature(from, i, r, s, data);
            if (k == null || !k.equals(publicKey)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. Are your credentials valid?");
        }
        int headerByte = recId + addToV;
        byte v = (byte)headerByte;
        byte[] cr = Numeric.toBytesPadded(r, 32);
        byte[] cs = Numeric.toBytesPadded(s, 32);
        return new SignatureData(v, cr, cs);
    }
}

