/*
 * Decompiled with CFR 0.152.
 */
package com.github.iotexproject.mobile.contract;

import com.github.iotexproject.grpc.api.ReadContractRequest;
import com.github.iotexproject.grpc.types.Execution;
import com.github.iotexproject.mobile.account.Account;
import com.github.iotexproject.mobile.action.method.ExecutionMethod;
import com.github.iotexproject.mobile.protocol.ExecutionRequest;
import com.github.iotexproject.mobile.rpc.RPCMethod;
import com.github.iotexproject.mobile.solidity.Abi;
import com.github.iotexproject.mobile.utils.Numeric;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.List;

public class Contract {
    private RPCMethod provider;
    private String address;
    private String abiJson;
    private byte[] bin;
    private Abi abi;

    public Contract(RPCMethod provider, String abi) {
        this(provider, "", abi, null);
    }

    public Contract(RPCMethod provider, String address, String abi) {
        this(provider, address, abi, null);
    }

    public Contract(RPCMethod provider, String abi, byte[] bin) {
        this.provider = provider;
        this.address = "";
        this.abiJson = abi;
        this.bin = bin;
        this.abi = Abi.fromJson(abi);
    }

    public Contract(RPCMethod provider, String address, String abi, byte[] bin) {
        this.provider = provider;
        this.address = address;
        this.abiJson = abi;
        this.bin = bin;
        this.abi = Abi.fromJson(abi);
    }

    public void setProvider(RPCMethod provider) {
        this.provider = provider;
    }

    public RPCMethod currentProvider() {
        return this.provider;
    }

    public String deploy(Long nonce, Long gasLimit, String gasPrice, Account account, String amount, Object ... args) {
        if (this.bin == null) {
            throw new RuntimeException("deploy contract must set bin");
        }
        byte[] data = this.bin;
        Abi.Constructor constructor = this.abi.findConstructor();
        if (constructor != null && args != null && args.length > 0) {
            data = Numeric.merge(data, constructor.encode(args));
        }
        ExecutionRequest request = new ExecutionRequest();
        request.setNonce(nonce);
        request.setGasLimit(gasLimit);
        request.setGasPrice(gasPrice);
        request.setAccount(account);
        request.setContract("");
        request.setAmount(amount);
        request.setData(data);
        return new ExecutionMethod(this.provider, request).execute();
    }

    public String execute(Long nonce, Long gasLimit, String gasPrice, Account account, String method, String amount, Object ... args) {
        Abi.Function function = this.abi.findFunction(method);
        if (function == null) {
            throw new RuntimeException("contract method " + method + " not exists.");
        }
        ExecutionRequest request = new ExecutionRequest();
        request.setNonce(nonce);
        request.setGasLimit(gasLimit);
        request.setGasPrice(gasPrice);
        request.setAccount(account);
        request.setContract(this.address);
        request.setAmount(amount);
        request.setData(function.encode(args));
        return new ExecutionMethod(this.provider, request).execute();
    }

    public List<?> read(String callerAddress, String method, Object ... args) {
        Abi.Function function = this.abi.findFunction(method);
        if (function == null) {
            throw new RuntimeException("contract method " + method + " not exists.");
        }
        String result = this.provider.readContract(ReadContractRequest.newBuilder().setExecution(Execution.newBuilder().setContract(this.address).setAmount("0").setData(ByteString.copyFrom((byte[])function.encode(args))).build()).setCallerAddress(callerAddress).build()).getData();
        return function.decodeResult(Numeric.hexStringToByteArray(result));
    }

    public Abi.Function getFunctionBySignature(String signature) {
        for (Abi.Entry entry : this.abi) {
            if (!signature.equals(Numeric.toHexString(entry.encodeSignature()))) continue;
            return (Abi.Function)entry;
        }
        return null;
    }

    public RPCMethod getProvider() {
        return this.provider;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAbiJson() {
        return this.abiJson;
    }

    public byte[] getBin() {
        return this.bin;
    }

    public Abi getAbi() {
        return this.abi;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setAbiJson(String abiJson) {
        this.abiJson = abiJson;
    }

    public void setBin(byte[] bin) {
        this.bin = bin;
    }

    public void setAbi(Abi abi) {
        this.abi = abi;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contract)) {
            return false;
        }
        Contract other = (Contract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RPCMethod this$provider = this.getProvider();
        RPCMethod other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$abiJson = this.getAbiJson();
        String other$abiJson = other.getAbiJson();
        if (this$abiJson == null ? other$abiJson != null : !this$abiJson.equals(other$abiJson)) {
            return false;
        }
        if (!Arrays.equals(this.getBin(), other.getBin())) {
            return false;
        }
        Abi this$abi = this.getAbi();
        Abi other$abi = other.getAbi();
        return !(this$abi == null ? other$abi != null : !((Object)this$abi).equals(other$abi));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Contract;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RPCMethod $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $abiJson = this.getAbiJson();
        result = result * 59 + ($abiJson == null ? 43 : $abiJson.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBin());
        Abi $abi = this.getAbi();
        result = result * 59 + ($abi == null ? 43 : ((Object)$abi).hashCode());
        return result;
    }

    public String toString() {
        return "Contract(provider=" + this.getProvider() + ", address=" + this.getAddress() + ", abiJson=" + this.getAbiJson() + ", bin=" + Arrays.toString(this.getBin()) + ", abi=" + this.getAbi() + ")";
    }
}

