/*
 * Decompiled with CFR 0.152.
 */
package com.github.iotexproject.mobile.action;

import com.github.iotexproject.grpc.types.Action;
import com.github.iotexproject.grpc.types.ActionCore;
import com.github.iotexproject.mobile.action.Envelop;
import com.github.iotexproject.mobile.crypto.Hash;
import com.github.iotexproject.mobile.crypto.SignatureData;
import com.github.iotexproject.mobile.crypto.Signer;
import com.github.iotexproject.mobile.utils.Numeric;
import com.google.protobuf.ByteString;
import java.math.BigInteger;

public class SealedEnvelop {
    private Envelop act;
    private byte[] senderPubKey;
    private byte[] signature;

    private SealedEnvelop() {
    }

    public static SealedEnvelop sign(BigInteger privateKey, BigInteger publicKey, Envelop envelop) {
        SignatureData signatureData = Signer.sign(privateKey, publicKey, 0, 0, Hash.sha3(envelop.byteStream()));
        SealedEnvelop sealedEnvelop = new SealedEnvelop();
        sealedEnvelop.act = envelop;
        sealedEnvelop.senderPubKey = publicKey.toByteArray();
        byte[] signature = new byte[65];
        System.arraycopy(signatureData.getR(), 0, signature, 0, 32);
        System.arraycopy(signatureData.getS(), 0, signature, 32, 32);
        signature[64] = signatureData.getV();
        sealedEnvelop.signature = signature;
        return sealedEnvelop;
    }

    public Action action() {
        ActionCore.Builder builder = ActionCore.newBuilder().setVersion(this.act.getVersion()).setNonce(this.act.getNonce()).setGasLimit(this.act.getGasLimit()).setGasPrice(this.act.getGasPrice());
        if (this.act.getTransfer() != null) {
            builder.setTransfer(this.act.getTransfer());
        }
        if (this.act.getExecution() != null) {
            builder.setExecution(this.act.getExecution());
        }
        if (this.act.getStartSubChain() != null) {
            builder.setStartSubChain(this.act.getStartSubChain());
        }
        if (this.act.getStopSubChain() != null) {
            builder.setStopSubChain(this.act.getStopSubChain());
        }
        if (this.act.getPutBlock() != null) {
            builder.setPutBlock(this.act.getPutBlock());
        }
        if (this.act.getCreateDeposit() != null) {
            builder.setCreateDeposit(this.act.getCreateDeposit());
        }
        if (this.act.getSettleDeposit() != null) {
            builder.setSettleDeposit(this.act.getSettleDeposit());
        }
        if (this.act.getCreatePlumChain() != null) {
            builder.setCreatePlumChain(this.act.getCreatePlumChain());
        }
        if (this.act.getTerminatePlumChain() != null) {
            builder.setTerminatePlumChain(this.act.getTerminatePlumChain());
        }
        if (this.act.getPlumPutBlock() != null) {
            builder.setPlumPutBlock(this.act.getPlumPutBlock());
        }
        if (this.act.getPlumCreateDeposit() != null) {
            builder.setPlumCreateDeposit(this.act.getPlumCreateDeposit());
        }
        if (this.act.getPlumStartExit() != null) {
            builder.setPlumStartExit(this.act.getPlumStartExit());
        }
        if (this.act.getPlumChallengeExit() != null) {
            builder.setPlumChallengeExit(this.act.getPlumChallengeExit());
        }
        if (this.act.getPlumResponseChallengeExit() != null) {
            builder.setPlumResponseChallengeExit(this.act.getPlumResponseChallengeExit());
        }
        if (this.act.getPlumFinalizeExit() != null) {
            builder.setPlumFinalizeExit(this.act.getPlumFinalizeExit());
        }
        if (this.act.getPlumSettleDeposit() != null) {
            builder.setPlumSettleDeposit(this.act.getPlumSettleDeposit());
        }
        if (this.act.getPlumTransfer() != null) {
            builder.setPlumTransfer(this.act.getPlumTransfer());
        }
        if (this.act.getDepositToRewardingFund() != null) {
            builder.setDepositToRewardingFund(this.act.getDepositToRewardingFund());
        }
        if (this.act.getClaimFromRewardingFund() != null) {
            builder.setClaimFromRewardingFund(this.act.getClaimFromRewardingFund());
        }
        if (this.act.getGrantReward() != null) {
            builder.setGrantReward(this.act.getGrantReward());
        }
        if (this.act.getPutPollResult() != null) {
            builder.setPutPollResult(this.act.getPutPollResult());
        }
        return Action.newBuilder().setCore(builder.build()).setSenderPubKey(ByteString.copyFrom((byte[])this.senderPubKey)).setSignature(ByteString.copyFrom((byte[])this.signature)).build();
    }

    public byte[] byteStream() {
        return this.action().toByteArray();
    }

    public String hash() {
        return Numeric.toHexString(Hash.sha3(this.byteStream()));
    }

    public Envelop getAct() {
        return this.act;
    }

    public byte[] getSenderPubKey() {
        return this.senderPubKey;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

