/*
 * Decompiled with CFR 0.152.
 */
package com.github.iotexproject.mobile.account;

import com.github.iotexproject.mobile.account.AbstractAccount;
import com.github.iotexproject.mobile.account.Account;
import com.github.iotexproject.mobile.crypto.Hash;
import com.github.iotexproject.mobile.crypto.SECP256K1;
import com.github.iotexproject.mobile.utils.Numeric;
import java.math.BigInteger;
import java.security.KeyPair;
import java.util.Arrays;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;

public class EthAccount
extends AbstractAccount
implements Account {
    public static final String AddressPrefix = "0x";

    private EthAccount(BigInteger privateKey, BigInteger publicKey) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.address = EthAccount.computeAddress(this.publicKey());
    }

    public static Account create() {
        try {
            return EthAccount.create(SECP256K1.createSecp256k1KeyPair());
        }
        catch (Exception e) {
            throw new RuntimeException("create secp256k1 key error", e);
        }
    }

    public static Account create(KeyPair keyPair) {
        BCECPrivateKey privateKey = (BCECPrivateKey)keyPair.getPrivate();
        BCECPublicKey publicKey = (BCECPublicKey)keyPair.getPublic();
        BigInteger privateKeyValue = privateKey.getD();
        byte[] publicKeyBytes = publicKey.getQ().getEncoded(false);
        BigInteger publicKeyValue = new BigInteger(1, Arrays.copyOfRange(publicKeyBytes, 1, publicKeyBytes.length));
        return new EthAccount(privateKeyValue, publicKeyValue);
    }

    public static Account create(BigInteger privateKey) {
        return new EthAccount(privateKey, SECP256K1.publicKeyFromPrivate(privateKey, 1));
    }

    private static String computeAddress(byte[] publicKey) {
        byte[] hash256 = Hash.sha3(publicKey);
        return AddressPrefix + Numeric.toHexString(hash256).substring(24);
    }

    @Override
    public byte[] publicKey() {
        return Numeric.toBytesPadded(this.publicKey, 64);
    }

    @Override
    public byte[] sign(byte[] data) {
        throw new UnsupportedOperationException("please use web3j to sign");
    }
}

