package com.github.insanusmokrassar.TelegramBotAPI.types.MessageEntity.textsources

import com.github.insanusmokrassar.TelegramBotAPI.CommonAbstracts.MultilevelTextSource
import com.github.insanusmokrassar.TelegramBotAPI.CommonAbstracts.TextPart
import com.github.insanusmokrassar.TelegramBotAPI.utils.*

class StrikethroughTextSource(
    source: String,
    textParts: List<TextPart>
) : MultilevelTextSource {
    override val textParts: List<TextPart> by lazy { source.fullListOfSubSource(textParts) }
    override val asHtmlSource: String by lazy { strikethroughHTML() }
    override val asMarkdownV2Source: String by lazy { strikethroughMarkdownV2() }
    override val asMarkdownSource: String by lazy { source.strikethroughMarkdown() }
}