(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'ktor-ktor-client-core', 'kotlinx-coroutines-core', 'kotlinx-serialization-kotlinx-serialization-runtime', 'ktor-ktor-http', 'ktor-ktor-io', 'klock-root-klock', 'uuid'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('ktor-ktor-client-core'), require('kotlinx-coroutines-core'), require('kotlinx-serialization-kotlinx-serialization-runtime'), require('ktor-ktor-http'), require('ktor-ktor-io'), require('klock-root-klock'), require('uuid'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'TelegramBotAPI'.");
    }
    if (typeof this['ktor-ktor-client-core'] === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI'. Its dependency 'ktor-ktor-client-core' was not found. Please, check whether 'ktor-ktor-client-core' is loaded prior to 'TelegramBotAPI'.");
    }
    if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'TelegramBotAPI'.");
    }
    if (typeof this['kotlinx-serialization-kotlinx-serialization-runtime'] === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI'. Its dependency 'kotlinx-serialization-kotlinx-serialization-runtime' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-runtime' is loaded prior to 'TelegramBotAPI'.");
    }
    if (typeof this['ktor-ktor-http'] === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI'. Its dependency 'ktor-ktor-http' was not found. Please, check whether 'ktor-ktor-http' is loaded prior to 'TelegramBotAPI'.");
    }
    if (typeof this['ktor-ktor-io'] === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI'. Its dependency 'ktor-ktor-io' was not found. Please, check whether 'ktor-ktor-io' is loaded prior to 'TelegramBotAPI'.");
    }
    if (typeof this['klock-root-klock'] === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI'. Its dependency 'klock-root-klock' was not found. Please, check whether 'klock-root-klock' is loaded prior to 'TelegramBotAPI'.");
    }
    if (typeof uuid === 'undefined') {
      throw new Error("Error loading module 'TelegramBotAPI'. Its dependency 'uuid' was not found. Please, check whether 'uuid' is loaded prior to 'TelegramBotAPI'.");
    }
    root.TelegramBotAPI = factory(typeof TelegramBotAPI === 'undefined' ? {} : TelegramBotAPI, kotlin, this['ktor-ktor-client-core'], this['kotlinx-coroutines-core'], this['kotlinx-serialization-kotlinx-serialization-runtime'], this['ktor-ktor-http'], this['ktor-ktor-io'], this['klock-root-klock'], uuid);
  }
}(this, function (_, Kotlin, $module$ktor_ktor_client_core, $module$kotlinx_coroutines_core, $module$kotlinx_serialization_kotlinx_serialization_runtime, $module$ktor_ktor_http, $module$ktor_ktor_io, $module$klock_root_klock, $module$uuid) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var PrimitiveClasses$stringClass = Kotlin.kotlin.reflect.js.internal.PrimitiveClasses.stringClass;
  var createKType = Kotlin.createKType;
  var delay = $module$kotlinx_coroutines_core.kotlinx.coroutines.delay_s8cxhz$;
  var readText = $module$ktor_ktor_client_core.io.ktor.client.statement.readText_rjorc7$;
  var ClientRequestException = $module$ktor_ktor_client_core.io.ktor.client.features.ClientRequestException;
  var HttpClient = $module$ktor_ktor_client_core.io.ktor.client.HttpClient_f0veat$;
  var Json = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.json.Json;
  var asSequence = Kotlin.kotlin.collections.asSequence_7wnvza$;
  var plus = Kotlin.kotlin.sequences.plus_9h40j2$;
  var toList = Kotlin.kotlin.sequences.toList_veqyi0$;
  var throwCCE = Kotlin.throwCCE;
  var call = $module$ktor_ktor_client_core.io.ktor.client.call;
  var TypeInfo_init = $module$ktor_ktor_client_core.io.ktor.client.call.TypeInfo;
  var HttpRequestBuilder = $module$ktor_ktor_client_core.io.ktor.client.request.HttpRequestBuilder;
  var url = $module$ktor_ktor_client_core.io.ktor.client.request.url_g8iu3v$;
  var HttpMethod = $module$ktor_ktor_http.io.ktor.http.HttpMethod;
  var ContentType = $module$ktor_ktor_http.io.ktor.http.ContentType;
  var accept = $module$ktor_ktor_client_core.io.ktor.client.request.accept_fohfhi$;
  var HttpStatement = $module$ktor_ktor_client_core.io.ktor.client.statement.HttpStatement;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var plus_0 = Kotlin.kotlin.collections.plus_iwxh38$;
  var http = $module$ktor_ktor_http.io.ktor.http;
  var Unit = Kotlin.kotlin.Unit;
  var formData = $module$ktor_ktor_client_core.io.ktor.client.request.forms.formData_hut2op$;
  var MultiPartFormDataContent = $module$ktor_ktor_client_core.io.ktor.client.request.forms.MultiPartFormDataContent;
  var HeadersBuilder_init = $module$ktor_ktor_http.io.ktor.http.HeadersBuilder;
  var TextContent = $module$ktor_ktor_http.io.ktor.http.content.TextContent;
  var SerializationStrategy = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.SerializationStrategy;
  var Closeable = $module$ktor_ktor_io.io.ktor.utils.io.core.Closeable;
  var coroutines = $module$kotlinx_coroutines_core.kotlinx.coroutines;
  var CoroutineScope = $module$kotlinx_coroutines_core.kotlinx.coroutines.CoroutineScope_1fupul$;
  var equals = Kotlin.equals;
  var contains = Kotlin.kotlin.text.contains_li3zpu$;
  var IOException = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.io.IOException;
  var NullableSerializer = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal.NullableSerializer;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var SerialClassDescImpl = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal.SerialClassDescImpl;
  var internal = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal;
  var UnknownFieldException = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.UnknownFieldException;
  var GeneratedSerializer = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal.GeneratedSerializer;
  var DateTime = $module$klock_root_klock.com.soywiz.klock.DateTime;
  var L20000 = Kotlin.Long.fromInt(20000);
  var Channel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.Channel_ww73n8$;
  var launch = $module$kotlinx_coroutines_core.kotlinx.coroutines.launch_s496o7$;
  var get_isActive = $module$kotlinx_coroutines_core.kotlinx.coroutines.get_isActive_e9pf1l$;
  var L1000 = Kotlin.Long.fromInt(1000);
  var L0 = Kotlin.Long.ZERO;
  var L10000 = Kotlin.Long.fromInt(10000);
  var intercepted = Kotlin.kotlin.coroutines.intrinsics.intercepted_f9mg25$;
  var SafeContinuation_init = Kotlin.kotlin.coroutines.SafeContinuation_init_wj8d80$;
  var Math_0 = Math;
  var Result = Kotlin.kotlin.Result;
  var MissingFieldException = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.MissingFieldException;
  var ArrayListSerializer = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal.ArrayListSerializer;
  var getKClass = Kotlin.getKClass;
  var withName = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.withName_8new1j$;
  var KSerializer = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.KSerializer;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var LinkedHashMapSerializer = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.internal.LinkedHashMapSerializer;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var mapOf = Kotlin.kotlin.collections.mapOf_x2b85n$;
  var json = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.json;
  var kotlin_js_internal_BooleanCompanionObject = Kotlin.kotlin.js.internal.BooleanCompanionObject;
  var serializer = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.serializer_jtjczu$;
  var Map = Kotlin.kotlin.collections.Map;
  var IntRange = Kotlin.kotlin.ranges.IntRange;
  var listOfNotNull = Kotlin.kotlin.collections.listOfNotNull_jurz7g$;
  var jsonArray = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.json.jsonArray_mb52fq$;
  var toMap = Kotlin.kotlin.collections.toMap_6hr0sd$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var addAll = Kotlin.kotlin.collections.addAll_ipc267$;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var lazy = Kotlin.kotlin.lazy_klfg04$;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var toLongOrNull = Kotlin.kotlin.text.toLongOrNull_pdl1vz$;
  var UnsupportedOperationException_init = Kotlin.kotlin.UnsupportedOperationException_init;
  var UpdateNotSupportedException = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.UpdateNotSupportedException;
  var DeserializationStrategy = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.DeserializationStrategy;
  var until = Kotlin.kotlin.ranges.until_dqglrj$;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  var Mapper = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.Mapper;
  var plus_1 = Kotlin.kotlin.collections.plus_qloxvw$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_4c7yge$;
  var first = Kotlin.kotlin.collections.first_2p1efm$;
  var sortedWith = Kotlin.kotlin.collections.sortedWith_eknfly$;
  var Comparator = Kotlin.kotlin.Comparator;
  var sortWith = Kotlin.kotlin.collections.sortWith_nqfjgj$;
  var Regex_init = Kotlin.kotlin.text.Regex_init_61zpoe$;
  var listOf_0 = Kotlin.kotlin.collections.listOf_i5x0yv$;
  var toList_0 = Kotlin.kotlin.collections.toList_7wnvza$;
  var Any = Object;
  var UnsupportedOperationException_init_0 = Kotlin.kotlin.UnsupportedOperationException_init_pdl1vj$;
  var firstOrNull = Kotlin.kotlin.collections.firstOrNull_2p1efm$;
  var last = Kotlin.kotlin.collections.last_2p1efm$;
  var getCallableRef = Kotlin.getCallableRef;
  var BroadcastChannel = $module$kotlinx_coroutines_core.kotlinx.coroutines.channels.BroadcastChannel_ww73n8$;
  var asFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.asFlow_jlcr6x$;
  var HttpClient_0 = $module$ktor_ktor_client_core.io.ktor.client.HttpClient;
  var Exception = Kotlin.kotlin.Exception;
  var cancel = $module$kotlinx_coroutines_core.kotlinx.coroutines.cancel_jnvdxk$;
  var Annotation = Kotlin.kotlin.Annotation;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init_za3lpa$;
  var chunked = Kotlin.kotlin.text.chunked_94bcnn$;
  var JsonObject = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.json.JsonObject;
  var JsonArray = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.json.JsonArray;
  var JsonPrimitive = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.json.JsonPrimitive;
  var json_0 = $module$kotlinx_serialization_kotlinx_serialization_runtime.kotlinx.serialization.json.json_s5o6vg$;
  var toString = Kotlin.toString;
  var HashMap_init = Kotlin.kotlin.collections.HashMap_init_q3lmfv$;
  var asSequence_0 = Kotlin.kotlin.collections.asSequence_abgq59$;
  var mapNotNull = Kotlin.kotlin.sequences.mapNotNull_qpz9h9$;
  var toMap_0 = Kotlin.kotlin.collections.toMap_ah2ab9$;
  var substring = Kotlin.kotlin.text.substring_fc3b62$;
  var joinToString = Kotlin.kotlin.collections.joinToString_fmv235$;
  var unboxChar = Kotlin.unboxChar;
  var iterator = Kotlin.kotlin.text.iterator_gw00vp$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var async = $module$kotlinx_coroutines_core.kotlinx.coroutines.async_pda6u4$;
  var throwUPAE = Kotlin.throwUPAE;
  var replace = Kotlin.kotlin.text.replace_680rmw$;
  var mutableSetOf = Kotlin.kotlin.collections.mutableSetOf_i5x0yv$;
  var contains_0 = Kotlin.kotlin.collections.contains_2ws7j4$;
  var L30000 = Kotlin.Long.fromInt(30000);
  var uuid4 = $module$uuid.com.benasher44.uuid.uuid4;
  KtorRequestsExecutor.prototype = Object.create(BaseRequestsExecutor.prototype);
  KtorRequestsExecutor.prototype.constructor = KtorRequestsExecutor;
  MultipartRequestCallFactory.prototype = Object.create(AbstractRequestCallFactory.prototype);
  MultipartRequestCallFactory.prototype.constructor = MultipartRequestCallFactory;
  SimpleRequestCallFactory.prototype = Object.create(AbstractRequestCallFactory.prototype);
  SimpleRequestCallFactory.prototype.constructor = SimpleRequestCallFactory;
  RequestException.prototype = Object.create(IOException.prototype);
  RequestException.prototype.constructor = RequestException;
  CommonRequestException.prototype = Object.create(RequestException.prototype);
  CommonRequestException.prototype.constructor = CommonRequestException;
  UnauthorizedException.prototype = Object.create(RequestException.prototype);
  UnauthorizedException.prototype.constructor = UnauthorizedException;
  ReplyMessageNotFoundException.prototype = Object.create(RequestException.prototype);
  ReplyMessageNotFoundException.prototype.constructor = ReplyMessageNotFoundException;
  MessageIsNotModifiedException.prototype = Object.create(RequestException.prototype);
  MessageIsNotModifiedException.prototype.constructor = MessageIsNotModifiedException;
  MessageToEditNotFoundException.prototype = Object.create(RequestException.prototype);
  MessageToEditNotFoundException.prototype.constructor = MessageToEditNotFoundException;
  AddRequest.prototype = Object.create(RequestEvent.prototype);
  AddRequest.prototype.constructor = AddRequest;
  CompleteRequest.prototype = Object.create(RequestEvent.prototype);
  CompleteRequest.prototype.constructor = CompleteRequest;
  FileId.prototype = Object.create(InputFile.prototype);
  FileId.prototype.constructor = FileId;
  MultipartFile.prototype = Object.create(InputFile.prototype);
  MultipartFile.prototype.constructor = MultipartFile;
  ChatId.prototype = Object.create(ChatIdentifier.prototype);
  ChatId.prototype.constructor = ChatId;
  Username.prototype = Object.create(ChatIdentifier.prototype);
  Username.prototype.constructor = Username;
  MarkdownParseMode.prototype = Object.create(ParseMode.prototype);
  MarkdownParseMode.prototype.constructor = MarkdownParseMode;
  MarkdownV2ParseMode.prototype = Object.create(ParseMode.prototype);
  MarkdownV2ParseMode.prototype.constructor = MarkdownV2ParseMode;
  HTMLParseMode.prototype = Object.create(ParseMode.prototype);
  HTMLParseMode.prototype.constructor = HTMLParseMode;
  RetryAfterError.prototype = Object.create(RequestError.prototype);
  RetryAfterError.prototype.constructor = RetryAfterError;
  MigrateChatId.prototype = Object.create(RequestError.prototype);
  MigrateChatId.prototype.constructor = MigrateChatId;
  TypingAction.prototype = Object.create(BotAction.prototype);
  TypingAction.prototype.constructor = TypingAction;
  UploadPhotoAction.prototype = Object.create(BotAction.prototype);
  UploadPhotoAction.prototype.constructor = UploadPhotoAction;
  RecordVideoAction.prototype = Object.create(BotAction.prototype);
  RecordVideoAction.prototype.constructor = RecordVideoAction;
  UploadVideoAction.prototype = Object.create(BotAction.prototype);
  UploadVideoAction.prototype.constructor = UploadVideoAction;
  RecordAudioAction.prototype = Object.create(BotAction.prototype);
  RecordAudioAction.prototype.constructor = RecordAudioAction;
  UploadAudioAction.prototype = Object.create(BotAction.prototype);
  UploadAudioAction.prototype.constructor = UploadAudioAction;
  UploadDocumentAction.prototype = Object.create(BotAction.prototype);
  UploadDocumentAction.prototype.constructor = UploadDocumentAction;
  FindLocationAction.prototype = Object.create(BotAction.prototype);
  FindLocationAction.prototype.constructor = FindLocationAction;
  PayInlineKeyboardButton.prototype = Object.create(InlineKeyboardButton.prototype);
  PayInlineKeyboardButton.prototype.constructor = PayInlineKeyboardButton;
  CallbackDataInlineKeyboardButton.prototype = Object.create(InlineKeyboardButton.prototype);
  CallbackDataInlineKeyboardButton.prototype.constructor = CallbackDataInlineKeyboardButton;
  LoginURLInlineKeyboardButton.prototype = Object.create(InlineKeyboardButton.prototype);
  LoginURLInlineKeyboardButton.prototype.constructor = LoginURLInlineKeyboardButton;
  SwitchInlineQueryCurrentChatInlineKeyboardButton.prototype = Object.create(InlineKeyboardButton.prototype);
  SwitchInlineQueryCurrentChatInlineKeyboardButton.prototype.constructor = SwitchInlineQueryCurrentChatInlineKeyboardButton;
  SwitchInlineQueryInlineKeyboardButton.prototype = Object.create(InlineKeyboardButton.prototype);
  SwitchInlineQueryInlineKeyboardButton.prototype.constructor = SwitchInlineQueryInlineKeyboardButton;
  URLInlineKeyboardButton.prototype = Object.create(InlineKeyboardButton.prototype);
  URLInlineKeyboardButton.prototype.constructor = URLInlineKeyboardButton;
  AnonymousForwardInfo.prototype = Object.create(ForwardInfo.prototype);
  AnonymousForwardInfo.prototype.constructor = AnonymousForwardInfo;
  UserForwardInfo.prototype = Object.create(ForwardInfo.prototype);
  UserForwardInfo.prototype.constructor = UserForwardInfo;
  ForwardFromChannelInfo.prototype = Object.create(ForwardInfo.prototype);
  ForwardFromChannelInfo.prototype.constructor = ForwardFromChannelInfo;
  AnonymousPollOption.prototype = Object.create(PollOption.prototype);
  AnonymousPollOption.prototype.constructor = AnonymousPollOption;
  AddValue.prototype = Object.create(DebounceAction.prototype);
  AddValue.prototype.constructor = AddValue;
  RemoveJob.prototype = Object.create(DebounceAction.prototype);
  RemoveJob.prototype.constructor = RemoveJob;
  function Captioned() {
  }
  Captioned.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Captioned',
    interfaces: []
  };
  function CaptionedOutput() {
  }
  CaptionedOutput.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CaptionedOutput',
    interfaces: [Captioned]
  };
  function CaptionedInput() {
  }
  CaptionedInput.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CaptionedInput',
    interfaces: [Captioned]
  };
  function fullEntitiesList($receiver) {
    var tmp$, tmp$_0, tmp$_1;
    var tmp$_2;
    if ((tmp$_0 = (tmp$ = $receiver.caption) != null ? fullListOfSubSource(tmp$, $receiver.captionEntities) : null) != null) {
      var destination = ArrayList_init(collectionSizeOrDefault(tmp$_0, 10));
      var tmp$_3;
      tmp$_3 = tmp$_0.iterator();
      while (tmp$_3.hasNext()) {
        var item = tmp$_3.next();
        destination.add_11rb$(item.source);
      }
      tmp$_2 = destination;
    }
     else
      tmp$_2 = null;
    return (tmp$_1 = tmp$_2) != null ? tmp$_1 : emptyList();
  }
  function CommonContactData() {
  }
  CommonContactData.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CommonContactData',
    interfaces: []
  };
  function CommonVenueData() {
  }
  CommonVenueData.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CommonVenueData',
    interfaces: [Titled]
  };
  function Livable() {
  }
  Livable.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Livable',
    interfaces: []
  };
  function Locationed() {
  }
  Locationed.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Locationed',
    interfaces: []
  };
  function MimeTyped() {
  }
  MimeTyped.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MimeTyped',
    interfaces: []
  };
  function Performerable() {
  }
  Performerable.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Performerable',
    interfaces: []
  };
  function TextSource() {
  }
  TextSource.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TextSource',
    interfaces: []
  };
  function MultilevelTextSource() {
  }
  MultilevelTextSource.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MultilevelTextSource',
    interfaces: [TextSource]
  };
  function TextPart(range, source) {
    this.range = range;
    this.source = source;
  }
  TextPart.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TextPart',
    interfaces: []
  };
  TextPart.prototype.component1 = function () {
    return this.range;
  };
  TextPart.prototype.component2 = function () {
    return this.source;
  };
  TextPart.prototype.copy_awv2vd$ = function (range, source) {
    return new TextPart(range === void 0 ? this.range : range, source === void 0 ? this.source : source);
  };
  TextPart.prototype.toString = function () {
    return 'TextPart(range=' + Kotlin.toString(this.range) + (', source=' + Kotlin.toString(this.source)) + ')';
  };
  TextPart.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.range) | 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    return result;
  };
  TextPart.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.range, other.range) && Kotlin.equals(this.source, other.source)))));
  };
  function Titled() {
  }
  Titled.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Titled',
    interfaces: []
  };
  function ChatRequest() {
  }
  ChatRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ChatRequest',
    interfaces: []
  };
  function DisableNotification() {
  }
  DisableNotification.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DisableNotification',
    interfaces: []
  };
  function DisableWebPagePreview() {
  }
  DisableWebPagePreview.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DisableWebPagePreview',
    interfaces: []
  };
  function InlineMessageAction() {
  }
  InlineMessageAction.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'InlineMessageAction',
    interfaces: []
  };
  function MessageAction() {
  }
  MessageAction.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MessageAction',
    interfaces: [ChatRequest]
  };
  function ReplyMarkup() {
  }
  ReplyMarkup.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ReplyMarkup',
    interfaces: []
  };
  function ReplyMessageId() {
  }
  ReplyMessageId.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ReplyMessageId',
    interfaces: []
  };
  function UntilDate() {
  }
  UntilDate.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'UntilDate',
    interfaces: []
  };
  function BaseRequestsExecutor(telegramAPIUrlsKeeper) {
    this.telegramAPIUrlsKeeper = telegramAPIUrlsKeeper;
  }
  BaseRequestsExecutor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BaseRequestsExecutor',
    interfaces: [RequestsExecutor]
  };
  function KtorCallFactory() {
  }
  KtorCallFactory.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'KtorCallFactory',
    interfaces: []
  };
  function KtorRequestsExecutor(telegramAPIUrlsKeeper, client, callsFactories, excludeDefaultFactories, requestsLimiter, jsonFormatter) {
    if (client === void 0)
      client = HttpClient();
    if (callsFactories === void 0)
      callsFactories = emptyList();
    if (excludeDefaultFactories === void 0)
      excludeDefaultFactories = false;
    if (requestsLimiter === void 0)
      requestsLimiter = EmptyLimiter_getInstance();
    if (jsonFormatter === void 0)
      jsonFormatter = Json.Companion.nonstrict;
    BaseRequestsExecutor.call(this, telegramAPIUrlsKeeper);
    this.client_0 = client;
    this.requestsLimiter_0 = requestsLimiter;
    this.jsonFormatter_0 = jsonFormatter;
    var $receiver = callsFactories;
    var block$result;
    if (!excludeDefaultFactories) {
      block$result = toList(plus(plus(asSequence($receiver), new SimpleRequestCallFactory()), new MultipartRequestCallFactory()));
    }
     else {
      block$result = $receiver;
    }
    this.callsFactories_0 = block$result;
  }
  function Coroutine$KtorRequestsExecutor$execute$lambda(this$KtorRequestsExecutor_0, closure$request_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 17;
    this.local$this$KtorRequestsExecutor = this$KtorRequestsExecutor_0;
    this.local$closure$request = closure$request_0;
    this.local$tmp$ = void 0;
    this.local$statement = void 0;
    this.local$content = void 0;
    this.local$responseObject = void 0;
    this.local$tmp$_5 = void 0;
    this.local$tmp$_6 = void 0;
    this.local$closure$request_0 = void 0;
    this.local$this$KtorRequestsExecutor_0 = void 0;
    this.local$block$result = void 0;
  }
  Coroutine$KtorRequestsExecutor$execute$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$KtorRequestsExecutor$execute$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$KtorRequestsExecutor$execute$lambda.prototype.constructor = Coroutine$KtorRequestsExecutor$execute$lambda;
  Coroutine$KtorRequestsExecutor$execute$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
            this.local$statement = null;
            this.local$tmp$ = this.local$this$KtorRequestsExecutor.callsFactories_0.iterator();
            this.state_0 = 1;
            continue;
          case 1:
            if (!this.local$tmp$.hasNext()) {
              this.state_0 = 4;
              continue;
            }

            var factory = this.local$tmp$.next();
            this.state_0 = 2;
            this.result_0 = factory.prepareCall_6s6tft$(this.local$this$KtorRequestsExecutor.client_0, this.local$this$KtorRequestsExecutor.telegramAPIUrlsKeeper.commonAPIUrl, this.local$closure$request, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 2:
            this.local$statement = this.result_0;
            if (this.local$statement != null) {
              this.state_0 = 4;
              continue;
            }
             else {
              this.state_0 = 3;
              continue;
            }

          case 3:
            this.state_0 = 1;
            continue;
          case 4:
            this.exceptionState_0 = 13;
            if (this.local$statement != null) {
              this.state_0 = 5;
              this.result_0 = this.local$statement.execute(this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            }
             else {
              this.result_0 = null;
              this.state_0 = 6;
              continue;
            }

          case 5:
            this.state_0 = 6;
            continue;
          case 6:
            tmp$ = this.result_0;
            if (tmp$ == null) {
              throw IllegalArgumentException_init("Can't execute request: " + this.local$closure$request);
            }

            var response = tmp$;
            var tmp$_0_0;
            this.state_0 = 7;
            this.result_0 = response.call.receive_jo9acv$(new TypeInfo_init(PrimitiveClasses$stringClass, call.JsType, createKType(PrimitiveClasses$stringClass, [], false)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 7:
            this.result_0 = typeof (tmp$_0_0 = this.result_0) === 'string' ? tmp$_0_0 : throwCCE();
            this.local$content = this.result_0;
            this.local$responseObject = this.local$this$KtorRequestsExecutor.jsonFormatter_0.parse_awif5v$(Response$Companion_getInstance().serializer(), this.local$content);
            if ((tmp$_2 = (tmp$_0 = this.local$responseObject.result) != null ? this.local$this$KtorRequestsExecutor.jsonFormatter_0.fromJson_htt2tq$(this.local$closure$request.resultDeserializer, tmp$_0) : null) != null) {
              this.local$tmp$_5 = tmp$_2;
              this.state_0 = 12;
              continue;
            }
             else {
              if ((tmp$_1 = this.local$responseObject.parameters) != null) {
                this.local$closure$request_0 = this.local$closure$request;
                this.local$this$KtorRequestsExecutor_0 = this.local$this$KtorRequestsExecutor;
                var error = tmp$_1.error;
                if (Kotlin.isType(error, RetryAfterError)) {
                  this.state_0 = 8;
                  this.result_0 = delay(error.leftToRetry, this);
                  if (this.result_0 === COROUTINE_SUSPENDED)
                    return COROUTINE_SUSPENDED;
                  continue;
                }
                 else {
                  this.local$block$result = null;
                  this.state_0 = 10;
                  continue;
                }
              }
               else {
                this.local$tmp$_6 = null;
                this.state_0 = 11;
                continue;
              }
            }

          case 8:
            this.state_0 = 9;
            this.result_0 = this.local$this$KtorRequestsExecutor_0.execute_2kauxl$(this.local$closure$request_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 9:
            this.local$block$result = this.result_0;
            this.state_0 = 10;
            continue;
          case 10:
            this.local$tmp$_6 = this.local$block$result;
            this.state_0 = 11;
            continue;
          case 11:
            this.local$tmp$_5 = this.local$tmp$_6;
            this.state_0 = 12;
            continue;
          case 12:
            var tmp$_4;
            if ((tmp$_3 = this.local$tmp$_5) != null)
              tmp$_4 = tmp$_3;
            else {
              throw newRequestException(this.local$responseObject, this.local$content, "Can't get result object from " + this.local$content);
            }

            return tmp$_4;
          case 13:
            this.exceptionState_0 = 17;
            var e = this.exception_0;
            if (Kotlin.isType(e, ClientRequestException)) {
              this.state_0 = 14;
              this.result_0 = readText(e.response, void 0, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            }
             else {
              throw e;
            }

          case 14:
            var content = this.result_0;
            var responseObject = this.local$this$KtorRequestsExecutor.jsonFormatter_0.parse_awif5v$(Response$Companion_getInstance().serializer(), content);
            throw newRequestException(responseObject, content, "Can't get result object from " + content);
          case 15:
            this.state_0 = 16;
            continue;
          case 16:
            return;
          case 17:
            throw this.exception_0;
          default:this.state_0 = 17;
            throw new Error('State Machine Unreachable execution');
        }
      }
       catch (e) {
        if (this.state_0 === 17) {
          this.exceptionState_0 = this.state_0;
          throw e;
        }
         else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function KtorRequestsExecutor$execute$lambda(this$KtorRequestsExecutor_0, closure$request_0) {
    return function (continuation_0, suspended) {
      var instance = new Coroutine$KtorRequestsExecutor$execute$lambda(this$KtorRequestsExecutor_0, closure$request_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  KtorRequestsExecutor.prototype.execute_2kauxl$ = function (request, continuation) {
    return this.requestsLimiter_0.limit_lnyleu$(KtorRequestsExecutor$execute$lambda(this, request), continuation);
  };
  KtorRequestsExecutor.prototype.close = function () {
    this.client_0.close();
  };
  KtorRequestsExecutor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KtorRequestsExecutor',
    interfaces: [BaseRequestsExecutor]
  };
  function AbstractRequestCallFactory() {
    this.methodsCache_9lpqhj$_0 = LinkedHashMap_init();
  }
  AbstractRequestCallFactory.prototype.prepareCall_6s6tft$ = function (client, baseUrl, request, continuation) {
    var tmp$;
    tmp$ = this.prepareCallBody_6s6tft$(client, baseUrl, request);
    if (tmp$ == null) {
      return null;
    }
    var preparedBody = tmp$;
    var $receiver = new HttpRequestBuilder();
    var tmp$_0;
    var tmp$_1;
    if ((tmp$_0 = this.methodsCache_9lpqhj$_0.get_11rb$(request.method())) != null)
      tmp$_1 = tmp$_0;
    else {
      var $receiver_0 = baseUrl + '/' + request.method();
      var $receiver_1 = this.methodsCache_9lpqhj$_0;
      var key = request.method();
      $receiver_1.put_xwzc9p$(key, $receiver_0);
      tmp$_1 = $receiver_0;
    }
    url($receiver, tmp$_1);
    $receiver.method = HttpMethod.Companion.Post;
    accept($receiver, ContentType.Application.Json);
    $receiver.body = preparedBody;
    return new HttpStatement($receiver, client);
  };
  AbstractRequestCallFactory.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AbstractRequestCallFactory',
    interfaces: [KtorCallFactory]
  };
  function MultipartRequestCallFactory() {
    AbstractRequestCallFactory.call(this);
  }
  function MultipartRequestCallFactory$prepareCallBody$lambda$lambda$lambda(closure$value) {
    return function () {
      return closure$value.file.asInput();
    };
  }
  function MultipartRequestCallFactory$prepareCallBody$lambda$lambda(closure$castedRequest) {
    return function ($receiver) {
      var tmp$;
      var params = mapWithCommonValues(closure$castedRequest.paramsJson);
      tmp$ = plus_0(closure$castedRequest.mediaMap, params).entries.iterator();
      while (tmp$.hasNext()) {
        var tmp$_0 = tmp$.next();
        var key = tmp$_0.key;
        var value = tmp$_0.value;
        if (Kotlin.isType(value, MultipartFile)) {
          var $receiver_0 = new HeadersBuilder_init();
          $receiver_0.append_puj7f4$(http.HttpHeaders.ContentType, value.mimeType);
          $receiver_0.append_puj7f4$(http.HttpHeaders.ContentDisposition, 'filename=' + value.fileId);
          $receiver.appendInput_yeupz6$(key, $receiver_0.build(), void 0, MultipartRequestCallFactory$prepareCallBody$lambda$lambda$lambda(value));
        }
         else if (Kotlin.isType(value, FileId))
          $receiver.append_xz3v4a$(key, value.fileId);
        else
          $receiver.append_xz3v4a$(key, value.toString());
      }
      return Unit;
    };
  }
  MultipartRequestCallFactory.prototype.prepareCallBody_6s6tft$ = function (client, baseUrl, request) {
    var tmp$, tmp$_0;
    return (tmp$_0 = Kotlin.isType(tmp$ = request, MultipartRequest) ? tmp$ : null) != null ? new MultiPartFormDataContent(formData(MultipartRequestCallFactory$prepareCallBody$lambda$lambda(tmp$_0))) : null;
  };
  MultipartRequestCallFactory.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MultipartRequestCallFactory',
    interfaces: [AbstractRequestCallFactory]
  };
  function SimpleRequestCallFactory() {
    AbstractRequestCallFactory.call(this);
  }
  SimpleRequestCallFactory.prototype.prepareCallBody_6s6tft$ = function (client, baseUrl, request) {
    var tmp$;
    var tmp$_0;
    if ((Kotlin.isType(tmp$ = request, SimpleRequest) ? tmp$ : null) != null) {
      var tmp$_1;
      var serializer = Kotlin.isType(tmp$_1 = request.requestSerializer, SerializationStrategy) ? tmp$_1 : throwCCE();
      var content = withoutNulls_0(Json.Companion.nonstrict.toJson_tf03ej$(serializer, request).jsonObject).toString();
      tmp$_0 = new TextContent(content, ContentType.Application.Json);
    }
     else
      tmp$_0 = null;
    return tmp$_0;
  };
  SimpleRequestCallFactory.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SimpleRequestCallFactory',
    interfaces: [AbstractRequestCallFactory]
  };
  function RequestsExecutor() {
  }
  RequestsExecutor.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'RequestsExecutor',
    interfaces: [Closeable]
  };
  function UpdatesPoller() {
  }
  UpdatesPoller.prototype.start_gkk88$ = function (scope, callback$default) {
    if (scope === void 0)
      scope = CoroutineScope(coroutines.Dispatchers.Default);
    callback$default ? callback$default(scope) : this.start_gkk88$$default(scope);
  };
  UpdatesPoller.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'UpdatesPoller',
    interfaces: [Closeable]
  };
  function newRequestException(response, plainAnswer, message, cause) {
    if (message === void 0)
      message = null;
    if (cause === void 0)
      cause = null;
    var tmp$, tmp$_0;
    var tmp$_1;
    if ((tmp$ = response.description) != null) {
      var block$result;
      if (equals(tmp$, 'Bad Request: reply message not found')) {
        block$result = new ReplyMessageNotFoundException(response, plainAnswer, message, cause);
      }
       else if (equals(tmp$, 'Bad Request: message to edit not found')) {
        block$result = new MessageToEditNotFoundException(response, plainAnswer, message, cause);
      }
       else if (contains(tmp$, 'Bad Request: message is not modified')) {
        block$result = new MessageIsNotModifiedException(response, plainAnswer, message, cause);
      }
       else if (equals(tmp$, 'Unauthorized')) {
        block$result = new UnauthorizedException(response, plainAnswer, message, cause);
      }
       else {
        block$result = null;
      }
      tmp$_1 = block$result;
    }
     else
      tmp$_1 = null;
    return (tmp$_0 = tmp$_1) != null ? tmp$_0 : new CommonRequestException(response, plainAnswer, message, cause);
  }
  function RequestException(response, plainAnswer, message, cause) {
    if (message === void 0)
      message = null;
    if (cause === void 0)
      cause = null;
    IOException.call(this, message != null ? message : 'Something went wrong');
    this.response = response;
    this.plainAnswer = plainAnswer;
    this.cause_bg6qk6$_0 = cause;
    this.name = 'RequestException';
  }
  Object.defineProperty(RequestException.prototype, 'cause', {
    get: function () {
      return this.cause_bg6qk6$_0;
    }
  });
  RequestException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RequestException',
    interfaces: [IOException]
  };
  function CommonRequestException(response, plainAnswer, message, cause) {
    RequestException.call(this, response, plainAnswer, message, cause);
    this.name = 'CommonRequestException';
  }
  CommonRequestException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CommonRequestException',
    interfaces: [RequestException]
  };
  function UnauthorizedException(response, plainAnswer, message, cause) {
    RequestException.call(this, response, plainAnswer, message, cause);
    this.name = 'UnauthorizedException';
  }
  UnauthorizedException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnauthorizedException',
    interfaces: [RequestException]
  };
  function ReplyMessageNotFoundException(response, plainAnswer, message, cause) {
    RequestException.call(this, response, plainAnswer, message, cause);
    this.name = 'ReplyMessageNotFoundException';
  }
  ReplyMessageNotFoundException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ReplyMessageNotFoundException',
    interfaces: [RequestException]
  };
  function MessageIsNotModifiedException(response, plainAnswer, message, cause) {
    RequestException.call(this, response, plainAnswer, message, cause);
    this.name = 'MessageIsNotModifiedException';
  }
  MessageIsNotModifiedException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MessageIsNotModifiedException',
    interfaces: [RequestException]
  };
  function MessageToEditNotFoundException(response, plainAnswer, message, cause) {
    RequestException.call(this, response, plainAnswer, message, cause);
    this.name = 'MessageToEditNotFoundException';
  }
  MessageToEditNotFoundException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MessageToEditNotFoundException',
    interfaces: [RequestException]
  };
  function ProxySettings(host, port, username, password) {
    ProxySettings$Companion_getInstance();
    if (host === void 0)
      host = 'localhost';
    if (port === void 0)
      port = 1080;
    if (username === void 0)
      username = null;
    if (password === void 0)
      password = null;
    this.host = host;
    this.port = port;
    this.username = username;
    this.password = password;
  }
  function ProxySettings$Companion() {
    ProxySettings$Companion_instance = this;
  }
  ProxySettings$Companion.prototype.serializer = function () {
    return ProxySettings$$serializer_getInstance();
  };
  ProxySettings$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ProxySettings$Companion_instance = null;
  function ProxySettings$Companion_getInstance() {
    if (ProxySettings$Companion_instance === null) {
      new ProxySettings$Companion();
    }
    return ProxySettings$Companion_instance;
  }
  function ProxySettings$$serializer() {
    this.descriptor_bt9ecs$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.bot.settings.ProxySettings', this);
    this.descriptor.addElement_ivxn3r$('host', true);
    this.descriptor.addElement_ivxn3r$('port', true);
    this.descriptor.addElement_ivxn3r$('username', true);
    this.descriptor.addElement_ivxn3r$('password', true);
    ProxySettings$$serializer_instance = this;
  }
  Object.defineProperty(ProxySettings$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_bt9ecs$_0;
    }
  });
  ProxySettings$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    if (!equals(obj.host, 'localhost') || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 0))
      output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.host);
    if (!equals(obj.port, 1080) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeIntElement_4wpqag$(this.descriptor, 1, obj.port);
    if (!equals(obj.username, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.StringSerializer, obj.username);
    if (!equals(obj.password, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.password);
    output.endStructure_qatsm0$(this.descriptor);
  };
  ProxySettings$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeIntElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return ProxySettings_init(bitMask0, local0, local1, local2, local3, null);
  };
  ProxySettings$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.IntSerializer, new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer)];
  };
  ProxySettings$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var ProxySettings$$serializer_instance = null;
  function ProxySettings$$serializer_getInstance() {
    if (ProxySettings$$serializer_instance === null) {
      new ProxySettings$$serializer();
    }
    return ProxySettings$$serializer_instance;
  }
  function ProxySettings_init(seen1, host, port, username, password, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(ProxySettings.prototype);
    if ((seen1 & 1) === 0)
      $this.host = 'localhost';
    else
      $this.host = host;
    if ((seen1 & 2) === 0)
      $this.port = 1080;
    else
      $this.port = port;
    if ((seen1 & 4) === 0)
      $this.username = null;
    else
      $this.username = username;
    if ((seen1 & 8) === 0)
      $this.password = null;
    else
      $this.password = password;
    return $this;
  }
  ProxySettings.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ProxySettings',
    interfaces: []
  };
  ProxySettings.prototype.component1 = function () {
    return this.host;
  };
  ProxySettings.prototype.component2 = function () {
    return this.port;
  };
  ProxySettings.prototype.component3 = function () {
    return this.username;
  };
  ProxySettings.prototype.component4 = function () {
    return this.password;
  };
  ProxySettings.prototype.copy_j9igls$ = function (host, port, username, password) {
    return new ProxySettings(host === void 0 ? this.host : host, port === void 0 ? this.port : port, username === void 0 ? this.username : username, password === void 0 ? this.password : password);
  };
  ProxySettings.prototype.toString = function () {
    return 'ProxySettings(host=' + Kotlin.toString(this.host) + (', port=' + Kotlin.toString(this.port)) + (', username=' + Kotlin.toString(this.username)) + (', password=' + Kotlin.toString(this.password)) + ')';
  };
  ProxySettings.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.host) | 0;
    result = result * 31 + Kotlin.hashCode(this.port) | 0;
    result = result * 31 + Kotlin.hashCode(this.username) | 0;
    result = result * 31 + Kotlin.hashCode(this.password) | 0;
    return result;
  };
  ProxySettings.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.host, other.host) && Kotlin.equals(this.port, other.port) && Kotlin.equals(this.username, other.username) && Kotlin.equals(this.password, other.password)))));
  };
  function now() {
    return DateTime.Companion.nowUnixLong();
  }
  function CommonLimiter(lockCount, regenTime) {
    if (lockCount === void 0)
      lockCount = 10;
    if (regenTime === void 0)
      regenTime = L20000;
    this.lockCount_0 = lockCount;
    this.regenTime_0 = regenTime;
    this.doLimit_0 = false;
    this.counterChannel_0 = Channel(2147483647);
    this.scope_0 = CoroutineScope(coroutines.Dispatchers.Default);
    this.counterJob_0 = launch(this.scope_0, void 0, void 0, CommonLimiter$counterJob$lambda(this));
    this.quoterChannel_0 = Channel(-1);
    this.tickerJob_0 = launch(this.scope_0, void 0, void 0, CommonLimiter$tickerJob$lambda(this));
  }
  function Coroutine$limit_lnyleu$($this, block_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$block = block_0;
  }
  Coroutine$limit_lnyleu$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$limit_lnyleu$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$limit_lnyleu$.prototype.constructor = Coroutine$limit_lnyleu$;
  Coroutine$limit_lnyleu$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.counterChannel_0.send_11rb$(Unit, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.$this.doLimit_0) {
              this.state_0 = 5;
              this.result_0 = this.local$block(this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            }
             else {
              this.state_0 = 3;
              this.result_0 = this.$this.quoterChannel_0.receive(this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            }

          case 3:
            this.state_0 = 4;
            this.result_0 = this.local$block(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            this.local$tmp$ = this.result_0;
            this.state_0 = 6;
            continue;
          case 5:
            this.local$tmp$ = this.result_0;
            this.state_0 = 6;
            continue;
          case 6:
            return this.local$tmp$;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      }
       catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        }
         else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  CommonLimiter.prototype.limit_lnyleu$ = function (block_0, continuation_0, suspended) {
    var instance = new Coroutine$limit_lnyleu$(this, block_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$CommonLimiter$counterJob$lambda$lambda(this$CommonLimiter_0, closure$removeLimitTime_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$CommonLimiter = this$CommonLimiter_0;
    this.local$closure$removeLimitTime = closure$removeLimitTime_0;
    this.local$internalNow = void 0;
  }
  Coroutine$CommonLimiter$counterJob$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$CommonLimiter$counterJob$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$CommonLimiter$counterJob$lambda$lambda.prototype.constructor = Coroutine$CommonLimiter$counterJob$lambda$lambda;
  Coroutine$CommonLimiter$counterJob$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$this$CommonLimiter.doLimit_0 = true;
            this.local$internalNow = now();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (this.local$internalNow.compareTo_11rb$(this.local$closure$removeLimitTime.v) >= 0) {
              this.state_0 = 4;
              continue;
            }

            this.state_0 = 3;
            this.result_0 = delay(this.local$closure$removeLimitTime.v.subtract(this.local$internalNow), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.local$internalNow = now();
            this.state_0 = 2;
            continue;
          case 4:
            return this.local$this$CommonLimiter.doLimit_0 = false, Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      }
       catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        }
         else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function CommonLimiter$counterJob$lambda$lambda(this$CommonLimiter_0, closure$removeLimitTime_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$CommonLimiter$counterJob$lambda$lambda(this$CommonLimiter_0, closure$removeLimitTime_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$CommonLimiter$counterJob$lambda(this$CommonLimiter_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$CommonLimiter = this$CommonLimiter_0;
    this.local$tmp$ = void 0;
    this.local$wasLastSecond = void 0;
    this.local$lastCountTime = void 0;
    this.local$limitManagementJob = void 0;
    this.local$removeLimitTime = void 0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$CommonLimiter$counterJob$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$CommonLimiter$counterJob$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$CommonLimiter$counterJob$lambda.prototype.constructor = Coroutine$CommonLimiter$counterJob$lambda;
  Coroutine$CommonLimiter$counterJob$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.local$wasLastSecond = 0;
            this.local$lastCountTime = now();
            this.local$limitManagementJob = null;
            this.local$removeLimitTime = {v: this.local$lastCountTime};
            this.local$tmp$ = this.local$this$CommonLimiter.counterChannel_0.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$tmp$.hasNext(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            if (!this.result_0) {
              this.state_0 = 5;
              continue;
            }
             else {
              this.state_0 = 4;
              continue;
            }

          case 4:
            var counter = this.local$tmp$.next();
            var now_0 = now();
            if (now_0.subtract(this.local$lastCountTime).toNumber() > 1000) {
              this.local$lastCountTime = now_0;
              this.local$wasLastSecond = 1;
            }
             else {
              this.local$wasLastSecond = this.local$wasLastSecond + 1 | 0;
            }

            if (this.local$wasLastSecond >= this.local$this$CommonLimiter.lockCount_0) {
              this.local$removeLimitTime.v = now_0.add(this.local$this$CommonLimiter.regenTime_0);
              if (this.local$limitManagementJob == null) {
                this.local$limitManagementJob = launch(this.local$$receiver, void 0, void 0, CommonLimiter$counterJob$lambda$lambda(this.local$this$CommonLimiter, this.local$removeLimitTime));
              }
            }

            if (now_0.compareTo_11rb$(this.local$removeLimitTime.v) > 0) {
              this.local$limitManagementJob = null;
            }

            this.state_0 = 2;
            continue;
          case 5:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      }
       catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        }
         else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function CommonLimiter$counterJob$lambda(this$CommonLimiter_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$CommonLimiter$counterJob$lambda(this$CommonLimiter_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$CommonLimiter$tickerJob$lambda(this$CommonLimiter_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$CommonLimiter = this$CommonLimiter_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$CommonLimiter$tickerJob$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$CommonLimiter$tickerJob$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$CommonLimiter$tickerJob$lambda.prototype.constructor = Coroutine$CommonLimiter$tickerJob$lambda;
  Coroutine$CommonLimiter$tickerJob$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!get_isActive(this.local$$receiver)) {
              this.state_0 = 5;
              continue;
            }

            this.state_0 = 3;
            this.result_0 = this.local$this$CommonLimiter.quoterChannel_0.send_11rb$(Unit, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.state_0 = 4;
            this.result_0 = delay(L1000, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 4:
            this.state_0 = 2;
            continue;
          case 5:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      }
       catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        }
         else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function CommonLimiter$tickerJob$lambda(this$CommonLimiter_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$CommonLimiter$tickerJob$lambda(this$CommonLimiter_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  CommonLimiter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CommonLimiter',
    interfaces: [RequestLimiter]
  };
  function EmptyLimiter() {
    EmptyLimiter_instance = this;
  }
  EmptyLimiter.prototype.limit_lnyleu$ = function (block, continuation) {
    return block(continuation);
  };
  EmptyLimiter.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'EmptyLimiter',
    interfaces: [RequestLimiter]
  };
  var EmptyLimiter_instance = null;
  function EmptyLimiter_getInstance() {
    if (EmptyLimiter_instance === null) {
      new EmptyLimiter();
    }
    return EmptyLimiter_instance;
  }
  function suspendCoroutine$lambda(closure$block) {
    return function (c) {
      var safe = SafeContinuation_init(intercepted(c));
      closure$block(safe);
      return safe.getOrThrow();
    };
  }
  function RequestEvent() {
  }
  RequestEvent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RequestEvent',
    interfaces: []
  };
  function AddRequest(continuation) {
    RequestEvent.call(this);
    this.continuation = continuation;
  }
  AddRequest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AddRequest',
    interfaces: [RequestEvent]
  };
  function CompleteRequest() {
    CompleteRequest_instance = this;
    RequestEvent.call(this);
  }
  CompleteRequest.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'CompleteRequest',
    interfaces: [RequestEvent]
  };
  var CompleteRequest_instance = null;
  function CompleteRequest_getInstance() {
    if (CompleteRequest_instance === null) {
      new CompleteRequest();
    }
    return CompleteRequest_instance;
  }
  function PowLimiter(minAwaitTime, maxAwaitTime, powValue, powK) {
    PowLimiter$Companion_getInstance();
    if (minAwaitTime === void 0)
      minAwaitTime = L0;
    if (maxAwaitTime === void 0)
      maxAwaitTime = L10000;
    if (powValue === void 0)
      powValue = 4.0;
    if (powK === void 0)
      powK = 0.0016;
    this.minAwaitTime_0 = minAwaitTime;
    this.maxAwaitTime_0 = maxAwaitTime;
    this.powValue_0 = powValue;
    this.powK_0 = powK;
    this.scope_0 = CoroutineScope(coroutines.Dispatchers.Default);
    this.eventsChannel_0 = Channel(2147483647);
    this.awaitTimeRange_0 = this.minAwaitTime_0.rangeTo(this.maxAwaitTime_0);
    launch(this.scope_0, void 0, void 0, PowLimiter_init$lambda(this));
  }
  function Coroutine$PowLimiter$limit$lambda$lambda(this$PowLimiter_0, closure$it_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$PowLimiter = this$PowLimiter_0;
    this.local$closure$it = closure$it_0;
  }
  Coroutine$PowLimiter$limit$lambda$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PowLimiter$limit$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PowLimiter$limit$lambda$lambda.prototype.constructor = Coroutine$PowLimiter$limit$lambda$lambda;
  Coroutine$PowLimiter$limit$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$PowLimiter.eventsChannel_0.send_11rb$(new AddRequest(this.local$closure$it), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      }
       catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        }
         else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PowLimiter$limit$lambda$lambda(this$PowLimiter_0, closure$it_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$PowLimiter$limit$lambda$lambda(this$PowLimiter_0, closure$it_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function PowLimiter$limit$lambda(this$PowLimiter) {
    return function (it) {
      launch(this$PowLimiter.scope_0, void 0, void 0, PowLimiter$limit$lambda$lambda(this$PowLimiter, it));
      return Unit;
    };
  }
  function Coroutine$limit_lnyleu$_0($this, block_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 8;
    this.$this = $this;
    this.local$tmp$ = void 0;
    this.local$block = block_0;
  }
  Coroutine$limit_lnyleu$_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$limit_lnyleu$_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$limit_lnyleu$_0.prototype.constructor = Coroutine$limit_lnyleu$_0;
  Coroutine$limit_lnyleu$_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 1;
            this.result_0 = suspendCoroutine$lambda(PowLimiter$limit$lambda(this.$this))(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            this.result_0;
            var delayMillis = this.result_0;
            this.state_0 = 2;
            this.result_0 = delay(delayMillis, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 2:
            this.exceptionState_0 = 5;
            this.state_0 = 3;
            this.result_0 = this.local$block(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            this.local$tmp$ = this.result_0;
            this.exceptionState_0 = 8;
            this.finallyPath_0 = [4];
            this.state_0 = 6;
            continue;
          case 4:
            return this.local$tmp$;
          case 5:
            this.finallyPath_0 = [8];
            this.state_0 = 6;
            continue;
          case 6:
            this.exceptionState_0 = 8;
            this.state_0 = 7;
            this.result_0 = this.$this.eventsChannel_0.send_11rb$(CompleteRequest_getInstance(), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 7:
            this.state_0 = this.finallyPath_0.shift();
            continue;
          case 8:
            throw this.exception_0;
          default:this.state_0 = 8;
            throw new Error('State Machine Unreachable execution');
        }
      }
       catch (e) {
        if (this.state_0 === 8) {
          this.exceptionState_0 = this.state_0;
          throw e;
        }
         else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PowLimiter.prototype.limit_lnyleu$ = function (block_0, continuation_0, suspended) {
    var instance = new Coroutine$limit_lnyleu$_0(this, block_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function PowLimiter$Companion() {
    PowLimiter$Companion_instance = this;
  }
  PowLimiter$Companion.prototype.serializer = function () {
    return PowLimiter$$serializer_getInstance();
  };
  PowLimiter$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PowLimiter$Companion_instance = null;
  function PowLimiter$Companion_getInstance() {
    if (PowLimiter$Companion_instance === null) {
      new PowLimiter$Companion();
    }
    return PowLimiter$Companion_instance;
  }
  function PowLimiter$$serializer() {
    this.descriptor_24tbde$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.bot.settings.limiters.PowLimiter', this);
    this.descriptor.addElement_ivxn3r$('minAwaitTime', true);
    this.descriptor.addElement_ivxn3r$('maxAwaitTime', true);
    this.descriptor.addElement_ivxn3r$('powValue', true);
    this.descriptor.addElement_ivxn3r$('powK', true);
    PowLimiter$$serializer_instance = this;
  }
  Object.defineProperty(PowLimiter$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_24tbde$_0;
    }
  });
  PowLimiter$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    if (!equals(obj.minAwaitTime_0, L0) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 0))
      output.encodeLongElement_a3zgoj$(this.descriptor, 0, obj.minAwaitTime_0);
    if (!equals(obj.maxAwaitTime_0, L10000) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.maxAwaitTime_0);
    if (!equals(obj.powValue_0, 4.0) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeDoubleElement_imzr5k$(this.descriptor, 2, obj.powValue_0);
    if (!equals(obj.powK_0, 0.0016) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeDoubleElement_imzr5k$(this.descriptor, 3, obj.powK_0);
    output.endStructure_qatsm0$(this.descriptor);
  };
  PowLimiter$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeLongElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeDoubleElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeDoubleElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return PowLimiter_init(bitMask0, local0, local1, local2, local3, null);
  };
  PowLimiter$$serializer.prototype.childSerializers = function () {
    return [internal.LongSerializer, internal.LongSerializer, internal.DoubleSerializer, internal.DoubleSerializer];
  };
  PowLimiter$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var PowLimiter$$serializer_instance = null;
  function PowLimiter$$serializer_getInstance() {
    if (PowLimiter$$serializer_instance === null) {
      new PowLimiter$$serializer();
    }
    return PowLimiter$$serializer_instance;
  }
  function Coroutine$PowLimiter_init$lambda(this$PowLimiter, $receiver_1, continuation_1, $receiver_2, controller, continuation_2) {
    CoroutineImpl.call(this, continuation_2);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$this$PowLimiter = this$PowLimiter;
    this.local$tmp$ = void 0;
    this.local$requestsInWork = void 0;
  }
  Coroutine$PowLimiter_init$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PowLimiter_init$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PowLimiter_init$lambda.prototype.constructor = Coroutine$PowLimiter_init$lambda;
  Coroutine$PowLimiter_init$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$, tmp$_0;
            this.local$requestsInWork = 0.0;
            this.local$tmp$ = this.local$this$PowLimiter.eventsChannel_0.iterator();
            this.state_0 = 2;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$tmp$.hasNext(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            if (!this.result_0) {
              this.state_0 = 5;
              continue;
            }
             else {
              this.state_0 = 4;
              continue;
            }

          case 4:
            var event = this.local$tmp$.next();
            if (Kotlin.isType(event, AddRequest)) {
              var $receiver = this.local$requestsInWork;
              var x = this.local$this$PowLimiter.powValue_0;
              var awaitTime = Kotlin.Long.fromNumber(Math_0.pow($receiver, x) * this.local$this$PowLimiter.powK_0 * L1000.toNumber());
              this.local$requestsInWork = this.local$requestsInWork + 1;
              tmp$_0 = event.continuation;
              if (this.local$this$PowLimiter.awaitTimeRange_0.contains_mef7kx$(awaitTime)) {
                tmp$ = awaitTime;
              }
               else {
                if (awaitTime.compareTo_11rb$(this.local$this$PowLimiter.minAwaitTime_0) < 0) {
                  tmp$ = this.local$this$PowLimiter.minAwaitTime_0;
                }
                 else {
                  tmp$ = this.local$this$PowLimiter.maxAwaitTime_0;
                }
              }
              var value = tmp$;
              tmp$_0.resumeWith_tl1gpc$(new Result(value));
            }
             else if (Kotlin.isType(event, CompleteRequest)) {
              this.local$requestsInWork = this.local$requestsInWork - 1;
            }
             else
              Kotlin.noWhenBranchMatched();
            this.state_0 = 2;
            continue;
          case 5:
            return Unit;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      }
       catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        }
         else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PowLimiter_init$lambda(this$PowLimiter) {
    return function ($receiver_1, continuation_1, $receiver_2, continuation_2, suspended, suspended_1) {
      var instance_0 = new Coroutine$PowLimiter_init$lambda_0(this$PowLimiter_0, $receiver_1, continuation_1, $receiver_2, continuation_2, this, suspended);
      if (suspended_1)
        return instance_0;
      else
        return instance_0.doResume(null);
    };
  }
  function PowLimiter_init(seen1, minAwaitTime, maxAwaitTime, powValue, powK, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(PowLimiter.prototype);
    if ((seen1 & 1) === 0)
      $this.minAwaitTime_0 = L0;
    else
      $this.minAwaitTime_0 = minAwaitTime;
    if ((seen1 & 2) === 0)
      $this.maxAwaitTime_0 = L10000;
    else
      $this.maxAwaitTime_0 = maxAwaitTime;
    if ((seen1 & 4) === 0)
      $this.powValue_0 = 4.0;
    else
      $this.powValue_0 = powValue;
    if ((seen1 & 8) === 0)
      $this.powK_0 = 0.0016;
    else
      $this.powK_0 = powK;
    $this.scope_0 = CoroutineScope(coroutines.Dispatchers.Default);
    $this.eventsChannel_0 = Channel(2147483647);
    $this.awaitTimeRange_0 = $this.minAwaitTime_0.rangeTo($this.maxAwaitTime_0);
    launch($this.scope_0, void 0, void 0, PowLimiter_init$lambda($this));
    return $this;
  }
  function Coroutine$PowLimiter_init$lambda_0(this$PowLimiter_0, $receiver_1, continuation_1, $receiver_2, continuation_2, controller, suspended) {
    CoroutineImpl.call(this, suspended);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$$receiver = $receiver_1;
    this.local$continuation = continuation_1;
    this.local$$receiver_0 = $receiver_2;
    this.local$continuation_0 = continuation_2;
  }
  Coroutine$PowLimiter_init$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$PowLimiter_init$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$PowLimiter_init$lambda_0.prototype.constructor = Coroutine$PowLimiter_init$lambda_0;
  Coroutine$PowLimiter_init$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var instance = new Coroutine$PowLimiter_init$lambda(this$PowLimiter, this.local$$receiver, this.local$continuation, this.local$$receiver_0, this.$this, this.local$continuation_0);
            if (suspended)
              return instance;
            else
              return instance.doResume(null);
          case 1:
            throw this.exception_0;
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      }
       catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        }
         else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function PowLimiter_init$lambda(this$PowLimiter_0) {
    return function ($receiver_1, continuation_1, $receiver_2, continuation_2, suspended, suspended_1) {
      var instance_0 = new Coroutine$PowLimiter_init$lambda_0(this$PowLimiter_0, $receiver_1, continuation_1, $receiver_2, continuation_2, this, suspended);
      if (suspended_1)
        return instance_0;
      else
        return instance_0.doResume(null);
    };
  }
  PowLimiter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PowLimiter',
    interfaces: [RequestLimiter]
  };
  PowLimiter.prototype.component1_0 = function () {
    return this.minAwaitTime_0;
  };
  PowLimiter.prototype.component2_0 = function () {
    return this.maxAwaitTime_0;
  };
  PowLimiter.prototype.component3_0 = function () {
    return this.powValue_0;
  };
  PowLimiter.prototype.component4_0 = function () {
    return this.powK_0;
  };
  PowLimiter.prototype.copy_chi9qi$ = function (minAwaitTime, maxAwaitTime, powValue, powK) {
    return new PowLimiter(minAwaitTime === void 0 ? this.minAwaitTime_0 : minAwaitTime, maxAwaitTime === void 0 ? this.maxAwaitTime_0 : maxAwaitTime, powValue === void 0 ? this.powValue_0 : powValue, powK === void 0 ? this.powK_0 : powK);
  };
  PowLimiter.prototype.toString = function () {
    return 'PowLimiter(minAwaitTime=' + Kotlin.toString(this.minAwaitTime_0) + (', maxAwaitTime=' + Kotlin.toString(this.maxAwaitTime_0)) + (', powValue=' + Kotlin.toString(this.powValue_0)) + (', powK=' + Kotlin.toString(this.powK_0)) + ')';
  };
  PowLimiter.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.minAwaitTime_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.maxAwaitTime_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.powValue_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.powK_0) | 0;
    return result;
  };
  PowLimiter.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.minAwaitTime_0, other.minAwaitTime_0) && Kotlin.equals(this.maxAwaitTime_0, other.maxAwaitTime_0) && Kotlin.equals(this.powValue_0, other.powValue_0) && Kotlin.equals(this.powK_0, other.powK_0)))));
  };
  function RequestLimiter() {
  }
  RequestLimiter.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'RequestLimiter',
    interfaces: []
  };
  function DeleteMessage(chatId, messageId) {
    DeleteMessage$Companion_getInstance();
    this.chatId_bia6x1$_0 = chatId;
    this.messageId_uwkxmu$_0 = messageId;
  }
  Object.defineProperty(DeleteMessage.prototype, 'chatId', {
    get: function () {
      return this.chatId_bia6x1$_0;
    }
  });
  Object.defineProperty(DeleteMessage.prototype, 'messageId', {
    get: function () {
      return this.messageId_uwkxmu$_0;
    }
  });
  DeleteMessage.prototype.method = function () {
    return 'deleteMessage';
  };
  Object.defineProperty(DeleteMessage.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(DeleteMessage.prototype, 'requestSerializer', {
    get: function () {
      return DeleteMessage$Companion_getInstance().serializer();
    }
  });
  function DeleteMessage$Companion() {
    DeleteMessage$Companion_instance = this;
  }
  DeleteMessage$Companion.prototype.serializer = function () {
    return DeleteMessage$$serializer_getInstance();
  };
  DeleteMessage$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DeleteMessage$Companion_instance = null;
  function DeleteMessage$Companion_getInstance() {
    if (DeleteMessage$Companion_instance === null) {
      new DeleteMessage$Companion();
    }
    return DeleteMessage$Companion_instance;
  }
  function DeleteMessage$$serializer() {
    this.descriptor_fdi7sh$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.DeleteMessage', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    DeleteMessage$$serializer_instance = this;
  }
  Object.defineProperty(DeleteMessage$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_fdi7sh$_0;
    }
  });
  DeleteMessage$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.messageId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  DeleteMessage$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return DeleteMessage_init(bitMask0, local0, local1, null);
  };
  DeleteMessage$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer];
  };
  DeleteMessage$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var DeleteMessage$$serializer_instance = null;
  function DeleteMessage$$serializer_getInstance() {
    if (DeleteMessage$$serializer_instance === null) {
      new DeleteMessage$$serializer();
    }
    return DeleteMessage$$serializer_instance;
  }
  function DeleteMessage_init(seen1, chatId, messageId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(DeleteMessage.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_bia6x1$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_uwkxmu$_0 = messageId;
    return $this;
  }
  DeleteMessage.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DeleteMessage',
    interfaces: [MessageAction, SimpleRequest]
  };
  DeleteMessage.prototype.component1 = function () {
    return this.chatId;
  };
  DeleteMessage.prototype.component2 = function () {
    return this.messageId;
  };
  DeleteMessage.prototype.copy_lessgj$ = function (chatId, messageId) {
    return new DeleteMessage(chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId);
  };
  DeleteMessage.prototype.toString = function () {
    return 'DeleteMessage(chatId=' + Kotlin.toString(this.chatId) + (', messageId=' + Kotlin.toString(this.messageId)) + ')';
  };
  DeleteMessage.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    return result;
  };
  DeleteMessage.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId)))));
  };
  var AbleToBeForwardedMessageDeserializer;
  function ForwardMessage(fromChatId, toChatId, messageId, disableNotification) {
    ForwardMessage$Companion_getInstance();
    if (disableNotification === void 0)
      disableNotification = false;
    this.fromChatId = fromChatId;
    this.toChatId = toChatId;
    this.messageId_b4o60k$_0 = messageId;
    this.disableNotification = disableNotification;
  }
  Object.defineProperty(ForwardMessage.prototype, 'messageId', {
    get: function () {
      return this.messageId_b4o60k$_0;
    }
  });
  Object.defineProperty(ForwardMessage.prototype, 'chatId', {
    get: function () {
      return this.fromChatId;
    }
  });
  ForwardMessage.prototype.method = function () {
    return 'forwardMessage';
  };
  Object.defineProperty(ForwardMessage.prototype, 'resultDeserializer', {
    get: function () {
      return AbleToBeForwardedMessageDeserializer;
    }
  });
  Object.defineProperty(ForwardMessage.prototype, 'requestSerializer', {
    get: function () {
      return ForwardMessage$Companion_getInstance().serializer();
    }
  });
  function ForwardMessage$Companion() {
    ForwardMessage$Companion_instance = this;
  }
  ForwardMessage$Companion.prototype.serializer = function () {
    return ForwardMessage$$serializer_getInstance();
  };
  ForwardMessage$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ForwardMessage$Companion_instance = null;
  function ForwardMessage$Companion_getInstance() {
    if (ForwardMessage$Companion_instance === null) {
      new ForwardMessage$Companion();
    }
    return ForwardMessage$Companion_instance;
  }
  function ForwardMessage$$serializer() {
    this.descriptor_j78vih$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.ForwardMessage', this);
    this.descriptor.addElement_ivxn3r$('from_chat_id', false);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    ForwardMessage$$serializer_instance = this;
  }
  Object.defineProperty(ForwardMessage$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_j78vih$_0;
    }
  });
  ForwardMessage$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.fromChatId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), obj.toChatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 2, obj.messageId);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 3, obj.disableNotification);
    output.endStructure_qatsm0$(this.descriptor);
  };
  ForwardMessage$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeLongElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return ForwardMessage_init(bitMask0, local0, local1, local2, local3, null);
  };
  ForwardMessage$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), ChatIdentifierSerializer_getInstance(), internal.LongSerializer, internal.BooleanSerializer];
  };
  ForwardMessage$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var ForwardMessage$$serializer_instance = null;
  function ForwardMessage$$serializer_getInstance() {
    if (ForwardMessage$$serializer_instance === null) {
      new ForwardMessage$$serializer();
    }
    return ForwardMessage$$serializer_instance;
  }
  function ForwardMessage_init(seen1, fromChatId, toChatId, messageId, disableNotification, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(ForwardMessage.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('from_chat_id');
    else
      $this.fromChatId = fromChatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.toChatId = toChatId;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_b4o60k$_0 = messageId;
    if ((seen1 & 8) === 0)
      $this.disableNotification = false;
    else
      $this.disableNotification = disableNotification;
    return $this;
  }
  ForwardMessage.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ForwardMessage',
    interfaces: [MessageAction, SimpleRequest]
  };
  ForwardMessage.prototype.component1 = function () {
    return this.fromChatId;
  };
  ForwardMessage.prototype.component2 = function () {
    return this.toChatId;
  };
  ForwardMessage.prototype.component3 = function () {
    return this.messageId;
  };
  ForwardMessage.prototype.component4 = function () {
    return this.disableNotification;
  };
  ForwardMessage.prototype.copy_jalsui$ = function (fromChatId, toChatId, messageId, disableNotification) {
    return new ForwardMessage(fromChatId === void 0 ? this.fromChatId : fromChatId, toChatId === void 0 ? this.toChatId : toChatId, messageId === void 0 ? this.messageId : messageId, disableNotification === void 0 ? this.disableNotification : disableNotification);
  };
  ForwardMessage.prototype.toString = function () {
    return 'ForwardMessage(fromChatId=' + Kotlin.toString(this.fromChatId) + (', toChatId=' + Kotlin.toString(this.toChatId)) + (', messageId=' + Kotlin.toString(this.messageId)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + ')';
  };
  ForwardMessage.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.fromChatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.toChatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    return result;
  };
  ForwardMessage.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.fromChatId, other.fromChatId) && Kotlin.equals(this.toChatId, other.toChatId) && Kotlin.equals(this.messageId, other.messageId) && Kotlin.equals(this.disableNotification, other.disableNotification)))));
  };
  function GetMe() {
    GetMe$Companion_getInstance();
  }
  GetMe.prototype.method = function () {
    return 'getMe';
  };
  Object.defineProperty(GetMe.prototype, 'resultDeserializer', {
    get: function () {
      return User$Companion_getInstance().serializer();
    }
  });
  Object.defineProperty(GetMe.prototype, 'requestSerializer', {
    get: function () {
      return GetMe$Companion_getInstance().serializer();
    }
  });
  function GetMe$Companion() {
    GetMe$Companion_instance = this;
  }
  GetMe$Companion.prototype.serializer = function () {
    return GetMe$$serializer_getInstance();
  };
  GetMe$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetMe$Companion_instance = null;
  function GetMe$Companion_getInstance() {
    if (GetMe$Companion_instance === null) {
      new GetMe$Companion();
    }
    return GetMe$Companion_instance;
  }
  function GetMe$$serializer() {
    this.descriptor_vrvrrx$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.GetMe', this);
    GetMe$$serializer_instance = this;
  }
  Object.defineProperty(GetMe$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_vrvrrx$_0;
    }
  });
  GetMe$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetMe$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetMe_init(bitMask0, null);
  };
  GetMe$$serializer.prototype.childSerializers = function () {
    return [];
  };
  GetMe$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetMe$$serializer_instance = null;
  function GetMe$$serializer_getInstance() {
    if (GetMe$$serializer_instance === null) {
      new GetMe$$serializer();
    }
    return GetMe$$serializer_instance;
  }
  function GetMe_init(seen1, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetMe.prototype);
    return $this;
  }
  GetMe.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetMe',
    interfaces: [SimpleRequest]
  };
  var updatesListSerializer;
  function GetUpdates(offset, limit, timeout, allowed_updates) {
    GetUpdates$Companion_getInstance();
    if (offset === void 0)
      offset = null;
    if (limit === void 0)
      limit = null;
    if (timeout === void 0)
      timeout = null;
    if (allowed_updates === void 0)
      allowed_updates = ALL_UPDATES_LIST;
    this.offset = offset;
    this.limit = limit;
    this.timeout = timeout;
    this.allowed_updates = allowed_updates;
  }
  GetUpdates.prototype.method = function () {
    return 'getUpdates';
  };
  Object.defineProperty(GetUpdates.prototype, 'resultDeserializer', {
    get: function () {
      return updatesListSerializer;
    }
  });
  Object.defineProperty(GetUpdates.prototype, 'requestSerializer', {
    get: function () {
      return GetUpdates$Companion_getInstance().serializer();
    }
  });
  function GetUpdates$Companion() {
    GetUpdates$Companion_instance = this;
  }
  GetUpdates$Companion.prototype.serializer = function () {
    return GetUpdates$$serializer_getInstance();
  };
  GetUpdates$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetUpdates$Companion_instance = null;
  function GetUpdates$Companion_getInstance() {
    if (GetUpdates$Companion_instance === null) {
      new GetUpdates$Companion();
    }
    return GetUpdates$Companion_instance;
  }
  function GetUpdates$$serializer() {
    this.descriptor_ggorxz$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.GetUpdates', this);
    this.descriptor.addElement_ivxn3r$('offset', true);
    this.descriptor.addElement_ivxn3r$('limit', true);
    this.descriptor.addElement_ivxn3r$('timeout', true);
    this.descriptor.addElement_ivxn3r$('allowed_updates', true);
    GetUpdates$$serializer_instance = this;
  }
  Object.defineProperty(GetUpdates$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_ggorxz$_0;
    }
  });
  GetUpdates$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    if (!equals(obj.offset, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 0))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 0, internal.LongSerializer, obj.offset);
    if (!equals(obj.limit, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.IntSerializer, obj.limit);
    if (!equals(obj.timeout, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.IntSerializer, obj.timeout);
    if (!equals(obj.allowed_updates, ALL_UPDATES_LIST) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, new ArrayListSerializer(internal.StringSerializer), obj.allowed_updates);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetUpdates$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 0, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 0, internal.LongSerializer, local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.IntSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.IntSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, new ArrayListSerializer(internal.StringSerializer)) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, new ArrayListSerializer(internal.StringSerializer), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetUpdates_init(bitMask0, local0, local1, local2, local3, null);
  };
  GetUpdates$$serializer.prototype.childSerializers = function () {
    return [new NullableSerializer(internal.LongSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(new ArrayListSerializer(internal.StringSerializer))];
  };
  GetUpdates$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetUpdates$$serializer_instance = null;
  function GetUpdates$$serializer_getInstance() {
    if (GetUpdates$$serializer_instance === null) {
      new GetUpdates$$serializer();
    }
    return GetUpdates$$serializer_instance;
  }
  function GetUpdates_init(seen1, offset, limit, timeout, allowed_updates, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetUpdates.prototype);
    if ((seen1 & 1) === 0)
      $this.offset = null;
    else
      $this.offset = offset;
    if ((seen1 & 2) === 0)
      $this.limit = null;
    else
      $this.limit = limit;
    if ((seen1 & 4) === 0)
      $this.timeout = null;
    else
      $this.timeout = timeout;
    if ((seen1 & 8) === 0)
      $this.allowed_updates = ALL_UPDATES_LIST;
    else
      $this.allowed_updates = allowed_updates;
    return $this;
  }
  GetUpdates.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetUpdates',
    interfaces: [SimpleRequest]
  };
  GetUpdates.prototype.component1 = function () {
    return this.offset;
  };
  GetUpdates.prototype.component2 = function () {
    return this.limit;
  };
  GetUpdates.prototype.component3 = function () {
    return this.timeout;
  };
  GetUpdates.prototype.component4 = function () {
    return this.allowed_updates;
  };
  GetUpdates.prototype.copy_pccitc$ = function (offset, limit, timeout, allowed_updates) {
    return new GetUpdates(offset === void 0 ? this.offset : offset, limit === void 0 ? this.limit : limit, timeout === void 0 ? this.timeout : timeout, allowed_updates === void 0 ? this.allowed_updates : allowed_updates);
  };
  GetUpdates.prototype.toString = function () {
    return 'GetUpdates(offset=' + Kotlin.toString(this.offset) + (', limit=' + Kotlin.toString(this.limit)) + (', timeout=' + Kotlin.toString(this.timeout)) + (', allowed_updates=' + Kotlin.toString(this.allowed_updates)) + ')';
  };
  GetUpdates.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.offset) | 0;
    result = result * 31 + Kotlin.hashCode(this.limit) | 0;
    result = result * 31 + Kotlin.hashCode(this.timeout) | 0;
    result = result * 31 + Kotlin.hashCode(this.allowed_updates) | 0;
    return result;
  };
  GetUpdates.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.offset, other.offset) && Kotlin.equals(this.limit, other.limit) && Kotlin.equals(this.timeout, other.timeout) && Kotlin.equals(this.allowed_updates, other.allowed_updates)))));
  };
  function StopPoll(chatId, messageId, replyMarkup) {
    StopPoll$Companion_getInstance();
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_p4uuzu$_0 = chatId;
    this.messageId_8t9cuj$_0 = messageId;
    this.replyMarkup_ox2ibp$_0 = replyMarkup;
  }
  Object.defineProperty(StopPoll.prototype, 'chatId', {
    get: function () {
      return this.chatId_p4uuzu$_0;
    }
  });
  Object.defineProperty(StopPoll.prototype, 'messageId', {
    get: function () {
      return this.messageId_8t9cuj$_0;
    }
  });
  Object.defineProperty(StopPoll.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_ox2ibp$_0;
    }
  });
  StopPoll.prototype.method = function () {
    return 'stopPoll';
  };
  Object.defineProperty(StopPoll.prototype, 'resultDeserializer', {
    get: function () {
      return Poll$Companion_getInstance().serializer();
    }
  });
  Object.defineProperty(StopPoll.prototype, 'requestSerializer', {
    get: function () {
      return StopPoll$Companion_getInstance().serializer();
    }
  });
  function StopPoll$Companion() {
    StopPoll$Companion_instance = this;
  }
  StopPoll$Companion.prototype.serializer = function () {
    return StopPoll$$serializer_getInstance();
  };
  StopPoll$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var StopPoll$Companion_instance = null;
  function StopPoll$Companion_getInstance() {
    if (StopPoll$Companion_instance === null) {
      new StopPoll$Companion();
    }
    return StopPoll$Companion_instance;
  }
  function StopPoll$$serializer() {
    this.descriptor_y1w1cm$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.StopPoll', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    StopPoll$$serializer_instance = this;
  }
  Object.defineProperty(StopPoll$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_y1w1cm$_0;
    }
  });
  StopPoll$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.messageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  StopPoll$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return StopPoll_init(bitMask0, local0, local1, local2, null);
  };
  StopPoll$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer, new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  StopPoll$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var StopPoll$$serializer_instance = null;
  function StopPoll$$serializer_getInstance() {
    if (StopPoll$$serializer_instance === null) {
      new StopPoll$$serializer();
    }
    return StopPoll$$serializer_instance;
  }
  function StopPoll_init(seen1, chatId, messageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(StopPoll.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_p4uuzu$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_8t9cuj$_0 = messageId;
    if ((seen1 & 4) === 0)
      $this.replyMarkup_ox2ibp$_0 = null;
    else
      $this.replyMarkup_ox2ibp$_0 = replyMarkup;
    return $this;
  }
  StopPoll.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StopPoll',
    interfaces: [ReplyMarkup, SimpleRequest, MessageAction]
  };
  StopPoll.prototype.component1 = function () {
    return this.chatId;
  };
  StopPoll.prototype.component2 = function () {
    return this.messageId;
  };
  StopPoll.prototype.component3 = function () {
    return this.replyMarkup;
  };
  StopPoll.prototype.copy_ixtysa$ = function (chatId, messageId, replyMarkup) {
    return new StopPoll(chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  StopPoll.prototype.toString = function () {
    return 'StopPoll(chatId=' + Kotlin.toString(this.chatId) + (', messageId=' + Kotlin.toString(this.messageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  StopPoll.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  StopPoll.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function InputFile() {
    InputFile$Companion_getInstance();
  }
  function InputFile$Companion() {
    InputFile$Companion_instance = this;
  }
  InputFile$Companion.prototype.serializer = function () {
    return InputFileSerializer_getInstance();
  };
  InputFile$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var InputFile$Companion_instance = null;
  function InputFile$Companion_getInstance() {
    if (InputFile$Companion_instance === null) {
      new InputFile$Companion();
    }
    return InputFile$Companion_instance;
  }
  InputFile.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InputFile',
    interfaces: []
  };
  function FileId(fileId) {
    FileId$Companion_getInstance();
    InputFile.call(this);
    this.fileId_kawjtz$_0 = fileId;
  }
  Object.defineProperty(FileId.prototype, 'fileId', {
    get: function () {
      return this.fileId_kawjtz$_0;
    }
  });
  function FileId$Companion() {
    FileId$Companion_instance = this;
  }
  FileId$Companion.prototype.serializer = function () {
    return InputFileSerializer_getInstance();
  };
  FileId$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var FileId$Companion_instance = null;
  function FileId$Companion_getInstance() {
    if (FileId$Companion_instance === null) {
      new FileId$Companion();
    }
    return FileId$Companion_instance;
  }
  FileId.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FileId',
    interfaces: [InputFile]
  };
  FileId.prototype.component1 = function () {
    return this.fileId;
  };
  FileId.prototype.copy_61zpoe$ = function (fileId) {
    return new FileId(fileId === void 0 ? this.fileId : fileId);
  };
  FileId.prototype.toString = function () {
    return 'FileId(fileId=' + Kotlin.toString(this.fileId) + ')';
  };
  FileId.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.fileId) | 0;
    return result;
  };
  FileId.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.fileId, other.fileId))));
  };
  function toInputFile($receiver) {
    return new FileId($receiver);
  }
  function InputFileSerializer() {
    InputFileSerializer_instance = this;
    this.descriptor_z42ao8$_0 = withName(internal.StringDescriptor, getKClass(FileId).toString());
  }
  Object.defineProperty(InputFileSerializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_z42ao8$_0;
    }
  });
  InputFileSerializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    encoder.encodeString_61zpoe$(obj.fileId);
  };
  InputFileSerializer.prototype.deserialize_nts5qn$ = function (decoder) {
    return new FileId(decoder.decodeString());
  };
  InputFileSerializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'InputFileSerializer',
    interfaces: [KSerializer]
  };
  var InputFileSerializer_instance = null;
  function InputFileSerializer_getInstance() {
    if (InputFileSerializer_instance === null) {
      new InputFileSerializer();
    }
    return InputFileSerializer_instance;
  }
  function MultipartFile(file, mimeType, filename) {
    MultipartFile$Companion_getInstance();
    if (mimeType === void 0)
      mimeType = file.contentType;
    if (filename === void 0)
      filename = file.fileName;
    InputFile.call(this);
    this.file = file;
    this.mimeType = mimeType;
    this.filename = filename;
    this.fileId_wrfihc$_0 = this.file.generateCustomName();
  }
  Object.defineProperty(MultipartFile.prototype, 'fileId', {
    get: function () {
      return this.fileId_wrfihc$_0;
    }
  });
  function MultipartFile$Companion() {
    MultipartFile$Companion_instance = this;
  }
  MultipartFile$Companion.prototype.serializer = function () {
    return InputFileSerializer_getInstance();
  };
  MultipartFile$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var MultipartFile$Companion_instance = null;
  function MultipartFile$Companion_getInstance() {
    if (MultipartFile$Companion_instance === null) {
      new MultipartFile$Companion();
    }
    return MultipartFile$Companion_instance;
  }
  MultipartFile.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MultipartFile',
    interfaces: [InputFile]
  };
  MultipartFile.prototype.component1 = function () {
    return this.file;
  };
  MultipartFile.prototype.component2 = function () {
    return this.mimeType;
  };
  MultipartFile.prototype.component3 = function () {
    return this.filename;
  };
  MultipartFile.prototype.copy_ksgkas$ = function (file, mimeType, filename) {
    return new MultipartFile(file === void 0 ? this.file : file, mimeType === void 0 ? this.mimeType : mimeType, filename === void 0 ? this.filename : filename);
  };
  MultipartFile.prototype.toString = function () {
    return 'MultipartFile(file=' + Kotlin.toString(this.file) + (', mimeType=' + Kotlin.toString(this.mimeType)) + (', filename=' + Kotlin.toString(this.filename)) + ')';
  };
  MultipartFile.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.file) | 0;
    result = result * 31 + Kotlin.hashCode(this.mimeType) | 0;
    result = result * 31 + Kotlin.hashCode(this.filename) | 0;
    return result;
  };
  MultipartFile.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.file, other.file) && Kotlin.equals(this.mimeType, other.mimeType) && Kotlin.equals(this.filename, other.filename)))));
  };
  function MultipartRequest() {
  }
  MultipartRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MultipartRequest',
    interfaces: [Request]
  };
  function Request() {
  }
  Request.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Request',
    interfaces: []
  };
  function SimpleRequest() {
  }
  SimpleRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SimpleRequest',
    interfaces: [Request]
  };
  var json_1 = defineInlineFunction('TelegramBotAPI.com.github.insanusmokrassar.TelegramBotAPI.requests.abstracts.json_8lwfsk$', wrapFunction(function () {
    var SerializationStrategy = _.$$importsForInline$$['kotlinx-serialization-kotlinx-serialization-runtime'].kotlinx.serialization.SerializationStrategy;
    var throwCCE = Kotlin.throwCCE;
    var withoutNulls = _.com.github.insanusmokrassar.TelegramBotAPI.utils.withoutNulls_qgzobt$;
    var Json = _.$$importsForInline$$['kotlinx-serialization-kotlinx-serialization-runtime'].kotlinx.serialization.json.Json;
    return function ($receiver) {
      var tmp$;
      var serializer = Kotlin.isType(tmp$ = $receiver.requestSerializer, SerializationStrategy) ? tmp$ : throwCCE();
      return withoutNulls(Json.Companion.nonstrict.toJson_tf03ej$(serializer, $receiver).jsonObject);
    };
  }));
  function AnswerCallbackQuery(callbackQueryId, text, showAlert, url, cachedTimeSeconds) {
    AnswerCallbackQuery$Companion_getInstance();
    if (text === void 0)
      text = null;
    if (showAlert === void 0)
      showAlert = null;
    if (url === void 0)
      url = null;
    if (cachedTimeSeconds === void 0)
      cachedTimeSeconds = null;
    this.callbackQueryId = callbackQueryId;
    this.text = text;
    this.showAlert = showAlert;
    this.url = url;
    this.cachedTimeSeconds = cachedTimeSeconds;
  }
  AnswerCallbackQuery.prototype.method = function () {
    return 'answerCallbackQuery';
  };
  Object.defineProperty(AnswerCallbackQuery.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(AnswerCallbackQuery.prototype, 'requestSerializer', {
    get: function () {
      return AnswerCallbackQuery$Companion_getInstance().serializer();
    }
  });
  function AnswerCallbackQuery$Companion() {
    AnswerCallbackQuery$Companion_instance = this;
  }
  AnswerCallbackQuery$Companion.prototype.serializer = function () {
    return AnswerCallbackQuery$$serializer_getInstance();
  };
  AnswerCallbackQuery$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AnswerCallbackQuery$Companion_instance = null;
  function AnswerCallbackQuery$Companion_getInstance() {
    if (AnswerCallbackQuery$Companion_instance === null) {
      new AnswerCallbackQuery$Companion();
    }
    return AnswerCallbackQuery$Companion_instance;
  }
  function AnswerCallbackQuery$$serializer() {
    this.descriptor_sl003j$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.answers.AnswerCallbackQuery', this);
    this.descriptor.addElement_ivxn3r$('callback_query_id', false);
    this.descriptor.addElement_ivxn3r$('text', true);
    this.descriptor.addElement_ivxn3r$('show_alert', true);
    this.descriptor.addElement_ivxn3r$('url', true);
    this.descriptor.addElement_ivxn3r$('cached_time', true);
    AnswerCallbackQuery$$serializer_instance = this;
  }
  Object.defineProperty(AnswerCallbackQuery$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_sl003j$_0;
    }
  });
  AnswerCallbackQuery$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.callbackQueryId);
    if (!equals(obj.text, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.StringSerializer, obj.text);
    if (!equals(obj.showAlert, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.BooleanSerializer, obj.showAlert);
    if (!equals(obj.url, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.url);
    if (!equals(obj.cachedTimeSeconds, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.IntSerializer, obj.cachedTimeSeconds);
    output.endStructure_qatsm0$(this.descriptor);
  };
  AnswerCallbackQuery$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.StringSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.BooleanSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.IntSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return AnswerCallbackQuery_init(bitMask0, local0, local1, local2, local3, local4, null);
  };
  AnswerCallbackQuery$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.IntSerializer)];
  };
  AnswerCallbackQuery$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var AnswerCallbackQuery$$serializer_instance = null;
  function AnswerCallbackQuery$$serializer_getInstance() {
    if (AnswerCallbackQuery$$serializer_instance === null) {
      new AnswerCallbackQuery$$serializer();
    }
    return AnswerCallbackQuery$$serializer_instance;
  }
  function AnswerCallbackQuery_init(seen1, callbackQueryId, text, showAlert, url, cachedTimeSeconds, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(AnswerCallbackQuery.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('callback_query_id');
    else
      $this.callbackQueryId = callbackQueryId;
    if ((seen1 & 2) === 0)
      $this.text = null;
    else
      $this.text = text;
    if ((seen1 & 4) === 0)
      $this.showAlert = null;
    else
      $this.showAlert = showAlert;
    if ((seen1 & 8) === 0)
      $this.url = null;
    else
      $this.url = url;
    if ((seen1 & 16) === 0)
      $this.cachedTimeSeconds = null;
    else
      $this.cachedTimeSeconds = cachedTimeSeconds;
    return $this;
  }
  AnswerCallbackQuery.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnswerCallbackQuery',
    interfaces: [SimpleRequest]
  };
  AnswerCallbackQuery.prototype.component1 = function () {
    return this.callbackQueryId;
  };
  AnswerCallbackQuery.prototype.component2 = function () {
    return this.text;
  };
  AnswerCallbackQuery.prototype.component3 = function () {
    return this.showAlert;
  };
  AnswerCallbackQuery.prototype.component4 = function () {
    return this.url;
  };
  AnswerCallbackQuery.prototype.component5 = function () {
    return this.cachedTimeSeconds;
  };
  AnswerCallbackQuery.prototype.copy_emmtkn$ = function (callbackQueryId, text, showAlert, url, cachedTimeSeconds) {
    return new AnswerCallbackQuery(callbackQueryId === void 0 ? this.callbackQueryId : callbackQueryId, text === void 0 ? this.text : text, showAlert === void 0 ? this.showAlert : showAlert, url === void 0 ? this.url : url, cachedTimeSeconds === void 0 ? this.cachedTimeSeconds : cachedTimeSeconds);
  };
  AnswerCallbackQuery.prototype.toString = function () {
    return 'AnswerCallbackQuery(callbackQueryId=' + Kotlin.toString(this.callbackQueryId) + (', text=' + Kotlin.toString(this.text)) + (', showAlert=' + Kotlin.toString(this.showAlert)) + (', url=' + Kotlin.toString(this.url)) + (', cachedTimeSeconds=' + Kotlin.toString(this.cachedTimeSeconds)) + ')';
  };
  AnswerCallbackQuery.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.callbackQueryId) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.showAlert) | 0;
    result = result * 31 + Kotlin.hashCode(this.url) | 0;
    result = result * 31 + Kotlin.hashCode(this.cachedTimeSeconds) | 0;
    return result;
  };
  AnswerCallbackQuery.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.callbackQueryId, other.callbackQueryId) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.showAlert, other.showAlert) && Kotlin.equals(this.url, other.url) && Kotlin.equals(this.cachedTimeSeconds, other.cachedTimeSeconds)))));
  };
  function createAnswer($receiver, text, showAlert, url, cachedTimeSeconds) {
    if (text === void 0)
      text = null;
    if (showAlert === void 0)
      showAlert = null;
    if (url === void 0)
      url = null;
    if (cachedTimeSeconds === void 0)
      cachedTimeSeconds = null;
    return new AnswerCallbackQuery($receiver.id, text, showAlert, url, cachedTimeSeconds);
  }
  function AnswerInlineQuery(inlineQueryID, results, cachedTime, isPersonal, nextOffset, switchPmText, switchPmParameter) {
    AnswerInlineQuery$Companion_getInstance();
    if (results === void 0)
      results = emptyList();
    if (cachedTime === void 0)
      cachedTime = null;
    if (isPersonal === void 0)
      isPersonal = null;
    if (nextOffset === void 0)
      nextOffset = null;
    if (switchPmText === void 0)
      switchPmText = null;
    if (switchPmParameter === void 0)
      switchPmParameter = null;
    this.inlineQueryID = inlineQueryID;
    this.results = results;
    this.cachedTime = cachedTime;
    this.isPersonal = isPersonal;
    this.nextOffset = nextOffset;
    this.switchPmText = switchPmText;
    this.switchPmParameter = switchPmParameter;
  }
  AnswerInlineQuery.prototype.method = function () {
    return 'answerInlineQuery';
  };
  Object.defineProperty(AnswerInlineQuery.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(AnswerInlineQuery.prototype, 'requestSerializer', {
    get: function () {
      return AnswerInlineQuery$Companion_getInstance().serializer();
    }
  });
  function AnswerInlineQuery$Companion() {
    AnswerInlineQuery$Companion_instance = this;
  }
  AnswerInlineQuery$Companion.prototype.serializer = function () {
    return AnswerInlineQuery$$serializer_getInstance();
  };
  AnswerInlineQuery$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AnswerInlineQuery$Companion_instance = null;
  function AnswerInlineQuery$Companion_getInstance() {
    if (AnswerInlineQuery$Companion_instance === null) {
      new AnswerInlineQuery$Companion();
    }
    return AnswerInlineQuery$Companion_instance;
  }
  function AnswerInlineQuery$$serializer() {
    this.descriptor_fjx7fx$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.answers.AnswerInlineQuery', this);
    this.descriptor.addElement_ivxn3r$('inline_query_id', false);
    this.descriptor.addElement_ivxn3r$('results', true);
    this.descriptor.addElement_ivxn3r$('cached_time', true);
    this.descriptor.addElement_ivxn3r$('is_personal', true);
    this.descriptor.addElement_ivxn3r$('next_offset', true);
    this.descriptor.addElement_ivxn3r$('switch_pm_text', true);
    this.descriptor.addElement_ivxn3r$('switch_pm_parameter', true);
    AnswerInlineQuery$$serializer_instance = this;
  }
  Object.defineProperty(AnswerInlineQuery$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_fjx7fx$_0;
    }
  });
  AnswerInlineQuery$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.inlineQueryID);
    if (!equals(obj.results, emptyList()) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeSerializableElement_blecud$(this.descriptor, 1, InlineQueryAnswersResultsSerializer_getInstance(), obj.results);
    if (!equals(obj.cachedTime, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.IntSerializer, obj.cachedTime);
    if (!equals(obj.isPersonal, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.BooleanSerializer, obj.isPersonal);
    if (!equals(obj.nextOffset, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.StringSerializer, obj.nextOffset);
    if (!equals(obj.switchPmText, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.StringSerializer, obj.switchPmText);
    if (!equals(obj.switchPmParameter, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, internal.StringSerializer, obj.switchPmParameter);
    output.endStructure_qatsm0$(this.descriptor);
  };
  AnswerInlineQuery$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, InlineQueryAnswersResultsSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, InlineQueryAnswersResultsSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.IntSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.BooleanSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.StringSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.StringSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, internal.StringSerializer, local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return AnswerInlineQuery_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, null);
  };
  AnswerInlineQuery$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, InlineQueryAnswersResultsSerializer_getInstance(), new NullableSerializer(internal.IntSerializer), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer)];
  };
  AnswerInlineQuery$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var AnswerInlineQuery$$serializer_instance = null;
  function AnswerInlineQuery$$serializer_getInstance() {
    if (AnswerInlineQuery$$serializer_instance === null) {
      new AnswerInlineQuery$$serializer();
    }
    return AnswerInlineQuery$$serializer_instance;
  }
  function AnswerInlineQuery_init(seen1, inlineQueryID, results, cachedTime, isPersonal, nextOffset, switchPmText, switchPmParameter, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(AnswerInlineQuery.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('inline_query_id');
    else
      $this.inlineQueryID = inlineQueryID;
    if ((seen1 & 2) === 0)
      $this.results = emptyList();
    else
      $this.results = results;
    if ((seen1 & 4) === 0)
      $this.cachedTime = null;
    else
      $this.cachedTime = cachedTime;
    if ((seen1 & 8) === 0)
      $this.isPersonal = null;
    else
      $this.isPersonal = isPersonal;
    if ((seen1 & 16) === 0)
      $this.nextOffset = null;
    else
      $this.nextOffset = nextOffset;
    if ((seen1 & 32) === 0)
      $this.switchPmText = null;
    else
      $this.switchPmText = switchPmText;
    if ((seen1 & 64) === 0)
      $this.switchPmParameter = null;
    else
      $this.switchPmParameter = switchPmParameter;
    return $this;
  }
  AnswerInlineQuery.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnswerInlineQuery',
    interfaces: [SimpleRequest]
  };
  AnswerInlineQuery.prototype.component1 = function () {
    return this.inlineQueryID;
  };
  AnswerInlineQuery.prototype.component2 = function () {
    return this.results;
  };
  AnswerInlineQuery.prototype.component3 = function () {
    return this.cachedTime;
  };
  AnswerInlineQuery.prototype.component4 = function () {
    return this.isPersonal;
  };
  AnswerInlineQuery.prototype.component5 = function () {
    return this.nextOffset;
  };
  AnswerInlineQuery.prototype.component6 = function () {
    return this.switchPmText;
  };
  AnswerInlineQuery.prototype.component7 = function () {
    return this.switchPmParameter;
  };
  AnswerInlineQuery.prototype.copy_hm9riw$ = function (inlineQueryID, results, cachedTime, isPersonal, nextOffset, switchPmText, switchPmParameter) {
    return new AnswerInlineQuery(inlineQueryID === void 0 ? this.inlineQueryID : inlineQueryID, results === void 0 ? this.results : results, cachedTime === void 0 ? this.cachedTime : cachedTime, isPersonal === void 0 ? this.isPersonal : isPersonal, nextOffset === void 0 ? this.nextOffset : nextOffset, switchPmText === void 0 ? this.switchPmText : switchPmText, switchPmParameter === void 0 ? this.switchPmParameter : switchPmParameter);
  };
  AnswerInlineQuery.prototype.toString = function () {
    return 'AnswerInlineQuery(inlineQueryID=' + Kotlin.toString(this.inlineQueryID) + (', results=' + Kotlin.toString(this.results)) + (', cachedTime=' + Kotlin.toString(this.cachedTime)) + (', isPersonal=' + Kotlin.toString(this.isPersonal)) + (', nextOffset=' + Kotlin.toString(this.nextOffset)) + (', switchPmText=' + Kotlin.toString(this.switchPmText)) + (', switchPmParameter=' + Kotlin.toString(this.switchPmParameter)) + ')';
  };
  AnswerInlineQuery.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.inlineQueryID) | 0;
    result = result * 31 + Kotlin.hashCode(this.results) | 0;
    result = result * 31 + Kotlin.hashCode(this.cachedTime) | 0;
    result = result * 31 + Kotlin.hashCode(this.isPersonal) | 0;
    result = result * 31 + Kotlin.hashCode(this.nextOffset) | 0;
    result = result * 31 + Kotlin.hashCode(this.switchPmText) | 0;
    result = result * 31 + Kotlin.hashCode(this.switchPmParameter) | 0;
    return result;
  };
  AnswerInlineQuery.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.inlineQueryID, other.inlineQueryID) && Kotlin.equals(this.results, other.results) && Kotlin.equals(this.cachedTime, other.cachedTime) && Kotlin.equals(this.isPersonal, other.isPersonal) && Kotlin.equals(this.nextOffset, other.nextOffset) && Kotlin.equals(this.switchPmText, other.switchPmText) && Kotlin.equals(this.switchPmParameter, other.switchPmParameter)))));
  };
  function createAnswer_0($receiver, results, cachedTime, isPersonal, nextOffset, switchPmText, switchPmParameter) {
    if (results === void 0)
      results = emptyList();
    if (cachedTime === void 0)
      cachedTime = null;
    if (isPersonal === void 0)
      isPersonal = null;
    if (nextOffset === void 0)
      nextOffset = null;
    if (switchPmText === void 0)
      switchPmText = null;
    if (switchPmParameter === void 0)
      switchPmParameter = null;
    return new AnswerInlineQuery($receiver.id, results, cachedTime, isPersonal, nextOffset, switchPmText, switchPmParameter);
  }
  function InlineQueryAnswersResultsSerializer() {
    InlineQueryAnswersResultsSerializer_instance = this;
    this.$delegate_l4saxz$_0 = new ArrayListSerializer(InlineQueryResultSerializer_getInstance());
  }
  Object.defineProperty(InlineQueryAnswersResultsSerializer.prototype, 'descriptor', {
    get: function () {
      return this.$delegate_l4saxz$_0.descriptor;
    }
  });
  InlineQueryAnswersResultsSerializer.prototype.deserialize_nts5qn$ = function (decoder) {
    return this.$delegate_l4saxz$_0.deserialize_nts5qn$(decoder);
  };
  InlineQueryAnswersResultsSerializer.prototype.patch_mynpiu$ = function (decoder, old) {
    return this.$delegate_l4saxz$_0.patch_mynpiu$(decoder, old);
  };
  InlineQueryAnswersResultsSerializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    return this.$delegate_l4saxz$_0.serialize_awe97i$(encoder, obj);
  };
  InlineQueryAnswersResultsSerializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'InlineQueryAnswersResultsSerializer',
    interfaces: [KSerializer]
  };
  var InlineQueryAnswersResultsSerializer_instance = null;
  function InlineQueryAnswersResultsSerializer_getInstance() {
    if (InlineQueryAnswersResultsSerializer_instance === null) {
      new InlineQueryAnswersResultsSerializer();
    }
    return InlineQueryAnswersResultsSerializer_instance;
  }
  function AnswerPreCheckoutQueryOk(preCheckoutQueryId) {
    AnswerPreCheckoutQueryOk$Companion_getInstance();
    this.preCheckoutQueryId_kicg9v$_0 = preCheckoutQueryId;
    this.isOk_aqbdpz$_0 = true;
  }
  Object.defineProperty(AnswerPreCheckoutQueryOk.prototype, 'preCheckoutQueryId', {
    get: function () {
      return this.preCheckoutQueryId_kicg9v$_0;
    }
  });
  Object.defineProperty(AnswerPreCheckoutQueryOk.prototype, 'isOk', {
    get: function () {
      return this.isOk_aqbdpz$_0;
    }
  });
  Object.defineProperty(AnswerPreCheckoutQueryOk.prototype, 'requestSerializer', {
    get: function () {
      return AnswerPreCheckoutQueryOk$Companion_getInstance().serializer();
    }
  });
  function AnswerPreCheckoutQueryOk$Companion() {
    AnswerPreCheckoutQueryOk$Companion_instance = this;
  }
  AnswerPreCheckoutQueryOk$Companion.prototype.serializer = function () {
    return AnswerPreCheckoutQueryOk$$serializer_getInstance();
  };
  AnswerPreCheckoutQueryOk$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AnswerPreCheckoutQueryOk$Companion_instance = null;
  function AnswerPreCheckoutQueryOk$Companion_getInstance() {
    if (AnswerPreCheckoutQueryOk$Companion_instance === null) {
      new AnswerPreCheckoutQueryOk$Companion();
    }
    return AnswerPreCheckoutQueryOk$Companion_instance;
  }
  function AnswerPreCheckoutQueryOk$$serializer() {
    this.descriptor_j60cra$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.answers.payments.AnswerPreCheckoutQueryOk', this);
    this.descriptor.addElement_ivxn3r$('pre_checkout_query_id', false);
    this.descriptor.addElement_ivxn3r$('ok', true);
    AnswerPreCheckoutQueryOk$$serializer_instance = this;
  }
  Object.defineProperty(AnswerPreCheckoutQueryOk$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_j60cra$_0;
    }
  });
  AnswerPreCheckoutQueryOk$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.preCheckoutQueryId);
    if (!equals(obj.isOk, true) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 1, obj.isOk);
    output.endStructure_qatsm0$(this.descriptor);
  };
  AnswerPreCheckoutQueryOk$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return AnswerPreCheckoutQueryOk_init(bitMask0, local0, local1, null);
  };
  AnswerPreCheckoutQueryOk$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.BooleanSerializer];
  };
  AnswerPreCheckoutQueryOk$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var AnswerPreCheckoutQueryOk$$serializer_instance = null;
  function AnswerPreCheckoutQueryOk$$serializer_getInstance() {
    if (AnswerPreCheckoutQueryOk$$serializer_instance === null) {
      new AnswerPreCheckoutQueryOk$$serializer();
    }
    return AnswerPreCheckoutQueryOk$$serializer_instance;
  }
  function AnswerPreCheckoutQueryOk_init(seen1, preCheckoutQueryId, isOk, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(AnswerPreCheckoutQueryOk.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('pre_checkout_query_id');
    else
      $this.preCheckoutQueryId_kicg9v$_0 = preCheckoutQueryId;
    if ((seen1 & 2) === 0)
      $this.isOk_aqbdpz$_0 = true;
    else
      $this.isOk_aqbdpz$_0 = isOk;
    return $this;
  }
  AnswerPreCheckoutQueryOk.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnswerPreCheckoutQueryOk',
    interfaces: [AnswerPreCheckoutQuery]
  };
  AnswerPreCheckoutQueryOk.prototype.component1 = function () {
    return this.preCheckoutQueryId;
  };
  AnswerPreCheckoutQueryOk.prototype.copy_61zpoe$ = function (preCheckoutQueryId) {
    return new AnswerPreCheckoutQueryOk(preCheckoutQueryId === void 0 ? this.preCheckoutQueryId : preCheckoutQueryId);
  };
  AnswerPreCheckoutQueryOk.prototype.toString = function () {
    return 'AnswerPreCheckoutQueryOk(preCheckoutQueryId=' + Kotlin.toString(this.preCheckoutQueryId) + ')';
  };
  AnswerPreCheckoutQueryOk.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.preCheckoutQueryId) | 0;
    return result;
  };
  AnswerPreCheckoutQueryOk.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.preCheckoutQueryId, other.preCheckoutQueryId))));
  };
  function AnswerPreCheckoutQueryError(preCheckoutQueryId, errorMessage) {
    AnswerPreCheckoutQueryError$Companion_getInstance();
    this.preCheckoutQueryId_868tmj$_0 = preCheckoutQueryId;
    this.errorMessage = errorMessage;
    this.isOk_4nci3r$_0 = false;
  }
  Object.defineProperty(AnswerPreCheckoutQueryError.prototype, 'preCheckoutQueryId', {
    get: function () {
      return this.preCheckoutQueryId_868tmj$_0;
    }
  });
  Object.defineProperty(AnswerPreCheckoutQueryError.prototype, 'isOk', {
    get: function () {
      return this.isOk_4nci3r$_0;
    }
  });
  Object.defineProperty(AnswerPreCheckoutQueryError.prototype, 'requestSerializer', {
    get: function () {
      return AnswerPreCheckoutQueryError$Companion_getInstance().serializer();
    }
  });
  function AnswerPreCheckoutQueryError$Companion() {
    AnswerPreCheckoutQueryError$Companion_instance = this;
  }
  AnswerPreCheckoutQueryError$Companion.prototype.serializer = function () {
    return AnswerPreCheckoutQueryError$$serializer_getInstance();
  };
  AnswerPreCheckoutQueryError$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AnswerPreCheckoutQueryError$Companion_instance = null;
  function AnswerPreCheckoutQueryError$Companion_getInstance() {
    if (AnswerPreCheckoutQueryError$Companion_instance === null) {
      new AnswerPreCheckoutQueryError$Companion();
    }
    return AnswerPreCheckoutQueryError$Companion_instance;
  }
  function AnswerPreCheckoutQueryError$$serializer() {
    this.descriptor_3ztfso$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.answers.payments.AnswerPreCheckoutQueryError', this);
    this.descriptor.addElement_ivxn3r$('pre_checkout_query_id', false);
    this.descriptor.addElement_ivxn3r$('error_message', false);
    this.descriptor.addElement_ivxn3r$('ok', true);
    AnswerPreCheckoutQueryError$$serializer_instance = this;
  }
  Object.defineProperty(AnswerPreCheckoutQueryError$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_3ztfso$_0;
    }
  });
  AnswerPreCheckoutQueryError$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.preCheckoutQueryId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.errorMessage);
    if (!equals(obj.isOk, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 2, obj.isOk);
    output.endStructure_qatsm0$(this.descriptor);
  };
  AnswerPreCheckoutQueryError$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return AnswerPreCheckoutQueryError_init(bitMask0, local0, local1, local2, null);
  };
  AnswerPreCheckoutQueryError$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.StringSerializer, internal.BooleanSerializer];
  };
  AnswerPreCheckoutQueryError$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var AnswerPreCheckoutQueryError$$serializer_instance = null;
  function AnswerPreCheckoutQueryError$$serializer_getInstance() {
    if (AnswerPreCheckoutQueryError$$serializer_instance === null) {
      new AnswerPreCheckoutQueryError$$serializer();
    }
    return AnswerPreCheckoutQueryError$$serializer_instance;
  }
  function AnswerPreCheckoutQueryError_init(seen1, preCheckoutQueryId, errorMessage, isOk, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(AnswerPreCheckoutQueryError.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('pre_checkout_query_id');
    else
      $this.preCheckoutQueryId_868tmj$_0 = preCheckoutQueryId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('error_message');
    else
      $this.errorMessage = errorMessage;
    if ((seen1 & 4) === 0)
      $this.isOk_4nci3r$_0 = false;
    else
      $this.isOk_4nci3r$_0 = isOk;
    return $this;
  }
  AnswerPreCheckoutQueryError.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnswerPreCheckoutQueryError',
    interfaces: [AnswerPreCheckoutQuery]
  };
  AnswerPreCheckoutQueryError.prototype.component1 = function () {
    return this.preCheckoutQueryId;
  };
  AnswerPreCheckoutQueryError.prototype.component2 = function () {
    return this.errorMessage;
  };
  AnswerPreCheckoutQueryError.prototype.copy_puj7f4$ = function (preCheckoutQueryId, errorMessage) {
    return new AnswerPreCheckoutQueryError(preCheckoutQueryId === void 0 ? this.preCheckoutQueryId : preCheckoutQueryId, errorMessage === void 0 ? this.errorMessage : errorMessage);
  };
  AnswerPreCheckoutQueryError.prototype.toString = function () {
    return 'AnswerPreCheckoutQueryError(preCheckoutQueryId=' + Kotlin.toString(this.preCheckoutQueryId) + (', errorMessage=' + Kotlin.toString(this.errorMessage)) + ')';
  };
  AnswerPreCheckoutQueryError.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.preCheckoutQueryId) | 0;
    result = result * 31 + Kotlin.hashCode(this.errorMessage) | 0;
    return result;
  };
  AnswerPreCheckoutQueryError.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.preCheckoutQueryId, other.preCheckoutQueryId) && Kotlin.equals(this.errorMessage, other.errorMessage)))));
  };
  function createAnswerOk($receiver) {
    return new AnswerPreCheckoutQueryOk($receiver.id);
  }
  function createAnswerError($receiver, error) {
    return new AnswerPreCheckoutQueryError($receiver.id, error);
  }
  function AnswerShippingQueryOk(shippingQueryId, shippingOptions) {
    AnswerShippingQueryOk$Companion_getInstance();
    this.shippingQueryId_1w33rh$_0 = shippingQueryId;
    this.shippingOptions = shippingOptions;
    this.isOk_t00u62$_0 = true;
  }
  Object.defineProperty(AnswerShippingQueryOk.prototype, 'shippingQueryId', {
    get: function () {
      return this.shippingQueryId_1w33rh$_0;
    }
  });
  Object.defineProperty(AnswerShippingQueryOk.prototype, 'isOk', {
    get: function () {
      return this.isOk_t00u62$_0;
    }
  });
  Object.defineProperty(AnswerShippingQueryOk.prototype, 'requestSerializer', {
    get: function () {
      return AnswerShippingQueryOk$Companion_getInstance().serializer();
    }
  });
  function AnswerShippingQueryOk$Companion() {
    AnswerShippingQueryOk$Companion_instance = this;
  }
  AnswerShippingQueryOk$Companion.prototype.serializer = function () {
    return AnswerShippingQueryOk$$serializer_getInstance();
  };
  AnswerShippingQueryOk$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AnswerShippingQueryOk$Companion_instance = null;
  function AnswerShippingQueryOk$Companion_getInstance() {
    if (AnswerShippingQueryOk$Companion_instance === null) {
      new AnswerShippingQueryOk$Companion();
    }
    return AnswerShippingQueryOk$Companion_instance;
  }
  function AnswerShippingQueryOk$$serializer() {
    this.descriptor_ui28yt$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.answers.payments.AnswerShippingQueryOk', this);
    this.descriptor.addElement_ivxn3r$('shipping_query_id', false);
    this.descriptor.addElement_ivxn3r$('shipping_options', false);
    this.descriptor.addElement_ivxn3r$('ok', true);
    AnswerShippingQueryOk$$serializer_instance = this;
  }
  Object.defineProperty(AnswerShippingQueryOk$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_ui28yt$_0;
    }
  });
  AnswerShippingQueryOk$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.shippingQueryId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, ShippingOptionsSerializer_getInstance(), obj.shippingOptions);
    if (!equals(obj.isOk, true) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 2, obj.isOk);
    output.endStructure_qatsm0$(this.descriptor);
  };
  AnswerShippingQueryOk$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, ShippingOptionsSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, ShippingOptionsSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return AnswerShippingQueryOk_init(bitMask0, local0, local1, local2, null);
  };
  AnswerShippingQueryOk$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, ShippingOptionsSerializer_getInstance(), internal.BooleanSerializer];
  };
  AnswerShippingQueryOk$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var AnswerShippingQueryOk$$serializer_instance = null;
  function AnswerShippingQueryOk$$serializer_getInstance() {
    if (AnswerShippingQueryOk$$serializer_instance === null) {
      new AnswerShippingQueryOk$$serializer();
    }
    return AnswerShippingQueryOk$$serializer_instance;
  }
  function AnswerShippingQueryOk_init(seen1, shippingQueryId, shippingOptions, isOk, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(AnswerShippingQueryOk.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('shipping_query_id');
    else
      $this.shippingQueryId_1w33rh$_0 = shippingQueryId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('shipping_options');
    else
      $this.shippingOptions = shippingOptions;
    if ((seen1 & 4) === 0)
      $this.isOk_t00u62$_0 = true;
    else
      $this.isOk_t00u62$_0 = isOk;
    return $this;
  }
  AnswerShippingQueryOk.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnswerShippingQueryOk',
    interfaces: [AnswerShippingQuery]
  };
  AnswerShippingQueryOk.prototype.component1 = function () {
    return this.shippingQueryId;
  };
  AnswerShippingQueryOk.prototype.component2 = function () {
    return this.shippingOptions;
  };
  AnswerShippingQueryOk.prototype.copy_8fk0zo$ = function (shippingQueryId, shippingOptions) {
    return new AnswerShippingQueryOk(shippingQueryId === void 0 ? this.shippingQueryId : shippingQueryId, shippingOptions === void 0 ? this.shippingOptions : shippingOptions);
  };
  AnswerShippingQueryOk.prototype.toString = function () {
    return 'AnswerShippingQueryOk(shippingQueryId=' + Kotlin.toString(this.shippingQueryId) + (', shippingOptions=' + Kotlin.toString(this.shippingOptions)) + ')';
  };
  AnswerShippingQueryOk.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.shippingQueryId) | 0;
    result = result * 31 + Kotlin.hashCode(this.shippingOptions) | 0;
    return result;
  };
  AnswerShippingQueryOk.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.shippingQueryId, other.shippingQueryId) && Kotlin.equals(this.shippingOptions, other.shippingOptions)))));
  };
  function ShippingOptionsSerializer() {
    ShippingOptionsSerializer_instance = this;
    this.$delegate_qhnlo6$_0 = new ArrayListSerializer(ShippingOption$Companion_getInstance().serializer());
  }
  Object.defineProperty(ShippingOptionsSerializer.prototype, 'descriptor', {
    get: function () {
      return this.$delegate_qhnlo6$_0.descriptor;
    }
  });
  ShippingOptionsSerializer.prototype.deserialize_nts5qn$ = function (decoder) {
    return this.$delegate_qhnlo6$_0.deserialize_nts5qn$(decoder);
  };
  ShippingOptionsSerializer.prototype.patch_mynpiu$ = function (decoder, old) {
    return this.$delegate_qhnlo6$_0.patch_mynpiu$(decoder, old);
  };
  ShippingOptionsSerializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    return this.$delegate_qhnlo6$_0.serialize_awe97i$(encoder, obj);
  };
  ShippingOptionsSerializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ShippingOptionsSerializer',
    interfaces: [KSerializer]
  };
  var ShippingOptionsSerializer_instance = null;
  function ShippingOptionsSerializer_getInstance() {
    if (ShippingOptionsSerializer_instance === null) {
      new ShippingOptionsSerializer();
    }
    return ShippingOptionsSerializer_instance;
  }
  function AnswerShippingQueryError(shippingQueryId, error) {
    AnswerShippingQueryError$Companion_getInstance();
    this.shippingQueryId_owqiup$_0 = shippingQueryId;
    this.error = error;
    this.isOk_8rwxka$_0 = false;
  }
  Object.defineProperty(AnswerShippingQueryError.prototype, 'shippingQueryId', {
    get: function () {
      return this.shippingQueryId_owqiup$_0;
    }
  });
  Object.defineProperty(AnswerShippingQueryError.prototype, 'isOk', {
    get: function () {
      return this.isOk_8rwxka$_0;
    }
  });
  Object.defineProperty(AnswerShippingQueryError.prototype, 'requestSerializer', {
    get: function () {
      return AnswerShippingQueryError$Companion_getInstance().serializer();
    }
  });
  function AnswerShippingQueryError$Companion() {
    AnswerShippingQueryError$Companion_instance = this;
  }
  AnswerShippingQueryError$Companion.prototype.serializer = function () {
    return AnswerShippingQueryError$$serializer_getInstance();
  };
  AnswerShippingQueryError$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AnswerShippingQueryError$Companion_instance = null;
  function AnswerShippingQueryError$Companion_getInstance() {
    if (AnswerShippingQueryError$Companion_instance === null) {
      new AnswerShippingQueryError$Companion();
    }
    return AnswerShippingQueryError$Companion_instance;
  }
  function AnswerShippingQueryError$$serializer() {
    this.descriptor_21qhdj$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.answers.payments.AnswerShippingQueryError', this);
    this.descriptor.addElement_ivxn3r$('shipping_query_id', false);
    this.descriptor.addElement_ivxn3r$('error_message', false);
    this.descriptor.addElement_ivxn3r$('ok', true);
    AnswerShippingQueryError$$serializer_instance = this;
  }
  Object.defineProperty(AnswerShippingQueryError$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_21qhdj$_0;
    }
  });
  AnswerShippingQueryError$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.shippingQueryId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.error);
    if (!equals(obj.isOk, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 2, obj.isOk);
    output.endStructure_qatsm0$(this.descriptor);
  };
  AnswerShippingQueryError$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return AnswerShippingQueryError_init(bitMask0, local0, local1, local2, null);
  };
  AnswerShippingQueryError$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.StringSerializer, internal.BooleanSerializer];
  };
  AnswerShippingQueryError$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var AnswerShippingQueryError$$serializer_instance = null;
  function AnswerShippingQueryError$$serializer_getInstance() {
    if (AnswerShippingQueryError$$serializer_instance === null) {
      new AnswerShippingQueryError$$serializer();
    }
    return AnswerShippingQueryError$$serializer_instance;
  }
  function AnswerShippingQueryError_init(seen1, shippingQueryId, error, isOk, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(AnswerShippingQueryError.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('shipping_query_id');
    else
      $this.shippingQueryId_owqiup$_0 = shippingQueryId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('error_message');
    else
      $this.error = error;
    if ((seen1 & 4) === 0)
      $this.isOk_8rwxka$_0 = false;
    else
      $this.isOk_8rwxka$_0 = isOk;
    return $this;
  }
  AnswerShippingQueryError.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AnswerShippingQueryError',
    interfaces: [AnswerShippingQuery]
  };
  AnswerShippingQueryError.prototype.component1 = function () {
    return this.shippingQueryId;
  };
  AnswerShippingQueryError.prototype.component2 = function () {
    return this.error;
  };
  AnswerShippingQueryError.prototype.copy_puj7f4$ = function (shippingQueryId, error) {
    return new AnswerShippingQueryError(shippingQueryId === void 0 ? this.shippingQueryId : shippingQueryId, error === void 0 ? this.error : error);
  };
  AnswerShippingQueryError.prototype.toString = function () {
    return 'AnswerShippingQueryError(shippingQueryId=' + Kotlin.toString(this.shippingQueryId) + (', error=' + Kotlin.toString(this.error)) + ')';
  };
  AnswerShippingQueryError.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.shippingQueryId) | 0;
    result = result * 31 + Kotlin.hashCode(this.error) | 0;
    return result;
  };
  AnswerShippingQueryError.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.shippingQueryId, other.shippingQueryId) && Kotlin.equals(this.error, other.error)))));
  };
  function createAnswerOk_0($receiver, shippingOptions) {
    return new AnswerShippingQueryOk($receiver.id, shippingOptions);
  }
  function createAnswerError_0($receiver, error) {
    return new AnswerShippingQueryError($receiver.id, error);
  }
  function AnswerPreCheckoutQuery() {
  }
  AnswerPreCheckoutQuery.prototype.method = function () {
    return 'answerPreCheckoutQuery';
  };
  Object.defineProperty(AnswerPreCheckoutQuery.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  AnswerPreCheckoutQuery.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'AnswerPreCheckoutQuery',
    interfaces: [SimpleRequest]
  };
  function AnswerShippingQuery() {
  }
  AnswerShippingQuery.prototype.method = function () {
    return 'answerShippingQuery';
  };
  Object.defineProperty(AnswerShippingQuery.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  AnswerShippingQuery.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'AnswerShippingQuery',
    interfaces: [SimpleRequest]
  };
  function ExportChatInviteLink(chatId) {
    ExportChatInviteLink$Companion_getInstance();
    this.chatId_saaf1q$_0 = chatId;
  }
  Object.defineProperty(ExportChatInviteLink.prototype, 'chatId', {
    get: function () {
      return this.chatId_saaf1q$_0;
    }
  });
  ExportChatInviteLink.prototype.method = function () {
    return 'exportChatInviteLink';
  };
  Object.defineProperty(ExportChatInviteLink.prototype, 'resultDeserializer', {
    get: function () {
      return internal.StringSerializer;
    }
  });
  Object.defineProperty(ExportChatInviteLink.prototype, 'requestSerializer', {
    get: function () {
      return ExportChatInviteLink$Companion_getInstance().serializer();
    }
  });
  function ExportChatInviteLink$Companion() {
    ExportChatInviteLink$Companion_instance = this;
  }
  ExportChatInviteLink$Companion.prototype.serializer = function () {
    return ExportChatInviteLink$$serializer_getInstance();
  };
  ExportChatInviteLink$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ExportChatInviteLink$Companion_instance = null;
  function ExportChatInviteLink$Companion_getInstance() {
    if (ExportChatInviteLink$Companion_instance === null) {
      new ExportChatInviteLink$Companion();
    }
    return ExportChatInviteLink$Companion_instance;
  }
  function ExportChatInviteLink$$serializer() {
    this.descriptor_hn1ujq$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.ExportChatInviteLink', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    ExportChatInviteLink$$serializer_instance = this;
  }
  Object.defineProperty(ExportChatInviteLink$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_hn1ujq$_0;
    }
  });
  ExportChatInviteLink$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  ExportChatInviteLink$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return ExportChatInviteLink_init(bitMask0, local0, null);
  };
  ExportChatInviteLink$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance()];
  };
  ExportChatInviteLink$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var ExportChatInviteLink$$serializer_instance = null;
  function ExportChatInviteLink$$serializer_getInstance() {
    if (ExportChatInviteLink$$serializer_instance === null) {
      new ExportChatInviteLink$$serializer();
    }
    return ExportChatInviteLink$$serializer_instance;
  }
  function ExportChatInviteLink_init(seen1, chatId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(ExportChatInviteLink.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_saaf1q$_0 = chatId;
    return $this;
  }
  ExportChatInviteLink.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ExportChatInviteLink',
    interfaces: [SimpleRequest, ChatRequest]
  };
  ExportChatInviteLink.prototype.component1 = function () {
    return this.chatId;
  };
  ExportChatInviteLink.prototype.copy_eiloeo$ = function (chatId) {
    return new ExportChatInviteLink(chatId === void 0 ? this.chatId : chatId);
  };
  ExportChatInviteLink.prototype.toString = function () {
    return 'ExportChatInviteLink(chatId=' + Kotlin.toString(this.chatId) + ')';
  };
  ExportChatInviteLink.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    return result;
  };
  ExportChatInviteLink.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.chatId, other.chatId))));
  };
  function LeaveChat(chatId) {
    LeaveChat$Companion_getInstance();
    this.chatId_d5wp9e$_0 = chatId;
  }
  Object.defineProperty(LeaveChat.prototype, 'chatId', {
    get: function () {
      return this.chatId_d5wp9e$_0;
    }
  });
  LeaveChat.prototype.method = function () {
    return 'leaveChat';
  };
  Object.defineProperty(LeaveChat.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(LeaveChat.prototype, 'requestSerializer', {
    get: function () {
      return LeaveChat$Companion_getInstance().serializer();
    }
  });
  function LeaveChat$Companion() {
    LeaveChat$Companion_instance = this;
  }
  LeaveChat$Companion.prototype.serializer = function () {
    return LeaveChat$$serializer_getInstance();
  };
  LeaveChat$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var LeaveChat$Companion_instance = null;
  function LeaveChat$Companion_getInstance() {
    if (LeaveChat$Companion_instance === null) {
      new LeaveChat$Companion();
    }
    return LeaveChat$Companion_instance;
  }
  function LeaveChat$$serializer() {
    this.descriptor_zbh19u$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.LeaveChat', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    LeaveChat$$serializer_instance = this;
  }
  Object.defineProperty(LeaveChat$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_zbh19u$_0;
    }
  });
  LeaveChat$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  LeaveChat$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return LeaveChat_init(bitMask0, local0, null);
  };
  LeaveChat$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance()];
  };
  LeaveChat$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var LeaveChat$$serializer_instance = null;
  function LeaveChat$$serializer_getInstance() {
    if (LeaveChat$$serializer_instance === null) {
      new LeaveChat$$serializer();
    }
    return LeaveChat$$serializer_instance;
  }
  function LeaveChat_init(seen1, chatId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(LeaveChat.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_d5wp9e$_0 = chatId;
    return $this;
  }
  LeaveChat.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LeaveChat',
    interfaces: [SimpleRequest, ChatRequest]
  };
  LeaveChat.prototype.component1 = function () {
    return this.chatId;
  };
  LeaveChat.prototype.copy_eiloeo$ = function (chatId) {
    return new LeaveChat(chatId === void 0 ? this.chatId : chatId);
  };
  LeaveChat.prototype.toString = function () {
    return 'LeaveChat(chatId=' + Kotlin.toString(this.chatId) + ')';
  };
  LeaveChat.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    return result;
  };
  LeaveChat.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.chatId, other.chatId))));
  };
  function ChatMemberRequest() {
  }
  ChatMemberRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ChatMemberRequest',
    interfaces: [SimpleRequest, ChatRequest]
  };
  function GetChat(chatId) {
    GetChat$Companion_getInstance();
    this.chatId_twaew9$_0 = chatId;
  }
  Object.defineProperty(GetChat.prototype, 'chatId', {
    get: function () {
      return this.chatId_twaew9$_0;
    }
  });
  GetChat.prototype.method = function () {
    return 'getChat';
  };
  Object.defineProperty(GetChat.prototype, 'resultDeserializer', {
    get: function () {
      return ExtendedChatSerializer_getInstance();
    }
  });
  Object.defineProperty(GetChat.prototype, 'requestSerializer', {
    get: function () {
      return GetChat$Companion_getInstance().serializer();
    }
  });
  function GetChat$Companion() {
    GetChat$Companion_instance = this;
  }
  GetChat$Companion.prototype.serializer = function () {
    return GetChat$$serializer_getInstance();
  };
  GetChat$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetChat$Companion_instance = null;
  function GetChat$Companion_getInstance() {
    if (GetChat$Companion_instance === null) {
      new GetChat$Companion();
    }
    return GetChat$Companion_instance;
  }
  function GetChat$$serializer() {
    this.descriptor_kw8gut$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.get.GetChat', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    GetChat$$serializer_instance = this;
  }
  Object.defineProperty(GetChat$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_kw8gut$_0;
    }
  });
  GetChat$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetChat$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetChat_init(bitMask0, local0, null);
  };
  GetChat$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance()];
  };
  GetChat$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetChat$$serializer_instance = null;
  function GetChat$$serializer_getInstance() {
    if (GetChat$$serializer_instance === null) {
      new GetChat$$serializer();
    }
    return GetChat$$serializer_instance;
  }
  function GetChat_init(seen1, chatId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetChat.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_twaew9$_0 = chatId;
    return $this;
  }
  GetChat.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetChat',
    interfaces: [SimpleRequest, ChatRequest]
  };
  GetChat.prototype.component1 = function () {
    return this.chatId;
  };
  GetChat.prototype.copy_eiloeo$ = function (chatId) {
    return new GetChat(chatId === void 0 ? this.chatId : chatId);
  };
  GetChat.prototype.toString = function () {
    return 'GetChat(chatId=' + Kotlin.toString(this.chatId) + ')';
  };
  GetChat.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    return result;
  };
  GetChat.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.chatId, other.chatId))));
  };
  var chatMembersListSerializer;
  function GetChatAdministrators(chatId) {
    GetChatAdministrators$Companion_getInstance();
    this.chatId_h1bh69$_0 = chatId;
  }
  Object.defineProperty(GetChatAdministrators.prototype, 'chatId', {
    get: function () {
      return this.chatId_h1bh69$_0;
    }
  });
  GetChatAdministrators.prototype.method = function () {
    return 'getChatAdministrators';
  };
  Object.defineProperty(GetChatAdministrators.prototype, 'resultDeserializer', {
    get: function () {
      return chatMembersListSerializer;
    }
  });
  Object.defineProperty(GetChatAdministrators.prototype, 'requestSerializer', {
    get: function () {
      return GetChatAdministrators$Companion_getInstance().serializer();
    }
  });
  function GetChatAdministrators$Companion() {
    GetChatAdministrators$Companion_instance = this;
  }
  GetChatAdministrators$Companion.prototype.serializer = function () {
    return GetChatAdministrators$$serializer_getInstance();
  };
  GetChatAdministrators$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetChatAdministrators$Companion_instance = null;
  function GetChatAdministrators$Companion_getInstance() {
    if (GetChatAdministrators$Companion_instance === null) {
      new GetChatAdministrators$Companion();
    }
    return GetChatAdministrators$Companion_instance;
  }
  function GetChatAdministrators$$serializer() {
    this.descriptor_x3yj7f$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.get.GetChatAdministrators', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    GetChatAdministrators$$serializer_instance = this;
  }
  Object.defineProperty(GetChatAdministrators$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_x3yj7f$_0;
    }
  });
  GetChatAdministrators$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetChatAdministrators$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetChatAdministrators_init(bitMask0, local0, null);
  };
  GetChatAdministrators$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance()];
  };
  GetChatAdministrators$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetChatAdministrators$$serializer_instance = null;
  function GetChatAdministrators$$serializer_getInstance() {
    if (GetChatAdministrators$$serializer_instance === null) {
      new GetChatAdministrators$$serializer();
    }
    return GetChatAdministrators$$serializer_instance;
  }
  function GetChatAdministrators_init(seen1, chatId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetChatAdministrators.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_h1bh69$_0 = chatId;
    return $this;
  }
  GetChatAdministrators.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetChatAdministrators',
    interfaces: [SimpleRequest, ChatRequest]
  };
  GetChatAdministrators.prototype.component1 = function () {
    return this.chatId;
  };
  GetChatAdministrators.prototype.copy_eiloeo$ = function (chatId) {
    return new GetChatAdministrators(chatId === void 0 ? this.chatId : chatId);
  };
  GetChatAdministrators.prototype.toString = function () {
    return 'GetChatAdministrators(chatId=' + Kotlin.toString(this.chatId) + ')';
  };
  GetChatAdministrators.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    return result;
  };
  GetChatAdministrators.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.chatId, other.chatId))));
  };
  function GetChatMembersCount(chatId) {
    GetChatMembersCount$Companion_getInstance();
    this.chatId_ld2flt$_0 = chatId;
  }
  Object.defineProperty(GetChatMembersCount.prototype, 'chatId', {
    get: function () {
      return this.chatId_ld2flt$_0;
    }
  });
  GetChatMembersCount.prototype.method = function () {
    return 'getChatMembersCount';
  };
  Object.defineProperty(GetChatMembersCount.prototype, 'resultDeserializer', {
    get: function () {
      return internal.IntSerializer;
    }
  });
  Object.defineProperty(GetChatMembersCount.prototype, 'requestSerializer', {
    get: function () {
      return GetChatMembersCount$Companion_getInstance().serializer();
    }
  });
  function GetChatMembersCount$Companion() {
    GetChatMembersCount$Companion_instance = this;
  }
  GetChatMembersCount$Companion.prototype.serializer = function () {
    return GetChatMembersCount$$serializer_getInstance();
  };
  GetChatMembersCount$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetChatMembersCount$Companion_instance = null;
  function GetChatMembersCount$Companion_getInstance() {
    if (GetChatMembersCount$Companion_instance === null) {
      new GetChatMembersCount$Companion();
    }
    return GetChatMembersCount$Companion_instance;
  }
  function GetChatMembersCount$$serializer() {
    this.descriptor_wb07hn$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.get.GetChatMembersCount', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    GetChatMembersCount$$serializer_instance = this;
  }
  Object.defineProperty(GetChatMembersCount$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_wb07hn$_0;
    }
  });
  GetChatMembersCount$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetChatMembersCount$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetChatMembersCount_init(bitMask0, local0, null);
  };
  GetChatMembersCount$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance()];
  };
  GetChatMembersCount$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetChatMembersCount$$serializer_instance = null;
  function GetChatMembersCount$$serializer_getInstance() {
    if (GetChatMembersCount$$serializer_instance === null) {
      new GetChatMembersCount$$serializer();
    }
    return GetChatMembersCount$$serializer_instance;
  }
  function GetChatMembersCount_init(seen1, chatId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetChatMembersCount.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_ld2flt$_0 = chatId;
    return $this;
  }
  GetChatMembersCount.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetChatMembersCount',
    interfaces: [SimpleRequest, ChatRequest]
  };
  GetChatMembersCount.prototype.component1 = function () {
    return this.chatId;
  };
  GetChatMembersCount.prototype.copy_eiloeo$ = function (chatId) {
    return new GetChatMembersCount(chatId === void 0 ? this.chatId : chatId);
  };
  GetChatMembersCount.prototype.toString = function () {
    return 'GetChatMembersCount(chatId=' + Kotlin.toString(this.chatId) + ')';
  };
  GetChatMembersCount.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    return result;
  };
  GetChatMembersCount.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.chatId, other.chatId))));
  };
  function GetChatMember(chatId, userId) {
    GetChatMember$Companion_getInstance();
    this.chatId_w2navu$_0 = chatId;
    this.userId_oatdxv$_0 = userId;
  }
  Object.defineProperty(GetChatMember.prototype, 'chatId', {
    get: function () {
      return this.chatId_w2navu$_0;
    }
  });
  Object.defineProperty(GetChatMember.prototype, 'userId', {
    get: function () {
      return this.userId_oatdxv$_0;
    }
  });
  GetChatMember.prototype.method = function () {
    return 'getChatMember';
  };
  Object.defineProperty(GetChatMember.prototype, 'resultDeserializer', {
    get: function () {
      return ChatMemberDeserializationStrategy_getInstance();
    }
  });
  Object.defineProperty(GetChatMember.prototype, 'requestSerializer', {
    get: function () {
      return GetChatMember$Companion_getInstance().serializer();
    }
  });
  function GetChatMember$Companion() {
    GetChatMember$Companion_instance = this;
  }
  GetChatMember$Companion.prototype.serializer = function () {
    return GetChatMember$$serializer_getInstance();
  };
  GetChatMember$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetChatMember$Companion_instance = null;
  function GetChatMember$Companion_getInstance() {
    if (GetChatMember$Companion_instance === null) {
      new GetChatMember$Companion();
    }
    return GetChatMember$Companion_instance;
  }
  function GetChatMember$$serializer() {
    this.descriptor_q5dhg2$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.GetChatMember', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    GetChatMember$$serializer_instance = this;
  }
  Object.defineProperty(GetChatMember$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_q5dhg2$_0;
    }
  });
  GetChatMember$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), obj.userId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetChatMember$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetChatMember_init(bitMask0, local0, local1, null);
  };
  GetChatMember$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), ChatIdentifierSerializer_getInstance()];
  };
  GetChatMember$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetChatMember$$serializer_instance = null;
  function GetChatMember$$serializer_getInstance() {
    if (GetChatMember$$serializer_instance === null) {
      new GetChatMember$$serializer();
    }
    return GetChatMember$$serializer_instance;
  }
  function GetChatMember_init(seen1, chatId, userId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetChatMember.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_w2navu$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_oatdxv$_0 = userId;
    return $this;
  }
  GetChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetChatMember',
    interfaces: [ChatMemberRequest]
  };
  GetChatMember.prototype.component1 = function () {
    return this.chatId;
  };
  GetChatMember.prototype.component2 = function () {
    return this.userId;
  };
  GetChatMember.prototype.copy_oykgti$ = function (chatId, userId) {
    return new GetChatMember(chatId === void 0 ? this.chatId : chatId, userId === void 0 ? this.userId : userId);
  };
  GetChatMember.prototype.toString = function () {
    return 'GetChatMember(chatId=' + Kotlin.toString(this.chatId) + (', userId=' + Kotlin.toString(this.userId)) + ')';
  };
  GetChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    return result;
  };
  GetChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.userId, other.userId)))));
  };
  function KickChatMember(chatId, userId, untilDate) {
    KickChatMember$Companion_getInstance();
    if (untilDate === void 0)
      untilDate = null;
    this.chatId_grpxgs$_0 = chatId;
    this.userId_242kbd$_0 = userId;
    this.untilDate_dqfwon$_0 = untilDate;
  }
  Object.defineProperty(KickChatMember.prototype, 'chatId', {
    get: function () {
      return this.chatId_grpxgs$_0;
    }
  });
  Object.defineProperty(KickChatMember.prototype, 'userId', {
    get: function () {
      return this.userId_242kbd$_0;
    }
  });
  Object.defineProperty(KickChatMember.prototype, 'untilDate', {
    get: function () {
      return this.untilDate_dqfwon$_0;
    }
  });
  KickChatMember.prototype.method = function () {
    return 'kickChatMember';
  };
  Object.defineProperty(KickChatMember.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(KickChatMember.prototype, 'requestSerializer', {
    get: function () {
      return KickChatMember$Companion_getInstance().serializer();
    }
  });
  function KickChatMember$Companion() {
    KickChatMember$Companion_instance = this;
  }
  KickChatMember$Companion.prototype.serializer = function () {
    return KickChatMember$$serializer_getInstance();
  };
  KickChatMember$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var KickChatMember$Companion_instance = null;
  function KickChatMember$Companion_getInstance() {
    if (KickChatMember$Companion_instance === null) {
      new KickChatMember$Companion();
    }
    return KickChatMember$Companion_instance;
  }
  function KickChatMember$$serializer() {
    this.descriptor_3vtt7c$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.KickChatMember', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('until_date', true);
    KickChatMember$$serializer_instance = this;
  }
  Object.defineProperty(KickChatMember$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_3vtt7c$_0;
    }
  });
  KickChatMember$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), obj.userId);
    if (!equals(obj.untilDate, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, TelegramDateSerializer_getInstance(), obj.untilDate);
    output.endStructure_qatsm0$(this.descriptor);
  };
  KickChatMember$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, TelegramDateSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, TelegramDateSerializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return KickChatMember_init(bitMask0, local0, local1, local2, null);
  };
  KickChatMember$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), ChatIdentifierSerializer_getInstance(), new NullableSerializer(TelegramDateSerializer_getInstance())];
  };
  KickChatMember$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var KickChatMember$$serializer_instance = null;
  function KickChatMember$$serializer_getInstance() {
    if (KickChatMember$$serializer_instance === null) {
      new KickChatMember$$serializer();
    }
    return KickChatMember$$serializer_instance;
  }
  function KickChatMember_init(seen1, chatId, userId, untilDate, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(KickChatMember.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_grpxgs$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_242kbd$_0 = userId;
    if ((seen1 & 4) === 0)
      $this.untilDate_dqfwon$_0 = null;
    else
      $this.untilDate_dqfwon$_0 = untilDate;
    return $this;
  }
  KickChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KickChatMember',
    interfaces: [UntilDate, ChatMemberRequest]
  };
  KickChatMember.prototype.component1 = function () {
    return this.chatId;
  };
  KickChatMember.prototype.component2 = function () {
    return this.userId;
  };
  KickChatMember.prototype.component3 = function () {
    return this.untilDate;
  };
  KickChatMember.prototype.copy_etyiw7$ = function (chatId, userId, untilDate) {
    return new KickChatMember(chatId === void 0 ? this.chatId : chatId, userId === void 0 ? this.userId : userId, untilDate === void 0 ? this.untilDate : untilDate);
  };
  KickChatMember.prototype.toString = function () {
    return 'KickChatMember(chatId=' + Kotlin.toString(this.chatId) + (', userId=' + Kotlin.toString(this.userId)) + (', untilDate=' + Kotlin.toString(this.untilDate)) + ')';
  };
  KickChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.untilDate) | 0;
    return result;
  };
  KickChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.untilDate, other.untilDate)))));
  };
  function PromoteChatMember(chatId, userId, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers) {
    PromoteChatMember$Companion_getInstance();
    if (untilDate === void 0)
      untilDate = null;
    if (canChangeInfo === void 0)
      canChangeInfo = null;
    if (canPostMessages === void 0)
      canPostMessages = null;
    if (canEditMessages === void 0)
      canEditMessages = null;
    if (canDeleteMessages === void 0)
      canDeleteMessages = null;
    if (canInviteUsers === void 0)
      canInviteUsers = null;
    if (canRestrictMembers === void 0)
      canRestrictMembers = null;
    if (canPinMessages === void 0)
      canPinMessages = null;
    if (canPromoteMembers === void 0)
      canPromoteMembers = null;
    this.chatId_fr4bcg$_0 = chatId;
    this.userId_uerohv$_0 = userId;
    this.untilDate_g4mmat$_0 = untilDate;
    this.canChangeInfo_0 = canChangeInfo;
    this.canPostMessages_0 = canPostMessages;
    this.canEditMessages_0 = canEditMessages;
    this.canDeleteMessages_0 = canDeleteMessages;
    this.canInviteUsers_0 = canInviteUsers;
    this.canRestrictMembers_0 = canRestrictMembers;
    this.canPinMessages_0 = canPinMessages;
    this.canPromoteMembers_0 = canPromoteMembers;
  }
  Object.defineProperty(PromoteChatMember.prototype, 'chatId', {
    get: function () {
      return this.chatId_fr4bcg$_0;
    }
  });
  Object.defineProperty(PromoteChatMember.prototype, 'userId', {
    get: function () {
      return this.userId_uerohv$_0;
    }
  });
  Object.defineProperty(PromoteChatMember.prototype, 'untilDate', {
    get: function () {
      return this.untilDate_g4mmat$_0;
    }
  });
  PromoteChatMember.prototype.method = function () {
    return 'promoteChatMember';
  };
  Object.defineProperty(PromoteChatMember.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(PromoteChatMember.prototype, 'requestSerializer', {
    get: function () {
      return PromoteChatMember$Companion_getInstance().serializer();
    }
  });
  function PromoteChatMember$Companion() {
    PromoteChatMember$Companion_instance = this;
  }
  PromoteChatMember$Companion.prototype.serializer = function () {
    return PromoteChatMember$$serializer_getInstance();
  };
  PromoteChatMember$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PromoteChatMember$Companion_instance = null;
  function PromoteChatMember$Companion_getInstance() {
    if (PromoteChatMember$Companion_instance === null) {
      new PromoteChatMember$Companion();
    }
    return PromoteChatMember$Companion_instance;
  }
  function PromoteChatMember$$serializer() {
    this.descriptor_pkiubg$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.PromoteChatMember', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('until_date', true);
    this.descriptor.addElement_ivxn3r$('can_change_info', true);
    this.descriptor.addElement_ivxn3r$('can_post_messages', true);
    this.descriptor.addElement_ivxn3r$('can_edit_messages', true);
    this.descriptor.addElement_ivxn3r$('can_delete_messages', true);
    this.descriptor.addElement_ivxn3r$('can_invite_users', true);
    this.descriptor.addElement_ivxn3r$('can_restrict_members', true);
    this.descriptor.addElement_ivxn3r$('can_pin_messages', true);
    this.descriptor.addElement_ivxn3r$('can_promote_members', true);
    PromoteChatMember$$serializer_instance = this;
  }
  Object.defineProperty(PromoteChatMember$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_pkiubg$_0;
    }
  });
  PromoteChatMember$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), obj.userId);
    if (!equals(obj.untilDate, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, TelegramDateSerializer_getInstance(), obj.untilDate);
    if (!equals(obj.canChangeInfo_0, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.BooleanSerializer, obj.canChangeInfo_0);
    if (!equals(obj.canPostMessages_0, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.BooleanSerializer, obj.canPostMessages_0);
    if (!equals(obj.canEditMessages_0, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.BooleanSerializer, obj.canEditMessages_0);
    if (!equals(obj.canDeleteMessages_0, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, internal.BooleanSerializer, obj.canDeleteMessages_0);
    if (!equals(obj.canInviteUsers_0, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, internal.BooleanSerializer, obj.canInviteUsers_0);
    if (!equals(obj.canRestrictMembers_0, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 8, internal.BooleanSerializer, obj.canRestrictMembers_0);
    if (!equals(obj.canPinMessages_0, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 9))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 9, internal.BooleanSerializer, obj.canPinMessages_0);
    if (!equals(obj.canPromoteMembers_0, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 10))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 10, internal.BooleanSerializer, obj.canPromoteMembers_0);
    output.endStructure_qatsm0$(this.descriptor);
  };
  PromoteChatMember$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9
    , local10;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, TelegramDateSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, TelegramDateSerializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.BooleanSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.BooleanSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.BooleanSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, internal.BooleanSerializer, local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, internal.BooleanSerializer, local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = (bitMask0 & 256) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 8, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 8, internal.BooleanSerializer, local8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = (bitMask0 & 512) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 9, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 9, internal.BooleanSerializer, local9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case 10:
          local10 = (bitMask0 & 1024) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 10, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 10, internal.BooleanSerializer, local10);
          bitMask0 |= 1024;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return PromoteChatMember_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, local10, null);
  };
  PromoteChatMember$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), ChatIdentifierSerializer_getInstance(), new NullableSerializer(TelegramDateSerializer_getInstance()), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(internal.BooleanSerializer)];
  };
  PromoteChatMember$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var PromoteChatMember$$serializer_instance = null;
  function PromoteChatMember$$serializer_getInstance() {
    if (PromoteChatMember$$serializer_instance === null) {
      new PromoteChatMember$$serializer();
    }
    return PromoteChatMember$$serializer_instance;
  }
  function PromoteChatMember_init(seen1, chatId, userId, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(PromoteChatMember.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_fr4bcg$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_uerohv$_0 = userId;
    if ((seen1 & 4) === 0)
      $this.untilDate_g4mmat$_0 = null;
    else
      $this.untilDate_g4mmat$_0 = untilDate;
    if ((seen1 & 8) === 0)
      $this.canChangeInfo_0 = null;
    else
      $this.canChangeInfo_0 = canChangeInfo;
    if ((seen1 & 16) === 0)
      $this.canPostMessages_0 = null;
    else
      $this.canPostMessages_0 = canPostMessages;
    if ((seen1 & 32) === 0)
      $this.canEditMessages_0 = null;
    else
      $this.canEditMessages_0 = canEditMessages;
    if ((seen1 & 64) === 0)
      $this.canDeleteMessages_0 = null;
    else
      $this.canDeleteMessages_0 = canDeleteMessages;
    if ((seen1 & 128) === 0)
      $this.canInviteUsers_0 = null;
    else
      $this.canInviteUsers_0 = canInviteUsers;
    if ((seen1 & 256) === 0)
      $this.canRestrictMembers_0 = null;
    else
      $this.canRestrictMembers_0 = canRestrictMembers;
    if ((seen1 & 512) === 0)
      $this.canPinMessages_0 = null;
    else
      $this.canPinMessages_0 = canPinMessages;
    if ((seen1 & 1024) === 0)
      $this.canPromoteMembers_0 = null;
    else
      $this.canPromoteMembers_0 = canPromoteMembers;
    return $this;
  }
  PromoteChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PromoteChatMember',
    interfaces: [UntilDate, ChatMemberRequest]
  };
  PromoteChatMember.prototype.component1 = function () {
    return this.chatId;
  };
  PromoteChatMember.prototype.component2 = function () {
    return this.userId;
  };
  PromoteChatMember.prototype.component3 = function () {
    return this.untilDate;
  };
  PromoteChatMember.prototype.component4_0 = function () {
    return this.canChangeInfo_0;
  };
  PromoteChatMember.prototype.component5_0 = function () {
    return this.canPostMessages_0;
  };
  PromoteChatMember.prototype.component6_0 = function () {
    return this.canEditMessages_0;
  };
  PromoteChatMember.prototype.component7_0 = function () {
    return this.canDeleteMessages_0;
  };
  PromoteChatMember.prototype.component8_0 = function () {
    return this.canInviteUsers_0;
  };
  PromoteChatMember.prototype.component9_0 = function () {
    return this.canRestrictMembers_0;
  };
  PromoteChatMember.prototype.component10_0 = function () {
    return this.canPinMessages_0;
  };
  PromoteChatMember.prototype.component11_0 = function () {
    return this.canPromoteMembers_0;
  };
  PromoteChatMember.prototype.copy_rdfme1$ = function (chatId, userId, untilDate, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers) {
    return new PromoteChatMember(chatId === void 0 ? this.chatId : chatId, userId === void 0 ? this.userId : userId, untilDate === void 0 ? this.untilDate : untilDate, canChangeInfo === void 0 ? this.canChangeInfo_0 : canChangeInfo, canPostMessages === void 0 ? this.canPostMessages_0 : canPostMessages, canEditMessages === void 0 ? this.canEditMessages_0 : canEditMessages, canDeleteMessages === void 0 ? this.canDeleteMessages_0 : canDeleteMessages, canInviteUsers === void 0 ? this.canInviteUsers_0 : canInviteUsers, canRestrictMembers === void 0 ? this.canRestrictMembers_0 : canRestrictMembers, canPinMessages === void 0 ? this.canPinMessages_0 : canPinMessages, canPromoteMembers === void 0 ? this.canPromoteMembers_0 : canPromoteMembers);
  };
  PromoteChatMember.prototype.toString = function () {
    return 'PromoteChatMember(chatId=' + Kotlin.toString(this.chatId) + (', userId=' + Kotlin.toString(this.userId)) + (', untilDate=' + Kotlin.toString(this.untilDate)) + (', canChangeInfo=' + Kotlin.toString(this.canChangeInfo_0)) + (', canPostMessages=' + Kotlin.toString(this.canPostMessages_0)) + (', canEditMessages=' + Kotlin.toString(this.canEditMessages_0)) + (', canDeleteMessages=' + Kotlin.toString(this.canDeleteMessages_0)) + (', canInviteUsers=' + Kotlin.toString(this.canInviteUsers_0)) + (', canRestrictMembers=' + Kotlin.toString(this.canRestrictMembers_0)) + (', canPinMessages=' + Kotlin.toString(this.canPinMessages_0)) + (', canPromoteMembers=' + Kotlin.toString(this.canPromoteMembers_0)) + ')';
  };
  PromoteChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.untilDate) | 0;
    result = result * 31 + Kotlin.hashCode(this.canChangeInfo_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canPostMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canEditMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canDeleteMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canInviteUsers_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canRestrictMembers_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canPinMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canPromoteMembers_0) | 0;
    return result;
  };
  PromoteChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.untilDate, other.untilDate) && Kotlin.equals(this.canChangeInfo_0, other.canChangeInfo_0) && Kotlin.equals(this.canPostMessages_0, other.canPostMessages_0) && Kotlin.equals(this.canEditMessages_0, other.canEditMessages_0) && Kotlin.equals(this.canDeleteMessages_0, other.canDeleteMessages_0) && Kotlin.equals(this.canInviteUsers_0, other.canInviteUsers_0) && Kotlin.equals(this.canRestrictMembers_0, other.canRestrictMembers_0) && Kotlin.equals(this.canPinMessages_0, other.canPinMessages_0) && Kotlin.equals(this.canPromoteMembers_0, other.canPromoteMembers_0)))));
  };
  function RestrictChatMember(chatId, userId, untilDate, permissions) {
    RestrictChatMember$Companion_getInstance();
    if (untilDate === void 0)
      untilDate = null;
    this.chatId_brz1nm$_0 = chatId;
    this.userId_2vobht$_0 = userId;
    this.untilDate_kgitm5$_0 = untilDate;
    this.permissions = permissions;
  }
  Object.defineProperty(RestrictChatMember.prototype, 'chatId', {
    get: function () {
      return this.chatId_brz1nm$_0;
    }
  });
  Object.defineProperty(RestrictChatMember.prototype, 'userId', {
    get: function () {
      return this.userId_2vobht$_0;
    }
  });
  Object.defineProperty(RestrictChatMember.prototype, 'untilDate', {
    get: function () {
      return this.untilDate_kgitm5$_0;
    }
  });
  RestrictChatMember.prototype.method = function () {
    return 'restrictChatMember';
  };
  Object.defineProperty(RestrictChatMember.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(RestrictChatMember.prototype, 'requestSerializer', {
    get: function () {
      return RestrictChatMember$Companion_getInstance().serializer();
    }
  });
  function RestrictChatMember$Companion() {
    RestrictChatMember$Companion_instance = this;
  }
  RestrictChatMember$Companion.prototype.serializer = function () {
    return RestrictChatMember$$serializer_getInstance();
  };
  RestrictChatMember$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var RestrictChatMember$Companion_instance = null;
  function RestrictChatMember$Companion_getInstance() {
    if (RestrictChatMember$Companion_instance === null) {
      new RestrictChatMember$Companion();
    }
    return RestrictChatMember$Companion_instance;
  }
  function RestrictChatMember$$serializer() {
    this.descriptor_xgpcwe$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.RestrictChatMember', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('until_date', true);
    this.descriptor.addElement_ivxn3r$('permissions', false);
    RestrictChatMember$$serializer_instance = this;
  }
  Object.defineProperty(RestrictChatMember$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_xgpcwe$_0;
    }
  });
  RestrictChatMember$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), obj.userId);
    if (!equals(obj.untilDate, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, TelegramDateSerializer_getInstance(), obj.untilDate);
    output.encodeSerializableElement_blecud$(this.descriptor, 3, ChatPermissions$$serializer_getInstance(), obj.permissions);
    output.endStructure_qatsm0$(this.descriptor);
  };
  RestrictChatMember$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, TelegramDateSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, TelegramDateSerializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 3, ChatPermissions$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 3, ChatPermissions$$serializer_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return RestrictChatMember_init(bitMask0, local0, local1, local2, local3, null);
  };
  RestrictChatMember$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), ChatIdentifierSerializer_getInstance(), new NullableSerializer(TelegramDateSerializer_getInstance()), ChatPermissions$$serializer_getInstance()];
  };
  RestrictChatMember$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var RestrictChatMember$$serializer_instance = null;
  function RestrictChatMember$$serializer_getInstance() {
    if (RestrictChatMember$$serializer_instance === null) {
      new RestrictChatMember$$serializer();
    }
    return RestrictChatMember$$serializer_instance;
  }
  function RestrictChatMember_init(seen1, chatId, userId, untilDate, permissions, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(RestrictChatMember.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_brz1nm$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_2vobht$_0 = userId;
    if ((seen1 & 4) === 0)
      $this.untilDate_kgitm5$_0 = null;
    else
      $this.untilDate_kgitm5$_0 = untilDate;
    if ((seen1 & 8) === 0)
      throw new MissingFieldException('permissions');
    else
      $this.permissions = permissions;
    return $this;
  }
  RestrictChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RestrictChatMember',
    interfaces: [UntilDate, ChatMemberRequest]
  };
  RestrictChatMember.prototype.component1 = function () {
    return this.chatId;
  };
  RestrictChatMember.prototype.component2 = function () {
    return this.userId;
  };
  RestrictChatMember.prototype.component3 = function () {
    return this.untilDate;
  };
  RestrictChatMember.prototype.component4 = function () {
    return this.permissions;
  };
  RestrictChatMember.prototype.copy_1lyqio$ = function (chatId, userId, untilDate, permissions) {
    return new RestrictChatMember(chatId === void 0 ? this.chatId : chatId, userId === void 0 ? this.userId : userId, untilDate === void 0 ? this.untilDate : untilDate, permissions === void 0 ? this.permissions : permissions);
  };
  RestrictChatMember.prototype.toString = function () {
    return 'RestrictChatMember(chatId=' + Kotlin.toString(this.chatId) + (', userId=' + Kotlin.toString(this.userId)) + (', untilDate=' + Kotlin.toString(this.untilDate)) + (', permissions=' + Kotlin.toString(this.permissions)) + ')';
  };
  RestrictChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.untilDate) | 0;
    result = result * 31 + Kotlin.hashCode(this.permissions) | 0;
    return result;
  };
  RestrictChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.untilDate, other.untilDate) && Kotlin.equals(this.permissions, other.permissions)))));
  };
  function SetChatAdministratorCustomTitle(chatId, userId, customTitle) {
    SetChatAdministratorCustomTitle$Companion_getInstance();
    this.chatId_n86j7y$_0 = chatId;
    this.userId_x5a5lr$_0 = userId;
    this.customTitle = customTitle;
    if (!customTitleLength.contains_mef7kx$(this.customTitle.length)) {
      throw IllegalArgumentException_init('Custom title length must be in range ' + customTitleLength + ', but was ' + this.customTitle.length);
    }
  }
  Object.defineProperty(SetChatAdministratorCustomTitle.prototype, 'chatId', {
    get: function () {
      return this.chatId_n86j7y$_0;
    }
  });
  Object.defineProperty(SetChatAdministratorCustomTitle.prototype, 'userId', {
    get: function () {
      return this.userId_x5a5lr$_0;
    }
  });
  SetChatAdministratorCustomTitle.prototype.method = function () {
    return 'setChatAdministratorCustomTitle';
  };
  Object.defineProperty(SetChatAdministratorCustomTitle.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(SetChatAdministratorCustomTitle.prototype, 'requestSerializer', {
    get: function () {
      return RestrictChatMember$Companion_getInstance().serializer();
    }
  });
  function SetChatAdministratorCustomTitle$Companion() {
    SetChatAdministratorCustomTitle$Companion_instance = this;
  }
  SetChatAdministratorCustomTitle$Companion.prototype.serializer = function () {
    return SetChatAdministratorCustomTitle$$serializer_getInstance();
  };
  SetChatAdministratorCustomTitle$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SetChatAdministratorCustomTitle$Companion_instance = null;
  function SetChatAdministratorCustomTitle$Companion_getInstance() {
    if (SetChatAdministratorCustomTitle$Companion_instance === null) {
      new SetChatAdministratorCustomTitle$Companion();
    }
    return SetChatAdministratorCustomTitle$Companion_instance;
  }
  function SetChatAdministratorCustomTitle$$serializer() {
    this.descriptor_mbvx5q$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.SetChatAdministratorCustomTitle', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('custom_title', false);
    SetChatAdministratorCustomTitle$$serializer_instance = this;
  }
  Object.defineProperty(SetChatAdministratorCustomTitle$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_mbvx5q$_0;
    }
  });
  SetChatAdministratorCustomTitle$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), obj.userId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.customTitle);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SetChatAdministratorCustomTitle$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SetChatAdministratorCustomTitle_init(bitMask0, local0, local1, local2, null);
  };
  SetChatAdministratorCustomTitle$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), ChatIdentifierSerializer_getInstance(), internal.StringSerializer];
  };
  SetChatAdministratorCustomTitle$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SetChatAdministratorCustomTitle$$serializer_instance = null;
  function SetChatAdministratorCustomTitle$$serializer_getInstance() {
    if (SetChatAdministratorCustomTitle$$serializer_instance === null) {
      new SetChatAdministratorCustomTitle$$serializer();
    }
    return SetChatAdministratorCustomTitle$$serializer_instance;
  }
  function SetChatAdministratorCustomTitle_init(seen1, chatId, userId, customTitle, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SetChatAdministratorCustomTitle.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_n86j7y$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_x5a5lr$_0 = userId;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('custom_title');
    else
      $this.customTitle = customTitle;
    if (!customTitleLength.contains_mef7kx$($this.customTitle.length)) {
      throw IllegalArgumentException_init('Custom title length must be in range ' + customTitleLength + ', but was ' + $this.customTitle.length);
    }
    return $this;
  }
  SetChatAdministratorCustomTitle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SetChatAdministratorCustomTitle',
    interfaces: [ChatMemberRequest]
  };
  SetChatAdministratorCustomTitle.prototype.component1 = function () {
    return this.chatId;
  };
  SetChatAdministratorCustomTitle.prototype.component2 = function () {
    return this.userId;
  };
  SetChatAdministratorCustomTitle.prototype.component3 = function () {
    return this.customTitle;
  };
  SetChatAdministratorCustomTitle.prototype.copy_nclzkm$ = function (chatId, userId, customTitle) {
    return new SetChatAdministratorCustomTitle(chatId === void 0 ? this.chatId : chatId, userId === void 0 ? this.userId : userId, customTitle === void 0 ? this.customTitle : customTitle);
  };
  SetChatAdministratorCustomTitle.prototype.toString = function () {
    return 'SetChatAdministratorCustomTitle(chatId=' + Kotlin.toString(this.chatId) + (', userId=' + Kotlin.toString(this.userId)) + (', customTitle=' + Kotlin.toString(this.customTitle)) + ')';
  };
  SetChatAdministratorCustomTitle.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.customTitle) | 0;
    return result;
  };
  SetChatAdministratorCustomTitle.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.customTitle, other.customTitle)))));
  };
  function UnbanChatMember(chatId, userId) {
    UnbanChatMember$Companion_getInstance();
    this.chatId_xox27a$_0 = chatId;
    this.userId_j19p1v$_0 = userId;
  }
  Object.defineProperty(UnbanChatMember.prototype, 'chatId', {
    get: function () {
      return this.chatId_xox27a$_0;
    }
  });
  Object.defineProperty(UnbanChatMember.prototype, 'userId', {
    get: function () {
      return this.userId_j19p1v$_0;
    }
  });
  UnbanChatMember.prototype.method = function () {
    return 'unbanChatMember';
  };
  Object.defineProperty(UnbanChatMember.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(UnbanChatMember.prototype, 'requestSerializer', {
    get: function () {
      return UnbanChatMember$Companion_getInstance().serializer();
    }
  });
  function UnbanChatMember$Companion() {
    UnbanChatMember$Companion_instance = this;
  }
  UnbanChatMember$Companion.prototype.serializer = function () {
    return UnbanChatMember$$serializer_getInstance();
  };
  UnbanChatMember$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var UnbanChatMember$Companion_instance = null;
  function UnbanChatMember$Companion_getInstance() {
    if (UnbanChatMember$Companion_instance === null) {
      new UnbanChatMember$Companion();
    }
    return UnbanChatMember$Companion_instance;
  }
  function UnbanChatMember$$serializer() {
    this.descriptor_ul97hq$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.members.UnbanChatMember', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    UnbanChatMember$$serializer_instance = this;
  }
  Object.defineProperty(UnbanChatMember$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_ul97hq$_0;
    }
  });
  UnbanChatMember$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), obj.userId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  UnbanChatMember$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return UnbanChatMember_init(bitMask0, local0, local1, null);
  };
  UnbanChatMember$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), ChatIdentifierSerializer_getInstance()];
  };
  UnbanChatMember$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var UnbanChatMember$$serializer_instance = null;
  function UnbanChatMember$$serializer_getInstance() {
    if (UnbanChatMember$$serializer_instance === null) {
      new UnbanChatMember$$serializer();
    }
    return UnbanChatMember$$serializer_instance;
  }
  function UnbanChatMember_init(seen1, chatId, userId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(UnbanChatMember.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_xox27a$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_j19p1v$_0 = userId;
    return $this;
  }
  UnbanChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnbanChatMember',
    interfaces: [ChatMemberRequest]
  };
  UnbanChatMember.prototype.component1 = function () {
    return this.chatId;
  };
  UnbanChatMember.prototype.component2 = function () {
    return this.userId;
  };
  UnbanChatMember.prototype.copy_oykgti$ = function (chatId, userId) {
    return new UnbanChatMember(chatId === void 0 ? this.chatId : chatId, userId === void 0 ? this.userId : userId);
  };
  UnbanChatMember.prototype.toString = function () {
    return 'UnbanChatMember(chatId=' + Kotlin.toString(this.chatId) + (', userId=' + Kotlin.toString(this.userId)) + ')';
  };
  UnbanChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    return result;
  };
  UnbanChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.userId, other.userId)))));
  };
  function DeleteChatPhoto(chatId) {
    DeleteChatPhoto$Companion_getInstance();
    this.chatId_om69d2$_0 = chatId;
  }
  Object.defineProperty(DeleteChatPhoto.prototype, 'chatId', {
    get: function () {
      return this.chatId_om69d2$_0;
    }
  });
  DeleteChatPhoto.prototype.method = function () {
    return 'deleteChatPhoto';
  };
  Object.defineProperty(DeleteChatPhoto.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(DeleteChatPhoto.prototype, 'requestSerializer', {
    get: function () {
      return DeleteChatPhoto$Companion_getInstance().serializer();
    }
  });
  function DeleteChatPhoto$Companion() {
    DeleteChatPhoto$Companion_instance = this;
  }
  DeleteChatPhoto$Companion.prototype.serializer = function () {
    return DeleteChatPhoto$$serializer_getInstance();
  };
  DeleteChatPhoto$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DeleteChatPhoto$Companion_instance = null;
  function DeleteChatPhoto$Companion_getInstance() {
    if (DeleteChatPhoto$Companion_instance === null) {
      new DeleteChatPhoto$Companion();
    }
    return DeleteChatPhoto$Companion_instance;
  }
  function DeleteChatPhoto$$serializer() {
    this.descriptor_sbcdxi$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.DeleteChatPhoto', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    DeleteChatPhoto$$serializer_instance = this;
  }
  Object.defineProperty(DeleteChatPhoto$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_sbcdxi$_0;
    }
  });
  DeleteChatPhoto$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  DeleteChatPhoto$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return DeleteChatPhoto_init(bitMask0, local0, null);
  };
  DeleteChatPhoto$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance()];
  };
  DeleteChatPhoto$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var DeleteChatPhoto$$serializer_instance = null;
  function DeleteChatPhoto$$serializer_getInstance() {
    if (DeleteChatPhoto$$serializer_instance === null) {
      new DeleteChatPhoto$$serializer();
    }
    return DeleteChatPhoto$$serializer_instance;
  }
  function DeleteChatPhoto_init(seen1, chatId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(DeleteChatPhoto.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_om69d2$_0 = chatId;
    return $this;
  }
  DeleteChatPhoto.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DeleteChatPhoto',
    interfaces: [SimpleRequest, ChatRequest]
  };
  DeleteChatPhoto.prototype.component1 = function () {
    return this.chatId;
  };
  DeleteChatPhoto.prototype.copy_eiloeo$ = function (chatId) {
    return new DeleteChatPhoto(chatId === void 0 ? this.chatId : chatId);
  };
  DeleteChatPhoto.prototype.toString = function () {
    return 'DeleteChatPhoto(chatId=' + Kotlin.toString(this.chatId) + ')';
  };
  DeleteChatPhoto.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    return result;
  };
  DeleteChatPhoto.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.chatId, other.chatId))));
  };
  function PinChatMessage(chatId, messageId, disableNotification) {
    PinChatMessage$Companion_getInstance();
    if (disableNotification === void 0)
      disableNotification = false;
    this.chatId_c5ye3l$_0 = chatId;
    this.messageId_p07d26$_0 = messageId;
    this.disableNotification_vv9jwt$_0 = disableNotification;
  }
  Object.defineProperty(PinChatMessage.prototype, 'chatId', {
    get: function () {
      return this.chatId_c5ye3l$_0;
    }
  });
  Object.defineProperty(PinChatMessage.prototype, 'messageId', {
    get: function () {
      return this.messageId_p07d26$_0;
    }
  });
  Object.defineProperty(PinChatMessage.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_vv9jwt$_0;
    }
  });
  PinChatMessage.prototype.method = function () {
    return 'pinChatMessage';
  };
  Object.defineProperty(PinChatMessage.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(PinChatMessage.prototype, 'requestSerializer', {
    get: function () {
      return PinChatMessage$Companion_getInstance().serializer();
    }
  });
  function PinChatMessage$Companion() {
    PinChatMessage$Companion_instance = this;
  }
  PinChatMessage$Companion.prototype.serializer = function () {
    return PinChatMessage$$serializer_getInstance();
  };
  PinChatMessage$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var PinChatMessage$Companion_instance = null;
  function PinChatMessage$Companion_getInstance() {
    if (PinChatMessage$Companion_instance === null) {
      new PinChatMessage$Companion();
    }
    return PinChatMessage$Companion_instance;
  }
  function PinChatMessage$$serializer() {
    this.descriptor_ckp8b1$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.PinChatMessage', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    PinChatMessage$$serializer_instance = this;
  }
  Object.defineProperty(PinChatMessage$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_ckp8b1$_0;
    }
  });
  PinChatMessage$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.messageId);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 2, obj.disableNotification);
    output.endStructure_qatsm0$(this.descriptor);
  };
  PinChatMessage$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return PinChatMessage_init(bitMask0, local0, local1, local2, null);
  };
  PinChatMessage$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer, internal.BooleanSerializer];
  };
  PinChatMessage$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var PinChatMessage$$serializer_instance = null;
  function PinChatMessage$$serializer_getInstance() {
    if (PinChatMessage$$serializer_instance === null) {
      new PinChatMessage$$serializer();
    }
    return PinChatMessage$$serializer_instance;
  }
  function PinChatMessage_init(seen1, chatId, messageId, disableNotification, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(PinChatMessage.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_c5ye3l$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_p07d26$_0 = messageId;
    if ((seen1 & 4) === 0)
      $this.disableNotification_vv9jwt$_0 = false;
    else
      $this.disableNotification_vv9jwt$_0 = disableNotification;
    return $this;
  }
  PinChatMessage.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PinChatMessage',
    interfaces: [DisableNotification, MessageAction, SimpleRequest, ChatRequest]
  };
  PinChatMessage.prototype.component1 = function () {
    return this.chatId;
  };
  PinChatMessage.prototype.component2 = function () {
    return this.messageId;
  };
  PinChatMessage.prototype.component3 = function () {
    return this.disableNotification;
  };
  PinChatMessage.prototype.copy_p4ujzu$ = function (chatId, messageId, disableNotification) {
    return new PinChatMessage(chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId, disableNotification === void 0 ? this.disableNotification : disableNotification);
  };
  PinChatMessage.prototype.toString = function () {
    return 'PinChatMessage(chatId=' + Kotlin.toString(this.chatId) + (', messageId=' + Kotlin.toString(this.messageId)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + ')';
  };
  PinChatMessage.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    return result;
  };
  PinChatMessage.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId) && Kotlin.equals(this.disableNotification, other.disableNotification)))));
  };
  function SetChatDescription(chatId, description) {
    SetChatDescription$Companion_getInstance();
    this.chatId_jbmwo9$_0 = chatId;
    this.description = description;
    if (!chatDescriptionLength.contains_mef7kx$(this.description.length)) {
      throw IllegalArgumentException_init('Chat description must be in ' + chatDescriptionLength + ' range');
    }
  }
  Object.defineProperty(SetChatDescription.prototype, 'chatId', {
    get: function () {
      return this.chatId_jbmwo9$_0;
    }
  });
  SetChatDescription.prototype.method = function () {
    return 'setChatDescription';
  };
  Object.defineProperty(SetChatDescription.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(SetChatDescription.prototype, 'requestSerializer', {
    get: function () {
      return SetChatDescription$Companion_getInstance().serializer();
    }
  });
  function SetChatDescription$Companion() {
    SetChatDescription$Companion_instance = this;
  }
  SetChatDescription$Companion.prototype.serializer = function () {
    return SetChatDescription$$serializer_getInstance();
  };
  SetChatDescription$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SetChatDescription$Companion_instance = null;
  function SetChatDescription$Companion_getInstance() {
    if (SetChatDescription$Companion_instance === null) {
      new SetChatDescription$Companion();
    }
    return SetChatDescription$Companion_instance;
  }
  function SetChatDescription$$serializer() {
    this.descriptor_pmkxij$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.SetChatDescription', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('description', false);
    SetChatDescription$$serializer_instance = this;
  }
  Object.defineProperty(SetChatDescription$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_pmkxij$_0;
    }
  });
  SetChatDescription$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.description);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SetChatDescription$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SetChatDescription_init(bitMask0, local0, local1, null);
  };
  SetChatDescription$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer];
  };
  SetChatDescription$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SetChatDescription$$serializer_instance = null;
  function SetChatDescription$$serializer_getInstance() {
    if (SetChatDescription$$serializer_instance === null) {
      new SetChatDescription$$serializer();
    }
    return SetChatDescription$$serializer_instance;
  }
  function SetChatDescription_init(seen1, chatId, description, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SetChatDescription.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_jbmwo9$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('description');
    else
      $this.description = description;
    if (!chatDescriptionLength.contains_mef7kx$($this.description.length)) {
      throw IllegalArgumentException_init('Chat description must be in ' + chatDescriptionLength + ' range');
    }
    return $this;
  }
  SetChatDescription.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SetChatDescription',
    interfaces: [SimpleRequest, ChatRequest]
  };
  SetChatDescription.prototype.component1 = function () {
    return this.chatId;
  };
  SetChatDescription.prototype.component2 = function () {
    return this.description;
  };
  SetChatDescription.prototype.copy_qa97ia$ = function (chatId, description) {
    return new SetChatDescription(chatId === void 0 ? this.chatId : chatId, description === void 0 ? this.description : description);
  };
  SetChatDescription.prototype.toString = function () {
    return 'SetChatDescription(chatId=' + Kotlin.toString(this.chatId) + (', description=' + Kotlin.toString(this.description)) + ')';
  };
  SetChatDescription.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.description) | 0;
    return result;
  };
  SetChatDescription.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.description, other.description)))));
  };
  function SetChatPermissions(chatId, permissions) {
    SetChatPermissions$Companion_getInstance();
    this.chatId_28npn3$_0 = chatId;
    this.permissions = permissions;
  }
  Object.defineProperty(SetChatPermissions.prototype, 'chatId', {
    get: function () {
      return this.chatId_28npn3$_0;
    }
  });
  SetChatPermissions.prototype.method = function () {
    return 'setChatPermissions';
  };
  Object.defineProperty(SetChatPermissions.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(SetChatPermissions.prototype, 'requestSerializer', {
    get: function () {
      return SetChatPermissions$Companion_getInstance().serializer();
    }
  });
  function SetChatPermissions$Companion() {
    SetChatPermissions$Companion_instance = this;
  }
  SetChatPermissions$Companion.prototype.serializer = function () {
    return SetChatPermissions$$serializer_getInstance();
  };
  SetChatPermissions$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SetChatPermissions$Companion_instance = null;
  function SetChatPermissions$Companion_getInstance() {
    if (SetChatPermissions$Companion_instance === null) {
      new SetChatPermissions$Companion();
    }
    return SetChatPermissions$Companion_instance;
  }
  function SetChatPermissions$$serializer() {
    this.descriptor_pzfzfn$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.SetChatPermissions', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('permissions', false);
    SetChatPermissions$$serializer_instance = this;
  }
  Object.defineProperty(SetChatPermissions$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_pzfzfn$_0;
    }
  });
  SetChatPermissions$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, ChatPermissions$$serializer_getInstance(), obj.permissions);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SetChatPermissions$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, ChatPermissions$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, ChatPermissions$$serializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SetChatPermissions_init(bitMask0, local0, local1, null);
  };
  SetChatPermissions$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), ChatPermissions$$serializer_getInstance()];
  };
  SetChatPermissions$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SetChatPermissions$$serializer_instance = null;
  function SetChatPermissions$$serializer_getInstance() {
    if (SetChatPermissions$$serializer_instance === null) {
      new SetChatPermissions$$serializer();
    }
    return SetChatPermissions$$serializer_instance;
  }
  function SetChatPermissions_init(seen1, chatId, permissions, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SetChatPermissions.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_28npn3$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('permissions');
    else
      $this.permissions = permissions;
    return $this;
  }
  SetChatPermissions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SetChatPermissions',
    interfaces: [SimpleRequest, ChatRequest]
  };
  SetChatPermissions.prototype.component1 = function () {
    return this.chatId;
  };
  SetChatPermissions.prototype.component2 = function () {
    return this.permissions;
  };
  SetChatPermissions.prototype.copy_xeysnd$ = function (chatId, permissions) {
    return new SetChatPermissions(chatId === void 0 ? this.chatId : chatId, permissions === void 0 ? this.permissions : permissions);
  };
  SetChatPermissions.prototype.toString = function () {
    return 'SetChatPermissions(chatId=' + Kotlin.toString(this.chatId) + (', permissions=' + Kotlin.toString(this.permissions)) + ')';
  };
  SetChatPermissions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.permissions) | 0;
    return result;
  };
  SetChatPermissions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.permissions, other.permissions)))));
  };
  function SetChatPhoto(chatId, photo) {
    SetChatPhoto$Companion_getInstance();
    if (photo === void 0) {
      throw IllegalArgumentException_init("Unfortunately, this type of objects can't be parsed automatically");
    }
    this.chatId_uziodd$_0 = chatId;
    this.photo = photo;
    this.mediaMap_79aop2$_0 = mapOf(to(photoField, this.photo));
    var serializer = SetChatPhoto$Companion_getInstance().serializer();
    this.paramsJson_mnghhg$_0 = Json.Companion.nonstrict.toJson_tf03ej$(serializer, this).jsonObject;
  }
  Object.defineProperty(SetChatPhoto.prototype, 'chatId', {
    get: function () {
      return this.chatId_uziodd$_0;
    }
  });
  SetChatPhoto.prototype.method = function () {
    return 'setChatPhoto';
  };
  Object.defineProperty(SetChatPhoto.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(SetChatPhoto.prototype, 'mediaMap', {
    get: function () {
      return this.mediaMap_79aop2$_0;
    }
  });
  Object.defineProperty(SetChatPhoto.prototype, 'paramsJson', {
    get: function () {
      return this.paramsJson_mnghhg$_0;
    }
  });
  function SetChatPhoto$Companion() {
    SetChatPhoto$Companion_instance = this;
  }
  SetChatPhoto$Companion.prototype.serializer = function () {
    return SetChatPhoto$$serializer_getInstance();
  };
  SetChatPhoto$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SetChatPhoto$Companion_instance = null;
  function SetChatPhoto$Companion_getInstance() {
    if (SetChatPhoto$Companion_instance === null) {
      new SetChatPhoto$Companion();
    }
    return SetChatPhoto$Companion_instance;
  }
  function SetChatPhoto$$serializer() {
    this.descriptor_viz2q3$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.SetChatPhoto', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('photo', true);
    this.descriptor.addElement_ivxn3r$('mediaMap', true);
    this.descriptor.addElement_ivxn3r$('paramsJson', true);
    SetChatPhoto$$serializer_instance = this;
  }
  Object.defineProperty(SetChatPhoto$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_viz2q3$_0;
    }
  });
  SetChatPhoto$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    throw IllegalArgumentException_init("Unfortunately, this type of objects can't be parsed automatically");
  };
  SetChatPhoto$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, InputFileSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, InputFileSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 2, new LinkedHashMapSerializer(internal.StringSerializer, InputFileSerializer_getInstance())) : input.updateSerializableElement_ehubvl$(this.descriptor, 2, new LinkedHashMapSerializer(internal.StringSerializer, InputFileSerializer_getInstance()), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 3, json.JsonObjectSerializer) : input.updateSerializableElement_ehubvl$(this.descriptor, 3, json.JsonObjectSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SetChatPhoto_init(bitMask0, local0, local1, local2, local3, null);
  };
  SetChatPhoto$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), InputFileSerializer_getInstance(), new LinkedHashMapSerializer(internal.StringSerializer, InputFileSerializer_getInstance()), json.JsonObjectSerializer];
  };
  SetChatPhoto$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SetChatPhoto$$serializer_instance = null;
  function SetChatPhoto$$serializer_getInstance() {
    if (SetChatPhoto$$serializer_instance === null) {
      new SetChatPhoto$$serializer();
    }
    return SetChatPhoto$$serializer_instance;
  }
  function SetChatPhoto_init(seen1, chatId, photo, mediaMap, paramsJson, serializationConstructorMarker) {
    throw IllegalArgumentException_init("Unfortunately, this type of objects can't be parsed automatically");
  }
  SetChatPhoto.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SetChatPhoto',
    interfaces: [MultipartRequest, ChatRequest]
  };
  SetChatPhoto.prototype.component1 = function () {
    return this.chatId;
  };
  SetChatPhoto.prototype.component2 = function () {
    return this.photo;
  };
  SetChatPhoto.prototype.copy_wp94n3$ = function (chatId, photo) {
    return new SetChatPhoto(chatId === void 0 ? this.chatId : chatId, photo === void 0 ? this.photo : photo);
  };
  SetChatPhoto.prototype.toString = function () {
    return 'SetChatPhoto(chatId=' + Kotlin.toString(this.chatId) + (', photo=' + Kotlin.toString(this.photo)) + ')';
  };
  SetChatPhoto.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.photo) | 0;
    return result;
  };
  SetChatPhoto.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.photo, other.photo)))));
  };
  function SetChatTitle(chatId, title) {
    SetChatTitle$Companion_getInstance();
    this.chatId_dzt8sb$_0 = chatId;
    this.title = title;
    if (!chatTitleLength.contains_mef7kx$(this.title.length)) {
      throw IllegalArgumentException_init('Chat title must be in ' + chatTitleLength + ' range');
    }
  }
  Object.defineProperty(SetChatTitle.prototype, 'chatId', {
    get: function () {
      return this.chatId_dzt8sb$_0;
    }
  });
  SetChatTitle.prototype.method = function () {
    return 'setChatTitle';
  };
  Object.defineProperty(SetChatTitle.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(SetChatTitle.prototype, 'requestSerializer', {
    get: function () {
      return SetChatTitle$Companion_getInstance().serializer();
    }
  });
  function SetChatTitle$Companion() {
    SetChatTitle$Companion_instance = this;
  }
  SetChatTitle$Companion.prototype.serializer = function () {
    return SetChatTitle$$serializer_getInstance();
  };
  SetChatTitle$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SetChatTitle$Companion_instance = null;
  function SetChatTitle$Companion_getInstance() {
    if (SetChatTitle$Companion_instance === null) {
      new SetChatTitle$Companion();
    }
    return SetChatTitle$Companion_instance;
  }
  function SetChatTitle$$serializer() {
    this.descriptor_53u43z$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.SetChatTitle', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('title', false);
    SetChatTitle$$serializer_instance = this;
  }
  Object.defineProperty(SetChatTitle$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_53u43z$_0;
    }
  });
  SetChatTitle$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.title);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SetChatTitle$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SetChatTitle_init(bitMask0, local0, local1, null);
  };
  SetChatTitle$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer];
  };
  SetChatTitle$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SetChatTitle$$serializer_instance = null;
  function SetChatTitle$$serializer_getInstance() {
    if (SetChatTitle$$serializer_instance === null) {
      new SetChatTitle$$serializer();
    }
    return SetChatTitle$$serializer_instance;
  }
  function SetChatTitle_init(seen1, chatId, title, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SetChatTitle.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_dzt8sb$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('title');
    else
      $this.title = title;
    if (!chatTitleLength.contains_mef7kx$($this.title.length)) {
      throw IllegalArgumentException_init('Chat title must be in ' + chatTitleLength + ' range');
    }
    return $this;
  }
  SetChatTitle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SetChatTitle',
    interfaces: [SimpleRequest, ChatRequest]
  };
  SetChatTitle.prototype.component1 = function () {
    return this.chatId;
  };
  SetChatTitle.prototype.component2 = function () {
    return this.title;
  };
  SetChatTitle.prototype.copy_qa97ia$ = function (chatId, title) {
    return new SetChatTitle(chatId === void 0 ? this.chatId : chatId, title === void 0 ? this.title : title);
  };
  SetChatTitle.prototype.toString = function () {
    return 'SetChatTitle(chatId=' + Kotlin.toString(this.chatId) + (', title=' + Kotlin.toString(this.title)) + ')';
  };
  SetChatTitle.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.title) | 0;
    return result;
  };
  SetChatTitle.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.title, other.title)))));
  };
  function UnpinChatMessage(chatId) {
    UnpinChatMessage$Companion_getInstance();
    this.chatId_19zv0m$_0 = chatId;
  }
  Object.defineProperty(UnpinChatMessage.prototype, 'chatId', {
    get: function () {
      return this.chatId_19zv0m$_0;
    }
  });
  UnpinChatMessage.prototype.method = function () {
    return 'unpinChatMessage';
  };
  Object.defineProperty(UnpinChatMessage.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(UnpinChatMessage.prototype, 'requestSerializer', {
    get: function () {
      return UnpinChatMessage$Companion_getInstance().serializer();
    }
  });
  function UnpinChatMessage$Companion() {
    UnpinChatMessage$Companion_instance = this;
  }
  UnpinChatMessage$Companion.prototype.serializer = function () {
    return UnpinChatMessage$$serializer_getInstance();
  };
  UnpinChatMessage$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var UnpinChatMessage$Companion_instance = null;
  function UnpinChatMessage$Companion_getInstance() {
    if (UnpinChatMessage$Companion_instance === null) {
      new UnpinChatMessage$Companion();
    }
    return UnpinChatMessage$Companion_instance;
  }
  function UnpinChatMessage$$serializer() {
    this.descriptor_6dh6zq$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.modify.UnpinChatMessage', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    UnpinChatMessage$$serializer_instance = this;
  }
  Object.defineProperty(UnpinChatMessage$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_6dh6zq$_0;
    }
  });
  UnpinChatMessage$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  UnpinChatMessage$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return UnpinChatMessage_init(bitMask0, local0, null);
  };
  UnpinChatMessage$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance()];
  };
  UnpinChatMessage$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var UnpinChatMessage$$serializer_instance = null;
  function UnpinChatMessage$$serializer_getInstance() {
    if (UnpinChatMessage$$serializer_instance === null) {
      new UnpinChatMessage$$serializer();
    }
    return UnpinChatMessage$$serializer_instance;
  }
  function UnpinChatMessage_init(seen1, chatId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(UnpinChatMessage.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_19zv0m$_0 = chatId;
    return $this;
  }
  UnpinChatMessage.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UnpinChatMessage',
    interfaces: [SimpleRequest, ChatRequest]
  };
  UnpinChatMessage.prototype.component1 = function () {
    return this.chatId;
  };
  UnpinChatMessage.prototype.copy_eiloeo$ = function (chatId) {
    return new UnpinChatMessage(chatId === void 0 ? this.chatId : chatId);
  };
  UnpinChatMessage.prototype.toString = function () {
    return 'UnpinChatMessage(chatId=' + Kotlin.toString(this.chatId) + ')';
  };
  UnpinChatMessage.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    return result;
  };
  UnpinChatMessage.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.chatId, other.chatId))));
  };
  function DeleteChatStickerSet(chatId) {
    DeleteChatStickerSet$Companion_getInstance();
    this.chatId_q9s9yr$_0 = chatId;
  }
  Object.defineProperty(DeleteChatStickerSet.prototype, 'chatId', {
    get: function () {
      return this.chatId_q9s9yr$_0;
    }
  });
  DeleteChatStickerSet.prototype.method = function () {
    return 'deleteChatStickerSet';
  };
  Object.defineProperty(DeleteChatStickerSet.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(DeleteChatStickerSet.prototype, 'requestSerializer', {
    get: function () {
      return DeleteChatStickerSet$Companion_getInstance().serializer();
    }
  });
  function DeleteChatStickerSet$Companion() {
    DeleteChatStickerSet$Companion_instance = this;
  }
  DeleteChatStickerSet$Companion.prototype.serializer = function () {
    return DeleteChatStickerSet$$serializer_getInstance();
  };
  DeleteChatStickerSet$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DeleteChatStickerSet$Companion_instance = null;
  function DeleteChatStickerSet$Companion_getInstance() {
    if (DeleteChatStickerSet$Companion_instance === null) {
      new DeleteChatStickerSet$Companion();
    }
    return DeleteChatStickerSet$Companion_instance;
  }
  function DeleteChatStickerSet$$serializer() {
    this.descriptor_jsmtr5$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.stickers.DeleteChatStickerSet', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    DeleteChatStickerSet$$serializer_instance = this;
  }
  Object.defineProperty(DeleteChatStickerSet$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_jsmtr5$_0;
    }
  });
  DeleteChatStickerSet$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  DeleteChatStickerSet$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return DeleteChatStickerSet_init(bitMask0, local0, null);
  };
  DeleteChatStickerSet$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance()];
  };
  DeleteChatStickerSet$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var DeleteChatStickerSet$$serializer_instance = null;
  function DeleteChatStickerSet$$serializer_getInstance() {
    if (DeleteChatStickerSet$$serializer_instance === null) {
      new DeleteChatStickerSet$$serializer();
    }
    return DeleteChatStickerSet$$serializer_instance;
  }
  function DeleteChatStickerSet_init(seen1, chatId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(DeleteChatStickerSet.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_q9s9yr$_0 = chatId;
    return $this;
  }
  DeleteChatStickerSet.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DeleteChatStickerSet',
    interfaces: [SimpleRequest, ChatRequest]
  };
  DeleteChatStickerSet.prototype.component1 = function () {
    return this.chatId;
  };
  DeleteChatStickerSet.prototype.copy_eiloeo$ = function (chatId) {
    return new DeleteChatStickerSet(chatId === void 0 ? this.chatId : chatId);
  };
  DeleteChatStickerSet.prototype.toString = function () {
    return 'DeleteChatStickerSet(chatId=' + Kotlin.toString(this.chatId) + ')';
  };
  DeleteChatStickerSet.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    return result;
  };
  DeleteChatStickerSet.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.chatId, other.chatId))));
  };
  function SetChatStickerSet(chatId, stickerSetName) {
    SetChatStickerSet$Companion_getInstance();
    this.chatId_o2v8ai$_0 = chatId;
    this.stickerSetName = stickerSetName;
  }
  Object.defineProperty(SetChatStickerSet.prototype, 'chatId', {
    get: function () {
      return this.chatId_o2v8ai$_0;
    }
  });
  SetChatStickerSet.prototype.method = function () {
    return 'setChatStickerSet';
  };
  Object.defineProperty(SetChatStickerSet.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(SetChatStickerSet.prototype, 'requestSerializer', {
    get: function () {
      return SetChatStickerSet$Companion_getInstance().serializer();
    }
  });
  function SetChatStickerSet$Companion() {
    SetChatStickerSet$Companion_instance = this;
  }
  SetChatStickerSet$Companion.prototype.serializer = function () {
    return SetChatStickerSet$$serializer_getInstance();
  };
  SetChatStickerSet$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SetChatStickerSet$Companion_instance = null;
  function SetChatStickerSet$Companion_getInstance() {
    if (SetChatStickerSet$Companion_instance === null) {
      new SetChatStickerSet$Companion();
    }
    return SetChatStickerSet$Companion_instance;
  }
  function SetChatStickerSet$$serializer() {
    this.descriptor_m7kw26$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.chat.stickers.SetChatStickerSet', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('set_name', false);
    SetChatStickerSet$$serializer_instance = this;
  }
  Object.defineProperty(SetChatStickerSet$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_m7kw26$_0;
    }
  });
  SetChatStickerSet$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.stickerSetName);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SetChatStickerSet$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SetChatStickerSet_init(bitMask0, local0, local1, null);
  };
  SetChatStickerSet$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer];
  };
  SetChatStickerSet$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SetChatStickerSet$$serializer_instance = null;
  function SetChatStickerSet$$serializer_getInstance() {
    if (SetChatStickerSet$$serializer_instance === null) {
      new SetChatStickerSet$$serializer();
    }
    return SetChatStickerSet$$serializer_instance;
  }
  function SetChatStickerSet_init(seen1, chatId, stickerSetName, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SetChatStickerSet.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_o2v8ai$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('set_name');
    else
      $this.stickerSetName = stickerSetName;
    return $this;
  }
  SetChatStickerSet.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SetChatStickerSet',
    interfaces: [SimpleRequest, ChatRequest]
  };
  SetChatStickerSet.prototype.component1 = function () {
    return this.chatId;
  };
  SetChatStickerSet.prototype.component2 = function () {
    return this.stickerSetName;
  };
  SetChatStickerSet.prototype.copy_qa97ia$ = function (chatId, stickerSetName) {
    return new SetChatStickerSet(chatId === void 0 ? this.chatId : chatId, stickerSetName === void 0 ? this.stickerSetName : stickerSetName);
  };
  SetChatStickerSet.prototype.toString = function () {
    return 'SetChatStickerSet(chatId=' + Kotlin.toString(this.chatId) + (', stickerSetName=' + Kotlin.toString(this.stickerSetName)) + ')';
  };
  SetChatStickerSet.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.stickerSetName) | 0;
    return result;
  };
  SetChatStickerSet.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.stickerSetName, other.stickerSetName)))));
  };
  function CommonMultipartFileRequest(data, mediaMap) {
    this.data = data;
    this.mediaMap_hqefbt$_0 = mediaMap;
    var $receiver = this.data;
    var tmp$;
    var serializer = Kotlin.isType(tmp$ = $receiver.requestSerializer, SerializationStrategy) ? tmp$ : throwCCE();
    this.paramsJson_v4qctf$_0 = withoutNulls_0(Json.Companion.nonstrict.toJson_tf03ej$(serializer, $receiver).jsonObject);
  }
  Object.defineProperty(CommonMultipartFileRequest.prototype, 'mediaMap', {
    get: function () {
      return this.mediaMap_hqefbt$_0;
    }
  });
  Object.defineProperty(CommonMultipartFileRequest.prototype, 'paramsJson', {
    get: function () {
      return this.paramsJson_v4qctf$_0;
    }
  });
  Object.defineProperty(CommonMultipartFileRequest.prototype, 'resultDeserializer', {
    get: function () {
      return this.data.resultDeserializer;
    }
  });
  CommonMultipartFileRequest.prototype.method = function () {
    return this.data.method();
  };
  CommonMultipartFileRequest.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CommonMultipartFileRequest',
    interfaces: [MultipartRequest, Request]
  };
  CommonMultipartFileRequest.prototype.component1 = function () {
    return this.data;
  };
  CommonMultipartFileRequest.prototype.component2 = function () {
    return this.mediaMap;
  };
  CommonMultipartFileRequest.prototype.copy_98kljp$ = function (data, mediaMap) {
    return new CommonMultipartFileRequest(data === void 0 ? this.data : data, mediaMap === void 0 ? this.mediaMap : mediaMap);
  };
  CommonMultipartFileRequest.prototype.toString = function () {
    return 'CommonMultipartFileRequest(data=' + Kotlin.toString(this.data) + (', mediaMap=' + Kotlin.toString(this.mediaMap)) + ')';
  };
  CommonMultipartFileRequest.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.data) | 0;
    result = result * 31 + Kotlin.hashCode(this.mediaMap) | 0;
    return result;
  };
  CommonMultipartFileRequest.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.data, other.data) && Kotlin.equals(this.mediaMap, other.mediaMap)))));
  };
  var commonResultDeserializer;
  function EditChatMessageLiveLocation(chatId, messageId, latitude, longitude, replyMarkup) {
    EditChatMessageLiveLocation$Companion_getInstance();
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_qjgmwq$_0 = chatId;
    this.messageId_lxhhlz$_0 = messageId;
    this.latitude_b7batp$_0 = latitude;
    this.longitude_5fc1sc$_0 = longitude;
    this.replyMarkup_8f2wnr$_0 = replyMarkup;
  }
  Object.defineProperty(EditChatMessageLiveLocation.prototype, 'chatId', {
    get: function () {
      return this.chatId_qjgmwq$_0;
    }
  });
  Object.defineProperty(EditChatMessageLiveLocation.prototype, 'messageId', {
    get: function () {
      return this.messageId_lxhhlz$_0;
    }
  });
  Object.defineProperty(EditChatMessageLiveLocation.prototype, 'latitude', {
    get: function () {
      return this.latitude_b7batp$_0;
    }
  });
  Object.defineProperty(EditChatMessageLiveLocation.prototype, 'longitude', {
    get: function () {
      return this.longitude_5fc1sc$_0;
    }
  });
  Object.defineProperty(EditChatMessageLiveLocation.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_8f2wnr$_0;
    }
  });
  EditChatMessageLiveLocation.prototype.method = function () {
    return 'editMessageLiveLocation';
  };
  Object.defineProperty(EditChatMessageLiveLocation.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer;
    }
  });
  Object.defineProperty(EditChatMessageLiveLocation.prototype, 'requestSerializer', {
    get: function () {
      return EditChatMessageLiveLocation$Companion_getInstance().serializer();
    }
  });
  function EditChatMessageLiveLocation$Companion() {
    EditChatMessageLiveLocation$Companion_instance = this;
  }
  EditChatMessageLiveLocation$Companion.prototype.serializer = function () {
    return EditChatMessageLiveLocation$$serializer_getInstance();
  };
  EditChatMessageLiveLocation$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EditChatMessageLiveLocation$Companion_instance = null;
  function EditChatMessageLiveLocation$Companion_getInstance() {
    if (EditChatMessageLiveLocation$Companion_instance === null) {
      new EditChatMessageLiveLocation$Companion();
    }
    return EditChatMessageLiveLocation$Companion_instance;
  }
  function EditChatMessageLiveLocation$$serializer() {
    this.descriptor_7bqw6q$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.LiveLocation.EditChatMessageLiveLocation', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    this.descriptor.addElement_ivxn3r$('latitude', false);
    this.descriptor.addElement_ivxn3r$('longitude', false);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    EditChatMessageLiveLocation$$serializer_instance = this;
  }
  Object.defineProperty(EditChatMessageLiveLocation$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_7bqw6q$_0;
    }
  });
  EditChatMessageLiveLocation$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.messageId);
    output.encodeDoubleElement_imzr5k$(this.descriptor, 2, obj.latitude);
    output.encodeDoubleElement_imzr5k$(this.descriptor, 3, obj.longitude);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EditChatMessageLiveLocation$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeDoubleElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeDoubleElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EditChatMessageLiveLocation_init(bitMask0, local0, local1, local2, local3, local4, null);
  };
  EditChatMessageLiveLocation$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer, internal.DoubleSerializer, internal.DoubleSerializer, new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  EditChatMessageLiveLocation$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EditChatMessageLiveLocation$$serializer_instance = null;
  function EditChatMessageLiveLocation$$serializer_getInstance() {
    if (EditChatMessageLiveLocation$$serializer_instance === null) {
      new EditChatMessageLiveLocation$$serializer();
    }
    return EditChatMessageLiveLocation$$serializer_instance;
  }
  function EditChatMessageLiveLocation_init(seen1, chatId, messageId, latitude, longitude, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EditChatMessageLiveLocation.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_qjgmwq$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_lxhhlz$_0 = messageId;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('latitude');
    else
      $this.latitude_b7batp$_0 = latitude;
    if ((seen1 & 8) === 0)
      throw new MissingFieldException('longitude');
    else
      $this.longitude_5fc1sc$_0 = longitude;
    if ((seen1 & 16) === 0)
      $this.replyMarkup_8f2wnr$_0 = null;
    else
      $this.replyMarkup_8f2wnr$_0 = replyMarkup;
    return $this;
  }
  EditChatMessageLiveLocation.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EditChatMessageLiveLocation',
    interfaces: [EditLocationMessage, EditReplyMessage, EditChatMessage]
  };
  EditChatMessageLiveLocation.prototype.component1 = function () {
    return this.chatId;
  };
  EditChatMessageLiveLocation.prototype.component2 = function () {
    return this.messageId;
  };
  EditChatMessageLiveLocation.prototype.component3 = function () {
    return this.latitude;
  };
  EditChatMessageLiveLocation.prototype.component4 = function () {
    return this.longitude;
  };
  EditChatMessageLiveLocation.prototype.component5 = function () {
    return this.replyMarkup;
  };
  EditChatMessageLiveLocation.prototype.copy_lek72i$ = function (chatId, messageId, latitude, longitude, replyMarkup) {
    return new EditChatMessageLiveLocation(chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId, latitude === void 0 ? this.latitude : latitude, longitude === void 0 ? this.longitude : longitude, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  EditChatMessageLiveLocation.prototype.toString = function () {
    return 'EditChatMessageLiveLocation(chatId=' + Kotlin.toString(this.chatId) + (', messageId=' + Kotlin.toString(this.messageId)) + (', latitude=' + Kotlin.toString(this.latitude)) + (', longitude=' + Kotlin.toString(this.longitude)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  EditChatMessageLiveLocation.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.latitude) | 0;
    result = result * 31 + Kotlin.hashCode(this.longitude) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  EditChatMessageLiveLocation.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId) && Kotlin.equals(this.latitude, other.latitude) && Kotlin.equals(this.longitude, other.longitude) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function EditInlineMessageLiveLocation(inlineMessageId, latitude, longitude, replyMarkup) {
    EditInlineMessageLiveLocation$Companion_getInstance();
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.inlineMessageId_dch9rh$_0 = inlineMessageId;
    this.latitude_9xadgs$_0 = latitude;
    this.longitude_y7goc3$_0 = longitude;
    this.replyMarkup_nfitsm$_0 = replyMarkup;
  }
  Object.defineProperty(EditInlineMessageLiveLocation.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_dch9rh$_0;
    }
  });
  Object.defineProperty(EditInlineMessageLiveLocation.prototype, 'latitude', {
    get: function () {
      return this.latitude_9xadgs$_0;
    }
  });
  Object.defineProperty(EditInlineMessageLiveLocation.prototype, 'longitude', {
    get: function () {
      return this.longitude_y7goc3$_0;
    }
  });
  Object.defineProperty(EditInlineMessageLiveLocation.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_nfitsm$_0;
    }
  });
  EditInlineMessageLiveLocation.prototype.method = function () {
    return 'editMessageLiveLocation';
  };
  Object.defineProperty(EditInlineMessageLiveLocation.prototype, 'requestSerializer', {
    get: function () {
      return EditInlineMessageLiveLocation$Companion_getInstance().serializer();
    }
  });
  function EditInlineMessageLiveLocation$Companion() {
    EditInlineMessageLiveLocation$Companion_instance = this;
  }
  EditInlineMessageLiveLocation$Companion.prototype.serializer = function () {
    return EditInlineMessageLiveLocation$$serializer_getInstance();
  };
  EditInlineMessageLiveLocation$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EditInlineMessageLiveLocation$Companion_instance = null;
  function EditInlineMessageLiveLocation$Companion_getInstance() {
    if (EditInlineMessageLiveLocation$Companion_instance === null) {
      new EditInlineMessageLiveLocation$Companion();
    }
    return EditInlineMessageLiveLocation$Companion_instance;
  }
  function EditInlineMessageLiveLocation$$serializer() {
    this.descriptor_f8u3wx$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.LiveLocation.EditInlineMessageLiveLocation', this);
    this.descriptor.addElement_ivxn3r$('inline_message_id', false);
    this.descriptor.addElement_ivxn3r$('latitude', false);
    this.descriptor.addElement_ivxn3r$('longitude', false);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    EditInlineMessageLiveLocation$$serializer_instance = this;
  }
  Object.defineProperty(EditInlineMessageLiveLocation$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_f8u3wx$_0;
    }
  });
  EditInlineMessageLiveLocation$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.inlineMessageId);
    output.encodeDoubleElement_imzr5k$(this.descriptor, 1, obj.latitude);
    output.encodeDoubleElement_imzr5k$(this.descriptor, 2, obj.longitude);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EditInlineMessageLiveLocation$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeDoubleElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeDoubleElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EditInlineMessageLiveLocation_init(bitMask0, local0, local1, local2, local3, null);
  };
  EditInlineMessageLiveLocation$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.DoubleSerializer, internal.DoubleSerializer, new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  EditInlineMessageLiveLocation$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EditInlineMessageLiveLocation$$serializer_instance = null;
  function EditInlineMessageLiveLocation$$serializer_getInstance() {
    if (EditInlineMessageLiveLocation$$serializer_instance === null) {
      new EditInlineMessageLiveLocation$$serializer();
    }
    return EditInlineMessageLiveLocation$$serializer_instance;
  }
  function EditInlineMessageLiveLocation_init(seen1, inlineMessageId, latitude, longitude, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EditInlineMessageLiveLocation.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('inline_message_id');
    else
      $this.inlineMessageId_dch9rh$_0 = inlineMessageId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('latitude');
    else
      $this.latitude_9xadgs$_0 = latitude;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('longitude');
    else
      $this.longitude_y7goc3$_0 = longitude;
    if ((seen1 & 8) === 0)
      $this.replyMarkup_nfitsm$_0 = null;
    else
      $this.replyMarkup_nfitsm$_0 = replyMarkup;
    return $this;
  }
  EditInlineMessageLiveLocation.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EditInlineMessageLiveLocation',
    interfaces: [EditLocationMessage, EditReplyMessage, EditInlineMessage]
  };
  EditInlineMessageLiveLocation.prototype.component1 = function () {
    return this.inlineMessageId;
  };
  EditInlineMessageLiveLocation.prototype.component2 = function () {
    return this.latitude;
  };
  EditInlineMessageLiveLocation.prototype.component3 = function () {
    return this.longitude;
  };
  EditInlineMessageLiveLocation.prototype.component4 = function () {
    return this.replyMarkup;
  };
  EditInlineMessageLiveLocation.prototype.copy_13n3uj$ = function (inlineMessageId, latitude, longitude, replyMarkup) {
    return new EditInlineMessageLiveLocation(inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, latitude === void 0 ? this.latitude : latitude, longitude === void 0 ? this.longitude : longitude, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  EditInlineMessageLiveLocation.prototype.toString = function () {
    return 'EditInlineMessageLiveLocation(inlineMessageId=' + Kotlin.toString(this.inlineMessageId) + (', latitude=' + Kotlin.toString(this.latitude)) + (', longitude=' + Kotlin.toString(this.longitude)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  EditInlineMessageLiveLocation.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.latitude) | 0;
    result = result * 31 + Kotlin.hashCode(this.longitude) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  EditInlineMessageLiveLocation.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.latitude, other.latitude) && Kotlin.equals(this.longitude, other.longitude) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  var commonResultDeserializer_0;
  function StopChatMessageLiveLocation(chatId, messageId, replyMarkup) {
    StopChatMessageLiveLocation$Companion_getInstance();
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_7mtgqa$_0 = chatId;
    this.messageId_pjlr4h$_0 = messageId;
    this.replyMarkup_cy6141$_0 = replyMarkup;
  }
  Object.defineProperty(StopChatMessageLiveLocation.prototype, 'chatId', {
    get: function () {
      return this.chatId_7mtgqa$_0;
    }
  });
  Object.defineProperty(StopChatMessageLiveLocation.prototype, 'messageId', {
    get: function () {
      return this.messageId_pjlr4h$_0;
    }
  });
  Object.defineProperty(StopChatMessageLiveLocation.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_cy6141$_0;
    }
  });
  StopChatMessageLiveLocation.prototype.method = function () {
    return 'stopMessageLiveLocation';
  };
  Object.defineProperty(StopChatMessageLiveLocation.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_0;
    }
  });
  Object.defineProperty(StopChatMessageLiveLocation.prototype, 'requestSerializer', {
    get: function () {
      return StopChatMessageLiveLocation$Companion_getInstance().serializer();
    }
  });
  function StopChatMessageLiveLocation$Companion() {
    StopChatMessageLiveLocation$Companion_instance = this;
  }
  StopChatMessageLiveLocation$Companion.prototype.serializer = function () {
    return StopChatMessageLiveLocation$$serializer_getInstance();
  };
  StopChatMessageLiveLocation$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var StopChatMessageLiveLocation$Companion_instance = null;
  function StopChatMessageLiveLocation$Companion_getInstance() {
    if (StopChatMessageLiveLocation$Companion_instance === null) {
      new StopChatMessageLiveLocation$Companion();
    }
    return StopChatMessageLiveLocation$Companion_instance;
  }
  function StopChatMessageLiveLocation$$serializer() {
    this.descriptor_x7vk6$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.LiveLocation.StopChatMessageLiveLocation', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    StopChatMessageLiveLocation$$serializer_instance = this;
  }
  Object.defineProperty(StopChatMessageLiveLocation$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_x7vk6$_0;
    }
  });
  StopChatMessageLiveLocation$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.messageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  StopChatMessageLiveLocation$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return StopChatMessageLiveLocation_init(bitMask0, local0, local1, local2, null);
  };
  StopChatMessageLiveLocation$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer, new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  StopChatMessageLiveLocation$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var StopChatMessageLiveLocation$$serializer_instance = null;
  function StopChatMessageLiveLocation$$serializer_getInstance() {
    if (StopChatMessageLiveLocation$$serializer_instance === null) {
      new StopChatMessageLiveLocation$$serializer();
    }
    return StopChatMessageLiveLocation$$serializer_instance;
  }
  function StopChatMessageLiveLocation_init(seen1, chatId, messageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(StopChatMessageLiveLocation.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_7mtgqa$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_pjlr4h$_0 = messageId;
    if ((seen1 & 4) === 0)
      $this.replyMarkup_cy6141$_0 = null;
    else
      $this.replyMarkup_cy6141$_0 = replyMarkup;
    return $this;
  }
  StopChatMessageLiveLocation.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StopChatMessageLiveLocation',
    interfaces: [EditReplyMessage, EditChatMessage]
  };
  StopChatMessageLiveLocation.prototype.component1 = function () {
    return this.chatId;
  };
  StopChatMessageLiveLocation.prototype.component2 = function () {
    return this.messageId;
  };
  StopChatMessageLiveLocation.prototype.component3 = function () {
    return this.replyMarkup;
  };
  StopChatMessageLiveLocation.prototype.copy_ixtysa$ = function (chatId, messageId, replyMarkup) {
    return new StopChatMessageLiveLocation(chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  StopChatMessageLiveLocation.prototype.toString = function () {
    return 'StopChatMessageLiveLocation(chatId=' + Kotlin.toString(this.chatId) + (', messageId=' + Kotlin.toString(this.messageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  StopChatMessageLiveLocation.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  StopChatMessageLiveLocation.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function StopInlineMessageLiveLocation(inlineMessageId, replyMarkup) {
    StopInlineMessageLiveLocation$Companion_getInstance();
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.inlineMessageId_s0ubw5$_0 = inlineMessageId;
    this.replyMarkup_gph65a$_0 = replyMarkup;
  }
  Object.defineProperty(StopInlineMessageLiveLocation.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_s0ubw5$_0;
    }
  });
  Object.defineProperty(StopInlineMessageLiveLocation.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_gph65a$_0;
    }
  });
  StopInlineMessageLiveLocation.prototype.method = function () {
    return 'stopMessageLiveLocation';
  };
  Object.defineProperty(StopInlineMessageLiveLocation.prototype, 'requestSerializer', {
    get: function () {
      return StopInlineMessageLiveLocation$Companion_getInstance().serializer();
    }
  });
  function StopInlineMessageLiveLocation$Companion() {
    StopInlineMessageLiveLocation$Companion_instance = this;
  }
  StopInlineMessageLiveLocation$Companion.prototype.serializer = function () {
    return StopInlineMessageLiveLocation$$serializer_getInstance();
  };
  StopInlineMessageLiveLocation$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var StopInlineMessageLiveLocation$Companion_instance = null;
  function StopInlineMessageLiveLocation$Companion_getInstance() {
    if (StopInlineMessageLiveLocation$Companion_instance === null) {
      new StopInlineMessageLiveLocation$Companion();
    }
    return StopInlineMessageLiveLocation$Companion_instance;
  }
  function StopInlineMessageLiveLocation$$serializer() {
    this.descriptor_rnuhlz$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.LiveLocation.StopInlineMessageLiveLocation', this);
    this.descriptor.addElement_ivxn3r$('inline_message_id', false);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    StopInlineMessageLiveLocation$$serializer_instance = this;
  }
  Object.defineProperty(StopInlineMessageLiveLocation$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_rnuhlz$_0;
    }
  });
  StopInlineMessageLiveLocation$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.inlineMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  StopInlineMessageLiveLocation$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, InlineKeyboardMarkup$$serializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return StopInlineMessageLiveLocation_init(bitMask0, local0, local1, null);
  };
  StopInlineMessageLiveLocation$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  StopInlineMessageLiveLocation$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var StopInlineMessageLiveLocation$$serializer_instance = null;
  function StopInlineMessageLiveLocation$$serializer_getInstance() {
    if (StopInlineMessageLiveLocation$$serializer_instance === null) {
      new StopInlineMessageLiveLocation$$serializer();
    }
    return StopInlineMessageLiveLocation$$serializer_instance;
  }
  function StopInlineMessageLiveLocation_init(seen1, inlineMessageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(StopInlineMessageLiveLocation.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('inline_message_id');
    else
      $this.inlineMessageId_s0ubw5$_0 = inlineMessageId;
    if ((seen1 & 2) === 0)
      $this.replyMarkup_gph65a$_0 = null;
    else
      $this.replyMarkup_gph65a$_0 = replyMarkup;
    return $this;
  }
  StopInlineMessageLiveLocation.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StopInlineMessageLiveLocation',
    interfaces: [EditReplyMessage, EditInlineMessage]
  };
  StopInlineMessageLiveLocation.prototype.component1 = function () {
    return this.inlineMessageId;
  };
  StopInlineMessageLiveLocation.prototype.component2 = function () {
    return this.replyMarkup;
  };
  StopInlineMessageLiveLocation.prototype.copy_o9644p$ = function (inlineMessageId, replyMarkup) {
    return new StopInlineMessageLiveLocation(inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  StopInlineMessageLiveLocation.prototype.toString = function () {
    return 'StopInlineMessageLiveLocation(inlineMessageId=' + Kotlin.toString(this.inlineMessageId) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  StopInlineMessageLiveLocation.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  StopInlineMessageLiveLocation.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  var editMessageReplyMarkupMethod;
  var commonResultDeserializer_1;
  function EditChatMessageReplyMarkup(chatId, messageId, replyMarkup) {
    EditChatMessageReplyMarkup$Companion_getInstance();
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_tb74ae$_0 = chatId;
    this.messageId_r0gyeh$_0 = messageId;
    this.replyMarkup_3ku7jt$_0 = replyMarkup;
  }
  Object.defineProperty(EditChatMessageReplyMarkup.prototype, 'chatId', {
    get: function () {
      return this.chatId_tb74ae$_0;
    }
  });
  Object.defineProperty(EditChatMessageReplyMarkup.prototype, 'messageId', {
    get: function () {
      return this.messageId_r0gyeh$_0;
    }
  });
  Object.defineProperty(EditChatMessageReplyMarkup.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_3ku7jt$_0;
    }
  });
  EditChatMessageReplyMarkup.prototype.method = function () {
    return editMessageReplyMarkupMethod;
  };
  Object.defineProperty(EditChatMessageReplyMarkup.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_1;
    }
  });
  Object.defineProperty(EditChatMessageReplyMarkup.prototype, 'requestSerializer', {
    get: function () {
      return EditChatMessageReplyMarkup$Companion_getInstance().serializer();
    }
  });
  function EditChatMessageReplyMarkup$Companion() {
    EditChatMessageReplyMarkup$Companion_instance = this;
  }
  EditChatMessageReplyMarkup$Companion.prototype.serializer = function () {
    return EditChatMessageReplyMarkup$$serializer_getInstance();
  };
  EditChatMessageReplyMarkup$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EditChatMessageReplyMarkup$Companion_instance = null;
  function EditChatMessageReplyMarkup$Companion_getInstance() {
    if (EditChatMessageReplyMarkup$Companion_instance === null) {
      new EditChatMessageReplyMarkup$Companion();
    }
    return EditChatMessageReplyMarkup$Companion_instance;
  }
  function EditChatMessageReplyMarkup$$serializer() {
    this.descriptor_evjz6q$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.ReplyMarkup.EditChatMessageReplyMarkup', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    EditChatMessageReplyMarkup$$serializer_instance = this;
  }
  Object.defineProperty(EditChatMessageReplyMarkup$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_evjz6q$_0;
    }
  });
  EditChatMessageReplyMarkup$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.messageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EditChatMessageReplyMarkup$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EditChatMessageReplyMarkup_init(bitMask0, local0, local1, local2, null);
  };
  EditChatMessageReplyMarkup$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer, new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  EditChatMessageReplyMarkup$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EditChatMessageReplyMarkup$$serializer_instance = null;
  function EditChatMessageReplyMarkup$$serializer_getInstance() {
    if (EditChatMessageReplyMarkup$$serializer_instance === null) {
      new EditChatMessageReplyMarkup$$serializer();
    }
    return EditChatMessageReplyMarkup$$serializer_instance;
  }
  function EditChatMessageReplyMarkup_init(seen1, chatId, messageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EditChatMessageReplyMarkup.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_tb74ae$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_r0gyeh$_0 = messageId;
    if ((seen1 & 4) === 0)
      $this.replyMarkup_3ku7jt$_0 = null;
    else
      $this.replyMarkup_3ku7jt$_0 = replyMarkup;
    return $this;
  }
  EditChatMessageReplyMarkup.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EditChatMessageReplyMarkup',
    interfaces: [EditReplyMessage, EditChatMessage]
  };
  EditChatMessageReplyMarkup.prototype.component1 = function () {
    return this.chatId;
  };
  EditChatMessageReplyMarkup.prototype.component2 = function () {
    return this.messageId;
  };
  EditChatMessageReplyMarkup.prototype.component3 = function () {
    return this.replyMarkup;
  };
  EditChatMessageReplyMarkup.prototype.copy_ixtysa$ = function (chatId, messageId, replyMarkup) {
    return new EditChatMessageReplyMarkup(chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  EditChatMessageReplyMarkup.prototype.toString = function () {
    return 'EditChatMessageReplyMarkup(chatId=' + Kotlin.toString(this.chatId) + (', messageId=' + Kotlin.toString(this.messageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  EditChatMessageReplyMarkup.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  EditChatMessageReplyMarkup.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function EditInlineMessageReplyMarkup(inlineMessageId, replyMarkup) {
    EditInlineMessageReplyMarkup$Companion_getInstance();
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.inlineMessageId_ab2j5t$_0 = inlineMessageId;
    this.replyMarkup_trkafs$_0 = replyMarkup;
  }
  Object.defineProperty(EditInlineMessageReplyMarkup.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_ab2j5t$_0;
    }
  });
  Object.defineProperty(EditInlineMessageReplyMarkup.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_trkafs$_0;
    }
  });
  EditInlineMessageReplyMarkup.prototype.method = function () {
    return editMessageReplyMarkupMethod;
  };
  Object.defineProperty(EditInlineMessageReplyMarkup.prototype, 'requestSerializer', {
    get: function () {
      return EditInlineMessageReplyMarkup$Companion_getInstance().serializer();
    }
  });
  function EditInlineMessageReplyMarkup$Companion() {
    EditInlineMessageReplyMarkup$Companion_instance = this;
  }
  EditInlineMessageReplyMarkup$Companion.prototype.serializer = function () {
    return EditInlineMessageReplyMarkup$$serializer_getInstance();
  };
  EditInlineMessageReplyMarkup$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EditInlineMessageReplyMarkup$Companion_instance = null;
  function EditInlineMessageReplyMarkup$Companion_getInstance() {
    if (EditInlineMessageReplyMarkup$Companion_instance === null) {
      new EditInlineMessageReplyMarkup$Companion();
    }
    return EditInlineMessageReplyMarkup$Companion_instance;
  }
  function EditInlineMessageReplyMarkup$$serializer() {
    this.descriptor_p6xlp$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.ReplyMarkup.EditInlineMessageReplyMarkup', this);
    this.descriptor.addElement_ivxn3r$('inline_message_id', false);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    EditInlineMessageReplyMarkup$$serializer_instance = this;
  }
  Object.defineProperty(EditInlineMessageReplyMarkup$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_p6xlp$_0;
    }
  });
  EditInlineMessageReplyMarkup$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.inlineMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EditInlineMessageReplyMarkup$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, InlineKeyboardMarkup$$serializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EditInlineMessageReplyMarkup_init(bitMask0, local0, local1, null);
  };
  EditInlineMessageReplyMarkup$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  EditInlineMessageReplyMarkup$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EditInlineMessageReplyMarkup$$serializer_instance = null;
  function EditInlineMessageReplyMarkup$$serializer_getInstance() {
    if (EditInlineMessageReplyMarkup$$serializer_instance === null) {
      new EditInlineMessageReplyMarkup$$serializer();
    }
    return EditInlineMessageReplyMarkup$$serializer_instance;
  }
  function EditInlineMessageReplyMarkup_init(seen1, inlineMessageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EditInlineMessageReplyMarkup.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('inline_message_id');
    else
      $this.inlineMessageId_ab2j5t$_0 = inlineMessageId;
    if ((seen1 & 2) === 0)
      $this.replyMarkup_trkafs$_0 = null;
    else
      $this.replyMarkup_trkafs$_0 = replyMarkup;
    return $this;
  }
  EditInlineMessageReplyMarkup.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EditInlineMessageReplyMarkup',
    interfaces: [EditReplyMessage, EditInlineMessage]
  };
  EditInlineMessageReplyMarkup.prototype.component1 = function () {
    return this.inlineMessageId;
  };
  EditInlineMessageReplyMarkup.prototype.component2 = function () {
    return this.replyMarkup;
  };
  EditInlineMessageReplyMarkup.prototype.copy_o9644p$ = function (inlineMessageId, replyMarkup) {
    return new EditInlineMessageReplyMarkup(inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  EditInlineMessageReplyMarkup.prototype.toString = function () {
    return 'EditInlineMessageReplyMarkup(inlineMessageId=' + Kotlin.toString(this.inlineMessageId) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  EditInlineMessageReplyMarkup.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  EditInlineMessageReplyMarkup.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function EditChatMessage() {
  }
  EditChatMessage.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'EditChatMessage',
    interfaces: [MessageAction, SimpleRequest]
  };
  function EditDisableWebPagePreviewMessage() {
  }
  EditDisableWebPagePreviewMessage.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'EditDisableWebPagePreviewMessage',
    interfaces: []
  };
  function EditInlineMessage() {
  }
  Object.defineProperty(EditInlineMessage.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  EditInlineMessage.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'EditInlineMessage',
    interfaces: [SimpleRequest]
  };
  function EditLocationMessage() {
  }
  EditLocationMessage.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'EditLocationMessage',
    interfaces: []
  };
  function EditMediaMessage() {
  }
  EditMediaMessage.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'EditMediaMessage',
    interfaces: []
  };
  function EditReplyMessage() {
  }
  EditReplyMessage.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'EditReplyMessage',
    interfaces: [ReplyMarkup]
  };
  function EditTextChatMessage() {
  }
  EditTextChatMessage.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'EditTextChatMessage',
    interfaces: []
  };
  var editMessageCaptionMethod;
  function EditChatMessageCaption(chatId, messageId, text, parseMode, replyMarkup) {
    EditChatMessageCaption$Companion_getInstance();
    if (parseMode === void 0)
      parseMode = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_miuxxy$_0 = chatId;
    this.messageId_fp63zr$_0 = messageId;
    this.text_6pnc1o$_0 = text;
    this.parseMode_48do6j$_0 = parseMode;
    this.replyMarkup_cz6zmh$_0 = replyMarkup;
  }
  Object.defineProperty(EditChatMessageCaption.prototype, 'chatId', {
    get: function () {
      return this.chatId_miuxxy$_0;
    }
  });
  Object.defineProperty(EditChatMessageCaption.prototype, 'messageId', {
    get: function () {
      return this.messageId_fp63zr$_0;
    }
  });
  Object.defineProperty(EditChatMessageCaption.prototype, 'text', {
    get: function () {
      return this.text_6pnc1o$_0;
    }
  });
  Object.defineProperty(EditChatMessageCaption.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_48do6j$_0;
    }
  });
  Object.defineProperty(EditChatMessageCaption.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_cz6zmh$_0;
    }
  });
  EditChatMessageCaption.prototype.method = function () {
    return editMessageCaptionMethod;
  };
  Object.defineProperty(EditChatMessageCaption.prototype, 'resultDeserializer', {
    get: function () {
      return MediaContentMessageResultDeserializer;
    }
  });
  Object.defineProperty(EditChatMessageCaption.prototype, 'requestSerializer', {
    get: function () {
      return EditChatMessageCaption$Companion_getInstance().serializer();
    }
  });
  function EditChatMessageCaption$Companion() {
    EditChatMessageCaption$Companion_instance = this;
  }
  EditChatMessageCaption$Companion.prototype.serializer = function () {
    return EditChatMessageCaption$$serializer_getInstance();
  };
  EditChatMessageCaption$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EditChatMessageCaption$Companion_instance = null;
  function EditChatMessageCaption$Companion_getInstance() {
    if (EditChatMessageCaption$Companion_instance === null) {
      new EditChatMessageCaption$Companion();
    }
    return EditChatMessageCaption$Companion_instance;
  }
  function EditChatMessageCaption$$serializer() {
    this.descriptor_9fzzcy$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.caption.EditChatMessageCaption', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    this.descriptor.addElement_ivxn3r$('caption', false);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    EditChatMessageCaption$$serializer_instance = this;
  }
  Object.defineProperty(EditChatMessageCaption$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_9fzzcy$_0;
    }
  });
  EditChatMessageCaption$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.messageId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EditChatMessageCaption$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, ParseModeSerializerObject_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EditChatMessageCaption_init(bitMask0, local0, local1, local2, local3, local4, null);
  };
  EditChatMessageCaption$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer, internal.StringSerializer, new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  EditChatMessageCaption$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EditChatMessageCaption$$serializer_instance = null;
  function EditChatMessageCaption$$serializer_getInstance() {
    if (EditChatMessageCaption$$serializer_instance === null) {
      new EditChatMessageCaption$$serializer();
    }
    return EditChatMessageCaption$$serializer_instance;
  }
  function EditChatMessageCaption_init(seen1, chatId, messageId, text, parseMode, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EditChatMessageCaption.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_miuxxy$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_fp63zr$_0 = messageId;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('caption');
    else
      $this.text_6pnc1o$_0 = text;
    if ((seen1 & 8) === 0)
      $this.parseMode_48do6j$_0 = null;
    else
      $this.parseMode_48do6j$_0 = parseMode;
    if ((seen1 & 16) === 0)
      $this.replyMarkup_cz6zmh$_0 = null;
    else
      $this.replyMarkup_cz6zmh$_0 = replyMarkup;
    return $this;
  }
  EditChatMessageCaption.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EditChatMessageCaption',
    interfaces: [EditReplyMessage, EditTextChatMessage, EditChatMessage]
  };
  EditChatMessageCaption.prototype.component1 = function () {
    return this.chatId;
  };
  EditChatMessageCaption.prototype.component2 = function () {
    return this.messageId;
  };
  EditChatMessageCaption.prototype.component3 = function () {
    return this.text;
  };
  EditChatMessageCaption.prototype.component4 = function () {
    return this.parseMode;
  };
  EditChatMessageCaption.prototype.component5 = function () {
    return this.replyMarkup;
  };
  EditChatMessageCaption.prototype.copy_6brtto$ = function (chatId, messageId, text, parseMode, replyMarkup) {
    return new EditChatMessageCaption(chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  EditChatMessageCaption.prototype.toString = function () {
    return 'EditChatMessageCaption(chatId=' + Kotlin.toString(this.chatId) + (', messageId=' + Kotlin.toString(this.messageId)) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  EditChatMessageCaption.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  EditChatMessageCaption.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function EditInlineMessageCaption(inlineMessageId, text, parseMode, replyMarkup) {
    EditInlineMessageCaption$Companion_getInstance();
    if (parseMode === void 0)
      parseMode = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.inlineMessageId_omlb6n$_0 = inlineMessageId;
    this.text_gfujur$_0 = text;
    this.parseMode_kzfxdg$_0 = parseMode;
    this.replyMarkup_p8wo6w$_0 = replyMarkup;
  }
  Object.defineProperty(EditInlineMessageCaption.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_omlb6n$_0;
    }
  });
  Object.defineProperty(EditInlineMessageCaption.prototype, 'text', {
    get: function () {
      return this.text_gfujur$_0;
    }
  });
  Object.defineProperty(EditInlineMessageCaption.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_kzfxdg$_0;
    }
  });
  Object.defineProperty(EditInlineMessageCaption.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_p8wo6w$_0;
    }
  });
  EditInlineMessageCaption.prototype.method = function () {
    return editMessageCaptionMethod;
  };
  Object.defineProperty(EditInlineMessageCaption.prototype, 'requestSerializer', {
    get: function () {
      return EditInlineMessageCaption$Companion_getInstance().serializer();
    }
  });
  function EditInlineMessageCaption$Companion() {
    EditInlineMessageCaption$Companion_instance = this;
  }
  EditInlineMessageCaption$Companion.prototype.serializer = function () {
    return EditInlineMessageCaption$$serializer_getInstance();
  };
  EditInlineMessageCaption$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EditInlineMessageCaption$Companion_instance = null;
  function EditInlineMessageCaption$Companion_getInstance() {
    if (EditInlineMessageCaption$Companion_instance === null) {
      new EditInlineMessageCaption$Companion();
    }
    return EditInlineMessageCaption$Companion_instance;
  }
  function EditInlineMessageCaption$$serializer() {
    this.descriptor_9r6cw3$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.caption.EditInlineMessageCaption', this);
    this.descriptor.addElement_ivxn3r$('inline_message_id', false);
    this.descriptor.addElement_ivxn3r$('caption', false);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    EditInlineMessageCaption$$serializer_instance = this;
  }
  Object.defineProperty(EditInlineMessageCaption$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_9r6cw3$_0;
    }
  });
  EditInlineMessageCaption$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.inlineMessageId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EditInlineMessageCaption$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, ParseModeSerializerObject_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EditInlineMessageCaption_init(bitMask0, local0, local1, local2, local3, null);
  };
  EditInlineMessageCaption$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.StringSerializer, new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  EditInlineMessageCaption$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EditInlineMessageCaption$$serializer_instance = null;
  function EditInlineMessageCaption$$serializer_getInstance() {
    if (EditInlineMessageCaption$$serializer_instance === null) {
      new EditInlineMessageCaption$$serializer();
    }
    return EditInlineMessageCaption$$serializer_instance;
  }
  function EditInlineMessageCaption_init(seen1, inlineMessageId, text, parseMode, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EditInlineMessageCaption.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('inline_message_id');
    else
      $this.inlineMessageId_omlb6n$_0 = inlineMessageId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('caption');
    else
      $this.text_gfujur$_0 = text;
    if ((seen1 & 4) === 0)
      $this.parseMode_kzfxdg$_0 = null;
    else
      $this.parseMode_kzfxdg$_0 = parseMode;
    if ((seen1 & 8) === 0)
      $this.replyMarkup_p8wo6w$_0 = null;
    else
      $this.replyMarkup_p8wo6w$_0 = replyMarkup;
    return $this;
  }
  EditInlineMessageCaption.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EditInlineMessageCaption',
    interfaces: [EditReplyMessage, EditTextChatMessage, EditInlineMessage]
  };
  EditInlineMessageCaption.prototype.component1 = function () {
    return this.inlineMessageId;
  };
  EditInlineMessageCaption.prototype.component2 = function () {
    return this.text;
  };
  EditInlineMessageCaption.prototype.component3 = function () {
    return this.parseMode;
  };
  EditInlineMessageCaption.prototype.component4 = function () {
    return this.replyMarkup;
  };
  EditInlineMessageCaption.prototype.copy_8bywbx$ = function (inlineMessageId, text, parseMode, replyMarkup) {
    return new EditInlineMessageCaption(inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  EditInlineMessageCaption.prototype.toString = function () {
    return 'EditInlineMessageCaption(inlineMessageId=' + Kotlin.toString(this.inlineMessageId) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  EditInlineMessageCaption.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  EditInlineMessageCaption.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  var editMessageMediaMethod;
  var MediaContentMessageResultDeserializer;
  function EditChatMessageMedia(chatId, messageId, media, replyMarkup) {
    EditChatMessageMedia$Companion_getInstance();
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_hqcuui$_0 = chatId;
    this.messageId_332ojt$_0 = messageId;
    this.media_hv6iw7$_0 = media;
    this.replyMarkup_n3azx5$_0 = replyMarkup;
    if (Kotlin.isType(this.media.file, MultipartFile)) {
      throw IllegalArgumentException_init('For editing of media messages you MUST use file id (according to documentation)');
    }
  }
  Object.defineProperty(EditChatMessageMedia.prototype, 'chatId', {
    get: function () {
      return this.chatId_hqcuui$_0;
    }
  });
  Object.defineProperty(EditChatMessageMedia.prototype, 'messageId', {
    get: function () {
      return this.messageId_332ojt$_0;
    }
  });
  Object.defineProperty(EditChatMessageMedia.prototype, 'media', {
    get: function () {
      return this.media_hv6iw7$_0;
    }
  });
  Object.defineProperty(EditChatMessageMedia.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_n3azx5$_0;
    }
  });
  EditChatMessageMedia.prototype.method = function () {
    return editMessageMediaMethod;
  };
  Object.defineProperty(EditChatMessageMedia.prototype, 'resultDeserializer', {
    get: function () {
      return MediaContentMessageResultDeserializer;
    }
  });
  Object.defineProperty(EditChatMessageMedia.prototype, 'requestSerializer', {
    get: function () {
      return EditChatMessageMedia$Companion_getInstance().serializer();
    }
  });
  function EditChatMessageMedia$Companion() {
    EditChatMessageMedia$Companion_instance = this;
  }
  EditChatMessageMedia$Companion.prototype.serializer = function () {
    return EditChatMessageMedia$$serializer_getInstance();
  };
  EditChatMessageMedia$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EditChatMessageMedia$Companion_instance = null;
  function EditChatMessageMedia$Companion_getInstance() {
    if (EditChatMessageMedia$Companion_instance === null) {
      new EditChatMessageMedia$Companion();
    }
    return EditChatMessageMedia$Companion_instance;
  }
  function EditChatMessageMedia$$serializer() {
    this.descriptor_1sc9c2$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.media.EditChatMessageMedia', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    this.descriptor.addElement_ivxn3r$('media', false);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    EditChatMessageMedia$$serializer_instance = this;
  }
  Object.defineProperty(EditChatMessageMedia$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_1sc9c2$_0;
    }
  });
  EditChatMessageMedia$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.messageId);
    output.encodeSerializableElement_blecud$(this.descriptor, 2, InputMediaSerializer_getInstance(), obj.media);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EditChatMessageMedia$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 2, InputMediaSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 2, InputMediaSerializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EditChatMessageMedia_init(bitMask0, local0, local1, local2, local3, null);
  };
  EditChatMessageMedia$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer, InputMediaSerializer_getInstance(), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  EditChatMessageMedia$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EditChatMessageMedia$$serializer_instance = null;
  function EditChatMessageMedia$$serializer_getInstance() {
    if (EditChatMessageMedia$$serializer_instance === null) {
      new EditChatMessageMedia$$serializer();
    }
    return EditChatMessageMedia$$serializer_instance;
  }
  function EditChatMessageMedia_init(seen1, chatId, messageId, media, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EditChatMessageMedia.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_hqcuui$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_332ojt$_0 = messageId;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('media');
    else
      $this.media_hv6iw7$_0 = media;
    if ((seen1 & 8) === 0)
      $this.replyMarkup_n3azx5$_0 = null;
    else
      $this.replyMarkup_n3azx5$_0 = replyMarkup;
    if (Kotlin.isType($this.media.file, MultipartFile)) {
      throw IllegalArgumentException_init('For editing of media messages you MUST use file id (according to documentation)');
    }
    return $this;
  }
  EditChatMessageMedia.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EditChatMessageMedia',
    interfaces: [EditMediaMessage, EditReplyMessage, EditChatMessage]
  };
  EditChatMessageMedia.prototype.component1 = function () {
    return this.chatId;
  };
  EditChatMessageMedia.prototype.component2 = function () {
    return this.messageId;
  };
  EditChatMessageMedia.prototype.component3 = function () {
    return this.media;
  };
  EditChatMessageMedia.prototype.component4 = function () {
    return this.replyMarkup;
  };
  EditChatMessageMedia.prototype.copy_q7bh7t$ = function (chatId, messageId, media, replyMarkup) {
    return new EditChatMessageMedia(chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId, media === void 0 ? this.media : media, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  EditChatMessageMedia.prototype.toString = function () {
    return 'EditChatMessageMedia(chatId=' + Kotlin.toString(this.chatId) + (', messageId=' + Kotlin.toString(this.messageId)) + (', media=' + Kotlin.toString(this.media)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  EditChatMessageMedia.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.media) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  EditChatMessageMedia.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId) && Kotlin.equals(this.media, other.media) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function EditInlineMessageMedia(inlineMessageId, media, replyMarkup) {
    EditInlineMessageMedia$Companion_getInstance();
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.inlineMessageId_jvupen$_0 = inlineMessageId;
    this.media_6tvrd2$_0 = media;
    this.replyMarkup_had1hk$_0 = replyMarkup;
    if (Kotlin.isType(this.media.file, MultipartFile)) {
      throw IllegalArgumentException_init('For editing of media messages you MUST use file id (according to documentation)');
    }
  }
  Object.defineProperty(EditInlineMessageMedia.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_jvupen$_0;
    }
  });
  Object.defineProperty(EditInlineMessageMedia.prototype, 'media', {
    get: function () {
      return this.media_6tvrd2$_0;
    }
  });
  Object.defineProperty(EditInlineMessageMedia.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_had1hk$_0;
    }
  });
  Object.defineProperty(EditInlineMessageMedia.prototype, 'requestSerializer', {
    get: function () {
      return EditInlineMessageMedia$Companion_getInstance().serializer();
    }
  });
  EditInlineMessageMedia.prototype.method = function () {
    return editMessageMediaMethod;
  };
  function EditInlineMessageMedia$Companion() {
    EditInlineMessageMedia$Companion_instance = this;
  }
  EditInlineMessageMedia$Companion.prototype.serializer = function () {
    return EditInlineMessageMedia$$serializer_getInstance();
  };
  EditInlineMessageMedia$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EditInlineMessageMedia$Companion_instance = null;
  function EditInlineMessageMedia$Companion_getInstance() {
    if (EditInlineMessageMedia$Companion_instance === null) {
      new EditInlineMessageMedia$Companion();
    }
    return EditInlineMessageMedia$Companion_instance;
  }
  function EditInlineMessageMedia$$serializer() {
    this.descriptor_pq3y0t$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.media.EditInlineMessageMedia', this);
    this.descriptor.addElement_ivxn3r$('inline_message_id', false);
    this.descriptor.addElement_ivxn3r$('media', false);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    EditInlineMessageMedia$$serializer_instance = this;
  }
  Object.defineProperty(EditInlineMessageMedia$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_pq3y0t$_0;
    }
  });
  EditInlineMessageMedia$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.inlineMessageId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, InputMediaSerializer_getInstance(), obj.media);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EditInlineMessageMedia$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, InputMediaSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, InputMediaSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, InlineKeyboardMarkup$$serializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EditInlineMessageMedia_init(bitMask0, local0, local1, local2, null);
  };
  EditInlineMessageMedia$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, InputMediaSerializer_getInstance(), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  EditInlineMessageMedia$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EditInlineMessageMedia$$serializer_instance = null;
  function EditInlineMessageMedia$$serializer_getInstance() {
    if (EditInlineMessageMedia$$serializer_instance === null) {
      new EditInlineMessageMedia$$serializer();
    }
    return EditInlineMessageMedia$$serializer_instance;
  }
  function EditInlineMessageMedia_init(seen1, inlineMessageId, media, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EditInlineMessageMedia.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('inline_message_id');
    else
      $this.inlineMessageId_jvupen$_0 = inlineMessageId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('media');
    else
      $this.media_6tvrd2$_0 = media;
    if ((seen1 & 4) === 0)
      $this.replyMarkup_had1hk$_0 = null;
    else
      $this.replyMarkup_had1hk$_0 = replyMarkup;
    if (Kotlin.isType($this.media.file, MultipartFile)) {
      throw IllegalArgumentException_init('For editing of media messages you MUST use file id (according to documentation)');
    }
    return $this;
  }
  EditInlineMessageMedia.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EditInlineMessageMedia',
    interfaces: [EditMediaMessage, EditReplyMessage, EditInlineMessage]
  };
  EditInlineMessageMedia.prototype.component1 = function () {
    return this.inlineMessageId;
  };
  EditInlineMessageMedia.prototype.component2 = function () {
    return this.media;
  };
  EditInlineMessageMedia.prototype.component3 = function () {
    return this.replyMarkup;
  };
  EditInlineMessageMedia.prototype.copy_sl3eh2$ = function (inlineMessageId, media, replyMarkup) {
    return new EditInlineMessageMedia(inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, media === void 0 ? this.media : media, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  EditInlineMessageMedia.prototype.toString = function () {
    return 'EditInlineMessageMedia(inlineMessageId=' + Kotlin.toString(this.inlineMessageId) + (', media=' + Kotlin.toString(this.media)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  EditInlineMessageMedia.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.media) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  EditInlineMessageMedia.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.media, other.media) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  var editMessageTextMethod;
  function EditChatMessageText(chatId, messageId, text, parseMode, disableWebPagePreview, replyMarkup) {
    EditChatMessageText$Companion_getInstance();
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_kxmj7i$_0 = chatId;
    this.messageId_gyrz3$_0 = messageId;
    this.text_o5k36s$_0 = text;
    this.parseMode_aztnu5$_0 = parseMode;
    this.disableWebPagePreview_oluj92$_0 = disableWebPagePreview;
    this.replyMarkup_elrii9$_0 = replyMarkup;
  }
  Object.defineProperty(EditChatMessageText.prototype, 'chatId', {
    get: function () {
      return this.chatId_kxmj7i$_0;
    }
  });
  Object.defineProperty(EditChatMessageText.prototype, 'messageId', {
    get: function () {
      return this.messageId_gyrz3$_0;
    }
  });
  Object.defineProperty(EditChatMessageText.prototype, 'text', {
    get: function () {
      return this.text_o5k36s$_0;
    }
  });
  Object.defineProperty(EditChatMessageText.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_aztnu5$_0;
    }
  });
  Object.defineProperty(EditChatMessageText.prototype, 'disableWebPagePreview', {
    get: function () {
      return this.disableWebPagePreview_oluj92$_0;
    }
  });
  Object.defineProperty(EditChatMessageText.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_elrii9$_0;
    }
  });
  EditChatMessageText.prototype.method = function () {
    return editMessageTextMethod;
  };
  Object.defineProperty(EditChatMessageText.prototype, 'resultDeserializer', {
    get: function () {
      return TextContentMessageResultDeserializer;
    }
  });
  Object.defineProperty(EditChatMessageText.prototype, 'requestSerializer', {
    get: function () {
      return EditChatMessageText$Companion_getInstance().serializer();
    }
  });
  function EditChatMessageText$Companion() {
    EditChatMessageText$Companion_instance = this;
  }
  EditChatMessageText$Companion.prototype.serializer = function () {
    return EditChatMessageText$$serializer_getInstance();
  };
  EditChatMessageText$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EditChatMessageText$Companion_instance = null;
  function EditChatMessageText$Companion_getInstance() {
    if (EditChatMessageText$Companion_instance === null) {
      new EditChatMessageText$Companion();
    }
    return EditChatMessageText$Companion_instance;
  }
  function EditChatMessageText$$serializer() {
    this.descriptor_theu3a$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.text.EditChatMessageText', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    this.descriptor.addElement_ivxn3r$('text', false);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('disable_web_page_preview', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    EditChatMessageText$$serializer_instance = this;
  }
  Object.defineProperty(EditChatMessageText$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_theu3a$_0;
    }
  });
  EditChatMessageText$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.messageId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.disableWebPagePreview, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.BooleanSerializer, obj.disableWebPagePreview);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EditChatMessageText$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, ParseModeSerializerObject_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.BooleanSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, InlineKeyboardMarkup$$serializer_getInstance(), local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EditChatMessageText_init(bitMask0, local0, local1, local2, local3, local4, local5, null);
  };
  EditChatMessageText$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer, internal.StringSerializer, new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  EditChatMessageText$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EditChatMessageText$$serializer_instance = null;
  function EditChatMessageText$$serializer_getInstance() {
    if (EditChatMessageText$$serializer_instance === null) {
      new EditChatMessageText$$serializer();
    }
    return EditChatMessageText$$serializer_instance;
  }
  function EditChatMessageText_init(seen1, chatId, messageId, text, parseMode, disableWebPagePreview, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EditChatMessageText.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_kxmj7i$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_gyrz3$_0 = messageId;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('text');
    else
      $this.text_o5k36s$_0 = text;
    if ((seen1 & 8) === 0)
      $this.parseMode_aztnu5$_0 = null;
    else
      $this.parseMode_aztnu5$_0 = parseMode;
    if ((seen1 & 16) === 0)
      $this.disableWebPagePreview_oluj92$_0 = null;
    else
      $this.disableWebPagePreview_oluj92$_0 = disableWebPagePreview;
    if ((seen1 & 32) === 0)
      $this.replyMarkup_elrii9$_0 = null;
    else
      $this.replyMarkup_elrii9$_0 = replyMarkup;
    return $this;
  }
  EditChatMessageText.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EditChatMessageText',
    interfaces: [EditDisableWebPagePreviewMessage, EditReplyMessage, EditTextChatMessage, EditChatMessage]
  };
  EditChatMessageText.prototype.component1 = function () {
    return this.chatId;
  };
  EditChatMessageText.prototype.component2 = function () {
    return this.messageId;
  };
  EditChatMessageText.prototype.component3 = function () {
    return this.text;
  };
  EditChatMessageText.prototype.component4 = function () {
    return this.parseMode;
  };
  EditChatMessageText.prototype.component5 = function () {
    return this.disableWebPagePreview;
  };
  EditChatMessageText.prototype.component6 = function () {
    return this.replyMarkup;
  };
  EditChatMessageText.prototype.copy_4lwtck$ = function (chatId, messageId, text, parseMode, disableWebPagePreview, replyMarkup) {
    return new EditChatMessageText(chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, disableWebPagePreview === void 0 ? this.disableWebPagePreview : disableWebPagePreview, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  EditChatMessageText.prototype.toString = function () {
    return 'EditChatMessageText(chatId=' + Kotlin.toString(this.chatId) + (', messageId=' + Kotlin.toString(this.messageId)) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', disableWebPagePreview=' + Kotlin.toString(this.disableWebPagePreview)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  EditChatMessageText.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableWebPagePreview) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  EditChatMessageText.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.disableWebPagePreview, other.disableWebPagePreview) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function EditInlineMessageText(inlineMessageId, text, parseMode, disableWebPagePreview, replyMarkup) {
    EditInlineMessageText$Companion_getInstance();
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.inlineMessageId_5h56xx$_0 = inlineMessageId;
    this.text_b1oyf1$_0 = text;
    this.parseMode_4v2i7i$_0 = parseMode;
    this.disableWebPagePreview_nyhflj$_0 = disableWebPagePreview;
    this.replyMarkup_h96t4i$_0 = replyMarkup;
  }
  Object.defineProperty(EditInlineMessageText.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_5h56xx$_0;
    }
  });
  Object.defineProperty(EditInlineMessageText.prototype, 'text', {
    get: function () {
      return this.text_b1oyf1$_0;
    }
  });
  Object.defineProperty(EditInlineMessageText.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_4v2i7i$_0;
    }
  });
  Object.defineProperty(EditInlineMessageText.prototype, 'disableWebPagePreview', {
    get: function () {
      return this.disableWebPagePreview_nyhflj$_0;
    }
  });
  Object.defineProperty(EditInlineMessageText.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_h96t4i$_0;
    }
  });
  EditInlineMessageText.prototype.method = function () {
    return editMessageMediaMethod;
  };
  Object.defineProperty(EditInlineMessageText.prototype, 'requestSerializer', {
    get: function () {
      return EditInlineMessageText$Companion_getInstance().serializer();
    }
  });
  function EditInlineMessageText$Companion() {
    EditInlineMessageText$Companion_instance = this;
  }
  EditInlineMessageText$Companion.prototype.serializer = function () {
    return EditInlineMessageText$$serializer_getInstance();
  };
  EditInlineMessageText$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var EditInlineMessageText$Companion_instance = null;
  function EditInlineMessageText$Companion_getInstance() {
    if (EditInlineMessageText$Companion_instance === null) {
      new EditInlineMessageText$Companion();
    }
    return EditInlineMessageText$Companion_instance;
  }
  function EditInlineMessageText$$serializer() {
    this.descriptor_lff2mh$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.edit.text.EditInlineMessageText', this);
    this.descriptor.addElement_ivxn3r$('inline_message_id', false);
    this.descriptor.addElement_ivxn3r$('text', false);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('disable_web_page_preview', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    EditInlineMessageText$$serializer_instance = this;
  }
  Object.defineProperty(EditInlineMessageText$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_lff2mh$_0;
    }
  });
  EditInlineMessageText$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.inlineMessageId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.disableWebPagePreview, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.BooleanSerializer, obj.disableWebPagePreview);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  EditInlineMessageText$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, ParseModeSerializerObject_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.BooleanSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return EditInlineMessageText_init(bitMask0, local0, local1, local2, local3, local4, null);
  };
  EditInlineMessageText$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.StringSerializer, new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance())];
  };
  EditInlineMessageText$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var EditInlineMessageText$$serializer_instance = null;
  function EditInlineMessageText$$serializer_getInstance() {
    if (EditInlineMessageText$$serializer_instance === null) {
      new EditInlineMessageText$$serializer();
    }
    return EditInlineMessageText$$serializer_instance;
  }
  function EditInlineMessageText_init(seen1, inlineMessageId, text, parseMode, disableWebPagePreview, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(EditInlineMessageText.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('inline_message_id');
    else
      $this.inlineMessageId_5h56xx$_0 = inlineMessageId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('text');
    else
      $this.text_b1oyf1$_0 = text;
    if ((seen1 & 4) === 0)
      $this.parseMode_4v2i7i$_0 = null;
    else
      $this.parseMode_4v2i7i$_0 = parseMode;
    if ((seen1 & 8) === 0)
      $this.disableWebPagePreview_nyhflj$_0 = null;
    else
      $this.disableWebPagePreview_nyhflj$_0 = disableWebPagePreview;
    if ((seen1 & 16) === 0)
      $this.replyMarkup_h96t4i$_0 = null;
    else
      $this.replyMarkup_h96t4i$_0 = replyMarkup;
    return $this;
  }
  EditInlineMessageText.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'EditInlineMessageText',
    interfaces: [EditDisableWebPagePreviewMessage, EditReplyMessage, EditTextChatMessage, EditInlineMessage]
  };
  EditInlineMessageText.prototype.component1 = function () {
    return this.inlineMessageId;
  };
  EditInlineMessageText.prototype.component2 = function () {
    return this.text;
  };
  EditInlineMessageText.prototype.component3 = function () {
    return this.parseMode;
  };
  EditInlineMessageText.prototype.component4 = function () {
    return this.disableWebPagePreview;
  };
  EditInlineMessageText.prototype.component5 = function () {
    return this.replyMarkup;
  };
  EditInlineMessageText.prototype.copy_5lpblx$ = function (inlineMessageId, text, parseMode, disableWebPagePreview, replyMarkup) {
    return new EditInlineMessageText(inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, disableWebPagePreview === void 0 ? this.disableWebPagePreview : disableWebPagePreview, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  EditInlineMessageText.prototype.toString = function () {
    return 'EditInlineMessageText(inlineMessageId=' + Kotlin.toString(this.inlineMessageId) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', disableWebPagePreview=' + Kotlin.toString(this.disableWebPagePreview)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  EditInlineMessageText.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableWebPagePreview) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  EditInlineMessageText.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.disableWebPagePreview, other.disableWebPagePreview) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function GetGameHighScoresByChat(userId, chatId, messageId) {
    GetGameHighScoresByChat$Companion_getInstance();
    this.userId_cf70zh$_0 = userId;
    this.chatId_28gc5y$_0 = chatId;
    this.messageId_qbd43t$_0 = messageId;
  }
  Object.defineProperty(GetGameHighScoresByChat.prototype, 'userId', {
    get: function () {
      return this.userId_cf70zh$_0;
    }
  });
  Object.defineProperty(GetGameHighScoresByChat.prototype, 'chatId', {
    get: function () {
      return this.chatId_28gc5y$_0;
    }
  });
  Object.defineProperty(GetGameHighScoresByChat.prototype, 'messageId', {
    get: function () {
      return this.messageId_qbd43t$_0;
    }
  });
  Object.defineProperty(GetGameHighScoresByChat.prototype, 'requestSerializer', {
    get: function () {
      return GetGameHighScoresByChat$Companion_getInstance().serializer();
    }
  });
  function GetGameHighScoresByChat$Companion() {
    GetGameHighScoresByChat$Companion_instance = this;
  }
  GetGameHighScoresByChat$Companion.prototype.serializer = function () {
    return GetGameHighScoresByChat$$serializer_getInstance();
  };
  GetGameHighScoresByChat$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetGameHighScoresByChat$Companion_instance = null;
  function GetGameHighScoresByChat$Companion_getInstance() {
    if (GetGameHighScoresByChat$Companion_instance === null) {
      new GetGameHighScoresByChat$Companion();
    }
    return GetGameHighScoresByChat$Companion_instance;
  }
  function GetGameHighScoresByChat$$serializer() {
    this.descriptor_dz93ia$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.games.GetGameHighScoresByChat', this);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    GetGameHighScoresByChat$$serializer_instance = this;
  }
  Object.defineProperty(GetGameHighScoresByChat$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_dz93ia$_0;
    }
  });
  GetGameHighScoresByChat$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.userId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 2, obj.messageId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetGameHighScoresByChat$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, ChatIdentifierSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeLongElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetGameHighScoresByChat_init(bitMask0, local0, local1, local2, null);
  };
  GetGameHighScoresByChat$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), ChatIdentifierSerializer_getInstance(), internal.LongSerializer];
  };
  GetGameHighScoresByChat$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetGameHighScoresByChat$$serializer_instance = null;
  function GetGameHighScoresByChat$$serializer_getInstance() {
    if (GetGameHighScoresByChat$$serializer_instance === null) {
      new GetGameHighScoresByChat$$serializer();
    }
    return GetGameHighScoresByChat$$serializer_instance;
  }
  function GetGameHighScoresByChat_init(seen1, userId, chatId, messageId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetGameHighScoresByChat.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_cf70zh$_0 = userId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_28gc5y$_0 = chatId;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_qbd43t$_0 = messageId;
    return $this;
  }
  GetGameHighScoresByChat.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetGameHighScoresByChat',
    interfaces: [MessageAction, GetGameHighScores]
  };
  GetGameHighScoresByChat.prototype.component1 = function () {
    return this.userId;
  };
  GetGameHighScoresByChat.prototype.component2 = function () {
    return this.chatId;
  };
  GetGameHighScoresByChat.prototype.component3 = function () {
    return this.messageId;
  };
  GetGameHighScoresByChat.prototype.copy_hzli97$ = function (userId, chatId, messageId) {
    return new GetGameHighScoresByChat(userId === void 0 ? this.userId : userId, chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId);
  };
  GetGameHighScoresByChat.prototype.toString = function () {
    return 'GetGameHighScoresByChat(userId=' + Kotlin.toString(this.userId) + (', chatId=' + Kotlin.toString(this.chatId)) + (', messageId=' + Kotlin.toString(this.messageId)) + ')';
  };
  GetGameHighScoresByChat.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    return result;
  };
  GetGameHighScoresByChat.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId)))));
  };
  function GetGameHighScoresByInlineMessageId(userId, inlineMessageId) {
    GetGameHighScoresByInlineMessageId$Companion_getInstance();
    this.userId_fz48t2$_0 = userId;
    this.inlineMessageId_bngf45$_0 = inlineMessageId;
  }
  Object.defineProperty(GetGameHighScoresByInlineMessageId.prototype, 'userId', {
    get: function () {
      return this.userId_fz48t2$_0;
    }
  });
  Object.defineProperty(GetGameHighScoresByInlineMessageId.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_bngf45$_0;
    }
  });
  Object.defineProperty(GetGameHighScoresByInlineMessageId.prototype, 'requestSerializer', {
    get: function () {
      return GetGameHighScoresByInlineMessageId$Companion_getInstance().serializer();
    }
  });
  function GetGameHighScoresByInlineMessageId$Companion() {
    GetGameHighScoresByInlineMessageId$Companion_instance = this;
  }
  GetGameHighScoresByInlineMessageId$Companion.prototype.serializer = function () {
    return GetGameHighScoresByInlineMessageId$$serializer_getInstance();
  };
  GetGameHighScoresByInlineMessageId$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetGameHighScoresByInlineMessageId$Companion_instance = null;
  function GetGameHighScoresByInlineMessageId$Companion_getInstance() {
    if (GetGameHighScoresByInlineMessageId$Companion_instance === null) {
      new GetGameHighScoresByInlineMessageId$Companion();
    }
    return GetGameHighScoresByInlineMessageId$Companion_instance;
  }
  function GetGameHighScoresByInlineMessageId$$serializer() {
    this.descriptor_wfi6s7$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.games.GetGameHighScoresByInlineMessageId', this);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('inline_message_id', false);
    GetGameHighScoresByInlineMessageId$$serializer_instance = this;
  }
  Object.defineProperty(GetGameHighScoresByInlineMessageId$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_wfi6s7$_0;
    }
  });
  GetGameHighScoresByInlineMessageId$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.userId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.inlineMessageId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetGameHighScoresByInlineMessageId$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetGameHighScoresByInlineMessageId_init(bitMask0, local0, local1, null);
  };
  GetGameHighScoresByInlineMessageId$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer];
  };
  GetGameHighScoresByInlineMessageId$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetGameHighScoresByInlineMessageId$$serializer_instance = null;
  function GetGameHighScoresByInlineMessageId$$serializer_getInstance() {
    if (GetGameHighScoresByInlineMessageId$$serializer_instance === null) {
      new GetGameHighScoresByInlineMessageId$$serializer();
    }
    return GetGameHighScoresByInlineMessageId$$serializer_instance;
  }
  function GetGameHighScoresByInlineMessageId_init(seen1, userId, inlineMessageId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetGameHighScoresByInlineMessageId.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_fz48t2$_0 = userId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('inline_message_id');
    else
      $this.inlineMessageId_bngf45$_0 = inlineMessageId;
    return $this;
  }
  GetGameHighScoresByInlineMessageId.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetGameHighScoresByInlineMessageId',
    interfaces: [InlineMessageAction, GetGameHighScores]
  };
  GetGameHighScoresByInlineMessageId.prototype.component1 = function () {
    return this.userId;
  };
  GetGameHighScoresByInlineMessageId.prototype.component2 = function () {
    return this.inlineMessageId;
  };
  GetGameHighScoresByInlineMessageId.prototype.copy_ofozbg$ = function (userId, inlineMessageId) {
    return new GetGameHighScoresByInlineMessageId(userId === void 0 ? this.userId : userId, inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId);
  };
  GetGameHighScoresByInlineMessageId.prototype.toString = function () {
    return 'GetGameHighScoresByInlineMessageId(userId=' + Kotlin.toString(this.userId) + (', inlineMessageId=' + Kotlin.toString(this.inlineMessageId)) + ')';
  };
  GetGameHighScoresByInlineMessageId.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    return result;
  };
  GetGameHighScoresByInlineMessageId.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.inlineMessageId, other.inlineMessageId)))));
  };
  function SetGameScoreByChatId(userId, score, chatId, messageId, force, disableEditMessage) {
    SetGameScoreByChatId$Companion_getInstance();
    if (force === void 0)
      force = false;
    if (disableEditMessage === void 0)
      disableEditMessage = false;
    this.userId_1u60r9$_0 = userId;
    this.score_cpa50v$_0 = score;
    this.chatId_cthce6$_0 = chatId;
    this.messageId_vc5jtt$_0 = messageId;
    this.force_io836w$_0 = force;
    this.disableEditMessage_pha37g$_0 = disableEditMessage;
  }
  Object.defineProperty(SetGameScoreByChatId.prototype, 'userId', {
    get: function () {
      return this.userId_1u60r9$_0;
    }
  });
  Object.defineProperty(SetGameScoreByChatId.prototype, 'score', {
    get: function () {
      return this.score_cpa50v$_0;
    }
  });
  Object.defineProperty(SetGameScoreByChatId.prototype, 'chatId', {
    get: function () {
      return this.chatId_cthce6$_0;
    }
  });
  Object.defineProperty(SetGameScoreByChatId.prototype, 'messageId', {
    get: function () {
      return this.messageId_vc5jtt$_0;
    }
  });
  Object.defineProperty(SetGameScoreByChatId.prototype, 'force', {
    get: function () {
      return this.force_io836w$_0;
    }
  });
  Object.defineProperty(SetGameScoreByChatId.prototype, 'disableEditMessage', {
    get: function () {
      return this.disableEditMessage_pha37g$_0;
    }
  });
  Object.defineProperty(SetGameScoreByChatId.prototype, 'requestSerializer', {
    get: function () {
      return SetGameScoreByChatId$Companion_getInstance().serializer();
    }
  });
  function SetGameScoreByChatId$Companion() {
    SetGameScoreByChatId$Companion_instance = this;
  }
  SetGameScoreByChatId$Companion.prototype.serializer = function () {
    return SetGameScoreByChatId$$serializer_getInstance();
  };
  SetGameScoreByChatId$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SetGameScoreByChatId$Companion_instance = null;
  function SetGameScoreByChatId$Companion_getInstance() {
    if (SetGameScoreByChatId$Companion_instance === null) {
      new SetGameScoreByChatId$Companion();
    }
    return SetGameScoreByChatId$Companion_instance;
  }
  function SetGameScoreByChatId$$serializer() {
    this.descriptor_4c0s5y$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.games.SetGameScoreByChatId', this);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('score', false);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('message_id', false);
    this.descriptor.addElement_ivxn3r$('force', true);
    this.descriptor.addElement_ivxn3r$('disable_edit_message', true);
    SetGameScoreByChatId$$serializer_instance = this;
  }
  Object.defineProperty(SetGameScoreByChatId$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_4c0s5y$_0;
    }
  });
  SetGameScoreByChatId$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.userId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.score);
    output.encodeSerializableElement_blecud$(this.descriptor, 2, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 3, obj.messageId);
    if (!equals(obj.force, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 4, obj.force);
    if (!equals(obj.disableEditMessage, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 5, obj.disableEditMessage);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SetGameScoreByChatId$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 2, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 2, ChatIdentifierSerializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeLongElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SetGameScoreByChatId_init(bitMask0, local0, local1, local2, local3, local4, local5, null);
  };
  SetGameScoreByChatId$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer, ChatIdentifierSerializer_getInstance(), internal.LongSerializer, internal.BooleanSerializer, internal.BooleanSerializer];
  };
  SetGameScoreByChatId$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SetGameScoreByChatId$$serializer_instance = null;
  function SetGameScoreByChatId$$serializer_getInstance() {
    if (SetGameScoreByChatId$$serializer_instance === null) {
      new SetGameScoreByChatId$$serializer();
    }
    return SetGameScoreByChatId$$serializer_instance;
  }
  function SetGameScoreByChatId_init(seen1, userId, score, chatId, messageId, force, disableEditMessage, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SetGameScoreByChatId.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_1u60r9$_0 = userId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('score');
    else
      $this.score_cpa50v$_0 = score;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_cthce6$_0 = chatId;
    if ((seen1 & 8) === 0)
      throw new MissingFieldException('message_id');
    else
      $this.messageId_vc5jtt$_0 = messageId;
    if ((seen1 & 16) === 0)
      $this.force_io836w$_0 = false;
    else
      $this.force_io836w$_0 = force;
    if ((seen1 & 32) === 0)
      $this.disableEditMessage_pha37g$_0 = false;
    else
      $this.disableEditMessage_pha37g$_0 = disableEditMessage;
    return $this;
  }
  SetGameScoreByChatId.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SetGameScoreByChatId',
    interfaces: [MessageAction, SetGameScore]
  };
  SetGameScoreByChatId.prototype.component1 = function () {
    return this.userId;
  };
  SetGameScoreByChatId.prototype.component2 = function () {
    return this.score;
  };
  SetGameScoreByChatId.prototype.component3 = function () {
    return this.chatId;
  };
  SetGameScoreByChatId.prototype.component4 = function () {
    return this.messageId;
  };
  SetGameScoreByChatId.prototype.component5 = function () {
    return this.force;
  };
  SetGameScoreByChatId.prototype.component6 = function () {
    return this.disableEditMessage;
  };
  SetGameScoreByChatId.prototype.copy_phkhji$ = function (userId, score, chatId, messageId, force, disableEditMessage) {
    return new SetGameScoreByChatId(userId === void 0 ? this.userId : userId, score === void 0 ? this.score : score, chatId === void 0 ? this.chatId : chatId, messageId === void 0 ? this.messageId : messageId, force === void 0 ? this.force : force, disableEditMessage === void 0 ? this.disableEditMessage : disableEditMessage);
  };
  SetGameScoreByChatId.prototype.toString = function () {
    return 'SetGameScoreByChatId(userId=' + Kotlin.toString(this.userId) + (', score=' + Kotlin.toString(this.score)) + (', chatId=' + Kotlin.toString(this.chatId)) + (', messageId=' + Kotlin.toString(this.messageId)) + (', force=' + Kotlin.toString(this.force)) + (', disableEditMessage=' + Kotlin.toString(this.disableEditMessage)) + ')';
  };
  SetGameScoreByChatId.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.score) | 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.messageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.force) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableEditMessage) | 0;
    return result;
  };
  SetGameScoreByChatId.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.score, other.score) && Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.messageId, other.messageId) && Kotlin.equals(this.force, other.force) && Kotlin.equals(this.disableEditMessage, other.disableEditMessage)))));
  };
  function SetGameScoreByInlineMessageId(userId, score, inlineMessageId, force, disableEditMessage) {
    SetGameScoreByInlineMessageId$Companion_getInstance();
    if (force === void 0)
      force = false;
    if (disableEditMessage === void 0)
      disableEditMessage = false;
    this.userId_bye659$_0 = userId;
    this.score_1hnt9b$_0 = score;
    this.inlineMessageId_z1zgrs$_0 = inlineMessageId;
    this.force_4ha4wq$_0 = force;
    this.disableEditMessage_u4oguq$_0 = disableEditMessage;
  }
  Object.defineProperty(SetGameScoreByInlineMessageId.prototype, 'userId', {
    get: function () {
      return this.userId_bye659$_0;
    }
  });
  Object.defineProperty(SetGameScoreByInlineMessageId.prototype, 'score', {
    get: function () {
      return this.score_1hnt9b$_0;
    }
  });
  Object.defineProperty(SetGameScoreByInlineMessageId.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_z1zgrs$_0;
    }
  });
  Object.defineProperty(SetGameScoreByInlineMessageId.prototype, 'force', {
    get: function () {
      return this.force_4ha4wq$_0;
    }
  });
  Object.defineProperty(SetGameScoreByInlineMessageId.prototype, 'disableEditMessage', {
    get: function () {
      return this.disableEditMessage_u4oguq$_0;
    }
  });
  Object.defineProperty(SetGameScoreByInlineMessageId.prototype, 'requestSerializer', {
    get: function () {
      return SetGameScoreByInlineMessageId$Companion_getInstance().serializer();
    }
  });
  function SetGameScoreByInlineMessageId$Companion() {
    SetGameScoreByInlineMessageId$Companion_instance = this;
  }
  SetGameScoreByInlineMessageId$Companion.prototype.serializer = function () {
    return SetGameScoreByInlineMessageId$$serializer_getInstance();
  };
  SetGameScoreByInlineMessageId$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SetGameScoreByInlineMessageId$Companion_instance = null;
  function SetGameScoreByInlineMessageId$Companion_getInstance() {
    if (SetGameScoreByInlineMessageId$Companion_instance === null) {
      new SetGameScoreByInlineMessageId$Companion();
    }
    return SetGameScoreByInlineMessageId$Companion_instance;
  }
  function SetGameScoreByInlineMessageId$$serializer() {
    this.descriptor_q15wv8$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.games.SetGameScoreByInlineMessageId', this);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('score', false);
    this.descriptor.addElement_ivxn3r$('inline_message_id', false);
    this.descriptor.addElement_ivxn3r$('force', true);
    this.descriptor.addElement_ivxn3r$('disable_edit_message', true);
    SetGameScoreByInlineMessageId$$serializer_instance = this;
  }
  Object.defineProperty(SetGameScoreByInlineMessageId$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_q15wv8$_0;
    }
  });
  SetGameScoreByInlineMessageId$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.userId);
    output.encodeLongElement_a3zgoj$(this.descriptor, 1, obj.score);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.inlineMessageId);
    if (!equals(obj.force, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 3, obj.force);
    if (!equals(obj.disableEditMessage, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 4, obj.disableEditMessage);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SetGameScoreByInlineMessageId$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeLongElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SetGameScoreByInlineMessageId_init(bitMask0, local0, local1, local2, local3, local4, null);
  };
  SetGameScoreByInlineMessageId$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.LongSerializer, internal.StringSerializer, internal.BooleanSerializer, internal.BooleanSerializer];
  };
  SetGameScoreByInlineMessageId$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SetGameScoreByInlineMessageId$$serializer_instance = null;
  function SetGameScoreByInlineMessageId$$serializer_getInstance() {
    if (SetGameScoreByInlineMessageId$$serializer_instance === null) {
      new SetGameScoreByInlineMessageId$$serializer();
    }
    return SetGameScoreByInlineMessageId$$serializer_instance;
  }
  function SetGameScoreByInlineMessageId_init(seen1, userId, score, inlineMessageId, force, disableEditMessage, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SetGameScoreByInlineMessageId.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_bye659$_0 = userId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('score');
    else
      $this.score_1hnt9b$_0 = score;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('inline_message_id');
    else
      $this.inlineMessageId_z1zgrs$_0 = inlineMessageId;
    if ((seen1 & 8) === 0)
      $this.force_4ha4wq$_0 = false;
    else
      $this.force_4ha4wq$_0 = force;
    if ((seen1 & 16) === 0)
      $this.disableEditMessage_u4oguq$_0 = false;
    else
      $this.disableEditMessage_u4oguq$_0 = disableEditMessage;
    return $this;
  }
  SetGameScoreByInlineMessageId.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SetGameScoreByInlineMessageId',
    interfaces: [InlineMessageAction, SetGameScore]
  };
  SetGameScoreByInlineMessageId.prototype.component1 = function () {
    return this.userId;
  };
  SetGameScoreByInlineMessageId.prototype.component2 = function () {
    return this.score;
  };
  SetGameScoreByInlineMessageId.prototype.component3 = function () {
    return this.inlineMessageId;
  };
  SetGameScoreByInlineMessageId.prototype.component4 = function () {
    return this.force;
  };
  SetGameScoreByInlineMessageId.prototype.component5 = function () {
    return this.disableEditMessage;
  };
  SetGameScoreByInlineMessageId.prototype.copy_ensgwh$ = function (userId, score, inlineMessageId, force, disableEditMessage) {
    return new SetGameScoreByInlineMessageId(userId === void 0 ? this.userId : userId, score === void 0 ? this.score : score, inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, force === void 0 ? this.force : force, disableEditMessage === void 0 ? this.disableEditMessage : disableEditMessage);
  };
  SetGameScoreByInlineMessageId.prototype.toString = function () {
    return 'SetGameScoreByInlineMessageId(userId=' + Kotlin.toString(this.userId) + (', score=' + Kotlin.toString(this.score)) + (', inlineMessageId=' + Kotlin.toString(this.inlineMessageId)) + (', force=' + Kotlin.toString(this.force)) + (', disableEditMessage=' + Kotlin.toString(this.disableEditMessage)) + ')';
  };
  SetGameScoreByInlineMessageId.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.score) | 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.force) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableEditMessage) | 0;
    return result;
  };
  SetGameScoreByInlineMessageId.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.score, other.score) && Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.force, other.force) && Kotlin.equals(this.disableEditMessage, other.disableEditMessage)))));
  };
  function GetGameHighScores() {
  }
  GetGameHighScores.prototype.method = function () {
    return 'getGameHighScores';
  };
  Object.defineProperty(GetGameHighScores.prototype, 'resultDeserializer', {
    get: function () {
      return GameHighScoresSerializer_getInstance();
    }
  });
  GetGameHighScores.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'GetGameHighScores',
    interfaces: [SimpleRequest]
  };
  function GameHighScoresSerializer() {
    GameHighScoresSerializer_instance = this;
    this.$delegate_usrftt$_0 = new ArrayListSerializer(GameHighScore$Companion_getInstance().serializer());
  }
  Object.defineProperty(GameHighScoresSerializer.prototype, 'descriptor', {
    get: function () {
      return this.$delegate_usrftt$_0.descriptor;
    }
  });
  GameHighScoresSerializer.prototype.deserialize_nts5qn$ = function (decoder) {
    return this.$delegate_usrftt$_0.deserialize_nts5qn$(decoder);
  };
  GameHighScoresSerializer.prototype.patch_mynpiu$ = function (decoder, old) {
    return this.$delegate_usrftt$_0.patch_mynpiu$(decoder, old);
  };
  GameHighScoresSerializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    return this.$delegate_usrftt$_0.serialize_awe97i$(encoder, obj);
  };
  GameHighScoresSerializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'GameHighScoresSerializer',
    interfaces: [KSerializer]
  };
  var GameHighScoresSerializer_instance = null;
  function GameHighScoresSerializer_getInstance() {
    if (GameHighScoresSerializer_instance === null) {
      new GameHighScoresSerializer();
    }
    return GameHighScoresSerializer_instance;
  }
  function SetGameScore() {
  }
  SetGameScore.prototype.method = function () {
    return 'setGameScore';
  };
  Object.defineProperty(SetGameScore.prototype, 'resultDeserializer', {
    get: function () {
      return serializer(kotlin_js_internal_BooleanCompanionObject);
    }
  });
  SetGameScore.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SetGameScore',
    interfaces: [SimpleRequest]
  };
  function GetFile(fileId) {
    GetFile$Companion_getInstance();
    this.fileId = fileId;
  }
  GetFile.prototype.method = function () {
    return 'getFile';
  };
  Object.defineProperty(GetFile.prototype, 'resultDeserializer', {
    get: function () {
      return PathedFile$Companion_getInstance().serializer();
    }
  });
  Object.defineProperty(GetFile.prototype, 'requestSerializer', {
    get: function () {
      return GetFile$Companion_getInstance().serializer();
    }
  });
  function GetFile$Companion() {
    GetFile$Companion_instance = this;
  }
  GetFile$Companion.prototype.serializer = function () {
    return GetFile$$serializer_getInstance();
  };
  GetFile$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetFile$Companion_instance = null;
  function GetFile$Companion_getInstance() {
    if (GetFile$Companion_instance === null) {
      new GetFile$Companion();
    }
    return GetFile$Companion_instance;
  }
  function GetFile$$serializer() {
    this.descriptor_3z4fhr$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.get.GetFile', this);
    this.descriptor.addElement_ivxn3r$('file_id', false);
    GetFile$$serializer_instance = this;
  }
  Object.defineProperty(GetFile$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_3z4fhr$_0;
    }
  });
  GetFile$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, InputFileSerializer_getInstance(), obj.fileId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetFile$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, InputFileSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, InputFileSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetFile_init(bitMask0, local0, null);
  };
  GetFile$$serializer.prototype.childSerializers = function () {
    return [InputFileSerializer_getInstance()];
  };
  GetFile$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetFile$$serializer_instance = null;
  function GetFile$$serializer_getInstance() {
    if (GetFile$$serializer_instance === null) {
      new GetFile$$serializer();
    }
    return GetFile$$serializer_instance;
  }
  function GetFile_init(seen1, fileId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetFile.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('file_id');
    else
      $this.fileId = fileId;
    return $this;
  }
  GetFile.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetFile',
    interfaces: [SimpleRequest]
  };
  GetFile.prototype.component1 = function () {
    return this.fileId;
  };
  GetFile.prototype.copy_qk7lt0$ = function (fileId) {
    return new GetFile(fileId === void 0 ? this.fileId : fileId);
  };
  GetFile.prototype.toString = function () {
    return 'GetFile(fileId=' + Kotlin.toString(this.fileId) + ')';
  };
  GetFile.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.fileId) | 0;
    return result;
  };
  GetFile.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.fileId, other.fileId))));
  };
  function GetStickerSet(name) {
    GetStickerSet$Companion_getInstance();
    this.name = name;
  }
  GetStickerSet.prototype.method = function () {
    return 'getStickerSet';
  };
  Object.defineProperty(GetStickerSet.prototype, 'resultDeserializer', {
    get: function () {
      return StickerSet$Companion_getInstance().serializer();
    }
  });
  Object.defineProperty(GetStickerSet.prototype, 'requestSerializer', {
    get: function () {
      return GetStickerSet$Companion_getInstance().serializer();
    }
  });
  function GetStickerSet$Companion() {
    GetStickerSet$Companion_instance = this;
  }
  GetStickerSet$Companion.prototype.serializer = function () {
    return GetStickerSet$$serializer_getInstance();
  };
  GetStickerSet$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetStickerSet$Companion_instance = null;
  function GetStickerSet$Companion_getInstance() {
    if (GetStickerSet$Companion_instance === null) {
      new GetStickerSet$Companion();
    }
    return GetStickerSet$Companion_instance;
  }
  function GetStickerSet$$serializer() {
    this.descriptor_lsmqu0$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.get.GetStickerSet', this);
    this.descriptor.addElement_ivxn3r$('set_name', false);
    GetStickerSet$$serializer_instance = this;
  }
  Object.defineProperty(GetStickerSet$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_lsmqu0$_0;
    }
  });
  GetStickerSet$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.name);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetStickerSet$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetStickerSet_init(bitMask0, local0, null);
  };
  GetStickerSet$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer];
  };
  GetStickerSet$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetStickerSet$$serializer_instance = null;
  function GetStickerSet$$serializer_getInstance() {
    if (GetStickerSet$$serializer_instance === null) {
      new GetStickerSet$$serializer();
    }
    return GetStickerSet$$serializer_instance;
  }
  function GetStickerSet_init(seen1, name, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetStickerSet.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('set_name');
    else
      $this.name = name;
    return $this;
  }
  GetStickerSet.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetStickerSet',
    interfaces: [SimpleRequest]
  };
  GetStickerSet.prototype.component1 = function () {
    return this.name;
  };
  GetStickerSet.prototype.copy_61zpoe$ = function (name) {
    return new GetStickerSet(name === void 0 ? this.name : name);
  };
  GetStickerSet.prototype.toString = function () {
    return 'GetStickerSet(name=' + Kotlin.toString(this.name) + ')';
  };
  GetStickerSet.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    return result;
  };
  GetStickerSet.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.name, other.name))));
  };
  function GetUserProfilePhotos(userId, offset, limit) {
    GetUserProfilePhotos$Companion_getInstance();
    if (offset === void 0)
      offset = null;
    if (limit === void 0)
      limit = null;
    this.userId = userId;
    this.offset = offset;
    this.limit = limit;
    if (this.offset != null && this.offset < 0) {
      throw IllegalArgumentException_init('Offset for getting user profile photos must be positive');
    }
    if (this.limit != null && !userProfilePhotosRequestLimit.contains_mef7kx$(this.limit)) {
      throw IllegalArgumentException_init('Limit for getting user profile photos must be in 0 .. 100 range');
    }
  }
  GetUserProfilePhotos.prototype.method = function () {
    return 'getUserProfilePhotos';
  };
  Object.defineProperty(GetUserProfilePhotos.prototype, 'resultDeserializer', {
    get: function () {
      return UserProfilePhotos$Companion_getInstance().serializer();
    }
  });
  Object.defineProperty(GetUserProfilePhotos.prototype, 'requestSerializer', {
    get: function () {
      return GetUserProfilePhotos$Companion_getInstance().serializer();
    }
  });
  function GetUserProfilePhotos$Companion() {
    GetUserProfilePhotos$Companion_instance = this;
  }
  GetUserProfilePhotos$Companion.prototype.serializer = function () {
    return GetUserProfilePhotos$$serializer_getInstance();
  };
  GetUserProfilePhotos$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetUserProfilePhotos$Companion_instance = null;
  function GetUserProfilePhotos$Companion_getInstance() {
    if (GetUserProfilePhotos$Companion_instance === null) {
      new GetUserProfilePhotos$Companion();
    }
    return GetUserProfilePhotos$Companion_instance;
  }
  function GetUserProfilePhotos$$serializer() {
    this.descriptor_dunuqe$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.get.GetUserProfilePhotos', this);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('offset', true);
    this.descriptor.addElement_ivxn3r$('limit', true);
    GetUserProfilePhotos$$serializer_instance = this;
  }
  Object.defineProperty(GetUserProfilePhotos$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_dunuqe$_0;
    }
  });
  GetUserProfilePhotos$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.userId);
    if (!equals(obj.offset, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.IntSerializer, obj.offset);
    if (!equals(obj.limit, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.IntSerializer, obj.limit);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetUserProfilePhotos$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.IntSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.IntSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetUserProfilePhotos_init(bitMask0, local0, local1, local2, null);
  };
  GetUserProfilePhotos$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), new NullableSerializer(internal.IntSerializer), new NullableSerializer(internal.IntSerializer)];
  };
  GetUserProfilePhotos$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetUserProfilePhotos$$serializer_instance = null;
  function GetUserProfilePhotos$$serializer_getInstance() {
    if (GetUserProfilePhotos$$serializer_instance === null) {
      new GetUserProfilePhotos$$serializer();
    }
    return GetUserProfilePhotos$$serializer_instance;
  }
  function GetUserProfilePhotos_init(seen1, userId, offset, limit, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetUserProfilePhotos.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId = userId;
    if ((seen1 & 2) === 0)
      $this.offset = null;
    else
      $this.offset = offset;
    if ((seen1 & 4) === 0)
      $this.limit = null;
    else
      $this.limit = limit;
    if ($this.offset != null && $this.offset < 0) {
      throw IllegalArgumentException_init('Offset for getting user profile photos must be positive');
    }
    if ($this.limit != null && !userProfilePhotosRequestLimit.contains_mef7kx$($this.limit)) {
      throw IllegalArgumentException_init('Limit for getting user profile photos must be in 0 .. 100 range');
    }
    return $this;
  }
  GetUserProfilePhotos.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetUserProfilePhotos',
    interfaces: [SimpleRequest]
  };
  GetUserProfilePhotos.prototype.component1 = function () {
    return this.userId;
  };
  GetUserProfilePhotos.prototype.component2 = function () {
    return this.offset;
  };
  GetUserProfilePhotos.prototype.component3 = function () {
    return this.limit;
  };
  GetUserProfilePhotos.prototype.copy_nhrjss$ = function (userId, offset, limit) {
    return new GetUserProfilePhotos(userId === void 0 ? this.userId : userId, offset === void 0 ? this.offset : offset, limit === void 0 ? this.limit : limit);
  };
  GetUserProfilePhotos.prototype.toString = function () {
    return 'GetUserProfilePhotos(userId=' + Kotlin.toString(this.userId) + (', offset=' + Kotlin.toString(this.offset)) + (', limit=' + Kotlin.toString(this.limit)) + ')';
  };
  GetUserProfilePhotos.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.offset) | 0;
    result = result * 31 + Kotlin.hashCode(this.limit) | 0;
    return result;
  };
  GetUserProfilePhotos.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.offset, other.offset) && Kotlin.equals(this.limit, other.limit)))));
  };
  function SendAction(chatId, action) {
    SendAction$Companion_getInstance();
    this.chatId_og99t9$_0 = chatId;
    this.action = action;
  }
  Object.defineProperty(SendAction.prototype, 'chatId', {
    get: function () {
      return this.chatId_og99t9$_0;
    }
  });
  SendAction.prototype.method = function () {
    return 'sendChatAction';
  };
  Object.defineProperty(SendAction.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(SendAction.prototype, 'requestSerializer', {
    get: function () {
      return SendAction$Companion_getInstance().serializer();
    }
  });
  function SendAction$Companion() {
    SendAction$Companion_instance = this;
  }
  SendAction$Companion.prototype.serializer = function () {
    return SendAction$$serializer_getInstance();
  };
  SendAction$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendAction$Companion_instance = null;
  function SendAction$Companion_getInstance() {
    if (SendAction$Companion_instance === null) {
      new SendAction$Companion();
    }
    return SendAction$Companion_instance;
  }
  function SendAction$$serializer() {
    this.descriptor_wgm6op$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendAction', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('action', false);
    SendAction$$serializer_instance = this;
  }
  Object.defineProperty(SendAction$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_wgm6op$_0;
    }
  });
  SendAction$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, BotActionSerializer_getInstance(), obj.action);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendAction$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, BotActionSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, BotActionSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendAction_init(bitMask0, local0, local1, null);
  };
  SendAction$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), BotActionSerializer_getInstance()];
  };
  SendAction$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendAction$$serializer_instance = null;
  function SendAction$$serializer_getInstance() {
    if (SendAction$$serializer_instance === null) {
      new SendAction$$serializer();
    }
    return SendAction$$serializer_instance;
  }
  function SendAction_init(seen1, chatId, action, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SendAction.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_og99t9$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('action');
    else
      $this.action = action;
    return $this;
  }
  SendAction.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendAction',
    interfaces: [SendChatMessageRequest]
  };
  SendAction.prototype.component1 = function () {
    return this.chatId;
  };
  SendAction.prototype.component2 = function () {
    return this.action;
  };
  SendAction.prototype.copy_6547k7$ = function (chatId, action) {
    return new SendAction(chatId === void 0 ? this.chatId : chatId, action === void 0 ? this.action : action);
  };
  SendAction.prototype.toString = function () {
    return 'SendAction(chatId=' + Kotlin.toString(this.chatId) + (', action=' + Kotlin.toString(this.action)) + ')';
  };
  SendAction.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.action) | 0;
    return result;
  };
  SendAction.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.action, other.action)))));
  };
  var commonResultDeserializer_2;
  function SendContact(chatId, phoneNumber, firstName, lastName, disableNotification, replyToMessageId, replyMarkup) {
    SendContact$Companion_getInstance();
    if (lastName === void 0)
      lastName = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_7mav6j$_0 = chatId;
    this.phoneNumber = phoneNumber;
    this.firstName = firstName;
    this.lastName = lastName;
    this.disableNotification_5klwdp$_0 = disableNotification;
    this.replyToMessageId_rqb1zj$_0 = replyToMessageId;
    this.replyMarkup_ypv0gc$_0 = replyMarkup;
  }
  Object.defineProperty(SendContact.prototype, 'chatId', {
    get: function () {
      return this.chatId_7mav6j$_0;
    }
  });
  Object.defineProperty(SendContact.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_5klwdp$_0;
    }
  });
  Object.defineProperty(SendContact.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_rqb1zj$_0;
    }
  });
  Object.defineProperty(SendContact.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_ypv0gc$_0;
    }
  });
  SendContact.prototype.method = function () {
    return 'sendContact';
  };
  Object.defineProperty(SendContact.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_2;
    }
  });
  Object.defineProperty(SendContact.prototype, 'requestSerializer', {
    get: function () {
      return SendContact$Companion_getInstance().serializer();
    }
  });
  function SendContact$Companion() {
    SendContact$Companion_instance = this;
  }
  SendContact$Companion.prototype.serializer = function () {
    return SendContact$$serializer_getInstance();
  };
  SendContact$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendContact$Companion_instance = null;
  function SendContact$Companion_getInstance() {
    if (SendContact$Companion_instance === null) {
      new SendContact$Companion();
    }
    return SendContact$Companion_instance;
  }
  function SendContact$$serializer() {
    this.descriptor_7zk1jb$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendContact', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('phone_number', false);
    this.descriptor.addElement_ivxn3r$('first_name', false);
    this.descriptor.addElement_ivxn3r$('last_name', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendContact$$serializer_instance = this;
  }
  Object.defineProperty(SendContact$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_7zk1jb$_0;
    }
  });
  SendContact$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.phoneNumber);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.firstName);
    if (!equals(obj.lastName, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.lastName);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 4, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendContact$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.LongSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance(), local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendContact_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, null);
  };
  SendContact$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer, internal.StringSerializer, new NullableSerializer(internal.StringSerializer), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendContact$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendContact$$serializer_instance = null;
  function SendContact$$serializer_getInstance() {
    if (SendContact$$serializer_instance === null) {
      new SendContact$$serializer();
    }
    return SendContact$$serializer_instance;
  }
  function SendContact_init(seen1, chatId, phoneNumber, firstName, lastName, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SendContact.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_7mav6j$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('phone_number');
    else
      $this.phoneNumber = phoneNumber;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('first_name');
    else
      $this.firstName = firstName;
    if ((seen1 & 8) === 0)
      $this.lastName = null;
    else
      $this.lastName = lastName;
    if ((seen1 & 16) === 0)
      $this.disableNotification_5klwdp$_0 = false;
    else
      $this.disableNotification_5klwdp$_0 = disableNotification;
    if ((seen1 & 32) === 0)
      $this.replyToMessageId_rqb1zj$_0 = null;
    else
      $this.replyToMessageId_rqb1zj$_0 = replyToMessageId;
    if ((seen1 & 64) === 0)
      $this.replyMarkup_ypv0gc$_0 = null;
    else
      $this.replyMarkup_ypv0gc$_0 = replyMarkup;
    return $this;
  }
  SendContact.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendContact',
    interfaces: [ReplyingMarkupSendMessageRequest, SendMessageRequest]
  };
  function SendContact_init_0(chatId, contact, disableNotification, replyToMessageId, replyMarkup, $this) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    $this = $this || Object.create(SendContact.prototype);
    SendContact.call($this, chatId, contact.phoneNumber, contact.firstName, contact.lastName, disableNotification, replyToMessageId, replyMarkup);
    return $this;
  }
  SendContact.prototype.component1 = function () {
    return this.chatId;
  };
  SendContact.prototype.component2 = function () {
    return this.phoneNumber;
  };
  SendContact.prototype.component3 = function () {
    return this.firstName;
  };
  SendContact.prototype.component4 = function () {
    return this.lastName;
  };
  SendContact.prototype.component5 = function () {
    return this.disableNotification;
  };
  SendContact.prototype.component6 = function () {
    return this.replyToMessageId;
  };
  SendContact.prototype.component7 = function () {
    return this.replyMarkup;
  };
  SendContact.prototype.copy_czt7kk$ = function (chatId, phoneNumber, firstName, lastName, disableNotification, replyToMessageId, replyMarkup) {
    return new SendContact(chatId === void 0 ? this.chatId : chatId, phoneNumber === void 0 ? this.phoneNumber : phoneNumber, firstName === void 0 ? this.firstName : firstName, lastName === void 0 ? this.lastName : lastName, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendContact.prototype.toString = function () {
    return 'SendContact(chatId=' + Kotlin.toString(this.chatId) + (', phoneNumber=' + Kotlin.toString(this.phoneNumber)) + (', firstName=' + Kotlin.toString(this.firstName)) + (', lastName=' + Kotlin.toString(this.lastName)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendContact.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.phoneNumber) | 0;
    result = result * 31 + Kotlin.hashCode(this.firstName) | 0;
    result = result * 31 + Kotlin.hashCode(this.lastName) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendContact.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.phoneNumber, other.phoneNumber) && Kotlin.equals(this.firstName, other.firstName) && Kotlin.equals(this.lastName, other.lastName) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function toRequest($receiver, chatId, disableNotification, replyToMessageId, replyMarkup) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return SendContact_init_0(chatId, $receiver, disableNotification, replyToMessageId, replyMarkup);
  }
  var commonResultDeserializer_3;
  function SendLocation(chatId, latitude, longitude, livePeriod, disableNotification, replyToMessageId, replyMarkup) {
    SendLocation$Companion_getInstance();
    if (livePeriod === void 0)
      livePeriod = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_kqomqc$_0 = chatId;
    this.latitude_r10aod$_0 = latitude;
    this.longitude_rs9gti$_0 = longitude;
    this.livePeriod = livePeriod;
    this.disableNotification_75mivy$_0 = disableNotification;
    this.replyToMessageId_22448y$_0 = replyToMessageId;
    this.replyMarkup_rcysxv$_0 = replyMarkup;
  }
  Object.defineProperty(SendLocation.prototype, 'chatId', {
    get: function () {
      return this.chatId_kqomqc$_0;
    }
  });
  Object.defineProperty(SendLocation.prototype, 'latitude', {
    get: function () {
      return this.latitude_r10aod$_0;
    }
  });
  Object.defineProperty(SendLocation.prototype, 'longitude', {
    get: function () {
      return this.longitude_rs9gti$_0;
    }
  });
  Object.defineProperty(SendLocation.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_75mivy$_0;
    }
  });
  Object.defineProperty(SendLocation.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_22448y$_0;
    }
  });
  Object.defineProperty(SendLocation.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_rcysxv$_0;
    }
  });
  SendLocation.prototype.method = function () {
    return 'sendLocation';
  };
  Object.defineProperty(SendLocation.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_3;
    }
  });
  Object.defineProperty(SendLocation.prototype, 'requestSerializer', {
    get: function () {
      return SendLocation$Companion_getInstance().serializer();
    }
  });
  function SendLocation$Companion() {
    SendLocation$Companion_instance = this;
  }
  SendLocation$Companion.prototype.serializer = function () {
    return SendLocation$$serializer_getInstance();
  };
  SendLocation$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendLocation$Companion_instance = null;
  function SendLocation$Companion_getInstance() {
    if (SendLocation$Companion_instance === null) {
      new SendLocation$Companion();
    }
    return SendLocation$Companion_instance;
  }
  function SendLocation$$serializer() {
    this.descriptor_ay0n8o$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendLocation', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('latitude', false);
    this.descriptor.addElement_ivxn3r$('longitude', false);
    this.descriptor.addElement_ivxn3r$('live_period', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendLocation$$serializer_instance = this;
  }
  Object.defineProperty(SendLocation$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_ay0n8o$_0;
    }
  });
  SendLocation$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeDoubleElement_imzr5k$(this.descriptor, 1, obj.latitude);
    output.encodeDoubleElement_imzr5k$(this.descriptor, 2, obj.longitude);
    if (!equals(obj.livePeriod, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.LongSerializer, obj.livePeriod);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 4, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendLocation$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeDoubleElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeDoubleElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.LongSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.LongSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance(), local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendLocation_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, null);
  };
  SendLocation$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.DoubleSerializer, internal.DoubleSerializer, new NullableSerializer(internal.LongSerializer), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendLocation$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendLocation$$serializer_instance = null;
  function SendLocation$$serializer_getInstance() {
    if (SendLocation$$serializer_instance === null) {
      new SendLocation$$serializer();
    }
    return SendLocation$$serializer_instance;
  }
  function SendLocation_init(seen1, chatId, latitude, longitude, livePeriod, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SendLocation.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_kqomqc$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('latitude');
    else
      $this.latitude_r10aod$_0 = latitude;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('longitude');
    else
      $this.longitude_rs9gti$_0 = longitude;
    if ((seen1 & 8) === 0)
      $this.livePeriod = null;
    else
      $this.livePeriod = livePeriod;
    if ((seen1 & 16) === 0)
      $this.disableNotification_75mivy$_0 = false;
    else
      $this.disableNotification_75mivy$_0 = disableNotification;
    if ((seen1 & 32) === 0)
      $this.replyToMessageId_22448y$_0 = null;
    else
      $this.replyToMessageId_22448y$_0 = replyToMessageId;
    if ((seen1 & 64) === 0)
      $this.replyMarkup_rcysxv$_0 = null;
    else
      $this.replyMarkup_rcysxv$_0 = replyMarkup;
    return $this;
  }
  SendLocation.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendLocation',
    interfaces: [PositionedSendMessageRequest, ReplyingMarkupSendMessageRequest, SendMessageRequest]
  };
  SendLocation.prototype.component1 = function () {
    return this.chatId;
  };
  SendLocation.prototype.component2 = function () {
    return this.latitude;
  };
  SendLocation.prototype.component3 = function () {
    return this.longitude;
  };
  SendLocation.prototype.component4 = function () {
    return this.livePeriod;
  };
  SendLocation.prototype.component5 = function () {
    return this.disableNotification;
  };
  SendLocation.prototype.component6 = function () {
    return this.replyToMessageId;
  };
  SendLocation.prototype.component7 = function () {
    return this.replyMarkup;
  };
  SendLocation.prototype.copy_7zo7$ = function (chatId, latitude, longitude, livePeriod, disableNotification, replyToMessageId, replyMarkup) {
    return new SendLocation(chatId === void 0 ? this.chatId : chatId, latitude === void 0 ? this.latitude : latitude, longitude === void 0 ? this.longitude : longitude, livePeriod === void 0 ? this.livePeriod : livePeriod, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendLocation.prototype.toString = function () {
    return 'SendLocation(chatId=' + Kotlin.toString(this.chatId) + (', latitude=' + Kotlin.toString(this.latitude)) + (', longitude=' + Kotlin.toString(this.longitude)) + (', livePeriod=' + Kotlin.toString(this.livePeriod)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendLocation.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.latitude) | 0;
    result = result * 31 + Kotlin.hashCode(this.longitude) | 0;
    result = result * 31 + Kotlin.hashCode(this.livePeriod) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendLocation.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.latitude, other.latitude) && Kotlin.equals(this.longitude, other.longitude) && Kotlin.equals(this.livePeriod, other.livePeriod) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  var TextContentMessageResultDeserializer;
  function SendTextMessage(chatId, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup) {
    SendTextMessage$Companion_getInstance();
    if (parseMode === void 0)
      parseMode = null;
    if (disableWebPagePreview === void 0)
      disableWebPagePreview = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_vw9vth$_0 = chatId;
    this.text_py429x$_0 = text;
    this.parseMode_6f280a$_0 = parseMode;
    this.disableWebPagePreview_9fxx1d$_0 = disableWebPagePreview;
    this.disableNotification_7wl6g7$_0 = disableNotification;
    this.replyToMessageId_oqkre3$_0 = replyToMessageId;
    this.replyMarkup_rhwo92$_0 = replyMarkup;
    if (!textLength.contains_mef7kx$(this.text.length)) {
      throw IllegalArgumentException_init('Text must be in ' + textLength + ' range');
    }
  }
  Object.defineProperty(SendTextMessage.prototype, 'chatId', {
    get: function () {
      return this.chatId_vw9vth$_0;
    }
  });
  Object.defineProperty(SendTextMessage.prototype, 'text', {
    get: function () {
      return this.text_py429x$_0;
    }
  });
  Object.defineProperty(SendTextMessage.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_6f280a$_0;
    }
  });
  Object.defineProperty(SendTextMessage.prototype, 'disableWebPagePreview', {
    get: function () {
      return this.disableWebPagePreview_9fxx1d$_0;
    }
  });
  Object.defineProperty(SendTextMessage.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_7wl6g7$_0;
    }
  });
  Object.defineProperty(SendTextMessage.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_oqkre3$_0;
    }
  });
  Object.defineProperty(SendTextMessage.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_rhwo92$_0;
    }
  });
  SendTextMessage.prototype.method = function () {
    return 'sendMessage';
  };
  Object.defineProperty(SendTextMessage.prototype, 'resultDeserializer', {
    get: function () {
      return TextContentMessageResultDeserializer;
    }
  });
  Object.defineProperty(SendTextMessage.prototype, 'requestSerializer', {
    get: function () {
      return SendTextMessage$Companion_getInstance().serializer();
    }
  });
  function SendTextMessage$Companion() {
    SendTextMessage$Companion_instance = this;
  }
  SendTextMessage$Companion.prototype.serializer = function () {
    return SendTextMessage$$serializer_getInstance();
  };
  SendTextMessage$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendTextMessage$Companion_instance = null;
  function SendTextMessage$Companion_getInstance() {
    if (SendTextMessage$Companion_instance === null) {
      new SendTextMessage$Companion();
    }
    return SendTextMessage$Companion_instance;
  }
  function SendTextMessage$$serializer() {
    this.descriptor_jk81fj$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendTextMessage', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('text', false);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('disable_web_page_preview', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendTextMessage$$serializer_instance = this;
  }
  Object.defineProperty(SendTextMessage$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_jk81fj$_0;
    }
  });
  SendTextMessage$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.disableWebPagePreview, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.BooleanSerializer, obj.disableWebPagePreview);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 4, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendTextMessage$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, ParseModeSerializerObject_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.BooleanSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.LongSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance(), local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendTextMessage_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, null);
  };
  SendTextMessage$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer, new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(internal.BooleanSerializer), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendTextMessage$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendTextMessage$$serializer_instance = null;
  function SendTextMessage$$serializer_getInstance() {
    if (SendTextMessage$$serializer_instance === null) {
      new SendTextMessage$$serializer();
    }
    return SendTextMessage$$serializer_instance;
  }
  function SendTextMessage_init(seen1, chatId, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SendTextMessage.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_vw9vth$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('text');
    else
      $this.text_py429x$_0 = text;
    if ((seen1 & 4) === 0)
      $this.parseMode_6f280a$_0 = null;
    else
      $this.parseMode_6f280a$_0 = parseMode;
    if ((seen1 & 8) === 0)
      $this.disableWebPagePreview_9fxx1d$_0 = null;
    else
      $this.disableWebPagePreview_9fxx1d$_0 = disableWebPagePreview;
    if ((seen1 & 16) === 0)
      $this.disableNotification_7wl6g7$_0 = false;
    else
      $this.disableNotification_7wl6g7$_0 = disableNotification;
    if ((seen1 & 32) === 0)
      $this.replyToMessageId_oqkre3$_0 = null;
    else
      $this.replyToMessageId_oqkre3$_0 = replyToMessageId;
    if ((seen1 & 64) === 0)
      $this.replyMarkup_rhwo92$_0 = null;
    else
      $this.replyMarkup_rhwo92$_0 = replyMarkup;
    if (!textLength.contains_mef7kx$($this.text.length)) {
      throw IllegalArgumentException_init('Text must be in ' + textLength + ' range');
    }
    return $this;
  }
  SendTextMessage.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendTextMessage',
    interfaces: [DisableWebPagePreview, TextableSendMessageRequest, ReplyingMarkupSendMessageRequest, SendMessageRequest]
  };
  SendTextMessage.prototype.component1 = function () {
    return this.chatId;
  };
  SendTextMessage.prototype.component2 = function () {
    return this.text;
  };
  SendTextMessage.prototype.component3 = function () {
    return this.parseMode;
  };
  SendTextMessage.prototype.component4 = function () {
    return this.disableWebPagePreview;
  };
  SendTextMessage.prototype.component5 = function () {
    return this.disableNotification;
  };
  SendTextMessage.prototype.component6 = function () {
    return this.replyToMessageId;
  };
  SendTextMessage.prototype.component7 = function () {
    return this.replyMarkup;
  };
  SendTextMessage.prototype.copy_ss5ccn$ = function (chatId, text, parseMode, disableWebPagePreview, disableNotification, replyToMessageId, replyMarkup) {
    return new SendTextMessage(chatId === void 0 ? this.chatId : chatId, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, disableWebPagePreview === void 0 ? this.disableWebPagePreview : disableWebPagePreview, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendTextMessage.prototype.toString = function () {
    return 'SendTextMessage(chatId=' + Kotlin.toString(this.chatId) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', disableWebPagePreview=' + Kotlin.toString(this.disableWebPagePreview)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendTextMessage.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableWebPagePreview) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendTextMessage.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.disableWebPagePreview, other.disableWebPagePreview) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  var commonResultDeserializer_4;
  function SendPoll(chatId, question, options, disableNotification, replyToMessageId, replyMarkup) {
    SendPoll$Companion_getInstance();
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_l4ugay$_0 = chatId;
    this.question = question;
    this.options = options;
    this.disableNotification_6k9n2w$_0 = disableNotification;
    this.replyToMessageId_mcik4$_0 = replyToMessageId;
    this.replyMarkup_xmschl$_0 = replyMarkup;
    if (!pollQuestionTextLength.contains_mef7kx$(this.question.length)) {
      throw IllegalArgumentException_init('The length of questions for polls must be in ' + pollQuestionTextLength + ' range, but was ' + this.question.length);
    }
    var tmp$;
    tmp$ = this.options.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (!pollOptionTextLength.contains_mef7kx$(element.length)) {
        throw IllegalArgumentException_init('The length of question option text for polls must be in ' + pollOptionTextLength + ' range, but was ' + element.length);
      }
    }
    if (!pollOptionsLimit.contains_mef7kx$(this.options.size)) {
      throw IllegalArgumentException_init('The amount of question options for polls must be in ' + pollOptionsLimit + ' range, but was ' + this.options.size);
    }
  }
  Object.defineProperty(SendPoll.prototype, 'chatId', {
    get: function () {
      return this.chatId_l4ugay$_0;
    }
  });
  Object.defineProperty(SendPoll.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_6k9n2w$_0;
    }
  });
  Object.defineProperty(SendPoll.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_mcik4$_0;
    }
  });
  Object.defineProperty(SendPoll.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_xmschl$_0;
    }
  });
  SendPoll.prototype.method = function () {
    return 'sendPoll';
  };
  Object.defineProperty(SendPoll.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_4;
    }
  });
  Object.defineProperty(SendPoll.prototype, 'requestSerializer', {
    get: function () {
      return SendPoll$Companion_getInstance().serializer();
    }
  });
  function SendPoll$Companion() {
    SendPoll$Companion_instance = this;
  }
  SendPoll$Companion.prototype.serializer = function () {
    return SendPoll$$serializer_getInstance();
  };
  SendPoll$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendPoll$Companion_instance = null;
  function SendPoll$Companion_getInstance() {
    if (SendPoll$Companion_instance === null) {
      new SendPoll$Companion();
    }
    return SendPoll$Companion_instance;
  }
  function SendPoll$$serializer() {
    this.descriptor_c720m6$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendPoll', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('question', false);
    this.descriptor.addElement_ivxn3r$('options', false);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendPoll$$serializer_instance = this;
  }
  Object.defineProperty(SendPoll$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_c720m6$_0;
    }
  });
  SendPoll$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.question);
    output.encodeSerializableElement_blecud$(this.descriptor, 2, new ArrayListSerializer(internal.StringSerializer), obj.options);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 3, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendPoll$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 2, new ArrayListSerializer(internal.StringSerializer)) : input.updateSerializableElement_ehubvl$(this.descriptor, 2, new ArrayListSerializer(internal.StringSerializer), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.LongSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, KeyboardMarkupSerializer_getInstance(), local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendPoll_init(bitMask0, local0, local1, local2, local3, local4, local5, null);
  };
  SendPoll$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer, new ArrayListSerializer(internal.StringSerializer), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendPoll$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendPoll$$serializer_instance = null;
  function SendPoll$$serializer_getInstance() {
    if (SendPoll$$serializer_instance === null) {
      new SendPoll$$serializer();
    }
    return SendPoll$$serializer_instance;
  }
  function SendPoll_init(seen1, chatId, question, options, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SendPoll.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_l4ugay$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('question');
    else
      $this.question = question;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('options');
    else
      $this.options = options;
    if ((seen1 & 8) === 0)
      $this.disableNotification_6k9n2w$_0 = false;
    else
      $this.disableNotification_6k9n2w$_0 = disableNotification;
    if ((seen1 & 16) === 0)
      $this.replyToMessageId_mcik4$_0 = null;
    else
      $this.replyToMessageId_mcik4$_0 = replyToMessageId;
    if ((seen1 & 32) === 0)
      $this.replyMarkup_xmschl$_0 = null;
    else
      $this.replyMarkup_xmschl$_0 = replyMarkup;
    if (!pollQuestionTextLength.contains_mef7kx$($this.question.length)) {
      throw IllegalArgumentException_init('The length of questions for polls must be in ' + pollQuestionTextLength + ' range, but was ' + $this.question.length);
    }
    var tmp$;
    tmp$ = $this.options.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      if (!pollOptionTextLength.contains_mef7kx$(element.length)) {
        throw IllegalArgumentException_init('The length of question option text for polls must be in ' + pollOptionTextLength + ' range, but was ' + element.length);
      }
    }
    if (!pollOptionsLimit.contains_mef7kx$($this.options.size)) {
      throw IllegalArgumentException_init('The amount of question options for polls must be in ' + pollOptionsLimit + ' range, but was ' + $this.options.size);
    }
    return $this;
  }
  SendPoll.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendPoll',
    interfaces: [ReplyingMarkupSendMessageRequest, SendMessageRequest]
  };
  SendPoll.prototype.component1 = function () {
    return this.chatId;
  };
  SendPoll.prototype.component2 = function () {
    return this.question;
  };
  SendPoll.prototype.component3 = function () {
    return this.options;
  };
  SendPoll.prototype.component4 = function () {
    return this.disableNotification;
  };
  SendPoll.prototype.component5 = function () {
    return this.replyToMessageId;
  };
  SendPoll.prototype.component6 = function () {
    return this.replyMarkup;
  };
  SendPoll.prototype.copy_eqb70k$ = function (chatId, question, options, disableNotification, replyToMessageId, replyMarkup) {
    return new SendPoll(chatId === void 0 ? this.chatId : chatId, question === void 0 ? this.question : question, options === void 0 ? this.options : options, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendPoll.prototype.toString = function () {
    return 'SendPoll(chatId=' + Kotlin.toString(this.chatId) + (', question=' + Kotlin.toString(this.question)) + (', options=' + Kotlin.toString(this.options)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendPoll.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.question) | 0;
    result = result * 31 + Kotlin.hashCode(this.options) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendPoll.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.question, other.question) && Kotlin.equals(this.options, other.options) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  var commonResultDeserializer_5;
  function SendVenue(chatId, latitude, longitude, title, address, foursquareId, disableNotification, replyToMessageId, replyMarkup) {
    SendVenue$Companion_getInstance();
    if (foursquareId === void 0)
      foursquareId = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_cf999m$_0 = chatId;
    this.latitude_mq6awh$_0 = latitude;
    this.longitude_7iguaw$_0 = longitude;
    this.title_pw8i3l$_0 = title;
    this.address = address;
    this.foursquareId = foursquareId;
    this.disableNotification_e0rlp8$_0 = disableNotification;
    this.replyToMessageId_96ltq8$_0 = replyToMessageId;
    this.replyMarkup_8cord1$_0 = replyMarkup;
  }
  Object.defineProperty(SendVenue.prototype, 'chatId', {
    get: function () {
      return this.chatId_cf999m$_0;
    }
  });
  Object.defineProperty(SendVenue.prototype, 'latitude', {
    get: function () {
      return this.latitude_mq6awh$_0;
    }
  });
  Object.defineProperty(SendVenue.prototype, 'longitude', {
    get: function () {
      return this.longitude_7iguaw$_0;
    }
  });
  Object.defineProperty(SendVenue.prototype, 'title', {
    get: function () {
      return this.title_pw8i3l$_0;
    }
  });
  Object.defineProperty(SendVenue.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_e0rlp8$_0;
    }
  });
  Object.defineProperty(SendVenue.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_96ltq8$_0;
    }
  });
  Object.defineProperty(SendVenue.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_8cord1$_0;
    }
  });
  SendVenue.prototype.method = function () {
    return 'sendVenue';
  };
  Object.defineProperty(SendVenue.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_5;
    }
  });
  Object.defineProperty(SendVenue.prototype, 'requestSerializer', {
    get: function () {
      return SendVenue$Companion_getInstance().serializer();
    }
  });
  function SendVenue$Companion() {
    SendVenue$Companion_instance = this;
  }
  SendVenue$Companion.prototype.serializer = function () {
    return SendVenue$$serializer_getInstance();
  };
  SendVenue$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendVenue$Companion_instance = null;
  function SendVenue$Companion_getInstance() {
    if (SendVenue$Companion_instance === null) {
      new SendVenue$Companion();
    }
    return SendVenue$Companion_instance;
  }
  function SendVenue$$serializer() {
    this.descriptor_t21qi2$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.SendVenue', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('latitude', false);
    this.descriptor.addElement_ivxn3r$('longitude', false);
    this.descriptor.addElement_ivxn3r$('title', false);
    this.descriptor.addElement_ivxn3r$('address', false);
    this.descriptor.addElement_ivxn3r$('foursquare_id', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendVenue$$serializer_instance = this;
  }
  Object.defineProperty(SendVenue$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_t21qi2$_0;
    }
  });
  SendVenue$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeDoubleElement_imzr5k$(this.descriptor, 1, obj.latitude);
    output.encodeDoubleElement_imzr5k$(this.descriptor, 2, obj.longitude);
    output.encodeStringElement_bgm7zs$(this.descriptor, 3, obj.title);
    output.encodeStringElement_bgm7zs$(this.descriptor, 4, obj.address);
    if (!equals(obj.foursquareId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.StringSerializer, obj.foursquareId);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 6, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 8, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendVenue$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeDoubleElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeDoubleElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeStringElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeStringElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.StringSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, internal.LongSerializer, local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = (bitMask0 & 256) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 8, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 8, KeyboardMarkupSerializer_getInstance(), local8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendVenue_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, null);
  };
  SendVenue$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.DoubleSerializer, internal.DoubleSerializer, internal.StringSerializer, internal.StringSerializer, new NullableSerializer(internal.StringSerializer), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendVenue$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendVenue$$serializer_instance = null;
  function SendVenue$$serializer_getInstance() {
    if (SendVenue$$serializer_instance === null) {
      new SendVenue$$serializer();
    }
    return SendVenue$$serializer_instance;
  }
  function SendVenue_init(seen1, chatId, latitude, longitude, title, address, foursquareId, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SendVenue.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_cf999m$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('latitude');
    else
      $this.latitude_mq6awh$_0 = latitude;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('longitude');
    else
      $this.longitude_7iguaw$_0 = longitude;
    if ((seen1 & 8) === 0)
      throw new MissingFieldException('title');
    else
      $this.title_pw8i3l$_0 = title;
    if ((seen1 & 16) === 0)
      throw new MissingFieldException('address');
    else
      $this.address = address;
    if ((seen1 & 32) === 0)
      $this.foursquareId = null;
    else
      $this.foursquareId = foursquareId;
    if ((seen1 & 64) === 0)
      $this.disableNotification_e0rlp8$_0 = false;
    else
      $this.disableNotification_e0rlp8$_0 = disableNotification;
    if ((seen1 & 128) === 0)
      $this.replyToMessageId_96ltq8$_0 = null;
    else
      $this.replyToMessageId_96ltq8$_0 = replyToMessageId;
    if ((seen1 & 256) === 0)
      $this.replyMarkup_8cord1$_0 = null;
    else
      $this.replyMarkup_8cord1$_0 = replyMarkup;
    return $this;
  }
  SendVenue.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendVenue',
    interfaces: [ReplyingMarkupSendMessageRequest, TitledSendMessageRequest, PositionedSendMessageRequest, SendMessageRequest]
  };
  function SendVenue_init_0(chatId, venue, disableNotification, replyToMessageId, replyMarkup, $this) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    $this = $this || Object.create(SendVenue.prototype);
    SendVenue.call($this, chatId, venue.location.latitude, venue.location.longitude, venue.title, venue.address, venue.foursquareId, disableNotification, replyToMessageId, replyMarkup);
    return $this;
  }
  SendVenue.prototype.component1 = function () {
    return this.chatId;
  };
  SendVenue.prototype.component2 = function () {
    return this.latitude;
  };
  SendVenue.prototype.component3 = function () {
    return this.longitude;
  };
  SendVenue.prototype.component4 = function () {
    return this.title;
  };
  SendVenue.prototype.component5 = function () {
    return this.address;
  };
  SendVenue.prototype.component6 = function () {
    return this.foursquareId;
  };
  SendVenue.prototype.component7 = function () {
    return this.disableNotification;
  };
  SendVenue.prototype.component8 = function () {
    return this.replyToMessageId;
  };
  SendVenue.prototype.component9 = function () {
    return this.replyMarkup;
  };
  SendVenue.prototype.copy_2oaank$ = function (chatId, latitude, longitude, title, address, foursquareId, disableNotification, replyToMessageId, replyMarkup) {
    return new SendVenue(chatId === void 0 ? this.chatId : chatId, latitude === void 0 ? this.latitude : latitude, longitude === void 0 ? this.longitude : longitude, title === void 0 ? this.title : title, address === void 0 ? this.address : address, foursquareId === void 0 ? this.foursquareId : foursquareId, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendVenue.prototype.toString = function () {
    return 'SendVenue(chatId=' + Kotlin.toString(this.chatId) + (', latitude=' + Kotlin.toString(this.latitude)) + (', longitude=' + Kotlin.toString(this.longitude)) + (', title=' + Kotlin.toString(this.title)) + (', address=' + Kotlin.toString(this.address)) + (', foursquareId=' + Kotlin.toString(this.foursquareId)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendVenue.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.latitude) | 0;
    result = result * 31 + Kotlin.hashCode(this.longitude) | 0;
    result = result * 31 + Kotlin.hashCode(this.title) | 0;
    result = result * 31 + Kotlin.hashCode(this.address) | 0;
    result = result * 31 + Kotlin.hashCode(this.foursquareId) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendVenue.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.latitude, other.latitude) && Kotlin.equals(this.longitude, other.longitude) && Kotlin.equals(this.title, other.title) && Kotlin.equals(this.address, other.address) && Kotlin.equals(this.foursquareId, other.foursquareId) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function toRequest_0($receiver, chatId, disableNotification, replyToMessageId, replyMarkup) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    return SendVenue_init_0(chatId, $receiver, disableNotification, replyToMessageId, replyMarkup);
  }
  function DuratedSendMessageRequest() {
  }
  DuratedSendMessageRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DuratedSendMessageRequest',
    interfaces: [SendMessageRequest]
  };
  function PositionedSendMessageRequest() {
  }
  PositionedSendMessageRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'PositionedSendMessageRequest',
    interfaces: [SendMessageRequest]
  };
  function ReplyingMarkupSendMessageRequest() {
  }
  ReplyingMarkupSendMessageRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ReplyingMarkupSendMessageRequest',
    interfaces: [ReplyMarkup, SendMessageRequest]
  };
  function SendChatMessageRequest() {
  }
  SendChatMessageRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SendChatMessageRequest',
    interfaces: [ChatRequest, SimpleRequest]
  };
  function SendMessageRequest() {
  }
  SendMessageRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SendMessageRequest',
    interfaces: [DisableNotification, ReplyMessageId, SendChatMessageRequest]
  };
  function SizedSendMessageRequest() {
  }
  SizedSendMessageRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SizedSendMessageRequest',
    interfaces: [SendMessageRequest]
  };
  function TextableSendMessageRequest() {
  }
  TextableSendMessageRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TextableSendMessageRequest',
    interfaces: [SendMessageRequest]
  };
  function ThumbedSendMessageRequest() {
  }
  ThumbedSendMessageRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ThumbedSendMessageRequest',
    interfaces: [SendMessageRequest]
  };
  function TitledSendMessageRequest() {
  }
  TitledSendMessageRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'TitledSendMessageRequest',
    interfaces: [SendMessageRequest]
  };
  var commonResultDeserializer_6;
  function SendGame(chatId, gameShortName, disableNotification, replyToMessageId, replyMarkup) {
    SendGame$Companion_getInstance();
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_j2nmx6$_0 = chatId;
    this.gameShortName = gameShortName;
    this.disableNotification_rmgdzs$_0 = disableNotification;
    this.replyToMessageId_4gfid0$_0 = replyToMessageId;
    this.replyMarkup_8t2w3d$_0 = replyMarkup;
  }
  Object.defineProperty(SendGame.prototype, 'chatId', {
    get: function () {
      return this.chatId_j2nmx6$_0;
    }
  });
  Object.defineProperty(SendGame.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_rmgdzs$_0;
    }
  });
  Object.defineProperty(SendGame.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_4gfid0$_0;
    }
  });
  Object.defineProperty(SendGame.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_8t2w3d$_0;
    }
  });
  SendGame.prototype.method = function () {
    return 'sendGame';
  };
  Object.defineProperty(SendGame.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_6;
    }
  });
  Object.defineProperty(SendGame.prototype, 'requestSerializer', {
    get: function () {
      return SendGame$Companion_getInstance().serializer();
    }
  });
  function SendGame$Companion() {
    SendGame$Companion_instance = this;
  }
  SendGame$Companion.prototype.serializer = function () {
    return SendGame$$serializer_getInstance();
  };
  SendGame$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendGame$Companion_instance = null;
  function SendGame$Companion_getInstance() {
    if (SendGame$Companion_instance === null) {
      new SendGame$Companion();
    }
    return SendGame$Companion_instance;
  }
  function SendGame$$serializer() {
    this.descriptor_714y1q$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.games.SendGame', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('game_short_name', false);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendGame$$serializer_instance = this;
  }
  Object.defineProperty(SendGame$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_714y1q$_0;
    }
  });
  SendGame$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.gameShortName);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 2, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendGame$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.LongSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, KeyboardMarkupSerializer_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendGame_init(bitMask0, local0, local1, local2, local3, local4, null);
  };
  SendGame$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer, internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendGame$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendGame$$serializer_instance = null;
  function SendGame$$serializer_getInstance() {
    if (SendGame$$serializer_instance === null) {
      new SendGame$$serializer();
    }
    return SendGame$$serializer_instance;
  }
  function SendGame_init(seen1, chatId, gameShortName, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SendGame.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_j2nmx6$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('game_short_name');
    else
      $this.gameShortName = gameShortName;
    if ((seen1 & 4) === 0)
      $this.disableNotification_rmgdzs$_0 = false;
    else
      $this.disableNotification_rmgdzs$_0 = disableNotification;
    if ((seen1 & 8) === 0)
      $this.replyToMessageId_4gfid0$_0 = null;
    else
      $this.replyToMessageId_4gfid0$_0 = replyToMessageId;
    if ((seen1 & 16) === 0)
      $this.replyMarkup_8t2w3d$_0 = null;
    else
      $this.replyMarkup_8t2w3d$_0 = replyMarkup;
    return $this;
  }
  SendGame.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendGame',
    interfaces: [ReplyMarkup, SendMessageRequest]
  };
  SendGame.prototype.component1 = function () {
    return this.chatId;
  };
  SendGame.prototype.component2 = function () {
    return this.gameShortName;
  };
  SendGame.prototype.component3 = function () {
    return this.disableNotification;
  };
  SendGame.prototype.component4 = function () {
    return this.replyToMessageId;
  };
  SendGame.prototype.component5 = function () {
    return this.replyMarkup;
  };
  SendGame.prototype.copy_cnlk4d$ = function (chatId, gameShortName, disableNotification, replyToMessageId, replyMarkup) {
    return new SendGame(chatId === void 0 ? this.chatId : chatId, gameShortName === void 0 ? this.gameShortName : gameShortName, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendGame.prototype.toString = function () {
    return 'SendGame(chatId=' + Kotlin.toString(this.chatId) + (', gameShortName=' + Kotlin.toString(this.gameShortName)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendGame.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.gameShortName) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendGame.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.gameShortName, other.gameShortName) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function SendAnimation(chatId, animation, thumb, caption, parseMode, duration, width, height, disableNotification, replyToMessageId, replyMarkup) {
    if (thumb === void 0)
      thumb = null;
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (width === void 0)
      width = null;
    if (height === void 0)
      height = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    var animationAsFileId = (tmp$_0 = Kotlin.isType(tmp$ = animation, FileId) ? tmp$ : null) != null ? tmp$_0.fileId : null;
    var animationAsFile = Kotlin.isType(tmp$_1 = animation, MultipartFile) ? tmp$_1 : null;
    var thumbAsFileId = (tmp$_3 = Kotlin.isType(tmp$_2 = thumb, FileId) ? tmp$_2 : null) != null ? tmp$_3.fileId : null;
    var thumbAsFile = Kotlin.isType(tmp$_4 = thumb, MultipartFile) ? tmp$_4 : null;
    var data = new SendAnimationData(chatId, animationAsFileId, thumbAsFileId, caption, parseMode, duration, width, height, disableNotification, replyToMessageId, replyMarkup);
    if (animationAsFile == null && thumbAsFile == null) {
      tmp$_5 = data;
    }
     else {
      tmp$_5 = new MultipartRequestImpl(data, new SendAnimationFiles(animationAsFile, thumbAsFile));
    }
    return tmp$_5;
  }
  var commonResultDeserializer_7;
  function SendAnimationData(chatId, animation, thumb, text, parseMode, duration, width, height, disableNotification, replyToMessageId, replyMarkup) {
    SendAnimationData$Companion_getInstance();
    if (animation === void 0)
      animation = null;
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (width === void 0)
      width = null;
    if (height === void 0)
      height = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_f0rh1b$_0 = chatId;
    this.animation = animation;
    this.thumb_wp7pas$_0 = thumb;
    this.text_7xhl5n$_0 = text;
    this.parseMode_hrvaj0$_0 = parseMode;
    this.duration_xu9use$_0 = duration;
    this.width_v9tqys$_0 = width;
    this.height_g2ooa3$_0 = height;
    this.disableNotification_jk7mpb$_0 = disableNotification;
    this.replyToMessageId_t0961h$_0 = replyToMessageId;
    this.replyMarkup_5l2tkg$_0 = replyMarkup;
    var tmp$;
    if ((tmp$ = this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
  }
  Object.defineProperty(SendAnimationData.prototype, 'chatId', {
    get: function () {
      return this.chatId_f0rh1b$_0;
    }
  });
  Object.defineProperty(SendAnimationData.prototype, 'thumb', {
    get: function () {
      return this.thumb_wp7pas$_0;
    }
  });
  Object.defineProperty(SendAnimationData.prototype, 'text', {
    get: function () {
      return this.text_7xhl5n$_0;
    }
  });
  Object.defineProperty(SendAnimationData.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_hrvaj0$_0;
    }
  });
  Object.defineProperty(SendAnimationData.prototype, 'duration', {
    get: function () {
      return this.duration_xu9use$_0;
    }
  });
  Object.defineProperty(SendAnimationData.prototype, 'width', {
    get: function () {
      return this.width_v9tqys$_0;
    }
  });
  Object.defineProperty(SendAnimationData.prototype, 'height', {
    get: function () {
      return this.height_g2ooa3$_0;
    }
  });
  Object.defineProperty(SendAnimationData.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_jk7mpb$_0;
    }
  });
  Object.defineProperty(SendAnimationData.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_t0961h$_0;
    }
  });
  Object.defineProperty(SendAnimationData.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_5l2tkg$_0;
    }
  });
  SendAnimationData.prototype.method = function () {
    return 'sendAnimation';
  };
  Object.defineProperty(SendAnimationData.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_7;
    }
  });
  Object.defineProperty(SendAnimationData.prototype, 'requestSerializer', {
    get: function () {
      return SendAnimationData$Companion_getInstance().serializer();
    }
  });
  function SendAnimationData$Companion() {
    SendAnimationData$Companion_instance = this;
  }
  SendAnimationData$Companion.prototype.serializer = function () {
    return SendAnimationData$$serializer_getInstance();
  };
  SendAnimationData$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendAnimationData$Companion_instance = null;
  function SendAnimationData$Companion_getInstance() {
    if (SendAnimationData$Companion_instance === null) {
      new SendAnimationData$Companion();
    }
    return SendAnimationData$Companion_instance;
  }
  function SendAnimationData$$serializer() {
    this.descriptor_z48ne3$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendAnimationData', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('animation', true);
    this.descriptor.addElement_ivxn3r$('thumb', true);
    this.descriptor.addElement_ivxn3r$('caption', true);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('duration', true);
    this.descriptor.addElement_ivxn3r$('width', true);
    this.descriptor.addElement_ivxn3r$('height', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendAnimationData$$serializer_instance = this;
  }
  Object.defineProperty(SendAnimationData$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_z48ne3$_0;
    }
  });
  SendAnimationData$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    if (!equals(obj.animation, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.StringSerializer, obj.animation);
    if (!equals(obj.thumb, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.StringSerializer, obj.thumb);
    if (!equals(obj.text, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.duration, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.LongSerializer, obj.duration);
    if (!equals(obj.width, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, internal.IntSerializer, obj.width);
    if (!equals(obj.height, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, internal.IntSerializer, obj.height);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 8, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 9))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 9, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 10))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 10, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendAnimationData$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9
    , local10;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.StringSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.LongSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, internal.IntSerializer, local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, internal.IntSerializer, local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = (bitMask0 & 512) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 9, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 9, internal.LongSerializer, local9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case 10:
          local10 = (bitMask0 & 1024) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 10, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 10, KeyboardMarkupSerializer_getInstance(), local10);
          bitMask0 |= 1024;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendAnimationData_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, local10, null);
  };
  SendAnimationData$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(internal.LongSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(internal.IntSerializer), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendAnimationData$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendAnimationData$$serializer_instance = null;
  function SendAnimationData$$serializer_getInstance() {
    if (SendAnimationData$$serializer_instance === null) {
      new SendAnimationData$$serializer();
    }
    return SendAnimationData$$serializer_instance;
  }
  function SendAnimationData_init(seen1, chatId, animation, thumb, text, parseMode, duration, width, height, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var tmp$;
    var $this = serializationConstructorMarker || Object.create(SendAnimationData.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_f0rh1b$_0 = chatId;
    if ((seen1 & 2) === 0)
      $this.animation = null;
    else
      $this.animation = animation;
    if ((seen1 & 4) === 0)
      $this.thumb_wp7pas$_0 = null;
    else
      $this.thumb_wp7pas$_0 = thumb;
    if ((seen1 & 8) === 0)
      $this.text_7xhl5n$_0 = null;
    else
      $this.text_7xhl5n$_0 = text;
    if ((seen1 & 16) === 0)
      $this.parseMode_hrvaj0$_0 = null;
    else
      $this.parseMode_hrvaj0$_0 = parseMode;
    if ((seen1 & 32) === 0)
      $this.duration_xu9use$_0 = null;
    else
      $this.duration_xu9use$_0 = duration;
    if ((seen1 & 64) === 0)
      $this.width_v9tqys$_0 = null;
    else
      $this.width_v9tqys$_0 = width;
    if ((seen1 & 128) === 0)
      $this.height_g2ooa3$_0 = null;
    else
      $this.height_g2ooa3$_0 = height;
    if ((seen1 & 256) === 0)
      $this.disableNotification_jk7mpb$_0 = false;
    else
      $this.disableNotification_jk7mpb$_0 = disableNotification;
    if ((seen1 & 512) === 0)
      $this.replyToMessageId_t0961h$_0 = null;
    else
      $this.replyToMessageId_t0961h$_0 = replyToMessageId;
    if ((seen1 & 1024) === 0)
      $this.replyMarkup_5l2tkg$_0 = null;
    else
      $this.replyMarkup_5l2tkg$_0 = replyMarkup;
    if ((tmp$ = $this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
    return $this;
  }
  SendAnimationData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendAnimationData',
    interfaces: [SizedSendMessageRequest, DuratedSendMessageRequest, ThumbedSendMessageRequest, TextableSendMessageRequest, ReplyingMarkupSendMessageRequest, SendMessageRequest, DataRequest]
  };
  SendAnimationData.prototype.component1 = function () {
    return this.chatId;
  };
  SendAnimationData.prototype.component2 = function () {
    return this.animation;
  };
  SendAnimationData.prototype.component3 = function () {
    return this.thumb;
  };
  SendAnimationData.prototype.component4 = function () {
    return this.text;
  };
  SendAnimationData.prototype.component5 = function () {
    return this.parseMode;
  };
  SendAnimationData.prototype.component6 = function () {
    return this.duration;
  };
  SendAnimationData.prototype.component7 = function () {
    return this.width;
  };
  SendAnimationData.prototype.component8 = function () {
    return this.height;
  };
  SendAnimationData.prototype.component9 = function () {
    return this.disableNotification;
  };
  SendAnimationData.prototype.component10 = function () {
    return this.replyToMessageId;
  };
  SendAnimationData.prototype.component11 = function () {
    return this.replyMarkup;
  };
  SendAnimationData.prototype.copy_vmvjeq$ = function (chatId, animation, thumb, text, parseMode, duration, width, height, disableNotification, replyToMessageId, replyMarkup) {
    return new SendAnimationData(chatId === void 0 ? this.chatId : chatId, animation === void 0 ? this.animation : animation, thumb === void 0 ? this.thumb : thumb, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, duration === void 0 ? this.duration : duration, width === void 0 ? this.width : width, height === void 0 ? this.height : height, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendAnimationData.prototype.toString = function () {
    return 'SendAnimationData(chatId=' + Kotlin.toString(this.chatId) + (', animation=' + Kotlin.toString(this.animation)) + (', thumb=' + Kotlin.toString(this.thumb)) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', duration=' + Kotlin.toString(this.duration)) + (', width=' + Kotlin.toString(this.width)) + (', height=' + Kotlin.toString(this.height)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendAnimationData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.animation) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.duration) | 0;
    result = result * 31 + Kotlin.hashCode(this.width) | 0;
    result = result * 31 + Kotlin.hashCode(this.height) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendAnimationData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.animation, other.animation) && Kotlin.equals(this.thumb, other.thumb) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.duration, other.duration) && Kotlin.equals(this.width, other.width) && Kotlin.equals(this.height, other.height) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function SendAnimationFiles(animation, thumb) {
    if (animation === void 0)
      animation = null;
    if (thumb === void 0)
      thumb = null;
    this.animation = animation;
    this.thumb = thumb;
    this.$delegate_m71kfv$_0 = mapOfNotNull([to(animationField, animation), to(thumbField, thumb)]);
  }
  Object.defineProperty(SendAnimationFiles.prototype, 'entries', {
    get: function () {
      return this.$delegate_m71kfv$_0.entries;
    }
  });
  Object.defineProperty(SendAnimationFiles.prototype, 'keys', {
    get: function () {
      return this.$delegate_m71kfv$_0.keys;
    }
  });
  Object.defineProperty(SendAnimationFiles.prototype, 'size', {
    get: function () {
      return this.$delegate_m71kfv$_0.size;
    }
  });
  Object.defineProperty(SendAnimationFiles.prototype, 'values', {
    get: function () {
      return this.$delegate_m71kfv$_0.values;
    }
  });
  SendAnimationFiles.prototype.containsKey_11rb$ = function (key) {
    return this.$delegate_m71kfv$_0.containsKey_11rb$(key);
  };
  SendAnimationFiles.prototype.containsValue_11rc$ = function (value) {
    return this.$delegate_m71kfv$_0.containsValue_11rc$(value);
  };
  SendAnimationFiles.prototype.get_11rb$ = function (key) {
    return this.$delegate_m71kfv$_0.get_11rb$(key);
  };
  SendAnimationFiles.prototype.isEmpty = function () {
    return this.$delegate_m71kfv$_0.isEmpty();
  };
  SendAnimationFiles.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendAnimationFiles',
    interfaces: [Map]
  };
  SendAnimationFiles.prototype.component1 = function () {
    return this.animation;
  };
  SendAnimationFiles.prototype.component2 = function () {
    return this.thumb;
  };
  SendAnimationFiles.prototype.copy_sm2yek$ = function (animation, thumb) {
    return new SendAnimationFiles(animation === void 0 ? this.animation : animation, thumb === void 0 ? this.thumb : thumb);
  };
  SendAnimationFiles.prototype.toString = function () {
    return 'SendAnimationFiles(animation=' + Kotlin.toString(this.animation) + (', thumb=' + Kotlin.toString(this.thumb)) + ')';
  };
  SendAnimationFiles.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.animation) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    return result;
  };
  SendAnimationFiles.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.animation, other.animation) && Kotlin.equals(this.thumb, other.thumb)))));
  };
  function SendAudio(chatId, audio, thumb, caption, parseMode, duration, performer, title, disableNotification, replyToMessageId, replyMarkup) {
    if (thumb === void 0)
      thumb = null;
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (performer === void 0)
      performer = null;
    if (title === void 0)
      title = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    var audioAsFileId = (tmp$_0 = Kotlin.isType(tmp$ = audio, FileId) ? tmp$ : null) != null ? tmp$_0.fileId : null;
    var audioAsFile = Kotlin.isType(tmp$_1 = audio, MultipartFile) ? tmp$_1 : null;
    var thumbAsFileId = (tmp$_3 = Kotlin.isType(tmp$_2 = thumb, FileId) ? tmp$_2 : null) != null ? tmp$_3.fileId : null;
    var thumbAsFile = Kotlin.isType(tmp$_4 = thumb, MultipartFile) ? tmp$_4 : null;
    var data = new SendAudioData(chatId, audioAsFileId, thumbAsFileId, caption, parseMode, duration, performer, title, disableNotification, replyToMessageId, replyMarkup);
    if (audioAsFile == null && thumbAsFile == null) {
      tmp$_5 = data;
    }
     else {
      tmp$_5 = new MultipartRequestImpl(data, new SendAudioFiles(audioAsFile, thumbAsFile));
    }
    return tmp$_5;
  }
  var commonResultDeserializer_8;
  function SendAudioData(chatId, audio, thumb, text, parseMode, duration, performer, title, disableNotification, replyToMessageId, replyMarkup) {
    SendAudioData$Companion_getInstance();
    if (audio === void 0)
      audio = null;
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (performer === void 0)
      performer = null;
    if (title === void 0)
      title = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_8ua9g1$_0 = chatId;
    this.audio = audio;
    this.thumb_f7uhlm$_0 = thumb;
    this.text_1sv6vd$_0 = text;
    this.parseMode_n3cpkq$_0 = parseMode;
    this.duration_9it89c$_0 = duration;
    this.performer_24yiea$_0 = performer;
    this.title_f8dmjc$_0 = title;
    this.disableNotification_tpcl25$_0 = disableNotification;
    this.replyToMessageId_8cc1bb$_0 = replyToMessageId;
    this.replyMarkup_8982te$_0 = replyMarkup;
    var tmp$;
    if ((tmp$ = this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
  }
  Object.defineProperty(SendAudioData.prototype, 'chatId', {
    get: function () {
      return this.chatId_8ua9g1$_0;
    }
  });
  Object.defineProperty(SendAudioData.prototype, 'thumb', {
    get: function () {
      return this.thumb_f7uhlm$_0;
    }
  });
  Object.defineProperty(SendAudioData.prototype, 'text', {
    get: function () {
      return this.text_1sv6vd$_0;
    }
  });
  Object.defineProperty(SendAudioData.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_n3cpkq$_0;
    }
  });
  Object.defineProperty(SendAudioData.prototype, 'duration', {
    get: function () {
      return this.duration_9it89c$_0;
    }
  });
  Object.defineProperty(SendAudioData.prototype, 'performer', {
    get: function () {
      return this.performer_24yiea$_0;
    }
  });
  Object.defineProperty(SendAudioData.prototype, 'title', {
    get: function () {
      return this.title_f8dmjc$_0;
    }
  });
  Object.defineProperty(SendAudioData.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_tpcl25$_0;
    }
  });
  Object.defineProperty(SendAudioData.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_8cc1bb$_0;
    }
  });
  Object.defineProperty(SendAudioData.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_8982te$_0;
    }
  });
  SendAudioData.prototype.method = function () {
    return 'sendAudio';
  };
  Object.defineProperty(SendAudioData.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_8;
    }
  });
  Object.defineProperty(SendAudioData.prototype, 'requestSerializer', {
    get: function () {
      return SendAudioData$Companion_getInstance().serializer();
    }
  });
  function SendAudioData$Companion() {
    SendAudioData$Companion_instance = this;
  }
  SendAudioData$Companion.prototype.serializer = function () {
    return SendAudioData$$serializer_getInstance();
  };
  SendAudioData$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendAudioData$Companion_instance = null;
  function SendAudioData$Companion_getInstance() {
    if (SendAudioData$Companion_instance === null) {
      new SendAudioData$Companion();
    }
    return SendAudioData$Companion_instance;
  }
  function SendAudioData$$serializer() {
    this.descriptor_v5y6d9$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendAudioData', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('audio', true);
    this.descriptor.addElement_ivxn3r$('thumb', true);
    this.descriptor.addElement_ivxn3r$('caption', true);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('duration', true);
    this.descriptor.addElement_ivxn3r$('performer', true);
    this.descriptor.addElement_ivxn3r$('title', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendAudioData$$serializer_instance = this;
  }
  Object.defineProperty(SendAudioData$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_v5y6d9$_0;
    }
  });
  SendAudioData$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    if (!equals(obj.audio, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.StringSerializer, obj.audio);
    if (!equals(obj.thumb, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.StringSerializer, obj.thumb);
    if (!equals(obj.text, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.duration, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.LongSerializer, obj.duration);
    if (!equals(obj.performer, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, internal.StringSerializer, obj.performer);
    if (!equals(obj.title, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, internal.StringSerializer, obj.title);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 8, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 9))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 9, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 10))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 10, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendAudioData$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9
    , local10;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.StringSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.LongSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, internal.StringSerializer, local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, internal.StringSerializer, local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = (bitMask0 & 512) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 9, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 9, internal.LongSerializer, local9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case 10:
          local10 = (bitMask0 & 1024) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 10, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 10, KeyboardMarkupSerializer_getInstance(), local10);
          bitMask0 |= 1024;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendAudioData_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, local10, null);
  };
  SendAudioData$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(internal.LongSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendAudioData$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendAudioData$$serializer_instance = null;
  function SendAudioData$$serializer_getInstance() {
    if (SendAudioData$$serializer_instance === null) {
      new SendAudioData$$serializer();
    }
    return SendAudioData$$serializer_instance;
  }
  function SendAudioData_init(seen1, chatId, audio, thumb, text, parseMode, duration, performer, title, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var tmp$;
    var $this = serializationConstructorMarker || Object.create(SendAudioData.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_8ua9g1$_0 = chatId;
    if ((seen1 & 2) === 0)
      $this.audio = null;
    else
      $this.audio = audio;
    if ((seen1 & 4) === 0)
      $this.thumb_f7uhlm$_0 = null;
    else
      $this.thumb_f7uhlm$_0 = thumb;
    if ((seen1 & 8) === 0)
      $this.text_1sv6vd$_0 = null;
    else
      $this.text_1sv6vd$_0 = text;
    if ((seen1 & 16) === 0)
      $this.parseMode_n3cpkq$_0 = null;
    else
      $this.parseMode_n3cpkq$_0 = parseMode;
    if ((seen1 & 32) === 0)
      $this.duration_9it89c$_0 = null;
    else
      $this.duration_9it89c$_0 = duration;
    if ((seen1 & 64) === 0)
      $this.performer_24yiea$_0 = null;
    else
      $this.performer_24yiea$_0 = performer;
    if ((seen1 & 128) === 0)
      $this.title_f8dmjc$_0 = null;
    else
      $this.title_f8dmjc$_0 = title;
    if ((seen1 & 256) === 0)
      $this.disableNotification_tpcl25$_0 = false;
    else
      $this.disableNotification_tpcl25$_0 = disableNotification;
    if ((seen1 & 512) === 0)
      $this.replyToMessageId_8cc1bb$_0 = null;
    else
      $this.replyToMessageId_8cc1bb$_0 = replyToMessageId;
    if ((seen1 & 1024) === 0)
      $this.replyMarkup_8982te$_0 = null;
    else
      $this.replyMarkup_8982te$_0 = replyMarkup;
    if ((tmp$ = $this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
    return $this;
  }
  SendAudioData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendAudioData',
    interfaces: [Performerable, DuratedSendMessageRequest, TitledSendMessageRequest, ThumbedSendMessageRequest, TextableSendMessageRequest, ReplyingMarkupSendMessageRequest, SendMessageRequest, DataRequest]
  };
  SendAudioData.prototype.component1 = function () {
    return this.chatId;
  };
  SendAudioData.prototype.component2 = function () {
    return this.audio;
  };
  SendAudioData.prototype.component3 = function () {
    return this.thumb;
  };
  SendAudioData.prototype.component4 = function () {
    return this.text;
  };
  SendAudioData.prototype.component5 = function () {
    return this.parseMode;
  };
  SendAudioData.prototype.component6 = function () {
    return this.duration;
  };
  SendAudioData.prototype.component7 = function () {
    return this.performer;
  };
  SendAudioData.prototype.component8 = function () {
    return this.title;
  };
  SendAudioData.prototype.component9 = function () {
    return this.disableNotification;
  };
  SendAudioData.prototype.component10 = function () {
    return this.replyToMessageId;
  };
  SendAudioData.prototype.component11 = function () {
    return this.replyMarkup;
  };
  SendAudioData.prototype.copy_62ttvo$ = function (chatId, audio, thumb, text, parseMode, duration, performer, title, disableNotification, replyToMessageId, replyMarkup) {
    return new SendAudioData(chatId === void 0 ? this.chatId : chatId, audio === void 0 ? this.audio : audio, thumb === void 0 ? this.thumb : thumb, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, duration === void 0 ? this.duration : duration, performer === void 0 ? this.performer : performer, title === void 0 ? this.title : title, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendAudioData.prototype.toString = function () {
    return 'SendAudioData(chatId=' + Kotlin.toString(this.chatId) + (', audio=' + Kotlin.toString(this.audio)) + (', thumb=' + Kotlin.toString(this.thumb)) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', duration=' + Kotlin.toString(this.duration)) + (', performer=' + Kotlin.toString(this.performer)) + (', title=' + Kotlin.toString(this.title)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendAudioData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.audio) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.duration) | 0;
    result = result * 31 + Kotlin.hashCode(this.performer) | 0;
    result = result * 31 + Kotlin.hashCode(this.title) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendAudioData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.audio, other.audio) && Kotlin.equals(this.thumb, other.thumb) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.duration, other.duration) && Kotlin.equals(this.performer, other.performer) && Kotlin.equals(this.title, other.title) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function SendAudioFiles(audio, thumb) {
    if (audio === void 0)
      audio = null;
    if (thumb === void 0)
      thumb = null;
    this.audio = audio;
    this.thumb = thumb;
    this.$delegate_lvvqs7$_0 = mapOfNotNull([to(audioField, audio), to(thumbField, thumb)]);
  }
  Object.defineProperty(SendAudioFiles.prototype, 'entries', {
    get: function () {
      return this.$delegate_lvvqs7$_0.entries;
    }
  });
  Object.defineProperty(SendAudioFiles.prototype, 'keys', {
    get: function () {
      return this.$delegate_lvvqs7$_0.keys;
    }
  });
  Object.defineProperty(SendAudioFiles.prototype, 'size', {
    get: function () {
      return this.$delegate_lvvqs7$_0.size;
    }
  });
  Object.defineProperty(SendAudioFiles.prototype, 'values', {
    get: function () {
      return this.$delegate_lvvqs7$_0.values;
    }
  });
  SendAudioFiles.prototype.containsKey_11rb$ = function (key) {
    return this.$delegate_lvvqs7$_0.containsKey_11rb$(key);
  };
  SendAudioFiles.prototype.containsValue_11rc$ = function (value) {
    return this.$delegate_lvvqs7$_0.containsValue_11rc$(value);
  };
  SendAudioFiles.prototype.get_11rb$ = function (key) {
    return this.$delegate_lvvqs7$_0.get_11rb$(key);
  };
  SendAudioFiles.prototype.isEmpty = function () {
    return this.$delegate_lvvqs7$_0.isEmpty();
  };
  SendAudioFiles.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendAudioFiles',
    interfaces: [Map]
  };
  SendAudioFiles.prototype.component1 = function () {
    return this.audio;
  };
  SendAudioFiles.prototype.component2 = function () {
    return this.thumb;
  };
  SendAudioFiles.prototype.copy_sm2yek$ = function (audio, thumb) {
    return new SendAudioFiles(audio === void 0 ? this.audio : audio, thumb === void 0 ? this.thumb : thumb);
  };
  SendAudioFiles.prototype.toString = function () {
    return 'SendAudioFiles(audio=' + Kotlin.toString(this.audio) + (', thumb=' + Kotlin.toString(this.thumb)) + ')';
  };
  SendAudioFiles.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.audio) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    return result;
  };
  SendAudioFiles.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.audio, other.audio) && Kotlin.equals(this.thumb, other.thumb)))));
  };
  function SendDocument(chatId, document, thumb, caption, parseMode, disableNotification, replyToMessageId, replyMarkup) {
    if (thumb === void 0)
      thumb = null;
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    var documentAsFileId = (tmp$_0 = Kotlin.isType(tmp$ = document, FileId) ? tmp$ : null) != null ? tmp$_0.fileId : null;
    var documentAsFile = Kotlin.isType(tmp$_1 = document, MultipartFile) ? tmp$_1 : null;
    var thumbAsFileId = (tmp$_3 = Kotlin.isType(tmp$_2 = thumb, FileId) ? tmp$_2 : null) != null ? tmp$_3.fileId : null;
    var thumbAsFile = Kotlin.isType(tmp$_4 = thumb, MultipartFile) ? tmp$_4 : null;
    var data = new SendDocumentData(chatId, documentAsFileId, thumbAsFileId, caption, parseMode, disableNotification, replyToMessageId, replyMarkup);
    if (documentAsFile == null && thumbAsFile == null) {
      tmp$_5 = data;
    }
     else {
      tmp$_5 = new MultipartRequestImpl(data, new SendDocumentFiles(documentAsFile, thumbAsFile));
    }
    return tmp$_5;
  }
  var commonResultDeserializer_9;
  function SendDocumentData(chatId, document, thumb, text, parseMode, disableNotification, replyToMessageId, replyMarkup) {
    SendDocumentData$Companion_getInstance();
    if (document === void 0)
      document = null;
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_i6op9i$_0 = chatId;
    this.document = document;
    this.thumb_xuljs5$_0 = thumb;
    this.text_3hpsxg$_0 = text;
    this.parseMode_y7y2f9$_0 = parseMode;
    this.disableNotification_vrvoko$_0 = disableNotification;
    this.replyToMessageId_ozdo8s$_0 = replyToMessageId;
    this.replyMarkup_upznt5$_0 = replyMarkup;
    var tmp$;
    if ((tmp$ = this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
  }
  Object.defineProperty(SendDocumentData.prototype, 'chatId', {
    get: function () {
      return this.chatId_i6op9i$_0;
    }
  });
  Object.defineProperty(SendDocumentData.prototype, 'thumb', {
    get: function () {
      return this.thumb_xuljs5$_0;
    }
  });
  Object.defineProperty(SendDocumentData.prototype, 'text', {
    get: function () {
      return this.text_3hpsxg$_0;
    }
  });
  Object.defineProperty(SendDocumentData.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_y7y2f9$_0;
    }
  });
  Object.defineProperty(SendDocumentData.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_vrvoko$_0;
    }
  });
  Object.defineProperty(SendDocumentData.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_ozdo8s$_0;
    }
  });
  Object.defineProperty(SendDocumentData.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_upznt5$_0;
    }
  });
  SendDocumentData.prototype.method = function () {
    return 'sendDocument';
  };
  Object.defineProperty(SendDocumentData.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_9;
    }
  });
  Object.defineProperty(SendDocumentData.prototype, 'requestSerializer', {
    get: function () {
      return SendDocumentData$Companion_getInstance().serializer();
    }
  });
  function SendDocumentData$Companion() {
    SendDocumentData$Companion_instance = this;
  }
  SendDocumentData$Companion.prototype.serializer = function () {
    return SendDocumentData$$serializer_getInstance();
  };
  SendDocumentData$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendDocumentData$Companion_instance = null;
  function SendDocumentData$Companion_getInstance() {
    if (SendDocumentData$Companion_instance === null) {
      new SendDocumentData$Companion();
    }
    return SendDocumentData$Companion_instance;
  }
  function SendDocumentData$$serializer() {
    this.descriptor_in40xa$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendDocumentData', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('document', true);
    this.descriptor.addElement_ivxn3r$('thumb', true);
    this.descriptor.addElement_ivxn3r$('caption', true);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendDocumentData$$serializer_instance = this;
  }
  Object.defineProperty(SendDocumentData$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_in40xa$_0;
    }
  });
  SendDocumentData$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    if (!equals(obj.document, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.StringSerializer, obj.document);
    if (!equals(obj.thumb, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.StringSerializer, obj.thumb);
    if (!equals(obj.text, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 5, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendDocumentData$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.StringSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, internal.LongSerializer, local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, KeyboardMarkupSerializer_getInstance(), local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendDocumentData_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, null);
  };
  SendDocumentData$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(ParseModeSerializerObject_getInstance()), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendDocumentData$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendDocumentData$$serializer_instance = null;
  function SendDocumentData$$serializer_getInstance() {
    if (SendDocumentData$$serializer_instance === null) {
      new SendDocumentData$$serializer();
    }
    return SendDocumentData$$serializer_instance;
  }
  function SendDocumentData_init(seen1, chatId, document, thumb, text, parseMode, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var tmp$;
    var $this = serializationConstructorMarker || Object.create(SendDocumentData.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_i6op9i$_0 = chatId;
    if ((seen1 & 2) === 0)
      $this.document = null;
    else
      $this.document = document;
    if ((seen1 & 4) === 0)
      $this.thumb_xuljs5$_0 = null;
    else
      $this.thumb_xuljs5$_0 = thumb;
    if ((seen1 & 8) === 0)
      $this.text_3hpsxg$_0 = null;
    else
      $this.text_3hpsxg$_0 = text;
    if ((seen1 & 16) === 0)
      $this.parseMode_y7y2f9$_0 = null;
    else
      $this.parseMode_y7y2f9$_0 = parseMode;
    if ((seen1 & 32) === 0)
      $this.disableNotification_vrvoko$_0 = false;
    else
      $this.disableNotification_vrvoko$_0 = disableNotification;
    if ((seen1 & 64) === 0)
      $this.replyToMessageId_ozdo8s$_0 = null;
    else
      $this.replyToMessageId_ozdo8s$_0 = replyToMessageId;
    if ((seen1 & 128) === 0)
      $this.replyMarkup_upznt5$_0 = null;
    else
      $this.replyMarkup_upznt5$_0 = replyMarkup;
    if ((tmp$ = $this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
    return $this;
  }
  SendDocumentData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendDocumentData',
    interfaces: [ThumbedSendMessageRequest, TextableSendMessageRequest, ReplyingMarkupSendMessageRequest, SendMessageRequest, DataRequest]
  };
  SendDocumentData.prototype.component1 = function () {
    return this.chatId;
  };
  SendDocumentData.prototype.component2 = function () {
    return this.document;
  };
  SendDocumentData.prototype.component3 = function () {
    return this.thumb;
  };
  SendDocumentData.prototype.component4 = function () {
    return this.text;
  };
  SendDocumentData.prototype.component5 = function () {
    return this.parseMode;
  };
  SendDocumentData.prototype.component6 = function () {
    return this.disableNotification;
  };
  SendDocumentData.prototype.component7 = function () {
    return this.replyToMessageId;
  };
  SendDocumentData.prototype.component8 = function () {
    return this.replyMarkup;
  };
  SendDocumentData.prototype.copy_imdnhg$ = function (chatId, document, thumb, text, parseMode, disableNotification, replyToMessageId, replyMarkup) {
    return new SendDocumentData(chatId === void 0 ? this.chatId : chatId, document === void 0 ? this.document : document, thumb === void 0 ? this.thumb : thumb, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendDocumentData.prototype.toString = function () {
    return 'SendDocumentData(chatId=' + Kotlin.toString(this.chatId) + (', document=' + Kotlin.toString(this.document)) + (', thumb=' + Kotlin.toString(this.thumb)) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendDocumentData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.document) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendDocumentData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.document, other.document) && Kotlin.equals(this.thumb, other.thumb) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function SendDocumentFiles(document, thumb) {
    if (document === void 0)
      document = null;
    if (thumb === void 0)
      thumb = null;
    this.document = document;
    this.thumb = thumb;
    this.$delegate_2g9aoc$_0 = mapOfNotNull([to(documentField, document), to(thumbField, thumb)]);
  }
  Object.defineProperty(SendDocumentFiles.prototype, 'entries', {
    get: function () {
      return this.$delegate_2g9aoc$_0.entries;
    }
  });
  Object.defineProperty(SendDocumentFiles.prototype, 'keys', {
    get: function () {
      return this.$delegate_2g9aoc$_0.keys;
    }
  });
  Object.defineProperty(SendDocumentFiles.prototype, 'size', {
    get: function () {
      return this.$delegate_2g9aoc$_0.size;
    }
  });
  Object.defineProperty(SendDocumentFiles.prototype, 'values', {
    get: function () {
      return this.$delegate_2g9aoc$_0.values;
    }
  });
  SendDocumentFiles.prototype.containsKey_11rb$ = function (key) {
    return this.$delegate_2g9aoc$_0.containsKey_11rb$(key);
  };
  SendDocumentFiles.prototype.containsValue_11rc$ = function (value) {
    return this.$delegate_2g9aoc$_0.containsValue_11rc$(value);
  };
  SendDocumentFiles.prototype.get_11rb$ = function (key) {
    return this.$delegate_2g9aoc$_0.get_11rb$(key);
  };
  SendDocumentFiles.prototype.isEmpty = function () {
    return this.$delegate_2g9aoc$_0.isEmpty();
  };
  SendDocumentFiles.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendDocumentFiles',
    interfaces: [Map]
  };
  SendDocumentFiles.prototype.component1 = function () {
    return this.document;
  };
  SendDocumentFiles.prototype.component2 = function () {
    return this.thumb;
  };
  SendDocumentFiles.prototype.copy_sm2yek$ = function (document, thumb) {
    return new SendDocumentFiles(document === void 0 ? this.document : document, thumb === void 0 ? this.thumb : thumb);
  };
  SendDocumentFiles.prototype.toString = function () {
    return 'SendDocumentFiles(document=' + Kotlin.toString(this.document) + (', thumb=' + Kotlin.toString(this.thumb)) + ')';
  };
  SendDocumentFiles.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.document) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    return result;
  };
  SendDocumentFiles.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.document, other.document) && Kotlin.equals(this.thumb, other.thumb)))));
  };
  var membersCountInMediaGroup;
  function SendMediaGroup(chatId, media, disableNotification, replyToMessageId) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    var tmp$;
    if (!membersCountInMediaGroup.contains_mef7kx$(media.size)) {
      throw IllegalArgumentException_init('Count of members for media group must be in ' + membersCountInMediaGroup + ' range');
    }
    var destination = ArrayList_init_0();
    var tmp$_0;
    tmp$_0 = media.iterator();
    while (tmp$_0.hasNext()) {
      var element = tmp$_0.next();
      var tmp$_1, tmp$_2, tmp$_3, tmp$_4;
      tmp$_2 = Kotlin.isType(tmp$_1 = element.file, MultipartFile) ? tmp$_1 : null;
      if (Kotlin.isType(element, ThumbedInputMedia)) {
        tmp$_4 = Kotlin.isType(tmp$_3 = element.thumb, MultipartFile) ? tmp$_3 : null;
      }
       else {
        tmp$_4 = null;
      }
      var list = listOfNotNull([tmp$_2, tmp$_4]);
      addAll(destination, list);
    }
    var files = destination;
    var data = new SendMediaGroupData(chatId, media, disableNotification, replyToMessageId);
    if (files.isEmpty()) {
      tmp$ = data;
    }
     else {
      tmp$ = new MultipartRequestImpl(data, new SendMediaGroupFiles(files));
    }
    return tmp$;
  }
  var messagesListSerializer;
  function SendMediaGroupData(chatId, media, disableNotification, replyToMessageId) {
    SendMediaGroupData$Companion_getInstance();
    if (media === void 0)
      media = emptyList();
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    this.chatId_ajbjga$_0 = chatId;
    this.media = media;
    this.disableNotification_3klmx4$_0 = disableNotification;
    this.replyToMessageId_zd51d0$_0 = replyToMessageId;
  }
  Object.defineProperty(SendMediaGroupData.prototype, 'chatId', {
    get: function () {
      return this.chatId_ajbjga$_0;
    }
  });
  Object.defineProperty(SendMediaGroupData.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_3klmx4$_0;
    }
  });
  Object.defineProperty(SendMediaGroupData.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_zd51d0$_0;
    }
  });
  function SendMediaGroupData$get_SendMediaGroupData$convertedMedia$lambda(this$SendMediaGroupData) {
    return function ($receiver) {
      var tmp$;
      tmp$ = this$SendMediaGroupData.media.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        var serializer = MediaGroupMemberInputMediaSerializer_getInstance();
        $receiver.unaryPlus_u3sd3g$(withoutNulls_0(Json.Companion.nonstrict.toJson_tf03ej$(serializer, element).jsonObject));
      }
      return Unit;
    };
  }
  Object.defineProperty(SendMediaGroupData.prototype, 'convertedMedia_0', {
    get: function () {
      return jsonArray(SendMediaGroupData$get_SendMediaGroupData$convertedMedia$lambda(this)).toString();
    }
  });
  SendMediaGroupData.prototype.method = function () {
    return 'sendMediaGroup';
  };
  Object.defineProperty(SendMediaGroupData.prototype, 'requestSerializer', {
    get: function () {
      return SendMediaGroupData$Companion_getInstance().serializer();
    }
  });
  Object.defineProperty(SendMediaGroupData.prototype, 'resultDeserializer', {
    get: function () {
      return messagesListSerializer;
    }
  });
  function SendMediaGroupData$Companion() {
    SendMediaGroupData$Companion_instance = this;
  }
  SendMediaGroupData$Companion.prototype.serializer = function () {
    return SendMediaGroupData$$serializer_getInstance();
  };
  SendMediaGroupData$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendMediaGroupData$Companion_instance = null;
  function SendMediaGroupData$Companion_getInstance() {
    if (SendMediaGroupData$Companion_instance === null) {
      new SendMediaGroupData$Companion();
    }
    return SendMediaGroupData$Companion_instance;
  }
  function SendMediaGroupData$$serializer() {
    this.descriptor_yby14i$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendMediaGroupData', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('media', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    SendMediaGroupData$$serializer_instance = this;
  }
  Object.defineProperty(SendMediaGroupData$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_yby14i$_0;
    }
  });
  SendMediaGroupData$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    if (!equals(obj.media, emptyList()) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeSerializableElement_blecud$(this.descriptor, 1, new ArrayListSerializer(MediaGroupMemberInputMediaSerializer_getInstance()), obj.media);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 2, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.LongSerializer, obj.replyToMessageId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendMediaGroupData$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, new ArrayListSerializer(MediaGroupMemberInputMediaSerializer_getInstance())) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, new ArrayListSerializer(MediaGroupMemberInputMediaSerializer_getInstance()), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.LongSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendMediaGroupData_init(bitMask0, local0, local1, local2, local3, null);
  };
  SendMediaGroupData$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), new ArrayListSerializer(MediaGroupMemberInputMediaSerializer_getInstance()), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer)];
  };
  SendMediaGroupData$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendMediaGroupData$$serializer_instance = null;
  function SendMediaGroupData$$serializer_getInstance() {
    if (SendMediaGroupData$$serializer_instance === null) {
      new SendMediaGroupData$$serializer();
    }
    return SendMediaGroupData$$serializer_instance;
  }
  function SendMediaGroupData_init(seen1, chatId, media, disableNotification, replyToMessageId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SendMediaGroupData.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_ajbjga$_0 = chatId;
    if ((seen1 & 2) === 0)
      $this.media = emptyList();
    else
      $this.media = media;
    if ((seen1 & 4) === 0)
      $this.disableNotification_3klmx4$_0 = false;
    else
      $this.disableNotification_3klmx4$_0 = disableNotification;
    if ((seen1 & 8) === 0)
      $this.replyToMessageId_zd51d0$_0 = null;
    else
      $this.replyToMessageId_zd51d0$_0 = replyToMessageId;
    return $this;
  }
  SendMediaGroupData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendMediaGroupData',
    interfaces: [SendMessageRequest, DataRequest]
  };
  SendMediaGroupData.prototype.component1 = function () {
    return this.chatId;
  };
  SendMediaGroupData.prototype.component2 = function () {
    return this.media;
  };
  SendMediaGroupData.prototype.component3 = function () {
    return this.disableNotification;
  };
  SendMediaGroupData.prototype.component4 = function () {
    return this.replyToMessageId;
  };
  SendMediaGroupData.prototype.copy_vff2fm$ = function (chatId, media, disableNotification, replyToMessageId) {
    return new SendMediaGroupData(chatId === void 0 ? this.chatId : chatId, media === void 0 ? this.media : media, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId);
  };
  SendMediaGroupData.prototype.toString = function () {
    return 'SendMediaGroupData(chatId=' + Kotlin.toString(this.chatId) + (', media=' + Kotlin.toString(this.media)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + ')';
  };
  SendMediaGroupData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.media) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    return result;
  };
  SendMediaGroupData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.media, other.media) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId)))));
  };
  function SendMediaGroupFiles(files) {
    this.files = files;
    var destination = ArrayList_init(collectionSizeOrDefault(files, 10));
    var tmp$;
    tmp$ = files.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(to(item.fileId, item));
    }
    this.$delegate_c2nr9w$_0 = toMap(destination);
  }
  Object.defineProperty(SendMediaGroupFiles.prototype, 'entries', {
    get: function () {
      return this.$delegate_c2nr9w$_0.entries;
    }
  });
  Object.defineProperty(SendMediaGroupFiles.prototype, 'keys', {
    get: function () {
      return this.$delegate_c2nr9w$_0.keys;
    }
  });
  Object.defineProperty(SendMediaGroupFiles.prototype, 'size', {
    get: function () {
      return this.$delegate_c2nr9w$_0.size;
    }
  });
  Object.defineProperty(SendMediaGroupFiles.prototype, 'values', {
    get: function () {
      return this.$delegate_c2nr9w$_0.values;
    }
  });
  SendMediaGroupFiles.prototype.containsKey_11rb$ = function (key) {
    return this.$delegate_c2nr9w$_0.containsKey_11rb$(key);
  };
  SendMediaGroupFiles.prototype.containsValue_11rc$ = function (value) {
    return this.$delegate_c2nr9w$_0.containsValue_11rc$(value);
  };
  SendMediaGroupFiles.prototype.get_11rb$ = function (key) {
    return this.$delegate_c2nr9w$_0.get_11rb$(key);
  };
  SendMediaGroupFiles.prototype.isEmpty = function () {
    return this.$delegate_c2nr9w$_0.isEmpty();
  };
  SendMediaGroupFiles.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendMediaGroupFiles',
    interfaces: [Map]
  };
  SendMediaGroupFiles.prototype.component1 = function () {
    return this.files;
  };
  SendMediaGroupFiles.prototype.copy_fsecx6$ = function (files) {
    return new SendMediaGroupFiles(files === void 0 ? this.files : files);
  };
  SendMediaGroupFiles.prototype.toString = function () {
    return 'SendMediaGroupFiles(files=' + Kotlin.toString(this.files) + ')';
  };
  SendMediaGroupFiles.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.files) | 0;
    return result;
  };
  SendMediaGroupFiles.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.files, other.files))));
  };
  function SendPhoto(chatId, photo, caption, parseMode, disableNotification, replyToMessageId, replyMarkup) {
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$, tmp$_0;
    var tmp$_1, tmp$_2;
    var data = new SendPhotoData(chatId, (tmp$_0 = Kotlin.isType(tmp$ = photo, FileId) ? tmp$ : null) != null ? tmp$_0.fileId : null, caption, parseMode, disableNotification, replyToMessageId, replyMarkup);
    tmp$_2 = data.photo != null ? data : null;
    if (tmp$_2 == null) {
      tmp$_2 = new MultipartRequestImpl(data, new SendPhotoFiles(Kotlin.isType(tmp$_1 = photo, MultipartFile) ? tmp$_1 : throwCCE()));
    }
    return tmp$_2;
  }
  var commonResultDeserializer_10;
  function SendPhotoData(chatId, photo, text, parseMode, disableNotification, replyToMessageId, replyMarkup) {
    SendPhotoData$Companion_getInstance();
    if (photo === void 0)
      photo = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_2o7ivn$_0 = chatId;
    this.photo = photo;
    this.text_osmdoz$_0 = text;
    this.parseMode_pz7pum$_0 = parseMode;
    this.disableNotification_c3bhdt$_0 = disableNotification;
    this.replyToMessageId_7sg3ct$_0 = replyToMessageId;
    this.replyMarkup_5xvvvi$_0 = replyMarkup;
    var tmp$;
    if ((tmp$ = this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
  }
  Object.defineProperty(SendPhotoData.prototype, 'chatId', {
    get: function () {
      return this.chatId_2o7ivn$_0;
    }
  });
  Object.defineProperty(SendPhotoData.prototype, 'text', {
    get: function () {
      return this.text_osmdoz$_0;
    }
  });
  Object.defineProperty(SendPhotoData.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_pz7pum$_0;
    }
  });
  Object.defineProperty(SendPhotoData.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_c3bhdt$_0;
    }
  });
  Object.defineProperty(SendPhotoData.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_7sg3ct$_0;
    }
  });
  Object.defineProperty(SendPhotoData.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_5xvvvi$_0;
    }
  });
  SendPhotoData.prototype.method = function () {
    return 'sendPhoto';
  };
  Object.defineProperty(SendPhotoData.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_10;
    }
  });
  Object.defineProperty(SendPhotoData.prototype, 'requestSerializer', {
    get: function () {
      return SendPhotoData$Companion_getInstance().serializer();
    }
  });
  function SendPhotoData$Companion() {
    SendPhotoData$Companion_instance = this;
  }
  SendPhotoData$Companion.prototype.serializer = function () {
    return SendPhotoData$$serializer_getInstance();
  };
  SendPhotoData$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendPhotoData$Companion_instance = null;
  function SendPhotoData$Companion_getInstance() {
    if (SendPhotoData$Companion_instance === null) {
      new SendPhotoData$Companion();
    }
    return SendPhotoData$Companion_instance;
  }
  function SendPhotoData$$serializer() {
    this.descriptor_ci5hif$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendPhotoData', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('photo', true);
    this.descriptor.addElement_ivxn3r$('caption', true);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendPhotoData$$serializer_instance = this;
  }
  Object.defineProperty(SendPhotoData$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_ci5hif$_0;
    }
  });
  SendPhotoData$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    if (!equals(obj.photo, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.StringSerializer, obj.photo);
    if (!equals(obj.text, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.StringSerializer, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 4, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendPhotoData$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.StringSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, ParseModeSerializerObject_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.LongSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, KeyboardMarkupSerializer_getInstance(), local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendPhotoData_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, null);
  };
  SendPhotoData$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(ParseModeSerializerObject_getInstance()), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendPhotoData$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendPhotoData$$serializer_instance = null;
  function SendPhotoData$$serializer_getInstance() {
    if (SendPhotoData$$serializer_instance === null) {
      new SendPhotoData$$serializer();
    }
    return SendPhotoData$$serializer_instance;
  }
  function SendPhotoData_init(seen1, chatId, photo, text, parseMode, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var tmp$;
    var $this = serializationConstructorMarker || Object.create(SendPhotoData.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_2o7ivn$_0 = chatId;
    if ((seen1 & 2) === 0)
      $this.photo = null;
    else
      $this.photo = photo;
    if ((seen1 & 4) === 0)
      $this.text_osmdoz$_0 = null;
    else
      $this.text_osmdoz$_0 = text;
    if ((seen1 & 8) === 0)
      $this.parseMode_pz7pum$_0 = null;
    else
      $this.parseMode_pz7pum$_0 = parseMode;
    if ((seen1 & 16) === 0)
      $this.disableNotification_c3bhdt$_0 = false;
    else
      $this.disableNotification_c3bhdt$_0 = disableNotification;
    if ((seen1 & 32) === 0)
      $this.replyToMessageId_7sg3ct$_0 = null;
    else
      $this.replyToMessageId_7sg3ct$_0 = replyToMessageId;
    if ((seen1 & 64) === 0)
      $this.replyMarkup_5xvvvi$_0 = null;
    else
      $this.replyMarkup_5xvvvi$_0 = replyMarkup;
    if ((tmp$ = $this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
    return $this;
  }
  SendPhotoData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendPhotoData',
    interfaces: [TextableSendMessageRequest, ReplyingMarkupSendMessageRequest, SendMessageRequest, DataRequest]
  };
  SendPhotoData.prototype.component1 = function () {
    return this.chatId;
  };
  SendPhotoData.prototype.component2 = function () {
    return this.photo;
  };
  SendPhotoData.prototype.component3 = function () {
    return this.text;
  };
  SendPhotoData.prototype.component4 = function () {
    return this.parseMode;
  };
  SendPhotoData.prototype.component5 = function () {
    return this.disableNotification;
  };
  SendPhotoData.prototype.component6 = function () {
    return this.replyToMessageId;
  };
  SendPhotoData.prototype.component7 = function () {
    return this.replyMarkup;
  };
  SendPhotoData.prototype.copy_6d1q3z$ = function (chatId, photo, text, parseMode, disableNotification, replyToMessageId, replyMarkup) {
    return new SendPhotoData(chatId === void 0 ? this.chatId : chatId, photo === void 0 ? this.photo : photo, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendPhotoData.prototype.toString = function () {
    return 'SendPhotoData(chatId=' + Kotlin.toString(this.chatId) + (', photo=' + Kotlin.toString(this.photo)) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendPhotoData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.photo) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendPhotoData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.photo, other.photo) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function SendPhotoFiles(photo) {
    this.photo = photo;
    this.$delegate_f4ks0d$_0 = mapOf(to(photoField, photo));
  }
  Object.defineProperty(SendPhotoFiles.prototype, 'entries', {
    get: function () {
      return this.$delegate_f4ks0d$_0.entries;
    }
  });
  Object.defineProperty(SendPhotoFiles.prototype, 'keys', {
    get: function () {
      return this.$delegate_f4ks0d$_0.keys;
    }
  });
  Object.defineProperty(SendPhotoFiles.prototype, 'size', {
    get: function () {
      return this.$delegate_f4ks0d$_0.size;
    }
  });
  Object.defineProperty(SendPhotoFiles.prototype, 'values', {
    get: function () {
      return this.$delegate_f4ks0d$_0.values;
    }
  });
  SendPhotoFiles.prototype.containsKey_11rb$ = function (key) {
    return this.$delegate_f4ks0d$_0.containsKey_11rb$(key);
  };
  SendPhotoFiles.prototype.containsValue_11rc$ = function (value) {
    return this.$delegate_f4ks0d$_0.containsValue_11rc$(value);
  };
  SendPhotoFiles.prototype.get_11rb$ = function (key) {
    return this.$delegate_f4ks0d$_0.get_11rb$(key);
  };
  SendPhotoFiles.prototype.isEmpty = function () {
    return this.$delegate_f4ks0d$_0.isEmpty();
  };
  SendPhotoFiles.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendPhotoFiles',
    interfaces: [Map]
  };
  SendPhotoFiles.prototype.component1 = function () {
    return this.photo;
  };
  SendPhotoFiles.prototype.copy_sor8sb$ = function (photo) {
    return new SendPhotoFiles(photo === void 0 ? this.photo : photo);
  };
  SendPhotoFiles.prototype.toString = function () {
    return 'SendPhotoFiles(photo=' + Kotlin.toString(this.photo) + ')';
  };
  SendPhotoFiles.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.photo) | 0;
    return result;
  };
  SendPhotoFiles.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.photo, other.photo))));
  };
  function SendSticker(chatId, sticker, disableNotification, replyToMessageId, replyMarkup) {
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$;
    var it = new SendStickerByFileId(chatId, Kotlin.isType(tmp$ = sticker, FileId) ? tmp$ : null, disableNotification, replyToMessageId, replyMarkup);
    var block$result;
    if (Kotlin.isType(sticker, MultipartFile)) {
      block$result = new SendStickerByFile(it, sticker);
    }
     else if (Kotlin.isType(sticker, FileId)) {
      block$result = it;
    }
     else {
      block$result = Kotlin.noWhenBranchMatched();
    }
    return block$result;
  }
  var commonResultDeserializer_11;
  function SendStickerByFileId(chatId, sticker, disableNotification, replyToMessageId, replyMarkup) {
    SendStickerByFileId$Companion_getInstance();
    if (sticker === void 0)
      sticker = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_v5plhg$_0 = chatId;
    this.sticker = sticker;
    this.disableNotification_s6pkby$_0 = disableNotification;
    this.replyToMessageId_fmt27i$_0 = replyToMessageId;
    this.replyMarkup_xr6ex9$_0 = replyMarkup;
  }
  Object.defineProperty(SendStickerByFileId.prototype, 'chatId', {
    get: function () {
      return this.chatId_v5plhg$_0;
    }
  });
  Object.defineProperty(SendStickerByFileId.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_s6pkby$_0;
    }
  });
  Object.defineProperty(SendStickerByFileId.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_fmt27i$_0;
    }
  });
  Object.defineProperty(SendStickerByFileId.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_xr6ex9$_0;
    }
  });
  SendStickerByFileId.prototype.method = function () {
    return 'sendSticker';
  };
  Object.defineProperty(SendStickerByFileId.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_11;
    }
  });
  Object.defineProperty(SendStickerByFileId.prototype, 'requestSerializer', {
    get: function () {
      return SendStickerByFileId$Companion_getInstance().serializer();
    }
  });
  function SendStickerByFileId$Companion() {
    SendStickerByFileId$Companion_instance = this;
  }
  SendStickerByFileId$Companion.prototype.serializer = function () {
    return SendStickerByFileId$$serializer_getInstance();
  };
  SendStickerByFileId$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendStickerByFileId$Companion_instance = null;
  function SendStickerByFileId$Companion_getInstance() {
    if (SendStickerByFileId$Companion_instance === null) {
      new SendStickerByFileId$Companion();
    }
    return SendStickerByFileId$Companion_instance;
  }
  function SendStickerByFileId$$serializer() {
    this.descriptor_qrd0go$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendStickerByFileId', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('sticker', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendStickerByFileId$$serializer_instance = this;
  }
  Object.defineProperty(SendStickerByFileId$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_qrd0go$_0;
    }
  });
  SendStickerByFileId$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    if (!equals(obj.sticker, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, InputFileSerializer_getInstance(), obj.sticker);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 2, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendStickerByFileId$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, InputFileSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, InputFileSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.LongSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, KeyboardMarkupSerializer_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendStickerByFileId_init(bitMask0, local0, local1, local2, local3, local4, null);
  };
  SendStickerByFileId$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), new NullableSerializer(InputFileSerializer_getInstance()), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendStickerByFileId$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendStickerByFileId$$serializer_instance = null;
  function SendStickerByFileId$$serializer_getInstance() {
    if (SendStickerByFileId$$serializer_instance === null) {
      new SendStickerByFileId$$serializer();
    }
    return SendStickerByFileId$$serializer_instance;
  }
  function SendStickerByFileId_init(seen1, chatId, sticker, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SendStickerByFileId.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_v5plhg$_0 = chatId;
    if ((seen1 & 2) === 0)
      $this.sticker = null;
    else
      $this.sticker = sticker;
    if ((seen1 & 4) === 0)
      $this.disableNotification_s6pkby$_0 = false;
    else
      $this.disableNotification_s6pkby$_0 = disableNotification;
    if ((seen1 & 8) === 0)
      $this.replyToMessageId_fmt27i$_0 = null;
    else
      $this.replyToMessageId_fmt27i$_0 = replyToMessageId;
    if ((seen1 & 16) === 0)
      $this.replyMarkup_xr6ex9$_0 = null;
    else
      $this.replyMarkup_xr6ex9$_0 = replyMarkup;
    return $this;
  }
  SendStickerByFileId.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendStickerByFileId',
    interfaces: [ReplyingMarkupSendMessageRequest, SendMessageRequest]
  };
  SendStickerByFileId.prototype.component1 = function () {
    return this.chatId;
  };
  SendStickerByFileId.prototype.component2 = function () {
    return this.sticker;
  };
  SendStickerByFileId.prototype.component3 = function () {
    return this.disableNotification;
  };
  SendStickerByFileId.prototype.component4 = function () {
    return this.replyToMessageId;
  };
  SendStickerByFileId.prototype.component5 = function () {
    return this.replyMarkup;
  };
  SendStickerByFileId.prototype.copy_rcbom$ = function (chatId, sticker, disableNotification, replyToMessageId, replyMarkup) {
    return new SendStickerByFileId(chatId === void 0 ? this.chatId : chatId, sticker === void 0 ? this.sticker : sticker, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendStickerByFileId.prototype.toString = function () {
    return 'SendStickerByFileId(chatId=' + Kotlin.toString(this.chatId) + (', sticker=' + Kotlin.toString(this.sticker)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendStickerByFileId.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.sticker) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendStickerByFileId.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.sticker, other.sticker) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function SendStickerByFile(sendStickerByFileId, sticker) {
    this.sendStickerByFileId_0 = sendStickerByFileId;
    this.sticker = sticker;
    this.mediaMap_wnw86c$_0 = mapOf(to(stickerField, this.sticker));
    var $receiver = this.sendStickerByFileId_0;
    var serializer = SendStickerByFileId$Companion_getInstance().serializer();
    this.paramsJson_sfxp7e$_0 = withoutNulls_0(Json.Companion.nonstrict.toJson_tf03ej$(serializer, $receiver).jsonObject);
  }
  Object.defineProperty(SendStickerByFile.prototype, 'mediaMap', {
    get: function () {
      return this.mediaMap_wnw86c$_0;
    }
  });
  Object.defineProperty(SendStickerByFile.prototype, 'paramsJson', {
    get: function () {
      return this.paramsJson_sfxp7e$_0;
    }
  });
  Object.defineProperty(SendStickerByFile.prototype, 'resultDeserializer', {
    get: function () {
      return this.sendStickerByFileId_0.resultDeserializer;
    }
  });
  SendStickerByFile.prototype.method = function () {
    return this.sendStickerByFileId_0.method();
  };
  SendStickerByFile.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendStickerByFile',
    interfaces: [MultipartRequest, Request]
  };
  SendStickerByFile.prototype.component1_0 = function () {
    return this.sendStickerByFileId_0;
  };
  SendStickerByFile.prototype.component2 = function () {
    return this.sticker;
  };
  SendStickerByFile.prototype.copy_ibyh3i$ = function (sendStickerByFileId, sticker) {
    return new SendStickerByFile(sendStickerByFileId === void 0 ? this.sendStickerByFileId_0 : sendStickerByFileId, sticker === void 0 ? this.sticker : sticker);
  };
  SendStickerByFile.prototype.toString = function () {
    return 'SendStickerByFile(sendStickerByFileId=' + Kotlin.toString(this.sendStickerByFileId_0) + (', sticker=' + Kotlin.toString(this.sticker)) + ')';
  };
  SendStickerByFile.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.sendStickerByFileId_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.sticker) | 0;
    return result;
  };
  SendStickerByFile.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.sendStickerByFileId_0, other.sendStickerByFileId_0) && Kotlin.equals(this.sticker, other.sticker)))));
  };
  function SendVideo(chatId, video, thumb, caption, parseMode, duration, width, height, supportStreaming, disableNotification, replyToMessageId, replyMarkup) {
    if (thumb === void 0)
      thumb = null;
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (width === void 0)
      width = null;
    if (height === void 0)
      height = null;
    if (supportStreaming === void 0)
      supportStreaming = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    var videoAsFileId = (tmp$_0 = Kotlin.isType(tmp$ = video, FileId) ? tmp$ : null) != null ? tmp$_0.fileId : null;
    var videoAsFile = Kotlin.isType(tmp$_1 = video, MultipartFile) ? tmp$_1 : null;
    var thumbAsFileId = (tmp$_3 = Kotlin.isType(tmp$_2 = thumb, FileId) ? tmp$_2 : null) != null ? tmp$_3.fileId : null;
    var thumbAsFile = Kotlin.isType(tmp$_4 = thumb, MultipartFile) ? tmp$_4 : null;
    var data = new SendVideoData(chatId, videoAsFileId, thumbAsFileId, caption, parseMode, duration, width, height, supportStreaming, disableNotification, replyToMessageId, replyMarkup);
    if (videoAsFile == null && thumbAsFile == null) {
      tmp$_5 = data;
    }
     else {
      tmp$_5 = new MultipartRequestImpl(data, new SendVideoFiles(videoAsFile, thumbAsFile));
    }
    return tmp$_5;
  }
  var commonResultDeserializer_12;
  function SendVideoData(chatId, video, thumb, text, parseMode, duration, width, height, supportStreaming, disableNotification, replyToMessageId, replyMarkup) {
    SendVideoData$Companion_getInstance();
    if (video === void 0)
      video = null;
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (width === void 0)
      width = null;
    if (height === void 0)
      height = null;
    if (supportStreaming === void 0)
      supportStreaming = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_pnzwju$_0 = chatId;
    this.video = video;
    this.thumb_fokbaj$_0 = thumb;
    this.text_ppmiw4$_0 = text;
    this.parseMode_u7ev5h$_0 = parseMode;
    this.duration_4lo2z$_0 = duration;
    this.width_e96cyj$_0 = width;
    this.height_om2pb2$_0 = height;
    this.supportStreaming = supportStreaming;
    this.disableNotification_pgvomg$_0 = disableNotification;
    this.replyToMessageId_ekclf8$_0 = replyToMessageId;
    this.replyMarkup_85higp$_0 = replyMarkup;
    var tmp$;
    if ((tmp$ = this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
  }
  Object.defineProperty(SendVideoData.prototype, 'chatId', {
    get: function () {
      return this.chatId_pnzwju$_0;
    }
  });
  Object.defineProperty(SendVideoData.prototype, 'thumb', {
    get: function () {
      return this.thumb_fokbaj$_0;
    }
  });
  Object.defineProperty(SendVideoData.prototype, 'text', {
    get: function () {
      return this.text_ppmiw4$_0;
    }
  });
  Object.defineProperty(SendVideoData.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_u7ev5h$_0;
    }
  });
  Object.defineProperty(SendVideoData.prototype, 'duration', {
    get: function () {
      return this.duration_4lo2z$_0;
    }
  });
  Object.defineProperty(SendVideoData.prototype, 'width', {
    get: function () {
      return this.width_e96cyj$_0;
    }
  });
  Object.defineProperty(SendVideoData.prototype, 'height', {
    get: function () {
      return this.height_om2pb2$_0;
    }
  });
  Object.defineProperty(SendVideoData.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_pgvomg$_0;
    }
  });
  Object.defineProperty(SendVideoData.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_ekclf8$_0;
    }
  });
  Object.defineProperty(SendVideoData.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_85higp$_0;
    }
  });
  SendVideoData.prototype.method = function () {
    return 'sendVideo';
  };
  Object.defineProperty(SendVideoData.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_12;
    }
  });
  Object.defineProperty(SendVideoData.prototype, 'requestSerializer', {
    get: function () {
      return SendVideoData$Companion_getInstance().serializer();
    }
  });
  function SendVideoData$Companion() {
    SendVideoData$Companion_instance = this;
  }
  SendVideoData$Companion.prototype.serializer = function () {
    return SendVideoData$$serializer_getInstance();
  };
  SendVideoData$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendVideoData$Companion_instance = null;
  function SendVideoData$Companion_getInstance() {
    if (SendVideoData$Companion_instance === null) {
      new SendVideoData$Companion();
    }
    return SendVideoData$Companion_instance;
  }
  function SendVideoData$$serializer() {
    this.descriptor_q3j0ma$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendVideoData', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('video', true);
    this.descriptor.addElement_ivxn3r$('thumb', true);
    this.descriptor.addElement_ivxn3r$('caption', true);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('duration', true);
    this.descriptor.addElement_ivxn3r$('width', true);
    this.descriptor.addElement_ivxn3r$('height', true);
    this.descriptor.addElement_ivxn3r$('support_streaming', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendVideoData$$serializer_instance = this;
  }
  Object.defineProperty(SendVideoData$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_q3j0ma$_0;
    }
  });
  SendVideoData$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    if (!equals(obj.video, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.StringSerializer, obj.video);
    if (!equals(obj.thumb, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.StringSerializer, obj.thumb);
    if (!equals(obj.text, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.duration, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.LongSerializer, obj.duration);
    if (!equals(obj.width, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, internal.IntSerializer, obj.width);
    if (!equals(obj.height, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, internal.IntSerializer, obj.height);
    if (!equals(obj.supportStreaming, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 8, internal.BooleanSerializer, obj.supportStreaming);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 9))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 9, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 10))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 10, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 11))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 11, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendVideoData$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9
    , local10
    , local11;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.StringSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.LongSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, internal.IntSerializer, local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, internal.IntSerializer, local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = (bitMask0 & 256) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 8, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 8, internal.BooleanSerializer, local8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case 10:
          local10 = (bitMask0 & 1024) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 10, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 10, internal.LongSerializer, local10);
          bitMask0 |= 1024;
          if (!readAll)
            break;
        case 11:
          local11 = (bitMask0 & 2048) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 11, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 11, KeyboardMarkupSerializer_getInstance(), local11);
          bitMask0 |= 2048;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendVideoData_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, local10, local11, null);
  };
  SendVideoData$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(internal.LongSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(internal.BooleanSerializer), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendVideoData$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendVideoData$$serializer_instance = null;
  function SendVideoData$$serializer_getInstance() {
    if (SendVideoData$$serializer_instance === null) {
      new SendVideoData$$serializer();
    }
    return SendVideoData$$serializer_instance;
  }
  function SendVideoData_init(seen1, chatId, video, thumb, text, parseMode, duration, width, height, supportStreaming, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var tmp$;
    var $this = serializationConstructorMarker || Object.create(SendVideoData.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_pnzwju$_0 = chatId;
    if ((seen1 & 2) === 0)
      $this.video = null;
    else
      $this.video = video;
    if ((seen1 & 4) === 0)
      $this.thumb_fokbaj$_0 = null;
    else
      $this.thumb_fokbaj$_0 = thumb;
    if ((seen1 & 8) === 0)
      $this.text_ppmiw4$_0 = null;
    else
      $this.text_ppmiw4$_0 = text;
    if ((seen1 & 16) === 0)
      $this.parseMode_u7ev5h$_0 = null;
    else
      $this.parseMode_u7ev5h$_0 = parseMode;
    if ((seen1 & 32) === 0)
      $this.duration_4lo2z$_0 = null;
    else
      $this.duration_4lo2z$_0 = duration;
    if ((seen1 & 64) === 0)
      $this.width_e96cyj$_0 = null;
    else
      $this.width_e96cyj$_0 = width;
    if ((seen1 & 128) === 0)
      $this.height_om2pb2$_0 = null;
    else
      $this.height_om2pb2$_0 = height;
    if ((seen1 & 256) === 0)
      $this.supportStreaming = null;
    else
      $this.supportStreaming = supportStreaming;
    if ((seen1 & 512) === 0)
      $this.disableNotification_pgvomg$_0 = false;
    else
      $this.disableNotification_pgvomg$_0 = disableNotification;
    if ((seen1 & 1024) === 0)
      $this.replyToMessageId_ekclf8$_0 = null;
    else
      $this.replyToMessageId_ekclf8$_0 = replyToMessageId;
    if ((seen1 & 2048) === 0)
      $this.replyMarkup_85higp$_0 = null;
    else
      $this.replyMarkup_85higp$_0 = replyMarkup;
    if ((tmp$ = $this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
    return $this;
  }
  SendVideoData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendVideoData',
    interfaces: [SizedSendMessageRequest, DuratedSendMessageRequest, ThumbedSendMessageRequest, TextableSendMessageRequest, ReplyingMarkupSendMessageRequest, SendMessageRequest, DataRequest]
  };
  SendVideoData.prototype.component1 = function () {
    return this.chatId;
  };
  SendVideoData.prototype.component2 = function () {
    return this.video;
  };
  SendVideoData.prototype.component3 = function () {
    return this.thumb;
  };
  SendVideoData.prototype.component4 = function () {
    return this.text;
  };
  SendVideoData.prototype.component5 = function () {
    return this.parseMode;
  };
  SendVideoData.prototype.component6 = function () {
    return this.duration;
  };
  SendVideoData.prototype.component7 = function () {
    return this.width;
  };
  SendVideoData.prototype.component8 = function () {
    return this.height;
  };
  SendVideoData.prototype.component9 = function () {
    return this.supportStreaming;
  };
  SendVideoData.prototype.component10 = function () {
    return this.disableNotification;
  };
  SendVideoData.prototype.component11 = function () {
    return this.replyToMessageId;
  };
  SendVideoData.prototype.component12 = function () {
    return this.replyMarkup;
  };
  SendVideoData.prototype.copy_ozdsye$ = function (chatId, video, thumb, text, parseMode, duration, width, height, supportStreaming, disableNotification, replyToMessageId, replyMarkup) {
    return new SendVideoData(chatId === void 0 ? this.chatId : chatId, video === void 0 ? this.video : video, thumb === void 0 ? this.thumb : thumb, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, duration === void 0 ? this.duration : duration, width === void 0 ? this.width : width, height === void 0 ? this.height : height, supportStreaming === void 0 ? this.supportStreaming : supportStreaming, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendVideoData.prototype.toString = function () {
    return 'SendVideoData(chatId=' + Kotlin.toString(this.chatId) + (', video=' + Kotlin.toString(this.video)) + (', thumb=' + Kotlin.toString(this.thumb)) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', duration=' + Kotlin.toString(this.duration)) + (', width=' + Kotlin.toString(this.width)) + (', height=' + Kotlin.toString(this.height)) + (', supportStreaming=' + Kotlin.toString(this.supportStreaming)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendVideoData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.video) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.duration) | 0;
    result = result * 31 + Kotlin.hashCode(this.width) | 0;
    result = result * 31 + Kotlin.hashCode(this.height) | 0;
    result = result * 31 + Kotlin.hashCode(this.supportStreaming) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendVideoData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.video, other.video) && Kotlin.equals(this.thumb, other.thumb) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.duration, other.duration) && Kotlin.equals(this.width, other.width) && Kotlin.equals(this.height, other.height) && Kotlin.equals(this.supportStreaming, other.supportStreaming) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function SendVideoFiles(video, thumb) {
    if (video === void 0)
      video = null;
    if (thumb === void 0)
      thumb = null;
    this.video = video;
    this.thumb = thumb;
    this.$delegate_38g2qk$_0 = mapOfNotNull([to(videoField, video), to(thumbField, thumb)]);
  }
  Object.defineProperty(SendVideoFiles.prototype, 'entries', {
    get: function () {
      return this.$delegate_38g2qk$_0.entries;
    }
  });
  Object.defineProperty(SendVideoFiles.prototype, 'keys', {
    get: function () {
      return this.$delegate_38g2qk$_0.keys;
    }
  });
  Object.defineProperty(SendVideoFiles.prototype, 'size', {
    get: function () {
      return this.$delegate_38g2qk$_0.size;
    }
  });
  Object.defineProperty(SendVideoFiles.prototype, 'values', {
    get: function () {
      return this.$delegate_38g2qk$_0.values;
    }
  });
  SendVideoFiles.prototype.containsKey_11rb$ = function (key) {
    return this.$delegate_38g2qk$_0.containsKey_11rb$(key);
  };
  SendVideoFiles.prototype.containsValue_11rc$ = function (value) {
    return this.$delegate_38g2qk$_0.containsValue_11rc$(value);
  };
  SendVideoFiles.prototype.get_11rb$ = function (key) {
    return this.$delegate_38g2qk$_0.get_11rb$(key);
  };
  SendVideoFiles.prototype.isEmpty = function () {
    return this.$delegate_38g2qk$_0.isEmpty();
  };
  SendVideoFiles.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendVideoFiles',
    interfaces: [Map]
  };
  SendVideoFiles.prototype.component1 = function () {
    return this.video;
  };
  SendVideoFiles.prototype.component2 = function () {
    return this.thumb;
  };
  SendVideoFiles.prototype.copy_sm2yek$ = function (video, thumb) {
    return new SendVideoFiles(video === void 0 ? this.video : video, thumb === void 0 ? this.thumb : thumb);
  };
  SendVideoFiles.prototype.toString = function () {
    return 'SendVideoFiles(video=' + Kotlin.toString(this.video) + (', thumb=' + Kotlin.toString(this.thumb)) + ')';
  };
  SendVideoFiles.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.video) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    return result;
  };
  SendVideoFiles.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.video, other.video) && Kotlin.equals(this.thumb, other.thumb)))));
  };
  function SendVideoNote(chatId, videoNote, thumb, caption, parseMode, duration, size, disableNotification, replyToMessageId, replyMarkup) {
    if (thumb === void 0)
      thumb = null;
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (size === void 0)
      size = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    var videoNoteAsFileId = (tmp$_0 = Kotlin.isType(tmp$ = videoNote, FileId) ? tmp$ : null) != null ? tmp$_0.fileId : null;
    var videoNoteAsFile = Kotlin.isType(tmp$_1 = videoNote, MultipartFile) ? tmp$_1 : null;
    var thumbAsFileId = (tmp$_3 = Kotlin.isType(tmp$_2 = thumb, FileId) ? tmp$_2 : null) != null ? tmp$_3.fileId : null;
    var thumbAsFile = Kotlin.isType(tmp$_4 = thumb, MultipartFile) ? tmp$_4 : null;
    var data = new SendVideoNoteData(chatId, videoNoteAsFileId, thumbAsFileId, caption, parseMode, duration, size, disableNotification, replyToMessageId, replyMarkup);
    if (videoNoteAsFile == null && thumbAsFile == null) {
      tmp$_5 = data;
    }
     else {
      tmp$_5 = new MultipartRequestImpl(data, new SendVideoNoteFiles(videoNoteAsFile, thumbAsFile));
    }
    return tmp$_5;
  }
  var commonResultDeserializer_13;
  function SendVideoNoteData(chatId, videoNote, thumb, text, parseMode, duration, width, disableNotification, replyToMessageId, replyMarkup) {
    SendVideoNoteData$Companion_getInstance();
    if (videoNote === void 0)
      videoNote = null;
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (width === void 0)
      width = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_qvh9tk$_0 = chatId;
    this.videoNote = videoNote;
    this.thumb_b4zpj1$_0 = thumb;
    this.text_ddxs6m$_0 = text;
    this.parseMode_b3lpr1$_0 = parseMode;
    this.duration_odg109$_0 = duration;
    this.width_9plr71$_0 = width;
    this.disableNotification_8mo4li$_0 = disableNotification;
    this.replyToMessageId_3jitni$_0 = replyToMessageId;
    this.replyMarkup_jcy73b$_0 = replyMarkup;
    var tmp$;
    if ((tmp$ = this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
  }
  Object.defineProperty(SendVideoNoteData.prototype, 'chatId', {
    get: function () {
      return this.chatId_qvh9tk$_0;
    }
  });
  Object.defineProperty(SendVideoNoteData.prototype, 'thumb', {
    get: function () {
      return this.thumb_b4zpj1$_0;
    }
  });
  Object.defineProperty(SendVideoNoteData.prototype, 'text', {
    get: function () {
      return this.text_ddxs6m$_0;
    }
  });
  Object.defineProperty(SendVideoNoteData.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_b3lpr1$_0;
    }
  });
  Object.defineProperty(SendVideoNoteData.prototype, 'duration', {
    get: function () {
      return this.duration_odg109$_0;
    }
  });
  Object.defineProperty(SendVideoNoteData.prototype, 'width', {
    get: function () {
      return this.width_9plr71$_0;
    }
  });
  Object.defineProperty(SendVideoNoteData.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_8mo4li$_0;
    }
  });
  Object.defineProperty(SendVideoNoteData.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_3jitni$_0;
    }
  });
  Object.defineProperty(SendVideoNoteData.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_jcy73b$_0;
    }
  });
  Object.defineProperty(SendVideoNoteData.prototype, 'height', {
    get: function () {
      return this.width;
    }
  });
  SendVideoNoteData.prototype.method = function () {
    return 'sendVideoNote';
  };
  Object.defineProperty(SendVideoNoteData.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_13;
    }
  });
  Object.defineProperty(SendVideoNoteData.prototype, 'requestSerializer', {
    get: function () {
      return SendVideoNoteData$Companion_getInstance().serializer();
    }
  });
  function SendVideoNoteData$Companion() {
    SendVideoNoteData$Companion_instance = this;
  }
  SendVideoNoteData$Companion.prototype.serializer = function () {
    return SendVideoNoteData$$serializer_getInstance();
  };
  SendVideoNoteData$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendVideoNoteData$Companion_instance = null;
  function SendVideoNoteData$Companion_getInstance() {
    if (SendVideoNoteData$Companion_instance === null) {
      new SendVideoNoteData$Companion();
    }
    return SendVideoNoteData$Companion_instance;
  }
  function SendVideoNoteData$$serializer() {
    this.descriptor_pxnszw$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendVideoNoteData', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('video_note', true);
    this.descriptor.addElement_ivxn3r$('thumb', true);
    this.descriptor.addElement_ivxn3r$('caption', true);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('duration', true);
    this.descriptor.addElement_ivxn3r$('length', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendVideoNoteData$$serializer_instance = this;
  }
  Object.defineProperty(SendVideoNoteData$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_pxnszw$_0;
    }
  });
  SendVideoNoteData$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    if (!equals(obj.videoNote, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.StringSerializer, obj.videoNote);
    if (!equals(obj.thumb, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.StringSerializer, obj.thumb);
    if (!equals(obj.text, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.duration, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.LongSerializer, obj.duration);
    if (!equals(obj.width, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, internal.IntSerializer, obj.width);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 7, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 8, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 9))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 9, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendVideoNoteData$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.StringSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.LongSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, internal.IntSerializer, local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = (bitMask0 & 256) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 8, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 8, internal.LongSerializer, local8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = (bitMask0 & 512) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 9, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 9, KeyboardMarkupSerializer_getInstance(), local9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendVideoNoteData_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, null);
  };
  SendVideoNoteData$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(internal.LongSerializer), new NullableSerializer(internal.IntSerializer), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendVideoNoteData$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendVideoNoteData$$serializer_instance = null;
  function SendVideoNoteData$$serializer_getInstance() {
    if (SendVideoNoteData$$serializer_instance === null) {
      new SendVideoNoteData$$serializer();
    }
    return SendVideoNoteData$$serializer_instance;
  }
  function SendVideoNoteData_init(seen1, chatId, videoNote, thumb, text, parseMode, duration, width, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var tmp$;
    var $this = serializationConstructorMarker || Object.create(SendVideoNoteData.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_qvh9tk$_0 = chatId;
    if ((seen1 & 2) === 0)
      $this.videoNote = null;
    else
      $this.videoNote = videoNote;
    if ((seen1 & 4) === 0)
      $this.thumb_b4zpj1$_0 = null;
    else
      $this.thumb_b4zpj1$_0 = thumb;
    if ((seen1 & 8) === 0)
      $this.text_ddxs6m$_0 = null;
    else
      $this.text_ddxs6m$_0 = text;
    if ((seen1 & 16) === 0)
      $this.parseMode_b3lpr1$_0 = null;
    else
      $this.parseMode_b3lpr1$_0 = parseMode;
    if ((seen1 & 32) === 0)
      $this.duration_odg109$_0 = null;
    else
      $this.duration_odg109$_0 = duration;
    if ((seen1 & 64) === 0)
      $this.width_9plr71$_0 = null;
    else
      $this.width_9plr71$_0 = width;
    if ((seen1 & 128) === 0)
      $this.disableNotification_8mo4li$_0 = false;
    else
      $this.disableNotification_8mo4li$_0 = disableNotification;
    if ((seen1 & 256) === 0)
      $this.replyToMessageId_3jitni$_0 = null;
    else
      $this.replyToMessageId_3jitni$_0 = replyToMessageId;
    if ((seen1 & 512) === 0)
      $this.replyMarkup_jcy73b$_0 = null;
    else
      $this.replyMarkup_jcy73b$_0 = replyMarkup;
    if ((tmp$ = $this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
    return $this;
  }
  SendVideoNoteData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendVideoNoteData',
    interfaces: [SizedSendMessageRequest, DuratedSendMessageRequest, ThumbedSendMessageRequest, TextableSendMessageRequest, ReplyingMarkupSendMessageRequest, SendMessageRequest, DataRequest]
  };
  SendVideoNoteData.prototype.component1 = function () {
    return this.chatId;
  };
  SendVideoNoteData.prototype.component2 = function () {
    return this.videoNote;
  };
  SendVideoNoteData.prototype.component3 = function () {
    return this.thumb;
  };
  SendVideoNoteData.prototype.component4 = function () {
    return this.text;
  };
  SendVideoNoteData.prototype.component5 = function () {
    return this.parseMode;
  };
  SendVideoNoteData.prototype.component6 = function () {
    return this.duration;
  };
  SendVideoNoteData.prototype.component7 = function () {
    return this.width;
  };
  SendVideoNoteData.prototype.component8 = function () {
    return this.disableNotification;
  };
  SendVideoNoteData.prototype.component9 = function () {
    return this.replyToMessageId;
  };
  SendVideoNoteData.prototype.component10 = function () {
    return this.replyMarkup;
  };
  SendVideoNoteData.prototype.copy_ipehbh$ = function (chatId, videoNote, thumb, text, parseMode, duration, width, disableNotification, replyToMessageId, replyMarkup) {
    return new SendVideoNoteData(chatId === void 0 ? this.chatId : chatId, videoNote === void 0 ? this.videoNote : videoNote, thumb === void 0 ? this.thumb : thumb, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, duration === void 0 ? this.duration : duration, width === void 0 ? this.width : width, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendVideoNoteData.prototype.toString = function () {
    return 'SendVideoNoteData(chatId=' + Kotlin.toString(this.chatId) + (', videoNote=' + Kotlin.toString(this.videoNote)) + (', thumb=' + Kotlin.toString(this.thumb)) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', duration=' + Kotlin.toString(this.duration)) + (', width=' + Kotlin.toString(this.width)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendVideoNoteData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.videoNote) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.duration) | 0;
    result = result * 31 + Kotlin.hashCode(this.width) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendVideoNoteData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.videoNote, other.videoNote) && Kotlin.equals(this.thumb, other.thumb) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.duration, other.duration) && Kotlin.equals(this.width, other.width) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function SendVideoNoteFiles(videoNote, thumb) {
    if (videoNote === void 0)
      videoNote = null;
    if (thumb === void 0)
      thumb = null;
    this.videoNote = videoNote;
    this.thumb = thumb;
    this.$delegate_9sh1oy$_0 = mapOfNotNull([to(videoNoteField, videoNote), to(thumbField, thumb)]);
  }
  Object.defineProperty(SendVideoNoteFiles.prototype, 'entries', {
    get: function () {
      return this.$delegate_9sh1oy$_0.entries;
    }
  });
  Object.defineProperty(SendVideoNoteFiles.prototype, 'keys', {
    get: function () {
      return this.$delegate_9sh1oy$_0.keys;
    }
  });
  Object.defineProperty(SendVideoNoteFiles.prototype, 'size', {
    get: function () {
      return this.$delegate_9sh1oy$_0.size;
    }
  });
  Object.defineProperty(SendVideoNoteFiles.prototype, 'values', {
    get: function () {
      return this.$delegate_9sh1oy$_0.values;
    }
  });
  SendVideoNoteFiles.prototype.containsKey_11rb$ = function (key) {
    return this.$delegate_9sh1oy$_0.containsKey_11rb$(key);
  };
  SendVideoNoteFiles.prototype.containsValue_11rc$ = function (value) {
    return this.$delegate_9sh1oy$_0.containsValue_11rc$(value);
  };
  SendVideoNoteFiles.prototype.get_11rb$ = function (key) {
    return this.$delegate_9sh1oy$_0.get_11rb$(key);
  };
  SendVideoNoteFiles.prototype.isEmpty = function () {
    return this.$delegate_9sh1oy$_0.isEmpty();
  };
  SendVideoNoteFiles.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendVideoNoteFiles',
    interfaces: [Map]
  };
  SendVideoNoteFiles.prototype.component1 = function () {
    return this.videoNote;
  };
  SendVideoNoteFiles.prototype.component2 = function () {
    return this.thumb;
  };
  SendVideoNoteFiles.prototype.copy_sm2yek$ = function (videoNote, thumb) {
    return new SendVideoNoteFiles(videoNote === void 0 ? this.videoNote : videoNote, thumb === void 0 ? this.thumb : thumb);
  };
  SendVideoNoteFiles.prototype.toString = function () {
    return 'SendVideoNoteFiles(videoNote=' + Kotlin.toString(this.videoNote) + (', thumb=' + Kotlin.toString(this.thumb)) + ')';
  };
  SendVideoNoteFiles.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.videoNote) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    return result;
  };
  SendVideoNoteFiles.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.videoNote, other.videoNote) && Kotlin.equals(this.thumb, other.thumb)))));
  };
  function SendVoice(chatId, voice, thumb, caption, parseMode, duration, disableNotification, replyToMessageId, replyMarkup) {
    if (thumb === void 0)
      thumb = null;
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5;
    var voiceAsFileId = (tmp$_0 = Kotlin.isType(tmp$ = voice, FileId) ? tmp$ : null) != null ? tmp$_0.fileId : null;
    var voiceAsFile = Kotlin.isType(tmp$_1 = voice, MultipartFile) ? tmp$_1 : null;
    var thumbAsFileId = (tmp$_3 = Kotlin.isType(tmp$_2 = thumb, FileId) ? tmp$_2 : null) != null ? tmp$_3.fileId : null;
    var thumbAsFile = Kotlin.isType(tmp$_4 = thumb, MultipartFile) ? tmp$_4 : null;
    var data = new SendVoiceData(chatId, voiceAsFileId, thumbAsFileId, caption, parseMode, duration, disableNotification, replyToMessageId, replyMarkup);
    if (voiceAsFile == null && thumbAsFile == null) {
      tmp$_5 = data;
    }
     else {
      tmp$_5 = new MultipartRequestImpl(data, new SendVoiceFiles(voiceAsFile, thumbAsFile));
    }
    return tmp$_5;
  }
  var commonResultDeserializer_14;
  function SendVoiceData(chatId, voice, thumb, text, parseMode, duration, disableNotification, replyToMessageId, replyMarkup) {
    SendVoiceData$Companion_getInstance();
    if (voice === void 0)
      voice = null;
    if (thumb === void 0)
      thumb = null;
    if (text === void 0)
      text = null;
    if (parseMode === void 0)
      parseMode = null;
    if (duration === void 0)
      duration = null;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_shcleb$_0 = chatId;
    this.voice = voice;
    this.thumb_9fj1dq$_0 = thumb;
    this.text_kbhict$_0 = text;
    this.parseMode_pc5ile$_0 = parseMode;
    this.duration_6i2ugk$_0 = duration;
    this.disableNotification_eozqyn$_0 = disableNotification;
    this.replyToMessageId_vqs0zh$_0 = replyToMessageId;
    this.replyMarkup_oy084e$_0 = replyMarkup;
    var tmp$;
    if ((tmp$ = this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
  }
  Object.defineProperty(SendVoiceData.prototype, 'chatId', {
    get: function () {
      return this.chatId_shcleb$_0;
    }
  });
  Object.defineProperty(SendVoiceData.prototype, 'thumb', {
    get: function () {
      return this.thumb_9fj1dq$_0;
    }
  });
  Object.defineProperty(SendVoiceData.prototype, 'text', {
    get: function () {
      return this.text_kbhict$_0;
    }
  });
  Object.defineProperty(SendVoiceData.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_pc5ile$_0;
    }
  });
  Object.defineProperty(SendVoiceData.prototype, 'duration', {
    get: function () {
      return this.duration_6i2ugk$_0;
    }
  });
  Object.defineProperty(SendVoiceData.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_eozqyn$_0;
    }
  });
  Object.defineProperty(SendVoiceData.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_vqs0zh$_0;
    }
  });
  Object.defineProperty(SendVoiceData.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_oy084e$_0;
    }
  });
  SendVoiceData.prototype.method = function () {
    return 'sendVoice';
  };
  Object.defineProperty(SendVoiceData.prototype, 'resultDeserializer', {
    get: function () {
      return commonResultDeserializer_14;
    }
  });
  Object.defineProperty(SendVoiceData.prototype, 'requestSerializer', {
    get: function () {
      return SendVoiceData$Companion_getInstance().serializer();
    }
  });
  function SendVoiceData$Companion() {
    SendVoiceData$Companion_instance = this;
  }
  SendVoiceData$Companion.prototype.serializer = function () {
    return SendVoiceData$$serializer_getInstance();
  };
  SendVoiceData$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendVoiceData$Companion_instance = null;
  function SendVoiceData$Companion_getInstance() {
    if (SendVoiceData$Companion_instance === null) {
      new SendVoiceData$Companion();
    }
    return SendVoiceData$Companion_instance;
  }
  function SendVoiceData$$serializer() {
    this.descriptor_ornoyh$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.media.SendVoiceData', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('voice', true);
    this.descriptor.addElement_ivxn3r$('thumb', true);
    this.descriptor.addElement_ivxn3r$('caption', true);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('duration', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    SendVoiceData$$serializer_instance = this;
  }
  Object.defineProperty(SendVoiceData$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_ornoyh$_0;
    }
  });
  SendVoiceData$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    if (!equals(obj.voice, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.StringSerializer, obj.voice);
    if (!equals(obj.thumb, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.StringSerializer, obj.thumb);
    if (!equals(obj.text, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.text);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.duration, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.LongSerializer, obj.duration);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 6, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 8, KeyboardMarkupSerializer_getInstance(), obj.replyMarkup);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendVoiceData$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.StringSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, ParseModeSerializerObject_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.LongSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, internal.LongSerializer, local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = (bitMask0 & 256) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 8, KeyboardMarkupSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 8, KeyboardMarkupSerializer_getInstance(), local8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendVoiceData_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, null);
  };
  SendVoiceData$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(internal.LongSerializer), internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(KeyboardMarkupSerializer_getInstance())];
  };
  SendVoiceData$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendVoiceData$$serializer_instance = null;
  function SendVoiceData$$serializer_getInstance() {
    if (SendVoiceData$$serializer_instance === null) {
      new SendVoiceData$$serializer();
    }
    return SendVoiceData$$serializer_instance;
  }
  function SendVoiceData_init(seen1, chatId, voice, thumb, text, parseMode, duration, disableNotification, replyToMessageId, replyMarkup, serializationConstructorMarker) {
    var tmp$;
    var $this = serializationConstructorMarker || Object.create(SendVoiceData.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_shcleb$_0 = chatId;
    if ((seen1 & 2) === 0)
      $this.voice = null;
    else
      $this.voice = voice;
    if ((seen1 & 4) === 0)
      $this.thumb_9fj1dq$_0 = null;
    else
      $this.thumb_9fj1dq$_0 = thumb;
    if ((seen1 & 8) === 0)
      $this.text_kbhict$_0 = null;
    else
      $this.text_kbhict$_0 = text;
    if ((seen1 & 16) === 0)
      $this.parseMode_pc5ile$_0 = null;
    else
      $this.parseMode_pc5ile$_0 = parseMode;
    if ((seen1 & 32) === 0)
      $this.duration_6i2ugk$_0 = null;
    else
      $this.duration_6i2ugk$_0 = duration;
    if ((seen1 & 64) === 0)
      $this.disableNotification_eozqyn$_0 = false;
    else
      $this.disableNotification_eozqyn$_0 = disableNotification;
    if ((seen1 & 128) === 0)
      $this.replyToMessageId_vqs0zh$_0 = null;
    else
      $this.replyToMessageId_vqs0zh$_0 = replyToMessageId;
    if ((seen1 & 256) === 0)
      $this.replyMarkup_oy084e$_0 = null;
    else
      $this.replyMarkup_oy084e$_0 = replyMarkup;
    if ((tmp$ = $this.text) != null) {
      if (!captionLength.contains_mef7kx$(tmp$.length)) {
        throw IllegalArgumentException_init('Caption must be in ' + captionLength + ' range');
      }
    }
    return $this;
  }
  SendVoiceData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendVoiceData',
    interfaces: [DuratedSendMessageRequest, ThumbedSendMessageRequest, TextableSendMessageRequest, ReplyingMarkupSendMessageRequest, SendMessageRequest, DataRequest]
  };
  SendVoiceData.prototype.component1 = function () {
    return this.chatId;
  };
  SendVoiceData.prototype.component2 = function () {
    return this.voice;
  };
  SendVoiceData.prototype.component3 = function () {
    return this.thumb;
  };
  SendVoiceData.prototype.component4 = function () {
    return this.text;
  };
  SendVoiceData.prototype.component5 = function () {
    return this.parseMode;
  };
  SendVoiceData.prototype.component6 = function () {
    return this.duration;
  };
  SendVoiceData.prototype.component7 = function () {
    return this.disableNotification;
  };
  SendVoiceData.prototype.component8 = function () {
    return this.replyToMessageId;
  };
  SendVoiceData.prototype.component9 = function () {
    return this.replyMarkup;
  };
  SendVoiceData.prototype.copy_13ey3o$ = function (chatId, voice, thumb, text, parseMode, duration, disableNotification, replyToMessageId, replyMarkup) {
    return new SendVoiceData(chatId === void 0 ? this.chatId : chatId, voice === void 0 ? this.voice : voice, thumb === void 0 ? this.thumb : thumb, text === void 0 ? this.text : text, parseMode === void 0 ? this.parseMode : parseMode, duration === void 0 ? this.duration : duration, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendVoiceData.prototype.toString = function () {
    return 'SendVoiceData(chatId=' + Kotlin.toString(this.chatId) + (', voice=' + Kotlin.toString(this.voice)) + (', thumb=' + Kotlin.toString(this.thumb)) + (', text=' + Kotlin.toString(this.text)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', duration=' + Kotlin.toString(this.duration)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendVoiceData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.voice) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    result = result * 31 + Kotlin.hashCode(this.text) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.duration) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendVoiceData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.voice, other.voice) && Kotlin.equals(this.thumb, other.thumb) && Kotlin.equals(this.text, other.text) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.duration, other.duration) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function SendVoiceFiles(voice, thumb) {
    if (voice === void 0)
      voice = null;
    if (thumb === void 0)
      thumb = null;
    this.voice = voice;
    this.thumb = thumb;
    this.$delegate_1j4kkz$_0 = mapOfNotNull([to(voiceField, voice), to(thumbField, thumb)]);
  }
  Object.defineProperty(SendVoiceFiles.prototype, 'entries', {
    get: function () {
      return this.$delegate_1j4kkz$_0.entries;
    }
  });
  Object.defineProperty(SendVoiceFiles.prototype, 'keys', {
    get: function () {
      return this.$delegate_1j4kkz$_0.keys;
    }
  });
  Object.defineProperty(SendVoiceFiles.prototype, 'size', {
    get: function () {
      return this.$delegate_1j4kkz$_0.size;
    }
  });
  Object.defineProperty(SendVoiceFiles.prototype, 'values', {
    get: function () {
      return this.$delegate_1j4kkz$_0.values;
    }
  });
  SendVoiceFiles.prototype.containsKey_11rb$ = function (key) {
    return this.$delegate_1j4kkz$_0.containsKey_11rb$(key);
  };
  SendVoiceFiles.prototype.containsValue_11rc$ = function (value) {
    return this.$delegate_1j4kkz$_0.containsValue_11rc$(value);
  };
  SendVoiceFiles.prototype.get_11rb$ = function (key) {
    return this.$delegate_1j4kkz$_0.get_11rb$(key);
  };
  SendVoiceFiles.prototype.isEmpty = function () {
    return this.$delegate_1j4kkz$_0.isEmpty();
  };
  SendVoiceFiles.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendVoiceFiles',
    interfaces: [Map]
  };
  SendVoiceFiles.prototype.component1 = function () {
    return this.voice;
  };
  SendVoiceFiles.prototype.component2 = function () {
    return this.thumb;
  };
  SendVoiceFiles.prototype.copy_sm2yek$ = function (voice, thumb) {
    return new SendVoiceFiles(voice === void 0 ? this.voice : voice, thumb === void 0 ? this.thumb : thumb);
  };
  SendVoiceFiles.prototype.toString = function () {
    return 'SendVoiceFiles(voice=' + Kotlin.toString(this.voice) + (', thumb=' + Kotlin.toString(this.thumb)) + ')';
  };
  SendVoiceFiles.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.voice) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumb) | 0;
    return result;
  };
  SendVoiceFiles.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.voice, other.voice) && Kotlin.equals(this.thumb, other.thumb)))));
  };
  function DataRequest() {
  }
  DataRequest.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DataRequest',
    interfaces: [SimpleRequest]
  };
  function MultipartRequestImpl(data, files) {
    this.data = data;
    this.files = files;
    var $receiver = this.data;
    var tmp$;
    var serializer = Kotlin.isType(tmp$ = $receiver.requestSerializer, SerializationStrategy) ? tmp$ : throwCCE();
    this.paramsJson_8k3y82$_0 = withoutNulls_0(Json.Companion.nonstrict.toJson_tf03ej$(serializer, $receiver).jsonObject);
    this.mediaMap_jwqnp0$_0 = this.files;
  }
  MultipartRequestImpl.prototype.method = function () {
    return this.data.method();
  };
  Object.defineProperty(MultipartRequestImpl.prototype, 'resultDeserializer', {
    get: function () {
      return this.data.resultDeserializer;
    }
  });
  Object.defineProperty(MultipartRequestImpl.prototype, 'paramsJson', {
    get: function () {
      return this.paramsJson_8k3y82$_0;
    }
  });
  Object.defineProperty(MultipartRequestImpl.prototype, 'mediaMap', {
    get: function () {
      return this.mediaMap_jwqnp0$_0;
    }
  });
  MultipartRequestImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MultipartRequestImpl',
    interfaces: [MultipartRequest]
  };
  function SendInvoice(chatId, title, description, payload, providerToken, startParameter, currency, prices, providerData, requireName, requirePhoneNumber, requireEmail, requireShippingAddress, shouldSendPhoneNumberToProvider, shouldSendEmailToProvider, priceDependOnShipAddress, disableNotification, replyToMessageId, replyMarkup) {
    SendInvoice$Companion_getInstance();
    if (providerData === void 0)
      providerData = null;
    if (requireName === void 0)
      requireName = false;
    if (requirePhoneNumber === void 0)
      requirePhoneNumber = false;
    if (requireEmail === void 0)
      requireEmail = false;
    if (requireShippingAddress === void 0)
      requireShippingAddress = false;
    if (shouldSendPhoneNumberToProvider === void 0)
      shouldSendPhoneNumberToProvider = false;
    if (shouldSendEmailToProvider === void 0)
      shouldSendEmailToProvider = false;
    if (priceDependOnShipAddress === void 0)
      priceDependOnShipAddress = false;
    if (disableNotification === void 0)
      disableNotification = false;
    if (replyToMessageId === void 0)
      replyToMessageId = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    this.chatId_ajnbmb$_0 = chatId;
    this.title = title;
    this.description = description;
    this.payload = payload;
    this.providerToken = providerToken;
    this.startParameter = startParameter;
    this.currency_wiy6s5$_0 = currency;
    this.prices_6vyudg$_0 = prices;
    this.providerData = providerData;
    this.requireName = requireName;
    this.requirePhoneNumber = requirePhoneNumber;
    this.requireEmail = requireEmail;
    this.requireShippingAddress = requireShippingAddress;
    this.shouldSendPhoneNumberToProvider = shouldSendPhoneNumberToProvider;
    this.shouldSendEmailToProvider = shouldSendEmailToProvider;
    this.priceDependOnShipAddress = priceDependOnShipAddress;
    this.disableNotification_a6jp97$_0 = disableNotification;
    this.replyToMessageId_a1c7zd$_0 = replyToMessageId;
    this.replyMarkup_75e6h0$_0 = replyMarkup;
    this.photoUrl_7ml0nd$_0 = null;
    this.photoSize_nbidkr$_0 = null;
    this.photoWidth_ehhx8y$_0 = null;
    this.photoHeight_dzhff9$_0 = null;
  }
  Object.defineProperty(SendInvoice.prototype, 'chatId', {
    get: function () {
      return this.chatId_ajnbmb$_0;
    }
  });
  Object.defineProperty(SendInvoice.prototype, 'currency', {
    get: function () {
      return this.currency_wiy6s5$_0;
    }
  });
  Object.defineProperty(SendInvoice.prototype, 'prices', {
    get: function () {
      return this.prices_6vyudg$_0;
    }
  });
  Object.defineProperty(SendInvoice.prototype, 'disableNotification', {
    get: function () {
      return this.disableNotification_a6jp97$_0;
    }
  });
  Object.defineProperty(SendInvoice.prototype, 'replyToMessageId', {
    get: function () {
      return this.replyToMessageId_a1c7zd$_0;
    }
  });
  Object.defineProperty(SendInvoice.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_75e6h0$_0;
    }
  });
  SendInvoice.prototype.method = function () {
    return 'sendInvoice';
  };
  Object.defineProperty(SendInvoice.prototype, 'resultDeserializer', {
    get: function () {
      return TelegramBotAPIMessageDeserializationStrategy_getInstance();
    }
  });
  Object.defineProperty(SendInvoice.prototype, 'requestSerializer', {
    get: function () {
      return SendInvoice$Companion_getInstance().serializer();
    }
  });
  Object.defineProperty(SendInvoice.prototype, 'photoUrl', {
    get: function () {
      return this.photoUrl_7ml0nd$_0;
    },
    set: function (photoUrl) {
      this.photoUrl_7ml0nd$_0 = photoUrl;
    }
  });
  Object.defineProperty(SendInvoice.prototype, 'photoSize', {
    get: function () {
      return this.photoSize_nbidkr$_0;
    },
    set: function (photoSize) {
      this.photoSize_nbidkr$_0 = photoSize;
    }
  });
  Object.defineProperty(SendInvoice.prototype, 'photoWidth', {
    get: function () {
      return this.photoWidth_ehhx8y$_0;
    },
    set: function (photoWidth) {
      this.photoWidth_ehhx8y$_0 = photoWidth;
    }
  });
  Object.defineProperty(SendInvoice.prototype, 'photoHeight', {
    get: function () {
      return this.photoHeight_dzhff9$_0;
    },
    set: function (photoHeight) {
      this.photoHeight_dzhff9$_0 = photoHeight;
    }
  });
  SendInvoice.prototype.setPhoto_behpx6$ = function (photoUrl, photoSize, photoWidth, photoHeight) {
    if (photoSize === void 0)
      photoSize = null;
    if (photoWidth === void 0)
      photoWidth = null;
    if (photoHeight === void 0)
      photoHeight = null;
    this.photoUrl = photoUrl;
    this.photoSize = photoSize;
    this.photoWidth = photoWidth;
    this.photoHeight = photoHeight;
  };
  SendInvoice.prototype.unsetPhoto = function () {
    this.photoUrl = null;
    this.photoSize = null;
    this.photoWidth = null;
    this.photoHeight = null;
  };
  function SendInvoice$Companion() {
    SendInvoice$Companion_instance = this;
  }
  SendInvoice$Companion.prototype.serializer = function () {
    return SendInvoice$$serializer_getInstance();
  };
  SendInvoice$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SendInvoice$Companion_instance = null;
  function SendInvoice$Companion_getInstance() {
    if (SendInvoice$Companion_instance === null) {
      new SendInvoice$Companion();
    }
    return SendInvoice$Companion_instance;
  }
  function SendInvoice$$serializer() {
    this.descriptor_r8rb41$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.send.payments.SendInvoice', this);
    this.descriptor.addElement_ivxn3r$('chat_id', false);
    this.descriptor.addElement_ivxn3r$('title', false);
    this.descriptor.addElement_ivxn3r$('description', false);
    this.descriptor.addElement_ivxn3r$('payload', false);
    this.descriptor.addElement_ivxn3r$('provider_token', false);
    this.descriptor.addElement_ivxn3r$('start_parameter', false);
    this.descriptor.addElement_ivxn3r$('currency', false);
    this.descriptor.addElement_ivxn3r$('prices', false);
    this.descriptor.addElement_ivxn3r$('provider_data', true);
    this.descriptor.addElement_ivxn3r$('need_name', true);
    this.descriptor.addElement_ivxn3r$('need_phone_number', true);
    this.descriptor.addElement_ivxn3r$('need_email', true);
    this.descriptor.addElement_ivxn3r$('need_shipping_address', true);
    this.descriptor.addElement_ivxn3r$('send_phone_number_to_provider', true);
    this.descriptor.addElement_ivxn3r$('send_email_to_provider', true);
    this.descriptor.addElement_ivxn3r$('is_flexible', true);
    this.descriptor.addElement_ivxn3r$('disable_notification', true);
    this.descriptor.addElement_ivxn3r$('reply_to_message_id', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    this.descriptor.addElement_ivxn3r$('photo_url', true);
    this.descriptor.addElement_ivxn3r$('photo_size', true);
    this.descriptor.addElement_ivxn3r$('photo_width', true);
    this.descriptor.addElement_ivxn3r$('photo_height', true);
    SendInvoice$$serializer_instance = this;
  }
  Object.defineProperty(SendInvoice$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_r8rb41$_0;
    }
  });
  SendInvoice$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.chatId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.title);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.description);
    output.encodeStringElement_bgm7zs$(this.descriptor, 3, obj.payload);
    output.encodeStringElement_bgm7zs$(this.descriptor, 4, obj.providerToken);
    output.encodeStringElement_bgm7zs$(this.descriptor, 5, obj.startParameter);
    output.encodeStringElement_bgm7zs$(this.descriptor, 6, obj.currency);
    output.encodeSerializableElement_blecud$(this.descriptor, 7, LabeledPricesSerializer_getInstance(), obj.prices);
    if (!equals(obj.providerData, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 8, internal.StringSerializer, obj.providerData);
    if (!equals(obj.requireName, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 9))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 9, obj.requireName);
    if (!equals(obj.requirePhoneNumber, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 10))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 10, obj.requirePhoneNumber);
    if (!equals(obj.requireEmail, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 11))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 11, obj.requireEmail);
    if (!equals(obj.requireShippingAddress, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 12))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 12, obj.requireShippingAddress);
    if (!equals(obj.shouldSendPhoneNumberToProvider, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 13))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 13, obj.shouldSendPhoneNumberToProvider);
    if (!equals(obj.shouldSendEmailToProvider, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 14))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 14, obj.shouldSendEmailToProvider);
    if (!equals(obj.priceDependOnShipAddress, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 15))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 15, obj.priceDependOnShipAddress);
    if (!equals(obj.disableNotification, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 16))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 16, obj.disableNotification);
    if (!equals(obj.replyToMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 17))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 17, internal.LongSerializer, obj.replyToMessageId);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 18))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 18, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    if (!equals(obj.photoUrl, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 19))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 19, internal.StringSerializer, obj.photoUrl);
    if (!equals(obj.photoSize, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 20))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 20, internal.LongSerializer, obj.photoSize);
    if (!equals(obj.photoWidth, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 21))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 21, internal.IntSerializer, obj.photoWidth);
    if (!equals(obj.photoHeight, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 22))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 22, internal.IntSerializer, obj.photoHeight);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SendInvoice$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9
    , local10
    , local11
    , local12
    , local13
    , local14
    , local15
    , local16
    , local17
    , local18
    , local19
    , local20
    , local21
    , local22;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeStringElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeStringElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = input.decodeStringElement_3zr2iy$(this.descriptor, 5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = input.decodeStringElement_3zr2iy$(this.descriptor, 6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 7, LabeledPricesSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 7, LabeledPricesSerializer_getInstance(), local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = (bitMask0 & 256) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 8, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 8, internal.StringSerializer, local8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case 10:
          local10 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 10);
          bitMask0 |= 1024;
          if (!readAll)
            break;
        case 11:
          local11 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 11);
          bitMask0 |= 2048;
          if (!readAll)
            break;
        case 12:
          local12 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 12);
          bitMask0 |= 4096;
          if (!readAll)
            break;
        case 13:
          local13 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 13);
          bitMask0 |= 8192;
          if (!readAll)
            break;
        case 14:
          local14 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 14);
          bitMask0 |= 16384;
          if (!readAll)
            break;
        case 15:
          local15 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 15);
          bitMask0 |= 32768;
          if (!readAll)
            break;
        case 16:
          local16 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 16);
          bitMask0 |= 65536;
          if (!readAll)
            break;
        case 17:
          local17 = (bitMask0 & 131072) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 17, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 17, internal.LongSerializer, local17);
          bitMask0 |= 131072;
          if (!readAll)
            break;
        case 18:
          local18 = (bitMask0 & 262144) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 18, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 18, InlineKeyboardMarkup$$serializer_getInstance(), local18);
          bitMask0 |= 262144;
          if (!readAll)
            break;
        case 19:
          local19 = (bitMask0 & 524288) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 19, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 19, internal.StringSerializer, local19);
          bitMask0 |= 524288;
          if (!readAll)
            break;
        case 20:
          local20 = (bitMask0 & 1048576) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 20, internal.LongSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 20, internal.LongSerializer, local20);
          bitMask0 |= 1048576;
          if (!readAll)
            break;
        case 21:
          local21 = (bitMask0 & 2097152) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 21, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 21, internal.IntSerializer, local21);
          bitMask0 |= 2097152;
          if (!readAll)
            break;
        case 22:
          local22 = (bitMask0 & 4194304) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 22, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 22, internal.IntSerializer, local22);
          bitMask0 |= 4194304;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SendInvoice_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, local10, local11, local12, local13, local14, local15, local16, local17, local18, local19, local20, local21, local22, null);
  };
  SendInvoice$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer, internal.StringSerializer, internal.StringSerializer, internal.StringSerializer, internal.StringSerializer, internal.StringSerializer, LabeledPricesSerializer_getInstance(), new NullableSerializer(internal.StringSerializer), internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, new NullableSerializer(internal.LongSerializer), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance()), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.LongSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(internal.IntSerializer)];
  };
  SendInvoice$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SendInvoice$$serializer_instance = null;
  function SendInvoice$$serializer_getInstance() {
    if (SendInvoice$$serializer_instance === null) {
      new SendInvoice$$serializer();
    }
    return SendInvoice$$serializer_instance;
  }
  function SendInvoice_init(seen1, chatId, title, description, payload, providerToken, startParameter, currency, prices, providerData, requireName, requirePhoneNumber, requireEmail, requireShippingAddress, shouldSendPhoneNumberToProvider, shouldSendEmailToProvider, priceDependOnShipAddress, disableNotification, replyToMessageId, replyMarkup, photoUrl, photoSize, photoWidth, photoHeight, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SendInvoice.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('chat_id');
    else
      $this.chatId_ajnbmb$_0 = chatId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('title');
    else
      $this.title = title;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('description');
    else
      $this.description = description;
    if ((seen1 & 8) === 0)
      throw new MissingFieldException('payload');
    else
      $this.payload = payload;
    if ((seen1 & 16) === 0)
      throw new MissingFieldException('provider_token');
    else
      $this.providerToken = providerToken;
    if ((seen1 & 32) === 0)
      throw new MissingFieldException('start_parameter');
    else
      $this.startParameter = startParameter;
    if ((seen1 & 64) === 0)
      throw new MissingFieldException('currency');
    else
      $this.currency_wiy6s5$_0 = currency;
    if ((seen1 & 128) === 0)
      throw new MissingFieldException('prices');
    else
      $this.prices_6vyudg$_0 = prices;
    if ((seen1 & 256) === 0)
      $this.providerData = null;
    else
      $this.providerData = providerData;
    if ((seen1 & 512) === 0)
      $this.requireName = false;
    else
      $this.requireName = requireName;
    if ((seen1 & 1024) === 0)
      $this.requirePhoneNumber = false;
    else
      $this.requirePhoneNumber = requirePhoneNumber;
    if ((seen1 & 2048) === 0)
      $this.requireEmail = false;
    else
      $this.requireEmail = requireEmail;
    if ((seen1 & 4096) === 0)
      $this.requireShippingAddress = false;
    else
      $this.requireShippingAddress = requireShippingAddress;
    if ((seen1 & 8192) === 0)
      $this.shouldSendPhoneNumberToProvider = false;
    else
      $this.shouldSendPhoneNumberToProvider = shouldSendPhoneNumberToProvider;
    if ((seen1 & 16384) === 0)
      $this.shouldSendEmailToProvider = false;
    else
      $this.shouldSendEmailToProvider = shouldSendEmailToProvider;
    if ((seen1 & 32768) === 0)
      $this.priceDependOnShipAddress = false;
    else
      $this.priceDependOnShipAddress = priceDependOnShipAddress;
    if ((seen1 & 65536) === 0)
      $this.disableNotification_a6jp97$_0 = false;
    else
      $this.disableNotification_a6jp97$_0 = disableNotification;
    if ((seen1 & 131072) === 0)
      $this.replyToMessageId_a1c7zd$_0 = null;
    else
      $this.replyToMessageId_a1c7zd$_0 = replyToMessageId;
    if ((seen1 & 262144) === 0)
      $this.replyMarkup_75e6h0$_0 = null;
    else
      $this.replyMarkup_75e6h0$_0 = replyMarkup;
    if ((seen1 & 524288) === 0)
      $this.photoUrl_7ml0nd$_0 = null;
    else
      $this.photoUrl_7ml0nd$_0 = photoUrl;
    if ((seen1 & 1048576) === 0)
      $this.photoSize_nbidkr$_0 = null;
    else
      $this.photoSize_nbidkr$_0 = photoSize;
    if ((seen1 & 2097152) === 0)
      $this.photoWidth_ehhx8y$_0 = null;
    else
      $this.photoWidth_ehhx8y$_0 = photoWidth;
    if ((seen1 & 4194304) === 0)
      $this.photoHeight_dzhff9$_0 = null;
    else
      $this.photoHeight_dzhff9$_0 = photoHeight;
    return $this;
  }
  SendInvoice.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SendInvoice',
    interfaces: [SendMessageRequest, ReplyMarkup, ReplyMessageId, DisableNotification, ChatRequest, Priced, Currencied]
  };
  SendInvoice.prototype.component1 = function () {
    return this.chatId;
  };
  SendInvoice.prototype.component2 = function () {
    return this.title;
  };
  SendInvoice.prototype.component3 = function () {
    return this.description;
  };
  SendInvoice.prototype.component4 = function () {
    return this.payload;
  };
  SendInvoice.prototype.component5 = function () {
    return this.providerToken;
  };
  SendInvoice.prototype.component6 = function () {
    return this.startParameter;
  };
  SendInvoice.prototype.component7 = function () {
    return this.currency;
  };
  SendInvoice.prototype.component8 = function () {
    return this.prices;
  };
  SendInvoice.prototype.component9 = function () {
    return this.providerData;
  };
  SendInvoice.prototype.component10 = function () {
    return this.requireName;
  };
  SendInvoice.prototype.component11 = function () {
    return this.requirePhoneNumber;
  };
  SendInvoice.prototype.component12 = function () {
    return this.requireEmail;
  };
  SendInvoice.prototype.component13 = function () {
    return this.requireShippingAddress;
  };
  SendInvoice.prototype.component14 = function () {
    return this.shouldSendPhoneNumberToProvider;
  };
  SendInvoice.prototype.component15 = function () {
    return this.shouldSendEmailToProvider;
  };
  SendInvoice.prototype.component16 = function () {
    return this.priceDependOnShipAddress;
  };
  SendInvoice.prototype.component17 = function () {
    return this.disableNotification;
  };
  SendInvoice.prototype.component18 = function () {
    return this.replyToMessageId;
  };
  SendInvoice.prototype.component19 = function () {
    return this.replyMarkup;
  };
  SendInvoice.prototype.copy_4ow5dd$ = function (chatId, title, description, payload, providerToken, startParameter, currency, prices, providerData, requireName, requirePhoneNumber, requireEmail, requireShippingAddress, shouldSendPhoneNumberToProvider, shouldSendEmailToProvider, priceDependOnShipAddress, disableNotification, replyToMessageId, replyMarkup) {
    return new SendInvoice(chatId === void 0 ? this.chatId : chatId, title === void 0 ? this.title : title, description === void 0 ? this.description : description, payload === void 0 ? this.payload : payload, providerToken === void 0 ? this.providerToken : providerToken, startParameter === void 0 ? this.startParameter : startParameter, currency === void 0 ? this.currency : currency, prices === void 0 ? this.prices : prices, providerData === void 0 ? this.providerData : providerData, requireName === void 0 ? this.requireName : requireName, requirePhoneNumber === void 0 ? this.requirePhoneNumber : requirePhoneNumber, requireEmail === void 0 ? this.requireEmail : requireEmail, requireShippingAddress === void 0 ? this.requireShippingAddress : requireShippingAddress, shouldSendPhoneNumberToProvider === void 0 ? this.shouldSendPhoneNumberToProvider : shouldSendPhoneNumberToProvider, shouldSendEmailToProvider === void 0 ? this.shouldSendEmailToProvider : shouldSendEmailToProvider, priceDependOnShipAddress === void 0 ? this.priceDependOnShipAddress : priceDependOnShipAddress, disableNotification === void 0 ? this.disableNotification : disableNotification, replyToMessageId === void 0 ? this.replyToMessageId : replyToMessageId, replyMarkup === void 0 ? this.replyMarkup : replyMarkup);
  };
  SendInvoice.prototype.toString = function () {
    return 'SendInvoice(chatId=' + Kotlin.toString(this.chatId) + (', title=' + Kotlin.toString(this.title)) + (', description=' + Kotlin.toString(this.description)) + (', payload=' + Kotlin.toString(this.payload)) + (', providerToken=' + Kotlin.toString(this.providerToken)) + (', startParameter=' + Kotlin.toString(this.startParameter)) + (', currency=' + Kotlin.toString(this.currency)) + (', prices=' + Kotlin.toString(this.prices)) + (', providerData=' + Kotlin.toString(this.providerData)) + (', requireName=' + Kotlin.toString(this.requireName)) + (', requirePhoneNumber=' + Kotlin.toString(this.requirePhoneNumber)) + (', requireEmail=' + Kotlin.toString(this.requireEmail)) + (', requireShippingAddress=' + Kotlin.toString(this.requireShippingAddress)) + (', shouldSendPhoneNumberToProvider=' + Kotlin.toString(this.shouldSendPhoneNumberToProvider)) + (', shouldSendEmailToProvider=' + Kotlin.toString(this.shouldSendEmailToProvider)) + (', priceDependOnShipAddress=' + Kotlin.toString(this.priceDependOnShipAddress)) + (', disableNotification=' + Kotlin.toString(this.disableNotification)) + (', replyToMessageId=' + Kotlin.toString(this.replyToMessageId)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + ')';
  };
  SendInvoice.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    result = result * 31 + Kotlin.hashCode(this.title) | 0;
    result = result * 31 + Kotlin.hashCode(this.description) | 0;
    result = result * 31 + Kotlin.hashCode(this.payload) | 0;
    result = result * 31 + Kotlin.hashCode(this.providerToken) | 0;
    result = result * 31 + Kotlin.hashCode(this.startParameter) | 0;
    result = result * 31 + Kotlin.hashCode(this.currency) | 0;
    result = result * 31 + Kotlin.hashCode(this.prices) | 0;
    result = result * 31 + Kotlin.hashCode(this.providerData) | 0;
    result = result * 31 + Kotlin.hashCode(this.requireName) | 0;
    result = result * 31 + Kotlin.hashCode(this.requirePhoneNumber) | 0;
    result = result * 31 + Kotlin.hashCode(this.requireEmail) | 0;
    result = result * 31 + Kotlin.hashCode(this.requireShippingAddress) | 0;
    result = result * 31 + Kotlin.hashCode(this.shouldSendPhoneNumberToProvider) | 0;
    result = result * 31 + Kotlin.hashCode(this.shouldSendEmailToProvider) | 0;
    result = result * 31 + Kotlin.hashCode(this.priceDependOnShipAddress) | 0;
    result = result * 31 + Kotlin.hashCode(this.disableNotification) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyToMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    return result;
  };
  SendInvoice.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.chatId, other.chatId) && Kotlin.equals(this.title, other.title) && Kotlin.equals(this.description, other.description) && Kotlin.equals(this.payload, other.payload) && Kotlin.equals(this.providerToken, other.providerToken) && Kotlin.equals(this.startParameter, other.startParameter) && Kotlin.equals(this.currency, other.currency) && Kotlin.equals(this.prices, other.prices) && Kotlin.equals(this.providerData, other.providerData) && Kotlin.equals(this.requireName, other.requireName) && Kotlin.equals(this.requirePhoneNumber, other.requirePhoneNumber) && Kotlin.equals(this.requireEmail, other.requireEmail) && Kotlin.equals(this.requireShippingAddress, other.requireShippingAddress) && Kotlin.equals(this.shouldSendPhoneNumberToProvider, other.shouldSendPhoneNumberToProvider) && Kotlin.equals(this.shouldSendEmailToProvider, other.shouldSendEmailToProvider) && Kotlin.equals(this.priceDependOnShipAddress, other.priceDependOnShipAddress) && Kotlin.equals(this.disableNotification, other.disableNotification) && Kotlin.equals(this.replyToMessageId, other.replyToMessageId) && Kotlin.equals(this.replyMarkup, other.replyMarkup)))));
  };
  function AddStickerToSet(userId, stickerSetName, sticker, emojis, maskPosition) {
    if (maskPosition === void 0)
      maskPosition = null;
    var tmp$, tmp$_0;
    var data = new AddStickerToSet_0(userId, stickerSetName, emojis, Kotlin.isType(tmp$ = sticker, FileId) ? tmp$ : null, maskPosition);
    if (Kotlin.isType(sticker, MultipartFile))
      tmp$_0 = new CommonMultipartFileRequest(data, mapOf(to(pngStickerField, sticker)));
    else if (Kotlin.isType(sticker, FileId))
      tmp$_0 = data;
    else
      tmp$_0 = Kotlin.noWhenBranchMatched();
    return tmp$_0;
  }
  function AddStickerToSet_0(userId, name, emojis, sticker, maskPosition) {
    AddStickerToSet$Companion_getInstance();
    if (sticker === void 0)
      sticker = null;
    if (maskPosition === void 0)
      maskPosition = null;
    this.userId_ywgrw7$_0 = userId;
    this.name_kp74ik$_0 = name;
    this.emojis_boqo76$_0 = emojis;
    this.sticker = sticker;
    this.maskPosition_kvnbie$_0 = maskPosition;
    if (this.emojis.length === 0) {
      throw IllegalArgumentException_init('Emojis must not be empty');
    }
  }
  Object.defineProperty(AddStickerToSet_0.prototype, 'userId', {
    get: function () {
      return this.userId_ywgrw7$_0;
    }
  });
  Object.defineProperty(AddStickerToSet_0.prototype, 'name', {
    get: function () {
      return this.name_kp74ik$_0;
    }
  });
  Object.defineProperty(AddStickerToSet_0.prototype, 'emojis', {
    get: function () {
      return this.emojis_boqo76$_0;
    }
  });
  Object.defineProperty(AddStickerToSet_0.prototype, 'maskPosition', {
    get: function () {
      return this.maskPosition_kvnbie$_0;
    }
  });
  Object.defineProperty(AddStickerToSet_0.prototype, 'requestSerializer', {
    get: function () {
      return AddStickerToSet$Companion_getInstance().serializer();
    }
  });
  AddStickerToSet_0.prototype.method = function () {
    return 'addStickerToSet';
  };
  function AddStickerToSet$Companion() {
    AddStickerToSet$Companion_instance = this;
  }
  AddStickerToSet$Companion.prototype.serializer = function () {
    return AddStickerToSet$$serializer_getInstance();
  };
  AddStickerToSet$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var AddStickerToSet$Companion_instance = null;
  function AddStickerToSet$Companion_getInstance() {
    if (AddStickerToSet$Companion_instance === null) {
      new AddStickerToSet$Companion();
    }
    return AddStickerToSet$Companion_instance;
  }
  function AddStickerToSet$$serializer() {
    this.descriptor_f9724o$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.AddStickerToSet', this);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('name', false);
    this.descriptor.addElement_ivxn3r$('emojis', false);
    this.descriptor.addElement_ivxn3r$('png_sticker', true);
    this.descriptor.addElement_ivxn3r$('mask_position', true);
    AddStickerToSet$$serializer_instance = this;
  }
  Object.defineProperty(AddStickerToSet$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_f9724o$_0;
    }
  });
  AddStickerToSet$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.userId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.name);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.emojis);
    if (!equals(obj.sticker, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, InputFileSerializer_getInstance(), obj.sticker);
    if (!equals(obj.maskPosition, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, MaskPosition$$serializer_getInstance(), obj.maskPosition);
    output.endStructure_qatsm0$(this.descriptor);
  };
  AddStickerToSet$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, InputFileSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, InputFileSerializer_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, MaskPosition$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, MaskPosition$$serializer_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return AddStickerToSet_init(bitMask0, local0, local1, local2, local3, local4, null);
  };
  AddStickerToSet$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer, internal.StringSerializer, new NullableSerializer(InputFileSerializer_getInstance()), new NullableSerializer(MaskPosition$$serializer_getInstance())];
  };
  AddStickerToSet$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var AddStickerToSet$$serializer_instance = null;
  function AddStickerToSet$$serializer_getInstance() {
    if (AddStickerToSet$$serializer_instance === null) {
      new AddStickerToSet$$serializer();
    }
    return AddStickerToSet$$serializer_instance;
  }
  function AddStickerToSet_init(seen1, userId, name, emojis, sticker, maskPosition, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(AddStickerToSet_0.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_ywgrw7$_0 = userId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('name');
    else
      $this.name_kp74ik$_0 = name;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('emojis');
    else
      $this.emojis_boqo76$_0 = emojis;
    if ((seen1 & 8) === 0)
      $this.sticker = null;
    else
      $this.sticker = sticker;
    if ((seen1 & 16) === 0)
      $this.maskPosition_kvnbie$_0 = null;
    else
      $this.maskPosition_kvnbie$_0 = maskPosition;
    if ($this.emojis.length === 0) {
      throw IllegalArgumentException_init('Emojis must not be empty');
    }
    return $this;
  }
  AddStickerToSet_0.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AddStickerToSet',
    interfaces: [StickerSetAction]
  };
  AddStickerToSet_0.prototype.component1 = function () {
    return this.userId;
  };
  AddStickerToSet_0.prototype.component2 = function () {
    return this.name;
  };
  AddStickerToSet_0.prototype.component3 = function () {
    return this.emojis;
  };
  AddStickerToSet_0.prototype.component4 = function () {
    return this.sticker;
  };
  AddStickerToSet_0.prototype.component5 = function () {
    return this.maskPosition;
  };
  AddStickerToSet_0.prototype.copy_35l0tm$ = function (userId, name, emojis, sticker, maskPosition) {
    return new AddStickerToSet_0(userId === void 0 ? this.userId : userId, name === void 0 ? this.name : name, emojis === void 0 ? this.emojis : emojis, sticker === void 0 ? this.sticker : sticker, maskPosition === void 0 ? this.maskPosition : maskPosition);
  };
  AddStickerToSet_0.prototype.toString = function () {
    return 'AddStickerToSet(userId=' + Kotlin.toString(this.userId) + (', name=' + Kotlin.toString(this.name)) + (', emojis=' + Kotlin.toString(this.emojis)) + (', sticker=' + Kotlin.toString(this.sticker)) + (', maskPosition=' + Kotlin.toString(this.maskPosition)) + ')';
  };
  AddStickerToSet_0.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.emojis) | 0;
    result = result * 31 + Kotlin.hashCode(this.sticker) | 0;
    result = result * 31 + Kotlin.hashCode(this.maskPosition) | 0;
    return result;
  };
  AddStickerToSet_0.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.emojis, other.emojis) && Kotlin.equals(this.sticker, other.sticker) && Kotlin.equals(this.maskPosition, other.maskPosition)))));
  };
  function CreateNewStickerSet(userId, name, sticker, emojis, containsMasks, maskPosition) {
    if (containsMasks === void 0)
      containsMasks = null;
    if (maskPosition === void 0)
      maskPosition = null;
    var tmp$, tmp$_0;
    var data = new CreateNewStickerSet_0(userId, name, emojis, Kotlin.isType(tmp$ = sticker, FileId) ? tmp$ : null, containsMasks, maskPosition);
    if (Kotlin.isType(sticker, MultipartFile))
      tmp$_0 = new CommonMultipartFileRequest(data, mapOf(to(pngStickerField, sticker)));
    else if (Kotlin.isType(sticker, FileId))
      tmp$_0 = data;
    else
      tmp$_0 = Kotlin.noWhenBranchMatched();
    return tmp$_0;
  }
  function CreateNewStickerSet_0(userId, name, emojis, sticker, containsMasks, maskPosition) {
    CreateNewStickerSet$Companion_getInstance();
    if (sticker === void 0)
      sticker = null;
    if (containsMasks === void 0)
      containsMasks = null;
    if (maskPosition === void 0)
      maskPosition = null;
    this.userId_xwvi07$_0 = userId;
    this.name_g74e6$_0 = name;
    this.emojis_9gyw4g$_0 = emojis;
    this.sticker = sticker;
    this.containsMasks = containsMasks;
    this.maskPosition_mwqa20$_0 = maskPosition;
    if (this.emojis.length === 0) {
      throw IllegalArgumentException_init('Emojis must not be empty');
    }
  }
  Object.defineProperty(CreateNewStickerSet_0.prototype, 'userId', {
    get: function () {
      return this.userId_xwvi07$_0;
    }
  });
  Object.defineProperty(CreateNewStickerSet_0.prototype, 'name', {
    get: function () {
      return this.name_g74e6$_0;
    }
  });
  Object.defineProperty(CreateNewStickerSet_0.prototype, 'emojis', {
    get: function () {
      return this.emojis_9gyw4g$_0;
    }
  });
  Object.defineProperty(CreateNewStickerSet_0.prototype, 'maskPosition', {
    get: function () {
      return this.maskPosition_mwqa20$_0;
    }
  });
  Object.defineProperty(CreateNewStickerSet_0.prototype, 'requestSerializer', {
    get: function () {
      return CreateNewStickerSet$Companion_getInstance().serializer();
    }
  });
  CreateNewStickerSet_0.prototype.method = function () {
    return 'createNewStickerSet';
  };
  function CreateNewStickerSet$Companion() {
    CreateNewStickerSet$Companion_instance = this;
  }
  CreateNewStickerSet$Companion.prototype.serializer = function () {
    return CreateNewStickerSet$$serializer_getInstance();
  };
  CreateNewStickerSet$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CreateNewStickerSet$Companion_instance = null;
  function CreateNewStickerSet$Companion_getInstance() {
    if (CreateNewStickerSet$Companion_instance === null) {
      new CreateNewStickerSet$Companion();
    }
    return CreateNewStickerSet$Companion_instance;
  }
  function CreateNewStickerSet$$serializer() {
    this.descriptor_dppf8a$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.CreateNewStickerSet', this);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    this.descriptor.addElement_ivxn3r$('name', false);
    this.descriptor.addElement_ivxn3r$('emojis', false);
    this.descriptor.addElement_ivxn3r$('png_sticker', true);
    this.descriptor.addElement_ivxn3r$('contains_masks', true);
    this.descriptor.addElement_ivxn3r$('mask_position', true);
    CreateNewStickerSet$$serializer_instance = this;
  }
  Object.defineProperty(CreateNewStickerSet$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_dppf8a$_0;
    }
  });
  CreateNewStickerSet$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.userId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.name);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.emojis);
    if (!equals(obj.sticker, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, InputFileSerializer_getInstance(), obj.sticker);
    if (!equals(obj.containsMasks, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.BooleanSerializer, obj.containsMasks);
    if (!equals(obj.maskPosition, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, MaskPosition$$serializer_getInstance(), obj.maskPosition);
    output.endStructure_qatsm0$(this.descriptor);
  };
  CreateNewStickerSet$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, InputFileSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, InputFileSerializer_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.BooleanSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, MaskPosition$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, MaskPosition$$serializer_getInstance(), local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return CreateNewStickerSet_init(bitMask0, local0, local1, local2, local3, local4, local5, null);
  };
  CreateNewStickerSet$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance(), internal.StringSerializer, internal.StringSerializer, new NullableSerializer(InputFileSerializer_getInstance()), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(MaskPosition$$serializer_getInstance())];
  };
  CreateNewStickerSet$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var CreateNewStickerSet$$serializer_instance = null;
  function CreateNewStickerSet$$serializer_getInstance() {
    if (CreateNewStickerSet$$serializer_instance === null) {
      new CreateNewStickerSet$$serializer();
    }
    return CreateNewStickerSet$$serializer_instance;
  }
  function CreateNewStickerSet_init(seen1, userId, name, emojis, sticker, containsMasks, maskPosition, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(CreateNewStickerSet_0.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('user_id');
    else
      $this.userId_xwvi07$_0 = userId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('name');
    else
      $this.name_g74e6$_0 = name;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('emojis');
    else
      $this.emojis_9gyw4g$_0 = emojis;
    if ((seen1 & 8) === 0)
      $this.sticker = null;
    else
      $this.sticker = sticker;
    if ((seen1 & 16) === 0)
      $this.containsMasks = null;
    else
      $this.containsMasks = containsMasks;
    if ((seen1 & 32) === 0)
      $this.maskPosition_mwqa20$_0 = null;
    else
      $this.maskPosition_mwqa20$_0 = maskPosition;
    if ($this.emojis.length === 0) {
      throw IllegalArgumentException_init('Emojis must not be empty');
    }
    return $this;
  }
  CreateNewStickerSet_0.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CreateNewStickerSet',
    interfaces: [StickerSetAction]
  };
  CreateNewStickerSet_0.prototype.component1 = function () {
    return this.userId;
  };
  CreateNewStickerSet_0.prototype.component2 = function () {
    return this.name;
  };
  CreateNewStickerSet_0.prototype.component3 = function () {
    return this.emojis;
  };
  CreateNewStickerSet_0.prototype.component4 = function () {
    return this.sticker;
  };
  CreateNewStickerSet_0.prototype.component5 = function () {
    return this.containsMasks;
  };
  CreateNewStickerSet_0.prototype.component6 = function () {
    return this.maskPosition;
  };
  CreateNewStickerSet_0.prototype.copy_aospj6$ = function (userId, name, emojis, sticker, containsMasks, maskPosition) {
    return new CreateNewStickerSet_0(userId === void 0 ? this.userId : userId, name === void 0 ? this.name : name, emojis === void 0 ? this.emojis : emojis, sticker === void 0 ? this.sticker : sticker, containsMasks === void 0 ? this.containsMasks : containsMasks, maskPosition === void 0 ? this.maskPosition : maskPosition);
  };
  CreateNewStickerSet_0.prototype.toString = function () {
    return 'CreateNewStickerSet(userId=' + Kotlin.toString(this.userId) + (', name=' + Kotlin.toString(this.name)) + (', emojis=' + Kotlin.toString(this.emojis)) + (', sticker=' + Kotlin.toString(this.sticker)) + (', containsMasks=' + Kotlin.toString(this.containsMasks)) + (', maskPosition=' + Kotlin.toString(this.maskPosition)) + ')';
  };
  CreateNewStickerSet_0.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    result = result * 31 + Kotlin.hashCode(this.emojis) | 0;
    result = result * 31 + Kotlin.hashCode(this.sticker) | 0;
    result = result * 31 + Kotlin.hashCode(this.containsMasks) | 0;
    result = result * 31 + Kotlin.hashCode(this.maskPosition) | 0;
    return result;
  };
  CreateNewStickerSet_0.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.name, other.name) && Kotlin.equals(this.emojis, other.emojis) && Kotlin.equals(this.sticker, other.sticker) && Kotlin.equals(this.containsMasks, other.containsMasks) && Kotlin.equals(this.maskPosition, other.maskPosition)))));
  };
  function DeleteStickerFromSet(sticker) {
    DeleteStickerFromSet$Companion_getInstance();
    this.sticker = sticker;
  }
  DeleteStickerFromSet.prototype.method = function () {
    return 'deleteStickerFromSet';
  };
  Object.defineProperty(DeleteStickerFromSet.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(DeleteStickerFromSet.prototype, 'requestSerializer', {
    get: function () {
      return DeleteStickerFromSet$Companion_getInstance().serializer();
    }
  });
  function DeleteStickerFromSet$Companion() {
    DeleteStickerFromSet$Companion_instance = this;
  }
  DeleteStickerFromSet$Companion.prototype.serializer = function () {
    return DeleteStickerFromSet$$serializer_getInstance();
  };
  DeleteStickerFromSet$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DeleteStickerFromSet$Companion_instance = null;
  function DeleteStickerFromSet$Companion_getInstance() {
    if (DeleteStickerFromSet$Companion_instance === null) {
      new DeleteStickerFromSet$Companion();
    }
    return DeleteStickerFromSet$Companion_instance;
  }
  function DeleteStickerFromSet$$serializer() {
    this.descriptor_39day5$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.DeleteStickerFromSet', this);
    this.descriptor.addElement_ivxn3r$('sticker', false);
    DeleteStickerFromSet$$serializer_instance = this;
  }
  Object.defineProperty(DeleteStickerFromSet$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_39day5$_0;
    }
  });
  DeleteStickerFromSet$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, InputFileSerializer_getInstance(), obj.sticker);
    output.endStructure_qatsm0$(this.descriptor);
  };
  DeleteStickerFromSet$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, InputFileSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, InputFileSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return DeleteStickerFromSet_init(bitMask0, local0, null);
  };
  DeleteStickerFromSet$$serializer.prototype.childSerializers = function () {
    return [InputFileSerializer_getInstance()];
  };
  DeleteStickerFromSet$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var DeleteStickerFromSet$$serializer_instance = null;
  function DeleteStickerFromSet$$serializer_getInstance() {
    if (DeleteStickerFromSet$$serializer_instance === null) {
      new DeleteStickerFromSet$$serializer();
    }
    return DeleteStickerFromSet$$serializer_instance;
  }
  function DeleteStickerFromSet_init(seen1, sticker, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(DeleteStickerFromSet.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('sticker');
    else
      $this.sticker = sticker;
    return $this;
  }
  DeleteStickerFromSet.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DeleteStickerFromSet',
    interfaces: [SimpleRequest]
  };
  DeleteStickerFromSet.prototype.component1 = function () {
    return this.sticker;
  };
  DeleteStickerFromSet.prototype.copy_qk7lt0$ = function (sticker) {
    return new DeleteStickerFromSet(sticker === void 0 ? this.sticker : sticker);
  };
  DeleteStickerFromSet.prototype.toString = function () {
    return 'DeleteStickerFromSet(sticker=' + Kotlin.toString(this.sticker) + ')';
  };
  DeleteStickerFromSet.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.sticker) | 0;
    return result;
  };
  DeleteStickerFromSet.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.sticker, other.sticker))));
  };
  function SetStickerPositionInSet(sticker, position) {
    SetStickerPositionInSet$Companion_getInstance();
    this.sticker = sticker;
    this.position = position;
    if (this.position < 0) {
      throw IllegalArgumentException_init('Position must be positive or 0');
    }
  }
  SetStickerPositionInSet.prototype.method = function () {
    return 'setStickerPositionInSet';
  };
  Object.defineProperty(SetStickerPositionInSet.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(SetStickerPositionInSet.prototype, 'requestSerializer', {
    get: function () {
      return SetStickerPositionInSet$Companion_getInstance().serializer();
    }
  });
  function SetStickerPositionInSet$Companion() {
    SetStickerPositionInSet$Companion_instance = this;
  }
  SetStickerPositionInSet$Companion.prototype.serializer = function () {
    return SetStickerPositionInSet$$serializer_getInstance();
  };
  SetStickerPositionInSet$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SetStickerPositionInSet$Companion_instance = null;
  function SetStickerPositionInSet$Companion_getInstance() {
    if (SetStickerPositionInSet$Companion_instance === null) {
      new SetStickerPositionInSet$Companion();
    }
    return SetStickerPositionInSet$Companion_instance;
  }
  function SetStickerPositionInSet$$serializer() {
    this.descriptor_v0xtme$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.SetStickerPositionInSet', this);
    this.descriptor.addElement_ivxn3r$('sticker', false);
    this.descriptor.addElement_ivxn3r$('position', false);
    SetStickerPositionInSet$$serializer_instance = this;
  }
  Object.defineProperty(SetStickerPositionInSet$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_v0xtme$_0;
    }
  });
  SetStickerPositionInSet$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, InputFileSerializer_getInstance(), obj.sticker);
    output.encodeIntElement_4wpqag$(this.descriptor, 1, obj.position);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SetStickerPositionInSet$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, InputFileSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, InputFileSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeIntElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SetStickerPositionInSet_init(bitMask0, local0, local1, null);
  };
  SetStickerPositionInSet$$serializer.prototype.childSerializers = function () {
    return [InputFileSerializer_getInstance(), internal.IntSerializer];
  };
  SetStickerPositionInSet$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SetStickerPositionInSet$$serializer_instance = null;
  function SetStickerPositionInSet$$serializer_getInstance() {
    if (SetStickerPositionInSet$$serializer_instance === null) {
      new SetStickerPositionInSet$$serializer();
    }
    return SetStickerPositionInSet$$serializer_instance;
  }
  function SetStickerPositionInSet_init(seen1, sticker, position, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(SetStickerPositionInSet.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('sticker');
    else
      $this.sticker = sticker;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('position');
    else
      $this.position = position;
    if ($this.position < 0) {
      throw IllegalArgumentException_init('Position must be positive or 0');
    }
    return $this;
  }
  SetStickerPositionInSet.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SetStickerPositionInSet',
    interfaces: [SimpleRequest]
  };
  SetStickerPositionInSet.prototype.component1 = function () {
    return this.sticker;
  };
  SetStickerPositionInSet.prototype.component2 = function () {
    return this.position;
  };
  SetStickerPositionInSet.prototype.copy_fzfk0m$ = function (sticker, position) {
    return new SetStickerPositionInSet(sticker === void 0 ? this.sticker : sticker, position === void 0 ? this.position : position);
  };
  SetStickerPositionInSet.prototype.toString = function () {
    return 'SetStickerPositionInSet(sticker=' + Kotlin.toString(this.sticker) + (', position=' + Kotlin.toString(this.position)) + ')';
  };
  SetStickerPositionInSet.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.sticker) | 0;
    result = result * 31 + Kotlin.hashCode(this.position) | 0;
    return result;
  };
  SetStickerPositionInSet.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.sticker, other.sticker) && Kotlin.equals(this.position, other.position)))));
  };
  function UploadStickerFile(userId, sticker) {
    UploadStickerFile$Companion_getInstance();
    if (sticker === void 0) {
      throw IllegalStateException_init("Detected autocreating try: this class can't be deserialized");
    }
    this.userId = userId;
    this.sticker = sticker;
    this.mediaMap_dehvok$_0 = mapOf(to(pngStickerField, this.sticker));
    var serializer = UploadStickerFile$Companion_getInstance().serializer();
    this.paramsJson_auiw9e$_0 = withoutNulls_0(Json.Companion.nonstrict.toJson_tf03ej$(serializer, this).jsonObject);
  }
  UploadStickerFile.prototype.method = function () {
    return 'uploadStickerFile';
  };
  Object.defineProperty(UploadStickerFile.prototype, 'mediaMap', {
    get: function () {
      return this.mediaMap_dehvok$_0;
    }
  });
  Object.defineProperty(UploadStickerFile.prototype, 'paramsJson', {
    get: function () {
      return this.paramsJson_auiw9e$_0;
    }
  });
  Object.defineProperty(UploadStickerFile.prototype, 'resultDeserializer', {
    get: function () {
      return File$Companion_getInstance().serializer();
    }
  });
  function UploadStickerFile$Companion() {
    UploadStickerFile$Companion_instance = this;
  }
  UploadStickerFile$Companion.prototype.serializer = function () {
    return UploadStickerFile$$serializer_getInstance();
  };
  UploadStickerFile$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var UploadStickerFile$Companion_instance = null;
  function UploadStickerFile$Companion_getInstance() {
    if (UploadStickerFile$Companion_instance === null) {
      new UploadStickerFile$Companion();
    }
    return UploadStickerFile$Companion_instance;
  }
  function UploadStickerFile$$serializer() {
    this.descriptor_yh4bt7$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.stickers.UploadStickerFile', this);
    this.descriptor.addElement_ivxn3r$('user_id', false);
    UploadStickerFile$$serializer_instance = this;
  }
  Object.defineProperty(UploadStickerFile$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_yh4bt7$_0;
    }
  });
  UploadStickerFile$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), obj.userId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  UploadStickerFile$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, ChatIdentifierSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, ChatIdentifierSerializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return UploadStickerFile_init(bitMask0, local0, null);
  };
  UploadStickerFile$$serializer.prototype.childSerializers = function () {
    return [ChatIdentifierSerializer_getInstance()];
  };
  UploadStickerFile$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var UploadStickerFile$$serializer_instance = null;
  function UploadStickerFile$$serializer_getInstance() {
    if (UploadStickerFile$$serializer_instance === null) {
      new UploadStickerFile$$serializer();
    }
    return UploadStickerFile$$serializer_instance;
  }
  function UploadStickerFile_init(seen1, userId, serializationConstructorMarker) {
    throw IllegalStateException_init("Detected autocreating try: this class can't be deserialized");
  }
  UploadStickerFile.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'UploadStickerFile',
    interfaces: [MultipartRequest]
  };
  UploadStickerFile.prototype.component1 = function () {
    return this.userId;
  };
  UploadStickerFile.prototype.component2 = function () {
    return this.sticker;
  };
  UploadStickerFile.prototype.copy_un5ia7$ = function (userId, sticker) {
    return new UploadStickerFile(userId === void 0 ? this.userId : userId, sticker === void 0 ? this.sticker : sticker);
  };
  UploadStickerFile.prototype.toString = function () {
    return 'UploadStickerFile(userId=' + Kotlin.toString(this.userId) + (', sticker=' + Kotlin.toString(this.sticker)) + ')';
  };
  UploadStickerFile.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.sticker) | 0;
    return result;
  };
  UploadStickerFile.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.sticker, other.sticker)))));
  };
  function StickerSetAction() {
  }
  Object.defineProperty(StickerSetAction.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  StickerSetAction.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'StickerSetAction',
    interfaces: [SimpleRequest]
  };
  function DeleteWebhook() {
    DeleteWebhook$Companion_getInstance();
  }
  DeleteWebhook.prototype.method = function () {
    return 'deleteWebhook';
  };
  Object.defineProperty(DeleteWebhook.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(DeleteWebhook.prototype, 'requestSerializer', {
    get: function () {
      return DeleteWebhook$Companion_getInstance().serializer();
    }
  });
  function DeleteWebhook$Companion() {
    DeleteWebhook$Companion_instance = this;
  }
  DeleteWebhook$Companion.prototype.serializer = function () {
    return DeleteWebhook$$serializer_getInstance();
  };
  DeleteWebhook$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var DeleteWebhook$Companion_instance = null;
  function DeleteWebhook$Companion_getInstance() {
    if (DeleteWebhook$Companion_instance === null) {
      new DeleteWebhook$Companion();
    }
    return DeleteWebhook$Companion_instance;
  }
  function DeleteWebhook$$serializer() {
    this.descriptor_q90lp2$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.webhook.DeleteWebhook', this);
    DeleteWebhook$$serializer_instance = this;
  }
  Object.defineProperty(DeleteWebhook$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_q90lp2$_0;
    }
  });
  DeleteWebhook$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.endStructure_qatsm0$(this.descriptor);
  };
  DeleteWebhook$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return DeleteWebhook_init(bitMask0, null);
  };
  DeleteWebhook$$serializer.prototype.childSerializers = function () {
    return [];
  };
  DeleteWebhook$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var DeleteWebhook$$serializer_instance = null;
  function DeleteWebhook$$serializer_getInstance() {
    if (DeleteWebhook$$serializer_instance === null) {
      new DeleteWebhook$$serializer();
    }
    return DeleteWebhook$$serializer_instance;
  }
  function DeleteWebhook_init(seen1, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(DeleteWebhook.prototype);
    return $this;
  }
  DeleteWebhook.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DeleteWebhook',
    interfaces: [SimpleRequest]
  };
  function GetWebhookInfo() {
    GetWebhookInfo$Companion_getInstance();
  }
  GetWebhookInfo.prototype.method = function () {
    return 'getWebhookInfo';
  };
  Object.defineProperty(GetWebhookInfo.prototype, 'resultDeserializer', {
    get: function () {
      return WebhookInfo$Companion_getInstance().serializer();
    }
  });
  Object.defineProperty(GetWebhookInfo.prototype, 'requestSerializer', {
    get: function () {
      return GetWebhookInfo$Companion_getInstance().serializer();
    }
  });
  function GetWebhookInfo$Companion() {
    GetWebhookInfo$Companion_instance = this;
  }
  GetWebhookInfo$Companion.prototype.serializer = function () {
    return GetWebhookInfo$$serializer_getInstance();
  };
  GetWebhookInfo$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var GetWebhookInfo$Companion_instance = null;
  function GetWebhookInfo$Companion_getInstance() {
    if (GetWebhookInfo$Companion_instance === null) {
      new GetWebhookInfo$Companion();
    }
    return GetWebhookInfo$Companion_instance;
  }
  function GetWebhookInfo$$serializer() {
    this.descriptor_ufrvf$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.webhook.GetWebhookInfo', this);
    GetWebhookInfo$$serializer_instance = this;
  }
  Object.defineProperty(GetWebhookInfo$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_ufrvf$_0;
    }
  });
  GetWebhookInfo$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.endStructure_qatsm0$(this.descriptor);
  };
  GetWebhookInfo$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return GetWebhookInfo_init(bitMask0, null);
  };
  GetWebhookInfo$$serializer.prototype.childSerializers = function () {
    return [];
  };
  GetWebhookInfo$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var GetWebhookInfo$$serializer_instance = null;
  function GetWebhookInfo$$serializer_getInstance() {
    if (GetWebhookInfo$$serializer_instance === null) {
      new GetWebhookInfo$$serializer();
    }
    return GetWebhookInfo$$serializer_instance;
  }
  function GetWebhookInfo_init(seen1, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(GetWebhookInfo.prototype);
    return $this;
  }
  GetWebhookInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'GetWebhookInfo',
    interfaces: [SimpleRequest]
  };
  function SetWebhook(url, certificate, maxAllowedConnections, allowedUpdates) {
    if (maxAllowedConnections === void 0)
      maxAllowedConnections = null;
    if (allowedUpdates === void 0)
      allowedUpdates = null;
    var tmp$, tmp$_0, tmp$_1;
    var data = new SetWebhook_1(url, (tmp$_0 = Kotlin.isType(tmp$ = certificate, FileId) ? tmp$ : null) != null ? tmp$_0.fileId : null, maxAllowedConnections, allowedUpdates);
    if (Kotlin.isType(certificate, FileId))
      tmp$_1 = data;
    else if (Kotlin.isType(certificate, MultipartFile))
      tmp$_1 = new MultipartRequestImpl(data, mapOf(to(certificateField, certificate)));
    else
      tmp$_1 = Kotlin.noWhenBranchMatched();
    return tmp$_1;
  }
  function SetWebhook_0(url, maxAllowedConnections, allowedUpdates) {
    if (maxAllowedConnections === void 0)
      maxAllowedConnections = null;
    if (allowedUpdates === void 0)
      allowedUpdates = null;
    return new SetWebhook_1(url, null, maxAllowedConnections, allowedUpdates);
  }
  function SetWebhook_1(url, certificateFile, maxAllowedConnections, allowedUpdates) {
    SetWebhook$Companion_getInstance();
    if (certificateFile === void 0)
      certificateFile = null;
    if (maxAllowedConnections === void 0)
      maxAllowedConnections = null;
    if (allowedUpdates === void 0)
      allowedUpdates = null;
    this.url = url;
    this.certificateFile = certificateFile;
    this.maxAllowedConnections = maxAllowedConnections;
    this.allowedUpdates = allowedUpdates;
    var tmp$;
    if ((tmp$ = this.maxAllowedConnections) != null) {
      if (!allowedConnectionsLength.contains_mef7kx$(tmp$)) {
        throw IllegalArgumentException_init('Allowed connection for webhook must be in ' + allowedConnectionsLength + ' range (but passed ' + tmp$ + ')');
      }
    }
  }
  SetWebhook_1.prototype.method = function () {
    return 'setWebhook';
  };
  Object.defineProperty(SetWebhook_1.prototype, 'resultDeserializer', {
    get: function () {
      return internal.BooleanSerializer;
    }
  });
  Object.defineProperty(SetWebhook_1.prototype, 'requestSerializer', {
    get: function () {
      return SetWebhook$Companion_getInstance().serializer();
    }
  });
  function SetWebhook$Companion() {
    SetWebhook$Companion_instance = this;
  }
  SetWebhook$Companion.prototype.serializer = function () {
    return SetWebhook$$serializer_getInstance();
  };
  SetWebhook$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var SetWebhook$Companion_instance = null;
  function SetWebhook$Companion_getInstance() {
    if (SetWebhook$Companion_instance === null) {
      new SetWebhook$Companion();
    }
    return SetWebhook$Companion_instance;
  }
  function SetWebhook$$serializer() {
    this.descriptor_kkewe9$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.requests.webhook.SetWebhook', this);
    this.descriptor.addElement_ivxn3r$('url', false);
    this.descriptor.addElement_ivxn3r$('certificate', true);
    this.descriptor.addElement_ivxn3r$('max_connections', true);
    this.descriptor.addElement_ivxn3r$('allowed_updates', true);
    SetWebhook$$serializer_instance = this;
  }
  Object.defineProperty(SetWebhook$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_kkewe9$_0;
    }
  });
  SetWebhook$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.url);
    if (!equals(obj.certificateFile, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 1))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 1, internal.StringSerializer, obj.certificateFile);
    if (!equals(obj.maxAllowedConnections, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.IntSerializer, obj.maxAllowedConnections);
    if (!equals(obj.allowedUpdates, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, new ArrayListSerializer(internal.StringSerializer), obj.allowedUpdates);
    output.endStructure_qatsm0$(this.descriptor);
  };
  SetWebhook$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 1, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 1, internal.StringSerializer, local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.IntSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, new ArrayListSerializer(internal.StringSerializer)) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, new ArrayListSerializer(internal.StringSerializer), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return SetWebhook_init(bitMask0, local0, local1, local2, local3, null);
  };
  SetWebhook$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(new ArrayListSerializer(internal.StringSerializer))];
  };
  SetWebhook$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var SetWebhook$$serializer_instance = null;
  function SetWebhook$$serializer_getInstance() {
    if (SetWebhook$$serializer_instance === null) {
      new SetWebhook$$serializer();
    }
    return SetWebhook$$serializer_instance;
  }
  function SetWebhook_init(seen1, url, certificateFile, maxAllowedConnections, allowedUpdates, serializationConstructorMarker) {
    var tmp$;
    var $this = serializationConstructorMarker || Object.create(SetWebhook_1.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('url');
    else
      $this.url = url;
    if ((seen1 & 2) === 0)
      $this.certificateFile = null;
    else
      $this.certificateFile = certificateFile;
    if ((seen1 & 4) === 0)
      $this.maxAllowedConnections = null;
    else
      $this.maxAllowedConnections = maxAllowedConnections;
    if ((seen1 & 8) === 0)
      $this.allowedUpdates = null;
    else
      $this.allowedUpdates = allowedUpdates;
    if ((tmp$ = $this.maxAllowedConnections) != null) {
      if (!allowedConnectionsLength.contains_mef7kx$(tmp$)) {
        throw IllegalArgumentException_init('Allowed connection for webhook must be in ' + allowedConnectionsLength + ' range (but passed ' + tmp$ + ')');
      }
    }
    return $this;
  }
  SetWebhook_1.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SetWebhook',
    interfaces: [DataRequest]
  };
  SetWebhook_1.prototype.component1 = function () {
    return this.url;
  };
  SetWebhook_1.prototype.component2 = function () {
    return this.certificateFile;
  };
  SetWebhook_1.prototype.component3 = function () {
    return this.maxAllowedConnections;
  };
  SetWebhook_1.prototype.component4 = function () {
    return this.allowedUpdates;
  };
  SetWebhook_1.prototype.copy_950zaw$ = function (url, certificateFile, maxAllowedConnections, allowedUpdates) {
    return new SetWebhook_1(url === void 0 ? this.url : url, certificateFile === void 0 ? this.certificateFile : certificateFile, maxAllowedConnections === void 0 ? this.maxAllowedConnections : maxAllowedConnections, allowedUpdates === void 0 ? this.allowedUpdates : allowedUpdates);
  };
  SetWebhook_1.prototype.toString = function () {
    return 'SetWebhook(url=' + Kotlin.toString(this.url) + (', certificateFile=' + Kotlin.toString(this.certificateFile)) + (', maxAllowedConnections=' + Kotlin.toString(this.maxAllowedConnections)) + (', allowedUpdates=' + Kotlin.toString(this.allowedUpdates)) + ')';
  };
  SetWebhook_1.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.url) | 0;
    result = result * 31 + Kotlin.hashCode(this.certificateFile) | 0;
    result = result * 31 + Kotlin.hashCode(this.maxAllowedConnections) | 0;
    result = result * 31 + Kotlin.hashCode(this.allowedUpdates) | 0;
    return result;
  };
  SetWebhook_1.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.url, other.url) && Kotlin.equals(this.certificateFile, other.certificateFile) && Kotlin.equals(this.maxAllowedConnections, other.maxAllowedConnections) && Kotlin.equals(this.allowedUpdates, other.allowedUpdates)))));
  };
  function CallbackQuery() {
  }
  CallbackQuery.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CallbackQuery',
    interfaces: []
  };
  function DataCallbackQuery() {
  }
  DataCallbackQuery.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DataCallbackQuery',
    interfaces: [CallbackQuery]
  };
  function GameShortNameCallbackQuery() {
  }
  GameShortNameCallbackQuery.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'GameShortNameCallbackQuery',
    interfaces: [CallbackQuery]
  };
  function InlineMessageIdCallbackQuery() {
  }
  InlineMessageIdCallbackQuery.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'InlineMessageIdCallbackQuery',
    interfaces: [CallbackQuery]
  };
  function InlineMessageIdDataCallbackQuery(id, user, chatInstance, inlineMessageId, data) {
    this.id_p26i1n$_0 = id;
    this.user_3x96p7$_0 = user;
    this.chatInstance_pzsyjb$_0 = chatInstance;
    this.inlineMessageId_hx2xd7$_0 = inlineMessageId;
    this.data_3nlhkc$_0 = data;
  }
  Object.defineProperty(InlineMessageIdDataCallbackQuery.prototype, 'id', {
    get: function () {
      return this.id_p26i1n$_0;
    }
  });
  Object.defineProperty(InlineMessageIdDataCallbackQuery.prototype, 'user', {
    get: function () {
      return this.user_3x96p7$_0;
    }
  });
  Object.defineProperty(InlineMessageIdDataCallbackQuery.prototype, 'chatInstance', {
    get: function () {
      return this.chatInstance_pzsyjb$_0;
    }
  });
  Object.defineProperty(InlineMessageIdDataCallbackQuery.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_hx2xd7$_0;
    }
  });
  Object.defineProperty(InlineMessageIdDataCallbackQuery.prototype, 'data', {
    get: function () {
      return this.data_3nlhkc$_0;
    }
  });
  InlineMessageIdDataCallbackQuery.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InlineMessageIdDataCallbackQuery',
    interfaces: [InlineMessageIdCallbackQuery, DataCallbackQuery]
  };
  InlineMessageIdDataCallbackQuery.prototype.component1 = function () {
    return this.id;
  };
  InlineMessageIdDataCallbackQuery.prototype.component2 = function () {
    return this.user;
  };
  InlineMessageIdDataCallbackQuery.prototype.component3 = function () {
    return this.chatInstance;
  };
  InlineMessageIdDataCallbackQuery.prototype.component4 = function () {
    return this.inlineMessageId;
  };
  InlineMessageIdDataCallbackQuery.prototype.component5 = function () {
    return this.data;
  };
  InlineMessageIdDataCallbackQuery.prototype.copy_ar9ntu$ = function (id, user, chatInstance, inlineMessageId, data) {
    return new InlineMessageIdDataCallbackQuery(id === void 0 ? this.id : id, user === void 0 ? this.user : user, chatInstance === void 0 ? this.chatInstance : chatInstance, inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, data === void 0 ? this.data : data);
  };
  InlineMessageIdDataCallbackQuery.prototype.toString = function () {
    return 'InlineMessageIdDataCallbackQuery(id=' + Kotlin.toString(this.id) + (', user=' + Kotlin.toString(this.user)) + (', chatInstance=' + Kotlin.toString(this.chatInstance)) + (', inlineMessageId=' + Kotlin.toString(this.inlineMessageId)) + (', data=' + Kotlin.toString(this.data)) + ')';
  };
  InlineMessageIdDataCallbackQuery.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.chatInstance) | 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.data) | 0;
    return result;
  };
  InlineMessageIdDataCallbackQuery.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.user, other.user) && Kotlin.equals(this.chatInstance, other.chatInstance) && Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.data, other.data)))));
  };
  function InlineMessageIdGameShortNameCallbackQuery(id, user, chatInstance, inlineMessageId, gameShortName) {
    this.id_p443qq$_0 = id;
    this.user_fvmtum$_0 = user;
    this.chatInstance_ul8q5g$_0 = chatInstance;
    this.inlineMessageId_p5dphe$_0 = inlineMessageId;
    this.gameShortName_vjt1na$_0 = gameShortName;
  }
  Object.defineProperty(InlineMessageIdGameShortNameCallbackQuery.prototype, 'id', {
    get: function () {
      return this.id_p443qq$_0;
    }
  });
  Object.defineProperty(InlineMessageIdGameShortNameCallbackQuery.prototype, 'user', {
    get: function () {
      return this.user_fvmtum$_0;
    }
  });
  Object.defineProperty(InlineMessageIdGameShortNameCallbackQuery.prototype, 'chatInstance', {
    get: function () {
      return this.chatInstance_ul8q5g$_0;
    }
  });
  Object.defineProperty(InlineMessageIdGameShortNameCallbackQuery.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_p5dphe$_0;
    }
  });
  Object.defineProperty(InlineMessageIdGameShortNameCallbackQuery.prototype, 'gameShortName', {
    get: function () {
      return this.gameShortName_vjt1na$_0;
    }
  });
  InlineMessageIdGameShortNameCallbackQuery.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InlineMessageIdGameShortNameCallbackQuery',
    interfaces: [InlineMessageIdCallbackQuery, GameShortNameCallbackQuery]
  };
  InlineMessageIdGameShortNameCallbackQuery.prototype.component1 = function () {
    return this.id;
  };
  InlineMessageIdGameShortNameCallbackQuery.prototype.component2 = function () {
    return this.user;
  };
  InlineMessageIdGameShortNameCallbackQuery.prototype.component3 = function () {
    return this.chatInstance;
  };
  InlineMessageIdGameShortNameCallbackQuery.prototype.component4 = function () {
    return this.inlineMessageId;
  };
  InlineMessageIdGameShortNameCallbackQuery.prototype.component5 = function () {
    return this.gameShortName;
  };
  InlineMessageIdGameShortNameCallbackQuery.prototype.copy_ar9ntu$ = function (id, user, chatInstance, inlineMessageId, gameShortName) {
    return new InlineMessageIdGameShortNameCallbackQuery(id === void 0 ? this.id : id, user === void 0 ? this.user : user, chatInstance === void 0 ? this.chatInstance : chatInstance, inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, gameShortName === void 0 ? this.gameShortName : gameShortName);
  };
  InlineMessageIdGameShortNameCallbackQuery.prototype.toString = function () {
    return 'InlineMessageIdGameShortNameCallbackQuery(id=' + Kotlin.toString(this.id) + (', user=' + Kotlin.toString(this.user)) + (', chatInstance=' + Kotlin.toString(this.chatInstance)) + (', inlineMessageId=' + Kotlin.toString(this.inlineMessageId)) + (', gameShortName=' + Kotlin.toString(this.gameShortName)) + ')';
  };
  InlineMessageIdGameShortNameCallbackQuery.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.chatInstance) | 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.gameShortName) | 0;
    return result;
  };
  InlineMessageIdGameShortNameCallbackQuery.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.user, other.user) && Kotlin.equals(this.chatInstance, other.chatInstance) && Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.gameShortName, other.gameShortName)))));
  };
  function MessageCallbackQuery() {
  }
  MessageCallbackQuery.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MessageCallbackQuery',
    interfaces: [CallbackQuery]
  };
  function MessageDataCallbackQuery(id, user, chatInstance, message, data) {
    this.id_ktw7st$_0 = id;
    this.user_chv6ib$_0 = user;
    this.chatInstance_mj4kzv$_0 = chatInstance;
    this.message_6yl82z$_0 = message;
    this.data_crivn6$_0 = data;
  }
  Object.defineProperty(MessageDataCallbackQuery.prototype, 'id', {
    get: function () {
      return this.id_ktw7st$_0;
    }
  });
  Object.defineProperty(MessageDataCallbackQuery.prototype, 'user', {
    get: function () {
      return this.user_chv6ib$_0;
    }
  });
  Object.defineProperty(MessageDataCallbackQuery.prototype, 'chatInstance', {
    get: function () {
      return this.chatInstance_mj4kzv$_0;
    }
  });
  Object.defineProperty(MessageDataCallbackQuery.prototype, 'message', {
    get: function () {
      return this.message_6yl82z$_0;
    }
  });
  Object.defineProperty(MessageDataCallbackQuery.prototype, 'data', {
    get: function () {
      return this.data_crivn6$_0;
    }
  });
  MessageDataCallbackQuery.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MessageDataCallbackQuery',
    interfaces: [MessageCallbackQuery, DataCallbackQuery]
  };
  MessageDataCallbackQuery.prototype.component1 = function () {
    return this.id;
  };
  MessageDataCallbackQuery.prototype.component2 = function () {
    return this.user;
  };
  MessageDataCallbackQuery.prototype.component3 = function () {
    return this.chatInstance;
  };
  MessageDataCallbackQuery.prototype.component4 = function () {
    return this.message;
  };
  MessageDataCallbackQuery.prototype.component5 = function () {
    return this.data;
  };
  MessageDataCallbackQuery.prototype.copy_oarlck$ = function (id, user, chatInstance, message, data) {
    return new MessageDataCallbackQuery(id === void 0 ? this.id : id, user === void 0 ? this.user : user, chatInstance === void 0 ? this.chatInstance : chatInstance, message === void 0 ? this.message : message, data === void 0 ? this.data : data);
  };
  MessageDataCallbackQuery.prototype.toString = function () {
    return 'MessageDataCallbackQuery(id=' + Kotlin.toString(this.id) + (', user=' + Kotlin.toString(this.user)) + (', chatInstance=' + Kotlin.toString(this.chatInstance)) + (', message=' + Kotlin.toString(this.message)) + (', data=' + Kotlin.toString(this.data)) + ')';
  };
  MessageDataCallbackQuery.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.chatInstance) | 0;
    result = result * 31 + Kotlin.hashCode(this.message) | 0;
    result = result * 31 + Kotlin.hashCode(this.data) | 0;
    return result;
  };
  MessageDataCallbackQuery.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.user, other.user) && Kotlin.equals(this.chatInstance, other.chatInstance) && Kotlin.equals(this.message, other.message) && Kotlin.equals(this.data, other.data)))));
  };
  function MessageGameShortNameCallbackQuery(id, user, chatInstance, message, gameShortName) {
    this.id_s4qic4$_0 = id;
    this.user_sj5hvg$_0 = user;
    this.chatInstance_7bemd6$_0 = chatInstance;
    this.message_wpcooq$_0 = message;
    this.gameShortName_v03wo$_0 = gameShortName;
  }
  Object.defineProperty(MessageGameShortNameCallbackQuery.prototype, 'id', {
    get: function () {
      return this.id_s4qic4$_0;
    }
  });
  Object.defineProperty(MessageGameShortNameCallbackQuery.prototype, 'user', {
    get: function () {
      return this.user_sj5hvg$_0;
    }
  });
  Object.defineProperty(MessageGameShortNameCallbackQuery.prototype, 'chatInstance', {
    get: function () {
      return this.chatInstance_7bemd6$_0;
    }
  });
  Object.defineProperty(MessageGameShortNameCallbackQuery.prototype, 'message', {
    get: function () {
      return this.message_wpcooq$_0;
    }
  });
  Object.defineProperty(MessageGameShortNameCallbackQuery.prototype, 'gameShortName', {
    get: function () {
      return this.gameShortName_v03wo$_0;
    }
  });
  MessageGameShortNameCallbackQuery.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MessageGameShortNameCallbackQuery',
    interfaces: [MessageCallbackQuery, GameShortNameCallbackQuery]
  };
  MessageGameShortNameCallbackQuery.prototype.component1 = function () {
    return this.id;
  };
  MessageGameShortNameCallbackQuery.prototype.component2 = function () {
    return this.user;
  };
  MessageGameShortNameCallbackQuery.prototype.component3 = function () {
    return this.chatInstance;
  };
  MessageGameShortNameCallbackQuery.prototype.component4 = function () {
    return this.message;
  };
  MessageGameShortNameCallbackQuery.prototype.component5 = function () {
    return this.gameShortName;
  };
  MessageGameShortNameCallbackQuery.prototype.copy_oarlck$ = function (id, user, chatInstance, message, gameShortName) {
    return new MessageGameShortNameCallbackQuery(id === void 0 ? this.id : id, user === void 0 ? this.user : user, chatInstance === void 0 ? this.chatInstance : chatInstance, message === void 0 ? this.message : message, gameShortName === void 0 ? this.gameShortName : gameShortName);
  };
  MessageGameShortNameCallbackQuery.prototype.toString = function () {
    return 'MessageGameShortNameCallbackQuery(id=' + Kotlin.toString(this.id) + (', user=' + Kotlin.toString(this.user)) + (', chatInstance=' + Kotlin.toString(this.chatInstance)) + (', message=' + Kotlin.toString(this.message)) + (', gameShortName=' + Kotlin.toString(this.gameShortName)) + ')';
  };
  MessageGameShortNameCallbackQuery.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.chatInstance) | 0;
    result = result * 31 + Kotlin.hashCode(this.message) | 0;
    result = result * 31 + Kotlin.hashCode(this.gameShortName) | 0;
    return result;
  };
  MessageGameShortNameCallbackQuery.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.user, other.user) && Kotlin.equals(this.chatInstance, other.chatInstance) && Kotlin.equals(this.message, other.message) && Kotlin.equals(this.gameShortName, other.gameShortName)))));
  };
  function RawCallbackQuery(id, from, message, inlineMessageId, chatInstance, data, gameShortName) {
    RawCallbackQuery$Companion_getInstance();
    if (message === void 0)
      message = null;
    if (inlineMessageId === void 0)
      inlineMessageId = null;
    if (data === void 0)
      data = null;
    if (gameShortName === void 0)
      gameShortName = null;
    this.id = id;
    this.from = from;
    this.message = message;
    this.inlineMessageId = inlineMessageId;
    this.chatInstance = chatInstance;
    this.data = data;
    this.gameShortName = gameShortName;
    this.asCallbackQuery_c8cgqm$_0 = lazy(RawCallbackQuery$asCallbackQuery$lambda(this));
  }
  Object.defineProperty(RawCallbackQuery.prototype, 'asCallbackQuery', {
    get: function () {
      return this.asCallbackQuery_c8cgqm$_0.value;
    }
  });
  function RawCallbackQuery$Companion() {
    RawCallbackQuery$Companion_instance = this;
  }
  RawCallbackQuery$Companion.prototype.serializer = function () {
    return RawCallbackQuery$$serializer_getInstance();
  };
  RawCallbackQuery$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var RawCallbackQuery$Companion_instance = null;
  function RawCallbackQuery$Companion_getInstance() {
    if (RawCallbackQuery$Companion_instance === null) {
      new RawCallbackQuery$Companion();
    }
    return RawCallbackQuery$Companion_instance;
  }
  function RawCallbackQuery$$serializer() {
    this.descriptor_pfkava$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.CallbackQuery.RawCallbackQuery', this);
    this.descriptor.addElement_ivxn3r$('id', false);
    this.descriptor.addElement_ivxn3r$('from', false);
    this.descriptor.addElement_ivxn3r$('message', true);
    this.descriptor.addElement_ivxn3r$('inline_message_id', true);
    this.descriptor.addElement_ivxn3r$('chat_instance', false);
    this.descriptor.addElement_ivxn3r$('data', true);
    this.descriptor.addElement_ivxn3r$('game_short_name', true);
    RawCallbackQuery$$serializer_instance = this;
  }
  Object.defineProperty(RawCallbackQuery$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_pfkava$_0;
    }
  });
  RawCallbackQuery$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.id);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, User$$serializer_getInstance(), obj.from);
    if (!equals(obj.message, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, TelegramBotAPIMessageDeserializeOnlySerializer_getInstance(), obj.message);
    if (!equals(obj.inlineMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.inlineMessageId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 4, obj.chatInstance);
    if (!equals(obj.data, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.StringSerializer, obj.data);
    if (!equals(obj.gameShortName, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, internal.StringSerializer, obj.gameShortName);
    output.endStructure_qatsm0$(this.descriptor);
  };
  RawCallbackQuery$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, User$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, User$$serializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, TelegramBotAPIMessageDeserializeOnlySerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, TelegramBotAPIMessageDeserializeOnlySerializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeStringElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.StringSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, internal.StringSerializer, local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return RawCallbackQuery_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, null);
  };
  RawCallbackQuery$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, User$$serializer_getInstance(), new NullableSerializer(TelegramBotAPIMessageDeserializeOnlySerializer_getInstance()), new NullableSerializer(internal.StringSerializer), internal.StringSerializer, new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer)];
  };
  RawCallbackQuery$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var RawCallbackQuery$$serializer_instance = null;
  function RawCallbackQuery$$serializer_getInstance() {
    if (RawCallbackQuery$$serializer_instance === null) {
      new RawCallbackQuery$$serializer();
    }
    return RawCallbackQuery$$serializer_instance;
  }
  function RawCallbackQuery$asCallbackQuery$lambda(this$RawCallbackQuery) {
    return function () {
      if (this$RawCallbackQuery.message != null && this$RawCallbackQuery.data != null)
        return new MessageDataCallbackQuery(this$RawCallbackQuery.id, this$RawCallbackQuery.from, this$RawCallbackQuery.chatInstance, this$RawCallbackQuery.message, this$RawCallbackQuery.data);
      else if (this$RawCallbackQuery.message != null && this$RawCallbackQuery.gameShortName != null)
        return new MessageGameShortNameCallbackQuery(this$RawCallbackQuery.id, this$RawCallbackQuery.from, this$RawCallbackQuery.chatInstance, this$RawCallbackQuery.message, this$RawCallbackQuery.gameShortName);
      else if (this$RawCallbackQuery.inlineMessageId != null && this$RawCallbackQuery.data != null)
        return new InlineMessageIdDataCallbackQuery(this$RawCallbackQuery.id, this$RawCallbackQuery.from, this$RawCallbackQuery.chatInstance, this$RawCallbackQuery.inlineMessageId, this$RawCallbackQuery.data);
      else if (this$RawCallbackQuery.inlineMessageId != null && this$RawCallbackQuery.gameShortName != null)
        return new InlineMessageIdGameShortNameCallbackQuery(this$RawCallbackQuery.id, this$RawCallbackQuery.from, this$RawCallbackQuery.chatInstance, this$RawCallbackQuery.inlineMessageId, this$RawCallbackQuery.gameShortName);
      else
        throw IllegalStateException_init("Strange answer from server, can't create callback query");
    };
  }
  function RawCallbackQuery_init(seen1, id, from, message, inlineMessageId, chatInstance, data, gameShortName, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(RawCallbackQuery.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('id');
    else
      $this.id = id;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('from');
    else
      $this.from = from;
    if ((seen1 & 4) === 0)
      $this.message = null;
    else
      $this.message = message;
    if ((seen1 & 8) === 0)
      $this.inlineMessageId = null;
    else
      $this.inlineMessageId = inlineMessageId;
    if ((seen1 & 16) === 0)
      throw new MissingFieldException('chat_instance');
    else
      $this.chatInstance = chatInstance;
    if ((seen1 & 32) === 0)
      $this.data = null;
    else
      $this.data = data;
    if ((seen1 & 64) === 0)
      $this.gameShortName = null;
    else
      $this.gameShortName = gameShortName;
    $this.asCallbackQuery_c8cgqm$_0 = lazy(RawCallbackQuery$asCallbackQuery$lambda($this));
    return $this;
  }
  function RawCallbackQuery$asCallbackQuery$lambda(this$RawCallbackQuery_0) {
    return function () {
      if (this$RawCallbackQuery.message != null && this$RawCallbackQuery.data != null)
        return new MessageDataCallbackQuery(this$RawCallbackQuery.id, this$RawCallbackQuery.from, this$RawCallbackQuery.chatInstance, this$RawCallbackQuery.message, this$RawCallbackQuery.data);
      else if (this$RawCallbackQuery.message != null && this$RawCallbackQuery.gameShortName != null)
        return new MessageGameShortNameCallbackQuery(this$RawCallbackQuery.id, this$RawCallbackQuery.from, this$RawCallbackQuery.chatInstance, this$RawCallbackQuery.message, this$RawCallbackQuery.gameShortName);
      else if (this$RawCallbackQuery.inlineMessageId != null && this$RawCallbackQuery.data != null)
        return new InlineMessageIdDataCallbackQuery(this$RawCallbackQuery.id, this$RawCallbackQuery.from, this$RawCallbackQuery.chatInstance, this$RawCallbackQuery.inlineMessageId, this$RawCallbackQuery.data);
      else if (this$RawCallbackQuery.inlineMessageId != null && this$RawCallbackQuery.gameShortName != null)
        return new InlineMessageIdGameShortNameCallbackQuery(this$RawCallbackQuery.id, this$RawCallbackQuery.from, this$RawCallbackQuery.chatInstance, this$RawCallbackQuery.inlineMessageId, this$RawCallbackQuery.gameShortName);
      else
        throw IllegalStateException_init("Strange answer from server, can't create callback query");
    };
  }
  RawCallbackQuery.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RawCallbackQuery',
    interfaces: []
  };
  RawCallbackQuery.prototype.component1 = function () {
    return this.id;
  };
  RawCallbackQuery.prototype.component2 = function () {
    return this.from;
  };
  RawCallbackQuery.prototype.component3 = function () {
    return this.message;
  };
  RawCallbackQuery.prototype.component4 = function () {
    return this.inlineMessageId;
  };
  RawCallbackQuery.prototype.component5 = function () {
    return this.chatInstance;
  };
  RawCallbackQuery.prototype.component6 = function () {
    return this.data;
  };
  RawCallbackQuery.prototype.component7 = function () {
    return this.gameShortName;
  };
  RawCallbackQuery.prototype.copy_ot5vsc$ = function (id, from, message, inlineMessageId, chatInstance, data, gameShortName) {
    return new RawCallbackQuery(id === void 0 ? this.id : id, from === void 0 ? this.from : from, message === void 0 ? this.message : message, inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, chatInstance === void 0 ? this.chatInstance : chatInstance, data === void 0 ? this.data : data, gameShortName === void 0 ? this.gameShortName : gameShortName);
  };
  RawCallbackQuery.prototype.toString = function () {
    return 'RawCallbackQuery(id=' + Kotlin.toString(this.id) + (', from=' + Kotlin.toString(this.from)) + (', message=' + Kotlin.toString(this.message)) + (', inlineMessageId=' + Kotlin.toString(this.inlineMessageId)) + (', chatInstance=' + Kotlin.toString(this.chatInstance)) + (', data=' + Kotlin.toString(this.data)) + (', gameShortName=' + Kotlin.toString(this.gameShortName)) + ')';
  };
  RawCallbackQuery.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.from) | 0;
    result = result * 31 + Kotlin.hashCode(this.message) | 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.chatInstance) | 0;
    result = result * 31 + Kotlin.hashCode(this.data) | 0;
    result = result * 31 + Kotlin.hashCode(this.gameShortName) | 0;
    return result;
  };
  RawCallbackQuery.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.from, other.from) && Kotlin.equals(this.message, other.message) && Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.chatInstance, other.chatInstance) && Kotlin.equals(this.data, other.data) && Kotlin.equals(this.gameShortName, other.gameShortName)))));
  };
  function ChatIdentifier() {
    ChatIdentifier$Companion_getInstance();
  }
  function ChatIdentifier$Companion() {
    ChatIdentifier$Companion_instance = this;
  }
  ChatIdentifier$Companion.prototype.serializer = function () {
    return ChatIdentifierSerializer_getInstance();
  };
  ChatIdentifier$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ChatIdentifier$Companion_instance = null;
  function ChatIdentifier$Companion_getInstance() {
    if (ChatIdentifier$Companion_instance === null) {
      new ChatIdentifier$Companion();
    }
    return ChatIdentifier$Companion_instance;
  }
  ChatIdentifier.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChatIdentifier',
    interfaces: []
  };
  function ChatId(chatId) {
    ChatId$Companion_getInstance();
    ChatIdentifier.call(this);
    this.chatId = chatId;
  }
  function ChatId$Companion() {
    ChatId$Companion_instance = this;
  }
  ChatId$Companion.prototype.serializer = function () {
    return ChatIdentifierSerializer_getInstance();
  };
  ChatId$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ChatId$Companion_instance = null;
  function ChatId$Companion_getInstance() {
    if (ChatId$Companion_instance === null) {
      new ChatId$Companion();
    }
    return ChatId$Companion_instance;
  }
  ChatId.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChatId',
    interfaces: [ChatIdentifier]
  };
  ChatId.prototype.component1 = function () {
    return this.chatId;
  };
  ChatId.prototype.copy_s8cxhz$ = function (chatId) {
    return new ChatId(chatId === void 0 ? this.chatId : chatId);
  };
  ChatId.prototype.toString = function () {
    return 'ChatId(chatId=' + Kotlin.toString(this.chatId) + ')';
  };
  ChatId.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.chatId) | 0;
    return result;
  };
  ChatId.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.chatId, other.chatId))));
  };
  function get_link($receiver) {
    return 'tg://user?id=' + $receiver.chatId.toString();
  }
  function toChatId($receiver) {
    return new ChatId($receiver);
  }
  function toChatId_0($receiver) {
    return toChatId(Kotlin.Long.fromInt($receiver));
  }
  function toChatId_1($receiver) {
    return toChatId(Kotlin.Long.fromInt($receiver));
  }
  function Username(username) {
    Username$Companion_getInstance();
    ChatIdentifier.call(this);
    this.username = username;
    if (!startsWith(this.username, '@')) {
      throw IllegalArgumentException_init('Username must starts with `@`');
    }
  }
  function Username$Companion() {
    Username$Companion_instance = this;
  }
  Username$Companion.prototype.serializer = function () {
    return ChatIdentifierSerializer_getInstance();
  };
  Username$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Username$Companion_instance = null;
  function Username$Companion_getInstance() {
    if (Username$Companion_instance === null) {
      new Username$Companion();
    }
    return Username$Companion_instance;
  }
  Username.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Username',
    interfaces: [ChatIdentifier]
  };
  Username.prototype.component1 = function () {
    return this.username;
  };
  Username.prototype.copy_61zpoe$ = function (username) {
    return new Username(username === void 0 ? this.username : username);
  };
  Username.prototype.toString = function () {
    return 'Username(username=' + Kotlin.toString(this.username) + ')';
  };
  Username.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.username) | 0;
    return result;
  };
  Username.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.username, other.username))));
  };
  function toUsername($receiver) {
    return new Username($receiver);
  }
  function ChatIdentifierSerializer() {
    this.descriptor_qxea8x$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.ChatIdentifier', null);
    ChatIdentifierSerializer_instance = this;
  }
  ChatIdentifierSerializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var tmp$, tmp$_0, tmp$_1;
    var id = decoder.decodeString();
    tmp$_1 = (tmp$ = toLongOrNull(id)) != null ? new ChatId(tmp$) : null;
    if (tmp$_1 == null) {
      if (!startsWith(id, '@')) {
        tmp$_0 = new Username('@' + id);
      }
       else {
        tmp$_0 = new Username(id);
      }
      tmp$_1 = tmp$_0;
    }
    return tmp$_1;
  };
  ChatIdentifierSerializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    if (Kotlin.isType(obj, ChatId))
      encoder.encodeLong_s8cxhz$(obj.chatId);
    else if (Kotlin.isType(obj, Username))
      encoder.encodeString_61zpoe$(obj.username);
  };
  Object.defineProperty(ChatIdentifierSerializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_qxea8x$_0;
    }
  });
  ChatIdentifierSerializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ChatIdentifierSerializer',
    interfaces: [KSerializer]
  };
  var ChatIdentifierSerializer_instance = null;
  function ChatIdentifierSerializer_getInstance() {
    if (ChatIdentifierSerializer_instance === null) {
      new ChatIdentifierSerializer();
    }
    return ChatIdentifierSerializer_instance;
  }
  function AdministratorChatMemberImpl(user, canBeEdited, canChangeInfo, canPostMessages, canEditMessages, canRemoveMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, customTitle) {
    this.user_j3h4st$_0 = user;
    this.canBeEdited_uo01ie$_0 = canBeEdited;
    this.canChangeInfo_lb8hgo$_0 = canChangeInfo;
    this.canPostMessages_yyqf6u$_0 = canPostMessages;
    this.canEditMessages_7zjw4w$_0 = canEditMessages;
    this.canRemoveMessages_33lo3a$_0 = canRemoveMessages;
    this.canInviteUsers_xfrx2n$_0 = canInviteUsers;
    this.canRestrictMembers_2xooy7$_0 = canRestrictMembers;
    this.canPinMessages_5cisr7$_0 = canPinMessages;
    this.canPromoteMembers_633qx9$_0 = canPromoteMembers;
    this.customTitle_afo87j$_0 = customTitle;
  }
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'user', {
    get: function () {
      return this.user_j3h4st$_0;
    }
  });
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'canBeEdited', {
    get: function () {
      return this.canBeEdited_uo01ie$_0;
    }
  });
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'canChangeInfo', {
    get: function () {
      return this.canChangeInfo_lb8hgo$_0;
    }
  });
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'canPostMessages', {
    get: function () {
      return this.canPostMessages_yyqf6u$_0;
    }
  });
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'canEditMessages', {
    get: function () {
      return this.canEditMessages_7zjw4w$_0;
    }
  });
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'canRemoveMessages', {
    get: function () {
      return this.canRemoveMessages_33lo3a$_0;
    }
  });
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'canInviteUsers', {
    get: function () {
      return this.canInviteUsers_xfrx2n$_0;
    }
  });
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'canRestrictMembers', {
    get: function () {
      return this.canRestrictMembers_2xooy7$_0;
    }
  });
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'canPinMessages', {
    get: function () {
      return this.canPinMessages_5cisr7$_0;
    }
  });
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'canPromoteMembers', {
    get: function () {
      return this.canPromoteMembers_633qx9$_0;
    }
  });
  Object.defineProperty(AdministratorChatMemberImpl.prototype, 'customTitle', {
    get: function () {
      return this.customTitle_afo87j$_0;
    }
  });
  AdministratorChatMemberImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AdministratorChatMemberImpl',
    interfaces: [AdministratorChatMember]
  };
  AdministratorChatMemberImpl.prototype.component1 = function () {
    return this.user;
  };
  AdministratorChatMemberImpl.prototype.component2 = function () {
    return this.canBeEdited;
  };
  AdministratorChatMemberImpl.prototype.component3 = function () {
    return this.canChangeInfo;
  };
  AdministratorChatMemberImpl.prototype.component4 = function () {
    return this.canPostMessages;
  };
  AdministratorChatMemberImpl.prototype.component5 = function () {
    return this.canEditMessages;
  };
  AdministratorChatMemberImpl.prototype.component6 = function () {
    return this.canRemoveMessages;
  };
  AdministratorChatMemberImpl.prototype.component7 = function () {
    return this.canInviteUsers;
  };
  AdministratorChatMemberImpl.prototype.component8 = function () {
    return this.canRestrictMembers;
  };
  AdministratorChatMemberImpl.prototype.component9 = function () {
    return this.canPinMessages;
  };
  AdministratorChatMemberImpl.prototype.component10 = function () {
    return this.canPromoteMembers;
  };
  AdministratorChatMemberImpl.prototype.component11 = function () {
    return this.customTitle;
  };
  AdministratorChatMemberImpl.prototype.copy_2kn0tc$ = function (user, canBeEdited, canChangeInfo, canPostMessages, canEditMessages, canRemoveMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, customTitle) {
    return new AdministratorChatMemberImpl(user === void 0 ? this.user : user, canBeEdited === void 0 ? this.canBeEdited : canBeEdited, canChangeInfo === void 0 ? this.canChangeInfo : canChangeInfo, canPostMessages === void 0 ? this.canPostMessages : canPostMessages, canEditMessages === void 0 ? this.canEditMessages : canEditMessages, canRemoveMessages === void 0 ? this.canRemoveMessages : canRemoveMessages, canInviteUsers === void 0 ? this.canInviteUsers : canInviteUsers, canRestrictMembers === void 0 ? this.canRestrictMembers : canRestrictMembers, canPinMessages === void 0 ? this.canPinMessages : canPinMessages, canPromoteMembers === void 0 ? this.canPromoteMembers : canPromoteMembers, customTitle === void 0 ? this.customTitle : customTitle);
  };
  AdministratorChatMemberImpl.prototype.toString = function () {
    return 'AdministratorChatMemberImpl(user=' + Kotlin.toString(this.user) + (', canBeEdited=' + Kotlin.toString(this.canBeEdited)) + (', canChangeInfo=' + Kotlin.toString(this.canChangeInfo)) + (', canPostMessages=' + Kotlin.toString(this.canPostMessages)) + (', canEditMessages=' + Kotlin.toString(this.canEditMessages)) + (', canRemoveMessages=' + Kotlin.toString(this.canRemoveMessages)) + (', canInviteUsers=' + Kotlin.toString(this.canInviteUsers)) + (', canRestrictMembers=' + Kotlin.toString(this.canRestrictMembers)) + (', canPinMessages=' + Kotlin.toString(this.canPinMessages)) + (', canPromoteMembers=' + Kotlin.toString(this.canPromoteMembers)) + (', customTitle=' + Kotlin.toString(this.customTitle)) + ')';
  };
  AdministratorChatMemberImpl.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.canBeEdited) | 0;
    result = result * 31 + Kotlin.hashCode(this.canChangeInfo) | 0;
    result = result * 31 + Kotlin.hashCode(this.canPostMessages) | 0;
    result = result * 31 + Kotlin.hashCode(this.canEditMessages) | 0;
    result = result * 31 + Kotlin.hashCode(this.canRemoveMessages) | 0;
    result = result * 31 + Kotlin.hashCode(this.canInviteUsers) | 0;
    result = result * 31 + Kotlin.hashCode(this.canRestrictMembers) | 0;
    result = result * 31 + Kotlin.hashCode(this.canPinMessages) | 0;
    result = result * 31 + Kotlin.hashCode(this.canPromoteMembers) | 0;
    result = result * 31 + Kotlin.hashCode(this.customTitle) | 0;
    return result;
  };
  AdministratorChatMemberImpl.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.user, other.user) && Kotlin.equals(this.canBeEdited, other.canBeEdited) && Kotlin.equals(this.canChangeInfo, other.canChangeInfo) && Kotlin.equals(this.canPostMessages, other.canPostMessages) && Kotlin.equals(this.canEditMessages, other.canEditMessages) && Kotlin.equals(this.canRemoveMessages, other.canRemoveMessages) && Kotlin.equals(this.canInviteUsers, other.canInviteUsers) && Kotlin.equals(this.canRestrictMembers, other.canRestrictMembers) && Kotlin.equals(this.canPinMessages, other.canPinMessages) && Kotlin.equals(this.canPromoteMembers, other.canPromoteMembers) && Kotlin.equals(this.customTitle, other.customTitle)))));
  };
  function CreatorChatMember(user, customTitle) {
    this.user_vk4rou$_0 = user;
    this.customTitle_cbfqz4$_0 = customTitle;
    this.canBeEdited_ss8iqt$_0 = true;
    this.canChangeInfo_gk0zkn$_0 = true;
    this.canPostMessages_cc5yaj$_0 = true;
    this.canEditMessages_fqnscv$_0 = true;
    this.canRemoveMessages_19qgc7$_0 = true;
    this.canInviteUsers_3zkvg2$_0 = true;
    this.canRestrictMembers_bdjopc$_0 = true;
    this.canPinMessages_s98gp8$_0 = true;
    this.canPromoteMembers_498j66$_0 = true;
  }
  Object.defineProperty(CreatorChatMember.prototype, 'user', {
    get: function () {
      return this.user_vk4rou$_0;
    }
  });
  Object.defineProperty(CreatorChatMember.prototype, 'customTitle', {
    get: function () {
      return this.customTitle_cbfqz4$_0;
    }
  });
  Object.defineProperty(CreatorChatMember.prototype, 'canBeEdited', {
    get: function () {
      return this.canBeEdited_ss8iqt$_0;
    }
  });
  Object.defineProperty(CreatorChatMember.prototype, 'canChangeInfo', {
    get: function () {
      return this.canChangeInfo_gk0zkn$_0;
    }
  });
  Object.defineProperty(CreatorChatMember.prototype, 'canPostMessages', {
    get: function () {
      return this.canPostMessages_cc5yaj$_0;
    }
  });
  Object.defineProperty(CreatorChatMember.prototype, 'canEditMessages', {
    get: function () {
      return this.canEditMessages_fqnscv$_0;
    }
  });
  Object.defineProperty(CreatorChatMember.prototype, 'canRemoveMessages', {
    get: function () {
      return this.canRemoveMessages_19qgc7$_0;
    }
  });
  Object.defineProperty(CreatorChatMember.prototype, 'canInviteUsers', {
    get: function () {
      return this.canInviteUsers_3zkvg2$_0;
    }
  });
  Object.defineProperty(CreatorChatMember.prototype, 'canRestrictMembers', {
    get: function () {
      return this.canRestrictMembers_bdjopc$_0;
    }
  });
  Object.defineProperty(CreatorChatMember.prototype, 'canPinMessages', {
    get: function () {
      return this.canPinMessages_s98gp8$_0;
    }
  });
  Object.defineProperty(CreatorChatMember.prototype, 'canPromoteMembers', {
    get: function () {
      return this.canPromoteMembers_498j66$_0;
    }
  });
  CreatorChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CreatorChatMember',
    interfaces: [AdministratorChatMember]
  };
  CreatorChatMember.prototype.component1 = function () {
    return this.user;
  };
  CreatorChatMember.prototype.component2 = function () {
    return this.customTitle;
  };
  CreatorChatMember.prototype.copy_3mun4j$ = function (user, customTitle) {
    return new CreatorChatMember(user === void 0 ? this.user : user, customTitle === void 0 ? this.customTitle : customTitle);
  };
  CreatorChatMember.prototype.toString = function () {
    return 'CreatorChatMember(user=' + Kotlin.toString(this.user) + (', customTitle=' + Kotlin.toString(this.customTitle)) + ')';
  };
  CreatorChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.customTitle) | 0;
    return result;
  };
  CreatorChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.user, other.user) && Kotlin.equals(this.customTitle, other.customTitle)))));
  };
  function KickedChatMember(user, untilDate) {
    this.user_m5ulc5$_0 = user;
    this.untilDate_4pok8$_0 = untilDate;
  }
  Object.defineProperty(KickedChatMember.prototype, 'user', {
    get: function () {
      return this.user_m5ulc5$_0;
    }
  });
  Object.defineProperty(KickedChatMember.prototype, 'untilDate', {
    get: function () {
      return this.untilDate_4pok8$_0;
    }
  });
  KickedChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KickedChatMember',
    interfaces: [BannedChatMember]
  };
  KickedChatMember.prototype.component1 = function () {
    return this.user;
  };
  KickedChatMember.prototype.component2 = function () {
    return this.untilDate;
  };
  KickedChatMember.prototype.copy_icqib$ = function (user, untilDate) {
    return new KickedChatMember(user === void 0 ? this.user : user, untilDate === void 0 ? this.untilDate : untilDate);
  };
  KickedChatMember.prototype.toString = function () {
    return 'KickedChatMember(user=' + Kotlin.toString(this.user) + (', untilDate=' + Kotlin.toString(this.untilDate)) + ')';
  };
  KickedChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.untilDate) | 0;
    return result;
  };
  KickedChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.user, other.user) && Kotlin.equals(this.untilDate, other.untilDate)))));
  };
  function LeftChatMember(user) {
    this.user_uukvhj$_0 = user;
  }
  Object.defineProperty(LeftChatMember.prototype, 'user', {
    get: function () {
      return this.user_uukvhj$_0;
    }
  });
  LeftChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LeftChatMember',
    interfaces: [ChatMember]
  };
  LeftChatMember.prototype.component1 = function () {
    return this.user;
  };
  LeftChatMember.prototype.copy_ylykyi$ = function (user) {
    return new LeftChatMember(user === void 0 ? this.user : user);
  };
  LeftChatMember.prototype.toString = function () {
    return 'LeftChatMember(user=' + Kotlin.toString(this.user) + ')';
  };
  LeftChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    return result;
  };
  LeftChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.user, other.user))));
  };
  function MemberChatMember(user) {
    this.user_s2ddiy$_0 = user;
  }
  Object.defineProperty(MemberChatMember.prototype, 'user', {
    get: function () {
      return this.user_s2ddiy$_0;
    }
  });
  MemberChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MemberChatMember',
    interfaces: [ChatMember]
  };
  MemberChatMember.prototype.component1 = function () {
    return this.user;
  };
  MemberChatMember.prototype.copy_ylykyi$ = function (user) {
    return new MemberChatMember(user === void 0 ? this.user : user);
  };
  MemberChatMember.prototype.toString = function () {
    return 'MemberChatMember(user=' + Kotlin.toString(this.user) + ')';
  };
  MemberChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    return result;
  };
  MemberChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.user, other.user))));
  };
  function RawChatMember(user, status, until_date, canBeEdited, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, isMember, canSendMessages, canSendMediaMessages, canSendPolls, canSendOtherMessages, canAddWebPagePreviews, customTitle) {
    RawChatMember$Companion_getInstance();
    if (until_date === void 0)
      until_date = null;
    if (canBeEdited === void 0)
      canBeEdited = false;
    if (canChangeInfo === void 0)
      canChangeInfo = false;
    if (canPostMessages === void 0)
      canPostMessages = false;
    if (canEditMessages === void 0)
      canEditMessages = false;
    if (canDeleteMessages === void 0)
      canDeleteMessages = false;
    if (canInviteUsers === void 0)
      canInviteUsers = false;
    if (canRestrictMembers === void 0)
      canRestrictMembers = false;
    if (canPinMessages === void 0)
      canPinMessages = false;
    if (canPromoteMembers === void 0)
      canPromoteMembers = false;
    if (isMember === void 0)
      isMember = false;
    if (canSendMessages === void 0)
      canSendMessages = false;
    if (canSendMediaMessages === void 0)
      canSendMediaMessages = false;
    if (canSendPolls === void 0)
      canSendPolls = false;
    if (canSendOtherMessages === void 0)
      canSendOtherMessages = false;
    if (canAddWebPagePreviews === void 0)
      canAddWebPagePreviews = false;
    if (customTitle === void 0)
      customTitle = null;
    this.user = user;
    this.status_0 = status;
    this.until_date_0 = until_date;
    this.canBeEdited_0 = canBeEdited;
    this.canChangeInfo_0 = canChangeInfo;
    this.canPostMessages_0 = canPostMessages;
    this.canEditMessages_0 = canEditMessages;
    this.canDeleteMessages_0 = canDeleteMessages;
    this.canInviteUsers_0 = canInviteUsers;
    this.canRestrictMembers_0 = canRestrictMembers;
    this.canPinMessages_0 = canPinMessages;
    this.canPromoteMembers_0 = canPromoteMembers;
    this.isMember_0 = isMember;
    this.canSendMessages_0 = canSendMessages;
    this.canSendMediaMessages_0 = canSendMediaMessages;
    this.canSendPolls_0 = canSendPolls;
    this.canSendOtherMessages_0 = canSendOtherMessages;
    this.canAddWebPagePreviews_0 = canAddWebPagePreviews;
    this.customTitle_0 = customTitle;
    this.asChatMember_c98pt7$_0 = lazy(RawChatMember$asChatMember$lambda(this));
  }
  Object.defineProperty(RawChatMember.prototype, 'asChatMember', {
    get: function () {
      return this.asChatMember_c98pt7$_0.value;
    }
  });
  function RawChatMember$Companion() {
    RawChatMember$Companion_instance = this;
  }
  RawChatMember$Companion.prototype.serializer = function () {
    return RawChatMember$$serializer_getInstance();
  };
  RawChatMember$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var RawChatMember$Companion_instance = null;
  function RawChatMember$Companion_getInstance() {
    if (RawChatMember$Companion_instance === null) {
      new RawChatMember$Companion();
    }
    return RawChatMember$Companion_instance;
  }
  function RawChatMember$$serializer() {
    this.descriptor_3rrci$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.ChatMember.RawChatMember', this);
    this.descriptor.addElement_ivxn3r$('user', false);
    this.descriptor.addElement_ivxn3r$('status', false);
    this.descriptor.addElement_ivxn3r$('until_date', true);
    this.descriptor.addElement_ivxn3r$('can_be_edited', true);
    this.descriptor.addElement_ivxn3r$('can_change_info', true);
    this.descriptor.addElement_ivxn3r$('can_post_messages', true);
    this.descriptor.addElement_ivxn3r$('can_edit_messages', true);
    this.descriptor.addElement_ivxn3r$('can_delete_messages', true);
    this.descriptor.addElement_ivxn3r$('can_invite_users', true);
    this.descriptor.addElement_ivxn3r$('can_restrict_members', true);
    this.descriptor.addElement_ivxn3r$('can_pin_messages', true);
    this.descriptor.addElement_ivxn3r$('can_promote_members', true);
    this.descriptor.addElement_ivxn3r$('is_member', true);
    this.descriptor.addElement_ivxn3r$('can_send_messages', true);
    this.descriptor.addElement_ivxn3r$('can_send_media_messages', true);
    this.descriptor.addElement_ivxn3r$('can_send_polls', true);
    this.descriptor.addElement_ivxn3r$('can_send_other_messages', true);
    this.descriptor.addElement_ivxn3r$('can_add_web_page_previews', true);
    this.descriptor.addElement_ivxn3r$('custom_title', true);
    RawChatMember$$serializer_instance = this;
  }
  Object.defineProperty(RawChatMember$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_3rrci$_0;
    }
  });
  RawChatMember$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeSerializableElement_blecud$(this.descriptor, 0, User$$serializer_getInstance(), obj.user);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.status_0);
    if (!equals(obj.until_date_0, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, TelegramDateSerializer_getInstance(), obj.until_date_0);
    if (!equals(obj.canBeEdited_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 3, obj.canBeEdited_0);
    if (!equals(obj.canChangeInfo_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 4, obj.canChangeInfo_0);
    if (!equals(obj.canPostMessages_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 5, obj.canPostMessages_0);
    if (!equals(obj.canEditMessages_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 6, obj.canEditMessages_0);
    if (!equals(obj.canDeleteMessages_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 7, obj.canDeleteMessages_0);
    if (!equals(obj.canInviteUsers_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 8, obj.canInviteUsers_0);
    if (!equals(obj.canRestrictMembers_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 9))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 9, obj.canRestrictMembers_0);
    if (!equals(obj.canPinMessages_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 10))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 10, obj.canPinMessages_0);
    if (!equals(obj.canPromoteMembers_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 11))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 11, obj.canPromoteMembers_0);
    if (!equals(obj.isMember_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 12))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 12, obj.isMember_0);
    if (!equals(obj.canSendMessages_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 13))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 13, obj.canSendMessages_0);
    if (!equals(obj.canSendMediaMessages_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 14))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 14, obj.canSendMediaMessages_0);
    if (!equals(obj.canSendPolls_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 15))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 15, obj.canSendPolls_0);
    if (!equals(obj.canSendOtherMessages_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 16))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 16, obj.canSendOtherMessages_0);
    if (!equals(obj.canAddWebPagePreviews_0, false) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 17))
      output.encodeBooleanElement_w1b0nl$(this.descriptor, 17, obj.canAddWebPagePreviews_0);
    if (!equals(obj.customTitle_0, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 18))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 18, internal.StringSerializer, obj.customTitle_0);
    output.endStructure_qatsm0$(this.descriptor);
  };
  RawChatMember$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9
    , local10
    , local11
    , local12
    , local13
    , local14
    , local15
    , local16
    , local17
    , local18;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = (bitMask0 & 1) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 0, User$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 0, User$$serializer_getInstance(), local0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, TelegramDateSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, TelegramDateSerializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case 10:
          local10 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 10);
          bitMask0 |= 1024;
          if (!readAll)
            break;
        case 11:
          local11 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 11);
          bitMask0 |= 2048;
          if (!readAll)
            break;
        case 12:
          local12 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 12);
          bitMask0 |= 4096;
          if (!readAll)
            break;
        case 13:
          local13 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 13);
          bitMask0 |= 8192;
          if (!readAll)
            break;
        case 14:
          local14 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 14);
          bitMask0 |= 16384;
          if (!readAll)
            break;
        case 15:
          local15 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 15);
          bitMask0 |= 32768;
          if (!readAll)
            break;
        case 16:
          local16 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 16);
          bitMask0 |= 65536;
          if (!readAll)
            break;
        case 17:
          local17 = input.decodeBooleanElement_3zr2iy$(this.descriptor, 17);
          bitMask0 |= 131072;
          if (!readAll)
            break;
        case 18:
          local18 = (bitMask0 & 262144) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 18, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 18, internal.StringSerializer, local18);
          bitMask0 |= 262144;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return RawChatMember_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, local10, local11, local12, local13, local14, local15, local16, local17, local18, null);
  };
  RawChatMember$$serializer.prototype.childSerializers = function () {
    return [User$$serializer_getInstance(), internal.StringSerializer, new NullableSerializer(TelegramDateSerializer_getInstance()), internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, internal.BooleanSerializer, new NullableSerializer(internal.StringSerializer)];
  };
  RawChatMember$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var RawChatMember$$serializer_instance = null;
  function RawChatMember$$serializer_getInstance() {
    if (RawChatMember$$serializer_instance === null) {
      new RawChatMember$$serializer();
    }
    return RawChatMember$$serializer_instance;
  }
  function RawChatMember$asChatMember$lambda(this$RawChatMember) {
    return function () {
      switch (this$RawChatMember.status_0) {
        case 'creator':
          return new CreatorChatMember(this$RawChatMember.user, this$RawChatMember.customTitle_0);
        case 'administrator':
          return new AdministratorChatMemberImpl(this$RawChatMember.user, this$RawChatMember.canBeEdited_0, this$RawChatMember.canChangeInfo_0, this$RawChatMember.canPostMessages_0, this$RawChatMember.canEditMessages_0, this$RawChatMember.canDeleteMessages_0, this$RawChatMember.canInviteUsers_0, this$RawChatMember.canRestrictMembers_0, this$RawChatMember.canPinMessages_0, this$RawChatMember.canPromoteMembers_0, this$RawChatMember.customTitle_0);
        case 'member':
          return new MemberChatMember(this$RawChatMember.user);
        case 'restricted':
          return new RestrictedChatMember(this$RawChatMember.user, this$RawChatMember.until_date_0, this$RawChatMember.isMember_0, this$RawChatMember.canSendMessages_0, this$RawChatMember.canSendMediaMessages_0, this$RawChatMember.canSendPolls_0, this$RawChatMember.canSendOtherMessages_0, this$RawChatMember.canAddWebPagePreviews_0, this$RawChatMember.canChangeInfo_0, this$RawChatMember.canInviteUsers_0, this$RawChatMember.canPinMessages_0);
        case 'left':
          return new LeftChatMember(this$RawChatMember.user);
        case 'kicked':
          return new KickedChatMember(this$RawChatMember.user, this$RawChatMember.until_date_0);
        default:throw IllegalStateException_init("Can't understand type of user: " + this$RawChatMember.status_0);
      }
    };
  }
  function RawChatMember_init(seen1, user, status, until_date, canBeEdited, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, isMember, canSendMessages, canSendMediaMessages, canSendPolls, canSendOtherMessages, canAddWebPagePreviews, customTitle, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(RawChatMember.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('user');
    else
      $this.user = user;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('status');
    else
      $this.status_0 = status;
    if ((seen1 & 4) === 0)
      $this.until_date_0 = null;
    else
      $this.until_date_0 = until_date;
    if ((seen1 & 8) === 0)
      $this.canBeEdited_0 = false;
    else
      $this.canBeEdited_0 = canBeEdited;
    if ((seen1 & 16) === 0)
      $this.canChangeInfo_0 = false;
    else
      $this.canChangeInfo_0 = canChangeInfo;
    if ((seen1 & 32) === 0)
      $this.canPostMessages_0 = false;
    else
      $this.canPostMessages_0 = canPostMessages;
    if ((seen1 & 64) === 0)
      $this.canEditMessages_0 = false;
    else
      $this.canEditMessages_0 = canEditMessages;
    if ((seen1 & 128) === 0)
      $this.canDeleteMessages_0 = false;
    else
      $this.canDeleteMessages_0 = canDeleteMessages;
    if ((seen1 & 256) === 0)
      $this.canInviteUsers_0 = false;
    else
      $this.canInviteUsers_0 = canInviteUsers;
    if ((seen1 & 512) === 0)
      $this.canRestrictMembers_0 = false;
    else
      $this.canRestrictMembers_0 = canRestrictMembers;
    if ((seen1 & 1024) === 0)
      $this.canPinMessages_0 = false;
    else
      $this.canPinMessages_0 = canPinMessages;
    if ((seen1 & 2048) === 0)
      $this.canPromoteMembers_0 = false;
    else
      $this.canPromoteMembers_0 = canPromoteMembers;
    if ((seen1 & 4096) === 0)
      $this.isMember_0 = false;
    else
      $this.isMember_0 = isMember;
    if ((seen1 & 8192) === 0)
      $this.canSendMessages_0 = false;
    else
      $this.canSendMessages_0 = canSendMessages;
    if ((seen1 & 16384) === 0)
      $this.canSendMediaMessages_0 = false;
    else
      $this.canSendMediaMessages_0 = canSendMediaMessages;
    if ((seen1 & 32768) === 0)
      $this.canSendPolls_0 = false;
    else
      $this.canSendPolls_0 = canSendPolls;
    if ((seen1 & 65536) === 0)
      $this.canSendOtherMessages_0 = false;
    else
      $this.canSendOtherMessages_0 = canSendOtherMessages;
    if ((seen1 & 131072) === 0)
      $this.canAddWebPagePreviews_0 = false;
    else
      $this.canAddWebPagePreviews_0 = canAddWebPagePreviews;
    if ((seen1 & 262144) === 0)
      $this.customTitle_0 = null;
    else
      $this.customTitle_0 = customTitle;
    $this.asChatMember_c98pt7$_0 = lazy(RawChatMember$asChatMember$lambda($this));
    return $this;
  }
  function RawChatMember$asChatMember$lambda(this$RawChatMember_0) {
    return function () {
      switch (this$RawChatMember.status_0) {
        case 'creator':
          return new CreatorChatMember(this$RawChatMember.user, this$RawChatMember.customTitle_0);
        case 'administrator':
          return new AdministratorChatMemberImpl(this$RawChatMember.user, this$RawChatMember.canBeEdited_0, this$RawChatMember.canChangeInfo_0, this$RawChatMember.canPostMessages_0, this$RawChatMember.canEditMessages_0, this$RawChatMember.canDeleteMessages_0, this$RawChatMember.canInviteUsers_0, this$RawChatMember.canRestrictMembers_0, this$RawChatMember.canPinMessages_0, this$RawChatMember.canPromoteMembers_0, this$RawChatMember.customTitle_0);
        case 'member':
          return new MemberChatMember(this$RawChatMember.user);
        case 'restricted':
          return new RestrictedChatMember(this$RawChatMember.user, this$RawChatMember.until_date_0, this$RawChatMember.isMember_0, this$RawChatMember.canSendMessages_0, this$RawChatMember.canSendMediaMessages_0, this$RawChatMember.canSendPolls_0, this$RawChatMember.canSendOtherMessages_0, this$RawChatMember.canAddWebPagePreviews_0, this$RawChatMember.canChangeInfo_0, this$RawChatMember.canInviteUsers_0, this$RawChatMember.canPinMessages_0);
        case 'left':
          return new LeftChatMember(this$RawChatMember.user);
        case 'kicked':
          return new KickedChatMember(this$RawChatMember.user, this$RawChatMember.until_date_0);
        default:throw IllegalStateException_init("Can't understand type of user: " + this$RawChatMember.status_0);
      }
    };
  }
  RawChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RawChatMember',
    interfaces: []
  };
  RawChatMember.prototype.component1 = function () {
    return this.user;
  };
  RawChatMember.prototype.component2_0 = function () {
    return this.status_0;
  };
  RawChatMember.prototype.component3_0 = function () {
    return this.until_date_0;
  };
  RawChatMember.prototype.component4_0 = function () {
    return this.canBeEdited_0;
  };
  RawChatMember.prototype.component5_0 = function () {
    return this.canChangeInfo_0;
  };
  RawChatMember.prototype.component6_0 = function () {
    return this.canPostMessages_0;
  };
  RawChatMember.prototype.component7_0 = function () {
    return this.canEditMessages_0;
  };
  RawChatMember.prototype.component8_0 = function () {
    return this.canDeleteMessages_0;
  };
  RawChatMember.prototype.component9_0 = function () {
    return this.canInviteUsers_0;
  };
  RawChatMember.prototype.component10_0 = function () {
    return this.canRestrictMembers_0;
  };
  RawChatMember.prototype.component11_0 = function () {
    return this.canPinMessages_0;
  };
  RawChatMember.prototype.component12_0 = function () {
    return this.canPromoteMembers_0;
  };
  RawChatMember.prototype.component13_0 = function () {
    return this.isMember_0;
  };
  RawChatMember.prototype.component14_0 = function () {
    return this.canSendMessages_0;
  };
  RawChatMember.prototype.component15_0 = function () {
    return this.canSendMediaMessages_0;
  };
  RawChatMember.prototype.component16_0 = function () {
    return this.canSendPolls_0;
  };
  RawChatMember.prototype.component17_0 = function () {
    return this.canSendOtherMessages_0;
  };
  RawChatMember.prototype.component18_0 = function () {
    return this.canAddWebPagePreviews_0;
  };
  RawChatMember.prototype.component19_0 = function () {
    return this.customTitle_0;
  };
  RawChatMember.prototype.copy_4t166f$ = function (user, status, until_date, canBeEdited, canChangeInfo, canPostMessages, canEditMessages, canDeleteMessages, canInviteUsers, canRestrictMembers, canPinMessages, canPromoteMembers, isMember, canSendMessages, canSendMediaMessages, canSendPolls, canSendOtherMessages, canAddWebPagePreviews, customTitle) {
    return new RawChatMember(user === void 0 ? this.user : user, status === void 0 ? this.status_0 : status, until_date === void 0 ? this.until_date_0 : until_date, canBeEdited === void 0 ? this.canBeEdited_0 : canBeEdited, canChangeInfo === void 0 ? this.canChangeInfo_0 : canChangeInfo, canPostMessages === void 0 ? this.canPostMessages_0 : canPostMessages, canEditMessages === void 0 ? this.canEditMessages_0 : canEditMessages, canDeleteMessages === void 0 ? this.canDeleteMessages_0 : canDeleteMessages, canInviteUsers === void 0 ? this.canInviteUsers_0 : canInviteUsers, canRestrictMembers === void 0 ? this.canRestrictMembers_0 : canRestrictMembers, canPinMessages === void 0 ? this.canPinMessages_0 : canPinMessages, canPromoteMembers === void 0 ? this.canPromoteMembers_0 : canPromoteMembers, isMember === void 0 ? this.isMember_0 : isMember, canSendMessages === void 0 ? this.canSendMessages_0 : canSendMessages, canSendMediaMessages === void 0 ? this.canSendMediaMessages_0 : canSendMediaMessages, canSendPolls === void 0 ? this.canSendPolls_0 : canSendPolls, canSendOtherMessages === void 0 ? this.canSendOtherMessages_0 : canSendOtherMessages, canAddWebPagePreviews === void 0 ? this.canAddWebPagePreviews_0 : canAddWebPagePreviews, customTitle === void 0 ? this.customTitle_0 : customTitle);
  };
  RawChatMember.prototype.toString = function () {
    return 'RawChatMember(user=' + Kotlin.toString(this.user) + (', status=' + Kotlin.toString(this.status_0)) + (', until_date=' + Kotlin.toString(this.until_date_0)) + (', canBeEdited=' + Kotlin.toString(this.canBeEdited_0)) + (', canChangeInfo=' + Kotlin.toString(this.canChangeInfo_0)) + (', canPostMessages=' + Kotlin.toString(this.canPostMessages_0)) + (', canEditMessages=' + Kotlin.toString(this.canEditMessages_0)) + (', canDeleteMessages=' + Kotlin.toString(this.canDeleteMessages_0)) + (', canInviteUsers=' + Kotlin.toString(this.canInviteUsers_0)) + (', canRestrictMembers=' + Kotlin.toString(this.canRestrictMembers_0)) + (', canPinMessages=' + Kotlin.toString(this.canPinMessages_0)) + (', canPromoteMembers=' + Kotlin.toString(this.canPromoteMembers_0)) + (', isMember=' + Kotlin.toString(this.isMember_0)) + (', canSendMessages=' + Kotlin.toString(this.canSendMessages_0)) + (', canSendMediaMessages=' + Kotlin.toString(this.canSendMediaMessages_0)) + (', canSendPolls=' + Kotlin.toString(this.canSendPolls_0)) + (', canSendOtherMessages=' + Kotlin.toString(this.canSendOtherMessages_0)) + (', canAddWebPagePreviews=' + Kotlin.toString(this.canAddWebPagePreviews_0)) + (', customTitle=' + Kotlin.toString(this.customTitle_0)) + ')';
  };
  RawChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.status_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.until_date_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canBeEdited_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canChangeInfo_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canPostMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canEditMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canDeleteMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canInviteUsers_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canRestrictMembers_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canPinMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canPromoteMembers_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.isMember_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canSendMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canSendMediaMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canSendPolls_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canSendOtherMessages_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.canAddWebPagePreviews_0) | 0;
    result = result * 31 + Kotlin.hashCode(this.customTitle_0) | 0;
    return result;
  };
  RawChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.user, other.user) && Kotlin.equals(this.status_0, other.status_0) && Kotlin.equals(this.until_date_0, other.until_date_0) && Kotlin.equals(this.canBeEdited_0, other.canBeEdited_0) && Kotlin.equals(this.canChangeInfo_0, other.canChangeInfo_0) && Kotlin.equals(this.canPostMessages_0, other.canPostMessages_0) && Kotlin.equals(this.canEditMessages_0, other.canEditMessages_0) && Kotlin.equals(this.canDeleteMessages_0, other.canDeleteMessages_0) && Kotlin.equals(this.canInviteUsers_0, other.canInviteUsers_0) && Kotlin.equals(this.canRestrictMembers_0, other.canRestrictMembers_0) && Kotlin.equals(this.canPinMessages_0, other.canPinMessages_0) && Kotlin.equals(this.canPromoteMembers_0, other.canPromoteMembers_0) && Kotlin.equals(this.isMember_0, other.isMember_0) && Kotlin.equals(this.canSendMessages_0, other.canSendMessages_0) && Kotlin.equals(this.canSendMediaMessages_0, other.canSendMediaMessages_0) && Kotlin.equals(this.canSendPolls_0, other.canSendPolls_0) && Kotlin.equals(this.canSendOtherMessages_0, other.canSendOtherMessages_0) && Kotlin.equals(this.canAddWebPagePreviews_0, other.canAddWebPagePreviews_0) && Kotlin.equals(this.customTitle_0, other.customTitle_0)))));
  };
  function RestrictedChatMember(user, untilDate, isMember, canSendMessages, canSendMediaMessages, canSendPolls, canSendOtherMessages, canAddWebpagePreviews, canChangeInfo, canInviteUsers, canPinMessages) {
    this.user_yt82rf$_0 = user;
    this.untilDate_l7qqxu$_0 = untilDate;
    this.isMember = isMember;
    this.canSendMessages = canSendMessages;
    this.canSendMediaMessages = canSendMediaMessages;
    this.canSendPolls = canSendPolls;
    this.canSendOtherMessages = canSendOtherMessages;
    this.canAddWebpagePreviews = canAddWebpagePreviews;
    this.canChangeInfo_pl4ps$_0 = canChangeInfo;
    this.canInviteUsers_9zpop5$_0 = canInviteUsers;
    this.canPinMessages_m93ng5$_0 = canPinMessages;
  }
  Object.defineProperty(RestrictedChatMember.prototype, 'user', {
    get: function () {
      return this.user_yt82rf$_0;
    }
  });
  Object.defineProperty(RestrictedChatMember.prototype, 'untilDate', {
    get: function () {
      return this.untilDate_l7qqxu$_0;
    }
  });
  Object.defineProperty(RestrictedChatMember.prototype, 'canChangeInfo', {
    get: function () {
      return this.canChangeInfo_pl4ps$_0;
    }
  });
  Object.defineProperty(RestrictedChatMember.prototype, 'canInviteUsers', {
    get: function () {
      return this.canInviteUsers_9zpop5$_0;
    }
  });
  Object.defineProperty(RestrictedChatMember.prototype, 'canPinMessages', {
    get: function () {
      return this.canPinMessages_m93ng5$_0;
    }
  });
  RestrictedChatMember.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RestrictedChatMember',
    interfaces: [SpecialRightsChatMember, BannedChatMember]
  };
  RestrictedChatMember.prototype.component1 = function () {
    return this.user;
  };
  RestrictedChatMember.prototype.component2 = function () {
    return this.untilDate;
  };
  RestrictedChatMember.prototype.component3 = function () {
    return this.isMember;
  };
  RestrictedChatMember.prototype.component4 = function () {
    return this.canSendMessages;
  };
  RestrictedChatMember.prototype.component5 = function () {
    return this.canSendMediaMessages;
  };
  RestrictedChatMember.prototype.component6 = function () {
    return this.canSendPolls;
  };
  RestrictedChatMember.prototype.component7 = function () {
    return this.canSendOtherMessages;
  };
  RestrictedChatMember.prototype.component8 = function () {
    return this.canAddWebpagePreviews;
  };
  RestrictedChatMember.prototype.component9 = function () {
    return this.canChangeInfo;
  };
  RestrictedChatMember.prototype.component10 = function () {
    return this.canInviteUsers;
  };
  RestrictedChatMember.prototype.component11 = function () {
    return this.canPinMessages;
  };
  RestrictedChatMember.prototype.copy_6wr7sk$ = function (user, untilDate, isMember, canSendMessages, canSendMediaMessages, canSendPolls, canSendOtherMessages, canAddWebpagePreviews, canChangeInfo, canInviteUsers, canPinMessages) {
    return new RestrictedChatMember(user === void 0 ? this.user : user, untilDate === void 0 ? this.untilDate : untilDate, isMember === void 0 ? this.isMember : isMember, canSendMessages === void 0 ? this.canSendMessages : canSendMessages, canSendMediaMessages === void 0 ? this.canSendMediaMessages : canSendMediaMessages, canSendPolls === void 0 ? this.canSendPolls : canSendPolls, canSendOtherMessages === void 0 ? this.canSendOtherMessages : canSendOtherMessages, canAddWebpagePreviews === void 0 ? this.canAddWebpagePreviews : canAddWebpagePreviews, canChangeInfo === void 0 ? this.canChangeInfo : canChangeInfo, canInviteUsers === void 0 ? this.canInviteUsers : canInviteUsers, canPinMessages === void 0 ? this.canPinMessages : canPinMessages);
  };
  RestrictedChatMember.prototype.toString = function () {
    return 'RestrictedChatMember(user=' + Kotlin.toString(this.user) + (', untilDate=' + Kotlin.toString(this.untilDate)) + (', isMember=' + Kotlin.toString(this.isMember)) + (', canSendMessages=' + Kotlin.toString(this.canSendMessages)) + (', canSendMediaMessages=' + Kotlin.toString(this.canSendMediaMessages)) + (', canSendPolls=' + Kotlin.toString(this.canSendPolls)) + (', canSendOtherMessages=' + Kotlin.toString(this.canSendOtherMessages)) + (', canAddWebpagePreviews=' + Kotlin.toString(this.canAddWebpagePreviews)) + (', canChangeInfo=' + Kotlin.toString(this.canChangeInfo)) + (', canInviteUsers=' + Kotlin.toString(this.canInviteUsers)) + (', canPinMessages=' + Kotlin.toString(this.canPinMessages)) + ')';
  };
  RestrictedChatMember.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.untilDate) | 0;
    result = result * 31 + Kotlin.hashCode(this.isMember) | 0;
    result = result * 31 + Kotlin.hashCode(this.canSendMessages) | 0;
    result = result * 31 + Kotlin.hashCode(this.canSendMediaMessages) | 0;
    result = result * 31 + Kotlin.hashCode(this.canSendPolls) | 0;
    result = result * 31 + Kotlin.hashCode(this.canSendOtherMessages) | 0;
    result = result * 31 + Kotlin.hashCode(this.canAddWebpagePreviews) | 0;
    result = result * 31 + Kotlin.hashCode(this.canChangeInfo) | 0;
    result = result * 31 + Kotlin.hashCode(this.canInviteUsers) | 0;
    result = result * 31 + Kotlin.hashCode(this.canPinMessages) | 0;
    return result;
  };
  RestrictedChatMember.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.user, other.user) && Kotlin.equals(this.untilDate, other.untilDate) && Kotlin.equals(this.isMember, other.isMember) && Kotlin.equals(this.canSendMessages, other.canSendMessages) && Kotlin.equals(this.canSendMediaMessages, other.canSendMediaMessages) && Kotlin.equals(this.canSendPolls, other.canSendPolls) && Kotlin.equals(this.canSendOtherMessages, other.canSendOtherMessages) && Kotlin.equals(this.canAddWebpagePreviews, other.canAddWebpagePreviews) && Kotlin.equals(this.canChangeInfo, other.canChangeInfo) && Kotlin.equals(this.canInviteUsers, other.canInviteUsers) && Kotlin.equals(this.canPinMessages, other.canPinMessages)))));
  };
  function AdministratorChatMember() {
  }
  AdministratorChatMember.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'AdministratorChatMember',
    interfaces: [SpecialRightsChatMember]
  };
  function BannedChatMember() {
  }
  BannedChatMember.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'BannedChatMember',
    interfaces: [UntilDate, ChatMember]
  };
  function ChatMember() {
  }
  ChatMember.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ChatMember',
    interfaces: []
  };
  function AdministratorChatMemberSerializerWithoutDeserialization() {
    AdministratorChatMemberSerializerWithoutDeserialization_instance = this;
    this.descriptor_be04tn$_0 = withName(internal.StringDescriptor, 'ChatMemberSerializerWithoutDeserialization');
  }
  Object.defineProperty(AdministratorChatMemberSerializerWithoutDeserialization.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_be04tn$_0;
    }
  });
  AdministratorChatMemberSerializerWithoutDeserialization.prototype.deserialize_nts5qn$ = function (decoder) {
    var tmp$;
    return Kotlin.isType(tmp$ = ChatMemberDeserializationStrategy_getInstance().deserialize_nts5qn$(decoder), AdministratorChatMember) ? tmp$ : throwCCE();
  };
  AdministratorChatMemberSerializerWithoutDeserialization.prototype.serialize_awe97i$ = function (encoder, obj) {
    throw UnsupportedOperationException_init();
  };
  AdministratorChatMemberSerializerWithoutDeserialization.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'AdministratorChatMemberSerializerWithoutDeserialization',
    interfaces: [KSerializer]
  };
  var AdministratorChatMemberSerializerWithoutDeserialization_instance = null;
  function AdministratorChatMemberSerializerWithoutDeserialization_getInstance() {
    if (AdministratorChatMemberSerializerWithoutDeserialization_instance === null) {
      new AdministratorChatMemberSerializerWithoutDeserialization();
    }
    return AdministratorChatMemberSerializerWithoutDeserialization_instance;
  }
  function ChatMemberDeserializationStrategy() {
    ChatMemberDeserializationStrategy_instance = this;
    this.descriptor_oizu8z$_0 = withName(internal.StringDescriptor, 'ChatMemberDeserializationStrategy');
  }
  Object.defineProperty(ChatMemberDeserializationStrategy.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_oizu8z$_0;
    }
  });
  ChatMemberDeserializationStrategy.prototype.deserialize_nts5qn$ = function (decoder) {
    return RawChatMember$Companion_getInstance().serializer().deserialize_nts5qn$(decoder).asChatMember;
  };
  ChatMemberDeserializationStrategy.prototype.patch_mynpiu$ = function (decoder, old) {
    throw new UpdateNotSupportedException(this.descriptor.name);
  };
  ChatMemberDeserializationStrategy.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ChatMemberDeserializationStrategy',
    interfaces: [DeserializationStrategy]
  };
  var ChatMemberDeserializationStrategy_instance = null;
  function ChatMemberDeserializationStrategy_getInstance() {
    if (ChatMemberDeserializationStrategy_instance === null) {
      new ChatMemberDeserializationStrategy();
    }
    return ChatMemberDeserializationStrategy_instance;
  }
  function SpecialRightsChatMember() {
  }
  SpecialRightsChatMember.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'SpecialRightsChatMember',
    interfaces: [ChatMember]
  };
  function ChatPhoto(smallFileId, bigFileId, smallFileUniqueId, bigFileUniqueId) {
    ChatPhoto$Companion_getInstance();
    this.smallFileId = smallFileId;
    this.bigFileId = bigFileId;
    this.smallFileUniqueId = smallFileUniqueId;
    this.bigFileUniqueId = bigFileUniqueId;
  }
  function ChatPhoto$Companion() {
    ChatPhoto$Companion_instance = this;
  }
  ChatPhoto$Companion.prototype.serializer = function () {
    return ChatPhoto$$serializer_getInstance();
  };
  ChatPhoto$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var ChatPhoto$Companion_instance = null;
  function ChatPhoto$Companion_getInstance() {
    if (ChatPhoto$Companion_instance === null) {
      new ChatPhoto$Companion();
    }
    return ChatPhoto$Companion_instance;
  }
  function ChatPhoto$$serializer() {
    this.descriptor_z4hdtc$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.ChatPhoto', this);
    this.descriptor.addElement_ivxn3r$('small_file_id', false);
    this.descriptor.addElement_ivxn3r$('big_file_id', false);
    this.descriptor.addElement_ivxn3r$('small_file_unique_id', false);
    this.descriptor.addElement_ivxn3r$('big_file_unique_id', false);
    ChatPhoto$$serializer_instance = this;
  }
  Object.defineProperty(ChatPhoto$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_z4hdtc$_0;
    }
  });
  ChatPhoto$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.smallFileId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.bigFileId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.smallFileUniqueId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 3, obj.bigFileUniqueId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  ChatPhoto$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = input.decodeStringElement_3zr2iy$(this.descriptor, 3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return ChatPhoto_init(bitMask0, local0, local1, local2, local3, null);
  };
  ChatPhoto$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.StringSerializer, internal.StringSerializer, internal.StringSerializer];
  };
  ChatPhoto$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var ChatPhoto$$serializer_instance = null;
  function ChatPhoto$$serializer_getInstance() {
    if (ChatPhoto$$serializer_instance === null) {
      new ChatPhoto$$serializer();
    }
    return ChatPhoto$$serializer_instance;
  }
  function ChatPhoto_init(seen1, smallFileId, bigFileId, smallFileUniqueId, bigFileUniqueId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(ChatPhoto.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('small_file_id');
    else
      $this.smallFileId = smallFileId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('big_file_id');
    else
      $this.bigFileId = bigFileId;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('small_file_unique_id');
    else
      $this.smallFileUniqueId = smallFileUniqueId;
    if ((seen1 & 8) === 0)
      throw new MissingFieldException('big_file_unique_id');
    else
      $this.bigFileUniqueId = bigFileUniqueId;
    return $this;
  }
  ChatPhoto.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChatPhoto',
    interfaces: []
  };
  ChatPhoto.prototype.component1 = function () {
    return this.smallFileId;
  };
  ChatPhoto.prototype.component2 = function () {
    return this.bigFileId;
  };
  ChatPhoto.prototype.component3 = function () {
    return this.smallFileUniqueId;
  };
  ChatPhoto.prototype.component4 = function () {
    return this.bigFileUniqueId;
  };
  ChatPhoto.prototype.copy_w74nik$ = function (smallFileId, bigFileId, smallFileUniqueId, bigFileUniqueId) {
    return new ChatPhoto(smallFileId === void 0 ? this.smallFileId : smallFileId, bigFileId === void 0 ? this.bigFileId : bigFileId, smallFileUniqueId === void 0 ? this.smallFileUniqueId : smallFileUniqueId, bigFileUniqueId === void 0 ? this.bigFileUniqueId : bigFileUniqueId);
  };
  ChatPhoto.prototype.toString = function () {
    return 'ChatPhoto(smallFileId=' + Kotlin.toString(this.smallFileId) + (', bigFileId=' + Kotlin.toString(this.bigFileId)) + (', smallFileUniqueId=' + Kotlin.toString(this.smallFileUniqueId)) + (', bigFileUniqueId=' + Kotlin.toString(this.bigFileUniqueId)) + ')';
  };
  ChatPhoto.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.smallFileId) | 0;
    result = result * 31 + Kotlin.hashCode(this.bigFileId) | 0;
    result = result * 31 + Kotlin.hashCode(this.smallFileUniqueId) | 0;
    result = result * 31 + Kotlin.hashCode(this.bigFileUniqueId) | 0;
    return result;
  };
  ChatPhoto.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.smallFileId, other.smallFileId) && Kotlin.equals(this.bigFileId, other.bigFileId) && Kotlin.equals(this.smallFileUniqueId, other.smallFileUniqueId) && Kotlin.equals(this.bigFileUniqueId, other.bigFileUniqueId)))));
  };
  var callbackQueryAnswerLength;
  var captionLength;
  var textLength;
  var userProfilePhotosRequestLimit;
  var chatTitleLength;
  var chatDescriptionLength;
  var inlineResultQueryIdLingth;
  var allowedConnectionsLength;
  var invoiceTitleLimit;
  var invoiceDescriptionLimit;
  var invoicePayloadBytesLimit;
  var pollOptionTextLength;
  var pollQuestionTextLength;
  var pollOptionsLimit;
  var livePeriodLimit;
  var inlineQueryAnswerResultsLimit;
  var customTitleLength;
  var chatIdField;
  var messageIdField;
  var updateIdField;
  var fromChatIdField;
  var disableWebPagePreviewField;
  var disableNotificationField;
  var replyToMessageIdField;
  var replyMarkupField;
  var supportStreamingField;
  var livePeriodField;
  var isBotField;
  var firstNameField;
  var lastNameField;
  var languageCodeField;
  var textEntitiesField;
  var stickerSetNameField;
  var stickerSetNameFullField;
  var slowModeDelayField;
  var maskPositionField;
  var phoneNumberField;
  var userIdField;
  var containsMasksField;
  var resultIdField;
  var inlineMessageIdField;
  var callbackDataField;
  var callbackQueryIdField;
  var inlineQueryIdField;
  var inlineKeyboardField;
  var showAlertField;
  var cachedTimeField;
  var foursquareIdField;
  var foursquareTypeField;
  var untilDateField;
  var errorMessageField;
  var messageTextField;
  var isPersonalField;
  var nextOffsetField;
  var switchPmTextField;
  var switchPmParameterField;
  var maxAllowedConnectionsField;
  var allowedUpdatesField;
  var hasCustomCertificateField;
  var pendingUpdateCountField;
  var lastErrorDateField;
  var lastErrorMessageField;
  var votesCountField;
  var isClosedField;
  var loginUrlField;
  var forwardTextField;
  var botUsernameField;
  var switchInlineQueryCurrentChatField;
  var switchInlineQueryField;
  var isAnimatedField;
  var inviteLinkField;
  var pinnedMessageField;
  var customTitleField;
  var requestWriteAccessField;
  var photoUrlField;
  var photoSizeField;
  var photoFileIdField;
  var photoWidthField;
  var photoHeightField;
  var gifUrlField;
  var gifFileIdField;
  var gifWidthField;
  var gifHeightField;
  var gifDurationField;
  var mpeg4GifUrlField;
  var mpeg4GifFileIdField;
  var mpeg4GifWidthField;
  var mpeg4GifHeightField;
  var mpeg4GifDurationField;
  var videoUrlField;
  var videoFileIdField;
  var videoWidthField;
  var videoHeightField;
  var videoDurationField;
  var audioUrlField;
  var audioFileIdField;
  var audioDurationField;
  var voiceUrlField;
  var voiceFileIdField;
  var voiceDurationField;
  var documentUrlField;
  var documentFileIdField;
  var stickerFileIdField;
  var gameShortNameField;
  var thumbUrlField;
  var thumbWidthField;
  var thumbHeightField;
  var inputMessageContentField;
  var hideUrlField;
  var isMemberField;
  var canSendMessagesField;
  var canSendMediaMessagesField;
  var canSendOtherMessagesField;
  var canSendPollsField;
  var canAddWebPagePreviewsField;
  var canSetStickerSetField;
  var canBeEditedField;
  var canChangeInfoField;
  var canPostMessagesField;
  var canEditMessagesField;
  var canDeleteMessagesField;
  var canInviteUsersField;
  var canRestrictMembersField;
  var canPinMessagesField;
  var canPromoteMembersField;
  var pngStickerField;
  var okField;
  var captionField;
  var idField;
  var textField;
  var thumbField;
  var emojiField;
  var emojisField;
  var titleField;
  var descriptionField;
  var performerField;
  var durationField;
  var widthField;
  var heightField;
  var lengthField;
  var latitudeField;
  var longitudeField;
  var fromField;
  var userField;
  var dateField;
  var chatField;
  var usernameField;
  var nameField;
  var emailField;
  var locationField;
  var queryField;
  var offsetField;
  var limitField;
  var stickersField;
  var stickerField;
  var urlField;
  var addressField;
  var actionField;
  var positionField;
  var labelField;
  var amountField;
  var pricesField;
  var payloadField;
  var vcardField;
  var resultsField;
  var certificateField;
  var questionField;
  var optionsField;
  var payField;
  var permissionsField;
  var typeField;
  var pointField;
  var xShiftField;
  var yShiftField;
  var scaleField;
  var smallFileIdField;
  var bigFileIdField;
  var smallFileUniqueIdField;
  var bigFileUniqueIdField;
  var fileUniqueIdField;
  var currencyField;
  var startParameterField;
  var totalAmountField;
  var invoicePayloadField;
  var shippingOptionIdField;
  var shippingQueryIdField;
  var preCheckoutQueryIdField;
  var shippingOptionsField;
  var countryCodeField;
  var stateField;
  var cityField;
  var firstStreetLineField;
  var secondStreetLineField;
  var postCodeField;
  var shippingAddressField;
  var orderInfoField;
  var telegramPaymentChargeIdField;
  var providerPaymentChargeIdField;
  var providerTokenField;
  var providerDataField;
  var requireNameField;
  var requirePhoneNumberField;
  var requireEmailField;
  var requireShippingAddressField;
  var shouldSendPhoneNumberToProviderField;
  var shouldSendEmailToProviderField;
  var priceDependOnShipAddressField;
  var documentField;
  var photoField;
  var audioField;
  var videoField;
  var animationField;
  var voiceField;
  var videoNoteField;
  var mediaField;
  var disableEditMessageField;
  var scoreField;
  var forceField;
  function Contact(phoneNumber, firstName, lastName, userId, vcard) {
    Contact$Companion_getInstance();
    if (lastName === void 0)
      lastName = null;
    if (userId === void 0)
      userId = null;
    if (vcard === void 0)
      vcard = null;
    this.phoneNumber_i55duo$_0 = phoneNumber;
    this.firstName_wmmxw$_0 = firstName;
    this.lastName_a6gnrw$_0 = lastName;
    this.userId = userId;
    this.vcard_6rljhr$_0 = vcard;
  }
  Object.defineProperty(Contact.prototype, 'phoneNumber', {
    get: function () {
      return this.phoneNumber_i55duo$_0;
    }
  });
  Object.defineProperty(Contact.prototype, 'firstName', {
    get: function () {
      return this.firstName_wmmxw$_0;
    }
  });
  Object.defineProperty(Contact.prototype, 'lastName', {
    get: function () {
      return this.lastName_a6gnrw$_0;
    }
  });
  Object.defineProperty(Contact.prototype, 'vcard', {
    get: function () {
      return this.vcard_6rljhr$_0;
    }
  });
  function Contact$Companion() {
    Contact$Companion_instance = this;
  }
  Contact$Companion.prototype.serializer = function () {
    return Contact$$serializer_getInstance();
  };
  Contact$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Contact$Companion_instance = null;
  function Contact$Companion_getInstance() {
    if (Contact$Companion_instance === null) {
      new Contact$Companion();
    }
    return Contact$Companion_instance;
  }
  function Contact$$serializer() {
    this.descriptor_d24yve$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.Contact', this);
    this.descriptor.addElement_ivxn3r$('phone_number', false);
    this.descriptor.addElement_ivxn3r$('first_name', false);
    this.descriptor.addElement_ivxn3r$('last_name', true);
    this.descriptor.addElement_ivxn3r$('user_id', true);
    this.descriptor.addElement_ivxn3r$('vcard', true);
    Contact$$serializer_instance = this;
  }
  Object.defineProperty(Contact$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_d24yve$_0;
    }
  });
  Contact$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.phoneNumber);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.firstName);
    if (!equals(obj.lastName, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.StringSerializer, obj.lastName);
    if (!equals(obj.userId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, ChatIdentifierSerializer_getInstance(), obj.userId);
    if (!equals(obj.vcard, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.StringSerializer, obj.vcard);
    output.endStructure_qatsm0$(this.descriptor);
  };
  Contact$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, ChatIdentifierSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, ChatIdentifierSerializer_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.StringSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return Contact_init(bitMask0, local0, local1, local2, local3, local4, null);
  };
  Contact$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.StringSerializer, new NullableSerializer(internal.StringSerializer), new NullableSerializer(ChatIdentifierSerializer_getInstance()), new NullableSerializer(internal.StringSerializer)];
  };
  Contact$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var Contact$$serializer_instance = null;
  function Contact$$serializer_getInstance() {
    if (Contact$$serializer_instance === null) {
      new Contact$$serializer();
    }
    return Contact$$serializer_instance;
  }
  function Contact_init(seen1, phoneNumber, firstName, lastName, userId, vcard, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(Contact.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('phone_number');
    else
      $this.phoneNumber_i55duo$_0 = phoneNumber;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('first_name');
    else
      $this.firstName_wmmxw$_0 = firstName;
    if ((seen1 & 4) === 0)
      $this.lastName_a6gnrw$_0 = null;
    else
      $this.lastName_a6gnrw$_0 = lastName;
    if ((seen1 & 8) === 0)
      $this.userId = null;
    else
      $this.userId = userId;
    if ((seen1 & 16) === 0)
      $this.vcard_6rljhr$_0 = null;
    else
      $this.vcard_6rljhr$_0 = vcard;
    return $this;
  }
  Contact.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Contact',
    interfaces: [CommonContactData]
  };
  Contact.prototype.component1 = function () {
    return this.phoneNumber;
  };
  Contact.prototype.component2 = function () {
    return this.firstName;
  };
  Contact.prototype.component3 = function () {
    return this.lastName;
  };
  Contact.prototype.component4 = function () {
    return this.userId;
  };
  Contact.prototype.component5 = function () {
    return this.vcard;
  };
  Contact.prototype.copy_7m63c1$ = function (phoneNumber, firstName, lastName, userId, vcard) {
    return new Contact(phoneNumber === void 0 ? this.phoneNumber : phoneNumber, firstName === void 0 ? this.firstName : firstName, lastName === void 0 ? this.lastName : lastName, userId === void 0 ? this.userId : userId, vcard === void 0 ? this.vcard : vcard);
  };
  Contact.prototype.toString = function () {
    return 'Contact(phoneNumber=' + Kotlin.toString(this.phoneNumber) + (', firstName=' + Kotlin.toString(this.firstName)) + (', lastName=' + Kotlin.toString(this.lastName)) + (', userId=' + Kotlin.toString(this.userId)) + (', vcard=' + Kotlin.toString(this.vcard)) + ')';
  };
  Contact.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.phoneNumber) | 0;
    result = result * 31 + Kotlin.hashCode(this.firstName) | 0;
    result = result * 31 + Kotlin.hashCode(this.lastName) | 0;
    result = result * 31 + Kotlin.hashCode(this.userId) | 0;
    result = result * 31 + Kotlin.hashCode(this.vcard) | 0;
    return result;
  };
  Contact.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.phoneNumber, other.phoneNumber) && Kotlin.equals(this.firstName, other.firstName) && Kotlin.equals(this.lastName, other.lastName) && Kotlin.equals(this.userId, other.userId) && Kotlin.equals(this.vcard, other.vcard)))));
  };
  function BaseChosenInlineResult(resultId, user, inlineMessageId, query) {
    this.resultId_elhvyb$_0 = resultId;
    this.user_uduaj4$_0 = user;
    this.inlineMessageId_en83gw$_0 = inlineMessageId;
    this.query_kdp7m7$_0 = query;
  }
  Object.defineProperty(BaseChosenInlineResult.prototype, 'resultId', {
    get: function () {
      return this.resultId_elhvyb$_0;
    }
  });
  Object.defineProperty(BaseChosenInlineResult.prototype, 'user', {
    get: function () {
      return this.user_uduaj4$_0;
    }
  });
  Object.defineProperty(BaseChosenInlineResult.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_en83gw$_0;
    }
  });
  Object.defineProperty(BaseChosenInlineResult.prototype, 'query', {
    get: function () {
      return this.query_kdp7m7$_0;
    }
  });
  BaseChosenInlineResult.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BaseChosenInlineResult',
    interfaces: [ChosenInlineResult]
  };
  BaseChosenInlineResult.prototype.component1 = function () {
    return this.resultId;
  };
  BaseChosenInlineResult.prototype.component2 = function () {
    return this.user;
  };
  BaseChosenInlineResult.prototype.component3 = function () {
    return this.inlineMessageId;
  };
  BaseChosenInlineResult.prototype.component4 = function () {
    return this.query;
  };
  BaseChosenInlineResult.prototype.copy_cryakz$ = function (resultId, user, inlineMessageId, query) {
    return new BaseChosenInlineResult(resultId === void 0 ? this.resultId : resultId, user === void 0 ? this.user : user, inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, query === void 0 ? this.query : query);
  };
  BaseChosenInlineResult.prototype.toString = function () {
    return 'BaseChosenInlineResult(resultId=' + Kotlin.toString(this.resultId) + (', user=' + Kotlin.toString(this.user)) + (', inlineMessageId=' + Kotlin.toString(this.inlineMessageId)) + (', query=' + Kotlin.toString(this.query)) + ')';
  };
  BaseChosenInlineResult.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.resultId) | 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.query) | 0;
    return result;
  };
  BaseChosenInlineResult.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.resultId, other.resultId) && Kotlin.equals(this.user, other.user) && Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.query, other.query)))));
  };
  function LocationChosenInlineResult(resultId, user, location, inlineMessageId, query) {
    this.resultId_o9l255$_0 = resultId;
    this.user_xvl4b8$_0 = user;
    this.location = location;
    this.inlineMessageId_ucwvec$_0 = inlineMessageId;
    this.query_h4kysz$_0 = query;
  }
  Object.defineProperty(LocationChosenInlineResult.prototype, 'resultId', {
    get: function () {
      return this.resultId_o9l255$_0;
    }
  });
  Object.defineProperty(LocationChosenInlineResult.prototype, 'user', {
    get: function () {
      return this.user_xvl4b8$_0;
    }
  });
  Object.defineProperty(LocationChosenInlineResult.prototype, 'inlineMessageId', {
    get: function () {
      return this.inlineMessageId_ucwvec$_0;
    }
  });
  Object.defineProperty(LocationChosenInlineResult.prototype, 'query', {
    get: function () {
      return this.query_h4kysz$_0;
    }
  });
  LocationChosenInlineResult.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LocationChosenInlineResult',
    interfaces: [ChosenInlineResult]
  };
  LocationChosenInlineResult.prototype.component1 = function () {
    return this.resultId;
  };
  LocationChosenInlineResult.prototype.component2 = function () {
    return this.user;
  };
  LocationChosenInlineResult.prototype.component3 = function () {
    return this.location;
  };
  LocationChosenInlineResult.prototype.component4 = function () {
    return this.inlineMessageId;
  };
  LocationChosenInlineResult.prototype.component5 = function () {
    return this.query;
  };
  LocationChosenInlineResult.prototype.copy_8vygcl$ = function (resultId, user, location, inlineMessageId, query) {
    return new LocationChosenInlineResult(resultId === void 0 ? this.resultId : resultId, user === void 0 ? this.user : user, location === void 0 ? this.location : location, inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId, query === void 0 ? this.query : query);
  };
  LocationChosenInlineResult.prototype.toString = function () {
    return 'LocationChosenInlineResult(resultId=' + Kotlin.toString(this.resultId) + (', user=' + Kotlin.toString(this.user)) + (', location=' + Kotlin.toString(this.location)) + (', inlineMessageId=' + Kotlin.toString(this.inlineMessageId)) + (', query=' + Kotlin.toString(this.query)) + ')';
  };
  LocationChosenInlineResult.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.resultId) | 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    result = result * 31 + Kotlin.hashCode(this.query) | 0;
    return result;
  };
  LocationChosenInlineResult.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.resultId, other.resultId) && Kotlin.equals(this.user, other.user) && Kotlin.equals(this.location, other.location) && Kotlin.equals(this.inlineMessageId, other.inlineMessageId) && Kotlin.equals(this.query, other.query)))));
  };
  function RawChosenInlineResult(resultId, user, query, location, inlineMessageId) {
    RawChosenInlineResult$Companion_getInstance();
    if (location === void 0)
      location = null;
    if (inlineMessageId === void 0)
      inlineMessageId = null;
    this.resultId = resultId;
    this.user = user;
    this.query = query;
    this.location = location;
    this.inlineMessageId = inlineMessageId;
    this.asChosenInlineResult_krdtos$_0 = lazy(RawChosenInlineResult$asChosenInlineResult$lambda(this));
  }
  Object.defineProperty(RawChosenInlineResult.prototype, 'asChosenInlineResult', {
    get: function () {
      return this.asChosenInlineResult_krdtos$_0.value;
    }
  });
  function RawChosenInlineResult$Companion() {
    RawChosenInlineResult$Companion_instance = this;
  }
  RawChosenInlineResult$Companion.prototype.serializer = function () {
    return RawChosenInlineResult$$serializer_getInstance();
  };
  RawChosenInlineResult$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var RawChosenInlineResult$Companion_instance = null;
  function RawChosenInlineResult$Companion_getInstance() {
    if (RawChosenInlineResult$Companion_instance === null) {
      new RawChosenInlineResult$Companion();
    }
    return RawChosenInlineResult$Companion_instance;
  }
  function RawChosenInlineResult$$serializer() {
    this.descriptor_p2pa7z$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.InlineQueries.ChosenInlineResult.RawChosenInlineResult', this);
    this.descriptor.addElement_ivxn3r$('result_id', false);
    this.descriptor.addElement_ivxn3r$('from', false);
    this.descriptor.addElement_ivxn3r$('query', false);
    this.descriptor.addElement_ivxn3r$('location', true);
    this.descriptor.addElement_ivxn3r$('inline_message_id', true);
    RawChosenInlineResult$$serializer_instance = this;
  }
  Object.defineProperty(RawChosenInlineResult$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_p2pa7z$_0;
    }
  });
  RawChosenInlineResult$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.resultId);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, User$$serializer_getInstance(), obj.user);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.query);
    if (!equals(obj.location, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, Location$$serializer_getInstance(), obj.location);
    if (!equals(obj.inlineMessageId, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.StringSerializer, obj.inlineMessageId);
    output.endStructure_qatsm0$(this.descriptor);
  };
  RawChosenInlineResult$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, User$$serializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, User$$serializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, Location$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, Location$$serializer_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.StringSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return RawChosenInlineResult_init(bitMask0, local0, local1, local2, local3, local4, null);
  };
  RawChosenInlineResult$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, User$$serializer_getInstance(), internal.StringSerializer, new NullableSerializer(Location$$serializer_getInstance()), new NullableSerializer(internal.StringSerializer)];
  };
  RawChosenInlineResult$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var RawChosenInlineResult$$serializer_instance = null;
  function RawChosenInlineResult$$serializer_getInstance() {
    if (RawChosenInlineResult$$serializer_instance === null) {
      new RawChosenInlineResult$$serializer();
    }
    return RawChosenInlineResult$$serializer_instance;
  }
  function RawChosenInlineResult$asChosenInlineResult$lambda(this$RawChosenInlineResult) {
    return function () {
      var tmp$_0;
      return (tmp$_0 = this$RawChosenInlineResult.location != null ? new LocationChosenInlineResult(this$RawChosenInlineResult.resultId, this$RawChosenInlineResult.user, this$RawChosenInlineResult.location, this$RawChosenInlineResult.inlineMessageId, this$RawChosenInlineResult.query) : null) != null ? tmp$_0 : new BaseChosenInlineResult(this$RawChosenInlineResult.resultId, this$RawChosenInlineResult.user, this$RawChosenInlineResult.inlineMessageId, this$RawChosenInlineResult.query);
    };
  }
  function RawChosenInlineResult_init(seen1, resultId, user, query, location, inlineMessageId, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(RawChosenInlineResult.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('result_id');
    else
      $this.resultId = resultId;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('from');
    else
      $this.user = user;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('query');
    else
      $this.query = query;
    if ((seen1 & 8) === 0)
      $this.location = null;
    else
      $this.location = location;
    if ((seen1 & 16) === 0)
      $this.inlineMessageId = null;
    else
      $this.inlineMessageId = inlineMessageId;
    $this.asChosenInlineResult_krdtos$_0 = lazy(RawChosenInlineResult$asChosenInlineResult$lambda($this));
    return $this;
  }
  function RawChosenInlineResult$asChosenInlineResult$lambda(this$RawChosenInlineResult_0) {
    return function () {
      var tmp$_0;
      return (tmp$_0 = this$RawChosenInlineResult.location != null ? new LocationChosenInlineResult(this$RawChosenInlineResult.resultId, this$RawChosenInlineResult.user, this$RawChosenInlineResult.location, this$RawChosenInlineResult.inlineMessageId, this$RawChosenInlineResult.query) : null) != null ? tmp$_0 : new BaseChosenInlineResult(this$RawChosenInlineResult.resultId, this$RawChosenInlineResult.user, this$RawChosenInlineResult.inlineMessageId, this$RawChosenInlineResult.query);
    };
  }
  RawChosenInlineResult.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RawChosenInlineResult',
    interfaces: []
  };
  RawChosenInlineResult.prototype.component1 = function () {
    return this.resultId;
  };
  RawChosenInlineResult.prototype.component2 = function () {
    return this.user;
  };
  RawChosenInlineResult.prototype.component3 = function () {
    return this.query;
  };
  RawChosenInlineResult.prototype.component4 = function () {
    return this.location;
  };
  RawChosenInlineResult.prototype.component5 = function () {
    return this.inlineMessageId;
  };
  RawChosenInlineResult.prototype.copy_ufvr8c$ = function (resultId, user, query, location, inlineMessageId) {
    return new RawChosenInlineResult(resultId === void 0 ? this.resultId : resultId, user === void 0 ? this.user : user, query === void 0 ? this.query : query, location === void 0 ? this.location : location, inlineMessageId === void 0 ? this.inlineMessageId : inlineMessageId);
  };
  RawChosenInlineResult.prototype.toString = function () {
    return 'RawChosenInlineResult(resultId=' + Kotlin.toString(this.resultId) + (', user=' + Kotlin.toString(this.user)) + (', query=' + Kotlin.toString(this.query)) + (', location=' + Kotlin.toString(this.location)) + (', inlineMessageId=' + Kotlin.toString(this.inlineMessageId)) + ')';
  };
  RawChosenInlineResult.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.resultId) | 0;
    result = result * 31 + Kotlin.hashCode(this.user) | 0;
    result = result * 31 + Kotlin.hashCode(this.query) | 0;
    result = result * 31 + Kotlin.hashCode(this.location) | 0;
    result = result * 31 + Kotlin.hashCode(this.inlineMessageId) | 0;
    return result;
  };
  RawChosenInlineResult.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.resultId, other.resultId) && Kotlin.equals(this.user, other.user) && Kotlin.equals(this.query, other.query) && Kotlin.equals(this.location, other.location) && Kotlin.equals(this.inlineMessageId, other.inlineMessageId)))));
  };
  function InlineQueryResultArticle(id, title, inputMessageContent, replyMarkup, url, hideUrl, description, thumbUrl, thumbWidth, thumbHeight) {
    InlineQueryResultArticle$Companion_getInstance();
    if (replyMarkup === void 0)
      replyMarkup = null;
    if (url === void 0)
      url = null;
    if (hideUrl === void 0)
      hideUrl = null;
    if (description === void 0)
      description = null;
    if (thumbUrl === void 0)
      thumbUrl = null;
    if (thumbWidth === void 0)
      thumbWidth = null;
    if (thumbHeight === void 0)
      thumbHeight = null;
    this.id_rjsz4d$_0 = id;
    this.title_aq25nw$_0 = title;
    this.inputMessageContent_gqg500$_0 = inputMessageContent;
    this.replyMarkup_7ctrk6$_0 = replyMarkup;
    this.url_1otkil$_0 = url;
    this.hideUrl = hideUrl;
    this.description_c71oog$_0 = description;
    this.thumbUrl_803qsv$_0 = thumbUrl;
    this.thumbWidth_k8ts6w$_0 = thumbWidth;
    this.thumbHeight_kkn39t$_0 = thumbHeight;
    this.type_io2lma$_0 = 'article';
  }
  Object.defineProperty(InlineQueryResultArticle.prototype, 'id', {
    get: function () {
      return this.id_rjsz4d$_0;
    }
  });
  Object.defineProperty(InlineQueryResultArticle.prototype, 'title', {
    get: function () {
      return this.title_aq25nw$_0;
    }
  });
  Object.defineProperty(InlineQueryResultArticle.prototype, 'inputMessageContent', {
    get: function () {
      return this.inputMessageContent_gqg500$_0;
    }
  });
  Object.defineProperty(InlineQueryResultArticle.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_7ctrk6$_0;
    }
  });
  Object.defineProperty(InlineQueryResultArticle.prototype, 'url', {
    get: function () {
      return this.url_1otkil$_0;
    }
  });
  Object.defineProperty(InlineQueryResultArticle.prototype, 'description', {
    get: function () {
      return this.description_c71oog$_0;
    }
  });
  Object.defineProperty(InlineQueryResultArticle.prototype, 'thumbUrl', {
    get: function () {
      return this.thumbUrl_803qsv$_0;
    }
  });
  Object.defineProperty(InlineQueryResultArticle.prototype, 'thumbWidth', {
    get: function () {
      return this.thumbWidth_k8ts6w$_0;
    }
  });
  Object.defineProperty(InlineQueryResultArticle.prototype, 'thumbHeight', {
    get: function () {
      return this.thumbHeight_kkn39t$_0;
    }
  });
  Object.defineProperty(InlineQueryResultArticle.prototype, 'type', {
    get: function () {
      return this.type_io2lma$_0;
    }
  });
  function InlineQueryResultArticle$Companion() {
    InlineQueryResultArticle$Companion_instance = this;
  }
  InlineQueryResultArticle$Companion.prototype.serializer = function () {
    return InlineQueryResultArticle$$serializer_getInstance();
  };
  InlineQueryResultArticle$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var InlineQueryResultArticle$Companion_instance = null;
  function InlineQueryResultArticle$Companion_getInstance() {
    if (InlineQueryResultArticle$Companion_instance === null) {
      new InlineQueryResultArticle$Companion();
    }
    return InlineQueryResultArticle$Companion_instance;
  }
  function InlineQueryResultArticle$$serializer() {
    this.descriptor_b2zx33$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.InlineQueries.InlineQueryResult.InlineQueryResultArticle', this);
    this.descriptor.addElement_ivxn3r$('id', false);
    this.descriptor.addElement_ivxn3r$('title', false);
    this.descriptor.addElement_ivxn3r$('input_message_content', false);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    this.descriptor.addElement_ivxn3r$('url', true);
    this.descriptor.addElement_ivxn3r$('hide_url', true);
    this.descriptor.addElement_ivxn3r$('description', true);
    this.descriptor.addElement_ivxn3r$('thumb_url', true);
    this.descriptor.addElement_ivxn3r$('thumb_width', true);
    this.descriptor.addElement_ivxn3r$('thumb_height', true);
    this.descriptor.addElement_ivxn3r$('type', true);
    InlineQueryResultArticle$$serializer_instance = this;
  }
  Object.defineProperty(InlineQueryResultArticle$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_b2zx33$_0;
    }
  });
  InlineQueryResultArticle$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.id);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.title);
    output.encodeSerializableElement_blecud$(this.descriptor, 2, InputMessageContentSerializer_getInstance(), obj.inputMessageContent);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    if (!equals(obj.url, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.StringSerializer, obj.url);
    if (!equals(obj.hideUrl, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.BooleanSerializer, obj.hideUrl);
    if (!equals(obj.description, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, internal.StringSerializer, obj.description);
    if (!equals(obj.thumbUrl, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, internal.StringSerializer, obj.thumbUrl);
    if (!equals(obj.thumbWidth, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 8, internal.IntSerializer, obj.thumbWidth);
    if (!equals(obj.thumbHeight, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 9))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 9, internal.IntSerializer, obj.thumbHeight);
    if (!equals(obj.type, 'article') || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 10))
      output.encodeStringElement_bgm7zs$(this.descriptor, 10, obj.type);
    output.endStructure_qatsm0$(this.descriptor);
  };
  InlineQueryResultArticle$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9
    , local10;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 2, InputMessageContentSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 2, InputMessageContentSerializer_getInstance(), local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, InlineKeyboardMarkup$$serializer_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.StringSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.BooleanSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.BooleanSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, internal.StringSerializer, local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, internal.StringSerializer, local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = (bitMask0 & 256) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 8, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 8, internal.IntSerializer, local8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = (bitMask0 & 512) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 9, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 9, internal.IntSerializer, local9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case 10:
          local10 = input.decodeStringElement_3zr2iy$(this.descriptor, 10);
          bitMask0 |= 1024;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return InlineQueryResultArticle_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, local10, null);
  };
  InlineQueryResultArticle$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.StringSerializer, InputMessageContentSerializer_getInstance(), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance()), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.BooleanSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(internal.IntSerializer), internal.StringSerializer];
  };
  InlineQueryResultArticle$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var InlineQueryResultArticle$$serializer_instance = null;
  function InlineQueryResultArticle$$serializer_getInstance() {
    if (InlineQueryResultArticle$$serializer_instance === null) {
      new InlineQueryResultArticle$$serializer();
    }
    return InlineQueryResultArticle$$serializer_instance;
  }
  function InlineQueryResultArticle_init(seen1, id, title, inputMessageContent, replyMarkup, url, hideUrl, description, thumbUrl, thumbWidth, thumbHeight, type, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(InlineQueryResultArticle.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('id');
    else
      $this.id_rjsz4d$_0 = id;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('title');
    else
      $this.title_aq25nw$_0 = title;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('input_message_content');
    else
      $this.inputMessageContent_gqg500$_0 = inputMessageContent;
    if ((seen1 & 8) === 0)
      $this.replyMarkup_7ctrk6$_0 = null;
    else
      $this.replyMarkup_7ctrk6$_0 = replyMarkup;
    if ((seen1 & 16) === 0)
      $this.url_1otkil$_0 = null;
    else
      $this.url_1otkil$_0 = url;
    if ((seen1 & 32) === 0)
      $this.hideUrl = null;
    else
      $this.hideUrl = hideUrl;
    if ((seen1 & 64) === 0)
      $this.description_c71oog$_0 = null;
    else
      $this.description_c71oog$_0 = description;
    if ((seen1 & 128) === 0)
      $this.thumbUrl_803qsv$_0 = null;
    else
      $this.thumbUrl_803qsv$_0 = thumbUrl;
    if ((seen1 & 256) === 0)
      $this.thumbWidth_k8ts6w$_0 = null;
    else
      $this.thumbWidth_k8ts6w$_0 = thumbWidth;
    if ((seen1 & 512) === 0)
      $this.thumbHeight_kkn39t$_0 = null;
    else
      $this.thumbHeight_kkn39t$_0 = thumbHeight;
    if ((seen1 & 1024) === 0)
      $this.type_io2lma$_0 = 'article';
    else
      $this.type_io2lma$_0 = type;
    return $this;
  }
  InlineQueryResultArticle.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InlineQueryResultArticle',
    interfaces: [UrlInlineQueryResult, WithInputMessageContentInlineQueryResult, DescribedInlineQueryResult, TitledInlineQueryResult, ThumbSizedInlineQueryResult, InlineQueryResult]
  };
  function InlineQueryResultAudioCachedImpl(id, fileId, caption, parseMode, replyMarkup, inputMessageContent) {
    InlineQueryResultAudioCachedImpl$Companion_getInstance();
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    if (inputMessageContent === void 0)
      inputMessageContent = null;
    this.id_sqzdjl$_0 = id;
    this.fileId_ujnafn$_0 = fileId;
    this.caption_yuvu90$_0 = caption;
    this.parseMode_tu67n0$_0 = parseMode;
    this.replyMarkup_h2pfmw$_0 = replyMarkup;
    this.inputMessageContent_72tlm6$_0 = inputMessageContent;
    this.type_2wx4ds$_0 = inlineQueryResultAudioType;
  }
  Object.defineProperty(InlineQueryResultAudioCachedImpl.prototype, 'id', {
    get: function () {
      return this.id_sqzdjl$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioCachedImpl.prototype, 'fileId', {
    get: function () {
      return this.fileId_ujnafn$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioCachedImpl.prototype, 'caption', {
    get: function () {
      return this.caption_yuvu90$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioCachedImpl.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_tu67n0$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioCachedImpl.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_h2pfmw$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioCachedImpl.prototype, 'inputMessageContent', {
    get: function () {
      return this.inputMessageContent_72tlm6$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioCachedImpl.prototype, 'type', {
    get: function () {
      return this.type_2wx4ds$_0;
    }
  });
  function InlineQueryResultAudioCachedImpl$Companion() {
    InlineQueryResultAudioCachedImpl$Companion_instance = this;
  }
  InlineQueryResultAudioCachedImpl$Companion.prototype.serializer = function () {
    return InlineQueryResultAudioCachedImpl$$serializer_getInstance();
  };
  InlineQueryResultAudioCachedImpl$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var InlineQueryResultAudioCachedImpl$Companion_instance = null;
  function InlineQueryResultAudioCachedImpl$Companion_getInstance() {
    if (InlineQueryResultAudioCachedImpl$Companion_instance === null) {
      new InlineQueryResultAudioCachedImpl$Companion();
    }
    return InlineQueryResultAudioCachedImpl$Companion_instance;
  }
  function InlineQueryResultAudioCachedImpl$$serializer() {
    this.descriptor_650pjx$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.InlineQueries.InlineQueryResult.InlineQueryResultAudioCachedImpl', this);
    this.descriptor.addElement_ivxn3r$('id', false);
    this.descriptor.addElement_ivxn3r$('audio_file_id', false);
    this.descriptor.addElement_ivxn3r$('caption', true);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    this.descriptor.addElement_ivxn3r$('input_message_content', true);
    this.descriptor.addElement_ivxn3r$('type', true);
    InlineQueryResultAudioCachedImpl$$serializer_instance = this;
  }
  Object.defineProperty(InlineQueryResultAudioCachedImpl$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_650pjx$_0;
    }
  });
  InlineQueryResultAudioCachedImpl$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.id);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, InputFileSerializer_getInstance(), obj.fileId);
    if (!equals(obj.caption, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 2))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 2, internal.StringSerializer, obj.caption);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    if (!equals(obj.inputMessageContent, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, InputMessageContentSerializer_getInstance(), obj.inputMessageContent);
    if (!equals(obj.type, inlineQueryResultAudioType) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeStringElement_bgm7zs$(this.descriptor, 6, obj.type);
    output.endStructure_qatsm0$(this.descriptor);
  };
  InlineQueryResultAudioCachedImpl$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, InputFileSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, InputFileSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = (bitMask0 & 4) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 2, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 2, internal.StringSerializer, local2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, ParseModeSerializerObject_getInstance(), local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, InlineKeyboardMarkup$$serializer_getInstance(), local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, InputMessageContentSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, InputMessageContentSerializer_getInstance(), local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = input.decodeStringElement_3zr2iy$(this.descriptor, 6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return InlineQueryResultAudioCachedImpl_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, null);
  };
  InlineQueryResultAudioCachedImpl$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, InputFileSerializer_getInstance(), new NullableSerializer(internal.StringSerializer), new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance()), new NullableSerializer(InputMessageContentSerializer_getInstance()), internal.StringSerializer];
  };
  InlineQueryResultAudioCachedImpl$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var InlineQueryResultAudioCachedImpl$$serializer_instance = null;
  function InlineQueryResultAudioCachedImpl$$serializer_getInstance() {
    if (InlineQueryResultAudioCachedImpl$$serializer_instance === null) {
      new InlineQueryResultAudioCachedImpl$$serializer();
    }
    return InlineQueryResultAudioCachedImpl$$serializer_instance;
  }
  function InlineQueryResultAudioCachedImpl_init(seen1, id, fileId, caption, parseMode, replyMarkup, inputMessageContent, type, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(InlineQueryResultAudioCachedImpl.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('id');
    else
      $this.id_sqzdjl$_0 = id;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('audio_file_id');
    else
      $this.fileId_ujnafn$_0 = fileId;
    if ((seen1 & 4) === 0)
      $this.caption_yuvu90$_0 = null;
    else
      $this.caption_yuvu90$_0 = caption;
    if ((seen1 & 8) === 0)
      $this.parseMode_tu67n0$_0 = null;
    else
      $this.parseMode_tu67n0$_0 = parseMode;
    if ((seen1 & 16) === 0)
      $this.replyMarkup_h2pfmw$_0 = null;
    else
      $this.replyMarkup_h2pfmw$_0 = replyMarkup;
    if ((seen1 & 32) === 0)
      $this.inputMessageContent_72tlm6$_0 = null;
    else
      $this.inputMessageContent_72tlm6$_0 = inputMessageContent;
    if ((seen1 & 64) === 0)
      $this.type_2wx4ds$_0 = inlineQueryResultAudioType;
    else
      $this.type_2wx4ds$_0 = type;
    return $this;
  }
  InlineQueryResultAudioCachedImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InlineQueryResultAudioCachedImpl',
    interfaces: [InlineQueryResultAudioCached]
  };
  InlineQueryResultAudioCachedImpl.prototype.component1 = function () {
    return this.id;
  };
  InlineQueryResultAudioCachedImpl.prototype.component2 = function () {
    return this.fileId;
  };
  InlineQueryResultAudioCachedImpl.prototype.component3 = function () {
    return this.caption;
  };
  InlineQueryResultAudioCachedImpl.prototype.component4 = function () {
    return this.parseMode;
  };
  InlineQueryResultAudioCachedImpl.prototype.component5 = function () {
    return this.replyMarkup;
  };
  InlineQueryResultAudioCachedImpl.prototype.component6 = function () {
    return this.inputMessageContent;
  };
  InlineQueryResultAudioCachedImpl.prototype.copy_yimbxw$ = function (id, fileId, caption, parseMode, replyMarkup, inputMessageContent) {
    return new InlineQueryResultAudioCachedImpl(id === void 0 ? this.id : id, fileId === void 0 ? this.fileId : fileId, caption === void 0 ? this.caption : caption, parseMode === void 0 ? this.parseMode : parseMode, replyMarkup === void 0 ? this.replyMarkup : replyMarkup, inputMessageContent === void 0 ? this.inputMessageContent : inputMessageContent);
  };
  InlineQueryResultAudioCachedImpl.prototype.toString = function () {
    return 'InlineQueryResultAudioCachedImpl(id=' + Kotlin.toString(this.id) + (', fileId=' + Kotlin.toString(this.fileId)) + (', caption=' + Kotlin.toString(this.caption)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + (', inputMessageContent=' + Kotlin.toString(this.inputMessageContent)) + ')';
  };
  InlineQueryResultAudioCachedImpl.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.fileId) | 0;
    result = result * 31 + Kotlin.hashCode(this.caption) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    result = result * 31 + Kotlin.hashCode(this.inputMessageContent) | 0;
    return result;
  };
  InlineQueryResultAudioCachedImpl.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.fileId, other.fileId) && Kotlin.equals(this.caption, other.caption) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.replyMarkup, other.replyMarkup) && Kotlin.equals(this.inputMessageContent, other.inputMessageContent)))));
  };
  function InlineQueryResultAudioImpl(id, url, title, performer, duration, caption, parseMode, replyMarkup, inputMessageContent) {
    InlineQueryResultAudioImpl$Companion_getInstance();
    if (performer === void 0)
      performer = null;
    if (duration === void 0)
      duration = null;
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    if (inputMessageContent === void 0)
      inputMessageContent = null;
    this.id_pkomlp$_0 = id;
    this.url_bh6uf1$_0 = url;
    this.title_jhfwok$_0 = title;
    this.performer_3vi8vy$_0 = performer;
    this.duration_6km9as$_0 = duration;
    this.caption_2jgp2e$_0 = caption;
    this.parseMode_otwg2e$_0 = parseMode;
    this.replyMarkup_rq0tcq$_0 = replyMarkup;
    this.inputMessageContent_nnp8kw$_0 = inputMessageContent;
    this.type_mwpf2$_0 = inlineQueryResultAudioType;
  }
  Object.defineProperty(InlineQueryResultAudioImpl.prototype, 'id', {
    get: function () {
      return this.id_pkomlp$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioImpl.prototype, 'url', {
    get: function () {
      return this.url_bh6uf1$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioImpl.prototype, 'title', {
    get: function () {
      return this.title_jhfwok$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioImpl.prototype, 'performer', {
    get: function () {
      return this.performer_3vi8vy$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioImpl.prototype, 'duration', {
    get: function () {
      return this.duration_6km9as$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioImpl.prototype, 'caption', {
    get: function () {
      return this.caption_2jgp2e$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioImpl.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_otwg2e$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioImpl.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_rq0tcq$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioImpl.prototype, 'inputMessageContent', {
    get: function () {
      return this.inputMessageContent_nnp8kw$_0;
    }
  });
  Object.defineProperty(InlineQueryResultAudioImpl.prototype, 'type', {
    get: function () {
      return this.type_mwpf2$_0;
    }
  });
  function InlineQueryResultAudioImpl$Companion() {
    InlineQueryResultAudioImpl$Companion_instance = this;
  }
  InlineQueryResultAudioImpl$Companion.prototype.serializer = function () {
    return InlineQueryResultAudioImpl$$serializer_getInstance();
  };
  InlineQueryResultAudioImpl$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var InlineQueryResultAudioImpl$Companion_instance = null;
  function InlineQueryResultAudioImpl$Companion_getInstance() {
    if (InlineQueryResultAudioImpl$Companion_instance === null) {
      new InlineQueryResultAudioImpl$Companion();
    }
    return InlineQueryResultAudioImpl$Companion_instance;
  }
  function InlineQueryResultAudioImpl$$serializer() {
    this.descriptor_l91i8v$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.InlineQueries.InlineQueryResult.InlineQueryResultAudioImpl', this);
    this.descriptor.addElement_ivxn3r$('id', false);
    this.descriptor.addElement_ivxn3r$('audio_url', false);
    this.descriptor.addElement_ivxn3r$('title', false);
    this.descriptor.addElement_ivxn3r$('performer', true);
    this.descriptor.addElement_ivxn3r$('audio_duration', true);
    this.descriptor.addElement_ivxn3r$('caption', true);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    this.descriptor.addElement_ivxn3r$('input_message_content', true);
    this.descriptor.addElement_ivxn3r$('type', true);
    InlineQueryResultAudioImpl$$serializer_instance = this;
  }
  Object.defineProperty(InlineQueryResultAudioImpl$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_l91i8v$_0;
    }
  });
  InlineQueryResultAudioImpl$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.id);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.url);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.title);
    if (!equals(obj.performer, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.performer);
    if (!equals(obj.duration, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.IntSerializer, obj.duration);
    if (!equals(obj.caption, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.StringSerializer, obj.caption);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    if (!equals(obj.inputMessageContent, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 8, InputMessageContentSerializer_getInstance(), obj.inputMessageContent);
    if (!equals(obj.type, inlineQueryResultAudioType) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 9))
      output.encodeStringElement_bgm7zs$(this.descriptor, 9, obj.type);
    output.endStructure_qatsm0$(this.descriptor);
  };
  InlineQueryResultAudioImpl$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.IntSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.StringSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, ParseModeSerializerObject_getInstance(), local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, InlineKeyboardMarkup$$serializer_getInstance(), local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = (bitMask0 & 256) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 8, InputMessageContentSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 8, InputMessageContentSerializer_getInstance(), local8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = input.decodeStringElement_3zr2iy$(this.descriptor, 9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return InlineQueryResultAudioImpl_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, null);
  };
  InlineQueryResultAudioImpl$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.StringSerializer, internal.StringSerializer, new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance()), new NullableSerializer(InputMessageContentSerializer_getInstance()), internal.StringSerializer];
  };
  InlineQueryResultAudioImpl$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var InlineQueryResultAudioImpl$$serializer_instance = null;
  function InlineQueryResultAudioImpl$$serializer_getInstance() {
    if (InlineQueryResultAudioImpl$$serializer_instance === null) {
      new InlineQueryResultAudioImpl$$serializer();
    }
    return InlineQueryResultAudioImpl$$serializer_instance;
  }
  function InlineQueryResultAudioImpl_init(seen1, id, url, title, performer, duration, caption, parseMode, replyMarkup, inputMessageContent, type, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(InlineQueryResultAudioImpl.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('id');
    else
      $this.id_pkomlp$_0 = id;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('audio_url');
    else
      $this.url_bh6uf1$_0 = url;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('title');
    else
      $this.title_jhfwok$_0 = title;
    if ((seen1 & 8) === 0)
      $this.performer_3vi8vy$_0 = null;
    else
      $this.performer_3vi8vy$_0 = performer;
    if ((seen1 & 16) === 0)
      $this.duration_6km9as$_0 = null;
    else
      $this.duration_6km9as$_0 = duration;
    if ((seen1 & 32) === 0)
      $this.caption_2jgp2e$_0 = null;
    else
      $this.caption_2jgp2e$_0 = caption;
    if ((seen1 & 64) === 0)
      $this.parseMode_otwg2e$_0 = null;
    else
      $this.parseMode_otwg2e$_0 = parseMode;
    if ((seen1 & 128) === 0)
      $this.replyMarkup_rq0tcq$_0 = null;
    else
      $this.replyMarkup_rq0tcq$_0 = replyMarkup;
    if ((seen1 & 256) === 0)
      $this.inputMessageContent_nnp8kw$_0 = null;
    else
      $this.inputMessageContent_nnp8kw$_0 = inputMessageContent;
    if ((seen1 & 512) === 0)
      $this.type_mwpf2$_0 = inlineQueryResultAudioType;
    else
      $this.type_mwpf2$_0 = type;
    return $this;
  }
  InlineQueryResultAudioImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InlineQueryResultAudioImpl',
    interfaces: [InlineQueryResultAudio]
  };
  InlineQueryResultAudioImpl.prototype.component1 = function () {
    return this.id;
  };
  InlineQueryResultAudioImpl.prototype.component2 = function () {
    return this.url;
  };
  InlineQueryResultAudioImpl.prototype.component3 = function () {
    return this.title;
  };
  InlineQueryResultAudioImpl.prototype.component4 = function () {
    return this.performer;
  };
  InlineQueryResultAudioImpl.prototype.component5 = function () {
    return this.duration;
  };
  InlineQueryResultAudioImpl.prototype.component6 = function () {
    return this.caption;
  };
  InlineQueryResultAudioImpl.prototype.component7 = function () {
    return this.parseMode;
  };
  InlineQueryResultAudioImpl.prototype.component8 = function () {
    return this.replyMarkup;
  };
  InlineQueryResultAudioImpl.prototype.component9 = function () {
    return this.inputMessageContent;
  };
  InlineQueryResultAudioImpl.prototype.copy_sijj06$ = function (id, url, title, performer, duration, caption, parseMode, replyMarkup, inputMessageContent) {
    return new InlineQueryResultAudioImpl(id === void 0 ? this.id : id, url === void 0 ? this.url : url, title === void 0 ? this.title : title, performer === void 0 ? this.performer : performer, duration === void 0 ? this.duration : duration, caption === void 0 ? this.caption : caption, parseMode === void 0 ? this.parseMode : parseMode, replyMarkup === void 0 ? this.replyMarkup : replyMarkup, inputMessageContent === void 0 ? this.inputMessageContent : inputMessageContent);
  };
  InlineQueryResultAudioImpl.prototype.toString = function () {
    return 'InlineQueryResultAudioImpl(id=' + Kotlin.toString(this.id) + (', url=' + Kotlin.toString(this.url)) + (', title=' + Kotlin.toString(this.title)) + (', performer=' + Kotlin.toString(this.performer)) + (', duration=' + Kotlin.toString(this.duration)) + (', caption=' + Kotlin.toString(this.caption)) + (', parseMode=' + Kotlin.toString(this.parseMode)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + (', inputMessageContent=' + Kotlin.toString(this.inputMessageContent)) + ')';
  };
  InlineQueryResultAudioImpl.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.url) | 0;
    result = result * 31 + Kotlin.hashCode(this.title) | 0;
    result = result * 31 + Kotlin.hashCode(this.performer) | 0;
    result = result * 31 + Kotlin.hashCode(this.duration) | 0;
    result = result * 31 + Kotlin.hashCode(this.caption) | 0;
    result = result * 31 + Kotlin.hashCode(this.parseMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    result = result * 31 + Kotlin.hashCode(this.inputMessageContent) | 0;
    return result;
  };
  InlineQueryResultAudioImpl.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.url, other.url) && Kotlin.equals(this.title, other.title) && Kotlin.equals(this.performer, other.performer) && Kotlin.equals(this.duration, other.duration) && Kotlin.equals(this.caption, other.caption) && Kotlin.equals(this.parseMode, other.parseMode) && Kotlin.equals(this.replyMarkup, other.replyMarkup) && Kotlin.equals(this.inputMessageContent, other.inputMessageContent)))));
  };
  function InlineQueryResultContact(id, phoneNumber, firstName, lastName, vcard, thumbUrl, thumbWidth, thumbHeight, replyMarkup, inputMessageContent) {
    InlineQueryResultContact$Companion_getInstance();
    if (lastName === void 0)
      lastName = null;
    if (vcard === void 0)
      vcard = null;
    if (thumbUrl === void 0)
      thumbUrl = null;
    if (thumbWidth === void 0)
      thumbWidth = null;
    if (thumbHeight === void 0)
      thumbHeight = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    if (inputMessageContent === void 0)
      inputMessageContent = null;
    this.id_eoztvb$_0 = id;
    this.phoneNumber_tu6f1x$_0 = phoneNumber;
    this.firstName_mnr7wn$_0 = firstName;
    this.lastName_vk7tzl$_0 = lastName;
    this.vcard_ypddo$_0 = vcard;
    this.thumbUrl_kiyiop$_0 = thumbUrl;
    this.thumbWidth_jot6u6$_0 = thumbWidth;
    this.thumbHeight_k0lqdh$_0 = thumbHeight;
    this.replyMarkup_x8f234$_0 = replyMarkup;
    this.inputMessageContent_rhgig6$_0 = inputMessageContent;
    this.type_dqi8nc$_0 = 'contact';
  }
  Object.defineProperty(InlineQueryResultContact.prototype, 'id', {
    get: function () {
      return this.id_eoztvb$_0;
    }
  });
  Object.defineProperty(InlineQueryResultContact.prototype, 'phoneNumber', {
    get: function () {
      return this.phoneNumber_tu6f1x$_0;
    }
  });
  Object.defineProperty(InlineQueryResultContact.prototype, 'firstName', {
    get: function () {
      return this.firstName_mnr7wn$_0;
    }
  });
  Object.defineProperty(InlineQueryResultContact.prototype, 'lastName', {
    get: function () {
      return this.lastName_vk7tzl$_0;
    }
  });
  Object.defineProperty(InlineQueryResultContact.prototype, 'vcard', {
    get: function () {
      return this.vcard_ypddo$_0;
    }
  });
  Object.defineProperty(InlineQueryResultContact.prototype, 'thumbUrl', {
    get: function () {
      return this.thumbUrl_kiyiop$_0;
    }
  });
  Object.defineProperty(InlineQueryResultContact.prototype, 'thumbWidth', {
    get: function () {
      return this.thumbWidth_jot6u6$_0;
    }
  });
  Object.defineProperty(InlineQueryResultContact.prototype, 'thumbHeight', {
    get: function () {
      return this.thumbHeight_k0lqdh$_0;
    }
  });
  Object.defineProperty(InlineQueryResultContact.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_x8f234$_0;
    }
  });
  Object.defineProperty(InlineQueryResultContact.prototype, 'inputMessageContent', {
    get: function () {
      return this.inputMessageContent_rhgig6$_0;
    }
  });
  Object.defineProperty(InlineQueryResultContact.prototype, 'type', {
    get: function () {
      return this.type_dqi8nc$_0;
    }
  });
  function InlineQueryResultContact$Companion() {
    InlineQueryResultContact$Companion_instance = this;
  }
  InlineQueryResultContact$Companion.prototype.serializer = function () {
    return InlineQueryResultContact$$serializer_getInstance();
  };
  InlineQueryResultContact$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var InlineQueryResultContact$Companion_instance = null;
  function InlineQueryResultContact$Companion_getInstance() {
    if (InlineQueryResultContact$Companion_instance === null) {
      new InlineQueryResultContact$Companion();
    }
    return InlineQueryResultContact$Companion_instance;
  }
  function InlineQueryResultContact$$serializer() {
    this.descriptor_rlpudx$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.InlineQueries.InlineQueryResult.InlineQueryResultContact', this);
    this.descriptor.addElement_ivxn3r$('id', false);
    this.descriptor.addElement_ivxn3r$('phone_number', false);
    this.descriptor.addElement_ivxn3r$('first_name', false);
    this.descriptor.addElement_ivxn3r$('last_name', true);
    this.descriptor.addElement_ivxn3r$('vcard', true);
    this.descriptor.addElement_ivxn3r$('thumb_url', true);
    this.descriptor.addElement_ivxn3r$('thumb_width', true);
    this.descriptor.addElement_ivxn3r$('thumb_height', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    this.descriptor.addElement_ivxn3r$('input_message_content', true);
    this.descriptor.addElement_ivxn3r$('type', true);
    InlineQueryResultContact$$serializer_instance = this;
  }
  Object.defineProperty(InlineQueryResultContact$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_rlpudx$_0;
    }
  });
  InlineQueryResultContact$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.id);
    output.encodeStringElement_bgm7zs$(this.descriptor, 1, obj.phoneNumber);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.firstName);
    if (!equals(obj.lastName, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.lastName);
    if (!equals(obj.vcard, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.StringSerializer, obj.vcard);
    if (!equals(obj.thumbUrl, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, internal.StringSerializer, obj.thumbUrl);
    if (!equals(obj.thumbWidth, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, internal.IntSerializer, obj.thumbWidth);
    if (!equals(obj.thumbHeight, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, internal.IntSerializer, obj.thumbHeight);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 8, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    if (!equals(obj.inputMessageContent, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 9))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 9, InputMessageContentSerializer_getInstance(), obj.inputMessageContent);
    if (!equals(obj.type, 'contact') || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 10))
      output.encodeStringElement_bgm7zs$(this.descriptor, 10, obj.type);
    output.endStructure_qatsm0$(this.descriptor);
  };
  InlineQueryResultContact$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8
    , local9
    , local10;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = input.decodeStringElement_3zr2iy$(this.descriptor, 1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.StringSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, internal.StringSerializer, local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, internal.IntSerializer, local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, internal.IntSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, internal.IntSerializer, local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = (bitMask0 & 256) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 8, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 8, InlineKeyboardMarkup$$serializer_getInstance(), local8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case 9:
          local9 = (bitMask0 & 512) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 9, InputMessageContentSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 9, InputMessageContentSerializer_getInstance(), local9);
          bitMask0 |= 512;
          if (!readAll)
            break;
        case 10:
          local10 = input.decodeStringElement_3zr2iy$(this.descriptor, 10);
          bitMask0 |= 1024;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return InlineQueryResultContact_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, local9, local10, null);
  };
  InlineQueryResultContact$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, internal.StringSerializer, internal.StringSerializer, new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(internal.IntSerializer), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance()), new NullableSerializer(InputMessageContentSerializer_getInstance()), internal.StringSerializer];
  };
  InlineQueryResultContact$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var InlineQueryResultContact$$serializer_instance = null;
  function InlineQueryResultContact$$serializer_getInstance() {
    if (InlineQueryResultContact$$serializer_instance === null) {
      new InlineQueryResultContact$$serializer();
    }
    return InlineQueryResultContact$$serializer_instance;
  }
  function InlineQueryResultContact_init(seen1, id, phoneNumber, firstName, lastName, vcard, thumbUrl, thumbWidth, thumbHeight, replyMarkup, inputMessageContent, type, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(InlineQueryResultContact.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('id');
    else
      $this.id_eoztvb$_0 = id;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('phone_number');
    else
      $this.phoneNumber_tu6f1x$_0 = phoneNumber;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('first_name');
    else
      $this.firstName_mnr7wn$_0 = firstName;
    if ((seen1 & 8) === 0)
      $this.lastName_vk7tzl$_0 = null;
    else
      $this.lastName_vk7tzl$_0 = lastName;
    if ((seen1 & 16) === 0)
      $this.vcard_ypddo$_0 = null;
    else
      $this.vcard_ypddo$_0 = vcard;
    if ((seen1 & 32) === 0)
      $this.thumbUrl_kiyiop$_0 = null;
    else
      $this.thumbUrl_kiyiop$_0 = thumbUrl;
    if ((seen1 & 64) === 0)
      $this.thumbWidth_jot6u6$_0 = null;
    else
      $this.thumbWidth_jot6u6$_0 = thumbWidth;
    if ((seen1 & 128) === 0)
      $this.thumbHeight_k0lqdh$_0 = null;
    else
      $this.thumbHeight_k0lqdh$_0 = thumbHeight;
    if ((seen1 & 256) === 0)
      $this.replyMarkup_x8f234$_0 = null;
    else
      $this.replyMarkup_x8f234$_0 = replyMarkup;
    if ((seen1 & 512) === 0)
      $this.inputMessageContent_rhgig6$_0 = null;
    else
      $this.inputMessageContent_rhgig6$_0 = inputMessageContent;
    if ((seen1 & 1024) === 0)
      $this.type_dqi8nc$_0 = 'contact';
    else
      $this.type_dqi8nc$_0 = type;
    return $this;
  }
  InlineQueryResultContact.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InlineQueryResultContact',
    interfaces: [ThumbSizedInlineQueryResult, ThumbedInlineQueryResult, WithInputMessageContentInlineQueryResult, CommonContactData, InlineQueryResult]
  };
  InlineQueryResultContact.prototype.component1 = function () {
    return this.id;
  };
  InlineQueryResultContact.prototype.component2 = function () {
    return this.phoneNumber;
  };
  InlineQueryResultContact.prototype.component3 = function () {
    return this.firstName;
  };
  InlineQueryResultContact.prototype.component4 = function () {
    return this.lastName;
  };
  InlineQueryResultContact.prototype.component5 = function () {
    return this.vcard;
  };
  InlineQueryResultContact.prototype.component6 = function () {
    return this.thumbUrl;
  };
  InlineQueryResultContact.prototype.component7 = function () {
    return this.thumbWidth;
  };
  InlineQueryResultContact.prototype.component8 = function () {
    return this.thumbHeight;
  };
  InlineQueryResultContact.prototype.component9 = function () {
    return this.replyMarkup;
  };
  InlineQueryResultContact.prototype.component10 = function () {
    return this.inputMessageContent;
  };
  InlineQueryResultContact.prototype.copy_nb38ta$ = function (id, phoneNumber, firstName, lastName, vcard, thumbUrl, thumbWidth, thumbHeight, replyMarkup, inputMessageContent) {
    return new InlineQueryResultContact(id === void 0 ? this.id : id, phoneNumber === void 0 ? this.phoneNumber : phoneNumber, firstName === void 0 ? this.firstName : firstName, lastName === void 0 ? this.lastName : lastName, vcard === void 0 ? this.vcard : vcard, thumbUrl === void 0 ? this.thumbUrl : thumbUrl, thumbWidth === void 0 ? this.thumbWidth : thumbWidth, thumbHeight === void 0 ? this.thumbHeight : thumbHeight, replyMarkup === void 0 ? this.replyMarkup : replyMarkup, inputMessageContent === void 0 ? this.inputMessageContent : inputMessageContent);
  };
  InlineQueryResultContact.prototype.toString = function () {
    return 'InlineQueryResultContact(id=' + Kotlin.toString(this.id) + (', phoneNumber=' + Kotlin.toString(this.phoneNumber)) + (', firstName=' + Kotlin.toString(this.firstName)) + (', lastName=' + Kotlin.toString(this.lastName)) + (', vcard=' + Kotlin.toString(this.vcard)) + (', thumbUrl=' + Kotlin.toString(this.thumbUrl)) + (', thumbWidth=' + Kotlin.toString(this.thumbWidth)) + (', thumbHeight=' + Kotlin.toString(this.thumbHeight)) + (', replyMarkup=' + Kotlin.toString(this.replyMarkup)) + (', inputMessageContent=' + Kotlin.toString(this.inputMessageContent)) + ')';
  };
  InlineQueryResultContact.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.id) | 0;
    result = result * 31 + Kotlin.hashCode(this.phoneNumber) | 0;
    result = result * 31 + Kotlin.hashCode(this.firstName) | 0;
    result = result * 31 + Kotlin.hashCode(this.lastName) | 0;
    result = result * 31 + Kotlin.hashCode(this.vcard) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumbUrl) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumbWidth) | 0;
    result = result * 31 + Kotlin.hashCode(this.thumbHeight) | 0;
    result = result * 31 + Kotlin.hashCode(this.replyMarkup) | 0;
    result = result * 31 + Kotlin.hashCode(this.inputMessageContent) | 0;
    return result;
  };
  InlineQueryResultContact.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.id, other.id) && Kotlin.equals(this.phoneNumber, other.phoneNumber) && Kotlin.equals(this.firstName, other.firstName) && Kotlin.equals(this.lastName, other.lastName) && Kotlin.equals(this.vcard, other.vcard) && Kotlin.equals(this.thumbUrl, other.thumbUrl) && Kotlin.equals(this.thumbWidth, other.thumbWidth) && Kotlin.equals(this.thumbHeight, other.thumbHeight) && Kotlin.equals(this.replyMarkup, other.replyMarkup) && Kotlin.equals(this.inputMessageContent, other.inputMessageContent)))));
  };
  function InlineQueryResultDocumentCachedImpl(id, fileId, title, description, caption, parseMode, replyMarkup, inputMessageContent) {
    InlineQueryResultDocumentCachedImpl$Companion_getInstance();
    if (description === void 0)
      description = null;
    if (caption === void 0)
      caption = null;
    if (parseMode === void 0)
      parseMode = null;
    if (replyMarkup === void 0)
      replyMarkup = null;
    if (inputMessageContent === void 0)
      inputMessageContent = null;
    this.id_jzjr4o$_0 = id;
    this.fileId_b2941g$_0 = fileId;
    this.title_auwlax$_0 = title;
    this.description_fho41h$_0 = description;
    this.caption_nk0d3f$_0 = caption;
    this.parseMode_ne6rgl$_0 = parseMode;
    this.replyMarkup_427c75$_0 = replyMarkup;
    this.inputMessageContent_scatg5$_0 = inputMessageContent;
    this.type_tfg2hj$_0 = inlineQueryResultDocumentType;
  }
  Object.defineProperty(InlineQueryResultDocumentCachedImpl.prototype, 'id', {
    get: function () {
      return this.id_jzjr4o$_0;
    }
  });
  Object.defineProperty(InlineQueryResultDocumentCachedImpl.prototype, 'fileId', {
    get: function () {
      return this.fileId_b2941g$_0;
    }
  });
  Object.defineProperty(InlineQueryResultDocumentCachedImpl.prototype, 'title', {
    get: function () {
      return this.title_auwlax$_0;
    }
  });
  Object.defineProperty(InlineQueryResultDocumentCachedImpl.prototype, 'description', {
    get: function () {
      return this.description_fho41h$_0;
    }
  });
  Object.defineProperty(InlineQueryResultDocumentCachedImpl.prototype, 'caption', {
    get: function () {
      return this.caption_nk0d3f$_0;
    }
  });
  Object.defineProperty(InlineQueryResultDocumentCachedImpl.prototype, 'parseMode', {
    get: function () {
      return this.parseMode_ne6rgl$_0;
    }
  });
  Object.defineProperty(InlineQueryResultDocumentCachedImpl.prototype, 'replyMarkup', {
    get: function () {
      return this.replyMarkup_427c75$_0;
    }
  });
  Object.defineProperty(InlineQueryResultDocumentCachedImpl.prototype, 'inputMessageContent', {
    get: function () {
      return this.inputMessageContent_scatg5$_0;
    }
  });
  Object.defineProperty(InlineQueryResultDocumentCachedImpl.prototype, 'type', {
    get: function () {
      return this.type_tfg2hj$_0;
    }
  });
  function InlineQueryResultDocumentCachedImpl$Companion() {
    InlineQueryResultDocumentCachedImpl$Companion_instance = this;
  }
  InlineQueryResultDocumentCachedImpl$Companion.prototype.serializer = function () {
    return InlineQueryResultDocumentCachedImpl$$serializer_getInstance();
  };
  InlineQueryResultDocumentCachedImpl$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var InlineQueryResultDocumentCachedImpl$Companion_instance = null;
  function InlineQueryResultDocumentCachedImpl$Companion_getInstance() {
    if (InlineQueryResultDocumentCachedImpl$Companion_instance === null) {
      new InlineQueryResultDocumentCachedImpl$Companion();
    }
    return InlineQueryResultDocumentCachedImpl$Companion_instance;
  }
  function InlineQueryResultDocumentCachedImpl$$serializer() {
    this.descriptor_58hdic$_0 = new SerialClassDescImpl('com.github.insanusmokrassar.TelegramBotAPI.types.InlineQueries.InlineQueryResult.InlineQueryResultDocumentCachedImpl', this);
    this.descriptor.addElement_ivxn3r$('id', false);
    this.descriptor.addElement_ivxn3r$('document_file_id', false);
    this.descriptor.addElement_ivxn3r$('title', false);
    this.descriptor.addElement_ivxn3r$('description', true);
    this.descriptor.addElement_ivxn3r$('caption', true);
    this.descriptor.addElement_ivxn3r$('parse_mode', true);
    this.descriptor.addElement_ivxn3r$('reply_markup', true);
    this.descriptor.addElement_ivxn3r$('input_message_content', true);
    this.descriptor.addElement_ivxn3r$('type', true);
    InlineQueryResultDocumentCachedImpl$$serializer_instance = this;
  }
  Object.defineProperty(InlineQueryResultDocumentCachedImpl$$serializer.prototype, 'descriptor', {
    get: function () {
      return this.descriptor_58hdic$_0;
    }
  });
  InlineQueryResultDocumentCachedImpl$$serializer.prototype.serialize_awe97i$ = function (encoder, obj) {
    var output = encoder.beginStructure_r0sa6z$(this.descriptor, []);
    output.encodeStringElement_bgm7zs$(this.descriptor, 0, obj.id);
    output.encodeSerializableElement_blecud$(this.descriptor, 1, InputFileSerializer_getInstance(), obj.fileId);
    output.encodeStringElement_bgm7zs$(this.descriptor, 2, obj.title);
    if (!equals(obj.description, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 3))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 3, internal.StringSerializer, obj.description);
    if (!equals(obj.caption, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 4))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 4, internal.StringSerializer, obj.caption);
    if (!equals(obj.parseMode, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 5))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 5, ParseModeSerializerObject_getInstance(), obj.parseMode);
    if (!equals(obj.replyMarkup, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 6))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 6, InlineKeyboardMarkup$$serializer_getInstance(), obj.replyMarkup);
    if (!equals(obj.inputMessageContent, null) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 7))
      output.encodeNullableSerializableElement_orpvvi$(this.descriptor, 7, InputMessageContentSerializer_getInstance(), obj.inputMessageContent);
    if (!equals(obj.type, inlineQueryResultDocumentType) || output.shouldEncodeElementDefault_3zr2iy$(this.descriptor, 8))
      output.encodeStringElement_bgm7zs$(this.descriptor, 8, obj.type);
    output.endStructure_qatsm0$(this.descriptor);
  };
  InlineQueryResultDocumentCachedImpl$$serializer.prototype.deserialize_nts5qn$ = function (decoder) {
    var index, readAll = false;
    var bitMask0 = 0;
    var local0
    , local1
    , local2
    , local3
    , local4
    , local5
    , local6
    , local7
    , local8;
    var input = decoder.beginStructure_r0sa6z$(this.descriptor, []);
    loopLabel: while (true) {
      index = input.decodeElementIndex_qatsm0$(this.descriptor);
      switch (index) {
        case -2:
          readAll = true;
        case 0:
          local0 = input.decodeStringElement_3zr2iy$(this.descriptor, 0);
          bitMask0 |= 1;
          if (!readAll)
            break;
        case 1:
          local1 = (bitMask0 & 2) === 0 ? input.decodeSerializableElement_s44l7r$(this.descriptor, 1, InputFileSerializer_getInstance()) : input.updateSerializableElement_ehubvl$(this.descriptor, 1, InputFileSerializer_getInstance(), local1);
          bitMask0 |= 2;
          if (!readAll)
            break;
        case 2:
          local2 = input.decodeStringElement_3zr2iy$(this.descriptor, 2);
          bitMask0 |= 4;
          if (!readAll)
            break;
        case 3:
          local3 = (bitMask0 & 8) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 3, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 3, internal.StringSerializer, local3);
          bitMask0 |= 8;
          if (!readAll)
            break;
        case 4:
          local4 = (bitMask0 & 16) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 4, internal.StringSerializer) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 4, internal.StringSerializer, local4);
          bitMask0 |= 16;
          if (!readAll)
            break;
        case 5:
          local5 = (bitMask0 & 32) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 5, ParseModeSerializerObject_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 5, ParseModeSerializerObject_getInstance(), local5);
          bitMask0 |= 32;
          if (!readAll)
            break;
        case 6:
          local6 = (bitMask0 & 64) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 6, InlineKeyboardMarkup$$serializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 6, InlineKeyboardMarkup$$serializer_getInstance(), local6);
          bitMask0 |= 64;
          if (!readAll)
            break;
        case 7:
          local7 = (bitMask0 & 128) === 0 ? input.decodeNullableSerializableElement_cwlm4k$(this.descriptor, 7, InputMessageContentSerializer_getInstance()) : input.updateNullableSerializableElement_u33s02$(this.descriptor, 7, InputMessageContentSerializer_getInstance(), local7);
          bitMask0 |= 128;
          if (!readAll)
            break;
        case 8:
          local8 = input.decodeStringElement_3zr2iy$(this.descriptor, 8);
          bitMask0 |= 256;
          if (!readAll)
            break;
        case -1:
          break loopLabel;
        default:throw new UnknownFieldException(index);
      }
    }
    input.endStructure_qatsm0$(this.descriptor);
    return InlineQueryResultDocumentCachedImpl_init(bitMask0, local0, local1, local2, local3, local4, local5, local6, local7, local8, null);
  };
  InlineQueryResultDocumentCachedImpl$$serializer.prototype.childSerializers = function () {
    return [internal.StringSerializer, InputFileSerializer_getInstance(), internal.StringSerializer, new NullableSerializer(internal.StringSerializer), new NullableSerializer(internal.StringSerializer), new NullableSerializer(ParseModeSerializerObject_getInstance()), new NullableSerializer(InlineKeyboardMarkup$$serializer_getInstance()), new NullableSerializer(InputMessageContentSerializer_getInstance()), internal.StringSerializer];
  };
  InlineQueryResultDocumentCachedImpl$$serializer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: '$serializer',
    interfaces: [GeneratedSerializer]
  };
  var InlineQueryResultDocumentCachedImpl$$serializer_instance = null;
  function InlineQueryResultDocumentCachedImpl$$serializer_getInstance() {
    if (InlineQueryResultDocumentCachedImpl$$serializer_instance === null) {
      new InlineQueryResultDocumentCachedImpl$$serializer();
    }
    return InlineQueryResultDocumentCachedImpl$$serializer_instance;
  }
  function InlineQueryResultDocumentCachedImpl_init(seen1, id, fileId, title, description, caption, parseMode, replyMarkup, inputMessageContent, type, serializationConstructorMarker) {
    var $this = serializationConstructorMarker || Object.create(InlineQueryResultDocumentCachedImpl.prototype);
    if ((seen1 & 1) === 0)
      throw new MissingFieldException('id');
    else
      $this.id_jzjr4o$_0 = id;
    if ((seen1 & 2) === 0)
      throw new MissingFieldException('document_file_id');
    else
      $this.fileId_b2941g$_0 = fileId;
    if ((seen1 & 4) === 0)
      throw new MissingFieldException('title');
    else
      $this.title_auwlax$_0 = title;
    if ((seen1 & 8) === 0)
      $this.description_fho41h$_0 = null;
    else
      $this.description_fho41h$_0 = description;
    if ((seen1 & 16) === 0)
      $this.caption_nk0d3f$_0 = null;
    else
      $this.caption_nk0d3f$_0 = caption;
    if ((seen1 & 32) === 0)
      $this.parseMode_ne6rgl$_0 = null;
    else
      $this.parseMode_ne6rgl$_0 = parseMode;
    if ((seen1 & 64) === 0)
      $this.replyMarkup_427c75$_0 = null;
    else
      $this.replyMarkup_427c75$_0 = replyMarkup;
    if ((seen1 & 128) === 0)
      $this.inputMessageContent_scatg5$_0 = null;
    else
      $this.inputMessageContent_scatg5$_0 = inputMessageContent;
    if ((seen1 & 256) === 0)
      $this.type_tfg2hj$_0 = inlineQueryResultDocumentType;
    else
      $this.type_tfg2hj$_0 = type;
    return $this;
  }
  InlineQueryResultDocumentCachedImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'InlineQueryResultDocumentCachedImpl',
    interfaces: [InlineQueryResultDocumentCached]
  };
  InlineQueryResultDocumentCachedImpl.prototype.component1 = function () {
    return this.id;
  };
  InlineQueryResultDocumentCachedImpl.prototype.component2 = function () {
    return this.fileId;
  };
  InlineQueryResultDocumentCachedImpl.prototype.co