/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.vendors.SQLiteDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.SQLiteFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J:\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u00152\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0018\u001a\u00020\u00042\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "supportsMultipleGeneratedKeys", "", "getSupportsMultipleGeneratedKeys", "()Z", "createIndex", "", "index", "Lorg/jetbrains/exposed/sql/Index;", "delete", "ignore", "table", "Lorg/jetbrains/exposed/sql/Table;", "where", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "getDatabase", "insert", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "expr", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "Companion", "exposed"})
public final class SQLiteDialect
extends VendorDialect {
    private final boolean supportsMultipleGeneratedKeys = false;
    @NotNull
    public static final String dialectName = "sqlite";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        return true;
    }

    @Override
    @NotNull
    public String getDatabase() {
        return "";
    }

    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(columns2, "columns");
        Intrinsics.checkParameterIsNotNull(expr, "expr");
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        String def = super.insert(false, table, columns2, expr, transaction);
        return ignore ? StringsKt.replaceFirst$default(def, "INSERT", "INSERT OR IGNORE", false, 4, null) : def;
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Table table, @Nullable String where, @NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        String def = super.delete(false, table, where, transaction);
        return ignore ? StringsKt.replaceFirst$default(def, "DELETE", "DELETE OR IGNORE", false, 4, null) : def;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkParameterIsNotNull(index, "index");
        String originalCreateIndex = super.createIndex(Index.copy$default(index, null, null, null, false, 7, null));
        return index.getUnique() ? StringsKt.replace$default(originalCreateIndex, "INDEX", "UNIQUE INDEX", false, 4, null) : originalCreateIndex;
    }

    public SQLiteDialect() {
        super(dialectName, SQLiteDataTypeProvider.INSTANCE, SQLiteFunctionProvider.INSTANCE);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLiteDialect$Companion;", "", "()V", "dialectName", "", "exposed"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

