/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.vendors.SQLServerDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.SQLServerFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0014\u0010\u0016\u001a\u00020\u00112\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "supportsIfNotExists", "getSupportsIfNotExists", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "limit", "", "size", "", "offset", "alreadyOrdered", "modifyColumn", "column", "Lorg/jetbrains/exposed/sql/Column;", "Companion", "exposed"})
public final class SQLServerDialect
extends VendorDialect {
    private final boolean supportsIfNotExists = false;
    private final boolean needsQuotesWhenSymbolsInNames = false;
    @NotNull
    public static final String dialectName = "sqlserver";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return ReferenceOption.NO_ACTION;
    }

    @Override
    @NotNull
    public String limit(int size, int offset, boolean alreadyOrdered) {
        return (!alreadyOrdered ? " ORDER BY(SELECT NULL) " : "") + " OFFSET " + offset + " ROWS FETCH NEXT " + size + " ROWS ONLY";
    }

    @Override
    @NotNull
    public String modifyColumn(@NotNull Column<?> column) {
        Intrinsics.checkParameterIsNotNull(column, "column");
        return StringsKt.replace$default(super.modifyColumn(column), "MODIFY COLUMN", "ALTER COLUMN", false, 4, null);
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        return true;
    }

    public SQLServerDialect() {
        super(dialectName, SQLServerDataTypeProvider.INSTANCE, SQLServerFunctionProvider.INSTANCE);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDialect$Companion;", "", "()V", "dialectName", "", "exposed"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

