/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.OracleDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.OracleFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J:\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u00162\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\"\u001a\u00020\f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0016J \u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\fH\u0016J\u0014\u0010)\u001a\u00020\u00172\n\u0010*\u001a\u0006\u0012\u0002\b\u00030 H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006,"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "identifierLengthLimit", "", "getIdentifierLengthLimit", "()I", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "supportsIfNotExists", "getSupportsIfNotExists", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "allTablesNames", "", "", "catalog", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "insert", "ignore", "table", "Lorg/jetbrains/exposed/sql/Table;", "columns", "Lorg/jetbrains/exposed/sql/Column;", "expr", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "limit", "size", "offset", "alreadyOrdered", "modifyColumn", "column", "Companion", "exposed"})
public final class OracleDialect
extends VendorDialect {
    private final boolean supportsMultipleGeneratedKeys = false;
    private final boolean supportsIfNotExists = false;
    private final boolean needsSequenceToAutoInc = true;
    private final boolean needsQuotesWhenSymbolsInNames = false;
    private final int identifierLengthLimit = 30;
    @NotNull
    public static final String dialectName = "oracle";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return this.needsSequenceToAutoInc;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public int getIdentifierLengthLimit() {
        return this.identifierLengthLimit;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return ReferenceOption.NO_ACTION;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        return true;
    }

    @Override
    @NotNull
    public String catalog(@NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        DatabaseMetaData databaseMetaData = transaction.getConnection().getMetaData();
        Intrinsics.checkExpressionValueIsNotNull(databaseMetaData, "transaction.connection.metaData");
        String string = databaseMetaData.getUserName();
        Intrinsics.checkExpressionValueIsNotNull(string, "transaction.connection.metaData.userName");
        return string;
    }

    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction) {
        Column<?> column;
        block8: {
            block7: {
                String string;
                Column<?> column2;
                Column<?> it;
                Intrinsics.checkParameterIsNotNull(table, "table");
                Intrinsics.checkParameterIsNotNull(columns2, "columns");
                Intrinsics.checkParameterIsNotNull(expr, "expr");
                Intrinsics.checkParameterIsNotNull(transaction, "transaction");
                column = table.getAutoIncColumn();
                if (column == null || (column = !columns2.contains(it = (column2 = column)) ? column2 : null) == null) break block7;
                it = column2 = column;
                if (StringsKt.isBlank(expr)) {
                    StringBuilder stringBuilder = new StringBuilder().append("VALUES (");
                    String string2 = ColumnTypeKt.getAutoIncSeqName(it);
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    string = stringBuilder.append(string2).append(".NEXTVAL)").toString();
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("VALUES (");
                    String string3 = ColumnTypeKt.getAutoIncSeqName(it);
                    if (string3 == null) {
                        Intrinsics.throwNpe();
                    }
                    string = StringsKt.replace$default(expr, "VALUES (", stringBuilder.append(string3).append(".NEXTVAL, ").toString(), false, 4, null);
                }
                String newExpr = string;
                String string4 = super.insert(ignore, table, CollectionsKt.plus((Collection)CollectionsKt.listOf(it), (Iterable)columns2), newExpr, transaction);
                column = string4;
                if (string4 != null) break block8;
            }
            column = super.insert(ignore, table, columns2, expr, transaction);
        }
        return column;
    }

    @Override
    @NotNull
    public String limit(int size, int offset, boolean alreadyOrdered) {
        return (offset > 0 ? " OFFSET " + offset + " ROWS" : "") + " FETCH FIRST " + size + " ROWS ONLY";
    }

    @Override
    @NotNull
    public List<String> allTablesNames() {
        ArrayList<String> result2 = new ArrayList<String>();
        Transaction tr = TransactionManager.Companion.current();
        ResultSet resultSet = tr.getDb().getMetadata$exposed().getTables(null, this.getDatabase(), null, new String[]{"TABLE"});
        while (resultSet.next()) {
            String string = resultSet.getString("TABLE_NAME");
            Intrinsics.checkExpressionValueIsNotNull(string, "resultSet.getString(\"TABLE_NAME\")");
            result2.add(this.getInProperCase(string));
        }
        resultSet.close();
        return result2;
    }

    @Override
    @NotNull
    public String modifyColumn(@NotNull Column<?> column) {
        Intrinsics.checkParameterIsNotNull(column, "column");
        return StringsKt.replace$default(super.modifyColumn(column), "MODIFY COLUMN", "MODIFY", false, 4, null);
    }

    public OracleDialect() {
        super(dialectName, OracleDataTypeProvider.INSTANCE, OracleFunctionProvider.INSTANCE);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect$Companion;", "", "()V", "dialectName", "", "exposed"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

