/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.DateColumnType;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\u0014\u0010\u0014\u001a\u00020\b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "blobAsStream", "", "getBlobAsStream", "()Z", "binaryType", "", "length", "", "blobType", "booleanFromStringToBoolean", "value", "booleanToStatementString", "bool", "booleanType", "dateTimeType", "longAutoincType", "longType", "processForDefaultValue", "e", "Lorg/jetbrains/exposed/sql/Expression;", "shortAutoincType", "shortType", "textType", "uuidType", "exposed"})
public final class OracleDataTypeProvider
extends DataTypeProvider {
    private static final boolean blobAsStream = true;
    public static final OracleDataTypeProvider INSTANCE;

    @Override
    @NotNull
    public String shortAutoincType() {
        return "NUMBER(12)";
    }

    @Override
    @NotNull
    public String shortType() {
        return "NUMBER(12)";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return "NUMBER(19)";
    }

    @Override
    @NotNull
    public String longType() {
        return "NUMBER(19)";
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    @NotNull
    public String uuidType() {
        return "RAW(16)";
    }

    @Override
    @NotNull
    public String textType() {
        return "LONG";
    }

    @Override
    @NotNull
    public String blobType() {
        return "BLOB";
    }

    @Override
    @NotNull
    public String binaryType(int length) {
        return "BLOB";
    }

    @Override
    @NotNull
    public String booleanType() {
        return "CHAR(1)";
    }

    @Override
    @NotNull
    public String booleanToStatementString(boolean bool) {
        return bool ? "1" : "0";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(value, "value");
        try {
            String string = value;
            bl = Long.parseLong(string) != 0L;
        }
        catch (NumberFormatException ex) {
            String string = "Unexpected value of type Boolean: " + value;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return bl;
    }

    @Override
    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        return e instanceof LiteralOp && ((LiteralOp)e).getColumnType() instanceof DateColumnType ? "DATE " + super.processForDefaultValue(e) : super.processForDefaultValue(e);
    }

    @Override
    public boolean getBlobAsStream() {
        return blobAsStream;
    }

    private OracleDataTypeProvider() {
    }

    static {
        OracleDataTypeProvider oracleDataTypeProvider;
        INSTANCE = oracleDataTypeProvider = new OracleDataTypeProvider();
        blobAsStream = true;
    }
}

