/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.MysqlDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J?\u0010\u0007\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0017\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J:\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\n2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u001e\u001a\u00020\u00122\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\u0006\u0010!\u001a\u00020\u0012J8\u0010\"\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\u001e\u0010#\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0006\u0012\u0004\u0018\u00010$0\t0\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006&"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "DEFAULT_VALUE_EXPRESSION", "", "getDEFAULT_VALUE_EXPRESSION", "()Ljava/lang/String;", "columnConstraints", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "delete", "ignore", "", "table", "where", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "dropIndex", "tableName", "indexName", "insert", "columns", "Lorg/jetbrains/exposed/sql/Column;", "expr", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "isFractionDateTimeSupported", "replace", "data", "", "Companion", "exposed"})
public final class MysqlDialect
extends VendorDialect {
    @NotNull
    private final String DEFAULT_VALUE_EXPRESSION = "() VALUES ()";
    @NotNull
    public static final String dialectName = "mysql";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkParameterIsNotNull(e, "e");
        String string2 = string = e.toSQL(new QueryBuilder(false));
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String expression = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return super.isAllowedAsColumnDefault(e) || Intrinsics.areEqual(expression, "CURRENT_TIMESTAMP") && TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("5.6"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized Map<Pair<String, String>, List<ForeignKeyConstraint>> columnConstraints(Table ... tables) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull(tables, "tables");
        HashMap constraints = new HashMap();
        Object[] objectArray = $receiver$iv = (Object[])tables;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        for (void item$iv$iv : $receiver$iv$iv) {
            void it;
            Table table = (Table)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getTableName();
            collection.add(string);
        }
        List tableNames = (List)destination$iv$iv;
        Function0<String> inTableList$ = new Function0<String>(tables, tableNames){
            final /* synthetic */ Table[] $tables;
            final /* synthetic */ List $tableNames;

            @NotNull
            public final String invoke() {
                Object[] objectArray = this.$tables;
                Object[] objectArray2 = objectArray;
                if (!(objectArray2.length == 0)) {
                    return " AND ku.TABLE_NAME IN " + CollectionsKt.joinToString$default(this.$tableNames, "','", "('", "')", 0, null, null, 56, null);
                }
                return "";
            }
            {
                this.$tables = tableArray;
                this.$tableNames = list;
                super(0);
            }
        };
        TransactionManager.Companion.current().exec("SELECT\n  rc.CONSTRAINT_NAME,\n  ku.TABLE_NAME,\n  ku.COLUMN_NAME,\n  ku.REFERENCED_TABLE_NAME,\n  ku.REFERENCED_COLUMN_NAME,\n  rc.DELETE_RULE\nFROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc\n  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE ku\n    ON ku.TABLE_SCHEMA = rc.CONSTRAINT_SCHEMA AND rc.CONSTRAINT_NAME = ku.CONSTRAINT_NAME\n" + "WHERE ku.TABLE_SCHEMA = '" + this.getDatabase() + "' " + (String)inTableList$.invoke(), (Function1)new Function1<ResultSet, Unit>(tableNames, constraints){
            final /* synthetic */ List $tableNames;
            final /* synthetic */ HashMap $constraints;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ResultSet rs) {
                Intrinsics.checkParameterIsNotNull(rs, "rs");
                while (rs.next()) {
                    String refColumnName;
                    String refTableName;
                    String constraintName;
                    Object object;
                    void $receiver$iv;
                    String refereeColumnName;
                    String refereeTableName;
                    if (rs.getString("TABLE_NAME") == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!this.$tableNames.contains(refereeTableName)) continue;
                    if (rs.getString("COLUMN_NAME") == null) {
                        Intrinsics.throwNpe();
                    }
                    if (rs.getString("CONSTRAINT_NAME") == null) {
                        Intrinsics.throwNpe();
                    }
                    if (rs.getString("REFERENCED_TABLE_NAME") == null) {
                        Intrinsics.throwNpe();
                    }
                    if (rs.getString("REFERENCED_COLUMN_NAME") == null) {
                        Intrinsics.throwNpe();
                    }
                    String string = rs.getString("DELETE_RULE");
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    ReferenceOption constraintDeleteRule = ReferenceOption.valueOf(StringsKt.replace$default(string, " ", "_", false, 4, null));
                    Map map2 = this.$constraints;
                    Pair<String, String> key$iv = new Pair<String, String>(refereeTableName, refereeColumnName);
                    V value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        ArrayList<E> answer$iv = new ArrayList<E>();
                        $receiver$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((List)object).add(new ForeignKeyConstraint(constraintName, refereeTableName, refereeColumnName, refTableName, refColumnName, constraintDeleteRule));
                }
            }
            {
                this.$tableNames = list;
                this.$constraints = hashMap;
                super(1);
            }
        });
        return constraints;
    }

    @Override
    @NotNull
    public String replace(@NotNull Table table, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> data2, @NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        QueryBuilder builder = new QueryBuilder(true);
        String columns2 = CollectionsKt.joinToString$default(data2, null, null, null, 0, null, new Function1<Pair<? extends Column<?>, ? extends Object>, String>(transaction){
            final /* synthetic */ Transaction $transaction;

            @NotNull
            public final String invoke(@NotNull Pair<? extends Column<?>, ? extends Object> it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return this.$transaction.identity(it.getFirst());
            }
            {
                this.$transaction = transaction;
                super(1);
            }
        }, 31, null);
        String values2 = CollectionsKt.joinToString$default(data2, null, null, null, 0, null, new Function1<Pair<? extends Column<?>, ? extends Object>, String>(builder){
            final /* synthetic */ QueryBuilder $builder;

            @NotNull
            public final String invoke(@NotNull Pair<? extends Column<?>, ? extends Object> it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return this.$builder.registerArgument(it.getFirst().getColumnType(), it.getSecond());
            }
            {
                this.$builder = queryBuilder;
                super(1);
            }
        }, 31, null);
        return "REPLACE INTO " + transaction.identity(table) + " (" + columns2 + ") VALUES (" + values2 + ')';
    }

    @Override
    @NotNull
    protected String getDEFAULT_VALUE_EXPRESSION() {
        return this.DEFAULT_VALUE_EXPRESSION;
    }

    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(columns2, "columns");
        Intrinsics.checkParameterIsNotNull(expr, "expr");
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        String def = super.insert(false, table, columns2, expr, transaction);
        return ignore ? StringsKt.replaceFirst$default(def, "INSERT", "INSERT IGNORE", false, 4, null) : def;
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Table table, @Nullable String where, @NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        String def = super.delete(false, table, where, transaction);
        return ignore ? StringsKt.replaceFirst$default(def, "DELETE", "DELETE IGNORE", false, 4, null) : def;
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2) {
        Intrinsics.checkParameterIsNotNull(tableName, "tableName");
        Intrinsics.checkParameterIsNotNull(indexName2, "indexName");
        return "ALTER TABLE " + tableName + " DROP INDEX " + indexName2;
    }

    public final boolean isFractionDateTimeSupported() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("5.6"));
    }

    public MysqlDialect() {
        super(dialectName, MysqlDataTypeProvider.INSTANCE, MysqlFunctionProvider.INSTANCE);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect$Companion;", "", "()V", "dialectName", "", "exposed"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

