/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.Connection;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0002J3\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00100\u000e2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0012\"\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013J:\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000f2\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00102\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0014\u0010\u001c\u001a\u00020\u00042\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J8\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000f2\u001e\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0006\u0012\u0004\u0018\u00010\"0!0\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006$"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "isMySQLMode", "", "()Z", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "createIndex", "", "index", "Lorg/jetbrains/exposed/sql/Index;", "currentMode", "existingIndices", "", "Lorg/jetbrains/exposed/sql/Table;", "", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "insert", "ignore", "table", "columns", "Lorg/jetbrains/exposed/sql/Column;", "expr", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "replace", "data", "Lkotlin/Pair;", "", "Companion", "exposed"})
public final class H2Dialect
extends VendorDialect {
    private final boolean supportsMultipleGeneratedKeys = false;
    @NotNull
    public static final String dialectName = "h2";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        return true;
    }

    private final boolean isMySQLMode() {
        return Intrinsics.areEqual(this.currentMode(), "MySQL");
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String replace(@NotNull Table table, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> data2, @NotNull Transaction transaction) {
        void $receiver$iv$iv;
        Object object;
        Collection collection;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(data2, "data");
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        if (!this.isMySQLMode()) {
            throw (Throwable)new UnsupportedOperationException("REPLACE is only supported in MySQL compatibility more for H2");
        }
        QueryBuilder builder = new QueryBuilder(true);
        Iterable iterable = $receiver$iv = (Iterable)data2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            object = builder.registerArgument(((Column)it.getFirst()).getColumnType(), it.getSecond());
            collection.add(object);
        }
        List values2 = (List)destination$iv$iv;
        QueryBuilder inlineBuilder = new QueryBuilder(false);
        Iterable $receiver$iv2 = data2;
        Iterable iterable2 = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Pair $i$f$mapTo = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            object = TuplesKt.to(transaction.identity((Column)it.getFirst()), inlineBuilder.registerArgument(((Column)it.getFirst()).getColumnType(), it.getSecond()));
            collection.add(object);
        }
        List preparedValues = (List)destination$iv$iv2;
        return "INSERT INTO " + transaction.identity(table) + " (" + CollectionsKt.joinToString$default(preparedValues, null, null, null, 0, null, replace.1.INSTANCE, 31, null) + ") VALUES (" + CollectionsKt.joinToString$default(values2, null, null, null, 0, null, null, 63, null) + ") ON DUPLICATE KEY UPDATE " + CollectionsKt.joinToString$default(preparedValues, null, null, null, 0, null, replace.2.INSTANCE, 31, null);
    }

    private final String currentMode() {
        Object object;
        Connection connection = TransactionManager.Companion.current().getConnection();
        if (connection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.sql.Wrapper");
        }
        JdbcConnection jdbcConnection = ((Wrapper)connection).unwrap(JdbcConnection.class);
        Intrinsics.checkExpressionValueIsNotNull(jdbcConnection, "(TransactionManager.curr\u2026bcConnection::class.java)");
        SessionInterface sessionInterface = jdbcConnection.getSession();
        if (!(sessionInterface instanceof Session)) {
            sessionInterface = null;
        }
        if ((object = (Session)sessionInterface) == null || (object = ((Session)object).getDatabase()) == null || (object = ((Database)object).getMode()) == null || (object = ((Mode)object).getName()) == null) {
            object = "";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Object object;
        void $receiver$iv$iv;
        Map $receiver$iv;
        Intrinsics.checkParameterIsNotNull(tables, "tables");
        Map map2 = $receiver$iv = super.existingIndices(Arrays.copyOf(tables, tables.length));
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void $receiver$iv$iv2;
            void it;
            Iterable $receiver$iv2;
            void it$iv$iv;
            object = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            Iterable iterable = $receiver$iv2 = (Iterable)it.getValue();
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                Index it2 = (Index)element$iv$iv;
                if (StringsKt.startsWith$default(it2.getIndexName(), "PRIMARY_KEY_", false, 2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            map4.put(k2, list);
        }
        $receiver$iv = destination$iv$iv;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map5 = $receiver$iv;
        for (Map.Entry entry$iv : map5.entrySet()) {
            List it = (List)entry$iv.getValue();
            object = it;
            if (!(!object.isEmpty())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction) {
        String string;
        void $receiver$iv$iv;
        Pair it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(table, "table");
        Intrinsics.checkParameterIsNotNull(columns2, "columns");
        Intrinsics.checkParameterIsNotNull(expr, "expr");
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        Iterable iterable = $receiver$iv = (Iterable)table.getIndices();
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (Pair)element$iv$iv;
            if (!((Boolean)it.getSecond()).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (Pair)element$iv$iv;
            Iterable list$iv$iv = ArraysKt.toList((Object[])it.getFirst());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List uniqueIdxCols = (List)destination$iv$iv;
        Iterable $receiver$iv2 = columns2;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Column it2 = (Column)element$iv$iv;
            if (!(it2.getIndexInPK$exposed() != null || uniqueIdxCols.contains(it2))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List uniqueCols = (List)destination$iv$iv2;
        if (ignore && !($receiver$iv2 = (Collection)uniqueCols).isEmpty() && this.isMySQLMode()) {
            String def = super.insert(false, table, columns2, expr, transaction);
            string = def + " ON DUPLICATE KEY UPDATE " + CollectionsKt.joinToString$default(uniqueCols, null, null, null, 0, null, new Function1<Column<?>, String>(transaction){
                final /* synthetic */ Transaction $transaction;

                @NotNull
                public final String invoke(@NotNull Column<?> it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    return "" + this.$transaction.identity(it) + "=VALUES(" + this.$transaction.identity(it) + ')';
                }
                {
                    this.$transaction = transaction;
                    super(1);
                }
            }, 31, null);
        } else {
            string = super.insert(ignore, table, columns2, expr, transaction);
        }
        return string;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull(index, "index");
            Iterable $receiver$iv = index.getColumns();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Column it = (Column)element$iv;
                    if (!(it.getColumnType() instanceof TextColumnType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            SQLLogKt.getExposedLogger().warn("Index on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default(index.getColumns(), null, null, null, 0, null, createIndex.2.INSTANCE, 31, null) + " can't be created in H2");
            return "";
        }
        return super.createIndex(index);
    }

    public H2Dialect() {
        super(dialectName, H2DataTypeProvider.INSTANCE, null, 4, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$Companion;", "", "()V", "dialectName", "", "exposed"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

