/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!H&J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0016J?\u0010(\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130*\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0!0)2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0-\"\u00020'H\u0016\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u000201H&J*\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u00010\u00132\u0006\u0010#\u001a\u00020$H&J\u0018\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013H&J3\u00108\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u0002010!0)2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0-\"\u00020'H\u0016\u00a2\u0006\u0002\u0010.J\b\u00109\u001a\u00020\u0013H&J:\u0010:\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0010\u0010;\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030<0!2\u0006\u0010=\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H&J\u0014\u0010>\u001a\u00020\u00172\n\u0010?\u001a\u0006\u0012\u0002\b\u00030@H\u0016J$\u0010A\u001a\u00020\u00132\u0006\u0010B\u001a\u00020\u000f2\b\b\u0002\u0010C\u001a\u00020\u000f2\b\b\u0002\u0010D\u001a\u00020\u0017H&J\u0014\u0010E\u001a\u00020\u00132\n\u0010F\u001a\u0006\u0012\u0002\b\u00030<H&J8\u0010G\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u001e\u0010H\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030<\u0012\u0006\u0012\u0004\u0018\u00010\u00010*0!2\u0006\u0010#\u001a\u00020$H&J\b\u0010I\u001a\u00020JH&J\b\u0010K\u001a\u00020\u0017H&J3\u0010L\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0!0)2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0-\"\u00020'H\u0016\u00a2\u0006\u0002\u0010.J\u0010\u0010N\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0012\u0010\u001e\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019\u00a8\u0006O"}, d2={"Lorg/jetbrains/exposed/sql/vendors/DatabaseDialect;", "", "dataTypeProvider", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "getDataTypeProvider", "()Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "functionProvider", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "getFunctionProvider", "()Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "identifierLengthLimit", "", "getIdentifierLengthLimit", "()I", "name", "", "getName", "()Ljava/lang/String;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "supportsIfNotExists", "getSupportsIfNotExists", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "allTablesNames", "", "catalog", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "checkTableMapping", "table", "Lorg/jetbrains/exposed/sql/Table;", "columnConstraints", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "delete", "ignore", "where", "dropIndex", "tableName", "indexName", "existingIndices", "getDatabase", "insert", "columns", "Lorg/jetbrains/exposed/sql/Column;", "expr", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "limit", "size", "offset", "alreadyOrdered", "modifyColumn", "column", "replace", "data", "resetCaches", "", "supportsSelectForUpdate", "tableColumns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tableExists", "exposed"})
public interface DatabaseDialect {
    @NotNull
    public String getName();

    @NotNull
    public DataTypeProvider getDataTypeProvider();

    @NotNull
    public FunctionProvider getFunctionProvider();

    @NotNull
    public String getDatabase();

    @NotNull
    public List<String> allTablesNames();

    @NotNull
    public Map<Table, List<ColumnMetadata>> tableColumns(Table ... var1);

    @NotNull
    public Map<Pair<String, String>, List<ForeignKeyConstraint>> columnConstraints(Table ... var1);

    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... var1);

    public boolean tableExists(@NotNull Table var1);

    public boolean checkTableMapping(@NotNull Table var1);

    public void resetCaches();

    public boolean supportsSelectForUpdate();

    public boolean getSupportsMultipleGeneratedKeys();

    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> var1);

    public boolean getSupportsIfNotExists();

    public boolean getNeedsSequenceToAutoInc();

    public boolean getNeedsQuotesWhenSymbolsInNames();

    public int getIdentifierLengthLimit();

    @NotNull
    public String catalog(@NotNull Transaction var1);

    @NotNull
    public ReferenceOption getDefaultReferenceOption();

    @NotNull
    public String insert(boolean var1, @NotNull Table var2, @NotNull List<? extends Column<?>> var3, @NotNull String var4, @NotNull Transaction var5);

    @NotNull
    public String delete(boolean var1, @NotNull Table var2, @Nullable String var3, @NotNull Transaction var4);

    @NotNull
    public String replace(@NotNull Table var1, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> var2, @NotNull Transaction var3);

    @NotNull
    public String createIndex(@NotNull Index var1);

    @NotNull
    public String dropIndex(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String modifyColumn(@NotNull Column<?> var1);

    @NotNull
    public String limit(int var1, int var2, boolean var3);

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static Map<Table, List<ColumnMetadata>> tableColumns(DatabaseDialect $this, Table ... tables) {
            Intrinsics.checkParameterIsNotNull(tables, "tables");
            return MapsKt.emptyMap();
        }

        @NotNull
        public static Map<Pair<String, String>, List<ForeignKeyConstraint>> columnConstraints(DatabaseDialect $this, Table ... tables) {
            Intrinsics.checkParameterIsNotNull(tables, "tables");
            return MapsKt.emptyMap();
        }

        @NotNull
        public static Map<Table, List<Index>> existingIndices(DatabaseDialect $this, Table ... tables) {
            Intrinsics.checkParameterIsNotNull(tables, "tables");
            return MapsKt.emptyMap();
        }

        public static boolean checkTableMapping(DatabaseDialect $this, @NotNull Table table) {
            Intrinsics.checkParameterIsNotNull(table, "table");
            return true;
        }

        public static boolean isAllowedAsColumnDefault(DatabaseDialect $this, @NotNull Expression<?> e) {
            Intrinsics.checkParameterIsNotNull(e, "e");
            return e instanceof LiteralOp;
        }

        public static boolean getSupportsIfNotExists(DatabaseDialect $this) {
            return true;
        }

        public static boolean getNeedsSequenceToAutoInc(DatabaseDialect $this) {
            return false;
        }

        public static boolean getNeedsQuotesWhenSymbolsInNames(DatabaseDialect $this) {
            return true;
        }

        public static int getIdentifierLengthLimit(DatabaseDialect $this) {
            return 100;
        }

        @NotNull
        public static String catalog(DatabaseDialect $this, @NotNull Transaction transaction) {
            Intrinsics.checkParameterIsNotNull(transaction, "transaction");
            String string = transaction.getConnection().getCatalog();
            Intrinsics.checkExpressionValueIsNotNull(string, "transaction.connection.catalog");
            return string;
        }

        @NotNull
        public static ReferenceOption getDefaultReferenceOption(DatabaseDialect $this) {
            return ReferenceOption.RESTRICT;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ String limit$default(DatabaseDialect databaseDialect, int n, int n2, boolean bl, int n3, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: limit");
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            if ((n3 & 4) != 0) {
                bl = true;
            }
            return databaseDialect.limit(n, n2, bl);
        }
    }
}

