/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.LiteralOp;
import org.jetbrains.exposed.sql.QueryBuilder;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\u0014\u0010\u0014\u001a\u00020\b2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "", "()V", "blobAsStream", "", "getBlobAsStream", "()Z", "binaryType", "", "length", "", "blobType", "booleanFromStringToBoolean", "value", "booleanToStatementString", "bool", "booleanType", "dateTimeType", "longAutoincType", "longType", "processForDefaultValue", "e", "Lorg/jetbrains/exposed/sql/Expression;", "shortAutoincType", "shortType", "textType", "uuidToDB", "Ljava/util/UUID;", "uuidType", "exposed"})
public class DataTypeProvider {
    private final boolean blobAsStream = false;

    @NotNull
    public String shortAutoincType() {
        return "INT AUTO_INCREMENT";
    }

    @NotNull
    public String shortType() {
        return "INT";
    }

    @NotNull
    public String longAutoincType() {
        return "BIGINT AUTO_INCREMENT";
    }

    @NotNull
    public String longType() {
        return "BIGINT";
    }

    @NotNull
    public String uuidType() {
        return "BINARY(16)";
    }

    @NotNull
    public String dateTimeType() {
        return "DATETIME";
    }

    @NotNull
    public String blobType() {
        return "BLOB";
    }

    @NotNull
    public String binaryType(int length) {
        return "VARBINARY(" + length + ')';
    }

    @NotNull
    public String booleanType() {
        return "BOOLEAN";
    }

    @NotNull
    public String booleanToStatementString(boolean bool) {
        return String.valueOf(bool);
    }

    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        byte[] byArray = ByteBuffer.allocate(16).putLong(value.getMostSignificantBits()).putLong(value.getLeastSignificantBits()).array();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "ByteBuffer.allocate(16).\u2026tSignificantBits).array()");
        return byArray;
    }

    public boolean booleanFromStringToBoolean(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        String string = value;
        return Boolean.parseBoolean(string);
    }

    @NotNull
    public String textType() {
        return "TEXT";
    }

    public boolean getBlobAsStream() {
        return this.blobAsStream;
    }

    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        Expression<?> expression = e;
        return expression instanceof LiteralOp ? e.toSQL(new QueryBuilder(false)) : '(' + e.toSQL(new QueryBuilder(false)) + ')';
    }
}

