/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000@\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aF\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00010\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u000b\u001aF\u0010\f\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00010\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u000f\u001a6\u0010\f\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00010\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u0010\u001a%\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0015j\u0002`\u0016\u0012\u0004\u0012\u00020\u00120\bH\u0082\b\u001a$\u0010\u0017\u001a\u00020\u0012*\u00020\u00132\u0016\u0010\u0014\u001a\u0012\u0012\b\u0012\u00060\u0015j\u0002`\u0016\u0012\u0004\u0012\u00020\u00120\bH\u0002\u00a8\u0006\u0018"}, d2={"inTopLevelTransaction", "T", "transactionIsolation", "", "repetitionAttempts", "manager", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "statement", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/Transaction;", "Lkotlin/ExtensionFunctionType;", "(IILorg/jetbrains/exposed/sql/transactions/TransactionManager;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "transaction", "db", "Lorg/jetbrains/exposed/sql/Database;", "(IILorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "(Lorg/jetbrains/exposed/sql/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "closeLoggingException", "", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "log", "Ljava/lang/Exception;", "Lkotlin/Exception;", "rollbackLoggingException", "exposed"})
public final class ThreadLocalTransactionManagerKt {
    public static final <T> T transaction(@Nullable Database db, @NotNull Function1<? super Transaction, ? extends T> statement) {
        Intrinsics.checkParameterIsNotNull(statement, "statement");
        return ThreadLocalTransactionManagerKt.transaction(TransactionManager.Companion.getManager().getDefaultIsolationLevel(), 3, db, statement);
    }

    public static /* bridge */ /* synthetic */ Object transaction$default(Database database, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(database, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T transaction(int transactionIsolation, int repetitionAttempts, @Nullable Database db, @NotNull Function1<? super Transaction, ? extends T> statement) {
        T t;
        block10: {
            TransactionManager existingForDb;
            block11: {
                T t2;
                TransactionManager transactionManager;
                Object it;
                Object object;
                block9: {
                    Intrinsics.checkParameterIsNotNull(statement, "statement");
                    Transaction outer = TransactionManager.Companion.currentOrNull();
                    if (outer == null || db != null && !Intrinsics.areEqual(outer.getDb(), db)) break block9;
                    t = statement.invoke(outer);
                    break block10;
                }
                Database database = db;
                if (database != null) {
                    it = object = database;
                    transactionManager = TransactionManager.Companion.managerFor$exposed((Database)it);
                } else {
                    transactionManager = null;
                }
                if ((t = (existingForDb = transactionManager)) == null || (t = t.currentOrNull()) == null) break block11;
                it = object = t;
                TransactionManager currentManager = TransactionManager.Companion.getManager();
                try {
                    TransactionManager.Companion.resetCurrent(existingForDb);
                    t2 = statement.invoke((Transaction)it);
                }
                finally {
                    TransactionManager.Companion.resetCurrent(currentManager);
                }
                T t3 = t2;
                t = t3;
                if (t3 != null) break block10;
            }
            t = ThreadLocalTransactionManagerKt.inTopLevelTransaction(transactionIsolation, repetitionAttempts, existingForDb, statement);
        }
        return t;
    }

    public static /* bridge */ /* synthetic */ Object transaction$default(int n, int n2, Database database, Function1 function1, int n3, Object object) {
        if ((n3 & 4) != 0) {
            database = null;
        }
        return ThreadLocalTransactionManagerKt.transaction(n, n2, database, function1);
    }

    private static final void rollbackLoggingException(@NotNull TransactionInterface $receiver, Function1<? super Exception, Unit> log) {
        try {
            $receiver.rollback();
        }
        catch (Exception e) {
            log.invoke(e);
        }
    }

    private static final void closeLoggingException(@NotNull TransactionInterface $receiver, Function1<? super Exception, Unit> log) {
        try {
            $receiver.close();
        }
        catch (Exception e) {
            log.invoke(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T inTopLevelTransaction(int transactionIsolation, int repetitionAttempts, @Nullable TransactionManager manager, @NotNull Function1<? super Transaction, ? extends T> statement) {
        TransactionManager outerManager;
        TransactionManager transactionManager;
        Intrinsics.checkParameterIsNotNull(statement, "statement");
        int repetitions = 0;
        TransactionManager it = transactionManager = TransactionManager.Companion.getManager();
        TransactionManager transactionManager2 = outerManager = TransactionManager.Companion.currentOrNull() != null ? transactionManager : null;
        while (true) {
            PreparedStatement currentStatement;
            if (manager != null) {
                it = transactionManager;
                TransactionManager.Companion.resetCurrent(it);
            }
            Transaction transaction = TransactionManager.Companion.getManager().newTransaction(transactionIsolation);
            try {
                T answer = statement.invoke(transaction);
                transaction.commit();
                T $i$a$1$let = answer;
                return $i$a$1$let;
            }
            catch (SQLException e) {
                currentStatement = transaction.getCurrentStatement();
                SQLLogKt.getExposedLogger().info("Transaction attempt #" + repetitions + " failed: " + e.getMessage() + ". Statement: " + currentStatement, e);
                ThreadLocalTransactionManagerKt.rollbackLoggingException(transaction, inTopLevelTransaction.2.INSTANCE);
                if (++repetitions < repetitionAttempts) continue;
                throw (Throwable)e;
            }
            catch (Throwable e) {
                currentStatement = transaction.getCurrentStatement();
                ThreadLocalTransactionManagerKt.rollbackLoggingException(transaction, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(currentStatement){
                    final /* synthetic */ PreparedStatement $currentStatement;

                    public final void invoke(@NotNull Exception it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + this.$currentStatement, it);
                    }
                    {
                        this.$currentStatement = preparedStatement;
                        super(1);
                    }
                });
                throw e;
            }
            finally {
                TransactionManager.Companion.resetCurrent(outerManager);
                PreparedStatement currentStatement2 = transaction.getCurrentStatement();
                try {
                    PreparedStatement preparedStatement = currentStatement2;
                    if (preparedStatement != null) {
                        currentStatement = preparedStatement;
                        PreparedStatement it2 = currentStatement;
                        if (!it2.isClosed()) {
                            it2.close();
                        }
                        transaction.setCurrentStatement(null);
                    }
                    transaction.closeExecutedStatements();
                }
                catch (Exception e) {
                    SQLLogKt.getExposedLogger().warn("Statements close failed", e);
                }
                TransactionInterface $receiver$iv = transaction;
                try {
                    $receiver$iv.close();
                }
                catch (Exception e$iv) {
                    Exception it3 = e$iv;
                    SQLLogKt.getExposedLogger().warn("Transaction close failed: " + it3.getMessage() + ". Statement: " + currentStatement2, it3);
                }
                continue;
            }
            break;
        }
    }

    public static /* bridge */ /* synthetic */ Object inTopLevelTransaction$default(int n, int n2, TransactionManager transactionManager, Function1 function1, int n3, Object object) {
        if ((n3 & 4) != 0) {
            transactionManager = null;
        }
        return ThreadLocalTransactionManagerKt.inTopLevelTransaction(n, n2, transactionManager, function1);
    }
}

