/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import java.sql.Connection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManager;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "db", "Lorg/jetbrains/exposed/sql/Database;", "defaultIsolationLevel", "", "(Lorg/jetbrains/exposed/sql/Database;I)V", "getDefaultIsolationLevel", "()I", "setDefaultIsolationLevel", "(I)V", "threadLocal", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/exposed/sql/Transaction;", "getThreadLocal", "()Ljava/lang/ThreadLocal;", "currentOrNull", "newTransaction", "isolation", "ThreadLocalTransaction", "exposed"})
public final class ThreadLocalTransactionManager
implements TransactionManager {
    @NotNull
    private final ThreadLocal<Transaction> threadLocal;
    private final Database db;
    private volatile int defaultIsolationLevel;

    @NotNull
    public final ThreadLocal<Transaction> getThreadLocal() {
        return this.threadLocal;
    }

    @Override
    @NotNull
    public Transaction newTransaction(int isolation) {
        Transaction transaction;
        Transaction $receiver = transaction = new Transaction(new ThreadLocalTransaction(this.db, isolation, this.threadLocal));
        this.threadLocal.set($receiver);
        return transaction;
    }

    @Override
    @Nullable
    public Transaction currentOrNull() {
        return this.threadLocal.get();
    }

    @Override
    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    @Override
    public void setDefaultIsolationLevel(int n) {
        this.defaultIsolationLevel = n;
    }

    public ThreadLocalTransactionManager(@NotNull Database db, int defaultIsolationLevel) {
        Intrinsics.checkParameterIsNotNull(db, "db");
        this.db = db;
        this.defaultIsolationLevel = defaultIsolationLevel;
        this.threadLocal = new ThreadLocal();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManager$ThreadLocalTransaction;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "db", "Lorg/jetbrains/exposed/sql/Database;", "isolation", "", "threadLocal", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/exposed/sql/Transaction;", "(Lorg/jetbrains/exposed/sql/Database;ILjava/lang/ThreadLocal;)V", "connection", "Ljava/sql/Connection;", "getConnection", "()Ljava/sql/Connection;", "connectionLazy", "Lkotlin/Lazy;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "outerTransaction", "getOuterTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "getThreadLocal", "()Ljava/lang/ThreadLocal;", "close", "", "commit", "rollback", "exposed"})
    private static final class ThreadLocalTransaction
    implements TransactionInterface {
        private final Lazy<Connection> connectionLazy;
        @Nullable
        private final Transaction outerTransaction;
        @NotNull
        private final Database db;
        @NotNull
        private final ThreadLocal<Transaction> threadLocal;

        @Override
        @NotNull
        public Connection getConnection() {
            return this.connectionLazy.getValue();
        }

        @Override
        @Nullable
        public Transaction getOuterTransaction() {
            return this.outerTransaction;
        }

        @Override
        public void commit() {
            if (this.connectionLazy.isInitialized()) {
                this.getConnection().commit();
            }
        }

        @Override
        public void rollback() {
            if (this.connectionLazy.isInitialized() && !this.getConnection().isClosed()) {
                this.getConnection().rollback();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                if (this.connectionLazy.isInitialized()) {
                    this.getConnection().close();
                }
            }
            finally {
                this.threadLocal.set(this.getOuterTransaction());
            }
        }

        @Override
        @NotNull
        public Database getDb() {
            return this.db;
        }

        @NotNull
        public final ThreadLocal<Transaction> getThreadLocal() {
            return this.threadLocal;
        }

        public ThreadLocalTransaction(@NotNull Database db, int isolation, @NotNull ThreadLocal<Transaction> threadLocal) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(threadLocal, "threadLocal");
            this.db = db;
            this.threadLocal = threadLocal;
            this.connectionLazy = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<Connection>(this, isolation){
                final /* synthetic */ ThreadLocalTransaction this$0;
                final /* synthetic */ int $isolation;

                @NotNull
                public final Connection invoke() {
                    Connection connection;
                    Connection $receiver = connection = this.this$0.getDb().getConnector().invoke();
                    $receiver.setAutoCommit(false);
                    $receiver.setTransactionIsolation(this.$isolation);
                    return connection;
                }
                {
                    this.this$0 = threadLocalTransaction;
                    this.$isolation = n;
                    super(0);
                }
            });
            this.outerTransaction = this.threadLocal.get();
        }
    }
}

