/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.statements.UpdateBuilder;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\u0018\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f0\u00190\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0019\u0010\u001f\u001a\u00020\u0002*\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010!R,\u0010\n\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/sql/statements/UpdateStatement;", "Lorg/jetbrains/exposed/sql/statements/UpdateBuilder;", "", "targetsSet", "Lorg/jetbrains/exposed/sql/ColumnSet;", "limit", "where", "Lorg/jetbrains/exposed/sql/Op;", "", "(Lorg/jetbrains/exposed/sql/ColumnSet;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;)V", "firstDataSet", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Column;", "", "getFirstDataSet", "()Ljava/util/List;", "getLimit", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getTargetsSet", "()Lorg/jetbrains/exposed/sql/ColumnSet;", "getWhere", "()Lorg/jetbrains/exposed/sql/Op;", "arguments", "", "Lorg/jetbrains/exposed/sql/IColumnType;", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "executeInternal", "Ljava/sql/PreparedStatement;", "(Ljava/sql/PreparedStatement;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Integer;", "exposed"})
public class UpdateStatement
extends UpdateBuilder<Integer> {
    @NotNull
    private final ColumnSet targetsSet;
    @Nullable
    private final Integer limit;
    @Nullable
    private final Op<Boolean> where;

    @NotNull
    public List<Pair<Column<?>, Object>> getFirstDataSet() {
        return MapsKt.toList(this.getValues());
    }

    @Override
    @NotNull
    public Integer executeInternal(@NotNull PreparedStatement $receiver, @NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        if (this.getValues().isEmpty()) {
            return 0;
        }
        transaction.flushCache();
        Integer n = $receiver.executeUpdate();
        int $receiver2 = ((Number)n).intValue();
        transaction.getEntityCache().removeTablesReferrers$exposed((Collection<? extends Table>)TableKt.targetTables(this.targetsSet));
        return n;
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction) {
        Object object;
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        QueryBuilder builder = new QueryBuilder(true);
        $receiver.append("UPDATE " + this.targetsSet.describe(transaction));
        $receiver.append(" SET ");
        $receiver.append(CollectionsKt.joinToString$default(this.getFirstDataSet(), null, null, null, 0, null, new Function1<Pair<? extends Column<?>, ? extends Object>, String>(builder, this, transaction){
            final /* synthetic */ QueryBuilder $builder;
            final /* synthetic */ UpdateStatement this$0;
            final /* synthetic */ Transaction $transaction$inlined;
            {
                this.$builder = queryBuilder;
                this.this$0 = updateStatement;
                this.$transaction$inlined = transaction;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull Pair<? extends Column<?>, ? extends Object> $col_value) {
                Intrinsics.checkParameterIsNotNull($col_value, "<name for destructuring parameter 0>");
                Column<?> col = $col_value.component1();
                Object value = $col_value.component2();
                return "" + this.$transaction$inlined.identity(col) + '=' + this.$builder.registerArgument(col, value);
            }
        }, 31, null));
        Op<Boolean> op = this.where;
        if (op != null) {
            object = op;
            Op<Boolean> it = object;
            $receiver.append(" WHERE " + it.toSQL(builder));
        }
        Integer n = this.limit;
        if (n != null) {
            object = n;
            int it = ((Number)object).intValue();
            $receiver.append(" LIMIT " + it);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType, Object>>> arguments() {
        Map<Column<?>, Object> $receiver$iv;
        QueryBuilder queryBuilder;
        QueryBuilder $receiver = queryBuilder = new QueryBuilder(true);
        Map<Column<?>, Object> map2 = $receiver$iv = this.getValues();
        Iterator<Map.Entry<Column<?>, Object>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Column<?>, Object> element$iv;
            Map.Entry<Column<?>, Object> it = element$iv = iterator2.next();
            $receiver.registerArgument(it.getKey(), it.getValue());
        }
        Op<Boolean> op = this.where;
        if (op != null) {
            op.toSQL($receiver);
        }
        Collection collection = $receiver.getArgs();
        return !collection.isEmpty() ? (Iterable)CollectionsKt.listOf($receiver.getArgs()) : (Iterable)CollectionsKt.emptyList();
    }

    @NotNull
    public final ColumnSet getTargetsSet() {
        return this.targetsSet;
    }

    @Nullable
    public final Integer getLimit() {
        return this.limit;
    }

    @Nullable
    public final Op<Boolean> getWhere() {
        return this.where;
    }

    public UpdateStatement(@NotNull ColumnSet targetsSet, @Nullable Integer limit, @Nullable Op<Boolean> where) {
        Intrinsics.checkParameterIsNotNull(targetsSet, "targetsSet");
        super(StatementType.UPDATE, TableKt.targetTables(targetsSet));
        this.targetsSet = targetsSet;
        this.limit = limit;
        this.where = where;
    }

    public /* synthetic */ UpdateStatement(ColumnSet columnSet, Integer n, Op op, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            op = null;
        }
        this(columnSet, n, op);
    }
}

