/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ*\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0001\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u000b2\u0006\u0010\u0013\u001a\u0002H\u0011H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J6\u0010\u0015\u001a\u00020\u0010\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u0011*\u0004\u0018\u0001H\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00010\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0016H\u0016R&\u0010\t\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/sql/statements/UpdateBuilder;", "T", "Lorg/jetbrains/exposed/sql/statements/Statement;", "type", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "targets", "", "Lorg/jetbrains/exposed/sql/Table;", "(Lorg/jetbrains/exposed/sql/statements/StatementType;Ljava/util/List;)V", "values", "", "Lorg/jetbrains/exposed/sql/Column;", "", "getValues", "()Ljava/util/Map;", "set", "", "S", "column", "value", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Object;)V", "update", "Lorg/jetbrains/exposed/sql/Expression;", "exposed"})
public abstract class UpdateBuilder<T>
extends Statement<T> {
    @NotNull
    private final Map<Column<?>, Object> values;

    @NotNull
    protected final Map<Column<?>, Object> getValues() {
        return this.values;
    }

    public <S> void set(@NotNull Column<S> column, S value) {
        Intrinsics.checkParameterIsNotNull(column, "column");
        if (this.values.containsKey(column)) {
            String string = "" + column + " is already initialized";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (!column.getColumnType().getNullable() && value == null) {
            String string = "Trying to set null to not nullable column " + column;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map<Column<?>, Object> map2 = this.values;
        S s = value;
        map2.put(column, s);
    }

    public <T, S extends T> void update(@NotNull Column<T> column, @NotNull Expression<S> value) {
        Intrinsics.checkParameterIsNotNull(column, "column");
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (this.values.containsKey(column)) {
            String string = "" + column + " is already initialized";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map<Column<?>, Object> map2 = this.values;
        Expression<S> expression = value;
        map2.put(column, expression);
    }

    public UpdateBuilder(@NotNull StatementType type2, @NotNull List<? extends Table> targets) {
        Intrinsics.checkParameterIsNotNull((Object)type2, "type");
        Intrinsics.checkParameterIsNotNull(targets, "targets");
        super(type2, targets);
        this.values = new LinkedHashMap();
    }
}

