/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementKt;
import org.jetbrains.exposed.sql.statements.StatementType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0010\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00120\u00110\u0011H&J\u0015\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0018\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00060\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u001b\u0010 \u001a\u0004\u0018\u00018\u0000*\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H&\u00a2\u0006\u0002\u0010!R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/sql/statements/Statement;", "T", "", "type", "Lorg/jetbrains/exposed/sql/statements/StatementType;", "targets", "", "Lorg/jetbrains/exposed/sql/Table;", "(Lorg/jetbrains/exposed/sql/statements/StatementType;Ljava/util/List;)V", "isAlwaysBatch", "", "()Z", "getTargets", "()Ljava/util/List;", "getType", "()Lorg/jetbrains/exposed/sql/statements/StatementType;", "arguments", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "execute", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Object;", "executeIn", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "executeIn$exposed", "prepareSQL", "", "prepared", "Ljava/sql/PreparedStatement;", "sql", "executeInternal", "(Ljava/sql/PreparedStatement;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Object;", "exposed"})
public abstract class Statement<T> {
    @NotNull
    private final StatementType type;
    @NotNull
    private final List<Table> targets;

    @Nullable
    public abstract T executeInternal(@NotNull PreparedStatement var1, @NotNull Transaction var2);

    @NotNull
    public abstract String prepareSQL(@NotNull Transaction var1);

    @NotNull
    public abstract Iterable<Iterable<Pair<IColumnType, Object>>> arguments();

    @NotNull
    public PreparedStatement prepared(@NotNull Transaction transaction, @NotNull String sql2) {
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        Intrinsics.checkParameterIsNotNull(sql2, "sql");
        PreparedStatement preparedStatement = transaction.getConnection().prepareStatement(sql2, 2);
        if (preparedStatement == null) {
            Intrinsics.throwNpe();
        }
        return preparedStatement;
    }

    public boolean isAlwaysBatch() {
        return false;
    }

    @Nullable
    public final T execute(@NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        return transaction.exec(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<T, List<StatementContext>> executeIn$exposed(@NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        try {
            List list;
            StatementContext args;
            transaction.getMonitor().register(transaction.getLogger());
            Iterable<Iterable<Pair<IColumnType, Object>>> arguments2 = this.arguments();
            if (CollectionsKt.count(arguments2) > 0) {
                void $receiver$iv$iv;
                Iterable<Iterable<Pair<IColumnType, Object>>> $receiver$iv;
                Iterable<Iterable<Pair<IColumnType, Object>>> iterable = $receiver$iv = arguments2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    Iterable iterable2 = (Iterable)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    StatementContext context = new StatementContext(this, (Iterable<? extends Pair<? extends IColumnType, ? extends Object>>)((Object)args));
                    transaction.getMonitor().notifyBeforeExecution(transaction, context);
                    StatementContext statementContext = context;
                    collection.add(statementContext);
                }
                list = (List)destination$iv$iv;
            } else {
                StatementContext context = new StatementContext(this, CollectionsKt.emptyList());
                transaction.getMonitor().notifyBeforeExecution(transaction, context);
                list = CollectionsKt.listOf(context);
            }
            List contexts = list;
            PreparedStatement statement = this.prepared(transaction, this.prepareSQL(transaction));
            Iterable $receiver$iv = contexts;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void context;
                int n = index$iv++;
                args = (StatementContext)item$iv;
                int i = n;
                StatementKt.fillParameters(statement, context.getArgs());
                if (contexts.size() <= 1 && !this.isAlwaysBatch()) continue;
                statement.addBatch();
            }
            if (!transaction.getDb().getSupportsMultipleResultSets()) {
                transaction.closeExecutedStatements();
            }
            transaction.setCurrentStatement(statement);
            T result2 = this.executeInternal(statement, transaction);
            transaction.setCurrentStatement(null);
            transaction.getExecutedStatements$exposed().add(statement);
            transaction.getMonitor().notifyAfterExecution(transaction, contexts, statement);
            Pair<T, List> pair = TuplesKt.to(result2, contexts);
            return pair;
        }
        finally {
            transaction.getMonitor().unregister(transaction.getLogger());
        }
    }

    @NotNull
    public final StatementType getType() {
        return this.type;
    }

    @NotNull
    public final List<Table> getTargets() {
        return this.targets;
    }

    public Statement(@NotNull StatementType type2, @NotNull List<? extends Table> targets) {
        Intrinsics.checkParameterIsNotNull((Object)type2, "type");
        Intrinsics.checkParameterIsNotNull(targets, "targets");
        this.type = type2;
        this.targets = targets;
    }
}

