/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchDataInconsistentException;
import org.jetbrains.exposed.sql.statements.BatchInsertStatement;
import org.jetbrains.exposed.sql.statements.SQLServerBatchInsertStatement;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\f\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e0\r0\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\r\u0010\u0015\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\b\u0017J\u001a\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u000e*\u00020\u001aH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/statements/SQLServerBatchInsertStatement;", "Lorg/jetbrains/exposed/sql/statements/BatchInsertStatement;", "table", "Lorg/jetbrains/exposed/sql/Table;", "ignore", "", "(Lorg/jetbrains/exposed/sql/Table;Z)V", "OUTPUT_PARAMS_LIMIT", "", "OUTPUT_ROW_LIMIT", "isAlwaysBatch", "()Z", "arguments", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/IColumnType;", "", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "validateLastBatch", "", "validateLastBatch$exposed", "execInsertFunction", "Ljava/sql/ResultSet;", "Ljava/sql/PreparedStatement;", "exposed"})
public final class SQLServerBatchInsertStatement
extends BatchInsertStatement {
    private final boolean isAlwaysBatch = false;
    private final int OUTPUT_ROW_LIMIT = 1000;
    private final int OUTPUT_PARAMS_LIMIT = 5000;

    @Override
    public boolean isAlwaysBatch() {
        return this.isAlwaysBatch;
    }

    @Override
    public void validateLastBatch$exposed() {
        int paramsToInsert;
        super.validateLastBatch$exposed();
        if (this.getData().size() > this.OUTPUT_ROW_LIMIT) {
            throw (Throwable)new BatchDataInconsistentException("Too much rows in one batch. Exceed " + this.OUTPUT_ROW_LIMIT + " limit");
        }
        Map map2 = (Map)CollectionsKt.firstOrNull((List)this.getData());
        int n = paramsToInsert = map2 != null ? map2.size() : 0;
        if (paramsToInsert * (this.getData().size() + 1) > this.OUTPUT_PARAMS_LIMIT) {
            throw (Throwable)new BatchDataInconsistentException("Too much parameters for batch with OUTPUT. Exceed " + this.OUTPUT_PARAMS_LIMIT + " limit");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction) {
        List list;
        Collection<Column> collection;
        DatabaseDialect databaseDialect;
        boolean bl;
        Table table;
        Column<?> output;
        Object builder;
        String string;
        List<List<Pair<Column<?>, Object>>> values2;
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        List<List<Pair<Column<?>, Object>>> list2 = this.getArguments();
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        if ((values2 = list2).isEmpty()) {
            string = "";
        } else {
            Object object;
            String string2;
            Column<?> column;
            builder = new QueryBuilder(true);
            Column<?> column2 = this.getTable().getAutoIncColumn();
            if (column2 != null) {
                Column<?> it = column = column2;
                string2 = " OUTPUT inserted." + transaction.identity(it) + " AS GENERATED_KEYS";
            } else {
                string2 = null;
            }
            if ((object = (column = string2)) == null) {
                object = "";
            }
            output = object;
            string = CollectionsKt.joinToString$default(values2, null, "" + output + " VALUES", null, 0, null, new Function1<List<? extends Pair<? extends Column<?>, ? extends Object>>, String>((QueryBuilder)builder){
                final /* synthetic */ QueryBuilder $builder;

                @NotNull
                public final String invoke(@NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    return CollectionsKt.joinToString$default(it, null, "(", ")", 0, null, new Function1<Pair<? extends Column<?>, ? extends Object>, String>(this){
                        final /* synthetic */ prepareSQL.sql.1 this$0;

                        @NotNull
                        public final String invoke(@NotNull Pair<? extends Column<?>, ? extends Object> $col_value) {
                            Intrinsics.checkParameterIsNotNull($col_value, "<name for destructuring parameter 0>");
                            Column<?> col = $col_value.component1();
                            Object value = $col_value.component2();
                            return this.this$0.$builder.registerArgument(col, value);
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }, 25, null);
                }
                {
                    this.$builder = queryBuilder;
                    super(1);
                }
            }, 29, null);
        }
        String sql2 = string;
        DatabaseDialect databaseDialect2 = transaction.getDb().getDialect$exposed();
        boolean bl2 = this.isIgnore();
        Table table2 = this.getTable();
        List<Pair<Column<?>, Object>> list3 = CollectionsKt.firstOrNull(values2);
        if (list3 != null) {
            void $receiver$iv$iv;
            void $receiver$iv;
            builder = list3;
            table = table2;
            bl = bl2;
            databaseDialect = databaseDialect2;
            output = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                Column column = (Column)it.getFirst();
                collection.add(column);
            }
            collection = (List)destination$iv$iv;
            databaseDialect2 = databaseDialect;
            bl2 = bl;
            table2 = table;
            list = collection;
        } else {
            list = null;
        }
        List list4 = list;
        table = table2;
        bl = bl2;
        databaseDialect = databaseDialect2;
        List list5 = list4;
        if (list5 == null) {
            list5 = CollectionsKt.emptyList();
        }
        collection = list5;
        return databaseDialect.insert(bl, table, (List<? extends Column<?>>)collection, sql2, transaction);
    }

    @Override
    @NotNull
    public List<List<Pair<IColumnType, Object>>> arguments() {
        List list;
        List it = list = CollectionsKt.flatten(super.arguments());
        Collection collection = this.getData();
        return CollectionsKt.listOfNotNull(!collection.isEmpty() ? list : null);
    }

    @Override
    @NotNull
    protected Pair<Integer, ResultSet> execInsertFunction(@NotNull PreparedStatement $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        List<List<Pair<Column<?>, Object>>> list = this.getArguments();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return TuplesKt.to(list.size(), $receiver.executeQuery());
    }

    public SQLServerBatchInsertStatement(@NotNull Table table, boolean ignore) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        super(table, ignore);
        this.OUTPUT_ROW_LIMIT = 1000;
        this.OUTPUT_PARAMS_LIMIT = 5000;
    }

    public /* synthetic */ SQLServerBatchInsertStatement(Table table, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(table, bl);
    }
}

