/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityClass;
import org.jetbrains.exposed.dao.EntityID;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchUpdateStatement;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0002\b\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001f\u0010\u0015\u001a\u00020\u000f2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0086\u0002R6\u0010\u0006\u001a*\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0002\u001a\u0010\u0012\u0002\b\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/sql/statements/EntityBatchUpdate;", "", "klass", "Lorg/jetbrains/exposed/dao/EntityClass;", "Lorg/jetbrains/exposed/dao/Entity;", "(Lorg/jetbrains/exposed/dao/EntityClass;)V", "data", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/dao/EntityID;", "Ljava/util/SortedMap;", "Lorg/jetbrains/exposed/sql/Column;", "getKlass", "()Lorg/jetbrains/exposed/dao/EntityClass;", "addBatch", "", "id", "execute", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "set", "column", "value", "exposed"})
public final class EntityBatchUpdate {
    private final ArrayList<Pair<EntityID<?>, SortedMap<Column<?>, Object>>> data;
    @NotNull
    private final EntityClass<?, Entity<?>> klass;

    public final void addBatch(@NotNull EntityID<?> id2) {
        Intrinsics.checkParameterIsNotNull(id2, "id");
        if (Intrinsics.areEqual(id2.getTable(), this.klass.getTable()) ^ true) {
            String string = "Table from Entity ID " + id2.getTable().getTableName() + " differs from entity class " + this.klass.getTable().getTableName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.data.add(TuplesKt.to(id2, new TreeMap()));
    }

    public final void set(@NotNull Column<?> column, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull(column, "column");
        SortedMap values2 = (SortedMap)((Pair)CollectionsKt.last((List)this.data)).getSecond();
        if (values2.containsKey(column)) {
            String string = "" + column + " is already initialized";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map map2 = values2;
        Object object = column.getColumnType().valueToDB(value);
        map2.put(column, object);
    }

    /*
     * WARNING - void declaration
     */
    public final int execute(@NotNull Transaction transaction) {
        int initial$iv;
        Object it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        Iterable iterable = $receiver$iv = (Iterable)this.data;
        Object destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Pair)element$iv$iv;
            if (((SortedMap)((Pair)it).getSecond()).isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            element$iv$iv = iterator2.next();
            it = (Pair)element$iv$iv;
            Set key$iv$iv = ((SortedMap)((Pair)it).getSecond()).keySet();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object updateSets = destination$iv$iv;
        $receiver$iv = updateSets.values();
        int accumulator$iv = initial$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void set;
            it = (List)element$iv;
            int acc = accumulator$iv;
            BatchUpdateStatement batchUpdateStatement = new BatchUpdateStatement(this.klass.getTable());
            int n = acc;
            BatchUpdateStatement it2 = batchUpdateStatement;
            it2.getData().addAll((Collection)set);
            Object t = it2.execute(transaction);
            if (t == null) {
                Intrinsics.throwNpe();
            }
            int n2 = ((Number)t).intValue();
            accumulator$iv = n + n2;
        }
        return accumulator$iv;
    }

    @NotNull
    public final EntityClass<?, Entity<?>> getKlass() {
        return this.klass;
    }

    public EntityBatchUpdate(@NotNull EntityClass<?, ? extends Entity<?>> klass) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        this.klass = klass;
        this.data = new ArrayList();
    }
}

