/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.EntityID;
import org.jetbrains.exposed.dao.IdTable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.UpdateStatement;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\bJ\"\u0010\u0017\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00070\u00180\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J6\u0010\u001e\u001a\u00020\u001f\"\u0004\b\u0000\u0010 \"\n\b\u0001\u0010!*\u0004\u0018\u0001H 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0\n2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$H\u0016J\u0019\u0010%\u001a\u00020&*\u00020'2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010(R9\u0010\u0005\u001a*\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR,\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00070\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lorg/jetbrains/exposed/sql/statements/BatchUpdateStatement;", "Lorg/jetbrains/exposed/sql/statements/UpdateStatement;", "table", "Lorg/jetbrains/exposed/dao/IdTable;", "(Lorg/jetbrains/exposed/dao/IdTable;)V", "data", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/dao/EntityID;", "Ljava/util/SortedMap;", "Lorg/jetbrains/exposed/sql/Column;", "", "getData", "()Ljava/util/ArrayList;", "firstDataSet", "", "getFirstDataSet", "()Ljava/util/List;", "getTable", "()Lorg/jetbrains/exposed/dao/IdTable;", "addBatch", "", "id", "arguments", "", "Lorg/jetbrains/exposed/sql/IColumnType;", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "update", "", "T", "S", "column", "value", "Lorg/jetbrains/exposed/sql/Expression;", "executeInternal", "", "Ljava/sql/PreparedStatement;", "(Ljava/sql/PreparedStatement;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Integer;", "exposed"})
public final class BatchUpdateStatement
extends UpdateStatement {
    @NotNull
    private final ArrayList<Pair<EntityID<?>, SortedMap<Column<?>, Object>>> data;
    @NotNull
    private final IdTable<?> table;

    @NotNull
    public final ArrayList<Pair<EntityID<?>, SortedMap<Column<?>, Object>>> getData() {
        return this.data;
    }

    @Override
    @NotNull
    public List<Pair<Column<?>, Object>> getFirstDataSet() {
        return MapsKt.toList((Map)((Pair)CollectionsKt.first((List)this.data)).getSecond());
    }

    public final void addBatch(@NotNull EntityID<?> id2) {
        Intrinsics.checkParameterIsNotNull(id2, "id");
        if (this.data.size() >= 2) {
            Set set = ((SortedMap)((Pair)CollectionsKt.first((List)this.data)).getSecond()).keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, "data.first().second.keys");
            List list = CollectionsKt.toList(set);
            Set set2 = ((SortedMap)((Pair)CollectionsKt.last((List)this.data)).getSecond()).keySet();
            Intrinsics.checkExpressionValueIsNotNull(set2, "data.last().second.keys");
            if (Intrinsics.areEqual(list, CollectionsKt.toList(set2))) {
            } else {
                Set set3 = ((SortedMap)((Pair)CollectionsKt.first((List)this.data)).getSecond()).keySet();
                Intrinsics.checkExpressionValueIsNotNull(set3, "data.first().second.keys");
                Iterable iterable = set3;
                Set set4 = ((SortedMap)((Pair)CollectionsKt.last((List)this.data)).getSecond()).keySet();
                Intrinsics.checkExpressionValueIsNotNull(set4, "data.last().second.keys");
                Set different = CollectionsKt.intersect(iterable, set4);
                String string = "Some values missing for batch update. Different columns: " + different;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        this.data.add(TuplesKt.to(id2, new TreeMap()));
    }

    @NotNull
    public <T, S extends T> Void update(@NotNull Column<T> column, @NotNull Expression<S> value) {
        Intrinsics.checkParameterIsNotNull(column, "column");
        Intrinsics.checkParameterIsNotNull(value, "value");
        String string = "Expressions unsupported in batch update";
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        return "" + super.prepareSQL(transaction) + " WHERE " + transaction.identity(this.table.getId()) + " = ?";
    }

    @Override
    @NotNull
    public Integer executeInternal(@NotNull PreparedStatement $receiver, @NotNull Transaction transaction) {
        int n;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(transaction, "transaction");
        if (this.data.size() == 1) {
            n = $receiver.executeUpdate();
        } else {
            int[] nArray = $receiver.executeBatch();
            Intrinsics.checkExpressionValueIsNotNull(nArray, "executeBatch()");
            n = ArraysKt.sum(nArray);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType, Object>>> arguments() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.data;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            void it;
            Map $receiver$iv2;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            Map map2 = $receiver$iv2 = (Map)it.getSecond();
            Collection destination$iv$iv2 = new ArrayList($receiver$iv2.size());
            void var10_10 = $receiver$iv$iv2;
            Iterator iterator2 = var10_10.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it2;
                Map.Entry item$iv$iv2;
                Map.Entry entry = item$iv$iv2 = iterator2.next();
                Collection collection2 = destination$iv$iv2;
                Pair pair2 = TuplesKt.to(((Column)it2.getKey()).getColumnType(), it2.getValue());
                collection2.add(pair2);
            }
            List list = CollectionsKt.plus((Collection)((List)destination$iv$iv2), TuplesKt.to(this.table.getId().getColumnType(), it.getFirst()));
            collection.add(list);
        }
        return (List)var3_3;
    }

    @NotNull
    public final IdTable<?> getTable() {
        return this.table;
    }

    public BatchUpdateStatement(@NotNull IdTable<?> table) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        super(table, null, null, 4, null);
        this.table = table;
        this.data = new ArrayList();
    }
}

