/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.statements.BatchDataInconsistentException;
import org.jetbrains.exposed.sql.statements.BatchInsertStatement;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u000b\b\u0016\u0018\u00002\u001e\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u00020\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u001fH\u0002J*\u0010 \u001a\u00020\u001d\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0\u00042\u0006\u0010#\u001a\u0002H!H\u0096\u0002\u00a2\u0006\u0002\u0010$J\r\u0010%\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b&J4\u0010'\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00032\u0018\u0010(\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003H\u0014J\u0010\u0010)\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u0004H\u0002R<\u0010\u000b\u001a\"\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\f0\u0002\u0018\u00010\u00028TX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R,\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00130\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\tX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R,\u0010\u0019\u001a\u001a\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u0014\u0010\u001b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018\u00a8\u0006*"}, d2={"Lorg/jetbrains/exposed/sql/statements/BatchInsertStatement;", "Lorg/jetbrains/exposed/sql/statements/InsertStatement;", "", "", "Lorg/jetbrains/exposed/sql/Column;", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "ignore", "", "(Lorg/jetbrains/exposed/sql/Table;Z)V", "arguments", "Lkotlin/Pair;", "getArguments", "()Ljava/util/List;", "setArguments", "(Ljava/util/List;)V", "data", "Ljava/util/ArrayList;", "", "getData", "()Ljava/util/ArrayList;", "flushCache", "getFlushCache", "()Z", "generatedKey", "getGeneratedKey", "isAlwaysBatch", "addBatch", "", "allColumnsInDataSet", "", "set", "S", "column", "value", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Object;)V", "validateLastBatch", "validateLastBatch$exposed", "valuesAndDefaults", "values", "isDefaultable", "exposed"})
public class BatchInsertStatement
extends InsertStatement<List<? extends Map<Column<?>, ? extends Object>>> {
    private final boolean flushCache = false;
    private final boolean isAlwaysBatch = true;
    @NotNull
    private final ArrayList<Map<Column<?>, Object>> data;
    @Nullable
    private List<? extends List<? extends Pair<? extends Column<?>, ? extends Object>>> arguments;

    @Override
    protected boolean getFlushCache() {
        return this.flushCache;
    }

    @Override
    public boolean isAlwaysBatch() {
        return this.isAlwaysBatch;
    }

    @Override
    @Nullable
    public List<Map<Column<?>, Object>> getGeneratedKey() {
        return this.getResultedValues();
    }

    @NotNull
    protected final ArrayList<Map<Column<?>, Object>> getData() {
        return this.data;
    }

    private final boolean isDefaultable(@NotNull Column<?> $receiver) {
        return $receiver.getColumnType().getNullable() || $receiver.getDefaultValueFun$exposed() != null;
    }

    @Override
    public <S> void set(@NotNull Column<S> column, S value) {
        Intrinsics.checkParameterIsNotNull(column, "column");
        if (this.data.size() > 1) {
            Map<Column<?>, Object> map2;
            Map<Column<?>, Object> map3 = this.data.get(this.data.size() - 2);
            Intrinsics.checkExpressionValueIsNotNull(map3, "data[data.size - 2]");
            Map<Column<?>, Object> map4 = map2 = map3;
            if (!map4.containsKey(column) && !this.isDefaultable(column)) {
                throw (Throwable)new BatchDataInconsistentException("Can't set " + value + " for " + TransactionManager.Companion.current().fullIdentity(column) + " because previous insertion can't be defaulted for that column.");
            }
        }
        super.set(column, value);
    }

    public final void addBatch() {
        Collection collection = this.data;
        if (!collection.isEmpty()) {
            this.validateLastBatch$exposed();
            this.data.set(this.data.size() - 1, new LinkedHashMap(this.getValues()));
            this.getValues().clear();
        }
        this.data.add(this.getValues());
        this.setArguments(null);
    }

    /*
     * WARNING - void declaration
     */
    public void validateLastBatch$exposed() {
        DdlAware it;
        Iterable $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)SetsKt.minus(((Map)CollectionsKt.last((List)this.data)).keySet(), (Iterable)this.getValues().keySet());
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            Column it2 = (Column)element$iv$iv;
            if (this.isDefaultable(it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cantBeDefaulted = (List)destination$iv$iv;
        $receiver$iv = cantBeDefaulted;
        if (!$receiver$iv.isEmpty()) {
            String columnList2 = CollectionsKt.joinToString$default(cantBeDefaulted, null, null, null, 0, null, validateLastBatch.columnList.1.INSTANCE, 31, null);
            throw (Throwable)new BatchDataInconsistentException("Can't add new batch because columns: " + columnList2 + " don't have client default values. DB defaults don't support in batch inserts");
        }
        Iterable $receiver$iv2 = this.getTargets();
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Table)element$iv$iv;
            Iterable list$iv$iv = ((Table)it).getColumns();
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        $receiver$iv$iv = $receiver$iv2 = (Iterable)CollectionsKt.minus((Iterable)((List)destination$iv$iv2), (Iterable)this.getValues().keySet());
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Column)element$iv$iv;
            if (!(!this.isDefaultable((Column<?>)it) && !ColumnTypeKt.isAutoInc(((Column)it).getColumnType()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List requiredInTargets = (List)destination$iv$iv2;
        if (CollectionsKt.any(requiredInTargets)) {
            throw (Throwable)new BatchDataInconsistentException("Can't add new batch because columns: " + CollectionsKt.joinToString$default(requiredInTargets, null, null, null, 0, null, null, 63, null) + " don't have client default values. DB defaults don't support in batch inserts");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Column<?>> allColumnsInDataSet() {
        void var3_3;
        void $receiver$iv;
        Iterable iterable = this.data;
        Set initial$iv = SetsKt.emptySet();
        Set accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void row;
            Map map2 = (Map)element$iv;
            Set columns2 = accumulator$iv;
            accumulator$iv = SetsKt.plus(columns2, row.keySet());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected List<List<Pair<Column<?>, Object>>> getArguments() {
        List list = this.arguments;
        if (list == null) {
            List list2;
            List $receiver;
            Object it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            BatchInsertStatement batchInsertStatement;
            BatchInsertStatement $receiver2 = batchInsertStatement = this;
            Iterable iterable = $receiver$iv = (Iterable)$receiver2.allColumnsInDataSet();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (Column)element$iv$iv;
                if (!((Column)it).getColumnType().getNullable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nullableColumns = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv = (Iterable)$receiver2.data;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                void single2;
                it = (Map)item$iv$iv;
                Collection collection = destination$iv$iv;
                Map<Column<?>, Object> valuesAndDefaults = super.valuesAndDefaults((Map<Column<?>, ? extends Object>)single2);
                Iterable $i$f$filterTo = CollectionsKt.minus((Iterable)nullableColumns, (Iterable)valuesAndDefaults.keySet());
                Map<Column<?>, Object> map2 = valuesAndDefaults;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10)), 16);
                Comparator comparator2 = $receiver$iv2;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                for (Object element$iv$iv : $receiver$iv$iv2) {
                    Map map3 = destination$iv$iv2;
                    Column it2 = (Column)element$iv$iv;
                    Pair<Column, Object> pair = TuplesKt.to(it2, null);
                    map3.put(pair.getFirst(), pair.getSecond());
                }
                Map map4 = destination$iv$iv2;
                Iterable iterable2 = $receiver$iv2 = (Iterable)MapsKt.toList(MapsKt.plus(map2, map4));
                comparator2 = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        Comparable comparable = (Column)it.getFirst();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        Column column = (Column)it.getFirst();
                        return ComparisonsKt.compareValues(comparable2, (Comparable)column);
                    }
                };
                List list3 = CollectionsKt.sortedWith(iterable2, comparator2);
                collection.add(list3);
            }
            this.arguments = $receiver = (list2 = (List)destination$iv$iv);
            list = list2;
        }
        return list;
    }

    @Override
    protected void setArguments(@Nullable List<? extends List<? extends Pair<? extends Column<?>, ? extends Object>>> list) {
        this.arguments = list;
    }

    @Override
    @NotNull
    protected Map<Column<?>, Object> valuesAndDefaults(@NotNull Map<Column<?>, ? extends Object> values2) {
        Intrinsics.checkParameterIsNotNull(values2, "values");
        List<List<Pair<Column<?>, Object>>> list = this.getArguments();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return MapsKt.toMap((Iterable)CollectionsKt.first(list));
    }

    public BatchInsertStatement(@NotNull Table table, boolean ignore) {
        Intrinsics.checkParameterIsNotNull(table, "table");
        super(table, ignore);
        this.isAlwaysBatch = true;
        this.data = new ArrayList();
    }

    public /* synthetic */ BatchInsertStatement(Table table, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(table, bl);
    }
}

