/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/exposed/sql/UUIDColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "notNullValueToDB", "", "value", "sqlType", "", "valueFromDB", "exposed"})
public final class UUIDColumnType
extends ColumnType {
    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().uuidType();
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        UUID uUID;
        Intrinsics.checkParameterIsNotNull(value, "value");
        DataTypeProvider dataTypeProvider = DefaultKt.getCurrentDialect().getDataTypeProvider();
        Object object = value;
        if (object instanceof UUID) {
            uUID = (UUID)value;
        } else if (object instanceof String) {
            uUID = UUID.fromString((String)value);
        } else if (object instanceof byte[]) {
            ByteBuffer it;
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])value);
            DataTypeProvider dataTypeProvider2 = dataTypeProvider;
            ByteBuffer byteBuffer2 = it = byteBuffer;
            Intrinsics.checkExpressionValueIsNotNull(byteBuffer2, "it");
            UUID uUID2 = new UUID(byteBuffer2.getLong(), it.getLong());
            dataTypeProvider = dataTypeProvider2;
            uUID = uUID2;
        } else {
            String string = "Unexpected value of type UUID: " + value.getClass().getCanonicalName();
            DataTypeProvider dataTypeProvider3 = dataTypeProvider;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkExpressionValueIsNotNull(uUID, "when (value) {\n        i\u2026ss.canonicalName}\")\n    }");
        return dataTypeProvider.uuidToDB(uUID);
    }

    @Override
    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        UUID uUID;
        Intrinsics.checkParameterIsNotNull(value, "value");
        Object object = value;
        if (object instanceof UUID) {
            uUID = (UUID)value;
        } else if (object instanceof byte[]) {
            ByteBuffer byteBuffer;
            ByteBuffer b;
            ByteBuffer byteBuffer2 = b = (byteBuffer = ByteBuffer.wrap((byte[])value));
            Intrinsics.checkExpressionValueIsNotNull(byteBuffer2, "b");
            uUID = new UUID(byteBuffer2.getLong(), b.getLong());
        } else if (object instanceof String) {
            Object object2 = (String)value;
            Object b = Charsets.UTF_8;
            byte[] byArray = ((String)object2).getBytes((Charset)b);
            Intrinsics.checkExpressionValueIsNotNull(byArray, "(this as java.lang.String).getBytes(charset)");
            Object object3 = b = (object2 = ByteBuffer.wrap(byArray));
            Intrinsics.checkExpressionValueIsNotNull(object3, "b");
            uUID = new UUID(((ByteBuffer)object3).getLong(), ((ByteBuffer)b).getLong());
        } else {
            String string = "Unexpected value of type UUID: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return uUID;
    }

    public UUIDColumnType() {
        super(false, 1, null);
    }
}

