/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityCache;
import org.jetbrains.exposed.dao.EntityHook;
import org.jetbrains.exposed.sql.Alias;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.CompositeSqlLogger;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Slf4jSqlLogger;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.Transaction$WhenMappings;
import org.jetbrains.exposed.sql.UserDataHolder;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementMonitor;
import org.jetbrains.exposed.sql.statements.StatementType;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\t\u0010M\u001a\u00020NH\u0096\u0001J\u0006\u0010O\u001a\u00020NJ\b\u0010P\u001a\u00020NH\u0016J\u0015\u0010Q\u001a\u00020:2\u0006\u0010R\u001a\u00020:H\u0000\u00a2\u0006\u0002\bSJ\u0018\u0010T\u001a\u00020:2\u0006\u0010U\u001a\u00020\u001a2\u0006\u0010V\u001a\u00020:H\u0002J\u0015\u0010W\u001a\u0004\u0018\u00010N2\u0006\u0010V\u001a\u00020:\u00a2\u0006\u0002\u0010XJ3\u0010W\u001a\u0004\u0018\u0001HY\"\b\b\u0000\u0010Y*\u00020Z2\u0006\u0010V\u001a\u00020:2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020]\u0012\u0004\u0012\u0002HY0\\\u00a2\u0006\u0002\u0010^J!\u0010W\u001a\u0004\u0018\u0001HY\"\u0004\b\u0000\u0010Y2\f\u0010V\u001a\b\u0012\u0004\u0012\u0002HY0_\u00a2\u0006\u0002\u0010`JL\u0010W\u001a\u0004\u0018\u0001Ha\"\u0004\b\u0000\u0010Y\"\u0004\b\u0001\u0010a2\f\u0010V\u001a\b\u0012\u0004\u0012\u0002HY0_2#\u0010b\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002HY0_\u0012\u0004\u0012\u0002HY\u0012\u0004\u0012\u0002Ha0c\u00a2\u0006\u0002\bd\u00a2\u0006\u0002\u0010eJ\u0010\u0010f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030h0gJ\u0012\u0010i\u001a\u00020:2\n\u0010j\u001a\u0006\u0012\u0002\b\u00030kJ\u0012\u0010R\u001a\u00020:2\n\u0010j\u001a\u0006\u0012\u0002\b\u00030kJ\u000e\u0010R\u001a\u00020:2\u0006\u0010l\u001a\u00020mJ\u0015\u0010n\u001a\u00020:2\u0006\u0010R\u001a\u00020:H\u0000\u00a2\u0006\u0002\boJ\u0010\u0010p\u001a\u00020:2\u0006\u0010q\u001a\u00020:H\u0002J\t\u0010r\u001a\u00020NH\u0096\u0001R\u0012\u0010\u0005\u001a\u00020\u0006X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u0004\u0018\u00010\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u000203X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107RE\u00108\u001a6\u0012\u0004\u0012\u00020:\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001a0;09j\u001a\u0012\u0004\u0012\u00020:\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001a0;`<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0015\u0010?\u001a\u00060@j\u0002`A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010D\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010I\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR\u0018\u0010J\u001a\u00020:*\u00020:8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006s"}, d2={"Lorg/jetbrains/exposed/sql/Transaction;", "Lorg/jetbrains/exposed/sql/UserDataHolder;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "transactionImpl", "(Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;)V", "connection", "Ljava/sql/Connection;", "getConnection", "()Ljava/sql/Connection;", "currentStatement", "Ljava/sql/PreparedStatement;", "getCurrentStatement", "()Ljava/sql/PreparedStatement;", "setCurrentStatement", "(Ljava/sql/PreparedStatement;)V", "db", "Lorg/jetbrains/exposed/sql/Database;", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "debug", "", "getDebug", "()Z", "setDebug", "(Z)V", "duration", "", "getDuration", "()J", "setDuration", "(J)V", "entityCache", "Lorg/jetbrains/exposed/dao/EntityCache;", "getEntityCache", "()Lorg/jetbrains/exposed/dao/EntityCache;", "executedStatements", "", "getExecutedStatements$exposed", "()Ljava/util/List;", "logger", "Lorg/jetbrains/exposed/sql/CompositeSqlLogger;", "getLogger", "()Lorg/jetbrains/exposed/sql/CompositeSqlLogger;", "monitor", "Lorg/jetbrains/exposed/sql/statements/StatementMonitor;", "getMonitor", "()Lorg/jetbrains/exposed/sql/statements/StatementMonitor;", "outerTransaction", "getOuterTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "statementCount", "", "getStatementCount", "()I", "setStatementCount", "(I)V", "statementStats", "Ljava/util/HashMap;", "", "Lkotlin/Pair;", "Lkotlin/collections/HashMap;", "getStatementStats", "()Ljava/util/HashMap;", "statements", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getStatements", "()Ljava/lang/StringBuilder;", "warnLongQueriesDuration", "getWarnLongQueriesDuration", "()Ljava/lang/Long;", "setWarnLongQueriesDuration", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "quoted", "getQuoted", "(Ljava/lang/String;)Ljava/lang/String;", "close", "", "closeExecutedStatements", "commit", "cutIfNecessary", "identity", "cutIfNecessary$exposed", "describeStatement", "delta", "stmt", "exec", "(Ljava/lang/String;)Lkotlin/Unit;", "T", "", "transform", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/jetbrains/exposed/sql/statements/Statement;", "(Lorg/jetbrains/exposed/sql/statements/Statement;)Ljava/lang/Object;", "R", "body", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/exposed/sql/statements/Statement;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "flushCache", "", "Lorg/jetbrains/exposed/dao/Entity;", "fullIdentity", "column", "Lorg/jetbrains/exposed/sql/Column;", "table", "Lorg/jetbrains/exposed/sql/Table;", "quoteIfNecessary", "quoteIfNecessary$exposed", "quoteTokenIfNecessary", "token", "rollback", "exposed"})
public class Transaction
extends UserDataHolder
implements TransactionInterface {
    @NotNull
    private final StatementMonitor monitor;
    @NotNull
    private final CompositeSqlLogger logger;
    private int statementCount;
    private long duration;
    @Nullable
    private Long warnLongQueriesDuration;
    private boolean debug;
    @NotNull
    private final EntityCache entityCache;
    @Nullable
    private PreparedStatement currentStatement;
    @NotNull
    private final List<PreparedStatement> executedStatements;
    @NotNull
    private final StringBuilder statements;
    @NotNull
    private final HashMap<String, Pair<Integer, Long>> statementStats;
    private final TransactionInterface transactionImpl;

    @NotNull
    public final StatementMonitor getMonitor() {
        return this.monitor;
    }

    @NotNull
    public final CompositeSqlLogger getLogger() {
        return this.logger;
    }

    public final int getStatementCount() {
        return this.statementCount;
    }

    public final void setStatementCount(int n) {
        this.statementCount = n;
    }

    public final long getDuration() {
        return this.duration;
    }

    public final void setDuration(long l) {
        this.duration = l;
    }

    @Nullable
    public final Long getWarnLongQueriesDuration() {
        return this.warnLongQueriesDuration;
    }

    public final void setWarnLongQueriesDuration(@Nullable Long l) {
        this.warnLongQueriesDuration = l;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    @NotNull
    public final EntityCache getEntityCache() {
        return this.entityCache;
    }

    @Nullable
    public final PreparedStatement getCurrentStatement() {
        return this.currentStatement;
    }

    public final void setCurrentStatement(@Nullable PreparedStatement preparedStatement) {
        this.currentStatement = preparedStatement;
    }

    @NotNull
    public final List<PreparedStatement> getExecutedStatements$exposed() {
        return this.executedStatements;
    }

    @NotNull
    public final StringBuilder getStatements() {
        return this.statements;
    }

    @NotNull
    public final HashMap<String, Pair<Integer, Long>> getStatementStats() {
        return this.statementStats;
    }

    @Override
    public void commit() {
        List<Entity<?>> created = this.flushCache();
        EntityHook.INSTANCE.alertSubscribers();
        List<Entity<?>> createdByHooks = this.flushCache();
        this.transactionImpl.commit();
        this.getUserdata().clear();
        EntityCache.Companion.invalidateGlobalCaches(CollectionsKt.plus((Collection)created, (Iterable)createdByHooks));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Entity<?>> flushCache() {
        void $receiver$iv$iv;
        Map $receiver$iv;
        EntityCache entityCache;
        EntityCache $receiver = entityCache = this.entityCache;
        Map map2 = $receiver$iv = (Map)$receiver.getInserts();
        Collection destination$iv$iv = new ArrayList();
        void var6_6 = $receiver$iv$iv;
        Iterator iterator2 = var6_6.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            Iterable list$iv$iv = (List)it.getValue();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List newEntities = (List)destination$iv$iv;
        $receiver.flush();
        return newEntities;
    }

    private final String describeStatement(long delta, String stmt) {
        return "" + '[' + delta + "ms] " + StringsKt.take(stmt, 1024) + "\n\n";
    }

    @Nullable
    public final Unit exec(@NotNull String stmt) {
        Intrinsics.checkParameterIsNotNull(stmt, "stmt");
        return (Unit)this.exec(stmt, exec.1.INSTANCE);
    }

    @Nullable
    public final <T> T exec(@NotNull String stmt, @NotNull Function1<? super ResultSet, ? extends T> transform) {
        StatementType statementType;
        Object object;
        block3: {
            Object[] objectArray;
            Intrinsics.checkParameterIsNotNull(stmt, "stmt");
            Intrinsics.checkParameterIsNotNull(transform, "transform");
            CharSequence charSequence = stmt;
            if (charSequence.length() == 0) {
                return null;
            }
            for (Object object2 : objectArray = (Object[])StatementType.values()) {
                StatementType it = (StatementType)((Object)object2);
                String string = stmt;
                if (!StringsKt.startsWith(((Object)StringsKt.trim((CharSequence)string)).toString(), it.name(), true)) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        if ((statementType = (StatementType)((Object)object)) == null) {
            statementType = StatementType.OTHER;
        }
        StatementType type2 = statementType;
        return this.exec(new Statement<T>(type2, transform, stmt, type2, CollectionsKt.emptyList()){
            final /* synthetic */ StatementType $type;
            final /* synthetic */ Function1 $transform;
            final /* synthetic */ String $stmt;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public T executeInternal(@NotNull PreparedStatement $receiver, @NotNull Transaction transaction) {
                T t;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Intrinsics.checkParameterIsNotNull(transaction, "transaction");
                switch (Transaction$WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                    case 1: {
                        $receiver.executeQuery();
                        break;
                    }
                    default: {
                        $receiver.executeUpdate();
                    }
                }
                ResultSet resultSet = $receiver.getResultSet();
                if (resultSet != null) {
                    R r;
                    ResultSet resultSet2;
                    ResultSet it = resultSet2 = resultSet;
                    try {
                        r = this.$transform.invoke(it);
                    }
                    finally {
                        it.close();
                    }
                    t = (T)r;
                } else {
                    t = null;
                }
                return t;
            }

            @NotNull
            public String prepareSQL(@NotNull Transaction transaction) {
                Intrinsics.checkParameterIsNotNull(transaction, "transaction");
                return this.$stmt;
            }

            @NotNull
            public Iterable<Iterable<Pair<ColumnType, Object>>> arguments() {
                return CollectionsKt.emptyList();
            }
            {
                this.$type = $captured_local_variable$0;
                this.$transform = $captured_local_variable$1;
                this.$stmt = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        });
    }

    @Nullable
    public final <T> T exec(@NotNull Statement<? extends T> stmt) {
        Intrinsics.checkParameterIsNotNull(stmt, "stmt");
        return (T)this.exec(stmt, exec.3.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T, R> R exec(@NotNull Statement<? extends T> stmt, @NotNull Function2<? super Statement<? extends T>, ? super T, ? extends R> body) {
        R r;
        Map map2;
        Intrinsics.checkParameterIsNotNull(stmt, "stmt");
        Intrinsics.checkParameterIsNotNull(body, "body");
        int n = this.statementCount;
        this.statementCount = n + 1;
        long start = System.currentTimeMillis();
        Pair<T, List<StatementContext>> answer = stmt.executeIn$exposed(this);
        long delta = System.currentTimeMillis() - start;
        Lazy lazySQL2 = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<String>(this, answer){
            final /* synthetic */ Transaction this$0;
            final /* synthetic */ Pair $answer;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)this.$answer.getSecond();
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    StatementContext statementContext = (StatementContext)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    String string = it.sql(this.this$0);
                    collection.add(string);
                }
                return CollectionsKt.joinToString$default(CollectionsKt.distinct((List)var3_3), null, null, null, 0, null, null, 63, null);
            }
            {
                this.this$0 = transaction;
                this.$answer = pair;
                super(0);
            }
        });
        this.duration += delta;
        if (this.debug) {
            Object object;
            void $receiver$iv;
            this.statements.append(this.describeStatement(delta, (String)lazySQL2.getValue()));
            map2 = this.statementStats;
            Object key$iv = lazySQL2.getValue();
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                Pair<Integer, Long> answer$iv = TuplesKt.to(0, 0L);
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            map2 = object;
            Pair $count_time = (Pair)((Object)map2);
            int count2 = ((Number)$count_time.component1()).intValue();
            long time = ((Number)$count_time.component2()).longValue();
            Map map3 = this.statementStats;
            Object t = lazySQL2.getValue();
            Pair<Integer, Long> pair = TuplesKt.to(count2 + 1, time + delta);
            map3.put(t, pair);
        }
        Long l = this.warnLongQueriesDuration;
        if (delta > (l != null ? l : Long.MAX_VALUE)) {
            SQLLogKt.getExposedLogger().warn("Long query: " + this.describeStatement(delta, (String)lazySQL2.getValue()), new RuntimeException());
        }
        T t = answer.getFirst();
        if (t != null) {
            Map it = map2 = t;
            r = body.invoke((Statement<? extends T>)stmt, (T)it);
        } else {
            r = null;
        }
        return r;
    }

    @NotNull
    public final String quoteIfNecessary$exposed(@NotNull String identity) {
        Intrinsics.checkParameterIsNotNull(identity, "identity");
        if (StringsKt.contains$default((CharSequence)identity, '.', false, 2, null)) {
            return CollectionsKt.joinToString$default(StringsKt.split$default((CharSequence)identity, new char[]{'.'}, false, 0, 6, null), ".", null, null, 0, null, new Function1<String, String>(this){
                final /* synthetic */ Transaction this$0;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    return Transaction.access$quoteTokenIfNecessary(this.this$0, it);
                }
                {
                    this.this$0 = transaction;
                    super(1);
                }
            }, 30, null);
        }
        return this.quoteTokenIfNecessary(identity);
    }

    @NotNull
    public final String cutIfNecessary$exposed(@NotNull String identity) {
        Intrinsics.checkParameterIsNotNull(identity, "identity");
        String string = identity;
        int n = 0;
        int n2 = Math.min(DefaultKt.getCurrentDialect().getIdentifierLengthLimit(), identity.length());
        String string2 = string.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string2;
    }

    private final String quoteTokenIfNecessary(String token) {
        return this.getDb().needQuotes(token) ? this.getQuoted(token) : token;
    }

    @NotNull
    public final String identity(@NotNull Table table) {
        Object object;
        block5: {
            block4: {
                Alias alias;
                Intrinsics.checkParameterIsNotNull(table, "table");
                Table table2 = table;
                if (!(table2 instanceof Alias)) {
                    table2 = null;
                }
                if ((object = (Alias)table2) == null) break block4;
                Alias it = alias = object;
                object = "" + this.identity((Table)it.getDelegate()) + ' ' + this.quoteIfNecessary$exposed(it.getAlias());
                if (object != null) break block5;
            }
            object = this.quoteIfNecessary$exposed(DefaultKt.inProperCase(table.getTableName()));
        }
        return object;
    }

    @NotNull
    public final String fullIdentity(@NotNull Column<?> column) {
        Intrinsics.checkParameterIsNotNull(column, "column");
        return "" + this.quoteIfNecessary$exposed(DefaultKt.inProperCase(column.getTable().getTableName())) + '.' + this.identity(column);
    }

    @NotNull
    public final String identity(@NotNull Column<?> column) {
        Intrinsics.checkParameterIsNotNull(column, "column");
        String nameInProperCase = DefaultKt.inProperCase(column.getName());
        return this.getDb().getShouldQuoteIdentifiers() && Intrinsics.areEqual(nameInProperCase, column.getName()) ^ true ? this.getQuoted(column.getName()) : this.quoteIfNecessary$exposed(nameInProperCase);
    }

    public final void closeExecutedStatements() {
        Iterable $receiver$iv = this.executedStatements;
        for (Object element$iv : $receiver$iv) {
            PreparedStatement it = (PreparedStatement)element$iv;
            if (it.isClosed()) continue;
            it.close();
        }
        this.executedStatements.clear();
    }

    private final String getQuoted(@NotNull String $receiver) {
        String string;
        String string2 = string = "" + this.getDb().getIdentityQuoteString() + "" + $receiver + "" + this.getDb().getIdentityQuoteString();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    public Transaction(@NotNull TransactionInterface transactionImpl) {
        Intrinsics.checkParameterIsNotNull(transactionImpl, "transactionImpl");
        this.transactionImpl = transactionImpl;
        this.monitor = new StatementMonitor();
        this.logger = new CompositeSqlLogger();
        this.entityCache = new EntityCache();
        Transaction transaction = this;
        Cloneable cloneable2 = new ArrayList();
        transaction.executedStatements = cloneable2;
        this.statements = new StringBuilder();
        transaction = this;
        cloneable2 = new HashMap();
        transaction.statementStats = cloneable2;
        this.logger.addLogger(Slf4jSqlLogger.INSTANCE);
    }

    @Override
    @NotNull
    public Connection getConnection() {
        return this.transactionImpl.getConnection();
    }

    @Override
    @NotNull
    public Database getDb() {
        return this.transactionImpl.getDb();
    }

    @Override
    @Nullable
    public Transaction getOuterTransaction() {
        return this.transactionImpl.getOuterTransaction();
    }

    @Override
    public void close() {
        this.transactionImpl.close();
    }

    @Override
    public void rollback() {
        this.transactionImpl.rollback();
    }

    @NotNull
    public static final /* synthetic */ String access$quoteTokenIfNecessary(Transaction $this, @NotNull String token) {
        return $this.quoteTokenIfNecessary(token);
    }
}

