/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.Reader;
import java.sql.Clob;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/exposed/sql/StringColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "collate", "", "(Ljava/lang/String;)V", "charactersToEscape", "", "", "getCollate", "()Ljava/lang/String;", "nonNullValueToString", "value", "", "valueFromDB", "exposed"})
public abstract class StringColumnType
extends ColumnType {
    private final Map<Character, String> charactersToEscape;
    @Nullable
    private final String collate;

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        CharSequence $receiver$iv;
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull(value, "value");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append('\'');
        CharSequence charSequence = $receiver$iv = (CharSequence)value.toString();
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv = charSequence.charAt(i);
            char it = element$iv;
            Object object = this.charactersToEscape.get(Character.valueOf(it));
            if (object == null) {
                object = Character.valueOf(it);
            }
            $receiver.append(object);
        }
        $receiver.append('\'');
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        if (value instanceof Clob) {
            Reader reader = ((Clob)value).getCharacterStream();
            Intrinsics.checkExpressionValueIsNotNull(reader, "value.characterStream");
            return TextStreamsKt.readText(reader);
        }
        return value;
    }

    @Nullable
    public final String getCollate() {
        return this.collate;
    }

    public StringColumnType(@Nullable String collate) {
        super(false, 1, null);
        this.collate = collate;
        this.charactersToEscape = MapsKt.mapOf(TuplesKt.to(Character.valueOf('\''), "''"), TuplesKt.to(Character.valueOf('\r'), "\\r"), TuplesKt.to(Character.valueOf('\n'), "\\n"));
    }

    public /* synthetic */ StringColumnType(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public StringColumnType() {
        this(null, 1, null);
    }
}

