/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.EntityCache;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Seq;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tJ)\u0010\n\u001a\u00020\u000b\"\b\b\u0000\u0010\f*\u00020\b2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\f0\u0007\"\u0002H\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J-\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\u00072\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0018\u001a\u00020\u0005J%\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\u001a\u001a\u00020\u000b2\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u001b\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f*\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\f0\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/exposed/sql/SchemaUtils;", "", "()V", "addMissingColumnsStatements", "", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/List;", "create", "", "T", "([Lorg/jetbrains/exposed/sql/Table;)V", "createFKey", "reference", "Lorg/jetbrains/exposed/sql/Column;", "createIndex", "columns", "isUnique", "", "([Lorg/jetbrains/exposed/sql/Column;Z)Ljava/util/List;", "createMissingTablesAndColumns", "createSequence", "name", "createStatements", "drop", "withDataBaseLock", "Lorg/jetbrains/exposed/sql/Transaction;", "body", "Lkotlin/Function0;", "exposed"})
public final class SchemaUtils {
    public static final SchemaUtils INSTANCE;

    @NotNull
    public final List<String> createStatements(Table ... tables) {
        Intrinsics.checkParameterIsNotNull(tables, "tables");
        ArrayList statements = new ArrayList();
        Object[] objectArray = tables;
        if (objectArray.length == 0) {
            return statements;
        }
        ArrayList<Table> newTables = new ArrayList<Table>();
        Iterator<Table> iterator2 = EntityCache.Companion.sortTablesByReferences((Iterable<? extends Table>)ArraysKt.toList((Object[])tables)).iterator();
        while (iterator2.hasNext()) {
            Table table;
            Table table2 = table = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(table2, "table");
            if (QueriesKt.exists(table2)) continue;
            newTables.add(table);
            statements.addAll(table.getDdl());
            for (Pair<Column<?>[], Boolean> pair : table.getIndices()) {
                Column<?>[] columns2 = pair.component1();
                boolean isUnique = pair.component2();
                statements.addAll(this.createIndex(columns2, isUnique));
            }
        }
        return statements;
    }

    @NotNull
    public final List<String> createSequence(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new Seq(name).createStatement();
    }

    @NotNull
    public final List<String> createFKey(@NotNull Column<?> reference) {
        Intrinsics.checkParameterIsNotNull(reference, "reference");
        return ForeignKeyConstraint.Companion.from(reference).createStatement();
    }

    @NotNull
    public final List<String> createIndex(@NotNull Column<?>[] columns2, boolean isUnique) {
        Intrinsics.checkParameterIsNotNull(columns2, "columns");
        Column<?>[] columnArray = Arrays.copyOf(columns2, columns2.length);
        boolean bl = isUnique;
        return Index.Companion.forColumns(columnArray, bl).createStatement();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> addMissingColumnsStatements(Table ... tables) {
        Transaction transaction;
        Transaction $receiver = transaction = TransactionManager.Companion.current();
        ArrayList statements = new ArrayList();
        Object[] objectArray = tables;
        if (objectArray.length == 0) {
            return statements;
        }
        String message$iv = "Extracting table columns";
        long start$iv = System.currentTimeMillis();
        Map<Table, List<ColumnMetadata>> answer$iv = DefaultKt.getCurrentDialect().tableColumns(Arrays.copyOf(tables, tables.length));
        SQLLogKt.getExposedLogger().info(message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
        Map<Table, List<ColumnMetadata>> existingTableColumns = answer$iv;
        for (Table table : tables) {
            void $receiver$iv$iv;
            Column[] columns2;
            Iterator<Object> $receiver$iv$iv2;
            List<ColumnMetadata> list = existingTableColumns.get(table);
            List<ColumnMetadata> list2 = list;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List<ColumnMetadata> thisTableExistingColumns = list2;
            Object $receiver$iv = table.getColumns();
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator2 = $receiver$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                boolean bl;
                Object element$iv$iv;
                block20: {
                    element$iv$iv = iterator2.next();
                    Column c = (Column)element$iv$iv;
                    Iterable $receiver$iv2 = thisTableExistingColumns;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv2) {
                            ColumnMetadata it = (ColumnMetadata)element$iv;
                            if (!StringsKt.equals(it.getName(), c.getName(), true)) continue;
                            bl = true;
                            break block20;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List missingTableColumns = (List)destination$iv$iv;
            $receiver$iv = missingTableColumns;
            $receiver$iv$iv2 = $receiver$iv.iterator();
            while ($receiver$iv$iv2.hasNext()) {
                Object element$iv = $receiver$iv$iv2.next();
                Column it = (Column)element$iv;
                Iterable list$iv = it.getDdl();
                CollectionsKt.addAll((Collection)statements, list$iv);
            }
            if (!$receiver.getDb().getSupportsAlterTableWithAddColumn()) continue;
            $receiver$iv$iv2 = table.getIndices().iterator();
            while ($receiver$iv$iv2.hasNext()) {
                boolean bl;
                boolean isUnique;
                block21: {
                    $receiver$iv = (Pair)$receiver$iv$iv2.next();
                    columns2 = (Column[])((Pair)$receiver$iv).component1();
                    isUnique = (Boolean)((Pair)$receiver$iv).component2();
                    for (Object element$iv : (Object[])columns2) {
                        Column it = (Column)element$iv;
                        if (!missingTableColumns.contains(it)) continue;
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
                if (!bl) continue;
                statements.addAll(INSTANCE.createIndex(columns2, isUnique));
            }
            Object $receiver$iv3 = (Column[])table.getColumns();
            columns2 = $receiver$iv3;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                boolean bl;
                block22: {
                    Column c = (Column)element$iv$iv;
                    Iterable $receiver$iv4 = thisTableExistingColumns;
                    if ($receiver$iv4 instanceof Collection && ((Collection)$receiver$iv4).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv4) {
                            ColumnMetadata it = (ColumnMetadata)element$iv;
                            if (!(StringsKt.equals(c.getName(), it.getName(), true) && it.getNullable() != c.getColumnType().getNullable())) continue;
                            bl = true;
                            break block22;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List incorrectNullabilityColumns = (List)destination$iv$iv2;
            $receiver$iv3 = incorrectNullabilityColumns;
            Iterator iterator3 = $receiver$iv3.iterator();
            while (iterator3.hasNext()) {
                Object element$iv = iterator3.next();
                Column it = (Column)element$iv;
                Iterable list$iv = it.modifyStatement();
                CollectionsKt.addAll((Collection)statements, list$iv);
            }
        }
        if ($receiver.getDb().getSupportsAlterTableWithAddColumn()) {
            String message$iv2 = "Extracting column constraints";
            long start$iv2 = System.currentTimeMillis();
            Map<Pair<String, String>, List<ForeignKeyConstraint>> answer$iv2 = $receiver.getDb().getDialect$exposed().columnConstraints(Arrays.copyOf(tables, tables.length));
            SQLLogKt.getExposedLogger().info(message$iv2 + " took " + (System.currentTimeMillis() - start$iv2) + "ms");
            Map<Pair<String, String>, List<ForeignKeyConstraint>> existingColumnConstraint = answer$iv2;
            for (Table table : tables) {
                for (Column<?> column : table.getColumns()) {
                    ForeignKeyConstraint existingConstraint;
                    if (column.getReferee() == null) continue;
                    List<ForeignKeyConstraint> list = existingColumnConstraint.get(TuplesKt.to(DefaultKt.inProperCase(table.getTableName()), DefaultKt.inProperCase(column.getName())));
                    ForeignKeyConstraint foreignKeyConstraint = existingConstraint = list != null ? CollectionsKt.firstOrNull(list) : null;
                    if (existingConstraint == null) {
                        statements.addAll(INSTANCE.createFKey(column));
                        continue;
                    }
                    String string = existingConstraint.getReferencedTable();
                    Column<?> column2 = column.getReferee();
                    if (column2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!(Intrinsics.areEqual(string, DefaultKt.inProperCase(column2.getTable().getTableName())) ^ true) && !(Intrinsics.areEqual((Object)column.getOnDelete$exposed(), (Object)existingConstraint.getDeleteRule()) ^ true)) continue;
                    statements.addAll(existingConstraint.dropStatement());
                    statements.addAll(INSTANCE.createFKey(column));
                }
            }
        }
        return statements;
    }

    public final <T extends Table> void create(T ... tables) {
        Transaction transaction;
        Intrinsics.checkParameterIsNotNull(tables, "tables");
        Transaction $receiver = transaction = TransactionManager.Companion.current();
        List<String> statements = INSTANCE.createStatements((Table[])Arrays.copyOf(tables, tables.length));
        for (String statement : statements) {
            $receiver.exec(statement);
        }
        $receiver.commit();
        DefaultKt.getCurrentDialect().resetCaches();
    }

    public final void createMissingTablesAndColumns(Table ... tables) {
        Iterable $receiver$iv;
        Transaction transaction;
        Intrinsics.checkParameterIsNotNull(tables, "tables");
        Transaction $receiver = transaction = TransactionManager.Companion.current();
        $receiver.getDb().getDialect$exposed().resetCaches();
        String message$iv = "Preparing create tables statements";
        long start$iv = System.currentTimeMillis();
        Object answer$iv = INSTANCE.createStatements(Arrays.copyOf(tables, tables.length));
        SQLLogKt.getExposedLogger().info(message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
        List<String> createStatements = answer$iv;
        message$iv = "Executing create tables statements";
        start$iv = System.currentTimeMillis();
        for (String statement2 : createStatements) {
            $receiver.exec(statement2);
        }
        $receiver.commit();
        answer$iv = Unit.INSTANCE;
        SQLLogKt.getExposedLogger().info(message$iv + " took " + (System.currentTimeMillis() - start$iv) + "ms");
        String message$iv2 = "Preparing alter table statements";
        long start$iv2 = System.currentTimeMillis();
        List<String> answer$iv2 = INSTANCE.addMissingColumnsStatements(Arrays.copyOf(tables, tables.length));
        SQLLogKt.getExposedLogger().info(message$iv2 + " took " + (System.currentTimeMillis() - start$iv2) + "ms");
        List<String> alterStatements = answer$iv2;
        String message$iv3 = "Executing alter table statements";
        long start$iv3 = System.currentTimeMillis();
        for (String string : alterStatements) {
            $receiver.exec(string);
        }
        $receiver.commit();
        Unit answer$iv3 = Unit.INSTANCE;
        SQLLogKt.getExposedLogger().info(message$iv3 + " took " + (System.currentTimeMillis() - start$iv3) + "ms");
        message$iv3 = "Checking mapping consistence";
        start$iv3 = System.currentTimeMillis();
        Iterable iterable = $receiver$iv = (Iterable)QueriesKt.checkMappingConsistence(Arrays.copyOf(tables, tables.length));
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : iterable) {
            String it = (String)element$iv$iv;
            if (!(!StringsKt.contains$default((CharSequence)$receiver.getStatements(), it, false, 2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String statement4 : (List)destination$iv$iv) {
            $receiver.exec(statement4);
        }
        $receiver.commit();
        answer$iv3 = Unit.INSTANCE;
        SQLLogKt.getExposedLogger().info(message$iv3 + " took " + (System.currentTimeMillis() - start$iv3) + "ms");
        $receiver.getDb().getDialect$exposed().resetCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void withDataBaseLock(@NotNull Transaction $receiver, @NotNull Function0<? extends T> body) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(body, "body");
        Table buzyTable2 = new Table("busy"){
            @NotNull
            private final Column<Boolean> busy;

            @NotNull
            public final Column<Boolean> getBusy() {
                return this.busy;
            }
            {
                this.busy = this.uniqueIndex(this.bool("busy"));
            }
        };
        this.create(new withDataBaseLock.buzyTable.1[]{buzyTable2});
        boolean isBusy = CollectionsKt.any(QueriesKt.selectAll(buzyTable2).forUpdate());
        if (!isBusy) {
            QueriesKt.insert((Table)buzyTable2, (Function2)new Function2<withDataBaseLock.buzyTable.1, InsertStatement<Number>, Unit>(buzyTable2){
                final /* synthetic */ withDataBaseLock.buzyTable.1 $buzyTable;

                public final void invoke(@NotNull withDataBaseLock.buzyTable.1 $receiver, @NotNull InsertStatement<Number> it) {
                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    it.set(this.$buzyTable.getBusy(), true);
                }
                {
                    this.$buzyTable = var1_1;
                    super(2);
                }
            });
            try {
                body.invoke();
            }
            finally {
                QueriesKt.deleteAll(buzyTable2);
                $receiver.getConnection().commit();
            }
        }
    }

    public final void drop(Table ... tables) {
        Table it;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(tables, "tables");
        Iterable $receiver$iv = CollectionsKt.reversed((Iterable)EntityCache.Companion.sortTablesByReferences((Iterable<? extends Table>)ArraysKt.toList((Object[])tables)));
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Table)element$iv$iv;
            if (!ArraysKt.contains((Object[])tables, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tablesForDeletion = (List)destination$iv$iv;
        if (!DefaultKt.getCurrentDialect().getSupportsIfNotExists()) {
            $receiver$iv$iv = $receiver$iv = (Iterable)tablesForDeletion;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (Table)element$iv$iv;
                if (!QueriesKt.exists(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tablesForDeletion = (List)destination$iv$iv;
        }
        $receiver$iv = tablesForDeletion;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Table)element$iv$iv;
            Iterable list$iv$iv = it.dropStatement();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            String it2 = (String)element$iv;
            TransactionManager.Companion.current().exec(it2);
        }
        DefaultKt.getCurrentDialect().resetCaches();
    }

    private SchemaUtils() {
    }

    static {
        SchemaUtils schemaUtils;
        INSTANCE = schemaUtils = new SchemaUtils();
    }
}

